/*
 * Copyright (c) 1997 Robert Nordier
 * All rights reserved.
 *
 * $Id: getopt.c,v 1.1 1997/01/20 22:58:00 rnordier Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR(S) ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR(S) BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
 * IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <string.h>
#include <stdio.h>
#include "dosbsd.h"

#define SWITCHAR  '-'

extern char *__progname;

int opterr = 1;
int optind = 1;
int optopt = 0;
char *optarg = NULL;

static int erropt(const char *msg, int c);

int
getopt(int argc, char *const * argv, const char *opts)
{
    static char *p = NULL;
    char *q;
    int c;

    if (!p) {
	if (optind >= argc)
	    return -1;
	p = argv[optind];
	if (*p++ != SWITCHAR || !*p)
	    return -1;
	if (*p == SWITCHAR && !p[1]) {
	    optind++;
	    return -1;
	}
    }
    c = *p++;
    if ((q = strchr(opts, c)) == NULL || c == ':')
	c = erropt("illegal option", c);
    else if (*++q == ':')
	if (!*p)
	    if (optind == argc - 1)
		c = erropt("option requires an argument", c);
	    else
		optarg = argv[++optind];
	else
	    optarg = p;
    else
	optarg = NULL;
    if (q && *q == ':' || !*p) {
	optind++;
	p = NULL;
    }
    return c;
}

static int
erropt(const char *msg, int c)
{
    fprintf(stderr, "%s: %s -- %c\n", __progname, msg, c);
    return '?';
}
