/*	$OpenBSD: qwxreg.h,v 1.8 2024/09/01 03:08:56 jsg Exp $	*/

/*
 * Copyright (c) 2021-2022, Qualcomm Innovation Center, Inc.
 * Copyright (c) 2018-2021 The Linux Foundation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted (subject to the limitations in the disclaimer
 * below) provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  * Neither the name of [Owner Organization] nor the names of its
 *    contributors may be used to endorse or promote products derived from
 *    this software without specific prior written permission.
 *
 * NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY
 * THIS LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * core.h
 */

#define ATH11K_TX_MGMT_NUM_PENDING_MAX	512

#define ATH11K_TX_MGMT_TARGET_MAX_SUPPORT_WMI 64

/* Pending management packets threshold for dropping probe responses */
#define ATH11K_PRB_RSP_DROP_THRESHOLD ((ATH11K_TX_MGMT_TARGET_MAX_SUPPORT_WMI * 3) / 4)

#define ATH11K_INVALID_HW_MAC_ID	0xFF
#define ATH11K_CONNECTION_LOSS_HZ	(3 * HZ)

enum ath11k_hw_rev {
	ATH11K_HW_IPQ8074,
	ATH11K_HW_QCA6390_HW20,
	ATH11K_HW_IPQ6018_HW10,
	ATH11K_HW_QCN9074_HW10,
	ATH11K_HW_WCN6855_HW20,
	ATH11K_HW_WCN6855_HW21,
	ATH11K_HW_WCN6750_HW10,
};

enum ath11k_firmware_mode {
	/* the default mode, standard 802.11 functionality */
	ATH11K_FIRMWARE_MODE_NORMAL,

	/* factory tests etc */
	ATH11K_FIRMWARE_MODE_FTM,

	/* Cold boot calibration */
	ATH11K_FIRMWARE_MODE_COLD_BOOT = 7,
};

enum ath11k_crypt_mode {
	/* Only use hardware crypto engine */
	ATH11K_CRYPT_MODE_HW,
	/* Only use software crypto */
	ATH11K_CRYPT_MODE_SW,
};

/* IPQ8074 HW channel counters frequency value in hertz */
#define IPQ8074_CC_FREQ_HERTZ 320000

#define ATH11K_MIN_5G_FREQ 4150
#define ATH11K_MIN_6G_FREQ 5925
#define ATH11K_MAX_6G_FREQ 7115
#define ATH11K_NUM_CHANS 102
#define ATH11K_MAX_5G_CHAN 177

/* Antenna noise floor */
#define ATH11K_DEFAULT_NOISE_FLOOR -95

/*
 * wmi.h
 */

#define PSOC_HOST_MAX_NUM_SS (8)

/* defines to set Packet extension values which can be 0 us, 8 usec or 16 usec */
#define MAX_HE_NSS               8
#define MAX_HE_MODULATION        8
#define MAX_HE_RU                4
#define HE_MODULATION_NONE       7
#define HE_PET_0_USEC            0
#define HE_PET_8_USEC            1
#define HE_PET_16_USEC           2

#define WMI_MAX_CHAINS		 8

#define WMI_MAX_NUM_SS                    MAX_HE_NSS
#define WMI_MAX_NUM_RU                    MAX_HE_RU

#define WMI_TLV_CMD(grp_id) (((grp_id) << 12) | 0x1)
#define WMI_TLV_EV(grp_id) (((grp_id) << 12) | 0x1)
#define WMI_TLV_CMD_UNSUPPORTED 0
#define WMI_TLV_PDEV_PARAM_UNSUPPORTED 0
#define WMI_TLV_VDEV_PARAM_UNSUPPORTED 0

struct wmi_cmd_hdr {
	uint32_t cmd_id;
} __packed;

struct wmi_tlv {
	uint32_t header;
	uint8_t value[];
} __packed;

#define WMI_TLV_LEN	GENMASK(15, 0)
#define WMI_TLV_TAG	GENMASK(31, 16)
#define TLV_HDR_SIZE	sizeof(uint32_t) /* wmi_tlv.header */

#define WMI_CMD_HDR_CMD_ID      GENMASK(23, 0)
#define WMI_MAX_MEM_REQS        32
#define ATH11K_MAX_HW_LISTEN_INTERVAL 5

#define WLAN_SCAN_MAX_HINT_S_SSID        10
#define WLAN_SCAN_MAX_HINT_BSSID         10
#define MAX_RNR_BSS                    5

#define WLAN_SCAN_MAX_HINT_S_SSID        10
#define WLAN_SCAN_MAX_HINT_BSSID         10
#define MAX_RNR_BSS                    5

#define WLAN_SCAN_PARAMS_MAX_SSID    16
#define WLAN_SCAN_PARAMS_MAX_BSSID   4
#define WLAN_SCAN_PARAMS_MAX_IE_LEN  256

#define WMI_APPEND_TO_EXISTING_CHAN_LIST_FLAG 1

#define MAX_WMI_UTF_LEN 252
#define WMI_BA_MODE_BUFFER_SIZE_256  3

/*
 * HW mode config type replicated from FW header
 * @WMI_HOST_HW_MODE_SINGLE: Only one PHY is active.
 * @WMI_HOST_HW_MODE_DBS: Both PHYs are active in different bands,
 *                        one in 2G and another in 5G.
 * @WMI_HOST_HW_MODE_SBS_PASSIVE: Both PHYs are in passive mode (only rx) in
 *                        same band; no tx allowed.
 * @WMI_HOST_HW_MODE_SBS: Both PHYs are active in the same band.
 *                        Support for both PHYs within one band is planned
 *                        for 5G only(as indicated in WMI_MAC_PHY_CAPABILITIES),
 *                        but could be extended to other bands in the future.
 *                        The separation of the band between the two PHYs needs
 *                        to be communicated separately.
 * @WMI_HOST_HW_MODE_DBS_SBS: 3 PHYs, with 2 on the same band doing SBS
 *                           as in WMI_HW_MODE_SBS, and 3rd on the other band
 * @WMI_HOST_HW_MODE_DBS_OR_SBS: Two PHY with one PHY capable of both 2G and
 *                        5G. It can support SBS (5G + 5G) OR DBS (5G + 2G).
 * @WMI_HOST_HW_MODE_MAX: Max hw_mode_id. Used to indicate invalid mode.
 */
enum wmi_host_hw_mode_config_type {
	WMI_HOST_HW_MODE_SINGLE       = 0,
	WMI_HOST_HW_MODE_DBS          = 1,
	WMI_HOST_HW_MODE_SBS_PASSIVE  = 2,
	WMI_HOST_HW_MODE_SBS          = 3,
	WMI_HOST_HW_MODE_DBS_SBS      = 4,
	WMI_HOST_HW_MODE_DBS_OR_SBS   = 5,

	/* keep last */
	WMI_HOST_HW_MODE_MAX
};

/* HW mode priority values used to detect the preferred HW mode
 * on the available modes.
 */
enum wmi_host_hw_mode_priority {
	WMI_HOST_HW_MODE_DBS_SBS_PRI,
	WMI_HOST_HW_MODE_DBS_PRI,
	WMI_HOST_HW_MODE_DBS_OR_SBS_PRI,
	WMI_HOST_HW_MODE_SBS_PRI,
	WMI_HOST_HW_MODE_SBS_PASSIVE_PRI,
	WMI_HOST_HW_MODE_SINGLE_PRI,

	/* keep last the lowest priority */
	WMI_HOST_HW_MODE_MAX_PRI
};

enum WMI_HOST_WLAN_BAND {
	WMI_HOST_WLAN_2G_CAP	= 0x1,
	WMI_HOST_WLAN_5G_CAP	= 0x2,
	WMI_HOST_WLAN_2G_5G_CAP	= WMI_HOST_WLAN_2G_CAP | WMI_HOST_WLAN_5G_CAP,
};

/* Parameters used for WMI_VDEV_PARAM_AUTORATE_MISC_CFG command.
 * Used only for HE auto rate mode.
 */
enum {
	/* HE LTF related configuration */
	WMI_HE_AUTORATE_LTF_1X = BIT(0),
	WMI_HE_AUTORATE_LTF_2X = BIT(1),
	WMI_HE_AUTORATE_LTF_4X = BIT(2),

	/* HE GI related configuration */
	WMI_AUTORATE_400NS_GI = BIT(8),
	WMI_AUTORATE_800NS_GI = BIT(9),
	WMI_AUTORATE_1600NS_GI = BIT(10),
	WMI_AUTORATE_3200NS_GI = BIT(11),
};

enum {
	WMI_HOST_VDEV_FLAGS_NON_MBSSID_AP       = 0x00000001,
	WMI_HOST_VDEV_FLAGS_TRANSMIT_AP         = 0x00000002,
	WMI_HOST_VDEV_FLAGS_NON_TRANSMIT_AP     = 0x00000004,
	WMI_HOST_VDEV_FLAGS_EMA_MODE            = 0x00000008,
	WMI_HOST_VDEV_FLAGS_SCAN_MODE_VAP       = 0x00000010,
};

/*
 * wmi command groups.
 */
enum wmi_cmd_group {
	/* 0 to 2 are reserved */
	WMI_GRP_START = 0x3,
	WMI_GRP_SCAN = WMI_GRP_START,
	WMI_GRP_PDEV		= 0x4,
	WMI_GRP_VDEV           = 0x5,
	WMI_GRP_PEER           = 0x6,
	WMI_GRP_MGMT           = 0x7,
	WMI_GRP_BA_NEG         = 0x8,
	WMI_GRP_STA_PS         = 0x9,
	WMI_GRP_DFS            = 0xa,
	WMI_GRP_ROAM           = 0xb,
	WMI_GRP_OFL_SCAN       = 0xc,
	WMI_GRP_P2P            = 0xd,
	WMI_GRP_AP_PS          = 0xe,
	WMI_GRP_RATE_CTRL      = 0xf,
	WMI_GRP_PROFILE        = 0x10,
	WMI_GRP_SUSPEND        = 0x11,
	WMI_GRP_BCN_FILTER     = 0x12,
	WMI_GRP_WOW            = 0x13,
	WMI_GRP_RTT            = 0x14,
	WMI_GRP_SPECTRAL       = 0x15,
	WMI_GRP_STATS          = 0x16,
	WMI_GRP_ARP_NS_OFL     = 0x17,
	WMI_GRP_NLO_OFL        = 0x18,
	WMI_GRP_GTK_OFL        = 0x19,
	WMI_GRP_CSA_OFL        = 0x1a,
	WMI_GRP_CHATTER        = 0x1b,
	WMI_GRP_TID_ADDBA      = 0x1c,
	WMI_GRP_MISC           = 0x1d,
	WMI_GRP_GPIO           = 0x1e,
	WMI_GRP_FWTEST         = 0x1f,
	WMI_GRP_TDLS           = 0x20,
	WMI_GRP_RESMGR         = 0x21,
	WMI_GRP_STA_SMPS       = 0x22,
	WMI_GRP_WLAN_HB        = 0x23,
	WMI_GRP_RMC            = 0x24,
	WMI_GRP_MHF_OFL        = 0x25,
	WMI_GRP_LOCATION_SCAN  = 0x26,
	WMI_GRP_OEM            = 0x27,
	WMI_GRP_NAN            = 0x28,
	WMI_GRP_COEX           = 0x29,
	WMI_GRP_OBSS_OFL       = 0x2a,
	WMI_GRP_LPI            = 0x2b,
	WMI_GRP_EXTSCAN        = 0x2c,
	WMI_GRP_DHCP_OFL       = 0x2d,
	WMI_GRP_IPA            = 0x2e,
	WMI_GRP_MDNS_OFL       = 0x2f,
	WMI_GRP_SAP_OFL        = 0x30,
	WMI_GRP_OCB            = 0x31,
	WMI_GRP_SOC            = 0x32,
	WMI_GRP_PKT_FILTER     = 0x33,
	WMI_GRP_MAWC           = 0x34,
	WMI_GRP_PMF_OFFLOAD    = 0x35,
	WMI_GRP_BPF_OFFLOAD    = 0x36,
	WMI_GRP_NAN_DATA       = 0x37,
	WMI_GRP_PROTOTYPE      = 0x38,
	WMI_GRP_MONITOR        = 0x39,
	WMI_GRP_REGULATORY     = 0x3a,
	WMI_GRP_HW_DATA_FILTER = 0x3b,
	WMI_GRP_WLM            = 0x3c,
	WMI_GRP_11K_OFFLOAD    = 0x3d,
	WMI_GRP_TWT            = 0x3e,
	WMI_GRP_MOTION_DET     = 0x3f,
	WMI_GRP_SPATIAL_REUSE  = 0x40,
};


#define WMI_CMD_GRP(grp_id) (((grp_id) << 12) | 0x1)
#define WMI_EVT_GRP_START_ID(grp_id) (((grp_id) << 12) | 0x1)

#define WMI_CMD_UNSUPPORTED 0

enum wmi_tlv_cmd_id {
	WMI_INIT_CMDID = 0x1,
	WMI_START_SCAN_CMDID = WMI_TLV_CMD(WMI_GRP_SCAN),
	WMI_STOP_SCAN_CMDID,
	WMI_SCAN_CHAN_LIST_CMDID,
	WMI_SCAN_SCH_PRIO_TBL_CMDID,
	WMI_SCAN_UPDATE_REQUEST_CMDID,
	WMI_SCAN_PROB_REQ_OUI_CMDID,
	WMI_SCAN_ADAPTIVE_DWELL_CONFIG_CMDID,
	WMI_PDEV_SET_REGDOMAIN_CMDID = WMI_TLV_CMD(WMI_GRP_PDEV),
	WMI_PDEV_SET_CHANNEL_CMDID,
	WMI_PDEV_SET_PARAM_CMDID,
	WMI_PDEV_PKTLOG_ENABLE_CMDID,
	WMI_PDEV_PKTLOG_DISABLE_CMDID,
	WMI_PDEV_SET_WMM_PARAMS_CMDID,
	WMI_PDEV_SET_HT_CAP_IE_CMDID,
	WMI_PDEV_SET_VHT_CAP_IE_CMDID,
	WMI_PDEV_SET_DSCP_TID_MAP_CMDID,
	WMI_PDEV_SET_QUIET_MODE_CMDID,
	WMI_PDEV_GREEN_AP_PS_ENABLE_CMDID,
	WMI_PDEV_GET_TPC_CONFIG_CMDID,
	WMI_PDEV_SET_BASE_MACADDR_CMDID,
	WMI_PDEV_DUMP_CMDID,
	WMI_PDEV_SET_LED_CONFIG_CMDID,
	WMI_PDEV_GET_TEMPERATURE_CMDID,
	WMI_PDEV_SET_LED_FLASHING_CMDID,
	WMI_PDEV_SMART_ANT_ENABLE_CMDID,
	WMI_PDEV_SMART_ANT_SET_RX_ANTENNA_CMDID,
	WMI_PDEV_SET_ANTENNA_SWITCH_TABLE_CMDID,
	WMI_PDEV_SET_CTL_TABLE_CMDID,
	WMI_PDEV_SET_MIMOGAIN_TABLE_CMDID,
	WMI_PDEV_FIPS_CMDID,
	WMI_PDEV_GET_ANI_CCK_CONFIG_CMDID,
	WMI_PDEV_GET_ANI_OFDM_CONFIG_CMDID,
	WMI_PDEV_GET_NFCAL_POWER_CMDID,
	WMI_PDEV_GET_TPC_CMDID,
	WMI_MIB_STATS_ENABLE_CMDID,
	WMI_PDEV_SET_PCL_CMDID,
	WMI_PDEV_SET_HW_MODE_CMDID,
	WMI_PDEV_SET_MAC_CONFIG_CMDID,
	WMI_PDEV_SET_ANTENNA_MODE_CMDID,
	WMI_SET_PERIODIC_CHANNEL_STATS_CONFIG_CMDID,
	WMI_PDEV_WAL_POWER_DEBUG_CMDID,
	WMI_PDEV_SET_REORDER_TIMEOUT_VAL_CMDID,
	WMI_PDEV_SET_WAKEUP_CONFIG_CMDID,
	WMI_PDEV_GET_ANTDIV_STATUS_CMDID,
	WMI_PDEV_GET_CHIP_POWER_STATS_CMDID,
	WMI_PDEV_SET_STATS_THRESHOLD_CMDID,
	WMI_PDEV_MULTIPLE_VDEV_RESTART_REQUEST_CMDID,
	WMI_PDEV_UPDATE_PKT_ROUTING_CMDID,
	WMI_PDEV_CHECK_CAL_VERSION_CMDID,
	WMI_PDEV_SET_DIVERSITY_GAIN_CMDID,
	WMI_PDEV_DIV_GET_RSSI_ANTID_CMDID,
	WMI_PDEV_BSS_CHAN_INFO_REQUEST_CMDID,
	WMI_PDEV_UPDATE_PMK_CACHE_CMDID,
	WMI_PDEV_UPDATE_FILS_HLP_PKT_CMDID,
	WMI_PDEV_UPDATE_CTLTABLE_REQUEST_CMDID,
	WMI_PDEV_CONFIG_VENDOR_OUI_ACTION_CMDID,
	WMI_PDEV_SET_AC_TX_QUEUE_OPTIMIZED_CMDID,
	WMI_PDEV_SET_RX_FILTER_PROMISCUOUS_CMDID,
	WMI_PDEV_DMA_RING_CFG_REQ_CMDID,
	WMI_PDEV_HE_TB_ACTION_FRM_CMDID,
	WMI_PDEV_PKTLOG_FILTER_CMDID,
	WMI_PDEV_SET_RAP_CONFIG_CMDID,
	WMI_PDEV_DSM_FILTER_CMDID,
	WMI_PDEV_FRAME_INJECT_CMDID,
	WMI_PDEV_TBTT_OFFSET_SYNC_CMDID,
	WMI_PDEV_SET_SRG_BSS_COLOR_BITMAP_CMDID,
	WMI_PDEV_SET_SRG_PARTIAL_BSSID_BITMAP_CMDID,
	WMI_PDEV_SET_SRG_OBSS_COLOR_ENABLE_BITMAP_CMDID,
	WMI_PDEV_SET_SRG_OBSS_BSSID_ENABLE_BITMAP_CMDID,
	WMI_PDEV_SET_NON_SRG_OBSS_COLOR_ENABLE_BITMAP_CMDID,
	WMI_PDEV_SET_NON_SRG_OBSS_BSSID_ENABLE_BITMAP_CMDID,
	WMI_PDEV_GET_TPC_STATS_CMDID,
	WMI_PDEV_ENABLE_DURATION_BASED_TX_MODE_SELECTION_CMDID,
	WMI_PDEV_GET_DPD_STATUS_CMDID,
	WMI_PDEV_SET_BIOS_SAR_TABLE_CMDID,
	WMI_PDEV_SET_BIOS_GEO_TABLE_CMDID,
	WMI_VDEV_CREATE_CMDID = WMI_TLV_CMD(WMI_GRP_VDEV),
	WMI_VDEV_DELETE_CMDID,
	WMI_VDEV_START_REQUEST_CMDID,
	WMI_VDEV_RESTART_REQUEST_CMDID,
	WMI_VDEV_UP_CMDID,
	WMI_VDEV_STOP_CMDID,
	WMI_VDEV_DOWN_CMDID,
	WMI_VDEV_SET_PARAM_CMDID,
	WMI_VDEV_INSTALL_KEY_CMDID,
	WMI_VDEV_WNM_SLEEPMODE_CMDID,
	WMI_VDEV_WMM_ADDTS_CMDID,
	WMI_VDEV_WMM_DELTS_CMDID,
	WMI_VDEV_SET_WMM_PARAMS_CMDID,
	WMI_VDEV_SET_GTX_PARAMS_CMDID,
	WMI_VDEV_IPSEC_NATKEEPALIVE_FILTER_CMDID,
	WMI_VDEV_PLMREQ_START_CMDID,
	WMI_VDEV_PLMREQ_STOP_CMDID,
	WMI_VDEV_TSF_TSTAMP_ACTION_CMDID,
	WMI_VDEV_SET_IE_CMDID,
	WMI_VDEV_RATEMASK_CMDID,
	WMI_VDEV_ATF_REQUEST_CMDID,
	WMI_VDEV_SET_DSCP_TID_MAP_CMDID,
	WMI_VDEV_FILTER_NEIGHBOR_RX_PACKETS_CMDID,
	WMI_VDEV_SET_QUIET_MODE_CMDID,
	WMI_VDEV_SET_CUSTOM_AGGR_SIZE_CMDID,
	WMI_VDEV_ENCRYPT_DECRYPT_DATA_REQ_CMDID,
	WMI_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_CMDID,
	WMI_PEER_CREATE_CMDID = WMI_TLV_CMD(WMI_GRP_PEER),
	WMI_PEER_DELETE_CMDID,
	WMI_PEER_FLUSH_TIDS_CMDID,
	WMI_PEER_SET_PARAM_CMDID,
	WMI_PEER_ASSOC_CMDID,
	WMI_PEER_ADD_WDS_ENTRY_CMDID,
	WMI_PEER_REMOVE_WDS_ENTRY_CMDID,
	WMI_PEER_MCAST_GROUP_CMDID,
	WMI_PEER_INFO_REQ_CMDID,
	WMI_PEER_GET_ESTIMATED_LINKSPEED_CMDID,
	WMI_PEER_SET_RATE_REPORT_CONDITION_CMDID,
	WMI_PEER_UPDATE_WDS_ENTRY_CMDID,
	WMI_PEER_ADD_PROXY_STA_ENTRY_CMDID,
	WMI_PEER_SMART_ANT_SET_TX_ANTENNA_CMDID,
	WMI_PEER_SMART_ANT_SET_TRAIN_INFO_CMDID,
	WMI_PEER_SMART_ANT_SET_NODE_CONFIG_OPS_CMDID,
	WMI_PEER_ATF_REQUEST_CMDID,
	WMI_PEER_BWF_REQUEST_CMDID,
	WMI_PEER_REORDER_QUEUE_SETUP_CMDID,
	WMI_PEER_REORDER_QUEUE_REMOVE_CMDID,
	WMI_PEER_SET_RX_BLOCKSIZE_CMDID,
	WMI_PEER_ANTDIV_INFO_REQ_CMDID,
	WMI_BCN_TX_CMDID = WMI_TLV_CMD(WMI_GRP_MGMT),
	WMI_PDEV_SEND_BCN_CMDID,
	WMI_BCN_TMPL_CMDID,
	WMI_BCN_FILTER_RX_CMDID,
	WMI_PRB_REQ_FILTER_RX_CMDID,
	WMI_MGMT_TX_CMDID,
	WMI_PRB_TMPL_CMDID,
	WMI_MGMT_TX_SEND_CMDID,
	WMI_OFFCHAN_DATA_TX_SEND_CMDID,
	WMI_PDEV_SEND_FD_CMDID,
	WMI_BCN_OFFLOAD_CTRL_CMDID,
	WMI_BSS_COLOR_CHANGE_ENABLE_CMDID,
	WMI_VDEV_BCN_OFFLOAD_QUIET_CONFIG_CMDID,
	WMI_FILS_DISCOVERY_TMPL_CMDID,
	WMI_ADDBA_CLEAR_RESP_CMDID = WMI_TLV_CMD(WMI_GRP_BA_NEG),
	WMI_ADDBA_SEND_CMDID,
	WMI_ADDBA_STATUS_CMDID,
	WMI_DELBA_SEND_CMDID,
	WMI_ADDBA_SET_RESP_CMDID,
	WMI_SEND_SINGLEAMSDU_CMDID,
	WMI_STA_POWERSAVE_MODE_CMDID = WMI_TLV_CMD(WMI_GRP_STA_PS),
	WMI_STA_POWERSAVE_PARAM_CMDID,
	WMI_STA_MIMO_PS_MODE_CMDID,
	WMI_PDEV_DFS_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_DFS),
	WMI_PDEV_DFS_DISABLE_CMDID,
	WMI_DFS_PHYERR_FILTER_ENA_CMDID,
	WMI_DFS_PHYERR_FILTER_DIS_CMDID,
	WMI_PDEV_DFS_PHYERR_OFFLOAD_ENABLE_CMDID,
	WMI_PDEV_DFS_PHYERR_OFFLOAD_DISABLE_CMDID,
	WMI_VDEV_ADFS_CH_CFG_CMDID,
	WMI_VDEV_ADFS_OCAC_ABORT_CMDID,
	WMI_ROAM_SCAN_MODE = WMI_TLV_CMD(WMI_GRP_ROAM),
	WMI_ROAM_SCAN_RSSI_THRESHOLD,
	WMI_ROAM_SCAN_PERIOD,
	WMI_ROAM_SCAN_RSSI_CHANGE_THRESHOLD,
	WMI_ROAM_AP_PROFILE,
	WMI_ROAM_CHAN_LIST,
	WMI_ROAM_SCAN_CMD,
	WMI_ROAM_SYNCH_COMPLETE,
	WMI_ROAM_SET_RIC_REQUEST_CMDID,
	WMI_ROAM_INVOKE_CMDID,
	WMI_ROAM_FILTER_CMDID,
	WMI_ROAM_SUBNET_CHANGE_CONFIG_CMDID,
	WMI_ROAM_CONFIGURE_MAWC_CMDID,
	WMI_ROAM_SET_MBO_PARAM_CMDID,
	WMI_ROAM_PER_CONFIG_CMDID,
	WMI_ROAM_BTM_CONFIG_CMDID,
	WMI_ENABLE_FILS_CMDID,
	WMI_OFL_SCAN_ADD_AP_PROFILE = WMI_TLV_CMD(WMI_GRP_OFL_SCAN),
	WMI_OFL_SCAN_REMOVE_AP_PROFILE,
	WMI_OFL_SCAN_PERIOD,
	WMI_P2P_DEV_SET_DEVICE_INFO = WMI_TLV_CMD(WMI_GRP_P2P),
	WMI_P2P_DEV_SET_DISCOVERABILITY,
	WMI_P2P_GO_SET_BEACON_IE,
	WMI_P2P_GO_SET_PROBE_RESP_IE,
	WMI_P2P_SET_VENDOR_IE_DATA_CMDID,
	WMI_P2P_DISC_OFFLOAD_CONFIG_CMDID,
	WMI_P2P_DISC_OFFLOAD_APPIE_CMDID,
	WMI_P2P_DISC_OFFLOAD_PATTERN_CMDID,
	WMI_P2P_SET_OPPPS_PARAM_CMDID,
	WMI_P2P_LISTEN_OFFLOAD_START_CMDID,
	WMI_P2P_LISTEN_OFFLOAD_STOP_CMDID,
	WMI_AP_PS_PEER_PARAM_CMDID = WMI_TLV_CMD(WMI_GRP_AP_PS),
	WMI_AP_PS_PEER_UAPSD_COEX_CMDID,
	WMI_AP_PS_EGAP_PARAM_CMDID,
	WMI_PEER_RATE_RETRY_SCHED_CMDID = WMI_TLV_CMD(WMI_GRP_RATE_CTRL),
	WMI_WLAN_PROFILE_TRIGGER_CMDID = WMI_TLV_CMD(WMI_GRP_PROFILE),
	WMI_WLAN_PROFILE_SET_HIST_INTVL_CMDID,
	WMI_WLAN_PROFILE_GET_PROFILE_DATA_CMDID,
	WMI_WLAN_PROFILE_ENABLE_PROFILE_ID_CMDID,
	WMI_WLAN_PROFILE_LIST_PROFILE_ID_CMDID,
	WMI_PDEV_SUSPEND_CMDID = WMI_TLV_CMD(WMI_GRP_SUSPEND),
	WMI_PDEV_RESUME_CMDID,
	WMI_ADD_BCN_FILTER_CMDID = WMI_TLV_CMD(WMI_GRP_BCN_FILTER),
	WMI_RMV_BCN_FILTER_CMDID,
	WMI_WOW_ADD_WAKE_PATTERN_CMDID = WMI_TLV_CMD(WMI_GRP_WOW),
	WMI_WOW_DEL_WAKE_PATTERN_CMDID,
	WMI_WOW_ENABLE_DISABLE_WAKE_EVENT_CMDID,
	WMI_WOW_ENABLE_CMDID,
	WMI_WOW_HOSTWAKEUP_FROM_SLEEP_CMDID,
	WMI_WOW_IOAC_ADD_KEEPALIVE_CMDID,
	WMI_WOW_IOAC_DEL_KEEPALIVE_CMDID,
	WMI_WOW_IOAC_ADD_WAKE_PATTERN_CMDID,
	WMI_WOW_IOAC_DEL_WAKE_PATTERN_CMDID,
	WMI_D0_WOW_ENABLE_DISABLE_CMDID,
	WMI_EXTWOW_ENABLE_CMDID,
	WMI_EXTWOW_SET_APP_TYPE1_PARAMS_CMDID,
	WMI_EXTWOW_SET_APP_TYPE2_PARAMS_CMDID,
	WMI_WOW_ENABLE_ICMPV6_NA_FLT_CMDID,
	WMI_WOW_UDP_SVC_OFLD_CMDID,
	WMI_WOW_HOSTWAKEUP_GPIO_PIN_PATTERN_CONFIG_CMDID,
	WMI_WOW_SET_ACTION_WAKE_UP_CMDID,
	WMI_RTT_MEASREQ_CMDID = WMI_TLV_CMD(WMI_GRP_RTT),
	WMI_RTT_TSF_CMDID,
	WMI_VDEV_SPECTRAL_SCAN_CONFIGURE_CMDID = WMI_TLV_CMD(WMI_GRP_SPECTRAL),
	WMI_VDEV_SPECTRAL_SCAN_ENABLE_CMDID,
	WMI_REQUEST_STATS_CMDID = WMI_TLV_CMD(WMI_GRP_STATS),
	WMI_MCC_SCHED_TRAFFIC_STATS_CMDID,
	WMI_REQUEST_STATS_EXT_CMDID,
	WMI_REQUEST_LINK_STATS_CMDID,
	WMI_START_LINK_STATS_CMDID,
	WMI_CLEAR_LINK_STATS_CMDID,
	WMI_GET_FW_MEM_DUMP_CMDID,
	WMI_DEBUG_MESG_FLUSH_CMDID,
	WMI_DIAG_EVENT_LOG_CONFIG_CMDID,
	WMI_REQUEST_WLAN_STATS_CMDID,
	WMI_REQUEST_RCPI_CMDID,
	WMI_REQUEST_PEER_STATS_INFO_CMDID,
	WMI_REQUEST_RADIO_CHAN_STATS_CMDID,
	WMI_SET_ARP_NS_OFFLOAD_CMDID = WMI_TLV_CMD(WMI_GRP_ARP_NS_OFL),
	WMI_ADD_PROACTIVE_ARP_RSP_PATTERN_CMDID,
	WMI_DEL_PROACTIVE_ARP_RSP_PATTERN_CMDID,
	WMI_NETWORK_LIST_OFFLOAD_CONFIG_CMDID = WMI_TLV_CMD(WMI_GRP_NLO_OFL),
	WMI_APFIND_CMDID,
	WMI_PASSPOINT_LIST_CONFIG_CMDID,
	WMI_NLO_CONFIGURE_MAWC_CMDID,
	WMI_GTK_OFFLOAD_CMDID = WMI_TLV_CMD(WMI_GRP_GTK_OFL),
	WMI_CSA_OFFLOAD_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_CSA_OFL),
	WMI_CSA_OFFLOAD_CHANSWITCH_CMDID,
	WMI_CHATTER_SET_MODE_CMDID = WMI_TLV_CMD(WMI_GRP_CHATTER),
	WMI_CHATTER_ADD_COALESCING_FILTER_CMDID,
	WMI_CHATTER_DELETE_COALESCING_FILTER_CMDID,
	WMI_CHATTER_COALESCING_QUERY_CMDID,
	WMI_PEER_TID_ADDBA_CMDID = WMI_TLV_CMD(WMI_GRP_TID_ADDBA),
	WMI_PEER_TID_DELBA_CMDID,
	WMI_STA_DTIM_PS_METHOD_CMDID,
	WMI_STA_UAPSD_AUTO_TRIG_CMDID,
	WMI_STA_KEEPALIVE_CMDID,
	WMI_BA_REQ_SSN_CMDID,
	WMI_ECHO_CMDID = WMI_TLV_CMD(WMI_GRP_MISC),
	WMI_PDEV_UTF_CMDID,
	WMI_DBGLOG_CFG_CMDID,
	WMI_PDEV_QVIT_CMDID,
	WMI_PDEV_FTM_INTG_CMDID,
	WMI_VDEV_SET_KEEPALIVE_CMDID,
	WMI_VDEV_GET_KEEPALIVE_CMDID,
	WMI_FORCE_FW_HANG_CMDID,
	WMI_SET_MCASTBCAST_FILTER_CMDID,
	WMI_THERMAL_MGMT_CMDID,
	WMI_HOST_AUTO_SHUTDOWN_CFG_CMDID,
	WMI_TPC_CHAINMASK_CONFIG_CMDID,
	WMI_SET_ANTENNA_DIVERSITY_CMDID,
	WMI_OCB_SET_SCHED_CMDID,
	WMI_RSSI_BREACH_MONITOR_CONFIG_CMDID,
	WMI_LRO_CONFIG_CMDID,
	WMI_TRANSFER_DATA_TO_FLASH_CMDID,
	WMI_CONFIG_ENHANCED_MCAST_FILTER_CMDID,
	WMI_VDEV_WISA_CMDID,
	WMI_DBGLOG_TIME_STAMP_SYNC_CMDID,
	WMI_SET_MULTIPLE_MCAST_FILTER_CMDID,
	WMI_READ_DATA_FROM_FLASH_CMDID,
	WMI_THERM_THROT_SET_CONF_CMDID,
	WMI_RUNTIME_DPD_RECAL_CMDID,
	WMI_GET_TPC_POWER_CMDID,
	WMI_IDLE_TRIGGER_MONITOR_CMDID,
	WMI_GPIO_CONFIG_CMDID = WMI_TLV_CMD(WMI_GRP_GPIO),
	WMI_GPIO_OUTPUT_CMDID,
	WMI_TXBF_CMDID,
	WMI_FWTEST_VDEV_MCC_SET_TBTT_MODE_CMDID = WMI_TLV_CMD(WMI_GRP_FWTEST),
	WMI_FWTEST_P2P_SET_NOA_PARAM_CMDID,
	WMI_UNIT_TEST_CMDID,
	WMI_FWTEST_CMDID,
	WMI_QBOOST_CFG_CMDID,
	WMI_TDLS_SET_STATE_CMDID = WMI_TLV_CMD(WMI_GRP_TDLS),
	WMI_TDLS_PEER_UPDATE_CMDID,
	WMI_TDLS_SET_OFFCHAN_MODE_CMDID,
	WMI_RESMGR_ADAPTIVE_OCS_EN_DIS_CMDID = WMI_TLV_CMD(WMI_GRP_RESMGR),
	WMI_RESMGR_SET_CHAN_TIME_QUOTA_CMDID,
	WMI_RESMGR_SET_CHAN_LATENCY_CMDID,
	WMI_STA_SMPS_FORCE_MODE_CMDID = WMI_TLV_CMD(WMI_GRP_STA_SMPS),
	WMI_STA_SMPS_PARAM_CMDID,
	WMI_HB_SET_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_WLAN_HB),
	WMI_HB_SET_TCP_PARAMS_CMDID,
	WMI_HB_SET_TCP_PKT_FILTER_CMDID,
	WMI_HB_SET_UDP_PARAMS_CMDID,
	WMI_HB_SET_UDP_PKT_FILTER_CMDID,
	WMI_RMC_SET_MODE_CMDID = WMI_TLV_CMD(WMI_GRP_RMC),
	WMI_RMC_SET_ACTION_PERIOD_CMDID,
	WMI_RMC_CONFIG_CMDID,
	WMI_RMC_SET_MANUAL_LEADER_CMDID,
	WMI_MHF_OFFLOAD_SET_MODE_CMDID = WMI_TLV_CMD(WMI_GRP_MHF_OFL),
	WMI_MHF_OFFLOAD_PLUMB_ROUTING_TBL_CMDID,
	WMI_BATCH_SCAN_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_LOCATION_SCAN),
	WMI_BATCH_SCAN_DISABLE_CMDID,
	WMI_BATCH_SCAN_TRIGGER_RESULT_CMDID,
	WMI_OEM_REQ_CMDID = WMI_TLV_CMD(WMI_GRP_OEM),
	WMI_OEM_REQUEST_CMDID,
	WMI_LPI_OEM_REQ_CMDID,
	WMI_NAN_CMDID = WMI_TLV_CMD(WMI_GRP_NAN),
	WMI_MODEM_POWER_STATE_CMDID = WMI_TLV_CMD(WMI_GRP_COEX),
	WMI_CHAN_AVOID_UPDATE_CMDID,
	WMI_COEX_CONFIG_CMDID,
	WMI_CHAN_AVOID_RPT_ALLOW_CMDID,
	WMI_COEX_GET_ANTENNA_ISOLATION_CMDID,
	WMI_SAR_LIMITS_CMDID,
	WMI_OBSS_SCAN_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_OBSS_OFL),
	WMI_OBSS_SCAN_DISABLE_CMDID,
	WMI_OBSS_COLOR_COLLISION_DET_CONFIG_CMDID,
	WMI_LPI_MGMT_SNOOPING_CONFIG_CMDID = WMI_TLV_CMD(WMI_GRP_LPI),
	WMI_LPI_START_SCAN_CMDID,
	WMI_LPI_STOP_SCAN_CMDID,
	WMI_EXTSCAN_START_CMDID = WMI_TLV_CMD(WMI_GRP_EXTSCAN),
	WMI_EXTSCAN_STOP_CMDID,
	WMI_EXTSCAN_CONFIGURE_WLAN_CHANGE_MONITOR_CMDID,
	WMI_EXTSCAN_CONFIGURE_HOTLIST_MONITOR_CMDID,
	WMI_EXTSCAN_GET_CACHED_RESULTS_CMDID,
	WMI_EXTSCAN_GET_WLAN_CHANGE_RESULTS_CMDID,
	WMI_EXTSCAN_SET_CAPABILITIES_CMDID,
	WMI_EXTSCAN_GET_CAPABILITIES_CMDID,
	WMI_EXTSCAN_CONFIGURE_HOTLIST_SSID_MONITOR_CMDID,
	WMI_EXTSCAN_CONFIGURE_MAWC_CMDID,
	WMI_SET_DHCP_SERVER_OFFLOAD_CMDID = WMI_TLV_CMD(WMI_GRP_DHCP_OFL),
	WMI_IPA_OFFLOAD_ENABLE_DISABLE_CMDID = WMI_TLV_CMD(WMI_GRP_IPA),
	WMI_MDNS_OFFLOAD_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_MDNS_OFL),
	WMI_MDNS_SET_FQDN_CMDID,
	WMI_MDNS_SET_RESPONSE_CMDID,
	WMI_MDNS_GET_STATS_CMDID,
	WMI_SAP_OFL_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_SAP_OFL),
	WMI_SAP_SET_BLACKLIST_PARAM_CMDID,
	WMI_OCB_SET_CONFIG_CMDID = WMI_TLV_CMD(WMI_GRP_OCB),
	WMI_OCB_SET_UTC_TIME_CMDID,
	WMI_OCB_START_TIMING_ADVERT_CMDID,
	WMI_OCB_STOP_TIMING_ADVERT_CMDID,
	WMI_OCB_GET_TSF_TIMER_CMDID,
	WMI_DCC_GET_STATS_CMDID,
	WMI_DCC_CLEAR_STATS_CMDID,
	WMI_DCC_UPDATE_NDL_CMDID,
	WMI_SOC_SET_PCL_CMDID = WMI_TLV_CMD(WMI_GRP_SOC),
	WMI_SOC_SET_HW_MODE_CMDID,
	WMI_SOC_SET_DUAL_MAC_CONFIG_CMDID,
	WMI_SOC_SET_ANTENNA_MODE_CMDID,
	WMI_PACKET_FILTER_CONFIG_CMDID = WMI_TLV_CMD(WMI_GRP_PKT_FILTER),
	WMI_PACKET_FILTER_ENABLE_CMDID,
	WMI_MAWC_SENSOR_REPORT_IND_CMDID = WMI_TLV_CMD(WMI_GRP_MAWC),
	WMI_PMF_OFFLOAD_SET_SA_QUERY_CMDID = WMI_TLV_CMD(WMI_GRP_PMF_OFFLOAD),
	WMI_BPF_GET_CAPABILITY_CMDID = WMI_TLV_CMD(WMI_GRP_BPF_OFFLOAD),
	WMI_BPF_GET_VDEV_STATS_CMDID,
	WMI_BPF_SET_VDEV_INSTRUCTIONS_CMDID,
	WMI_BPF_DEL_VDEV_INSTRUCTIONS_CMDID,
	WMI_BPF_SET_VDEV_ACTIVE_MODE_CMDID,
	WMI_MNT_FILTER_CMDID = WMI_TLV_CMD(WMI_GRP_MONITOR),
	WMI_SET_CURRENT_COUNTRY_CMDID = WMI_TLV_CMD(WMI_GRP_REGULATORY),
	WMI_11D_SCAN_START_CMDID,
	WMI_11D_SCAN_STOP_CMDID,
	WMI_SET_INIT_COUNTRY_CMDID,
	WMI_NDI_GET_CAP_REQ_CMDID = WMI_TLV_CMD(WMI_GRP_PROTOTYPE),
	WMI_NDP_INITIATOR_REQ_CMDID,
	WMI_NDP_RESPONDER_REQ_CMDID,
	WMI_NDP_END_REQ_CMDID,
	WMI_HW_DATA_FILTER_CMDID = WMI_TLV_CMD(WMI_GRP_HW_DATA_FILTER),
	WMI_TWT_ENABLE_CMDID = WMI_TLV_CMD(WMI_GRP_TWT),
	WMI_TWT_DISABLE_CMDID,
	WMI_TWT_ADD_DIALOG_CMDID,
	WMI_TWT_DEL_DIALOG_CMDID,
	WMI_TWT_PAUSE_DIALOG_CMDID,
	WMI_TWT_RESUME_DIALOG_CMDID,
	WMI_PDEV_OBSS_PD_SPATIAL_REUSE_CMDID =
				WMI_TLV_CMD(WMI_GRP_SPATIAL_REUSE),
	WMI_PDEV_OBSS_PD_SPATIAL_REUSE_SET_DEF_OBSS_THRESH_CMDID,
};

enum wmi_tlv_event_id {
	WMI_SERVICE_READY_EVENTID = 0x1,
	WMI_READY_EVENTID,
	WMI_SERVICE_AVAILABLE_EVENTID,
	WMI_SCAN_EVENTID = WMI_EVT_GRP_START_ID(WMI_GRP_SCAN),
	WMI_PDEV_TPC_CONFIG_EVENTID = WMI_TLV_CMD(WMI_GRP_PDEV),
	WMI_CHAN_INFO_EVENTID,
	WMI_PHYERR_EVENTID,
	WMI_PDEV_DUMP_EVENTID,
	WMI_TX_PAUSE_EVENTID,
	WMI_DFS_RADAR_EVENTID,
	WMI_PDEV_L1SS_TRACK_EVENTID,
	WMI_PDEV_TEMPERATURE_EVENTID,
	WMI_SERVICE_READY_EXT_EVENTID,
	WMI_PDEV_FIPS_EVENTID,
	WMI_PDEV_CHANNEL_HOPPING_EVENTID,
	WMI_PDEV_ANI_CCK_LEVEL_EVENTID,
	WMI_PDEV_ANI_OFDM_LEVEL_EVENTID,
	WMI_PDEV_TPC_EVENTID,
	WMI_PDEV_NFCAL_POWER_ALL_CHANNELS_EVENTID,
	WMI_PDEV_SET_HW_MODE_RESP_EVENTID,
	WMI_PDEV_HW_MODE_TRANSITION_EVENTID,
	WMI_PDEV_SET_MAC_CONFIG_RESP_EVENTID,
	WMI_PDEV_ANTDIV_STATUS_EVENTID,
	WMI_PDEV_CHIP_POWER_STATS_EVENTID,
	WMI_PDEV_CHIP_POWER_SAVE_FAILURE_DETECTED_EVENTID,
	WMI_PDEV_CSA_SWITCH_COUNT_STATUS_EVENTID,
	WMI_PDEV_CHECK_CAL_VERSION_EVENTID,
	WMI_PDEV_DIV_RSSI_ANTID_EVENTID,
	WMI_PDEV_BSS_CHAN_INFO_EVENTID,
	WMI_PDEV_UPDATE_CTLTABLE_EVENTID,
	WMI_PDEV_DMA_RING_CFG_RSP_EVENTID,
	WMI_PDEV_DMA_RING_BUF_RELEASE_EVENTID,
	WMI_PDEV_CTL_FAILSAFE_CHECK_EVENTID,
	WMI_PDEV_CSC_SWITCH_COUNT_STATUS_EVENTID,
	WMI_PDEV_COLD_BOOT_CAL_DATA_EVENTID,
	WMI_PDEV_RAP_INFO_EVENTID,
	WMI_CHAN_RF_CHARACTERIZATION_INFO_EVENTID,
	WMI_SERVICE_READY_EXT2_EVENTID,
	WMI_VDEV_START_RESP_EVENTID = WMI_TLV_CMD(WMI_GRP_VDEV),
	WMI_VDEV_STOPPED_EVENTID,
	WMI_VDEV_INSTALL_KEY_COMPLETE_EVENTID,
	WMI_VDEV_MCC_BCN_INTERVAL_CHANGE_REQ_EVENTID,
	WMI_VDEV_TSF_REPORT_EVENTID,
	WMI_VDEV_DELETE_RESP_EVENTID,
	WMI_VDEV_ENCRYPT_DECRYPT_DATA_RESP_EVENTID,
	WMI_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_STATUS_EVENTID,
	WMI_PEER_STA_KICKOUT_EVENTID = WMI_TLV_CMD(WMI_GRP_PEER),
	WMI_PEER_INFO_EVENTID,
	WMI_PEER_TX_FAIL_CNT_THR_EVENTID,
	WMI_PEER_ESTIMATED_LINKSPEED_EVENTID,
	WMI_PEER_STATE_EVENTID,
	WMI_PEER_ASSOC_CONF_EVENTID,
	WMI_PEER_DELETE_RESP_EVENTID,
	WMI_PEER_RATECODE_LIST_EVENTID,
	WMI_WDS_PEER_EVENTID,
	WMI_PEER_STA_PS_STATECHG_EVENTID,
	WMI_PEER_ANTDIV_INFO_EVENTID,
	WMI_PEER_RESERVED0_EVENTID,
	WMI_PEER_RESERVED1_EVENTID,
	WMI_PEER_RESERVED2_EVENTID,
	WMI_PEER_RESERVED3_EVENTID,
	WMI_PEER_RESERVED4_EVENTID,
	WMI_PEER_RESERVED5_EVENTID,
	WMI_PEER_RESERVED6_EVENTID,
	WMI_PEER_RESERVED7_EVENTID,
	WMI_PEER_RESERVED8_EVENTID,
	WMI_PEER_RESERVED9_EVENTID,
	WMI_PEER_RESERVED10_EVENTID,
	WMI_PEER_OPER_MODE_CHANGE_EVENTID,
	WMI_PEER_TX_PN_RESPONSE_EVENTID,
	WMI_PEER_CFR_CAPTURE_EVENTID,
	WMI_PEER_CREATE_CONF_EVENTID,
	WMI_MGMT_RX_EVENTID = WMI_TLV_CMD(WMI_GRP_MGMT),
	WMI_HOST_SWBA_EVENTID,
	WMI_TBTTOFFSET_UPDATE_EVENTID,
	WMI_OFFLOAD_BCN_TX_STATUS_EVENTID,
	WMI_OFFLOAD_PROB_RESP_TX_STATUS_EVENTID,
	WMI_MGMT_TX_COMPLETION_EVENTID,
	WMI_MGMT_TX_BUNDLE_COMPLETION_EVENTID,
	WMI_TBTTOFFSET_EXT_UPDATE_EVENTID,
	WMI_OFFCHAN_DATA_TX_COMPLETION_EVENTID,
	WMI_HOST_FILS_DISCOVERY_EVENTID,
	WMI_TX_DELBA_COMPLETE_EVENTID = WMI_TLV_CMD(WMI_GRP_BA_NEG),
	WMI_TX_ADDBA_COMPLETE_EVENTID,
	WMI_BA_RSP_SSN_EVENTID,
	WMI_AGGR_STATE_TRIG_EVENTID,
	WMI_ROAM_EVENTID = WMI_TLV_CMD(WMI_GRP_ROAM),
	WMI_PROFILE_MATCH,
	WMI_ROAM_SYNCH_EVENTID,
	WMI_P2P_DISC_EVENTID = WMI_TLV_CMD(WMI_GRP_P2P),
	WMI_P2P_NOA_EVENTID,
	WMI_P2P_LISTEN_OFFLOAD_STOPPED_EVENTID,
	WMI_AP_PS_EGAP_INFO_EVENTID = WMI_TLV_CMD(WMI_GRP_AP_PS),
	WMI_PDEV_RESUME_EVENTID = WMI_TLV_CMD(WMI_GRP_SUSPEND),
	WMI_WOW_WAKEUP_HOST_EVENTID = WMI_TLV_CMD(WMI_GRP_WOW),
	WMI_D0_WOW_DISABLE_ACK_EVENTID,
	WMI_WOW_INITIAL_WAKEUP_EVENTID,
	WMI_RTT_MEASUREMENT_REPORT_EVENTID = WMI_TLV_CMD(WMI_GRP_RTT),
	WMI_TSF_MEASUREMENT_REPORT_EVENTID,
	WMI_RTT_ERROR_REPORT_EVENTID,
	WMI_STATS_EXT_EVENTID = WMI_TLV_CMD(WMI_GRP_STATS),
	WMI_IFACE_LINK_STATS_EVENTID,
	WMI_PEER_LINK_STATS_EVENTID,
	WMI_RADIO_LINK_STATS_EVENTID,
	WMI_UPDATE_FW_MEM_DUMP_EVENTID,
	WMI_DIAG_EVENT_LOG_SUPPORTED_EVENTID,
	WMI_INST_RSSI_STATS_EVENTID,
	WMI_RADIO_TX_POWER_LEVEL_STATS_EVENTID,
	WMI_REPORT_STATS_EVENTID,
	WMI_UPDATE_RCPI_EVENTID,
	WMI_PEER_STATS_INFO_EVENTID,
	WMI_RADIO_CHAN_STATS_EVENTID,
	WMI_NLO_MATCH_EVENTID = WMI_TLV_CMD(WMI_GRP_NLO_OFL),
	WMI_NLO_SCAN_COMPLETE_EVENTID,
	WMI_APFIND_EVENTID,
	WMI_PASSPOINT_MATCH_EVENTID,
	WMI_GTK_OFFLOAD_STATUS_EVENTID = WMI_TLV_CMD(WMI_GRP_GTK_OFL),
	WMI_GTK_REKEY_FAIL_EVENTID,
	WMI_CSA_HANDLING_EVENTID = WMI_TLV_CMD(WMI_GRP_CSA_OFL),
	WMI_CHATTER_PC_QUERY_EVENTID = WMI_TLV_CMD(WMI_GRP_CHATTER),
	WMI_PDEV_DFS_RADAR_DETECTION_EVENTID = WMI_TLV_CMD(WMI_GRP_DFS),
	WMI_VDEV_DFS_CAC_COMPLETE_EVENTID,
	WMI_VDEV_ADFS_OCAC_COMPLETE_EVENTID,
	WMI_ECHO_EVENTID = WMI_TLV_CMD(WMI_GRP_MISC),
	WMI_PDEV_UTF_EVENTID,
	WMI_DEBUG_MESG_EVENTID,
	WMI_UPDATE_STATS_EVENTID,
	WMI_DEBUG_PRINT_EVENTID,
	WMI_DCS_INTERFERENCE_EVENTID,
	WMI_PDEV_QVIT_EVENTID,
	WMI_WLAN_PROFILE_DATA_EVENTID,
	WMI_PDEV_FTM_INTG_EVENTID,
	WMI_WLAN_FREQ_AVOID_EVENTID,
	WMI_VDEV_GET_KEEPALIVE_EVENTID,
	WMI_THERMAL_MGMT_EVENTID,
	WMI_DIAG_DATA_CONTAINER_EVENTID,
	WMI_HOST_AUTO_SHUTDOWN_EVENTID,
	WMI_UPDATE_WHAL_MIB_STATS_EVENTID,
	WMI_UPDATE_VDEV_RATE_STATS_EVENTID,
	WMI_DIAG_EVENTID,
	WMI_OCB_SET_SCHED_EVENTID,
	WMI_DEBUG_MESG_FLUSH_COMPLETE_EVENTID,
	WMI_RSSI_BREACH_EVENTID,
	WMI_TRANSFER_DATA_TO_FLASH_COMPLETE_EVENTID,
	WMI_PDEV_UTF_SCPC_EVENTID,
	WMI_READ_DATA_FROM_FLASH_EVENTID,
	WMI_REPORT_RX_AGGR_FAILURE_EVENTID,
	WMI_PKGID_EVENTID,
	WMI_GPIO_INPUT_EVENTID = WMI_TLV_CMD(WMI_GRP_GPIO),
	WMI_UPLOADH_EVENTID,
	WMI_CAPTUREH_EVENTID,
	WMI_RFKILL_STATE_CHANGE_EVENTID,
	WMI_TDLS_PEER_EVENTID = WMI_TLV_CMD(WMI_GRP_TDLS),
	WMI_STA_SMPS_FORCE_MODE_COMPL_EVENTID = WMI_TLV_CMD(WMI_GRP_STA_SMPS),
	WMI_BATCH_SCAN_ENABLED_EVENTID = WMI_TLV_CMD(WMI_GRP_LOCATION_SCAN),
	WMI_BATCH_SCAN_RESULT_EVENTID,
	WMI_OEM_CAPABILITY_EVENTID = WMI_TLV_CMD(WMI_GRP_OEM),
	WMI_OEM_MEASUREMENT_REPORT_EVENTID,
	WMI_OEM_ERROR_REPORT_EVENTID,
	WMI_OEM_RESPONSE_EVENTID,
	WMI_NAN_EVENTID = WMI_TLV_CMD(WMI_GRP_NAN),
	WMI_NAN_DISC_IFACE_CREATED_EVENTID,
	WMI_NAN_DISC_IFACE_DELETED_EVENTID,
	WMI_NAN_STARTED_CLUSTER_EVENTID,
	WMI_NAN_JOINED_CLUSTER_EVENTID,
	WMI_COEX_REPORT_ANTENNA_ISOLATION_EVENTID = WMI_TLV_CMD(WMI_GRP_COEX),
	WMI_LPI_RESULT_EVENTID = WMI_TLV_CMD(WMI_GRP_LPI),
	WMI_LPI_STATUS_EVENTID,
	WMI_LPI_HANDOFF_EVENTID,
	WMI_EXTSCAN_START_STOP_EVENTID = WMI_TLV_CMD(WMI_GRP_EXTSCAN),
	WMI_EXTSCAN_OPERATION_EVENTID,
	WMI_EXTSCAN_TABLE_USAGE_EVENTID,
	WMI_EXTSCAN_CACHED_RESULTS_EVENTID,
	WMI_EXTSCAN_WLAN_CHANGE_RESULTS_EVENTID,
	WMI_EXTSCAN_HOTLIST_MATCH_EVENTID,
	WMI_EXTSCAN_CAPABILITIES_EVENTID,
	WMI_EXTSCAN_HOTLIST_SSID_MATCH_EVENTID,
	WMI_MDNS_STATS_EVENTID = WMI_TLV_CMD(WMI_GRP_MDNS_OFL),
	WMI_SAP_OFL_ADD_STA_EVENTID = WMI_TLV_CMD(WMI_GRP_SAP_OFL),
	WMI_SAP_OFL_DEL_STA_EVENTID,
	WMI_OBSS_COLOR_COLLISION_DETECTION_EVENTID =
		WMI_EVT_GRP_START_ID(WMI_GRP_OBSS_OFL),
	WMI_OCB_SET_CONFIG_RESP_EVENTID = WMI_TLV_CMD(WMI_GRP_OCB),
	WMI_OCB_GET_TSF_TIMER_RESP_EVENTID,
	WMI_DCC_GET_STATS_RESP_EVENTID,
	WMI_DCC_UPDATE_NDL_RESP_EVENTID,
	WMI_DCC_STATS_EVENTID,
	WMI_SOC_SET_HW_MODE_RESP_EVENTID = WMI_TLV_CMD(WMI_GRP_SOC),
	WMI_SOC_HW_MODE_TRANSITION_EVENTID,
	WMI_SOC_SET_DUAL_MAC_CONFIG_RESP_EVENTID,
	WMI_MAWC_ENABLE_SENSOR_EVENTID = WMI_TLV_CMD(WMI_GRP_MAWC),
	WMI_BPF_CAPABILIY_INFO_EVENTID = WMI_TLV_CMD(WMI_GRP_BPF_OFFLOAD),
	WMI_BPF_VDEV_STATS_INFO_EVENTID,
	WMI_RMC_NEW_LEADER_EVENTID = WMI_TLV_CMD(WMI_GRP_RMC),
	WMI_REG_CHAN_LIST_CC_EVENTID = WMI_TLV_CMD(WMI_GRP_REGULATORY),
	WMI_11D_NEW_COUNTRY_EVENTID,
	WMI_REG_CHAN_LIST_CC_EXT_EVENTID,
	WMI_NDI_CAP_RSP_EVENTID = WMI_TLV_CMD(WMI_GRP_PROTOTYPE),
	WMI_NDP_INITIATOR_RSP_EVENTID,
	WMI_NDP_RESPONDER_RSP_EVENTID,
	WMI_NDP_END_RSP_EVENTID,
	WMI_NDP_INDICATION_EVENTID,
	WMI_NDP_CONFIRM_EVENTID,
	WMI_NDP_END_INDICATION_EVENTID,

	WMI_TWT_ENABLE_EVENTID = WMI_TLV_CMD(WMI_GRP_TWT),
	WMI_TWT_DISABLE_EVENTID,
	WMI_TWT_ADD_DIALOG_EVENTID,
	WMI_TWT_DEL_DIALOG_EVENTID,
	WMI_TWT_PAUSE_DIALOG_EVENTID,
	WMI_TWT_RESUME_DIALOG_EVENTID,
};

enum wmi_tlv_pdev_param {
	WMI_PDEV_PARAM_TX_CHAIN_MASK = 0x1,
	WMI_PDEV_PARAM_RX_CHAIN_MASK,
	WMI_PDEV_PARAM_TXPOWER_LIMIT2G,
	WMI_PDEV_PARAM_TXPOWER_LIMIT5G,
	WMI_PDEV_PARAM_TXPOWER_SCALE,
	WMI_PDEV_PARAM_BEACON_GEN_MODE,
	WMI_PDEV_PARAM_BEACON_TX_MODE,
	WMI_PDEV_PARAM_RESMGR_OFFCHAN_MODE,
	WMI_PDEV_PARAM_PROTECTION_MODE,
	WMI_PDEV_PARAM_DYNAMIC_BW,
	WMI_PDEV_PARAM_NON_AGG_SW_RETRY_TH,
	WMI_PDEV_PARAM_AGG_SW_RETRY_TH,
	WMI_PDEV_PARAM_STA_KICKOUT_TH,
	WMI_PDEV_PARAM_AC_AGGRSIZE_SCALING,
	WMI_PDEV_PARAM_LTR_ENABLE,
	WMI_PDEV_PARAM_LTR_AC_LATENCY_BE,
	WMI_PDEV_PARAM_LTR_AC_LATENCY_BK,
	WMI_PDEV_PARAM_LTR_AC_LATENCY_VI,
	WMI_PDEV_PARAM_LTR_AC_LATENCY_VO,
	WMI_PDEV_PARAM_LTR_AC_LATENCY_TIMEOUT,
	WMI_PDEV_PARAM_LTR_SLEEP_OVERRIDE,
	WMI_PDEV_PARAM_LTR_RX_OVERRIDE,
	WMI_PDEV_PARAM_LTR_TX_ACTIVITY_TIMEOUT,
	WMI_PDEV_PARAM_L1SS_ENABLE,
	WMI_PDEV_PARAM_DSLEEP_ENABLE,
	WMI_PDEV_PARAM_PCIELP_TXBUF_FLUSH,
	WMI_PDEV_PARAM_PCIELP_TXBUF_WATERMARK,
	WMI_PDEV_PARAM_PCIELP_TXBUF_TMO_EN,
	WMI_PDEV_PARAM_PCIELP_TXBUF_TMO_VALUE,
	WMI_PDEV_PARAM_PDEV_STATS_UPDATE_PERIOD,
	WMI_PDEV_PARAM_VDEV_STATS_UPDATE_PERIOD,
	WMI_PDEV_PARAM_PEER_STATS_UPDATE_PERIOD,
	WMI_PDEV_PARAM_BCNFLT_STATS_UPDATE_PERIOD,
	WMI_PDEV_PARAM_PMF_QOS,
	WMI_PDEV_PARAM_ARP_AC_OVERRIDE,
	WMI_PDEV_PARAM_DCS,
	WMI_PDEV_PARAM_ANI_ENABLE,
	WMI_PDEV_PARAM_ANI_POLL_PERIOD,
	WMI_PDEV_PARAM_ANI_LISTEN_PERIOD,
	WMI_PDEV_PARAM_ANI_OFDM_LEVEL,
	WMI_PDEV_PARAM_ANI_CCK_LEVEL,
	WMI_PDEV_PARAM_DYNTXCHAIN,
	WMI_PDEV_PARAM_PROXY_STA,
	WMI_PDEV_PARAM_IDLE_PS_CONFIG,
	WMI_PDEV_PARAM_POWER_GATING_SLEEP,
	WMI_PDEV_PARAM_RFKILL_ENABLE,
	WMI_PDEV_PARAM_BURST_DUR,
	WMI_PDEV_PARAM_BURST_ENABLE,
	WMI_PDEV_PARAM_HW_RFKILL_CONFIG,
	WMI_PDEV_PARAM_LOW_POWER_RF_ENABLE,
	WMI_PDEV_PARAM_L1SS_TRACK,
	WMI_PDEV_PARAM_HYST_EN,
	WMI_PDEV_PARAM_POWER_COLLAPSE_ENABLE,
	WMI_PDEV_PARAM_LED_SYS_STATE,
	WMI_PDEV_PARAM_LED_ENABLE,
	WMI_PDEV_PARAM_AUDIO_OVER_WLAN_LATENCY,
	WMI_PDEV_PARAM_AUDIO_OVER_WLAN_ENABLE,
	WMI_PDEV_PARAM_WHAL_MIB_STATS_UPDATE_ENABLE,
	WMI_PDEV_PARAM_VDEV_RATE_STATS_UPDATE_PERIOD,
	WMI_PDEV_PARAM_CTS_CBW,
	WMI_PDEV_PARAM_WNTS_CONFIG,
	WMI_PDEV_PARAM_ADAPTIVE_EARLY_RX_ENABLE,
	WMI_PDEV_PARAM_ADAPTIVE_EARLY_RX_MIN_SLEEP_SLOP,
	WMI_PDEV_PARAM_ADAPTIVE_EARLY_RX_INC_DEC_STEP,
	WMI_PDEV_PARAM_EARLY_RX_FIX_SLEEP_SLOP,
	WMI_PDEV_PARAM_BMISS_BASED_ADAPTIVE_BTO_ENABLE,
	WMI_PDEV_PARAM_BMISS_BTO_MIN_BCN_TIMEOUT,
	WMI_PDEV_PARAM_BMISS_BTO_INC_DEC_STEP,
	WMI_PDEV_PARAM_BTO_FIX_BCN_TIMEOUT,
	WMI_PDEV_PARAM_CE_BASED_ADAPTIVE_BTO_ENABLE,
	WMI_PDEV_PARAM_CE_BTO_COMBO_CE_VALUE,
	WMI_PDEV_PARAM_TX_CHAIN_MASK_2G,
	WMI_PDEV_PARAM_RX_CHAIN_MASK_2G,
	WMI_PDEV_PARAM_TX_CHAIN_MASK_5G,
	WMI_PDEV_PARAM_RX_CHAIN_MASK_5G,
	WMI_PDEV_PARAM_TX_CHAIN_MASK_CCK,
	WMI_PDEV_PARAM_TX_CHAIN_MASK_1SS,
	WMI_PDEV_PARAM_CTS2SELF_FOR_P2P_GO_CONFIG,
	WMI_PDEV_PARAM_TXPOWER_DECR_DB,
	WMI_PDEV_PARAM_AGGR_BURST,
	WMI_PDEV_PARAM_RX_DECAP_MODE,
	WMI_PDEV_PARAM_FAST_CHANNEL_RESET,
	WMI_PDEV_PARAM_SMART_ANTENNA_DEFAULT_ANTENNA,
	WMI_PDEV_PARAM_ANTENNA_GAIN,
	WMI_PDEV_PARAM_RX_FILTER,
	WMI_PDEV_SET_MCAST_TO_UCAST_TID,
	WMI_PDEV_PARAM_PROXY_STA_MODE,
	WMI_PDEV_PARAM_SET_MCAST2UCAST_MODE,
	WMI_PDEV_PARAM_SET_MCAST2UCAST_BUFFER,
	WMI_PDEV_PARAM_REMOVE_MCAST2UCAST_BUFFER,
	WMI_PDEV_PEER_STA_PS_STATECHG_ENABLE,
	WMI_PDEV_PARAM_IGMPMLD_AC_OVERRIDE,
	WMI_PDEV_PARAM_BLOCK_INTERBSS,
	WMI_PDEV_PARAM_SET_DISABLE_RESET_CMDID,
	WMI_PDEV_PARAM_SET_MSDU_TTL_CMDID,
	WMI_PDEV_PARAM_SET_PPDU_DURATION_CMDID,
	WMI_PDEV_PARAM_TXBF_SOUND_PERIOD_CMDID,
	WMI_PDEV_PARAM_SET_PROMISC_MODE_CMDID,
	WMI_PDEV_PARAM_SET_BURST_MODE_CMDID,
	WMI_PDEV_PARAM_EN_STATS,
	WMI_PDEV_PARAM_MU_GROUP_POLICY,
	WMI_PDEV_PARAM_NOISE_DETECTION,
	WMI_PDEV_PARAM_NOISE_THRESHOLD,
	WMI_PDEV_PARAM_DPD_ENABLE,
	WMI_PDEV_PARAM_SET_MCAST_BCAST_ECHO,
	WMI_PDEV_PARAM_ATF_STRICT_SCH,
	WMI_PDEV_PARAM_ATF_SCHED_DURATION,
	WMI_PDEV_PARAM_ANT_PLZN,
	WMI_PDEV_PARAM_MGMT_RETRY_LIMIT,
	WMI_PDEV_PARAM_SENSITIVITY_LEVEL,
	WMI_PDEV_PARAM_SIGNED_TXPOWER_2G,
	WMI_PDEV_PARAM_SIGNED_TXPOWER_5G,
	WMI_PDEV_PARAM_ENABLE_PER_TID_AMSDU,
	WMI_PDEV_PARAM_ENABLE_PER_TID_AMPDU,
	WMI_PDEV_PARAM_CCA_THRESHOLD,
	WMI_PDEV_PARAM_RTS_FIXED_RATE,
	WMI_PDEV_PARAM_PDEV_RESET,
	WMI_PDEV_PARAM_WAPI_MBSSID_OFFSET,
	WMI_PDEV_PARAM_ARP_DBG_SRCADDR,
	WMI_PDEV_PARAM_ARP_DBG_DSTADDR,
	WMI_PDEV_PARAM_ATF_OBSS_NOISE_SCH,
	WMI_PDEV_PARAM_ATF_OBSS_NOISE_SCALING_FACTOR,
	WMI_PDEV_PARAM_CUST_TXPOWER_SCALE,
	WMI_PDEV_PARAM_ATF_DYNAMIC_ENABLE,
	WMI_PDEV_PARAM_CTRL_RETRY_LIMIT,
	WMI_PDEV_PARAM_PROPAGATION_DELAY,
	WMI_PDEV_PARAM_ENA_ANT_DIV,
	WMI_PDEV_PARAM_FORCE_CHAIN_ANT,
	WMI_PDEV_PARAM_ANT_DIV_SELFTEST,
	WMI_PDEV_PARAM_ANT_DIV_SELFTEST_INTVL,
	WMI_PDEV_PARAM_STATS_OBSERVATION_PERIOD,
	WMI_PDEV_PARAM_TX_PPDU_DELAY_BIN_SIZE_MS,
	WMI_PDEV_PARAM_TX_PPDU_DELAY_ARRAY_LEN,
	WMI_PDEV_PARAM_TX_MPDU_AGGR_ARRAY_LEN,
	WMI_PDEV_PARAM_RX_MPDU_AGGR_ARRAY_LEN,
	WMI_PDEV_PARAM_TX_SCH_DELAY,
	WMI_PDEV_PARAM_ENABLE_RTS_SIFS_BURSTING,
	WMI_PDEV_PARAM_MAX_MPDUS_IN_AMPDU,
	WMI_PDEV_PARAM_PEER_STATS_INFO_ENABLE,
	WMI_PDEV_PARAM_FAST_PWR_TRANSITION,
	WMI_PDEV_PARAM_RADIO_CHAN_STATS_ENABLE,
	WMI_PDEV_PARAM_RADIO_DIAGNOSIS_ENABLE,
	WMI_PDEV_PARAM_MESH_MCAST_ENABLE,
	WMI_PDEV_PARAM_SET_CMD_OBSS_PD_THRESHOLD = 0xbc,
	WMI_PDEV_PARAM_SET_CMD_OBSS_PD_PER_AC = 0xbe,
	WMI_PDEV_PARAM_ENABLE_SR_PROHIBIT = 0xc6,
};

enum wmi_tlv_vdev_param {
	WMI_VDEV_PARAM_RTS_THRESHOLD = 0x1,
	WMI_VDEV_PARAM_FRAGMENTATION_THRESHOLD,
	WMI_VDEV_PARAM_BEACON_INTERVAL,
	WMI_VDEV_PARAM_LISTEN_INTERVAL,
	WMI_VDEV_PARAM_MULTICAST_RATE,
	WMI_VDEV_PARAM_MGMT_TX_RATE,
	WMI_VDEV_PARAM_SLOT_TIME,
	WMI_VDEV_PARAM_PREAMBLE,
	WMI_VDEV_PARAM_SWBA_TIME,
	WMI_VDEV_STATS_UPDATE_PERIOD,
	WMI_VDEV_PWRSAVE_AGEOUT_TIME,
	WMI_VDEV_HOST_SWBA_INTERVAL,
	WMI_VDEV_PARAM_DTIM_PERIOD,
	WMI_VDEV_OC_SCHEDULER_AIR_TIME_LIMIT,
	WMI_VDEV_PARAM_WDS,
	WMI_VDEV_PARAM_ATIM_WINDOW,
	WMI_VDEV_PARAM_BMISS_COUNT_MAX,
	WMI_VDEV_PARAM_BMISS_FIRST_BCNT,
	WMI_VDEV_PARAM_BMISS_FINAL_BCNT,
	WMI_VDEV_PARAM_FEATURE_WMM,
	WMI_VDEV_PARAM_CHWIDTH,
	WMI_VDEV_PARAM_CHEXTOFFSET,
	WMI_VDEV_PARAM_DISABLE_HTPROTECTION,
	WMI_VDEV_PARAM_STA_QUICKKICKOUT,
	WMI_VDEV_PARAM_MGMT_RATE,
	WMI_VDEV_PARAM_PROTECTION_MODE,
	WMI_VDEV_PARAM_FIXED_RATE,
	WMI_VDEV_PARAM_SGI,
	WMI_VDEV_PARAM_LDPC,
	WMI_VDEV_PARAM_TX_STBC,
	WMI_VDEV_PARAM_RX_STBC,
	WMI_VDEV_PARAM_INTRA_BSS_FWD,
	WMI_VDEV_PARAM_DEF_KEYID,
	WMI_VDEV_PARAM_NSS,
	WMI_VDEV_PARAM_BCAST_DATA_RATE,
	WMI_VDEV_PARAM_MCAST_DATA_RATE,
	WMI_VDEV_PARAM_MCAST_INDICATE,
	WMI_VDEV_PARAM_DHCP_INDICATE,
	WMI_VDEV_PARAM_UNKNOWN_DEST_INDICATE,
	WMI_VDEV_PARAM_AP_KEEPALIVE_MIN_IDLE_INACTIVE_TIME_SECS,
	WMI_VDEV_PARAM_AP_KEEPALIVE_MAX_IDLE_INACTIVE_TIME_SECS,
	WMI_VDEV_PARAM_AP_KEEPALIVE_MAX_UNRESPONSIVE_TIME_SECS,
	WMI_VDEV_PARAM_AP_ENABLE_NAWDS,
	WMI_VDEV_PARAM_ENABLE_RTSCTS,
	WMI_VDEV_PARAM_TXBF,
	WMI_VDEV_PARAM_PACKET_POWERSAVE,
	WMI_VDEV_PARAM_DROP_UNENCRY,
	WMI_VDEV_PARAM_TX_ENCAP_TYPE,
	WMI_VDEV_PARAM_AP_DETECT_OUT_OF_SYNC_SLEEPING_STA_TIME_SECS,
	WMI_VDEV_PARAM_EARLY_RX_ADJUST_ENABLE,
	WMI_VDEV_PARAM_EARLY_RX_TGT_BMISS_NUM,
	WMI_VDEV_PARAM_EARLY_RX_BMISS_SAMPLE_CYCLE,
	WMI_VDEV_PARAM_EARLY_RX_SLOP_STEP,
	WMI_VDEV_PARAM_EARLY_RX_INIT_SLOP,
	WMI_VDEV_PARAM_EARLY_RX_ADJUST_PAUSE,
	WMI_VDEV_PARAM_TX_PWRLIMIT,
	WMI_VDEV_PARAM_SNR_NUM_FOR_CAL,
	WMI_VDEV_PARAM_ROAM_FW_OFFLOAD,
	WMI_VDEV_PARAM_ENABLE_RMC,
	WMI_VDEV_PARAM_IBSS_MAX_BCN_LOST_MS,
	WMI_VDEV_PARAM_MAX_RATE,
	WMI_VDEV_PARAM_EARLY_RX_DRIFT_SAMPLE,
	WMI_VDEV_PARAM_SET_IBSS_TX_FAIL_CNT_THR,
	WMI_VDEV_PARAM_EBT_RESYNC_TIMEOUT,
	WMI_VDEV_PARAM_AGGR_TRIG_EVENT_ENABLE,
	WMI_VDEV_PARAM_IS_IBSS_POWER_SAVE_ALLOWED,
	WMI_VDEV_PARAM_IS_POWER_COLLAPSE_ALLOWED,
	WMI_VDEV_PARAM_IS_AWAKE_ON_TXRX_ENABLED,
	WMI_VDEV_PARAM_INACTIVITY_CNT,
	WMI_VDEV_PARAM_TXSP_END_INACTIVITY_TIME_MS,
	WMI_VDEV_PARAM_DTIM_POLICY,
	WMI_VDEV_PARAM_IBSS_PS_WARMUP_TIME_SECS,
	WMI_VDEV_PARAM_IBSS_PS_1RX_CHAIN_IN_ATIM_WINDOW_ENABLE,
	WMI_VDEV_PARAM_RX_LEAK_WINDOW,
	WMI_VDEV_PARAM_STATS_AVG_FACTOR,
	WMI_VDEV_PARAM_DISCONNECT_TH,
	WMI_VDEV_PARAM_RTSCTS_RATE,
	WMI_VDEV_PARAM_MCC_RTSCTS_PROTECTION_ENABLE,
	WMI_VDEV_PARAM_MCC_BROADCAST_PROBE_ENABLE,
	WMI_VDEV_PARAM_TXPOWER_SCALE,
	WMI_VDEV_PARAM_TXPOWER_SCALE_DECR_DB,
	WMI_VDEV_PARAM_MCAST2UCAST_SET,
	WMI_VDEV_PARAM_RC_NUM_RETRIES,
	WMI_VDEV_PARAM_CABQ_MAXDUR,
	WMI_VDEV_PARAM_MFPTEST_SET,
	WMI_VDEV_PARAM_RTS_FIXED_RATE,
	WMI_VDEV_PARAM_VHT_SGIMASK,
	WMI_VDEV_PARAM_VHT80_RATEMASK,
	WMI_VDEV_PARAM_PROXY_STA,
	WMI_VDEV_PARAM_VIRTUAL_CELL_MODE,
	WMI_VDEV_PARAM_RX_DECAP_TYPE,
	WMI_VDEV_PARAM_BW_NSS_RATEMASK,
	WMI_VDEV_PARAM_SENSOR_AP,
	WMI_VDEV_PARAM_BEACON_RATE,
	WMI_VDEV_PARAM_DTIM_ENABLE_CTS,
	WMI_VDEV_PARAM_STA_KICKOUT,
	WMI_VDEV_PARAM_CAPABILITIES,
	WMI_VDEV_PARAM_TSF_INCREMENT,
	WMI_VDEV_PARAM_AMPDU_PER_AC,
	WMI_VDEV_PARAM_RX_FILTER,
	WMI_VDEV_PARAM_MGMT_TX_POWER,
	WMI_VDEV_PARAM_NON_AGG_SW_RETRY_TH,
	WMI_VDEV_PARAM_AGG_SW_RETRY_TH,
	WMI_VDEV_PARAM_DISABLE_DYN_BW_RTS,
	WMI_VDEV_PARAM_ATF_SSID_SCHED_POLICY,
	WMI_VDEV_PARAM_HE_DCM,
	WMI_VDEV_PARAM_HE_RANGE_EXT,
	WMI_VDEV_PARAM_ENABLE_BCAST_PROBE_RESPONSE,
	WMI_VDEV_PARAM_FILS_MAX_CHANNEL_GUARD_TIME,
	WMI_VDEV_PARAM_HE_LTF = 0x74,
	WMI_VDEV_PARAM_ENABLE_DISABLE_RTT_RESPONDER_ROLE = 0x7d,
	WMI_VDEV_PARAM_BA_MODE = 0x7e,
	WMI_VDEV_PARAM_AUTORATE_MISC_CFG = 0x80,
	WMI_VDEV_PARAM_SET_HE_SOUNDING_MODE = 0x87,
	WMI_VDEV_PARAM_6GHZ_PARAMS = 0x99,
	WMI_VDEV_PARAM_PROTOTYPE = 0x8000,
	WMI_VDEV_PARAM_BSS_COLOR,
	WMI_VDEV_PARAM_SET_HEMU_MODE,
	WMI_VDEV_PARAM_HEOPS_0_31 = 0x8003,
};

enum wmi_tlv_peer_flags {
	WMI_TLV_PEER_AUTH = 0x00000001,
	WMI_TLV_PEER_QOS = 0x00000002,
	WMI_TLV_PEER_NEED_PTK_4_WAY = 0x00000004,
	WMI_TLV_PEER_NEED_GTK_2_WAY = 0x00000010,
	WMI_TLV_PEER_APSD = 0x00000800,
	WMI_TLV_PEER_HT = 0x00001000,
	WMI_TLV_PEER_40MHZ = 0x00002000,
	WMI_TLV_PEER_STBC = 0x00008000,
	WMI_TLV_PEER_LDPC = 0x00010000,
	WMI_TLV_PEER_DYN_MIMOPS = 0x00020000,
	WMI_TLV_PEER_STATIC_MIMOPS = 0x00040000,
	WMI_TLV_PEER_SPATIAL_MUX = 0x00200000,
	WMI_TLV_PEER_VHT = 0x02000000,
	WMI_TLV_PEER_80MHZ = 0x04000000,
	WMI_TLV_PEER_PMF = 0x08000000,
	WMI_PEER_IS_P2P_CAPABLE = 0x20000000,
	WMI_PEER_160MHZ         = 0x40000000,
	WMI_PEER_SAFEMODE_EN    = 0x80000000,

};

/** Enum list of TLV Tags for each parameter structure type. */
enum wmi_tlv_tag {
	WMI_TAG_LAST_RESERVED = 15,
	WMI_TAG_FIRST_ARRAY_ENUM,
	WMI_TAG_ARRAY_UINT32 = WMI_TAG_FIRST_ARRAY_ENUM,
	WMI_TAG_ARRAY_BYTE,
	WMI_TAG_ARRAY_STRUCT,
	WMI_TAG_ARRAY_FIXED_STRUCT,
	WMI_TAG_LAST_ARRAY_ENUM = 31,
	WMI_TAG_SERVICE_READY_EVENT,
	WMI_TAG_HAL_REG_CAPABILITIES,
	WMI_TAG_WLAN_HOST_MEM_REQ,
	WMI_TAG_READY_EVENT,
	WMI_TAG_SCAN_EVENT,
	WMI_TAG_PDEV_TPC_CONFIG_EVENT,
	WMI_TAG_CHAN_INFO_EVENT,
	WMI_TAG_COMB_PHYERR_RX_HDR,
	WMI_TAG_VDEV_START_RESPONSE_EVENT,
	WMI_TAG_VDEV_STOPPED_EVENT,
	WMI_TAG_VDEV_INSTALL_KEY_COMPLETE_EVENT,
	WMI_TAG_PEER_STA_KICKOUT_EVENT,
	WMI_TAG_MGMT_RX_HDR,
	WMI_TAG_TBTT_OFFSET_EVENT,
	WMI_TAG_TX_DELBA_COMPLETE_EVENT,
	WMI_TAG_TX_ADDBA_COMPLETE_EVENT,
	WMI_TAG_ROAM_EVENT,
	WMI_TAG_WOW_EVENT_INFO,
	WMI_TAG_WOW_EVENT_INFO_SECTION_BITMAP,
	WMI_TAG_RTT_EVENT_HEADER,
	WMI_TAG_RTT_ERROR_REPORT_EVENT,
	WMI_TAG_RTT_MEAS_EVENT,
	WMI_TAG_ECHO_EVENT,
	WMI_TAG_FTM_INTG_EVENT,
	WMI_TAG_VDEV_GET_KEEPALIVE_EVENT,
	WMI_TAG_GPIO_INPUT_EVENT,
	WMI_TAG_CSA_EVENT,
	WMI_TAG_GTK_OFFLOAD_STATUS_EVENT,
	WMI_TAG_IGTK_INFO,
	WMI_TAG_DCS_INTERFERENCE_EVENT,
	WMI_TAG_ATH_DCS_CW_INT,
	WMI_TAG_WLAN_DCS_CW_INT = /* ALIAS */
		WMI_TAG_ATH_DCS_CW_INT,
	WMI_TAG_ATH_DCS_WLAN_INT_STAT,
	WMI_TAG_WLAN_DCS_IM_TGT_STATS_T = /* ALIAS */
		WMI_TAG_ATH_DCS_WLAN_INT_STAT,
	WMI_TAG_WLAN_PROFILE_CTX_T,
	WMI_TAG_WLAN_PROFILE_T,
	WMI_TAG_PDEV_QVIT_EVENT,
	WMI_TAG_HOST_SWBA_EVENT,
	WMI_TAG_TIM_INFO,
	WMI_TAG_P2P_NOA_INFO,
	WMI_TAG_STATS_EVENT,
	WMI_TAG_AVOID_FREQ_RANGES_EVENT,
	WMI_TAG_AVOID_FREQ_RANGE_DESC,
	WMI_TAG_GTK_REKEY_FAIL_EVENT,
	WMI_TAG_INIT_CMD,
	WMI_TAG_RESOURCE_CONFIG,
	WMI_TAG_WLAN_HOST_MEMORY_CHUNK,
	WMI_TAG_START_SCAN_CMD,
	WMI_TAG_STOP_SCAN_CMD,
	WMI_TAG_SCAN_CHAN_LIST_CMD,
	WMI_TAG_CHANNEL,
	WMI_TAG_PDEV_SET_REGDOMAIN_CMD,
	WMI_TAG_PDEV_SET_PARAM_CMD,
	WMI_TAG_PDEV_SET_WMM_PARAMS_CMD,
	WMI_TAG_WMM_PARAMS,
	WMI_TAG_PDEV_SET_QUIET_CMD,
	WMI_TAG_VDEV_CREATE_CMD,
	WMI_TAG_VDEV_DELETE_CMD,
	WMI_TAG_VDEV_START_REQUEST_CMD,
	WMI_TAG_P2P_NOA_DESCRIPTOR,
	WMI_TAG_P2P_GO_SET_BEACON_IE,
	WMI_TAG_GTK_OFFLOAD_CMD,
	WMI_TAG_VDEV_UP_CMD,
	WMI_TAG_VDEV_STOP_CMD,
	WMI_TAG_VDEV_DOWN_CMD,
	WMI_TAG_VDEV_SET_PARAM_CMD,
	WMI_TAG_VDEV_INSTALL_KEY_CMD,
	WMI_TAG_PEER_CREATE_CMD,
	WMI_TAG_PEER_DELETE_CMD,
	WMI_TAG_PEER_FLUSH_TIDS_CMD,
	WMI_TAG_PEER_SET_PARAM_CMD,
	WMI_TAG_PEER_ASSOC_COMPLETE_CMD,
	WMI_TAG_VHT_RATE_SET,
	WMI_TAG_BCN_TMPL_CMD,
	WMI_TAG_PRB_TMPL_CMD,
	WMI_TAG_BCN_PRB_INFO,
	WMI_TAG_PEER_TID_ADDBA_CMD,
	WMI_TAG_PEER_TID_DELBA_CMD,
	WMI_TAG_STA_POWERSAVE_MODE_CMD,
	WMI_TAG_STA_POWERSAVE_PARAM_CMD,
	WMI_TAG_STA_DTIM_PS_METHOD_CMD,
	WMI_TAG_ROAM_SCAN_MODE,
	WMI_TAG_ROAM_SCAN_RSSI_THRESHOLD,
	WMI_TAG_ROAM_SCAN_PERIOD,
	WMI_TAG_ROAM_SCAN_RSSI_CHANGE_THRESHOLD,
	WMI_TAG_PDEV_SUSPEND_CMD,
	WMI_TAG_PDEV_RESUME_CMD,
	WMI_TAG_ADD_BCN_FILTER_CMD,
	WMI_TAG_RMV_BCN_FILTER_CMD,
	WMI_TAG_WOW_ENABLE_CMD,
	WMI_TAG_WOW_HOSTWAKEUP_FROM_SLEEP_CMD,
	WMI_TAG_STA_UAPSD_AUTO_TRIG_CMD,
	WMI_TAG_STA_UAPSD_AUTO_TRIG_PARAM,
	WMI_TAG_SET_ARP_NS_OFFLOAD_CMD,
	WMI_TAG_ARP_OFFLOAD_TUPLE,
	WMI_TAG_NS_OFFLOAD_TUPLE,
	WMI_TAG_FTM_INTG_CMD,
	WMI_TAG_STA_KEEPALIVE_CMD,
	WMI_TAG_STA_KEEPALIVE_ARP_RESPONSE,
	WMI_TAG_P2P_SET_VENDOR_IE_DATA_CMD,
	WMI_TAG_AP_PS_PEER_CMD,
	WMI_TAG_PEER_RATE_RETRY_SCHED_CMD,
	WMI_TAG_WLAN_PROFILE_TRIGGER_CMD,
	WMI_TAG_WLAN_PROFILE_SET_HIST_INTVL_CMD,
	WMI_TAG_WLAN_PROFILE_GET_PROF_DATA_CMD,
	WMI_TAG_WLAN_PROFILE_ENABLE_PROFILE_ID_CMD,
	WMI_TAG_WOW_DEL_PATTERN_CMD,
	WMI_TAG_WOW_ADD_DEL_EVT_CMD,
	WMI_TAG_RTT_MEASREQ_HEAD,
	WMI_TAG_RTT_MEASREQ_BODY,
	WMI_TAG_RTT_TSF_CMD,
	WMI_TAG_VDEV_SPECTRAL_CONFIGURE_CMD,
	WMI_TAG_VDEV_SPECTRAL_ENABLE_CMD,
	WMI_TAG_REQUEST_STATS_CMD,
	WMI_TAG_NLO_CONFIG_CMD,
	WMI_TAG_NLO_CONFIGURED_PARAMETERS,
	WMI_TAG_CSA_OFFLOAD_ENABLE_CMD,
	WMI_TAG_CSA_OFFLOAD_CHANSWITCH_CMD,
	WMI_TAG_CHATTER_SET_MODE_CMD,
	WMI_TAG_ECHO_CMD,
	WMI_TAG_VDEV_SET_KEEPALIVE_CMD,
	WMI_TAG_VDEV_GET_KEEPALIVE_CMD,
	WMI_TAG_FORCE_FW_HANG_CMD,
	WMI_TAG_GPIO_CONFIG_CMD,
	WMI_TAG_GPIO_OUTPUT_CMD,
	WMI_TAG_PEER_ADD_WDS_ENTRY_CMD,
	WMI_TAG_PEER_REMOVE_WDS_ENTRY_CMD,
	WMI_TAG_BCN_TX_HDR,
	WMI_TAG_BCN_SEND_FROM_HOST_CMD,
	WMI_TAG_MGMT_TX_HDR,
	WMI_TAG_ADDBA_CLEAR_RESP_CMD,
	WMI_TAG_ADDBA_SEND_CMD,
	WMI_TAG_DELBA_SEND_CMD,
	WMI_TAG_ADDBA_SETRESPONSE_CMD,
	WMI_TAG_SEND_SINGLEAMSDU_CMD,
	WMI_TAG_PDEV_PKTLOG_ENABLE_CMD,
	WMI_TAG_PDEV_PKTLOG_DISABLE_CMD,
	WMI_TAG_PDEV_SET_HT_IE_CMD,
	WMI_TAG_PDEV_SET_VHT_IE_CMD,
	WMI_TAG_PDEV_SET_DSCP_TID_MAP_CMD,
	WMI_TAG_PDEV_GREEN_AP_PS_ENABLE_CMD,
	WMI_TAG_PDEV_GET_TPC_CONFIG_CMD,
	WMI_TAG_PDEV_SET_BASE_MACADDR_CMD,
	WMI_TAG_PEER_MCAST_GROUP_CMD,
	WMI_TAG_ROAM_AP_PROFILE,
	WMI_TAG_AP_PROFILE,
	WMI_TAG_SCAN_SCH_PRIORITY_TABLE_CMD,
	WMI_TAG_PDEV_DFS_ENABLE_CMD,
	WMI_TAG_PDEV_DFS_DISABLE_CMD,
	WMI_TAG_WOW_ADD_PATTERN_CMD,
	WMI_TAG_WOW_BITMAP_PATTERN_T,
	WMI_TAG_WOW_IPV4_SYNC_PATTERN_T,
	WMI_TAG_WOW_IPV6_SYNC_PATTERN_T,
	WMI_TAG_WOW_MAGIC_PATTERN_CMD,
	WMI_TAG_SCAN_UPDATE_REQUEST_CMD,
	WMI_TAG_CHATTER_PKT_COALESCING_FILTER,
	WMI_TAG_CHATTER_COALESCING_ADD_FILTER_CMD,
	WMI_TAG_CHATTER_COALESCING_DELETE_FILTER_CMD,
	WMI_TAG_CHATTER_COALESCING_QUERY_CMD,
	WMI_TAG_TXBF_CMD,
	WMI_TAG_DEBUG_LOG_CONFIG_CMD,
	WMI_TAG_NLO_EVENT,
	WMI_TAG_CHATTER_QUERY_REPLY_EVENT,
	WMI_TAG_UPLOAD_H_HDR,
	WMI_TAG_CAPTURE_H_EVENT_HDR,
	WMI_TAG_VDEV_WNM_SLEEPMODE_CMD,
	WMI_TAG_VDEV_IPSEC_NATKEEPALIVE_FILTER_CMD,
	WMI_TAG_VDEV_WMM_ADDTS_CMD,
	WMI_TAG_VDEV_WMM_DELTS_CMD,
	WMI_TAG_VDEV_SET_WMM_PARAMS_CMD,
	WMI_TAG_TDLS_SET_STATE_CMD,
	WMI_TAG_TDLS_PEER_UPDATE_CMD,
	WMI_TAG_TDLS_PEER_EVENT,
	WMI_TAG_TDLS_PEER_CAPABILITIES,
	WMI_TAG_VDEV_MCC_SET_TBTT_MODE_CMD,
	WMI_TAG_ROAM_CHAN_LIST,
	WMI_TAG_VDEV_MCC_BCN_INTVL_CHANGE_EVENT,
	WMI_TAG_RESMGR_ADAPTIVE_OCS_ENABLE_DISABLE_CMD,
	WMI_TAG_RESMGR_SET_CHAN_TIME_QUOTA_CMD,
	WMI_TAG_RESMGR_SET_CHAN_LATENCY_CMD,
	WMI_TAG_BA_REQ_SSN_CMD,
	WMI_TAG_BA_RSP_SSN_EVENT,
	WMI_TAG_STA_SMPS_FORCE_MODE_CMD,
	WMI_TAG_SET_MCASTBCAST_FILTER_CMD,
	WMI_TAG_P2P_SET_OPPPS_CMD,
	WMI_TAG_P2P_SET_NOA_CMD,
	WMI_TAG_BA_REQ_SSN_CMD_SUB_STRUCT_PARAM,
	WMI_TAG_BA_REQ_SSN_EVENT_SUB_STRUCT_PARAM,
	WMI_TAG_STA_SMPS_PARAM_CMD,
	WMI_TAG_VDEV_SET_GTX_PARAMS_CMD,
	WMI_TAG_MCC_SCHED_TRAFFIC_STATS_CMD,
	WMI_TAG_MCC_SCHED_STA_TRAFFIC_STATS,
	WMI_TAG_OFFLOAD_BCN_TX_STATUS_EVENT,
	WMI_TAG_P2P_NOA_EVENT,
	WMI_TAG_HB_SET_ENABLE_CMD,
	WMI_TAG_HB_SET_TCP_PARAMS_CMD,
	WMI_TAG_HB_SET_TCP_PKT_FILTER_CMD,
	WMI_TAG_HB_SET_UDP_PARAMS_CMD,
	WMI_TAG_HB_SET_UDP_PKT_FILTER_CMD,
	WMI_TAG_HB_IND_EVENT,
	WMI_TAG_TX_PAUSE_EVENT,
	WMI_TAG_RFKILL_EVENT,
	WMI_TAG_DFS_RADAR_EVENT,
	WMI_TAG_DFS_PHYERR_FILTER_ENA_CMD,
	WMI_TAG_DFS_PHYERR_FILTER_DIS_CMD,
	WMI_TAG_BATCH_SCAN_RESULT_SCAN_LIST,
	WMI_TAG_BATCH_SCAN_RESULT_NETWORK_INFO,
	WMI_TAG_BATCH_SCAN_ENABLE_CMD,
	WMI_TAG_BATCH_SCAN_DISABLE_CMD,
	WMI_TAG_BATCH_SCAN_TRIGGER_RESULT_CMD,
	WMI_TAG_BATCH_SCAN_ENABLED_EVENT,
	WMI_TAG_BATCH_SCAN_RESULT_EVENT,
	WMI_TAG_VDEV_PLMREQ_START_CMD,
	WMI_TAG_VDEV_PLMREQ_STOP_CMD,
	WMI_TAG_THERMAL_MGMT_CMD,
	WMI_TAG_THERMAL_MGMT_EVENT,
	WMI_TAG_PEER_INFO_REQ_CMD,
	WMI_TAG_PEER_INFO_EVENT,
	WMI_TAG_PEER_INFO,
	WMI_TAG_PEER_TX_FAIL_CNT_THR_EVENT,
	WMI_TAG_RMC_SET_MODE_CMD,
	WMI_TAG_RMC_SET_ACTION_PERIOD_CMD,
	WMI_TAG_RMC_CONFIG_CMD,
	WMI_TAG_MHF_OFFLOAD_SET_MODE_CMD,
	WMI_TAG_MHF_OFFLOAD_PLUMB_ROUTING_TABLE_CMD,
	WMI_TAG_ADD_PROACTIVE_ARP_RSP_PATTERN_CMD,
	WMI_TAG_DEL_PROACTIVE_ARP_RSP_PATTERN_CMD,
	WMI_TAG_NAN_CMD_PARAM,
	WMI_TAG_NAN_EVENT_HDR,
	WMI_TAG_PDEV_L1SS_TRACK_EVENT,
	WMI_TAG_DIAG_DATA_CONTAINER_EVENT,
	WMI_TAG_MODEM_POWER_STATE_CMD_PARAM,
	WMI_TAG_PEER_GET_ESTIMATED_LINKSPEED_CMD,
	WMI_TAG_PEER_ESTIMATED_LINKSPEED_EVENT,
	WMI_TAG_AGGR_STATE_TRIG_EVENT,
	WMI_TAG_MHF_OFFLOAD_ROUTING_TABLE_ENTRY,
	WMI_TAG_ROAM_SCAN_CMD,
	WMI_TAG_REQ_STATS_EXT_CMD,
	WMI_TAG_STATS_EXT_EVENT,
	WMI_TAG_OBSS_SCAN_ENABLE_CMD,
	WMI_TAG_OBSS_SCAN_DISABLE_CMD,
	WMI_TAG_OFFLOAD_PRB_RSP_TX_STATUS_EVENT,
	WMI_TAG_PDEV_SET_LED_CONFIG_CMD,
	WMI_TAG_HOST_AUTO_SHUTDOWN_CFG_CMD,
	WMI_TAG_HOST_AUTO_SHUTDOWN_EVENT,
	WMI_TAG_UPDATE_WHAL_MIB_STATS_EVENT,
	WMI_TAG_CHAN_AVOID_UPDATE_CMD_PARAM,
	WMI_TAG_WOW_IOAC_PKT_PATTERN_T,
	WMI_TAG_WOW_IOAC_TMR_PATTERN_T,
	WMI_TAG_WOW_IOAC_ADD_KEEPALIVE_CMD,
	WMI_TAG_WOW_IOAC_DEL_KEEPALIVE_CMD,
	WMI_TAG_WOW_IOAC_KEEPALIVE_T,
	WMI_TAG_WOW_IOAC_ADD_PATTERN_CMD,
	WMI_TAG_WOW_IOAC_DEL_PATTERN_CMD,
	WMI_TAG_START_LINK_STATS_CMD,
	WMI_TAG_CLEAR_LINK_STATS_CMD,
	WMI_TAG_REQUEST_LINK_STATS_CMD,
	WMI_TAG_IFACE_LINK_STATS_EVENT,
	WMI_TAG_RADIO_LINK_STATS_EVENT,
	WMI_TAG_PEER_STATS_EVENT,
	WMI_TAG_CHANNEL_STATS,
	WMI_TAG_RADIO_LINK_STATS,
	WMI_TAG_RATE_STATS,
	WMI_TAG_PEER_LINK_STATS,
	WMI_TAG_WMM_AC_STATS,
	WMI_TAG_IFACE_LINK_STATS,
	WMI_TAG_LPI_MGMT_SNOOPING_CONFIG_CMD,
	WMI_TAG_LPI_START_SCAN_CMD,
	WMI_TAG_LPI_STOP_SCAN_CMD,
	WMI_TAG_LPI_RESULT_EVENT,
	WMI_TAG_PEER_STATE_EVENT,
	WMI_TAG_EXTSCAN_BUCKET_CMD,
	WMI_TAG_EXTSCAN_BUCKET_CHANNEL_EVENT,
	WMI_TAG_EXTSCAN_START_CMD,
	WMI_TAG_EXTSCAN_STOP_CMD,
	WMI_TAG_EXTSCAN_CONFIGURE_WLAN_CHANGE_MONITOR_CMD,
	WMI_TAG_EXTSCAN_WLAN_CHANGE_BSSID_PARAM_CMD,
	WMI_TAG_EXTSCAN_CONFIGURE_HOTLIST_MONITOR_CMD,
	WMI_TAG_EXTSCAN_GET_CACHED_RESULTS_CMD,
	WMI_TAG_EXTSCAN_GET_WLAN_CHANGE_RESULTS_CMD,
	WMI_TAG_EXTSCAN_SET_CAPABILITIES_CMD,
	WMI_TAG_EXTSCAN_GET_CAPABILITIES_CMD,
	WMI_TAG_EXTSCAN_OPERATION_EVENT,
	WMI_TAG_EXTSCAN_START_STOP_EVENT,
	WMI_TAG_EXTSCAN_TABLE_USAGE_EVENT,
	WMI_TAG_EXTSCAN_WLAN_DESCRIPTOR_EVENT,
	WMI_TAG_EXTSCAN_RSSI_INFO_EVENT,
	WMI_TAG_EXTSCAN_CACHED_RESULTS_EVENT,
	WMI_TAG_EXTSCAN_WLAN_CHANGE_RESULTS_EVENT,
	WMI_TAG_EXTSCAN_WLAN_CHANGE_RESULT_BSSID_EVENT,
	WMI_TAG_EXTSCAN_HOTLIST_MATCH_EVENT,
	WMI_TAG_EXTSCAN_CAPABILITIES_EVENT,
	WMI_TAG_EXTSCAN_CACHE_CAPABILITIES_EVENT,
	WMI_TAG_EXTSCAN_WLAN_CHANGE_MONITOR_CAPABILITIES_EVENT,
	WMI_TAG_EXTSCAN_HOTLIST_MONITOR_CAPABILITIES_EVENT,
	WMI_TAG_D0_WOW_ENABLE_DISABLE_CMD,
	WMI_TAG_D0_WOW_DISABLE_ACK_EVENT,
	WMI_TAG_UNIT_TEST_CMD,
	WMI_TAG_ROAM_OFFLOAD_TLV_PARAM,
	WMI_TAG_ROAM_11I_OFFLOAD_TLV_PARAM,
	WMI_TAG_ROAM_11R_OFFLOAD_TLV_PARAM,
	WMI_TAG_ROAM_ESE_OFFLOAD_TLV_PARAM,
	WMI_TAG_ROAM_SYNCH_EVENT,
	WMI_TAG_ROAM_SYNCH_COMPLETE,
	WMI_TAG_EXTWOW_ENABLE_CMD,
	WMI_TAG_EXTWOW_SET_APP_TYPE1_PARAMS_CMD,
	WMI_TAG_EXTWOW_SET_APP_TYPE2_PARAMS_CMD,
	WMI_TAG_LPI_STATUS_EVENT,
	WMI_TAG_LPI_HANDOFF_EVENT,
	WMI_TAG_VDEV_RATE_STATS_EVENT,
	WMI_TAG_VDEV_RATE_HT_INFO,
	WMI_TAG_RIC_REQUEST,
	WMI_TAG_PDEV_GET_TEMPERATURE_CMD,
	WMI_TAG_PDEV_TEMPERATURE_EVENT,
	WMI_TAG_SET_DHCP_SERVER_OFFLOAD_CMD,
	WMI_TAG_TPC_CHAINMASK_CONFIG_CMD,
	WMI_TAG_RIC_TSPEC,
	WMI_TAG_TPC_CHAINMASK_CONFIG,
	WMI_TAG_IPA_OFFLOAD_ENABLE_DISABLE_CMD,
	WMI_TAG_SCAN_PROB_REQ_OUI_CMD,
	WMI_TAG_KEY_MATERIAL,
	WMI_TAG_TDLS_SET_OFFCHAN_MODE_CMD,
	WMI_TAG_SET_LED_FLASHING_CMD,
	WMI_TAG_MDNS_OFFLOAD_CMD,
	WMI_TAG_MDNS_SET_FQDN_CMD,
	WMI_TAG_MDNS_SET_RESP_CMD,
	WMI_TAG_MDNS_GET_STATS_CMD,
	WMI_TAG_MDNS_STATS_EVENT,
	WMI_TAG_ROAM_INVOKE_CMD,
	WMI_TAG_PDEV_RESUME_EVENT,
	WMI_TAG_PDEV_SET_ANTENNA_DIVERSITY_CMD,
	WMI_TAG_SAP_OFL_ENABLE_CMD,
	WMI_TAG_SAP_OFL_ADD_STA_EVENT,
	WMI_TAG_SAP_OFL_DEL_STA_EVENT,
	WMI_TAG_APFIND_CMD_PARAM,
	WMI_TAG_APFIND_EVENT_HDR,
	WMI_TAG_OCB_SET_SCHED_CMD,
	WMI_TAG_OCB_SET_SCHED_EVENT,
	WMI_TAG_OCB_SET_CONFIG_CMD,
	WMI_TAG_OCB_SET_CONFIG_RESP_EVENT,
	WMI_TAG_OCB_SET_UTC_TIME_CMD,
	WMI_TAG_OCB_START_TIMING_ADVERT_CMD,
	WMI_TAG_OCB_STOP_TIMING_ADVERT_CMD,
	WMI_TAG_OCB_GET_TSF_TIMER_CMD,
	WMI_TAG_OCB_GET_TSF_TIMER_RESP_EVENT,
	WMI_TAG_DCC_GET_STATS_CMD,
	WMI_TAG_DCC_CHANNEL_STATS_REQUEST,
	WMI_TAG_DCC_GET_STATS_RESP_EVENT,
	WMI_TAG_DCC_CLEAR_STATS_CMD,
	WMI_TAG_DCC_UPDATE_NDL_CMD,
	WMI_TAG_DCC_UPDATE_NDL_RESP_EVENT,
	WMI_TAG_DCC_STATS_EVENT,
	WMI_TAG_OCB_CHANNEL,
	WMI_TAG_OCB_SCHEDULE_ELEMENT,
	WMI_TAG_DCC_NDL_STATS_PER_CHANNEL,
	WMI_TAG_DCC_NDL_CHAN,
	WMI_TAG_QOS_PARAMETER,
	WMI_TAG_DCC_NDL_ACTIVE_STATE_CONFIG,
	WMI_TAG_ROAM_SCAN_EXTENDED_THRESHOLD_PARAM,
	WMI_TAG_ROAM_FILTER,
	WMI_TAG_PASSPOINT_CONFIG_CMD,
	WMI_TAG_PASSPOINT_EVENT_HDR,
	WMI_TAG_EXTSCAN_CONFIGURE_HOTLIST_SSID_MONITOR_CMD,
	WMI_TAG_EXTSCAN_HOTLIST_SSID_MATCH_EVENT,
	WMI_TAG_VDEV_TSF_TSTAMP_ACTION_CMD,
	WMI_TAG_VDEV_TSF_REPORT_EVENT,
	WMI_TAG_GET_FW_MEM_DUMP,
	WMI_TAG_UPDATE_FW_MEM_DUMP,
	WMI_TAG_FW_MEM_DUMP_PARAMS,
	WMI_TAG_DEBUG_MESG_FLUSH,
	WMI_TAG_DEBUG_MESG_FLUSH_COMPLETE,
	WMI_TAG_PEER_SET_RATE_REPORT_CONDITION,
	WMI_TAG_ROAM_SUBNET_CHANGE_CONFIG,
	WMI_TAG_VDEV_SET_IE_CMD,
	WMI_TAG_RSSI_BREACH_MONITOR_CONFIG,
	WMI_TAG_RSSI_BREACH_EVENT,
	WMI_TAG_WOW_EVENT_INITIAL_WAKEUP,
	WMI_TAG_SOC_SET_PCL_CMD,
	WMI_TAG_SOC_SET_HW_MODE_CMD,
	WMI_TAG_SOC_SET_HW_MODE_RESPONSE_EVENT,
	WMI_TAG_SOC_HW_MODE_TRANSITION_EVENT,
	WMI_TAG_VDEV_TXRX_STREAMS,
	WMI_TAG_SOC_SET_HW_MODE_RESPONSE_VDEV_MAC_ENTRY,
	WMI_TAG_SOC_SET_DUAL_MAC_CONFIG_CMD,
	WMI_TAG_SOC_SET_DUAL_MAC_CONFIG_RESPONSE_EVENT,
	WMI_TAG_WOW_IOAC_SOCK_PATTERN_T,
	WMI_TAG_WOW_ENABLE_ICMPV6_NA_FLT_CMD,
	WMI_TAG_DIAG_EVENT_LOG_CONFIG,
	WMI_TAG_DIAG_EVENT_LOG_SUPPORTED_EVENT_FIXED_PARAMS,
	WMI_TAG_PACKET_FILTER_CONFIG,
	WMI_TAG_PACKET_FILTER_ENABLE,
	WMI_TAG_SAP_SET_BLACKLIST_PARAM_CMD,
	WMI_TAG_MGMT_TX_SEND_CMD,
	WMI_TAG_MGMT_TX_COMPL_EVENT,
	WMI_TAG_SOC_SET_ANTENNA_MODE_CMD,
	WMI_TAG_WOW_UDP_SVC_OFLD_CMD,
	WMI_TAG_LRO_INFO_CMD,
	WMI_TAG_ROAM_EARLYSTOP_RSSI_THRES_PARAM,
	WMI_TAG_SERVICE_READY_EXT_EVENT,
	WMI_TAG_MAWC_SENSOR_REPORT_IND_CMD,
	WMI_TAG_MAWC_ENABLE_SENSOR_EVENT,
	WMI_TAG_ROAM_CONFIGURE_MAWC_CMD,
	WMI_TAG_NLO_CONFIGURE_MAWC_CMD,
	WMI_TAG_EXTSCAN_CONFIGURE_MAWC_CMD,
	WMI_TAG_PEER_ASSOC_CONF_EVENT,
	WMI_TAG_WOW_HOSTWAKEUP_GPIO_PIN_PATTERN_CONFIG_CMD,
	WMI_TAG_AP_PS_EGAP_PARAM_CMD,
	WMI_TAG_AP_PS_EGAP_INFO_EVENT,
	WMI_TAG_PMF_OFFLOAD_SET_SA_QUERY_CMD,
	WMI_TAG_TRANSFER_DATA_TO_FLASH_CMD,
	WMI_TAG_TRANSFER_DATA_TO_FLASH_COMPLETE_EVENT,
	WMI_TAG_SCPC_EVENT,
	WMI_TAG_AP_PS_EGAP_INFO_CHAINMASK_LIST,
	WMI_TAG_STA_SMPS_FORCE_MODE_COMPLETE_EVENT,
	WMI_TAG_BPF_GET_CAPABILITY_CMD,
	WMI_TAG_BPF_CAPABILITY_INFO_EVT,
	WMI_TAG_BPF_GET_VDEV_STATS_CMD,
	WMI_TAG_BPF_VDEV_STATS_INFO_EVT,
	WMI_TAG_BPF_SET_VDEV_INSTRUCTIONS_CMD,
	WMI_TAG_BPF_DEL_VDEV_INSTRUCTIONS_CMD,
	WMI_TAG_VDEV_DELETE_RESP_EVENT,
	WMI_TAG_PEER_DELETE_RESP_EVENT,
	WMI_TAG_ROAM_DENSE_THRES_PARAM,
	WMI_TAG_ENLO_CANDIDATE_SCORE_PARAM,
	WMI_TAG_PEER_UPDATE_WDS_ENTRY_CMD,
	WMI_TAG_VDEV_CONFIG_RATEMASK,
	WMI_TAG_PDEV_FIPS_CMD,
	WMI_TAG_PDEV_SMART_ANT_ENABLE_CMD,
	WMI_TAG_PDEV_SMART_ANT_SET_RX_ANTENNA_CMD,
	WMI_TAG_PEER_SMART_ANT_SET_TX_ANTENNA_CMD,
	WMI_TAG_PEER_SMART_ANT_SET_TRAIN_ANTENNA_CMD,
	WMI_TAG_PEER_SMART_ANT_SET_NODE_CONFIG_OPS_CMD,
	WMI_TAG_PDEV_SET_ANT_SWITCH_TBL_CMD,
	WMI_TAG_PDEV_SET_CTL_TABLE_CMD,
	WMI_TAG_PDEV_SET_MIMOGAIN_TABLE_CMD,
	WMI_TAG_FWTEST_SET_PARAM_CMD,
	WMI_TAG_PEER_ATF_REQUEST,
	WMI_TAG_VDEV_ATF_REQUEST,
	WMI_TAG_PDEV_GET_ANI_CCK_CONFIG_CMD,
	WMI_TAG_PDEV_GET_ANI_OFDM_CONFIG_CMD,
	WMI_TAG_INST_RSSI_STATS_RESP,
	WMI_TAG_MED_UTIL_REPORT_EVENT,
	WMI_TAG_PEER_STA_PS_STATECHANGE_EVENT,
	WMI_TAG_WDS_ADDR_EVENT,
	WMI_TAG_PEER_RATECODE_LIST_EVENT,
	WMI_TAG_PDEV_NFCAL_POWER_ALL_CHANNELS_EVENT,
	WMI_TAG_PDEV_TPC_EVENT,
	WMI_TAG_ANI_OFDM_EVENT,
	WMI_TAG_ANI_CCK_EVENT,
	WMI_TAG_PDEV_CHANNEL_HOPPING_EVENT,
	WMI_TAG_PDEV_FIPS_EVENT,
	WMI_TAG_ATF_PEER_INFO,
	WMI_TAG_PDEV_GET_TPC_CMD,
	WMI_TAG_VDEV_FILTER_NRP_CONFIG_CMD,
	WMI_TAG_QBOOST_CFG_CMD,
	WMI_TAG_PDEV_SMART_ANT_GPIO_HANDLE,
	WMI_TAG_PEER_SMART_ANT_SET_TX_ANTENNA_SERIES,
	WMI_TAG_PEER_SMART_ANT_SET_TRAIN_ANTENNA_PARAM,
	WMI_TAG_PDEV_SET_ANT_CTRL_CHAIN,
	WMI_TAG_PEER_CCK_OFDM_RATE_INFO,
	WMI_TAG_PEER_MCS_RATE_INFO,
	WMI_TAG_PDEV_NFCAL_POWER_ALL_CHANNELS_NFDBR,
	WMI_TAG_PDEV_NFCAL_POWER_ALL_CHANNELS_NFDBM,
	WMI_TAG_PDEV_NFCAL_POWER_ALL_CHANNELS_FREQNUM,
	WMI_TAG_MU_REPORT_TOTAL_MU,
	WMI_TAG_VDEV_SET_DSCP_TID_MAP_CMD,
	WMI_TAG_ROAM_SET_MBO,
	WMI_TAG_MIB_STATS_ENABLE_CMD,
	WMI_TAG_NAN_DISC_IFACE_CREATED_EVENT,
	WMI_TAG_NAN_DISC_IFACE_DELETED_EVENT,
	WMI_TAG_NAN_STARTED_CLUSTER_EVENT,
	WMI_TAG_NAN_JOINED_CLUSTER_EVENT,
	WMI_TAG_NDI_GET_CAP_REQ,
	WMI_TAG_NDP_INITIATOR_REQ,
	WMI_TAG_NDP_RESPONDER_REQ,
	WMI_TAG_NDP_END_REQ,
	WMI_TAG_NDI_CAP_RSP_EVENT,
	WMI_TAG_NDP_INITIATOR_RSP_EVENT,
	WMI_TAG_NDP_RESPONDER_RSP_EVENT,
	WMI_TAG_NDP_END_RSP_EVENT,
	WMI_TAG_NDP_INDICATION_EVENT,
	WMI_TAG_NDP_CONFIRM_EVENT,
	WMI_TAG_NDP_END_INDICATION_EVENT,
	WMI_TAG_VDEV_SET_QUIET_CMD,
	WMI_TAG_PDEV_SET_PCL_CMD,
	WMI_TAG_PDEV_SET_HW_MODE_CMD,
	WMI_TAG_PDEV_SET_MAC_CONFIG_CMD,
	WMI_TAG_PDEV_SET_ANTENNA_MODE_CMD,
	WMI_TAG_PDEV_SET_HW_MODE_RESPONSE_EVENT,
	WMI_TAG_PDEV_HW_MODE_TRANSITION_EVENT,
	WMI_TAG_PDEV_SET_HW_MODE_RESPONSE_VDEV_MAC_ENTRY,
	WMI_TAG_PDEV_SET_MAC_CONFIG_RESPONSE_EVENT,
	WMI_TAG_COEX_CONFIG_CMD,
	WMI_TAG_CONFIG_ENHANCED_MCAST_FILTER,
	WMI_TAG_CHAN_AVOID_RPT_ALLOW_CMD,
	WMI_TAG_SET_PERIODIC_CHANNEL_STATS_CONFIG,
	WMI_TAG_VDEV_SET_CUSTOM_AGGR_SIZE_CMD,
	WMI_TAG_PDEV_WAL_POWER_DEBUG_CMD,
	WMI_TAG_MAC_PHY_CAPABILITIES,
	WMI_TAG_HW_MODE_CAPABILITIES,
	WMI_TAG_SOC_MAC_PHY_HW_MODE_CAPS,
	WMI_TAG_HAL_REG_CAPABILITIES_EXT,
	WMI_TAG_SOC_HAL_REG_CAPABILITIES,
	WMI_TAG_VDEV_WISA_CMD,
	WMI_TAG_TX_POWER_LEVEL_STATS_EVT,
	WMI_TAG_SCAN_ADAPTIVE_DWELL_PARAMETERS_TLV,
	WMI_TAG_SCAN_ADAPTIVE_DWELL_CONFIG,
	WMI_TAG_WOW_SET_ACTION_WAKE_UP_CMD,
	WMI_TAG_NDP_END_RSP_PER_NDI,
	WMI_TAG_PEER_BWF_REQUEST,
	WMI_TAG_BWF_PEER_INFO,
	WMI_TAG_DBGLOG_TIME_STAMP_SYNC_CMD,
	WMI_TAG_RMC_SET_LEADER_CMD,
	WMI_TAG_RMC_MANUAL_LEADER_EVENT,
	WMI_TAG_PER_CHAIN_RSSI_STATS,
	WMI_TAG_RSSI_STATS,
	WMI_TAG_P2P_LO_START_CMD,
	WMI_TAG_P2P_LO_STOP_CMD,
	WMI_TAG_P2P_LO_STOPPED_EVENT,
	WMI_TAG_REORDER_QUEUE_SETUP_CMD,
	WMI_TAG_REORDER_QUEUE_REMOVE_CMD,
	WMI_TAG_SET_MULTIPLE_MCAST_FILTER_CMD,
	WMI_TAG_MGMT_TX_COMPL_BUNDLE_EVENT,
	WMI_TAG_READ_DATA_FROM_FLASH_CMD,
	WMI_TAG_READ_DATA_FROM_FLASH_EVENT,
	WMI_TAG_PDEV_SET_REORDER_TIMEOUT_VAL_CMD,
	WMI_TAG_PEER_SET_RX_BLOCKSIZE_CMD,
	WMI_TAG_PDEV_SET_WAKEUP_CONFIG_CMDID,
	WMI_TAG_TLV_BUF_LEN_PARAM,
	WMI_TAG_SERVICE_AVAILABLE_EVENT,
	WMI_TAG_PEER_ANTDIV_INFO_REQ_CMD,
	WMI_TAG_PEER_ANTDIV_INFO_EVENT,
	WMI_TAG_PEER_ANTDIV_INFO,
	WMI_TAG_PDEV_GET_ANTDIV_STATUS_CMD,
	WMI_TAG_PDEV_ANTDIV_STATUS_EVENT,
	WMI_TAG_MNT_FILTER_CMD,
	WMI_TAG_GET_CHIP_POWER_STATS_CMD,
	WMI_TAG_PDEV_CHIP_POWER_STATS_EVENT,
	WMI_TAG_COEX_GET_ANTENNA_ISOLATION_CMD,
	WMI_TAG_COEX_REPORT_ISOLATION_EVENT,
	WMI_TAG_CHAN_CCA_STATS,
	WMI_TAG_PEER_SIGNAL_STATS,
	WMI_TAG_TX_STATS,
	WMI_TAG_PEER_AC_TX_STATS,
	WMI_TAG_RX_STATS,
	WMI_TAG_PEER_AC_RX_STATS,
	WMI_TAG_REPORT_STATS_EVENT,
	WMI_TAG_CHAN_CCA_STATS_THRESH,
	WMI_TAG_PEER_SIGNAL_STATS_THRESH,
	WMI_TAG_TX_STATS_THRESH,
	WMI_TAG_RX_STATS_THRESH,
	WMI_TAG_PDEV_SET_STATS_THRESHOLD_CMD,
	WMI_TAG_REQUEST_WLAN_STATS_CMD,
	WMI_TAG_RX_AGGR_FAILURE_EVENT,
	WMI_TAG_RX_AGGR_FAILURE_INFO,
	WMI_TAG_VDEV_ENCRYPT_DECRYPT_DATA_REQ_CMD,
	WMI_TAG_VDEV_ENCRYPT_DECRYPT_DATA_RESP_EVENT,
	WMI_TAG_PDEV_BAND_TO_MAC,
	WMI_TAG_TBTT_OFFSET_INFO,
	WMI_TAG_TBTT_OFFSET_EXT_EVENT,
	WMI_TAG_SAR_LIMITS_CMD,
	WMI_TAG_SAR_LIMIT_CMD_ROW,
	WMI_TAG_PDEV_DFS_PHYERR_OFFLOAD_ENABLE_CMD,
	WMI_TAG_PDEV_DFS_PHYERR_OFFLOAD_DISABLE_CMD,
	WMI_TAG_VDEV_ADFS_CH_CFG_CMD,
	WMI_TAG_VDEV_ADFS_OCAC_ABORT_CMD,
	WMI_TAG_PDEV_DFS_RADAR_DETECTION_EVENT,
	WMI_TAG_VDEV_ADFS_OCAC_COMPLETE_EVENT,
	WMI_TAG_VDEV_DFS_CAC_COMPLETE_EVENT,
	WMI_TAG_VENDOR_OUI,
	WMI_TAG_REQUEST_RCPI_CMD,
	WMI_TAG_UPDATE_RCPI_EVENT,
	WMI_TAG_REQUEST_PEER_STATS_INFO_CMD,
	WMI_TAG_PEER_STATS_INFO,
	WMI_TAG_PEER_STATS_INFO_EVENT,
	WMI_TAG_PKGID_EVENT,
	WMI_TAG_CONNECTED_NLO_RSSI_PARAMS,
	WMI_TAG_SET_CURRENT_COUNTRY_CMD,
	WMI_TAG_REGULATORY_RULE_STRUCT,
	WMI_TAG_REG_CHAN_LIST_CC_EVENT,
	WMI_TAG_11D_SCAN_START_CMD,
	WMI_TAG_11D_SCAN_STOP_CMD,
	WMI_TAG_11D_NEW_COUNTRY_EVENT,
	WMI_TAG_REQUEST_RADIO_CHAN_STATS_CMD,
	WMI_TAG_RADIO_CHAN_STATS,
	WMI_TAG_RADIO_CHAN_STATS_EVENT,
	WMI_TAG_ROAM_PER_CONFIG,
	WMI_TAG_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_CMD,
	WMI_TAG_VDEV_ADD_MAC_ADDR_TO_RX_FILTER_STATUS_EVENT,
	WMI_TAG_BPF_SET_VDEV_ACTIVE_MODE_CMD,
	WMI_TAG_HW_DATA_FILTER_CMD,
	WMI_TAG_CONNECTED_NLO_BSS_BAND_RSSI_PREF,
	WMI_TAG_PEER_OPER_MODE_CHANGE_EVENT,
	WMI_TAG_CHIP_POWER_SAVE_FAILURE_DETECTED,
	WMI_TAG_PDEV_MULTIPLE_VDEV_RESTART_REQUEST_CMD,
	WMI_TAG_PDEV_CSA_SWITCH_COUNT_STATUS_EVENT,
	WMI_TAG_PDEV_UPDATE_PKT_ROUTING_CMD,
	WMI_TAG_PDEV_CHECK_CAL_VERSION_CMD,
	WMI_TAG_PDEV_CHECK_CAL_VERSION_EVENT,
	WMI_TAG_PDEV_SET_DIVERSITY_GAIN_CMD,
	WMI_TAG_MAC_PHY_CHAINMASK_COMBO,
	WMI_TAG_MAC_PHY_CHAINMASK_CAPABILITY,
	WMI_TAG_VDEV_SET_ARP_STATS_CMD,
	WMI_TAG_VDEV_GET_ARP_STATS_CMD,
	WMI_TAG_VDEV_GET_ARP_STATS_EVENT,
	WMI_TAG_IFACE_OFFLOAD_STATS,
	WMI_TAG_REQUEST_STATS_CMD_SUB_STRUCT_PARAM,
	WMI_TAG_RSSI_CTL_EXT,
	WMI_TAG_SINGLE_PHYERR_EXT_RX_HDR,
	WMI_TAG_COEX_BT_ACTIVITY_EVENT,
	WMI_TAG_VDEV_GET_TX_POWER_CMD,
	WMI_TAG_VDEV_TX_POWER_EVENT,
	WMI_TAG_OFFCHAN_DATA_TX_COMPL_EVENT,
	WMI_TAG_OFFCHAN_DATA_TX_SEND_CMD,
	WMI_TAG_TX_SEND_PARAMS,
	WMI_TAG_HE_RATE_SET,
	WMI_TAG_CONGESTION_STATS,
	WMI_TAG_SET_INIT_COUNTRY_CMD,
	WMI_TAG_SCAN_DBS_DUTY_CYCLE,
	WMI_TAG_SCAN_DBS_DUTY_CYCLE_PARAM_TLV,
	WMI_TAG_PDEV_DIV_GET_RSSI_ANTID,
	WMI_TAG_THERM_THROT_CONFIG_REQUEST,
	WMI_TAG_THERM_THROT_LEVEL_CONFIG_INFO,
	WMI_TAG_THERM_THROT_STATS_EVENT,
	WMI_TAG_THERM_THROT_LEVEL_STATS_INFO,
	WMI_TAG_PDEV_DIV_RSSI_ANTID_EVENT,
	WMI_TAG_OEM_DMA_RING_CAPABILITIES,
	WMI_TAG_OEM_DMA_RING_CFG_REQ,
	WMI_TAG_OEM_DMA_RING_CFG_RSP,
	WMI_TAG_OEM_INDIRECT_DATA,
	WMI_TAG_OEM_DMA_BUF_RELEASE,
	WMI_TAG_OEM_DMA_BUF_RELEASE_ENTRY,
	WMI_TAG_PDEV_BSS_CHAN_INFO_REQUEST,
	WMI_TAG_PDEV_BSS_CHAN_INFO_EVENT,
	WMI_TAG_ROAM_LCA_DISALLOW_CONFIG,
	WMI_TAG_VDEV_LIMIT_OFFCHAN_CMD,
	WMI_TAG_ROAM_RSSI_REJECTION_OCE_CONFIG,
	WMI_TAG_UNIT_TEST_EVENT,
	WMI_TAG_ROAM_FILS_OFFLOAD,
	WMI_TAG_PDEV_UPDATE_PMK_CACHE_CMD,
	WMI_TAG_PMK_CACHE,
	WMI_TAG_PDEV_UPDATE_FILS_HLP_PKT_CMD,
	WMI_TAG_ROAM_FILS_SYNCH,
	WMI_TAG_GTK_OFFLOAD_EXTENDED,
	WMI_TAG_ROAM_BG_SCAN_ROAMING,
	WMI_TAG_OIC_PING_OFFLOAD_PARAMS_CMD,
	WMI_TAG_OIC_PING_OFFLOAD_SET_ENABLE_CMD,
	WMI_TAG_OIC_PING_HANDOFF_EVENT,
	WMI_TAG_DHCP_LEASE_RENEW_OFFLOAD_CMD,
	WMI_TAG_DHCP_LEASE_RENEW_EVENT,
	WMI_TAG_BTM_CONFIG,
	WMI_TAG_DEBUG_MESG_FW_DATA_STALL,
	WMI_TAG_WLM_CONFIG_CMD,
	WMI_TAG_PDEV_UPDATE_CTLTABLE_REQUEST,
	WMI_TAG_PDEV_UPDATE_CTLTABLE_EVENT,
	WMI_TAG_ROAM_CND_SCORING_PARAM,
	WMI_TAG_PDEV_CONFIG_VENDOR_OUI_ACTION,
	WMI_TAG_VENDOR_OUI_EXT,
	WMI_TAG_ROAM_SYNCH_FRAME_EVENT,
	WMI_TAG_FD_SEND_FROM_HOST_CMD,
	WMI_TAG_ENABLE_FILS_CMD,
	WMI_TAG_HOST_SWFDA_EVENT,
	WMI_TAG_BCN_OFFLOAD_CTRL_CMD,
	WMI_TAG_PDEV_SET_AC_TX_QUEUE_OPTIMIZED_CMD,
	WMI_TAG_STATS_PERIOD,
	WMI_TAG_NDL_SCHEDULE_UPDATE,
	WMI_TAG_PEER_TID_MSDUQ_QDEPTH_THRESH_UPDATE_CMD,
	WMI_TAG_MSDUQ_QDEPTH_THRESH_UPDATE,
	WMI_TAG_PDEV_SET_RX_FILTER_PROMISCUOUS_CMD,
	WMI_TAG_SAR2_RESULT_EVENT,
	WMI_TAG_SAR_CAPABILITIES,
	WMI_TAG_SAP_OBSS_DETECTION_CFG_CMD,
	WMI_TAG_SAP_OBSS_DETECTION_INFO_EVT,
	WMI_TAG_DMA_RING_CAPABILITIES,
	WMI_TAG_DMA_RING_CFG_REQ,
	WMI_TAG_DMA_RING_CFG_RSP,
	WMI_TAG_DMA_BUF_RELEASE,
	WMI_TAG_DMA_BUF_RELEASE_ENTRY,
	WMI_TAG_SAR_GET_LIMITS_CMD,
	WMI_TAG_SAR_GET_LIMITS_EVENT,
	WMI_TAG_SAR_GET_LIMITS_EVENT_ROW,
	WMI_TAG_OFFLOAD_11K_REPORT,
	WMI_TAG_INVOKE_NEIGHBOR_REPORT,
	WMI_TAG_NEIGHBOR_REPORT_OFFLOAD,
	WMI_TAG_VDEV_SET_CONNECTIVITY_CHECK_STATS,
	WMI_TAG_VDEV_GET_CONNECTIVITY_CHECK_STATS,
	WMI_TAG_BPF_SET_VDEV_ENABLE_CMD,
	WMI_TAG_BPF_SET_VDEV_WORK_MEMORY_CMD,
	WMI_TAG_BPF_GET_VDEV_WORK_MEMORY_CMD,
	WMI_TAG_BPF_GET_VDEV_WORK_MEMORY_RESP_EVT,
	WMI_TAG_PDEV_GET_NFCAL_POWER,
	WMI_TAG_BSS_COLOR_CHANGE_ENABLE,
	WMI_TAG_OBSS_COLOR_COLLISION_DET_CONFIG,
	WMI_TAG_OBSS_COLOR_COLLISION_EVT,
	WMI_TAG_RUNTIME_DPD_RECAL_CMD,
	WMI_TAG_TWT_ENABLE_CMD,
	WMI_TAG_TWT_DISABLE_CMD,
	WMI_TAG_TWT_ADD_DIALOG_CMD,
	WMI_TAG_TWT_DEL_DIALOG_CMD,
	WMI_TAG_TWT_PAUSE_DIALOG_CMD,
	WMI_TAG_TWT_RESUME_DIALOG_CMD,
	WMI_TAG_TWT_ENABLE_COMPLETE_EVENT,
	WMI_TAG_TWT_DISABLE_COMPLETE_EVENT,
	WMI_TAG_TWT_ADD_DIALOG_COMPLETE_EVENT,
	WMI_TAG_TWT_DEL_DIALOG_COMPLETE_EVENT,
	WMI_TAG_TWT_PAUSE_DIALOG_COMPLETE_EVENT,
	WMI_TAG_TWT_RESUME_DIALOG_COMPLETE_EVENT,
	WMI_TAG_REQUEST_ROAM_SCAN_STATS_CMD,
	WMI_TAG_ROAM_SCAN_STATS_EVENT,
	WMI_TAG_PEER_TID_CONFIGURATIONS_CMD,
	WMI_TAG_VDEV_SET_CUSTOM_SW_RETRY_TH_CMD,
	WMI_TAG_GET_TPC_POWER_CMD,
	WMI_TAG_GET_TPC_POWER_EVENT,
	WMI_TAG_DMA_BUF_RELEASE_SPECTRAL_META_DATA,
	WMI_TAG_MOTION_DET_CONFIG_PARAMS_CMD,
	WMI_TAG_MOTION_DET_BASE_LINE_CONFIG_PARAMS_CMD,
	WMI_TAG_MOTION_DET_START_STOP_CMD,
	WMI_TAG_MOTION_DET_BASE_LINE_START_STOP_CMD,
	WMI_TAG_MOTION_DET_EVENT,
	WMI_TAG_MOTION_DET_BASE_LINE_EVENT,
	WMI_TAG_NDP_TRANSPORT_IP,
	WMI_TAG_OBSS_SPATIAL_REUSE_SET_CMD,
	WMI_TAG_ESP_ESTIMATE_EVENT,
	WMI_TAG_NAN_HOST_CONFIG,
	WMI_TAG_SPECTRAL_BIN_SCALING_PARAMS,
	WMI_TAG_PEER_CFR_CAPTURE_CMD,
	WMI_TAG_PEER_CHAN_WIDTH_SWITCH_CMD,
	WMI_TAG_CHAN_WIDTH_PEER_LIST,
	WMI_TAG_OBSS_SPATIAL_REUSE_SET_DEF_OBSS_THRESH_CMD,
	WMI_TAG_PDEV_HE_TB_ACTION_FRM_CMD,
	WMI_TAG_PEER_EXTD2_STATS,
	WMI_TAG_HPCS_PULSE_START_CMD,
	WMI_TAG_PDEV_CTL_FAILSAFE_CHECK_EVENT,
	WMI_TAG_VDEV_CHAINMASK_CONFIG_CMD,
	WMI_TAG_VDEV_BCN_OFFLOAD_QUIET_CONFIG_CMD,
	WMI_TAG_NAN_EVENT_INFO,
	WMI_TAG_NDP_CHANNEL_INFO,
	WMI_TAG_NDP_CMD,
	WMI_TAG_NDP_EVENT,
	WMI_TAG_PDEV_PEER_PKTLOG_FILTER_CMD = 0x301,
	WMI_TAG_PDEV_PEER_PKTLOG_FILTER_INFO,
	WMI_TAG_FILS_DISCOVERY_TMPL_CMD = 0x344,
	WMI_TAG_PDEV_SRG_BSS_COLOR_BITMAP_CMD = 0x37b,
	WMI_TAG_PDEV_SRG_PARTIAL_BSSID_BITMAP_CMD,
	WMI_TAG_PDEV_SRG_OBSS_COLOR_ENABLE_BITMAP_CMD = 0x381,
	WMI_TAG_PDEV_SRG_OBSS_BSSID_ENABLE_BITMAP_CMD,
	WMI_TAG_PDEV_NON_SRG_OBSS_COLOR_ENABLE_BITMAP_CMD,
	WMI_TAG_PDEV_NON_SRG_OBSS_BSSID_ENABLE_BITMAP_CMD,
	WMI_TAG_REGULATORY_RULE_EXT_STRUCT = 0x3A9,
	WMI_TAG_REG_CHAN_LIST_CC_EXT_EVENT,
	WMI_TAG_PDEV_SET_BIOS_SAR_TABLE_CMD = 0x3D8,
	WMI_TAG_PDEV_SET_BIOS_GEO_TABLE_CMD,
	WMI_TAG_MAX
};

enum wmi_tlv_service {
	WMI_TLV_SERVICE_BEACON_OFFLOAD = 0,
	WMI_TLV_SERVICE_SCAN_OFFLOAD = 1,
	WMI_TLV_SERVICE_ROAM_SCAN_OFFLOAD = 2,
	WMI_TLV_SERVICE_BCN_MISS_OFFLOAD = 3,
	WMI_TLV_SERVICE_STA_PWRSAVE = 4,
	WMI_TLV_SERVICE_STA_ADVANCED_PWRSAVE = 5,
	WMI_TLV_SERVICE_AP_UAPSD = 6,
	WMI_TLV_SERVICE_AP_DFS = 7,
	WMI_TLV_SERVICE_11AC = 8,
	WMI_TLV_SERVICE_BLOCKACK = 9,
	WMI_TLV_SERVICE_PHYERR = 10,
	WMI_TLV_SERVICE_BCN_FILTER = 11,
	WMI_TLV_SERVICE_RTT = 12,
	WMI_TLV_SERVICE_WOW = 13,
	WMI_TLV_SERVICE_RATECTRL_CACHE = 14,
	WMI_TLV_SERVICE_IRAM_TIDS = 15,
	WMI_TLV_SERVICE_ARPNS_OFFLOAD = 16,
	WMI_TLV_SERVICE_NLO = 17,
	WMI_TLV_SERVICE_GTK_OFFLOAD = 18,
	WMI_TLV_SERVICE_SCAN_SCH = 19,
	WMI_TLV_SERVICE_CSA_OFFLOAD = 20,
	WMI_TLV_SERVICE_CHATTER = 21,
	WMI_TLV_SERVICE_COEX_FREQAVOID = 22,
	WMI_TLV_SERVICE_PACKET_POWER_SAVE = 23,
	WMI_TLV_SERVICE_FORCE_FW_HANG = 24,
	WMI_TLV_SERVICE_GPIO = 25,
	WMI_TLV_SERVICE_STA_DTIM_PS_MODULATED_DTIM = 26,
	WMI_STA_UAPSD_BASIC_AUTO_TRIG = 27,
	WMI_STA_UAPSD_VAR_AUTO_TRIG = 28,
	WMI_TLV_SERVICE_STA_KEEP_ALIVE = 29,
	WMI_TLV_SERVICE_TX_ENCAP = 30,
	WMI_TLV_SERVICE_AP_PS_DETECT_OUT_OF_SYNC = 31,
	WMI_TLV_SERVICE_EARLY_RX = 32,
	WMI_TLV_SERVICE_STA_SMPS = 33,
	WMI_TLV_SERVICE_FWTEST = 34,
	WMI_TLV_SERVICE_STA_WMMAC = 35,
	WMI_TLV_SERVICE_TDLS = 36,
	WMI_TLV_SERVICE_BURST = 37,
	WMI_TLV_SERVICE_MCC_BCN_INTERVAL_CHANGE = 38,
	WMI_TLV_SERVICE_ADAPTIVE_OCS = 39,
	WMI_TLV_SERVICE_BA_SSN_SUPPORT = 40,
	WMI_TLV_SERVICE_FILTER_IPSEC_NATKEEPALIVE = 41,
	WMI_TLV_SERVICE_WLAN_HB = 42,
	WMI_TLV_SERVICE_LTE_ANT_SHARE_SUPPORT = 43,
	WMI_TLV_SERVICE_BATCH_SCAN = 44,
	WMI_TLV_SERVICE_QPOWER = 45,
	WMI_TLV_SERVICE_PLMREQ = 46,
	WMI_TLV_SERVICE_THERMAL_MGMT = 47,
	WMI_TLV_SERVICE_RMC = 48,
	WMI_TLV_SERVICE_MHF_OFFLOAD = 49,
	WMI_TLV_SERVICE_COEX_SAR = 50,
	WMI_TLV_SERVICE_BCN_TXRATE_OVERRIDE = 51,
	WMI_TLV_SERVICE_NAN = 52,
	WMI_TLV_SERVICE_L1SS_STAT = 53,
	WMI_TLV_SERVICE_ESTIMATE_LINKSPEED = 54,
	WMI_TLV_SERVICE_OBSS_SCAN = 55,
	WMI_TLV_SERVICE_TDLS_OFFCHAN = 56,
	WMI_TLV_SERVICE_TDLS_UAPSD_BUFFER_STA = 57,
	WMI_TLV_SERVICE_TDLS_UAPSD_SLEEP_STA = 58,
	WMI_TLV_SERVICE_IBSS_PWRSAVE = 59,
	WMI_TLV_SERVICE_LPASS = 60,
	WMI_TLV_SERVICE_EXTSCAN = 61,
	WMI_TLV_SERVICE_D0WOW = 62,
	WMI_TLV_SERVICE_HSOFFLOAD = 63,
	WMI_TLV_SERVICE_ROAM_HO_OFFLOAD = 64,
	WMI_TLV_SERVICE_RX_FULL_REORDER = 65,
	WMI_TLV_SERVICE_DHCP_OFFLOAD = 66,
	WMI_TLV_SERVICE_STA_RX_IPA_OFFLOAD_SUPPORT = 67,
	WMI_TLV_SERVICE_MDNS_OFFLOAD = 68,
	WMI_TLV_SERVICE_SAP_AUTH_OFFLOAD = 69,
	WMI_TLV_SERVICE_DUAL_BAND_SIMULTANEOUS_SUPPORT = 70,
	WMI_TLV_SERVICE_OCB = 71,
	WMI_TLV_SERVICE_AP_ARPNS_OFFLOAD = 72,
	WMI_TLV_SERVICE_PER_BAND_CHAINMASK_SUPPORT = 73,
	WMI_TLV_SERVICE_PACKET_FILTER_OFFLOAD = 74,
	WMI_TLV_SERVICE_MGMT_TX_HTT = 75,
	WMI_TLV_SERVICE_MGMT_TX_WMI = 76,
	WMI_TLV_SERVICE_EXT_MSG = 77,
	WMI_TLV_SERVICE_MAWC = 78,
	WMI_TLV_SERVICE_PEER_ASSOC_CONF = 79,
	WMI_TLV_SERVICE_EGAP = 80,
	WMI_TLV_SERVICE_STA_PMF_OFFLOAD = 81,
	WMI_TLV_SERVICE_UNIFIED_WOW_CAPABILITY = 82,
	WMI_TLV_SERVICE_ENHANCED_PROXY_STA = 83,
	WMI_TLV_SERVICE_ATF = 84,
	WMI_TLV_SERVICE_COEX_GPIO = 85,
	WMI_TLV_SERVICE_AUX_SPECTRAL_INTF = 86,
	WMI_TLV_SERVICE_AUX_CHAN_LOAD_INTF = 87,
	WMI_TLV_SERVICE_BSS_CHANNEL_INFO_64 = 88,
	WMI_TLV_SERVICE_ENTERPRISE_MESH = 89,
	WMI_TLV_SERVICE_RESTRT_CHNL_SUPPORT = 90,
	WMI_TLV_SERVICE_BPF_OFFLOAD = 91,
	WMI_TLV_SERVICE_SYNC_DELETE_CMDS = 92,
	WMI_TLV_SERVICE_SMART_ANTENNA_SW_SUPPORT = 93,
	WMI_TLV_SERVICE_SMART_ANTENNA_HW_SUPPORT = 94,
	WMI_TLV_SERVICE_RATECTRL_LIMIT_MAX_MIN_RATES = 95,
	WMI_TLV_SERVICE_NAN_DATA = 96,
	WMI_TLV_SERVICE_NAN_RTT = 97,
	WMI_TLV_SERVICE_11AX = 98,
	WMI_TLV_SERVICE_DEPRECATED_REPLACE = 99,
	WMI_TLV_SERVICE_TDLS_CONN_TRACKER_IN_HOST_MODE = 100,
	WMI_TLV_SERVICE_ENHANCED_MCAST_FILTER = 101,
	WMI_TLV_SERVICE_PERIODIC_CHAN_STAT_SUPPORT = 102,
	WMI_TLV_SERVICE_MESH_11S = 103,
	WMI_TLV_SERVICE_HALF_RATE_QUARTER_RATE_SUPPORT = 104,
	WMI_TLV_SERVICE_VDEV_RX_FILTER = 105,
	WMI_TLV_SERVICE_P2P_LISTEN_OFFLOAD_SUPPORT = 106,
	WMI_TLV_SERVICE_MARK_FIRST_WAKEUP_PACKET = 107,
	WMI_TLV_SERVICE_MULTIPLE_MCAST_FILTER_SET = 108,
	WMI_TLV_SERVICE_HOST_MANAGED_RX_REORDER = 109,
	WMI_TLV_SERVICE_FLASH_RDWR_SUPPORT = 110,
	WMI_TLV_SERVICE_WLAN_STATS_REPORT = 111,
	WMI_TLV_SERVICE_TX_MSDU_ID_NEW_PARTITION_SUPPORT = 112,
	WMI_TLV_SERVICE_DFS_PHYERR_OFFLOAD = 113,
	WMI_TLV_SERVICE_RCPI_SUPPORT = 114,
	WMI_TLV_SERVICE_FW_MEM_DUMP_SUPPORT = 115,
	WMI_TLV_SERVICE_PEER_STATS_INFO = 116,
	WMI_TLV_SERVICE_REGULATORY_DB = 117,
	WMI_TLV_SERVICE_11D_OFFLOAD = 118,
	WMI_TLV_SERVICE_HW_DATA_FILTERING = 119,
	WMI_TLV_SERVICE_MULTIPLE_VDEV_RESTART = 120,
	WMI_TLV_SERVICE_PKT_ROUTING = 121,
	WMI_TLV_SERVICE_CHECK_CAL_VERSION = 122,
	WMI_TLV_SERVICE_OFFCHAN_TX_WMI = 123,
	WMI_TLV_SERVICE_8SS_TX_BFEE  =  124,
	WMI_TLV_SERVICE_EXTENDED_NSS_SUPPORT = 125,
	WMI_TLV_SERVICE_ACK_TIMEOUT = 126,
	WMI_TLV_SERVICE_PDEV_BSS_CHANNEL_INFO_64 = 127,

	/* The first 128 bits */
	WMI_MAX_SERVICE = 128,

	WMI_TLV_SERVICE_CHAN_LOAD_INFO = 128,
	WMI_TLV_SERVICE_TX_PPDU_INFO_STATS_SUPPORT = 129,
	WMI_TLV_SERVICE_VDEV_LIMIT_OFFCHAN_SUPPORT = 130,
	WMI_TLV_SERVICE_FILS_SUPPORT = 131,
	WMI_TLV_SERVICE_WLAN_OIC_PING_OFFLOAD = 132,
	WMI_TLV_SERVICE_WLAN_DHCP_RENEW = 133,
	WMI_TLV_SERVICE_MAWC_SUPPORT = 134,
	WMI_TLV_SERVICE_VDEV_LATENCY_CONFIG = 135,
	WMI_TLV_SERVICE_PDEV_UPDATE_CTLTABLE_SUPPORT = 136,
	WMI_TLV_SERVICE_PKTLOG_SUPPORT_OVER_HTT = 137,
	WMI_TLV_SERVICE_VDEV_MULTI_GROUP_KEY_SUPPORT = 138,
	WMI_TLV_SERVICE_SCAN_PHYMODE_SUPPORT = 139,
	WMI_TLV_SERVICE_THERM_THROT = 140,
	WMI_TLV_SERVICE_BCN_OFFLOAD_START_STOP_SUPPORT = 141,
	WMI_TLV_SERVICE_WOW_WAKEUP_BY_TIMER_PATTERN = 142,
	WMI_TLV_SERVICE_PEER_MAP_UNMAP_V2_SUPPORT = 143,
	WMI_TLV_SERVICE_OFFCHAN_DATA_TID_SUPPORT = 144,
	WMI_TLV_SERVICE_RX_PROMISC_ENABLE_SUPPORT = 145,
	WMI_TLV_SERVICE_SUPPORT_DIRECT_DMA = 146,
	WMI_TLV_SERVICE_AP_OBSS_DETECTION_OFFLOAD = 147,
	WMI_TLV_SERVICE_11K_NEIGHBOUR_REPORT_SUPPORT = 148,
	WMI_TLV_SERVICE_LISTEN_INTERVAL_OFFLOAD_SUPPORT = 149,
	WMI_TLV_SERVICE_BSS_COLOR_OFFLOAD = 150,
	WMI_TLV_SERVICE_RUNTIME_DPD_RECAL = 151,
	WMI_TLV_SERVICE_STA_TWT = 152,
	WMI_TLV_SERVICE_AP_TWT = 153,
	WMI_TLV_SERVICE_GMAC_OFFLOAD_SUPPORT = 154,
	WMI_TLV_SERVICE_SPOOF_MAC_SUPPORT = 155,
	WMI_TLV_SERVICE_PEER_TID_CONFIGS_SUPPORT = 156,
	WMI_TLV_SERVICE_VDEV_SWRETRY_PER_AC_CONFIG_SUPPORT = 157,
	WMI_TLV_SERVICE_DUAL_BEACON_ON_SINGLE_MAC_SCC_SUPPORT = 158,
	WMI_TLV_SERVICE_DUAL_BEACON_ON_SINGLE_MAC_MCC_SUPPORT = 159,
	WMI_TLV_SERVICE_MOTION_DET = 160,
	WMI_TLV_SERVICE_INFRA_MBSSID = 161,
	WMI_TLV_SERVICE_OBSS_SPATIAL_REUSE = 162,
	WMI_TLV_SERVICE_VDEV_DIFFERENT_BEACON_INTERVAL_SUPPORT = 163,
	WMI_TLV_SERVICE_NAN_DBS_SUPPORT = 164,
	WMI_TLV_SERVICE_NDI_DBS_SUPPORT = 165,
	WMI_TLV_SERVICE_NAN_SAP_SUPPORT = 166,
	WMI_TLV_SERVICE_NDI_SAP_SUPPORT = 167,
	WMI_TLV_SERVICE_CFR_CAPTURE_SUPPORT = 168,
	WMI_TLV_SERVICE_CFR_CAPTURE_IND_MSG_TYPE_1 = 169,
	WMI_TLV_SERVICE_ESP_SUPPORT = 170,
	WMI_TLV_SERVICE_PEER_CHWIDTH_CHANGE = 171,
	WMI_TLV_SERVICE_WLAN_HPCS_PULSE = 172,
	WMI_TLV_SERVICE_PER_VDEV_CHAINMASK_CONFIG_SUPPORT = 173,
	WMI_TLV_SERVICE_TX_DATA_MGMT_ACK_RSSI = 174,
	WMI_TLV_SERVICE_NAN_DISABLE_SUPPORT = 175,
	WMI_TLV_SERVICE_HTT_H2T_NO_HTC_HDR_LEN_IN_MSG_LEN = 176,
	WMI_TLV_SERVICE_COEX_SUPPORT_UNEQUAL_ISOLATION = 177,
	WMI_TLV_SERVICE_HW_DB2DBM_CONVERSION_SUPPORT = 178,
	WMI_TLV_SERVICE_SUPPORT_EXTEND_ADDRESS = 179,
	WMI_TLV_SERVICE_BEACON_RECEPTION_STATS = 180,
	WMI_TLV_SERVICE_FETCH_TX_PN = 181,
	WMI_TLV_SERVICE_PEER_UNMAP_RESPONSE_SUPPORT = 182,
	WMI_TLV_SERVICE_TX_PER_PEER_AMPDU_SIZE = 183,
	WMI_TLV_SERVICE_BSS_COLOR_SWITCH_COUNT = 184,
	WMI_TLV_SERVICE_HTT_PEER_STATS_SUPPORT = 185,
	WMI_TLV_SERVICE_UL_RU26_ALLOWED = 186,
	WMI_TLV_SERVICE_GET_MWS_COEX_STATE = 187,
	WMI_TLV_SERVICE_GET_MWS_DPWB_STATE = 188,
	WMI_TLV_SERVICE_GET_MWS_TDM_STATE = 189,
	WMI_TLV_SERVICE_GET_MWS_IDRX_STATE = 190,
	WMI_TLV_SERVICE_GET_MWS_ANTENNA_SHARING_STATE = 191,
	WMI_TLV_SERVICE_ENHANCED_TPC_CONFIG_EVENT = 192,
	WMI_TLV_SERVICE_WLM_STATS_REQUEST = 193,
	WMI_TLV_SERVICE_EXT_PEER_TID_CONFIGS_SUPPORT = 194,
	WMI_TLV_SERVICE_WPA3_FT_SAE_SUPPORT = 195,
	WMI_TLV_SERVICE_WPA3_FT_SUITE_B_SUPPORT = 196,
	WMI_TLV_SERVICE_VOW_ENABLE = 197,
	WMI_TLV_SERVICE_CFR_CAPTURE_IND_EVT_TYPE_1 = 198,
	WMI_TLV_SERVICE_BROADCAST_TWT = 199,
	WMI_TLV_SERVICE_RAP_DETECTION_SUPPORT = 200,
	WMI_TLV_SERVICE_PS_TDCC = 201,
	WMI_TLV_SERVICE_THREE_WAY_COEX_CONFIG_LEGACY   = 202,
	WMI_TLV_SERVICE_THREE_WAY_COEX_CONFIG_OVERRIDE = 203,
	WMI_TLV_SERVICE_TX_PWR_PER_PEER = 204,
	WMI_TLV_SERVICE_STA_PLUS_STA_SUPPORT = 205,
	WMI_TLV_SERVICE_WPA3_FT_FILS = 206,
	WMI_TLV_SERVICE_ADAPTIVE_11R_ROAM = 207,
	WMI_TLV_SERVICE_CHAN_RF_CHARACTERIZATION_INFO = 208,
	WMI_TLV_SERVICE_FW_IFACE_COMBINATION_SUPPORT = 209,
	WMI_TLV_SERVICE_TX_COMPL_TSF64 = 210,
	WMI_TLV_SERVICE_DSM_ROAM_FILTER = 211,
	WMI_TLV_SERVICE_PACKET_CAPTURE_SUPPORT = 212,
	WMI_TLV_SERVICE_PER_PEER_HTT_STATS_RESET = 213,
	WMI_TLV_SERVICE_FREQINFO_IN_METADATA = 219,
	WMI_TLV_SERVICE_EXT2_MSG = 220,
	WMI_TLV_SERVICE_PEER_POWER_SAVE_DURATION_SUPPORT = 246,
	WMI_TLV_SERVICE_SRG_SRP_SPATIAL_REUSE_SUPPORT = 249,
	WMI_TLV_SERVICE_MBSS_PARAM_IN_VDEV_START_SUPPORT = 253,
	WMI_TLV_SERVICE_PASSIVE_SCAN_START_TIME_ENHANCE = 263,

	/* The second 128 bits */
	WMI_MAX_EXT_SERVICE = 256,
	WMI_TLV_SERVICE_SCAN_CONFIG_PER_CHANNEL = 265,
	WMI_TLV_SERVICE_REG_CC_EXT_EVENT_SUPPORT = 281,
	WMI_TLV_SERVICE_BIOS_SAR_SUPPORT = 326,
	WMI_TLV_SERVICE_SUPPORT_11D_FOR_HOST_SCAN = 357,

	/* The third 128 bits */
	WMI_MAX_EXT2_SERVICE = 384
};

enum {
	WMI_SMPS_FORCED_MODE_NONE = 0,
	WMI_SMPS_FORCED_MODE_DISABLED,
	WMI_SMPS_FORCED_MODE_STATIC,
	WMI_SMPS_FORCED_MODE_DYNAMIC
};

#define WMI_TPC_CHAINMASK_CONFIG_BAND_2G      0
#define WMI_TPC_CHAINMASK_CONFIG_BAND_5G      1
#define WMI_NUM_SUPPORTED_BAND_MAX 2

#define WMI_PEER_MIMO_PS_STATE                          0x1
#define WMI_PEER_AMPDU                                  0x2
#define WMI_PEER_AUTHORIZE                              0x3
#define WMI_PEER_CHWIDTH                                0x4
#define WMI_PEER_NSS                                    0x5
#define WMI_PEER_USE_4ADDR                              0x6
#define WMI_PEER_MEMBERSHIP                             0x7
#define WMI_PEER_USERPOS                                0x8
#define WMI_PEER_CRIT_PROTO_HINT_ENABLED                0x9
#define WMI_PEER_TX_FAIL_CNT_THR                        0xA
#define WMI_PEER_SET_HW_RETRY_CTS2S                     0xB
#define WMI_PEER_IBSS_ATIM_WINDOW_LENGTH                0xC
#define WMI_PEER_PHYMODE                                0xD
#define WMI_PEER_USE_FIXED_PWR                          0xE
#define WMI_PEER_PARAM_FIXED_RATE                       0xF
#define WMI_PEER_SET_MU_WHITELIST                       0x10
#define WMI_PEER_SET_MAX_TX_RATE                        0x11
#define WMI_PEER_SET_MIN_TX_RATE                        0x12
#define WMI_PEER_SET_DEFAULT_ROUTING                    0x13

/* slot time long */
#define WMI_VDEV_SLOT_TIME_LONG         0x1
/* slot time short */
#define WMI_VDEV_SLOT_TIME_SHORT        0x2
/* preamble long */
#define WMI_VDEV_PREAMBLE_LONG          0x1
/* preamble short */
#define WMI_VDEV_PREAMBLE_SHORT         0x2

enum wmi_peer_smps_state {
	WMI_PEER_SMPS_PS_NONE = 0x0,
	WMI_PEER_SMPS_STATIC  = 0x1,
	WMI_PEER_SMPS_DYNAMIC = 0x2
};

enum wmi_peer_chwidth {
	WMI_PEER_CHWIDTH_20MHZ = 0,
	WMI_PEER_CHWIDTH_40MHZ = 1,
	WMI_PEER_CHWIDTH_80MHZ = 2,
	WMI_PEER_CHWIDTH_160MHZ = 3,
};

enum wmi_beacon_gen_mode {
	WMI_BEACON_STAGGERED_MODE = 0,
	WMI_BEACON_BURST_MODE = 1
};

enum wmi_direct_buffer_module {
	WMI_DIRECT_BUF_SPECTRAL = 0,
	WMI_DIRECT_BUF_CFR = 1,

	/* keep it last */
	WMI_DIRECT_BUF_MAX
};

/* enum wmi_nss_ratio - NSS ratio received from FW during service ready ext
 *			event
 * WMI_NSS_RATIO_1BY2_NSS -Max nss of 160MHz is equals to half of the max nss
 *			   of 80MHz
 * WMI_NSS_RATIO_3BY4_NSS - Max nss of 160MHz is equals to 3/4 of the max nss
 *			    of 80MHz
 * WMI_NSS_RATIO_1_NSS - Max nss of 160MHz is equals to the max nss of 80MHz
 * WMI_NSS_RATIO_2_NSS - Max nss of 160MHz is equals to two times the max
 *			 nss of 80MHz
 */

enum wmi_nss_ratio {
	WMI_NSS_RATIO_1BY2_NSS = 0x0,
	WMI_NSS_RATIO_3BY4_NSS = 0x1,
	WMI_NSS_RATIO_1_NSS = 0x2,
	WMI_NSS_RATIO_2_NSS = 0x3,
};

enum wmi_dtim_policy {
	WMI_DTIM_POLICY_IGNORE = 1,
	WMI_DTIM_POLICY_NORMAL = 2,
	WMI_DTIM_POLICY_STICK  = 3,
	WMI_DTIM_POLICY_AUTO   = 4,
};

struct wmi_host_pdev_band_to_mac {
	uint32_t pdev_id;
	uint32_t start_freq;
	uint32_t end_freq;
};

struct ath11k_ppe_threshold {
	uint32_t numss_m1;
	uint32_t ru_bit_mask;
	uint32_t ppet16_ppet8_ru3_ru0[PSOC_HOST_MAX_NUM_SS];
};

struct ath11k_service_ext_param {
	uint32_t default_conc_scan_config_bits;
	uint32_t default_fw_config_bits;
	struct ath11k_ppe_threshold ppet;
	uint32_t he_cap_info;
	uint32_t mpdu_density;
	uint32_t max_bssid_rx_filters;
	uint32_t num_hw_modes;
	uint32_t num_phy;
};

struct ath11k_hw_mode_caps {
	uint32_t hw_mode_id;
	uint32_t phy_id_map;
	uint32_t hw_mode_config_type;
};

#define PSOC_HOST_MAX_PHY_SIZE (3)
#define ATH11K_11B_SUPPORT                 BIT(0)
#define ATH11K_11G_SUPPORT                 BIT(1)
#define ATH11K_11A_SUPPORT                 BIT(2)
#define ATH11K_11N_SUPPORT                 BIT(3)
#define ATH11K_11AC_SUPPORT                BIT(4)
#define ATH11K_11AX_SUPPORT                BIT(5)

struct ath11k_hal_reg_capabilities_ext {
	uint32_t phy_id;
	uint32_t eeprom_reg_domain;
	uint32_t eeprom_reg_domain_ext;
	uint32_t regcap1;
	uint32_t regcap2;
	uint32_t wireless_modes;
	uint32_t low_2ghz_chan;
	uint32_t high_2ghz_chan;
	uint32_t low_5ghz_chan;
	uint32_t high_5ghz_chan;
};

#define WMI_HOST_MAX_PDEV 3

struct wlan_host_mem_chunk {
	uint32_t tlv_header;
	uint32_t req_id;
	uint32_t ptr;
	uint32_t size;
} __packed;

struct wmi_host_mem_chunk {
	void *vaddr;
	bus_addr_t paddr;
	uint32_t len;
	uint32_t req_id;
};

struct wmi_init_cmd_param {
	uint32_t tlv_header;
	struct target_resource_config *res_cfg;
	uint8_t num_mem_chunks;
	struct wmi_host_mem_chunk *mem_chunks;
	uint32_t hw_mode_id;
	uint32_t num_band_to_mac;
	struct wmi_host_pdev_band_to_mac band_to_mac[WMI_HOST_MAX_PDEV];
};

struct wmi_pdev_band_to_mac {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t start_freq;
	uint32_t end_freq;
} __packed;

struct wmi_pdev_set_hw_mode_cmd_param {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t hw_mode_index;
	uint32_t num_band_to_mac;
} __packed;

struct wmi_ppe_threshold {
	uint32_t numss_m1; /** NSS - 1*/
	union {
		uint32_t ru_count;
		uint32_t ru_mask;
	} __packed;
	uint32_t ppet16_ppet8_ru3_ru0[WMI_MAX_NUM_SS];
} __packed;

#define HW_BD_INFO_SIZE       5

struct wmi_abi_version {
	uint32_t abi_version_0;
	uint32_t abi_version_1;
	uint32_t abi_version_ns_0;
	uint32_t abi_version_ns_1;
	uint32_t abi_version_ns_2;
	uint32_t abi_version_ns_3;
} __packed;

struct wmi_init_cmd {
	uint32_t tlv_header;
	struct wmi_abi_version host_abi_vers;
	uint32_t num_host_mem_chunks;
} __packed;

#define WMI_RSRC_CFG_FLAG1_BSS_CHANNEL_INFO_64 BIT(5)
#define WMI_RSRC_CFG_FLAG2_CALC_NEXT_DTIM_COUNT_SET BIT(9)
#define WMI_RSRC_CFG_FLAG1_ACK_RSSI BIT(18)

#define WMI_CFG_HOST_SERVICE_FLAG_REG_CC_EXT 4

struct wmi_resource_config {
	uint32_t tlv_header;
	uint32_t num_vdevs;
	uint32_t num_peers;
	uint32_t num_offload_peers;
	uint32_t num_offload_reorder_buffs;
	uint32_t num_peer_keys;
	uint32_t num_tids;
	uint32_t ast_skid_limit;
	uint32_t tx_chain_mask;
	uint32_t rx_chain_mask;
	uint32_t rx_timeout_pri[4];
	uint32_t rx_decap_mode;
	uint32_t scan_max_pending_req;
	uint32_t bmiss_offload_max_vdev;
	uint32_t roam_offload_max_vdev;
	uint32_t roam_offload_max_ap_profiles;
	uint32_t num_mcast_groups;
	uint32_t num_mcast_table_elems;
	uint32_t mcast2ucast_mode;
	uint32_t tx_dbg_log_size;
	uint32_t num_wds_entries;
	uint32_t dma_burst_size;
	uint32_t mac_aggr_delim;
	uint32_t rx_skip_defrag_timeout_dup_detection_check;
	uint32_t vow_config;
	uint32_t gtk_offload_max_vdev;
	uint32_t num_msdu_desc;
	uint32_t max_frag_entries;
	uint32_t num_tdls_vdevs;
	uint32_t num_tdls_conn_table_entries;
	uint32_t beacon_tx_offload_max_vdev;
	uint32_t num_multicast_filter_entries;
	uint32_t num_wow_filters;
	uint32_t num_keep_alive_pattern;
	uint32_t keep_alive_pattern_size;
	uint32_t max_tdls_concurrent_sleep_sta;
	uint32_t max_tdls_concurrent_buffer_sta;
	uint32_t wmi_send_separate;
	uint32_t num_ocb_vdevs;
	uint32_t num_ocb_channels;
	uint32_t num_ocb_schedules;
	uint32_t flag1;
	uint32_t smart_ant_cap;
	uint32_t bk_minfree;
	uint32_t be_minfree;
	uint32_t vi_minfree;
	uint32_t vo_minfree;
	uint32_t alloc_frag_desc_for_data_pkt;
	uint32_t num_ns_ext_tuples_cfg;
	uint32_t bpf_instruction_size;
	uint32_t max_bssid_rx_filters;
	uint32_t use_pdev_id;
	uint32_t max_num_dbs_scan_duty_cycle;
	uint32_t max_num_group_keys;
	uint32_t peer_map_unmap_v2_support;
	uint32_t sched_params;
	uint32_t twt_ap_pdev_count;
	uint32_t twt_ap_sta_count;
#ifdef notyet /* 6 GHz support */
	uint32_t max_nlo_ssids;
	uint32_t num_pkt_filters;
	uint32_t num_max_sta_vdevs;
	uint32_t max_bssid_indicator;
	uint32_t ul_resp_config;
	uint32_t msdu_flow_override_config0;
	uint32_t msdu_flow_override_config1;
	uint32_t flags2;
	uint32_t host_service_flags;
	uint32_t max_rnr_neighbours;
	uint32_t ema_max_vap_cnt;
	uint32_t ema_max_profile_period;
#endif
} __packed;

struct wmi_service_ready_event {
	uint32_t fw_build_vers;
	struct wmi_abi_version fw_abi_vers;
	uint32_t phy_capability;
	uint32_t max_frag_entry;
	uint32_t num_rf_chains;
	uint32_t ht_cap_info;
	uint32_t vht_cap_info;
	uint32_t vht_supp_mcs;
	uint32_t hw_min_tx_power;
	uint32_t hw_max_tx_power;
	uint32_t sys_cap_info;
	uint32_t min_pkt_size_enable;
	uint32_t max_bcn_ie_size;
	uint32_t num_mem_reqs;
	uint32_t max_num_scan_channels;
	uint32_t hw_bd_id;
	uint32_t hw_bd_info[HW_BD_INFO_SIZE];
	uint32_t max_supported_macs;
	uint32_t wmi_fw_sub_feat_caps;
	uint32_t num_dbs_hw_modes;
	/* txrx_chainmask
	 *    [7:0]   - 2G band tx chain mask
	 *    [15:8]  - 2G band rx chain mask
	 *    [23:16] - 5G band tx chain mask
	 *    [31:24] - 5G band rx chain mask
	 */
	uint32_t txrx_chainmask;
	uint32_t default_dbs_hw_mode_index;
	uint32_t num_msdu_desc;
} __packed;

#define WMI_SERVICE_BM_SIZE	((WMI_MAX_SERVICE + sizeof(uint32_t) - 1) / sizeof(uint32_t))

#define WMI_SERVICE_SEGMENT_BM_SIZE32 4 /* 4x uint32_t = 128 bits */
#define WMI_SERVICE_EXT_BM_SIZE (WMI_SERVICE_SEGMENT_BM_SIZE32 * sizeof(uint32_t))
#define WMI_AVAIL_SERVICE_BITS_IN_SIZE32 32
#define WMI_SERVICE_BITS_IN_SIZE32 4

struct wmi_service_ready_ext_event {
	uint32_t default_conc_scan_config_bits;
	uint32_t default_fw_config_bits;
	struct wmi_ppe_threshold ppet;
	uint32_t he_cap_info;
	uint32_t mpdu_density;
	uint32_t max_bssid_rx_filters;
	uint32_t fw_build_vers_ext;
	uint32_t max_nlo_ssids;
	uint32_t max_bssid_indicator;
	uint32_t he_cap_info_ext;
} __packed;

struct wmi_soc_mac_phy_hw_mode_caps {
	uint32_t num_hw_modes;
	uint32_t num_chainmask_tables;
} __packed;

struct wmi_hw_mode_capabilities {
	uint32_t tlv_header;
	uint32_t hw_mode_id;
	uint32_t phy_id_map;
	uint32_t hw_mode_config_type;
} __packed;

#define WMI_MAX_HECAP_PHY_SIZE                 (3)
#define WMI_NSS_RATIO_ENABLE_DISABLE_BITPOS    BIT(0)
#define WMI_NSS_RATIO_ENABLE_DISABLE_GET(_val) \
	FIELD_GET(WMI_NSS_RATIO_ENABLE_DISABLE_BITPOS, _val)
#define WMI_NSS_RATIO_INFO_BITPOS              GENMASK(4, 1)
#define WMI_NSS_RATIO_INFO_GET(_val) \
	FIELD_GET(WMI_NSS_RATIO_INFO_BITPOS, _val)

struct wmi_mac_phy_capabilities {
	uint32_t hw_mode_id;
	uint32_t pdev_id;
	uint32_t phy_id;
	uint32_t supported_flags;
	uint32_t supported_bands;
	uint32_t ampdu_density;
	uint32_t max_bw_supported_2g;
	uint32_t ht_cap_info_2g;
	uint32_t vht_cap_info_2g;
	uint32_t vht_supp_mcs_2g;
	uint32_t he_cap_info_2g;
	uint32_t he_supp_mcs_2g;
	uint32_t tx_chain_mask_2g;
	uint32_t rx_chain_mask_2g;
	uint32_t max_bw_supported_5g;
	uint32_t ht_cap_info_5g;
	uint32_t vht_cap_info_5g;
	uint32_t vht_supp_mcs_5g;
	uint32_t he_cap_info_5g;
	uint32_t he_supp_mcs_5g;
	uint32_t tx_chain_mask_5g;
	uint32_t rx_chain_mask_5g;
	uint32_t he_cap_phy_info_2g[WMI_MAX_HECAP_PHY_SIZE];
	uint32_t he_cap_phy_info_5g[WMI_MAX_HECAP_PHY_SIZE];
	struct wmi_ppe_threshold he_ppet2g;
	struct wmi_ppe_threshold he_ppet5g;
	uint32_t chainmask_table_id;
	uint32_t lmac_id;
	uint32_t he_cap_info_2g_ext;
	uint32_t he_cap_info_5g_ext;
	uint32_t he_cap_info_internal;
	uint32_t wireless_modes;
	uint32_t low_2ghz_chan_freq;
	uint32_t high_2ghz_chan_freq;
	uint32_t low_5ghz_chan_freq;
	uint32_t high_5ghz_chan_freq;
	uint32_t nss_ratio;
} __packed;

struct wmi_hal_reg_capabilities_ext {
	uint32_t tlv_header;
	uint32_t phy_id;
	uint32_t eeprom_reg_domain;
	uint32_t eeprom_reg_domain_ext;
	uint32_t regcap1;
	uint32_t regcap2;
	uint32_t wireless_modes;
	uint32_t low_2ghz_chan;
	uint32_t high_2ghz_chan;
	uint32_t low_5ghz_chan;
	uint32_t high_5ghz_chan;
} __packed;

struct wmi_soc_hal_reg_capabilities {
	uint32_t num_phy;
} __packed;

/* 2 word representation of MAC addr */
struct wmi_mac_addr {
	union {
		uint8_t addr[6];
		struct {
			uint32_t word0;
			uint32_t word1;
		} __packed;
	} __packed;
} __packed;

struct wmi_dma_ring_capabilities {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t module_id;
	uint32_t min_elem;
	uint32_t min_buf_sz;
	uint32_t min_buf_align;
} __packed;

struct wmi_ready_event_min {
	struct wmi_abi_version fw_abi_vers;
	struct wmi_mac_addr mac_addr;
	uint32_t status;
	uint32_t num_dscp_table;
	uint32_t num_extra_mac_addr;
	uint32_t num_total_peers;
	uint32_t num_extra_peers;
} __packed;

struct wmi_ready_event {
	struct wmi_ready_event_min ready_event_min;
	uint32_t max_ast_index;
	uint32_t pktlog_defs_checksum;
} __packed;

struct wmi_service_available_event {
	uint32_t wmi_service_segment_offset;
	uint32_t wmi_service_segment_bitmap[WMI_SERVICE_SEGMENT_BM_SIZE32];
} __packed;

struct vdev_create_params {
	uint8_t if_id;
	uint32_t type;
	uint32_t subtype;
	struct {
		uint8_t tx;
		uint8_t rx;
	} chains[2];
	uint32_t pdev_id;
	uint32_t mbssid_flags;
	uint32_t mbssid_tx_vdev_id;
};

struct wmi_vdev_create_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t vdev_type;
	uint32_t vdev_subtype;
	struct wmi_mac_addr vdev_macaddr;
	uint32_t num_cfg_txrx_streams;
	uint32_t pdev_id;
	uint32_t mbssid_flags;
	uint32_t mbssid_tx_vdev_id;
} __packed;

struct wmi_vdev_txrx_streams {
	uint32_t tlv_header;
	uint32_t band;
	uint32_t supported_tx_streams;
	uint32_t supported_rx_streams;
} __packed;

struct wmi_vdev_delete_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
} __packed;

struct wmi_vdev_up_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t vdev_assoc_id;
	struct wmi_mac_addr vdev_bssid;
	struct wmi_mac_addr tx_vdev_bssid;
	uint32_t nontx_profile_idx;
	uint32_t nontx_profile_cnt;
} __packed;

struct wmi_vdev_stop_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
} __packed;

struct wmi_vdev_down_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
} __packed;

#define WMI_VDEV_START_HIDDEN_SSID  BIT(0)
#define WMI_VDEV_START_PMF_ENABLED  BIT(1)
#define WMI_VDEV_START_LDPC_RX_ENABLED BIT(3)
#define WMI_VDEV_START_HW_ENCRYPTION_DISABLED BIT(4)

struct wmi_ssid {
	uint32_t ssid_len;
	uint32_t ssid[8];
} __packed;

#define ATH11K_VDEV_SETUP_TIMEOUT_HZ (1 * HZ)

struct wmi_vdev_start_request_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t requestor_id;
	uint32_t beacon_interval;
	uint32_t dtim_period;
	uint32_t flags;
	struct wmi_ssid ssid;
	uint32_t bcn_tx_rate;
	uint32_t bcn_txpower;
	uint32_t num_noa_descriptors;
	uint32_t disable_hw_ack;
	uint32_t preferred_tx_streams;
	uint32_t preferred_rx_streams;
	uint32_t he_ops;
	uint32_t cac_duration_ms;
	uint32_t regdomain;
	uint32_t min_data_rate;
	uint32_t mbssid_flags;
	uint32_t mbssid_tx_vdev_id;
} __packed;

#define MGMT_TX_DL_FRM_LEN		     64
#define WMI_MAC_MAX_SSID_LENGTH              32
struct mac_ssid {
	uint8_t length;
	uint8_t mac_ssid[WMI_MAC_MAX_SSID_LENGTH];
} __packed;

struct wmi_p2p_noa_descriptor {
	uint32_t type_count;
	uint32_t duration;
	uint32_t interval;
	uint32_t start_time;
};

struct channel_param {
	uint8_t chan_id;
	uint8_t pwr;
	uint32_t mhz;
	uint32_t half_rate:1,
	    quarter_rate:1,
	    dfs_set:1,
	    dfs_set_cfreq2:1,
	    is_chan_passive:1,
	    allow_ht:1,
	    allow_vht:1,
	    allow_he:1,
	    set_agile:1,
	    psc_channel:1;
	uint32_t phy_mode;
	uint32_t cfreq1;
	uint32_t cfreq2;
	char   maxpower;
	char   minpower;
	char   maxregpower;
	uint8_t  antennamax;
	uint8_t  reg_class_id;
} __packed;

enum wmi_phy_mode {
	MODE_11A        = 0,
	MODE_11G        = 1,   /* 11b/g Mode */
	MODE_11B        = 2,   /* 11b Mode */
	MODE_11GONLY    = 3,   /* 11g only Mode */
	MODE_11NA_HT20   = 4,
	MODE_11NG_HT20   = 5,
	MODE_11NA_HT40   = 6,
	MODE_11NG_HT40   = 7,
	MODE_11AC_VHT20 = 8,
	MODE_11AC_VHT40 = 9,
	MODE_11AC_VHT80 = 10,
	MODE_11AC_VHT20_2G = 11,
	MODE_11AC_VHT40_2G = 12,
	MODE_11AC_VHT80_2G = 13,
	MODE_11AC_VHT80_80 = 14,
	MODE_11AC_VHT160 = 15,
	MODE_11AX_HE20 = 16,
	MODE_11AX_HE40 = 17,
	MODE_11AX_HE80 = 18,
	MODE_11AX_HE80_80 = 19,
	MODE_11AX_HE160 = 20,
	MODE_11AX_HE20_2G = 21,
	MODE_11AX_HE40_2G = 22,
	MODE_11AX_HE80_2G = 23,
	MODE_UNKNOWN = 24,
	MODE_MAX = 24
};

static inline const char *qwx_wmi_phymode_str(enum wmi_phy_mode mode)
{
	switch (mode) {
	case MODE_11A:
		return "11a";
	case MODE_11G:
		return "11g";
	case MODE_11B:
		return "11b";
	case MODE_11GONLY:
		return "11gonly";
	case MODE_11NA_HT20:
		return "11na-ht20";
	case MODE_11NG_HT20:
		return "11ng-ht20";
	case MODE_11NA_HT40:
		return "11na-ht40";
	case MODE_11NG_HT40:
		return "11ng-ht40";
	case MODE_11AC_VHT20:
		return "11ac-vht20";
	case MODE_11AC_VHT40:
		return "11ac-vht40";
	case MODE_11AC_VHT80:
		return "11ac-vht80";
	case MODE_11AC_VHT160:
		return "11ac-vht160";
	case MODE_11AC_VHT80_80:
		return "11ac-vht80+80";
	case MODE_11AC_VHT20_2G:
		return "11ac-vht20-2g";
	case MODE_11AC_VHT40_2G:
		return "11ac-vht40-2g";
	case MODE_11AC_VHT80_2G:
		return "11ac-vht80-2g";
	case MODE_11AX_HE20:
		return "11ax-he20";
	case MODE_11AX_HE40:
		return "11ax-he40";
	case MODE_11AX_HE80:
		return "11ax-he80";
	case MODE_11AX_HE80_80:
		return "11ax-he80+80";
	case MODE_11AX_HE160:
		return "11ax-he160";
	case MODE_11AX_HE20_2G:
		return "11ax-he20-2g";
	case MODE_11AX_HE40_2G:
		return "11ax-he40-2g";
	case MODE_11AX_HE80_2G:
		return "11ax-he80-2g";
	case MODE_UNKNOWN:
		/* skip */
		break;

		/* no default handler to allow compiler to check that the
		 * enum is fully handled
		 */
	}

	return "<unknown>";
}

struct wmi_channel_arg {
	uint32_t freq;
	uint32_t band_center_freq1;
	uint32_t band_center_freq2;
	bool passive;
	bool allow_ibss;
	bool allow_ht;
	bool allow_vht;
	bool ht40plus;
	bool chan_radar;
	bool freq2_radar;
	bool allow_he;
	uint32_t min_power;
	uint32_t max_power;
	uint32_t max_reg_power;
	uint32_t max_antenna_gain;
	enum wmi_phy_mode mode;
};

struct wmi_vdev_start_req_arg {
	uint32_t vdev_id;
	struct wmi_channel_arg channel;
	uint32_t bcn_intval;
	uint32_t dtim_period;
	uint8_t *ssid;
	uint32_t ssid_len;
	uint32_t bcn_tx_rate;
	uint32_t bcn_tx_power;
	bool disable_hw_ack;
	bool hidden_ssid;
	bool pmf_enabled;
	uint32_t he_ops;
	uint32_t cac_duration_ms;
	uint32_t regdomain;
	uint32_t pref_rx_streams;
	uint32_t pref_tx_streams;
	uint32_t num_noa_descriptors;
	uint32_t min_data_rate;
	uint32_t mbssid_flags;
	uint32_t mbssid_tx_vdev_id;
};

struct peer_create_params {
	uint8_t *peer_addr;
	uint32_t peer_type;
	uint32_t vdev_id;
};

struct peer_delete_params {
	uint8_t vdev_id;
};

struct peer_flush_params {
	uint32_t peer_tid_bitmap;
	uint8_t vdev_id;
};

struct pdev_set_regdomain_params {
	uint16_t current_rd_in_use;
	uint16_t current_rd_2g;
	uint16_t current_rd_5g;
	uint32_t ctl_2g;
	uint32_t ctl_5g;
	uint8_t dfs_domain;
	uint32_t pdev_id;
};

struct rx_reorder_queue_remove_params {
	uint8_t *peer_macaddr;
	uint16_t vdev_id;
	uint32_t peer_tid_bitmap;
};

#define WMI_HOST_PDEV_ID_SOC 0xFF
#define WMI_HOST_PDEV_ID_0   0
#define WMI_HOST_PDEV_ID_1   1
#define WMI_HOST_PDEV_ID_2   2

#define WMI_PDEV_ID_SOC         0
#define WMI_PDEV_ID_1ST         1
#define WMI_PDEV_ID_2ND         2
#define WMI_PDEV_ID_3RD         3

/* Freq units in MHz */
#define REG_RULE_START_FREQ			0x0000ffff
#define REG_RULE_END_FREQ			0xffff0000
#define REG_RULE_FLAGS				0x0000ffff
#define REG_RULE_MAX_BW				0x0000ffff
#define REG_RULE_REG_PWR			0x00ff0000
#define REG_RULE_ANT_GAIN			0xff000000
#define REG_RULE_PSD_INFO			BIT(0)
#define REG_RULE_PSD_EIRP			0xff0000

#define WMI_VDEV_PARAM_TXBF_SU_TX_BFEE BIT(0)
#define WMI_VDEV_PARAM_TXBF_MU_TX_BFEE BIT(1)
#define WMI_VDEV_PARAM_TXBF_SU_TX_BFER BIT(2)
#define WMI_VDEV_PARAM_TXBF_MU_TX_BFER BIT(3)

#define HE_PHYCAP_BYTE_0	0
#define HE_PHYCAP_BYTE_1	1
#define HE_PHYCAP_BYTE_2	2
#define HE_PHYCAP_BYTE_3	3
#define HE_PHYCAP_BYTE_4	4

#define HECAP_PHY_SU_BFER		BIT(7)
#define HECAP_PHY_SU_BFEE		BIT(0)
#define HECAP_PHY_MU_BFER		BIT(1)
#define HECAP_PHY_UL_MUMIMO		BIT(6)
#define HECAP_PHY_UL_MUOFDMA		BIT(7)

#define HECAP_PHY_SUBFMR_GET(hecap_phy) \
	FIELD_GET(HECAP_PHY_SU_BFER, hecap_phy[HE_PHYCAP_BYTE_3])

#define HECAP_PHY_SUBFME_GET(hecap_phy) \
	FIELD_GET(HECAP_PHY_SU_BFEE, hecap_phy[HE_PHYCAP_BYTE_4])

#define HECAP_PHY_MUBFMR_GET(hecap_phy) \
	FIELD_GET(HECAP_PHY_MU_BFER, hecap_phy[HE_PHYCAP_BYTE_4])

#define HECAP_PHY_ULMUMIMO_GET(hecap_phy) \
	FIELD_GET(HECAP_PHY_UL_MUMIMO, hecap_phy[HE_PHYCAP_BYTE_2])

#define HECAP_PHY_ULOFDMA_GET(hecap_phy) \
	FIELD_GET(HECAP_PHY_UL_MUOFDMA, hecap_phy[HE_PHYCAP_BYTE_2])

#define HE_MODE_SU_TX_BFEE	BIT(0)
#define HE_MODE_SU_TX_BFER	BIT(1)
#define HE_MODE_MU_TX_BFEE	BIT(2)
#define HE_MODE_MU_TX_BFER	BIT(3)
#define HE_MODE_DL_OFDMA	BIT(4)
#define HE_MODE_UL_OFDMA	BIT(5)
#define HE_MODE_UL_MUMIMO	BIT(6)

#define HE_DL_MUOFDMA_ENABLE	1
#define HE_UL_MUOFDMA_ENABLE	1
#define HE_DL_MUMIMO_ENABLE	1
#define HE_UL_MUMIMO_ENABLE	1
#define HE_MU_BFEE_ENABLE	1
#define HE_SU_BFEE_ENABLE	1
#define HE_MU_BFER_ENABLE	1
#define HE_SU_BFER_ENABLE	1

#define HE_VHT_SOUNDING_MODE_ENABLE		1
#define HE_SU_MU_SOUNDING_MODE_ENABLE		1
#define HE_TRIG_NONTRIG_SOUNDING_MODE_ENABLE	1

/* HE or VHT Sounding */
#define HE_VHT_SOUNDING_MODE		BIT(0)
/* SU or MU Sounding */
#define HE_SU_MU_SOUNDING_MODE		BIT(2)
/* Trig or Non-Trig Sounding */
#define HE_TRIG_NONTRIG_SOUNDING_MODE	BIT(3)

#define WMI_TXBF_STS_CAP_OFFSET_LSB	4
#define WMI_TXBF_STS_CAP_OFFSET_MASK	0x70
#define WMI_BF_SOUND_DIM_OFFSET_LSB	8
#define WMI_BF_SOUND_DIM_OFFSET_MASK	0x700

struct pdev_params {
	uint32_t param_id;
	uint32_t param_value;
};

enum wmi_peer_type {
	WMI_PEER_TYPE_DEFAULT = 0,
	WMI_PEER_TYPE_BSS = 1,
	WMI_PEER_TYPE_TDLS = 2,
};

struct wmi_peer_create_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t peer_type;
} __packed;

struct wmi_peer_delete_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
} __packed;

struct wmi_peer_reorder_queue_setup_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t tid;
	uint32_t queue_ptr_lo;
	uint32_t queue_ptr_hi;
	uint32_t queue_no;
	uint32_t ba_window_size_valid;
	uint32_t ba_window_size;
} __packed;

struct wmi_peer_reorder_queue_remove_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t tid_mask;
} __packed;

struct gpio_config_params {
	uint32_t gpio_num;
	uint32_t input;
	uint32_t pull_type;
	uint32_t intr_mode;
};

enum wmi_gpio_type {
	WMI_GPIO_PULL_NONE,
	WMI_GPIO_PULL_UP,
	WMI_GPIO_PULL_DOWN
};

enum wmi_gpio_intr_type {
	WMI_GPIO_INTTYPE_DISABLE,
	WMI_GPIO_INTTYPE_RISING_EDGE,
	WMI_GPIO_INTTYPE_FALLING_EDGE,
	WMI_GPIO_INTTYPE_BOTH_EDGE,
	WMI_GPIO_INTTYPE_LEVEL_LOW,
	WMI_GPIO_INTTYPE_LEVEL_HIGH
};

enum wmi_bss_chan_info_req_type {
	WMI_BSS_SURVEY_REQ_TYPE_READ = 1,
	WMI_BSS_SURVEY_REQ_TYPE_READ_CLEAR,
};

struct wmi_gpio_config_cmd_param {
	uint32_t tlv_header;
	uint32_t gpio_num;
	uint32_t input;
	uint32_t pull_type;
	uint32_t intr_mode;
};

struct gpio_output_params {
	uint32_t gpio_num;
	uint32_t set;
};

struct wmi_gpio_output_cmd_param {
	uint32_t tlv_header;
	uint32_t gpio_num;
	uint32_t set;
};

struct set_fwtest_params {
	uint32_t arg;
	uint32_t value;
};

struct wmi_fwtest_set_param_cmd_param {
	uint32_t tlv_header;
	uint32_t param_id;
	uint32_t param_value;
};

struct wmi_pdev_set_param_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t param_id;
	uint32_t param_value;
} __packed;

struct wmi_pdev_set_ps_mode_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t sta_ps_mode;
} __packed;

struct wmi_pdev_suspend_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t suspend_opt;
} __packed;

struct wmi_pdev_resume_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
} __packed;

struct wmi_pdev_bss_chan_info_req_cmd {
	uint32_t tlv_header;
	/* ref wmi_bss_chan_info_req_type */
	uint32_t req_type;
	uint32_t pdev_id;
} __packed;

struct wmi_ap_ps_peer_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t param;
	uint32_t value;
} __packed;

struct wmi_sta_powersave_param_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t param;
	uint32_t value;
} __packed;

struct wmi_pdev_set_regdomain_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t reg_domain;
	uint32_t reg_domain_2g;
	uint32_t reg_domain_5g;
	uint32_t conformance_test_limit_2g;
	uint32_t conformance_test_limit_5g;
	uint32_t dfs_domain;
} __packed;

struct wmi_peer_set_param_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t param_id;
	uint32_t param_value;
} __packed;

struct wmi_peer_flush_tids_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t peer_tid_bitmap;
} __packed;

struct wmi_dfs_phyerr_offload_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
} __packed;

struct wmi_bcn_offload_ctrl_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t bcn_ctrl_op;
} __packed;

enum scan_dwelltime_adaptive_mode {
	SCAN_DWELL_MODE_DEFAULT = 0,
	SCAN_DWELL_MODE_CONSERVATIVE = 1,
	SCAN_DWELL_MODE_MODERATE = 2,
	SCAN_DWELL_MODE_AGGRESSIVE = 3,
	SCAN_DWELL_MODE_STATIC = 4
};

#define WLAN_SSID_MAX_LEN 32

struct element_info {
	uint32_t len;
	uint8_t *ptr;
};

struct wlan_ssid {
	uint8_t length;
	uint8_t ssid[WLAN_SSID_MAX_LEN];
};

#define WMI_IE_BITMAP_SIZE             8

/* prefix used by scan requestor ids on the host */
#define WMI_HOST_SCAN_REQUESTOR_ID_PREFIX 0xA000

/* prefix used by scan request ids generated on the host */
/* host cycles through the lower 12 bits to generate ids */
#define WMI_HOST_SCAN_REQ_ID_PREFIX 0xA000

/* Values lower than this may be refused by some firmware revisions with a scan
 * completion with a timedout reason.
 */
#define WMI_SCAN_CHAN_MIN_TIME_MSEC 40

/* Scan priority numbers must be sequential, starting with 0 */
enum wmi_scan_priority {
	WMI_SCAN_PRIORITY_VERY_LOW = 0,
	WMI_SCAN_PRIORITY_LOW,
	WMI_SCAN_PRIORITY_MEDIUM,
	WMI_SCAN_PRIORITY_HIGH,
	WMI_SCAN_PRIORITY_VERY_HIGH,
	WMI_SCAN_PRIORITY_COUNT   /* number of priorities supported */
};

enum wmi_scan_event_type {
	WMI_SCAN_EVENT_STARTED              = BIT(0),
	WMI_SCAN_EVENT_COMPLETED            = BIT(1),
	WMI_SCAN_EVENT_BSS_CHANNEL          = BIT(2),
	WMI_SCAN_EVENT_FOREIGN_CHAN         = BIT(3),
	WMI_SCAN_EVENT_DEQUEUED             = BIT(4),
	/* possibly by high-prio scan */
	WMI_SCAN_EVENT_PREEMPTED            = BIT(5),
	WMI_SCAN_EVENT_START_FAILED         = BIT(6),
	WMI_SCAN_EVENT_RESTARTED            = BIT(7),
	WMI_SCAN_EVENT_FOREIGN_CHAN_EXIT    = BIT(8),
	WMI_SCAN_EVENT_SUSPENDED            = BIT(9),
	WMI_SCAN_EVENT_RESUMED              = BIT(10),
	WMI_SCAN_EVENT_MAX                  = BIT(15),
};

enum wmi_scan_completion_reason {
	WMI_SCAN_REASON_COMPLETED,
	WMI_SCAN_REASON_CANCELLED,
	WMI_SCAN_REASON_PREEMPTED,
	WMI_SCAN_REASON_TIMEDOUT,
	WMI_SCAN_REASON_INTERNAL_FAILURE,
	WMI_SCAN_REASON_MAX,
};

struct  wmi_start_scan_cmd {
	uint32_t tlv_header;
	uint32_t scan_id;
	uint32_t scan_req_id;
	uint32_t vdev_id;
	uint32_t scan_priority;
	uint32_t notify_scan_events;
	uint32_t dwell_time_active;
	uint32_t dwell_time_passive;
	uint32_t min_rest_time;
	uint32_t max_rest_time;
	uint32_t repeat_probe_time;
	uint32_t probe_spacing_time;
	uint32_t idle_time;
	uint32_t max_scan_time;
	uint32_t probe_delay;
	uint32_t scan_ctrl_flags;
	uint32_t burst_duration;
	uint32_t num_chan;
	uint32_t num_bssid;
	uint32_t num_ssids;
	uint32_t ie_len;
	uint32_t n_probes;
	struct wmi_mac_addr mac_addr;
	struct wmi_mac_addr mac_mask;
	uint32_t ie_bitmap[WMI_IE_BITMAP_SIZE];
	uint32_t num_vendor_oui;
	uint32_t scan_ctrl_flags_ext;
	uint32_t dwell_time_active_2g;
	uint32_t dwell_time_active_6g;
	uint32_t dwell_time_passive_6g;
	uint32_t scan_start_offset;
} __packed;

#define WMI_SCAN_FLAG_PASSIVE        0x1
#define WMI_SCAN_ADD_BCAST_PROBE_REQ 0x2
#define WMI_SCAN_ADD_CCK_RATES       0x4
#define WMI_SCAN_ADD_OFDM_RATES      0x8
#define WMI_SCAN_CHAN_STAT_EVENT     0x10
#define WMI_SCAN_FILTER_PROBE_REQ    0x20
#define WMI_SCAN_BYPASS_DFS_CHN      0x40
#define WMI_SCAN_CONTINUE_ON_ERROR   0x80
#define WMI_SCAN_FILTER_PROMISCUOS   0x100
#define WMI_SCAN_FLAG_FORCE_ACTIVE_ON_DFS 0x200
#define WMI_SCAN_ADD_TPC_IE_IN_PROBE_REQ  0x400
#define WMI_SCAN_ADD_DS_IE_IN_PROBE_REQ   0x800
#define WMI_SCAN_ADD_SPOOF_MAC_IN_PROBE_REQ   0x1000
#define WMI_SCAN_OFFCHAN_MGMT_TX    0x2000
#define WMI_SCAN_OFFCHAN_DATA_TX    0x4000
#define WMI_SCAN_CAPTURE_PHY_ERROR  0x8000
#define WMI_SCAN_FLAG_STRICT_PASSIVE_ON_PCHN 0x10000
#define WMI_SCAN_FLAG_HALF_RATE_SUPPORT      0x20000
#define WMI_SCAN_FLAG_QUARTER_RATE_SUPPORT   0x40000
#define WMI_SCAN_RANDOM_SEQ_NO_IN_PROBE_REQ 0x80000
#define WMI_SCAN_ENABLE_IE_WHTELIST_IN_PROBE_REQ 0x100000

#define WMI_SCAN_DWELL_MODE_MASK 0x00E00000
#define WMI_SCAN_DWELL_MODE_SHIFT        21
#define WMI_SCAN_FLAG_EXT_PASSIVE_SCAN_START_TIME_ENHANCE   0x00000800

#define WMI_SCAN_CONFIG_PER_CHANNEL_MASK	GENMASK(19, 0)
#define WMI_SCAN_CH_FLAG_SCAN_ONLY_IF_RNR_FOUND	BIT(20)

enum {
	WMI_SCAN_DWELL_MODE_DEFAULT      = 0,
	WMI_SCAN_DWELL_MODE_CONSERVATIVE = 1,
	WMI_SCAN_DWELL_MODE_MODERATE     = 2,
	WMI_SCAN_DWELL_MODE_AGGRESSIVE   = 3,
	WMI_SCAN_DWELL_MODE_STATIC       = 4,
};

#define WMI_SCAN_SET_DWELL_MODE(flag, mode) \
	((flag) |= (((mode) << WMI_SCAN_DWELL_MODE_SHIFT) & \
		    WMI_SCAN_DWELL_MODE_MASK))

struct hint_short_ssid {
	uint32_t freq_flags;
	uint32_t short_ssid;
};

struct hint_bssid {
	uint32_t freq_flags;
	struct wmi_mac_addr bssid;
};

struct scan_req_params {
	uint32_t scan_id;
	uint32_t scan_req_id;
	uint32_t vdev_id;
	uint32_t pdev_id;
	enum wmi_scan_priority scan_priority;
	union {
		struct {
			uint32_t scan_ev_started:1,
			    scan_ev_completed:1,
			    scan_ev_bss_chan:1,
			    scan_ev_foreign_chan:1,
			    scan_ev_dequeued:1,
			    scan_ev_preempted:1,
			    scan_ev_start_failed:1,
			    scan_ev_restarted:1,
			    scan_ev_foreign_chn_exit:1,
			    scan_ev_invalid:1,
			    scan_ev_gpio_timeout:1,
			    scan_ev_suspended:1,
			    scan_ev_resumed:1;
		};
		uint32_t scan_events;
	};
	uint32_t scan_ctrl_flags_ext;
	uint32_t dwell_time_active;
	uint32_t dwell_time_active_2g;
	uint32_t dwell_time_passive;
	uint32_t dwell_time_active_6g;
	uint32_t dwell_time_passive_6g;
	uint32_t min_rest_time;
	uint32_t max_rest_time;
	uint32_t repeat_probe_time;
	uint32_t probe_spacing_time;
	uint32_t idle_time;
	uint32_t max_scan_time;
	uint32_t probe_delay;
	union {
		struct {
			uint32_t scan_f_passive:1,
			    scan_f_bcast_probe:1,
			    scan_f_cck_rates:1,
			    scan_f_ofdm_rates:1,
			    scan_f_chan_stat_evnt:1,
			    scan_f_filter_prb_req:1,
			    scan_f_bypass_dfs_chn:1,
			    scan_f_continue_on_err:1,
			    scan_f_offchan_mgmt_tx:1,
			    scan_f_offchan_data_tx:1,
			    scan_f_promisc_mode:1,
			    scan_f_capture_phy_err:1,
			    scan_f_strict_passive_pch:1,
			    scan_f_half_rate:1,
			    scan_f_quarter_rate:1,
			    scan_f_force_active_dfs_chn:1,
			    scan_f_add_tpc_ie_in_probe:1,
			    scan_f_add_ds_ie_in_probe:1,
			    scan_f_add_spoofed_mac_in_probe:1,
			    scan_f_add_rand_seq_in_probe:1,
			    scan_f_en_ie_whitelist_in_probe:1,
			    scan_f_forced:1,
			    scan_f_2ghz:1,
			    scan_f_5ghz:1,
			    scan_f_80mhz:1;
		};
		uint32_t scan_flags;
	};
	enum scan_dwelltime_adaptive_mode adaptive_dwell_time_mode;
	uint32_t burst_duration;
	uint32_t num_chan;
	uint32_t num_bssid;
	uint32_t num_ssids;
	uint32_t n_probes;
	uint32_t *chan_list;
	uint32_t notify_scan_events;
	struct wlan_ssid ssid[WLAN_SCAN_PARAMS_MAX_SSID];
	struct wmi_mac_addr bssid_list[WLAN_SCAN_PARAMS_MAX_BSSID];
	struct element_info extraie;
	struct element_info htcap;
	struct element_info vhtcap;
	uint32_t num_hint_s_ssid;
	uint32_t num_hint_bssid;
	struct hint_short_ssid hint_s_ssid[WLAN_SCAN_MAX_HINT_S_SSID];
	struct hint_bssid hint_bssid[WLAN_SCAN_MAX_HINT_BSSID];
	struct wmi_mac_addr mac_addr;
	struct wmi_mac_addr mac_mask;
};

struct wmi_ssid_arg {
	int len;
	const uint8_t *ssid;
};

struct wmi_bssid_arg {
	const uint8_t *bssid;
};

struct wmi_start_scan_arg {
	uint32_t scan_id;
	uint32_t scan_req_id;
	uint32_t vdev_id;
	uint32_t scan_priority;
	uint32_t notify_scan_events;
	uint32_t dwell_time_active;
	uint32_t dwell_time_passive;
	uint32_t min_rest_time;
	uint32_t max_rest_time;
	uint32_t repeat_probe_time;
	uint32_t probe_spacing_time;
	uint32_t idle_time;
	uint32_t max_scan_time;
	uint32_t probe_delay;
	uint32_t scan_ctrl_flags;

	uint32_t ie_len;
	uint32_t n_channels;
	uint32_t n_ssids;
	uint32_t n_bssids;

	uint8_t ie[WLAN_SCAN_PARAMS_MAX_IE_LEN];
	uint32_t channels[64];
	struct wmi_ssid_arg ssids[WLAN_SCAN_PARAMS_MAX_SSID];
	struct wmi_bssid_arg bssids[WLAN_SCAN_PARAMS_MAX_BSSID];
};

#define WMI_SCAN_STOP_ONE       0x00000000
#define WMI_SCN_STOP_VAP_ALL    0x01000000
#define WMI_SCAN_STOP_ALL       0x04000000

/* Prefix 0xA000 indicates that the scan request
 * is trigger by HOST
 */
#define ATH11K_SCAN_ID          0xA000

enum scan_cancel_req_type {
	WLAN_SCAN_CANCEL_SINGLE = 1,
	WLAN_SCAN_CANCEL_VDEV_ALL,
	WLAN_SCAN_CANCEL_PDEV_ALL,
};

struct scan_cancel_param {
	uint32_t requester;
	uint32_t scan_id;
	enum scan_cancel_req_type req_type;
	uint32_t vdev_id;
	uint32_t pdev_id;
};

struct  wmi_bcn_send_from_host_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t data_len;
	union {
		uint32_t frag_ptr;
		uint32_t frag_ptr_lo;
	};
	uint32_t frame_ctrl;
	uint32_t dtim_flag;
	uint32_t bcn_antenna;
	uint32_t frag_ptr_hi;
};

#define WMI_CHAN_INFO_MODE		GENMASK(5, 0)
#define WMI_CHAN_INFO_HT40_PLUS		BIT(6)
#define WMI_CHAN_INFO_PASSIVE		BIT(7)
#define WMI_CHAN_INFO_ADHOC_ALLOWED	BIT(8)
#define WMI_CHAN_INFO_AP_DISABLED	BIT(9)
#define WMI_CHAN_INFO_DFS		BIT(10)
#define WMI_CHAN_INFO_ALLOW_HT		BIT(11)
#define WMI_CHAN_INFO_ALLOW_VHT		BIT(12)
#define WMI_CHAN_INFO_CHAN_CHANGE_CAUSE_CSA	BIT(13)
#define WMI_CHAN_INFO_HALF_RATE		BIT(14)
#define WMI_CHAN_INFO_QUARTER_RATE	BIT(15)
#define WMI_CHAN_INFO_DFS_FREQ2		BIT(16)
#define WMI_CHAN_INFO_ALLOW_HE		BIT(17)
#define WMI_CHAN_INFO_PSC		BIT(18)

#define WMI_CHAN_REG_INFO1_MIN_PWR	GENMASK(7, 0)
#define WMI_CHAN_REG_INFO1_MAX_PWR	GENMASK(15, 8)
#define WMI_CHAN_REG_INFO1_MAX_REG_PWR	GENMASK(23, 16)
#define WMI_CHAN_REG_INFO1_REG_CLS	GENMASK(31, 24)

#define WMI_CHAN_REG_INFO2_ANT_MAX	GENMASK(7, 0)
#define WMI_CHAN_REG_INFO2_MAX_TX_PWR	GENMASK(15, 8)

struct wmi_channel {
	uint32_t tlv_header;
	uint32_t mhz;
	uint32_t band_center_freq1;
	uint32_t band_center_freq2;
	uint32_t info;
	uint32_t reg_info_1;
	uint32_t reg_info_2;
} __packed;

struct wmi_mgmt_params {
	void *tx_frame;
	uint16_t frm_len;
	uint8_t vdev_id;
	uint16_t chanfreq;
	void *pdata;
	uint16_t desc_id;
	uint8_t *macaddr;
};

enum wmi_sta_ps_mode {
	WMI_STA_PS_MODE_DISABLED = 0,
	WMI_STA_PS_MODE_ENABLED = 1,
};

#define WMI_SMPS_MASK_LOWER_16BITS 0xFF
#define WMI_SMPS_MASK_UPPER_3BITS 0x7
#define WMI_SMPS_PARAM_VALUE_SHIFT 29

#define ATH11K_WMI_FW_HANG_ASSERT_TYPE 1
#define ATH11K_WMI_FW_HANG_DELAY 0

/* type, 0:unused 1: ASSERT 2: not respond detect command
 * delay_time_ms, the simulate will delay time
 */

struct wmi_force_fw_hang_cmd {
	uint32_t tlv_header;
	uint32_t type;
	uint32_t delay_time_ms;
};

struct wmi_vdev_set_param_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t param_id;
	uint32_t param_value;
} __packed;

enum wmi_stats_id {
	WMI_REQUEST_PEER_STAT			= BIT(0),
	WMI_REQUEST_AP_STAT			= BIT(1),
	WMI_REQUEST_PDEV_STAT			= BIT(2),
	WMI_REQUEST_VDEV_STAT			= BIT(3),
	WMI_REQUEST_BCNFLT_STAT			= BIT(4),
	WMI_REQUEST_VDEV_RATE_STAT		= BIT(5),
	WMI_REQUEST_INST_STAT			= BIT(6),
	WMI_REQUEST_MIB_STAT			= BIT(7),
	WMI_REQUEST_RSSI_PER_CHAIN_STAT		= BIT(8),
	WMI_REQUEST_CONGESTION_STAT		= BIT(9),
	WMI_REQUEST_PEER_EXTD_STAT		= BIT(10),
	WMI_REQUEST_BCN_STAT			= BIT(11),
	WMI_REQUEST_BCN_STAT_RESET		= BIT(12),
	WMI_REQUEST_PEER_EXTD2_STAT		= BIT(13),
};

struct wmi_request_stats_cmd {
	uint32_t tlv_header;
	enum wmi_stats_id stats_id;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t pdev_id;
} __packed;

struct wmi_get_pdev_temperature_cmd {
	uint32_t tlv_header;
	uint32_t param;
	uint32_t pdev_id;
} __packed;

struct wmi_ftm_seg_hdr {
	uint32_t len;
	uint32_t msgref;
	uint32_t segmentinfo;
	uint32_t pdev_id;
} __packed;

struct wmi_ftm_cmd {
	uint32_t tlv_header;
	struct wmi_ftm_seg_hdr seg_hdr;
	uint8_t data[];
} __packed;

struct wmi_ftm_event_msg {
	struct wmi_ftm_seg_hdr seg_hdr;
	uint8_t data[];
} __packed;

#define WMI_BEACON_TX_BUFFER_SIZE	512

#define WMI_EMA_TMPL_IDX_SHIFT            8
#define WMI_EMA_FIRST_TMPL_SHIFT          16
#define WMI_EMA_LAST_TMPL_SHIFT           24

struct wmi_bcn_tmpl_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t tim_ie_offset;
	uint32_t buf_len;
	uint32_t csa_switch_count_offset;
	uint32_t ext_csa_switch_count_offset;
	uint32_t csa_event_bitmap;
	uint32_t mbssid_ie_offset;
	uint32_t esp_ie_offset;
	uint32_t csc_switch_count_offset;
	uint32_t csc_event_bitmap;
	uint32_t mu_edca_ie_offset;
	uint32_t feature_enable_bitmap;
	uint32_t ema_params;
} __packed;

struct wmi_key_seq_counter {
	uint32_t key_seq_counter_l;
	uint32_t key_seq_counter_h;
} __packed;

struct wmi_vdev_install_key_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t key_idx;
	uint32_t key_flags;
	uint32_t key_cipher;
	struct wmi_key_seq_counter key_rsc_counter;
	struct wmi_key_seq_counter key_global_rsc_counter;
	struct wmi_key_seq_counter key_tsc_counter;
	uint8_t wpi_key_rsc_counter[16];
	uint8_t wpi_key_tsc_counter[16];
	uint32_t key_len;
	uint32_t key_txmic_len;
	uint32_t key_rxmic_len;
	uint32_t is_group_key_id_valid;
	uint32_t group_key_id;

	/* Followed by key_data containing key followed by
	 * tx mic and then rx mic
	 */
} __packed;

struct wmi_vdev_install_key_arg {
	uint32_t vdev_id;
	const uint8_t *macaddr;
	uint32_t key_idx;
	uint32_t key_flags;
	uint32_t key_cipher;
	uint32_t key_len;
	uint32_t key_txmic_len;
	uint32_t key_rxmic_len;
	uint64_t key_rsc_counter;
	const void *key_data;
};

#define WMI_MAX_SUPPORTED_RATES			128
#define WMI_HOST_MAX_HECAP_PHY_SIZE		3
#define WMI_HOST_MAX_HE_RATE_SET		3
#define WMI_HECAP_TXRX_MCS_NSS_IDX_80		0
#define WMI_HECAP_TXRX_MCS_NSS_IDX_160		1
#define WMI_HECAP_TXRX_MCS_NSS_IDX_80_80	2

struct wmi_rate_set_arg {
	uint32_t num_rates;
	uint8_t rates[WMI_MAX_SUPPORTED_RATES];
};

struct peer_assoc_params {
	struct wmi_mac_addr peer_macaddr;
	uint32_t vdev_id;
	uint32_t peer_new_assoc;
	uint32_t peer_associd;
	uint32_t peer_flags;
	uint32_t peer_caps;
	uint32_t peer_listen_intval;
	uint32_t peer_ht_caps;
	uint32_t peer_max_mpdu;
	uint32_t peer_mpdu_density;
	uint32_t peer_rate_caps;
	uint32_t peer_nss;
	uint32_t peer_vht_caps;
	uint32_t peer_phymode;
	uint32_t peer_ht_info[2];
	struct wmi_rate_set_arg peer_legacy_rates;
	struct wmi_rate_set_arg peer_ht_rates;
	uint32_t rx_max_rate;
	uint32_t rx_mcs_set;
	uint32_t tx_max_rate;
	uint32_t tx_mcs_set;
	uint8_t vht_capable;
	uint8_t min_data_rate;
	uint32_t tx_max_mcs_nss;
	uint32_t peer_bw_rxnss_override;
	bool is_pmf_enabled;
	bool is_wme_set;
	bool qos_flag;
	bool apsd_flag;
	bool ht_flag;
	bool bw_40;
	bool bw_80;
	bool bw_160;
	bool stbc_flag;
	bool ldpc_flag;
	bool static_mimops_flag;
	bool dynamic_mimops_flag;
	bool spatial_mux_flag;
	bool vht_flag;
	bool vht_ng_flag;
	bool need_ptk_4_way;
	bool need_gtk_2_way;
	bool auth_flag;
	bool safe_mode_enabled;
	bool amsdu_disable;
	/* Use common structure */
	uint8_t peer_mac[IEEE80211_ADDR_LEN];

	bool he_flag;
	uint32_t peer_he_cap_macinfo[2];
	uint32_t peer_he_cap_macinfo_internal;
	uint32_t peer_he_caps_6ghz;
	uint32_t peer_he_ops;
	uint32_t peer_he_cap_phyinfo[WMI_HOST_MAX_HECAP_PHY_SIZE];
	uint32_t peer_he_mcs_count;
	uint32_t peer_he_rx_mcs_set[WMI_HOST_MAX_HE_RATE_SET];
	uint32_t peer_he_tx_mcs_set[WMI_HOST_MAX_HE_RATE_SET];
	bool twt_responder;
	bool twt_requester;
	bool is_assoc;
	struct ath11k_ppe_threshold peer_ppet;
};

struct  wmi_peer_assoc_complete_cmd {
	uint32_t tlv_header;
	struct wmi_mac_addr peer_macaddr;
	uint32_t vdev_id;
	uint32_t peer_new_assoc;
	uint32_t peer_associd;
	uint32_t peer_flags;
	uint32_t peer_caps;
	uint32_t peer_listen_intval;
	uint32_t peer_ht_caps;
	uint32_t peer_max_mpdu;
	uint32_t peer_mpdu_density;
	uint32_t peer_rate_caps;
	uint32_t peer_nss;
	uint32_t peer_vht_caps;
	uint32_t peer_phymode;
	uint32_t peer_ht_info[2];
	uint32_t num_peer_legacy_rates;
	uint32_t num_peer_ht_rates;
	uint32_t peer_bw_rxnss_override;
	struct  wmi_ppe_threshold peer_ppet;
	uint32_t peer_he_cap_info;
	uint32_t peer_he_ops;
	uint32_t peer_he_cap_phy[WMI_MAX_HECAP_PHY_SIZE];
	uint32_t peer_he_mcs;
	uint32_t peer_he_cap_info_ext;
	uint32_t peer_he_cap_info_internal;
	uint32_t min_data_rate;
	uint32_t peer_he_caps_6ghz;
} __packed;

struct wmi_stop_scan_cmd {
	uint32_t tlv_header;
	uint32_t requestor;
	uint32_t scan_id;
	uint32_t req_type;
	uint32_t vdev_id;
	uint32_t pdev_id;
};

struct scan_chan_list_params {
	uint32_t pdev_id;
	uint16_t nallchans;
	struct channel_param ch_param[];
};

struct wmi_scan_chan_list_cmd {
	uint32_t tlv_header;
	uint32_t num_scan_chans;
	uint32_t flags;
	uint32_t pdev_id;
} __packed;

struct wmi_scan_prob_req_oui_cmd {
	uint32_t tlv_header;
	uint32_t prob_req_oui;
}  __packed;

#define WMI_MGMT_SEND_DOWNLD_LEN	64

#define WMI_TX_PARAMS_DWORD0_POWER		GENMASK(7, 0)
#define WMI_TX_PARAMS_DWORD0_MCS_MASK		GENMASK(19, 8)
#define WMI_TX_PARAMS_DWORD0_NSS_MASK		GENMASK(27, 20)
#define WMI_TX_PARAMS_DWORD0_RETRY_LIMIT	GENMASK(31, 28)

#define WMI_TX_PARAMS_DWORD1_CHAIN_MASK		GENMASK(7, 0)
#define WMI_TX_PARAMS_DWORD1_BW_MASK		GENMASK(14, 8)
#define WMI_TX_PARAMS_DWORD1_PREAMBLE_TYPE	GENMASK(19, 15)
#define WMI_TX_PARAMS_DWORD1_FRAME_TYPE		BIT(20)
#define WMI_TX_PARAMS_DWORD1_RSVD		GENMASK(31, 21)

struct wmi_mgmt_send_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t desc_id;
	uint32_t chanfreq;
	uint32_t paddr_lo;
	uint32_t paddr_hi;
	uint32_t frame_len;
	uint32_t buf_len;
	uint32_t tx_params_valid;

	/*
	 * Followed by struct wmi_tlv and buf_len bytes of frame data with
	 * buf_len <= WMI_MGMT_SEND_DOWNLD_LEN, which may be exceeded by
	 * frame_len. The full frame is mapped at paddr_lo/hi.
	 * Presumably the idea is that small frames can skip the extra DMA
	 * transfer of frame data after the command has been transferred.
	 */
} __packed;

struct wmi_sta_powersave_mode_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t sta_ps_mode;
};

struct wmi_sta_smps_force_mode_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t forced_mode;
};

struct wmi_sta_smps_param_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t param;
	uint32_t value;
};

struct wmi_bcn_prb_info {
	uint32_t tlv_header;
	uint32_t caps;
	uint32_t erp;
} __packed;

enum {
	WMI_PDEV_SUSPEND,
	WMI_PDEV_SUSPEND_AND_DISABLE_INTR,
};

struct green_ap_ps_params {
	uint32_t value;
};

struct wmi_pdev_green_ap_ps_enable_cmd_param {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t enable;
};

struct ap_ps_params {
	uint32_t vdev_id;
	uint32_t param;
	uint32_t value;
};

struct vdev_set_params {
	uint32_t if_id;
	uint32_t param_id;
	uint32_t param_value;
};

struct stats_request_params {
	uint32_t stats_id;
	uint32_t vdev_id;
	uint32_t pdev_id;
};

struct wmi_set_current_country_params {
	uint8_t alpha2[3];
};

struct wmi_set_current_country_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t new_alpha2;
} __packed;

enum set_init_cc_type {
	WMI_COUNTRY_INFO_TYPE_ALPHA,
	WMI_COUNTRY_INFO_TYPE_COUNTRY_CODE,
	WMI_COUNTRY_INFO_TYPE_REGDOMAIN,
};

enum set_init_cc_flags {
	INVALID_CC,
	CC_IS_SET,
	REGDMN_IS_SET,
	ALPHA_IS_SET,
};

struct wmi_init_country_params {
	union {
		uint16_t country_code;
		uint16_t regdom_id;
		uint8_t alpha2[3];
	} cc_info;
	enum set_init_cc_flags flags;
};

struct wmi_init_country_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t init_cc_type;
	union {
		uint32_t country_code;
		uint32_t regdom_id;
		uint32_t alpha2;
	} cc_info;
} __packed;

struct wmi_11d_scan_start_params {
	uint32_t vdev_id;
	uint32_t scan_period_msec;
	uint32_t start_interval_msec;
};

struct wmi_11d_scan_start_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t scan_period_msec;
	uint32_t start_interval_msec;
} __packed;

struct wmi_11d_scan_stop_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
} __packed;

struct wmi_11d_new_cc_ev {
	uint32_t new_alpha2;
} __packed;

#define THERMAL_LEVELS  1
struct tt_level_config {
	uint32_t tmplwm;
	uint32_t tmphwm;
	uint32_t dcoffpercent;
	uint32_t priority;
};

struct thermal_mitigation_params {
	uint32_t pdev_id;
	uint32_t enable;
	uint32_t dc;
	uint32_t dc_per_event;
	struct tt_level_config levelconf[THERMAL_LEVELS];
};

struct wmi_therm_throt_config_request_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t enable;
	uint32_t dc;
	uint32_t dc_per_event;
	uint32_t therm_throt_levels;
} __packed;

struct wmi_therm_throt_level_config_info {
	uint32_t tlv_header;
	uint32_t temp_lwm;
	uint32_t temp_hwm;
	uint32_t dc_off_percent;
	uint32_t prio;
} __packed;

struct wmi_delba_send_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t tid;
	uint32_t initiator;
	uint32_t reasoncode;
} __packed;

struct wmi_addba_setresponse_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t tid;
	uint32_t statuscode;
} __packed;

struct wmi_addba_send_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t tid;
	uint32_t buffersize;
} __packed;

struct wmi_addba_clear_resp_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
} __packed;

struct wmi_pdev_pktlog_filter_info {
	uint32_t tlv_header;
	struct wmi_mac_addr peer_macaddr;
} __packed;

struct wmi_pdev_pktlog_filter_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t enable;
	uint32_t filter_type;
	uint32_t num_mac;
} __packed;

enum ath11k_wmi_pktlog_enable {
	ATH11K_WMI_PKTLOG_ENABLE_AUTO  = 0,
	ATH11K_WMI_PKTLOG_ENABLE_FORCE = 1,
};

struct wmi_pktlog_enable_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t evlist; /* WMI_PKTLOG_EVENT */
	uint32_t enable;
} __packed;

struct wmi_pktlog_disable_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
} __packed;

#define DFS_PHYERR_UNIT_TEST_CMD 0
#define DFS_UNIT_TEST_MODULE	0x2b
#define DFS_UNIT_TEST_TOKEN	0xAA

enum dfs_test_args_idx {
	DFS_TEST_CMDID = 0,
	DFS_TEST_PDEV_ID,
	DFS_TEST_RADAR_PARAM,
	DFS_MAX_TEST_ARGS,
};

struct wmi_dfs_unit_test_arg {
	uint32_t cmd_id;
	uint32_t pdev_id;
	uint32_t radar_param;
};

struct wmi_unit_test_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t module_id;
	uint32_t num_args;
	uint32_t diag_token;
	/* Followed by test args*/
} __packed;

#define MAX_SUPPORTED_RATES 128

#define WMI_PEER_AUTH		0x00000001
#define WMI_PEER_QOS		0x00000002
#define WMI_PEER_NEED_PTK_4_WAY	0x00000004
#define WMI_PEER_NEED_GTK_2_WAY	0x00000010
#define WMI_PEER_HE		0x00000400
#define WMI_PEER_APSD		0x00000800
#define WMI_PEER_HT		0x00001000
#define WMI_PEER_40MHZ		0x00002000
#define WMI_PEER_STBC		0x00008000
#define WMI_PEER_LDPC		0x00010000
#define WMI_PEER_DYN_MIMOPS	0x00020000
#define WMI_PEER_STATIC_MIMOPS	0x00040000
#define WMI_PEER_SPATIAL_MUX	0x00200000
#define WMI_PEER_TWT_REQ	0x00400000
#define WMI_PEER_TWT_RESP	0x00800000
#define WMI_PEER_VHT		0x02000000
#define WMI_PEER_80MHZ		0x04000000
#define WMI_PEER_PMF		0x08000000
/* TODO: Place holder for WLAN_PEER_F_PS_PRESEND_REQUIRED = 0x10000000.
 * Need to be cleaned up
 */
#define WMI_PEER_IS_P2P_CAPABLE	0x20000000
#define WMI_PEER_160MHZ		0x40000000
#define WMI_PEER_SAFEMODE_EN	0x80000000

struct beacon_tmpl_params {
	uint8_t vdev_id;
	uint32_t tim_ie_offset;
	uint32_t tmpl_len;
	uint32_t tmpl_len_aligned;
	uint32_t csa_switch_count_offset;
	uint32_t ext_csa_switch_count_offset;
	uint8_t *frm;
};

struct wmi_rate_set {
	uint32_t num_rates;
	uint32_t rates[(MAX_SUPPORTED_RATES / 4) + 1];
};

struct wmi_vht_rate_set {
	uint32_t tlv_header;
	uint32_t rx_max_rate;
	uint32_t rx_mcs_set;
	uint32_t tx_max_rate;
	uint32_t tx_mcs_set;
	uint32_t tx_max_mcs_nss;
} __packed;

struct wmi_he_rate_set {
	uint32_t tlv_header;

	/* MCS at which the peer can receive */
	uint32_t rx_mcs_set;

	/* MCS at which the peer can transmit */
	uint32_t tx_mcs_set;
} __packed;

#define MAX_REG_RULES 10
#define REG_ALPHA2_LEN 2
#define MAX_6GHZ_REG_RULES 5

enum wmi_start_event_param {
	WMI_VDEV_START_RESP_EVENT = 0,
	WMI_VDEV_RESTART_RESP_EVENT,
};

struct wmi_vdev_start_resp_event {
	uint32_t vdev_id;
	uint32_t requestor_id;
	enum wmi_start_event_param resp_type;
	uint32_t status;
	uint32_t chain_mask;
	uint32_t smps_mode;
	union {
		uint32_t mac_id;
		uint32_t pdev_id;
	};
	uint32_t cfgd_tx_streams;
	uint32_t cfgd_rx_streams;
} __packed;

/* VDEV start response status codes */
enum wmi_vdev_start_resp_status_code {
	WMI_VDEV_START_RESPONSE_STATUS_SUCCESS = 0,
	WMI_VDEV_START_RESPONSE_INVALID_VDEVID = 1,
	WMI_VDEV_START_RESPONSE_NOT_SUPPORTED = 2,
	WMI_VDEV_START_RESPONSE_DFS_VIOLATION = 3,
	WMI_VDEV_START_RESPONSE_INVALID_REGDOMAIN = 4,
};

/* Regulatory Rule Flags Passed by FW */
#define REGULATORY_CHAN_DISABLED     BIT(0)
#define REGULATORY_CHAN_NO_IR        BIT(1)
#define REGULATORY_CHAN_RADAR        BIT(3)
#define REGULATORY_CHAN_NO_OFDM      BIT(6)
#define REGULATORY_CHAN_INDOOR_ONLY  BIT(9)

#define REGULATORY_CHAN_NO_HT40      BIT(4)
#define REGULATORY_CHAN_NO_80MHZ     BIT(7)
#define REGULATORY_CHAN_NO_160MHZ    BIT(8)
#define REGULATORY_CHAN_NO_20MHZ     BIT(11)
#define REGULATORY_CHAN_NO_10MHZ     BIT(12)

enum wmi_reg_chan_list_cmd_type {
	WMI_REG_CHAN_LIST_CC_ID = 0,
	WMI_REG_CHAN_LIST_CC_EXT_ID = 1,
};

enum wmi_reg_cc_setting_code {
	WMI_REG_SET_CC_STATUS_PASS = 0,
	WMI_REG_CURRENT_ALPHA2_NOT_FOUND = 1,
	WMI_REG_INIT_ALPHA2_NOT_FOUND = 2,
	WMI_REG_SET_CC_CHANGE_NOT_ALLOWED = 3,
	WMI_REG_SET_CC_STATUS_NO_MEMORY = 4,
	WMI_REG_SET_CC_STATUS_FAIL = 5,

	/* add new setting code above, update in
	 * @enum cc_setting_code as well.
	 * Also handle it in ath11k_wmi_cc_setting_code_to_reg()
	 */
};

enum cc_setting_code {
	REG_SET_CC_STATUS_PASS = 0,
	REG_CURRENT_ALPHA2_NOT_FOUND = 1,
	REG_INIT_ALPHA2_NOT_FOUND = 2,
	REG_SET_CC_CHANGE_NOT_ALLOWED = 3,
	REG_SET_CC_STATUS_NO_MEMORY = 4,
	REG_SET_CC_STATUS_FAIL = 5,

	/* add new setting code above, update in
	 * @enum wmi_reg_cc_setting_code as well.
	 * Also handle it in ath11k_cc_status_to_str()
	 */
};

static inline enum cc_setting_code
qwx_wmi_cc_setting_code_to_reg(enum wmi_reg_cc_setting_code status_code)
{
	switch (status_code) {
	case WMI_REG_SET_CC_STATUS_PASS:
		return REG_SET_CC_STATUS_PASS;
	case WMI_REG_CURRENT_ALPHA2_NOT_FOUND:
		return REG_CURRENT_ALPHA2_NOT_FOUND;
	case WMI_REG_INIT_ALPHA2_NOT_FOUND:
		return REG_INIT_ALPHA2_NOT_FOUND;
	case WMI_REG_SET_CC_CHANGE_NOT_ALLOWED:
		return REG_SET_CC_CHANGE_NOT_ALLOWED;
	case WMI_REG_SET_CC_STATUS_NO_MEMORY:
		return REG_SET_CC_STATUS_NO_MEMORY;
	case WMI_REG_SET_CC_STATUS_FAIL:
		return REG_SET_CC_STATUS_FAIL;
	}

	return REG_SET_CC_STATUS_FAIL;
}

static inline const char *
qwx_cc_status_to_str(enum cc_setting_code code)
{
	switch (code) {
	case REG_SET_CC_STATUS_PASS:
		return "REG_SET_CC_STATUS_PASS";
	case REG_CURRENT_ALPHA2_NOT_FOUND:
		return "REG_CURRENT_ALPHA2_NOT_FOUND";
	case REG_INIT_ALPHA2_NOT_FOUND:
		return "REG_INIT_ALPHA2_NOT_FOUND";
	case REG_SET_CC_CHANGE_NOT_ALLOWED:
		return "REG_SET_CC_CHANGE_NOT_ALLOWED";
	case REG_SET_CC_STATUS_NO_MEMORY:
		return "REG_SET_CC_STATUS_NO_MEMORY";
	case REG_SET_CC_STATUS_FAIL:
		return "REG_SET_CC_STATUS_FAIL";
	}

	return "Unknown CC status";
}

enum wmi_reg_6ghz_ap_type {
	WMI_REG_INDOOR_AP = 0,
	WMI_REG_STANDARD_POWER_AP = 1,
	WMI_REG_VERY_LOW_POWER_AP = 2,

	/* add AP type above, handle in ath11k_6ghz_ap_type_to_str()
	 */
	WMI_REG_CURRENT_MAX_AP_TYPE,
	WMI_REG_MAX_AP_TYPE = 7,
};

static inline const char *
qwx_6ghz_ap_type_to_str(enum wmi_reg_6ghz_ap_type type)
{
	switch (type) {
	case WMI_REG_INDOOR_AP:
		return "INDOOR AP";
	case WMI_REG_STANDARD_POWER_AP:
		return "STANDARD POWER AP";
	case WMI_REG_VERY_LOW_POWER_AP:
		return "VERY LOW POWER AP";
	case WMI_REG_CURRENT_MAX_AP_TYPE:
		return "CURRENT_MAX_AP_TYPE";
	case WMI_REG_MAX_AP_TYPE:
		return "MAX_AP_TYPE";
	}

	return "unknown 6 GHz AP type";
}

enum wmi_reg_6ghz_client_type {
	WMI_REG_DEFAULT_CLIENT = 0,
	WMI_REG_SUBORDINATE_CLIENT = 1,
	WMI_REG_MAX_CLIENT_TYPE = 2,

	/* add client type above, handle it in
	 * ath11k_6ghz_client_type_to_str()
	 */
};

static inline const char *
qwx_6ghz_client_type_to_str(enum wmi_reg_6ghz_client_type type)
{
	switch (type) {
	case WMI_REG_DEFAULT_CLIENT:
		return "DEFAULT CLIENT";
	case WMI_REG_SUBORDINATE_CLIENT:
		return "SUBORDINATE CLIENT";
	case WMI_REG_MAX_CLIENT_TYPE:
		return "MAX_CLIENT_TYPE";
	}

	return "unknown 6 GHz client type";
}

enum reg_subdomains_6ghz {
	EMPTY_6GHZ = 0x0,
	FCC1_CLIENT_LPI_REGULAR_6GHZ = 0x01,
	FCC1_CLIENT_SP_6GHZ = 0x02,
	FCC1_AP_LPI_6GHZ = 0x03,
	FCC1_CLIENT_LPI_SUBORDINATE = FCC1_AP_LPI_6GHZ,
	FCC1_AP_SP_6GHZ = 0x04,
	ETSI1_LPI_6GHZ = 0x10,
	ETSI1_VLP_6GHZ = 0x11,
	ETSI2_LPI_6GHZ = 0x12,
	ETSI2_VLP_6GHZ = 0x13,
	APL1_LPI_6GHZ = 0x20,
	APL1_VLP_6GHZ = 0x21,

	/* add sub-domain above, handle it in
	 * ath11k_sub_reg_6ghz_to_str()
	 */
};

static inline const char *
qwx_sub_reg_6ghz_to_str(enum reg_subdomains_6ghz sub_id)
{
	switch (sub_id) {
	case EMPTY_6GHZ:
		return "N/A";
	case FCC1_CLIENT_LPI_REGULAR_6GHZ:
		return "FCC1_CLIENT_LPI_REGULAR_6GHZ";
	case FCC1_CLIENT_SP_6GHZ:
		return "FCC1_CLIENT_SP_6GHZ";
	case FCC1_AP_LPI_6GHZ:
		return "FCC1_AP_LPI_6GHZ/FCC1_CLIENT_LPI_SUBORDINATE";
	case FCC1_AP_SP_6GHZ:
		return "FCC1_AP_SP_6GHZ";
	case ETSI1_LPI_6GHZ:
		return "ETSI1_LPI_6GHZ";
	case ETSI1_VLP_6GHZ:
		return "ETSI1_VLP_6GHZ";
	case ETSI2_LPI_6GHZ:
		return "ETSI2_LPI_6GHZ";
	case ETSI2_VLP_6GHZ:
		return "ETSI2_VLP_6GHZ";
	case APL1_LPI_6GHZ:
		return "APL1_LPI_6GHZ";
	case APL1_VLP_6GHZ:
		return "APL1_VLP_6GHZ";
	}

	return "unknown sub reg id";
}

enum reg_super_domain_6ghz {
	FCC1_6GHZ = 0x01,
	ETSI1_6GHZ = 0x02,
	ETSI2_6GHZ = 0x03,
	APL1_6GHZ = 0x04,
	FCC1_6GHZ_CL = 0x05,

	/* add super domain above, handle it in
	 * ath11k_super_reg_6ghz_to_str()
	 */
};

static inline const char *
qwx_super_reg_6ghz_to_str(enum reg_super_domain_6ghz domain_id)
{
	switch (domain_id) {
	case FCC1_6GHZ:
		return "FCC1_6GHZ";
	case ETSI1_6GHZ:
		return "ETSI1_6GHZ";
	case ETSI2_6GHZ:
		return "ETSI2_6GHZ";
	case APL1_6GHZ:
		return "APL1_6GHZ";
	case FCC1_6GHZ_CL:
		return "FCC1_6GHZ_CL";
	}

	return "unknown domain id";
}

struct cur_reg_rule {
	uint16_t start_freq;
	uint16_t end_freq;
	uint16_t max_bw;
	uint8_t reg_power;
	uint8_t ant_gain;
	uint16_t flags;
	bool psd_flag;
	int8_t psd_eirp;
};

struct cur_regulatory_info {
	enum cc_setting_code status_code;
	uint8_t num_phy;
	uint8_t phy_id;
	uint16_t reg_dmn_pair;
	uint16_t ctry_code;
	uint8_t alpha2[REG_ALPHA2_LEN + 1];
	uint32_t dfs_region;
	uint32_t phybitmap;
	uint32_t min_bw_2ghz;
	uint32_t max_bw_2ghz;
	uint32_t min_bw_5ghz;
	uint32_t max_bw_5ghz;
	uint32_t num_2ghz_reg_rules;
	uint32_t num_5ghz_reg_rules;
	struct cur_reg_rule *reg_rules_2ghz_ptr;
	struct cur_reg_rule *reg_rules_5ghz_ptr;
	bool is_ext_reg_event;
	enum wmi_reg_6ghz_client_type client_type;
	bool rnr_tpe_usable;
	bool unspecified_ap_usable;
	uint8_t domain_code_6ghz_ap[WMI_REG_CURRENT_MAX_AP_TYPE];
	uint8_t domain_code_6ghz_client[WMI_REG_CURRENT_MAX_AP_TYPE][WMI_REG_MAX_CLIENT_TYPE];
	uint32_t domain_code_6ghz_super_id;
	uint32_t min_bw_6ghz_ap[WMI_REG_CURRENT_MAX_AP_TYPE];
	uint32_t max_bw_6ghz_ap[WMI_REG_CURRENT_MAX_AP_TYPE];
	uint32_t min_bw_6ghz_client[WMI_REG_CURRENT_MAX_AP_TYPE][WMI_REG_MAX_CLIENT_TYPE];
	uint32_t max_bw_6ghz_client[WMI_REG_CURRENT_MAX_AP_TYPE][WMI_REG_MAX_CLIENT_TYPE];
	uint32_t num_6ghz_rules_ap[WMI_REG_CURRENT_MAX_AP_TYPE];
	uint32_t num_6ghz_rules_client[WMI_REG_CURRENT_MAX_AP_TYPE][WMI_REG_MAX_CLIENT_TYPE];
	struct cur_reg_rule *reg_rules_6ghz_ap_ptr[WMI_REG_CURRENT_MAX_AP_TYPE];
	struct cur_reg_rule *reg_rules_6ghz_client_ptr
		[WMI_REG_CURRENT_MAX_AP_TYPE][WMI_REG_MAX_CLIENT_TYPE];
};

struct wmi_reg_chan_list_cc_event {
	uint32_t status_code;
	uint32_t phy_id;
	uint32_t alpha2;
	uint32_t num_phy;
	uint32_t country_id;
	uint32_t domain_code;
	uint32_t dfs_region;
	uint32_t phybitmap;
	uint32_t min_bw_2ghz;
	uint32_t max_bw_2ghz;
	uint32_t min_bw_5ghz;
	uint32_t max_bw_5ghz;
	uint32_t num_2ghz_reg_rules;
	uint32_t num_5ghz_reg_rules;
} __packed;

struct wmi_regulatory_rule_struct {
	uint32_t  tlv_header;
	uint32_t  freq_info;
	uint32_t  bw_pwr_info;
	uint32_t  flag_info;
};

#define WMI_REG_CLIENT_MAX 4

struct wmi_reg_chan_list_cc_ext_event {
	uint32_t status_code;
	uint32_t phy_id;
	uint32_t alpha2;
	uint32_t num_phy;
	uint32_t country_id;
	uint32_t domain_code;
	uint32_t dfs_region;
	uint32_t phybitmap;
	uint32_t min_bw_2ghz;
	uint32_t max_bw_2ghz;
	uint32_t min_bw_5ghz;
	uint32_t max_bw_5ghz;
	uint32_t num_2ghz_reg_rules;
	uint32_t num_5ghz_reg_rules;
	uint32_t client_type;
	uint32_t rnr_tpe_usable;
	uint32_t unspecified_ap_usable;
	uint32_t domain_code_6ghz_ap_lpi;
	uint32_t domain_code_6ghz_ap_sp;
	uint32_t domain_code_6ghz_ap_vlp;
	uint32_t domain_code_6ghz_client_lpi[WMI_REG_CLIENT_MAX];
	uint32_t domain_code_6ghz_client_sp[WMI_REG_CLIENT_MAX];
	uint32_t domain_code_6ghz_client_vlp[WMI_REG_CLIENT_MAX];
	uint32_t domain_code_6ghz_super_id;
	uint32_t min_bw_6ghz_ap_sp;
	uint32_t max_bw_6ghz_ap_sp;
	uint32_t min_bw_6ghz_ap_lpi;
	uint32_t max_bw_6ghz_ap_lpi;
	uint32_t min_bw_6ghz_ap_vlp;
	uint32_t max_bw_6ghz_ap_vlp;
	uint32_t min_bw_6ghz_client_sp[WMI_REG_CLIENT_MAX];
	uint32_t max_bw_6ghz_client_sp[WMI_REG_CLIENT_MAX];
	uint32_t min_bw_6ghz_client_lpi[WMI_REG_CLIENT_MAX];
	uint32_t max_bw_6ghz_client_lpi[WMI_REG_CLIENT_MAX];
	uint32_t min_bw_6ghz_client_vlp[WMI_REG_CLIENT_MAX];
	uint32_t max_bw_6ghz_client_vlp[WMI_REG_CLIENT_MAX];
	uint32_t num_6ghz_reg_rules_ap_sp;
	uint32_t num_6ghz_reg_rules_ap_lpi;
	uint32_t num_6ghz_reg_rules_ap_vlp;
	uint32_t num_6ghz_reg_rules_client_sp[WMI_REG_CLIENT_MAX];
	uint32_t num_6ghz_reg_rules_client_lpi[WMI_REG_CLIENT_MAX];
	uint32_t num_6ghz_reg_rules_client_vlp[WMI_REG_CLIENT_MAX];
} __packed;

struct wmi_regulatory_ext_rule {
	uint32_t tlv_header;
	uint32_t freq_info;
	uint32_t bw_pwr_info;
	uint32_t flag_info;
	uint32_t psd_power_info;
} __packed;

struct wmi_vdev_delete_resp_event {
	uint32_t vdev_id;
} __packed;

struct wmi_peer_delete_resp_event {
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
} __packed;

struct wmi_bcn_tx_status_event {
	uint32_t vdev_id;
	uint32_t tx_status;
} __packed;

struct wmi_vdev_stopped_event {
	uint32_t vdev_id;
} __packed;

struct wmi_pdev_bss_chan_info_event {
	uint32_t freq;	/* Units in MHz */
	uint32_t noise_floor;	/* units are dBm */
	/* rx clear - how often the channel was unused */
	uint32_t rx_clear_count_low;
	uint32_t rx_clear_count_high;
	/* cycle count - elapsed time during measured period, in clock ticks */
	uint32_t cycle_count_low;
	uint32_t cycle_count_high;
	/* tx cycle count - elapsed time spent in tx, in clock ticks */
	uint32_t tx_cycle_count_low;
	uint32_t tx_cycle_count_high;
	/* rx cycle count - elapsed time spent in rx, in clock ticks */
	uint32_t rx_cycle_count_low;
	uint32_t rx_cycle_count_high;
	/*rx_cycle cnt for my bss in 64bits format */
	uint32_t rx_bss_cycle_count_low;
	uint32_t rx_bss_cycle_count_high;
	uint32_t pdev_id;
} __packed;

#define WMI_VDEV_INSTALL_KEY_COMPL_STATUS_SUCCESS 0

struct wmi_vdev_install_key_compl_event {
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t key_idx;
	uint32_t key_flags;
	uint32_t status;
} __packed;

struct wmi_vdev_install_key_complete_arg {
	uint32_t vdev_id;
	const uint8_t *macaddr;
	uint32_t key_idx;
	uint32_t key_flags;
	uint32_t status;
};

struct wmi_peer_assoc_conf_event {
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
} __packed;

struct wmi_peer_assoc_conf_arg {
	uint32_t vdev_id;
	const uint8_t *macaddr;
};

struct wmi_fils_discovery_event {
	uint32_t vdev_id;
	uint32_t fils_tt;
	uint32_t tbtt;
} __packed;

struct wmi_probe_resp_tx_status_event {
	uint32_t vdev_id;
	uint32_t tx_status;
} __packed;

/*
 * PDEV statistics
 */
struct wmi_pdev_stats_base {
	int32_t chan_nf;
	uint32_t tx_frame_count; /* Cycles spent transmitting frames */
	uint32_t rx_frame_count; /* Cycles spent receiving frames */
	uint32_t rx_clear_count; /* Total channel busy time, evidently */
	uint32_t cycle_count; /* Total on-channel time */
	uint32_t phy_err_count;
	uint32_t chan_tx_pwr;
} __packed;

struct wmi_pdev_stats_extra {
	uint32_t ack_rx_bad;
	uint32_t rts_bad;
	uint32_t rts_good;
	uint32_t fcs_bad;
	uint32_t no_beacons;
	uint32_t mib_int_count;
} __packed;

struct wmi_pdev_stats_tx {
	/* Num HTT cookies queued to dispatch list */
	int32_t comp_queued;

	/* Num HTT cookies dispatched */
	int32_t comp_delivered;

	/* Num MSDU queued to WAL */
	int32_t msdu_enqued;

	/* Num MPDU queue to WAL */
	int32_t mpdu_enqued;

	/* Num MSDUs dropped by WMM limit */
	int32_t wmm_drop;

	/* Num Local frames queued */
	int32_t local_enqued;

	/* Num Local frames done */
	int32_t local_freed;

	/* Num queued to HW */
	int32_t hw_queued;

	/* Num PPDU reaped from HW */
	int32_t hw_reaped;

	/* Num underruns */
	int32_t underrun;

	/* Num hw paused */
	uint32_t hw_paused;

	/* Num PPDUs cleaned up in TX abort */
	int32_t tx_abort;

	/* Num MPDUs requeued by SW */
	int32_t mpdus_requeued;

	/* excessive retries */
	uint32_t tx_ko;

	uint32_t tx_xretry;

	/* data hw rate code */
	uint32_t data_rc;

	/* Scheduler self triggers */
	uint32_t self_triggers;

	/* frames dropped due to excessive sw retries */
	uint32_t sw_retry_failure;

	/* illegal rate phy errors  */
	uint32_t illgl_rate_phy_err;

	/* wal pdev continuous xretry */
	uint32_t pdev_cont_xretry;

	/* wal pdev tx timeouts */
	uint32_t pdev_tx_timeout;

	/* wal pdev resets  */
	uint32_t pdev_resets;

	/* frames dropped due to non-availability of stateless TIDs */
	uint32_t stateless_tid_alloc_failure;

	/* PhY/BB underrun */
	uint32_t phy_underrun;

	/* MPDU is more than txop limit */
	uint32_t txop_ovf;

	/* Num sequences posted */
	uint32_t seq_posted;

	/* Num sequences failed in queueing */
	uint32_t seq_failed_queueing;

	/* Num sequences completed */
	uint32_t seq_completed;

	/* Num sequences restarted */
	uint32_t seq_restarted;

	/* Num of MU sequences posted */
	uint32_t mu_seq_posted;

	/* Num MPDUs flushed by SW, HWPAUSED, SW TXABORT
	 * (Reset,channel change)
	 */
	int32_t mpdus_sw_flush;

	/* Num MPDUs filtered by HW, all filter condition (TTL expired) */
	int32_t mpdus_hw_filter;

	/* Num MPDUs truncated by PDG (TXOP, TBTT,
	 * PPDU_duration based on rate, dyn_bw)
	 */
	int32_t mpdus_truncated;

	/* Num MPDUs that was tried but didn't receive ACK or BA */
	int32_t mpdus_ack_failed;

	/* Num MPDUs that was dropped du to expiry. */
	int32_t mpdus_expired;
} __packed;

struct wmi_pdev_stats_rx {
	/* Cnts any change in ring routing mid-ppdu */
	int32_t mid_ppdu_route_change;

	/* Total number of statuses processed */
	int32_t status_rcvd;

	/* Extra frags on rings 0-3 */
	int32_t r0_frags;
	int32_t r1_frags;
	int32_t r2_frags;
	int32_t r3_frags;

	/* MSDUs / MPDUs delivered to HTT */
	int32_t htt_msdus;
	int32_t htt_mpdus;

	/* MSDUs / MPDUs delivered to local stack */
	int32_t loc_msdus;
	int32_t loc_mpdus;

	/* AMSDUs that have more MSDUs than the status ring size */
	int32_t oversize_amsdu;

	/* Number of PHY errors */
	int32_t phy_errs;

	/* Number of PHY errors drops */
	int32_t phy_err_drop;

	/* Number of mpdu errors - FCS, MIC, ENC etc. */
	int32_t mpdu_errs;

	/* Num overflow errors */
	int32_t rx_ovfl_errs;
} __packed;

struct wmi_pdev_stats {
	struct wmi_pdev_stats_base base;
	struct wmi_pdev_stats_tx tx;
	struct wmi_pdev_stats_rx rx;
} __packed;

#define WLAN_MAX_AC 4
#define MAX_TX_RATE_VALUES 10
#define MAX_TX_RATE_VALUES 10

struct wmi_vdev_stats {
	uint32_t vdev_id;
	uint32_t beacon_snr;
	uint32_t data_snr;
	uint32_t num_tx_frames[WLAN_MAX_AC];
	uint32_t num_rx_frames;
	uint32_t num_tx_frames_retries[WLAN_MAX_AC];
	uint32_t num_tx_frames_failures[WLAN_MAX_AC];
	uint32_t num_rts_fail;
	uint32_t num_rts_success;
	uint32_t num_rx_err;
	uint32_t num_rx_discard;
	uint32_t num_tx_not_acked;
	uint32_t tx_rate_history[MAX_TX_RATE_VALUES];
	uint32_t beacon_rssi_history[MAX_TX_RATE_VALUES];
} __packed;

struct wmi_bcn_stats {
	uint32_t vdev_id;
	uint32_t tx_bcn_succ_cnt;
	uint32_t tx_bcn_outage_cnt;
} __packed;

struct wmi_stats_event {
	uint32_t stats_id;
	uint32_t num_pdev_stats;
	uint32_t num_vdev_stats;
	uint32_t num_peer_stats;
	uint32_t num_bcnflt_stats;
	uint32_t num_chan_stats;
	uint32_t num_mib_stats;
	uint32_t pdev_id;
	uint32_t num_bcn_stats;
	uint32_t num_peer_extd_stats;
	uint32_t num_peer_extd2_stats;
} __packed;

struct wmi_rssi_stats {
	uint32_t vdev_id;
	uint32_t rssi_avg_beacon[WMI_MAX_CHAINS];
	uint32_t rssi_avg_data[WMI_MAX_CHAINS];
	struct wmi_mac_addr peer_macaddr;
} __packed;

struct wmi_per_chain_rssi_stats {
	uint32_t num_per_chain_rssi_stats;
} __packed;

struct wmi_pdev_ctl_failsafe_chk_event {
	uint32_t pdev_id;
	uint32_t ctl_failsafe_status;
} __packed;

struct wmi_pdev_csa_switch_ev {
	uint32_t pdev_id;
	uint32_t current_switch_count;
	uint32_t num_vdevs;
} __packed;

struct wmi_pdev_radar_ev {
	uint32_t pdev_id;
	uint32_t detection_mode;
	uint32_t chan_freq;
	uint32_t chan_width;
	uint32_t detector_id;
	uint32_t segment_id;
	uint32_t timestamp;
	uint32_t is_chirp;
	int32_t freq_offset;
	int32_t sidx;
} __packed;

struct wmi_pdev_temperature_event {
	/* temperature value in Celsius degree */
	int32_t temp;
	uint32_t pdev_id;
} __packed;

#define WMI_RX_STATUS_OK			0x00
#define WMI_RX_STATUS_ERR_CRC			0x01
#define WMI_RX_STATUS_ERR_DECRYPT		0x08
#define WMI_RX_STATUS_ERR_MIC			0x10
#define WMI_RX_STATUS_ERR_KEY_CACHE_MISS	0x20

#define WLAN_MGMT_TXRX_HOST_MAX_ANTENNA 4

struct mgmt_rx_event_params {
	uint32_t chan_freq;
	uint32_t channel;
	uint32_t snr;
	uint8_t rssi_ctl[WLAN_MGMT_TXRX_HOST_MAX_ANTENNA];
	uint32_t rate;
	enum wmi_phy_mode phy_mode;
	uint32_t buf_len;
	int status;
	uint32_t flags;
	int rssi;
	uint32_t tsf_delta;
	uint8_t pdev_id;
};

#define ATH_MAX_ANTENNA 4

struct wmi_mgmt_rx_hdr {
	uint32_t channel;
	uint32_t snr;
	uint32_t rate;
	uint32_t phy_mode;
	uint32_t buf_len;
	uint32_t status;
	uint32_t rssi_ctl[ATH_MAX_ANTENNA];
	uint32_t flags;
	int rssi;
	uint32_t tsf_delta;
	uint32_t rx_tsf_l32;
	uint32_t rx_tsf_u32;
	uint32_t pdev_id;
	uint32_t chan_freq;
} __packed;

#define MAX_ANTENNA_EIGHT 8

struct wmi_rssi_ctl_ext {
	uint32_t tlv_header;
	uint32_t rssi_ctl_ext[MAX_ANTENNA_EIGHT - ATH_MAX_ANTENNA];
};

struct wmi_mgmt_tx_compl_event {
	uint32_t desc_id;
	uint32_t status;
	uint32_t pdev_id;
	uint32_t ppdu_id;
	uint32_t ack_rssi;
} __packed;

struct wmi_scan_event {
	uint32_t event_type; /* %WMI_SCAN_EVENT_ */
	uint32_t reason; /* %WMI_SCAN_REASON_ */
	uint32_t channel_freq; /* only valid for WMI_SCAN_EVENT_FOREIGN_CHANNEL */
	uint32_t scan_req_id;
	uint32_t scan_id;
	uint32_t vdev_id;
	/* TSF Timestamp when the scan event (%WMI_SCAN_EVENT_) is completed
	 * In case of AP it is TSF of the AP vdev
	 * In case of STA connected state, this is the TSF of the AP
	 * In case of STA not connected, it will be the free running HW timer
	 */
	uint32_t tsf_timestamp;
} __packed;

struct wmi_peer_sta_kickout_arg {
	const uint8_t *mac_addr;
};

struct wmi_peer_sta_kickout_event {
	struct wmi_mac_addr peer_macaddr;
} __packed;

enum wmi_roam_reason {
	WMI_ROAM_REASON_BETTER_AP = 1,
	WMI_ROAM_REASON_BEACON_MISS = 2,
	WMI_ROAM_REASON_LOW_RSSI = 3,
	WMI_ROAM_REASON_SUITABLE_AP_FOUND = 4,
	WMI_ROAM_REASON_HO_FAILED = 5,

	/* keep last */
	WMI_ROAM_REASON_MAX,
};

struct wmi_roam_event {
	uint32_t vdev_id;
	uint32_t reason;
	uint32_t rssi;
} __packed;

#define WMI_CHAN_INFO_START_RESP 0
#define WMI_CHAN_INFO_END_RESP 1

struct wmi_chan_info_event {
	uint32_t err_code;
	uint32_t freq;
	uint32_t cmd_flags;
	uint32_t noise_floor;
	uint32_t rx_clear_count;
	uint32_t cycle_count;
	uint32_t chan_tx_pwr_range;
	uint32_t chan_tx_pwr_tp;
	uint32_t rx_frame_count;
	uint32_t my_bss_rx_cycle_count;
	uint32_t rx_11b_mode_data_duration;
	uint32_t tx_frame_cnt;
	uint32_t mac_clk_mhz;
	uint32_t vdev_id;
} __packed;

struct ath11k_targ_cap {
	uint32_t phy_capability;
	uint32_t max_frag_entry;
	uint32_t num_rf_chains;
	uint32_t ht_cap_info;
	uint32_t vht_cap_info;
	uint32_t vht_supp_mcs;
	uint32_t hw_min_tx_power;
	uint32_t hw_max_tx_power;
	uint32_t sys_cap_info;
	uint32_t min_pkt_size_enable;
	uint32_t max_bcn_ie_size;
	uint32_t max_num_scan_channels;
	uint32_t max_supported_macs;
	uint32_t wmi_fw_sub_feat_caps;
	uint32_t txrx_chainmask;
	uint32_t default_dbs_hw_mode_index;
	uint32_t num_msdu_desc;
};

enum wmi_vdev_type {
	WMI_VDEV_TYPE_AP      = 1,
	WMI_VDEV_TYPE_STA     = 2,
	WMI_VDEV_TYPE_IBSS    = 3,
	WMI_VDEV_TYPE_MONITOR = 4,
};

enum wmi_vdev_subtype {
	WMI_VDEV_SUBTYPE_NONE,
	WMI_VDEV_SUBTYPE_P2P_DEVICE,
	WMI_VDEV_SUBTYPE_P2P_CLIENT,
	WMI_VDEV_SUBTYPE_P2P_GO,
	WMI_VDEV_SUBTYPE_PROXY_STA,
	WMI_VDEV_SUBTYPE_MESH_NON_11S,
	WMI_VDEV_SUBTYPE_MESH_11S,
};

enum wmi_sta_powersave_param {
	WMI_STA_PS_PARAM_RX_WAKE_POLICY = 0,
	WMI_STA_PS_PARAM_TX_WAKE_THRESHOLD = 1,
	WMI_STA_PS_PARAM_PSPOLL_COUNT = 2,
	WMI_STA_PS_PARAM_INACTIVITY_TIME = 3,
	WMI_STA_PS_PARAM_UAPSD = 4,
};

#define WMI_UAPSD_AC_TYPE_DELI 0
#define WMI_UAPSD_AC_TYPE_TRIG 1

#define WMI_UAPSD_AC_BIT_MASK(ac, type) \
	((type ==  WMI_UAPSD_AC_TYPE_DELI) ? \
	 (1 << (ac << 1)) : (1 << ((ac << 1) + 1)))

enum wmi_sta_ps_param_uapsd {
	WMI_STA_PS_UAPSD_AC0_DELIVERY_EN = (1 << 0),
	WMI_STA_PS_UAPSD_AC0_TRIGGER_EN  = (1 << 1),
	WMI_STA_PS_UAPSD_AC1_DELIVERY_EN = (1 << 2),
	WMI_STA_PS_UAPSD_AC1_TRIGGER_EN  = (1 << 3),
	WMI_STA_PS_UAPSD_AC2_DELIVERY_EN = (1 << 4),
	WMI_STA_PS_UAPSD_AC2_TRIGGER_EN  = (1 << 5),
	WMI_STA_PS_UAPSD_AC3_DELIVERY_EN = (1 << 6),
	WMI_STA_PS_UAPSD_AC3_TRIGGER_EN  = (1 << 7),
};

#define WMI_STA_UAPSD_MAX_INTERVAL_MSEC UINT_MAX

struct wmi_sta_uapsd_auto_trig_param {
	uint32_t wmm_ac;
	uint32_t user_priority;
	uint32_t service_interval;
	uint32_t suspend_interval;
	uint32_t delay_interval;
};

struct wmi_sta_uapsd_auto_trig_cmd_fixed_param {
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t num_ac;
};

struct wmi_sta_uapsd_auto_trig_arg {
	uint32_t wmm_ac;
	uint32_t user_priority;
	uint32_t service_interval;
	uint32_t suspend_interval;
	uint32_t delay_interval;
};

enum wmi_sta_ps_param_tx_wake_threshold {
	WMI_STA_PS_TX_WAKE_THRESHOLD_NEVER = 0,
	WMI_STA_PS_TX_WAKE_THRESHOLD_ALWAYS = 1,

	/* Values greater than one indicate that many TX attempts per beacon
	 * interval before the STA will wake up
	 */
};

/* The maximum number of PS-Poll frames the FW will send in response to
 * traffic advertised in TIM before waking up (by sending a null frame with PS
 * = 0). Value 0 has a special meaning: there is no maximum count and the FW
 * will send as many PS-Poll as are necessary to retrieve buffered BU. This
 * parameter is used when the RX wake policy is
 * WMI_STA_PS_RX_WAKE_POLICY_POLL_UAPSD and ignored when the RX wake
 * policy is WMI_STA_PS_RX_WAKE_POLICY_WAKE.
 */
enum wmi_sta_ps_param_pspoll_count {
	WMI_STA_PS_PSPOLL_COUNT_NO_MAX = 0,
	/* Values greater than 0 indicate the maximum number of PS-Poll frames
	 * FW will send before waking up.
	 */
};

/* U-APSD configuration of peer station from (re)assoc request and TSPECs */
enum wmi_ap_ps_param_uapsd {
	WMI_AP_PS_UAPSD_AC0_DELIVERY_EN = (1 << 0),
	WMI_AP_PS_UAPSD_AC0_TRIGGER_EN  = (1 << 1),
	WMI_AP_PS_UAPSD_AC1_DELIVERY_EN = (1 << 2),
	WMI_AP_PS_UAPSD_AC1_TRIGGER_EN  = (1 << 3),
	WMI_AP_PS_UAPSD_AC2_DELIVERY_EN = (1 << 4),
	WMI_AP_PS_UAPSD_AC2_TRIGGER_EN  = (1 << 5),
	WMI_AP_PS_UAPSD_AC3_DELIVERY_EN = (1 << 6),
	WMI_AP_PS_UAPSD_AC3_TRIGGER_EN  = (1 << 7),
};

/* U-APSD maximum service period of peer station */
enum wmi_ap_ps_peer_param_max_sp {
	WMI_AP_PS_PEER_PARAM_MAX_SP_UNLIMITED = 0,
	WMI_AP_PS_PEER_PARAM_MAX_SP_2 = 1,
	WMI_AP_PS_PEER_PARAM_MAX_SP_4 = 2,
	WMI_AP_PS_PEER_PARAM_MAX_SP_6 = 3,
	MAX_WMI_AP_PS_PEER_PARAM_MAX_SP,
};

enum wmi_ap_ps_peer_param {
	/** Set uapsd configuration for a given peer.
	 *
	 * This include the delivery and trigger enabled state for each AC.
	 * The host MLME needs to set this based on AP capability and stations
	 * request Set in the association request  received from the station.
	 *
	 * Lower 8 bits of the value specify the UAPSD configuration.
	 *
	 * (see enum wmi_ap_ps_param_uapsd)
	 * The default value is 0.
	 */
	WMI_AP_PS_PEER_PARAM_UAPSD = 0,

	/**
	 * Set the service period for a UAPSD capable station
	 *
	 * The service period from wme ie in the (re)assoc request frame.
	 *
	 * (see enum wmi_ap_ps_peer_param_max_sp)
	 */
	WMI_AP_PS_PEER_PARAM_MAX_SP = 1,

	/** Time in seconds for aging out buffered frames
	 * for STA in power save
	 */
	WMI_AP_PS_PEER_PARAM_AGEOUT_TIME = 2,

	/** Specify frame types that are considered SIFS
	 * RESP trigger frame
	 */
	WMI_AP_PS_PEER_PARAM_SIFS_RESP_FRMTYPE = 3,

	/** Specifies the trigger state of TID.
	 * Valid only for UAPSD frame type
	 */
	WMI_AP_PS_PEER_PARAM_SIFS_RESP_UAPSD = 4,

	/* Specifies the WNM sleep state of a STA */
	WMI_AP_PS_PEER_PARAM_WNM_SLEEP = 5,
};

#define DISABLE_SIFS_RESPONSE_TRIGGER 0

#define WMI_MAX_KEY_INDEX   3
#define WMI_MAX_KEY_LEN     32

#define WMI_KEY_PAIRWISE 0x00
#define WMI_KEY_GROUP    0x01

#define WMI_CIPHER_NONE     0x0 /* clear key */
#define WMI_CIPHER_WEP      0x1
#define WMI_CIPHER_TKIP     0x2
#define WMI_CIPHER_AES_OCB  0x3
#define WMI_CIPHER_AES_CCM  0x4
#define WMI_CIPHER_WAPI     0x5
#define WMI_CIPHER_CKIP     0x6
#define WMI_CIPHER_AES_CMAC 0x7
#define WMI_CIPHER_ANY      0x8
#define WMI_CIPHER_AES_GCM  0x9
#define WMI_CIPHER_AES_GMAC 0xa

/* Value to disable fixed rate setting */
#define WMI_FIXED_RATE_NONE	(0xffff)

#define ATH11K_RC_VERSION_OFFSET	28
#define ATH11K_RC_PREAMBLE_OFFSET	8
#define ATH11K_RC_NSS_OFFSET		5

#define ATH11K_HW_RATE_CODE(rate, nss, preamble)	\
	((1 << ATH11K_RC_VERSION_OFFSET) |		\
	 ((nss) << ATH11K_RC_NSS_OFFSET) |		\
	 ((preamble) << ATH11K_RC_PREAMBLE_OFFSET) |	\
	 (rate))

/* Preamble types to be used with VDEV fixed rate configuration */
enum wmi_rate_preamble {
	WMI_RATE_PREAMBLE_OFDM,
	WMI_RATE_PREAMBLE_CCK,
	WMI_RATE_PREAMBLE_HT,
	WMI_RATE_PREAMBLE_VHT,
	WMI_RATE_PREAMBLE_HE,
};

/**
 * enum wmi_rtscts_prot_mode - Enable/Disable RTS/CTS and CTS2Self Protection.
 * @WMI_RTS_CTS_DISABLED: RTS/CTS protection is disabled.
 * @WMI_USE_RTS_CTS: RTS/CTS Enabled.
 * @WMI_USE_CTS2SELF: CTS to self protection Enabled.
 */
enum wmi_rtscts_prot_mode {
	WMI_RTS_CTS_DISABLED = 0,
	WMI_USE_RTS_CTS = 1,
	WMI_USE_CTS2SELF = 2,
};

/**
 * enum wmi_rtscts_profile - Selection of RTS CTS profile along with enabling
 *                           protection mode.
 * @WMI_RTSCTS_FOR_NO_RATESERIES: Neither of rate-series should use RTS-CTS
 * @WMI_RTSCTS_FOR_SECOND_RATESERIES: Only second rate-series will use RTS-CTS
 * @WMI_RTSCTS_ACROSS_SW_RETRIES: Only the second rate-series will use RTS-CTS,
 *                                but if there's a sw retry, both the rate
 *                                series will use RTS-CTS.
 * @WMI_RTSCTS_ERP: RTS/CTS used for ERP protection for every PPDU.
 * @WMI_RTSCTS_FOR_ALL_RATESERIES: Enable RTS-CTS for all rate series.
 */
enum wmi_rtscts_profile {
	WMI_RTSCTS_FOR_NO_RATESERIES = 0,
	WMI_RTSCTS_FOR_SECOND_RATESERIES = 1,
	WMI_RTSCTS_ACROSS_SW_RETRIES = 2,
	WMI_RTSCTS_ERP = 3,
	WMI_RTSCTS_FOR_ALL_RATESERIES = 4,
};

struct ath11k_hal_reg_cap {
	uint32_t eeprom_rd;
	uint32_t eeprom_rd_ext;
	uint32_t regcap1;
	uint32_t regcap2;
	uint32_t wireless_modes;
	uint32_t low_2ghz_chan;
	uint32_t high_2ghz_chan;
	uint32_t low_5ghz_chan;
	uint32_t high_5ghz_chan;
};

struct ath11k_mem_chunk {
	void *vaddr;
	bus_addr_t paddr;
	uint32_t len;
	uint32_t req_id;
};

enum wmi_sta_ps_param_rx_wake_policy {
	WMI_STA_PS_RX_WAKE_POLICY_WAKE = 0,
	WMI_STA_PS_RX_WAKE_POLICY_POLL_UAPSD = 1,
};

/* Do not change existing values! Used by ath11k_frame_mode parameter
 * module parameter.
 */
enum ath11k_hw_txrx_mode {
	ATH11K_HW_TXRX_RAW = 0,
	ATH11K_HW_TXRX_NATIVE_WIFI = 1,
	ATH11K_HW_TXRX_ETHERNET = 2,
};

struct wmi_wmm_params {
	uint32_t tlv_header;
	uint32_t cwmin;
	uint32_t cwmax;
	uint32_t aifs;
	uint32_t txoplimit;
	uint32_t acm;
	uint32_t no_ack;
} __packed;

struct wmi_wmm_params_arg {
	uint8_t acm;
	uint8_t aifs;
	uint16_t cwmin;
	uint16_t cwmax;
	uint16_t txop;
	uint8_t no_ack;
};

struct wmi_vdev_set_wmm_params_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_wmm_params wmm_params[4];
	uint32_t wmm_param_type;
} __packed;

struct wmi_wmm_params_all_arg {
	struct wmi_wmm_params_arg ac_be;
	struct wmi_wmm_params_arg ac_bk;
	struct wmi_wmm_params_arg ac_vi;
	struct wmi_wmm_params_arg ac_vo;
};

#define ATH11K_TWT_DEF_STA_CONG_TIMER_MS		5000
#define ATH11K_TWT_DEF_DEFAULT_SLOT_SIZE		10
#define ATH11K_TWT_DEF_CONGESTION_THRESH_SETUP		50
#define ATH11K_TWT_DEF_CONGESTION_THRESH_TEARDOWN	20
#define ATH11K_TWT_DEF_CONGESTION_THRESH_CRITICAL	100
#define ATH11K_TWT_DEF_INTERFERENCE_THRESH_TEARDOWN	80
#define ATH11K_TWT_DEF_INTERFERENCE_THRESH_SETUP	50
#define ATH11K_TWT_DEF_MIN_NO_STA_SETUP			10
#define ATH11K_TWT_DEF_MIN_NO_STA_TEARDOWN		2
#define ATH11K_TWT_DEF_NO_OF_BCAST_MCAST_SLOTS		2
#define ATH11K_TWT_DEF_MIN_NO_TWT_SLOTS			2
#define ATH11K_TWT_DEF_MAX_NO_STA_TWT			500
#define ATH11K_TWT_DEF_MODE_CHECK_INTERVAL		10000
#define ATH11K_TWT_DEF_ADD_STA_SLOT_INTERVAL		1000
#define ATH11K_TWT_DEF_REMOVE_STA_SLOT_INTERVAL		5000

struct wmi_twt_enable_params {
	uint32_t sta_cong_timer_ms;
	uint32_t mbss_support;
	uint32_t default_slot_size;
	uint32_t congestion_thresh_setup;
	uint32_t congestion_thresh_teardown;
	uint32_t congestion_thresh_critical;
	uint32_t interference_thresh_teardown;
	uint32_t interference_thresh_setup;
	uint32_t min_no_sta_setup;
	uint32_t min_no_sta_teardown;
	uint32_t no_of_bcast_mcast_slots;
	uint32_t min_no_twt_slots;
	uint32_t max_no_sta_twt;
	uint32_t mode_check_interval;
	uint32_t add_sta_slot_interval;
	uint32_t remove_sta_slot_interval;
};

struct wmi_twt_enable_params_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t sta_cong_timer_ms;
	uint32_t mbss_support;
	uint32_t default_slot_size;
	uint32_t congestion_thresh_setup;
	uint32_t congestion_thresh_teardown;
	uint32_t congestion_thresh_critical;
	uint32_t interference_thresh_teardown;
	uint32_t interference_thresh_setup;
	uint32_t min_no_sta_setup;
	uint32_t min_no_sta_teardown;
	uint32_t no_of_bcast_mcast_slots;
	uint32_t min_no_twt_slots;
	uint32_t max_no_sta_twt;
	uint32_t mode_check_interval;
	uint32_t add_sta_slot_interval;
	uint32_t remove_sta_slot_interval;
} __packed;

struct wmi_twt_disable_params_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
} __packed;

enum WMI_HOST_TWT_COMMAND {
	WMI_HOST_TWT_COMMAND_REQUEST_TWT = 0,
	WMI_HOST_TWT_COMMAND_SUGGEST_TWT,
	WMI_HOST_TWT_COMMAND_DEMAND_TWT,
	WMI_HOST_TWT_COMMAND_TWT_GROUPING,
	WMI_HOST_TWT_COMMAND_ACCEPT_TWT,
	WMI_HOST_TWT_COMMAND_ALTERNATE_TWT,
	WMI_HOST_TWT_COMMAND_DICTATE_TWT,
	WMI_HOST_TWT_COMMAND_REJECT_TWT,
};

#define WMI_TWT_ADD_DIALOG_FLAG_BCAST           BIT(8)
#define WMI_TWT_ADD_DIALOG_FLAG_TRIGGER         BIT(9)
#define WMI_TWT_ADD_DIALOG_FLAG_FLOW_TYPE       BIT(10)
#define WMI_TWT_ADD_DIALOG_FLAG_PROTECTION      BIT(11)

struct wmi_twt_add_dialog_params_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t dialog_id;
	uint32_t wake_intvl_us;
	uint32_t wake_intvl_mantis;
	uint32_t wake_dura_us;
	uint32_t sp_offset_us;
	uint32_t flags;
} __packed;

struct wmi_twt_add_dialog_params {
	uint32_t vdev_id;
	uint8_t peer_macaddr[IEEE80211_ADDR_LEN];
	uint32_t dialog_id;
	uint32_t wake_intvl_us;
	uint32_t wake_intvl_mantis;
	uint32_t wake_dura_us;
	uint32_t sp_offset_us;
	uint8_t twt_cmd;
	uint8_t flag_bcast;
	uint8_t flag_trigger;
	uint8_t flag_flow_type;
	uint8_t flag_protection;
} __packed;

enum  wmi_twt_add_dialog_status {
	WMI_ADD_TWT_STATUS_OK,
	WMI_ADD_TWT_STATUS_TWT_NOT_ENABLED,
	WMI_ADD_TWT_STATUS_USED_DIALOG_ID,
	WMI_ADD_TWT_STATUS_INVALID_PARAM,
	WMI_ADD_TWT_STATUS_NOT_READY,
	WMI_ADD_TWT_STATUS_NO_RESOURCE,
	WMI_ADD_TWT_STATUS_NO_ACK,
	WMI_ADD_TWT_STATUS_NO_RESPONSE,
	WMI_ADD_TWT_STATUS_DENIED,
	WMI_ADD_TWT_STATUS_UNKNOWN_ERROR,
};

struct wmi_twt_add_dialog_event {
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t dialog_id;
	uint32_t status;
} __packed;

struct wmi_twt_del_dialog_params {
	uint32_t vdev_id;
	uint8_t peer_macaddr[IEEE80211_ADDR_LEN];
	uint32_t dialog_id;
} __packed;

struct wmi_twt_del_dialog_params_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t dialog_id;
} __packed;

struct wmi_twt_pause_dialog_params {
	uint32_t vdev_id;
	uint8_t peer_macaddr[IEEE80211_ADDR_LEN];
	uint32_t dialog_id;
} __packed;

struct wmi_twt_pause_dialog_params_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t dialog_id;
} __packed;

struct wmi_twt_resume_dialog_params {
	uint32_t vdev_id;
	uint8_t peer_macaddr[IEEE80211_ADDR_LEN];
	uint32_t dialog_id;
	uint32_t sp_offset_us;
	uint32_t next_twt_size;
} __packed;

struct wmi_twt_resume_dialog_params_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	struct wmi_mac_addr peer_macaddr;
	uint32_t dialog_id;
	uint32_t sp_offset_us;
	uint32_t next_twt_size;
} __packed;

struct wmi_obss_spatial_reuse_params_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t enable;
	int32_t obss_min;
	int32_t obss_max;
	uint32_t vdev_id;
} __packed;

struct wmi_pdev_obss_pd_bitmap_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t bitmap[2];
} __packed;

#define ATH11K_BSS_COLOR_COLLISION_SCAN_PERIOD_MS		200
#define ATH11K_OBSS_COLOR_COLLISION_DETECTION_DISABLE		0
#define ATH11K_OBSS_COLOR_COLLISION_DETECTION			1

#define ATH11K_BSS_COLOR_COLLISION_DETECTION_STA_PERIOD_MS	10000
#define ATH11K_BSS_COLOR_COLLISION_DETECTION_AP_PERIOD_MS	5000

enum wmi_bss_color_collision {
	WMI_BSS_COLOR_COLLISION_DISABLE = 0,
	WMI_BSS_COLOR_COLLISION_DETECTION,
	WMI_BSS_COLOR_FREE_SLOT_TIMER_EXPIRY,
	WMI_BSS_COLOR_FREE_SLOT_AVAILABLE,
};

struct wmi_obss_color_collision_cfg_params_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t flags;
	uint32_t evt_type;
	uint32_t current_bss_color;
	uint32_t detection_period_ms;
	uint32_t scan_period_ms;
	uint32_t free_slot_expiry_time_ms;
} __packed;

struct wmi_bss_color_change_enable_params_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t enable;
} __packed;

struct wmi_obss_color_collision_event {
	uint32_t vdev_id;
	uint32_t evt_type;
	uint64_t obss_color_bitmap;
} __packed;

#define ATH11K_IPV4_TH_SEED_SIZE 5
#define ATH11K_IPV6_TH_SEED_SIZE 11

struct ath11k_wmi_pdev_lro_config_cmd {
	uint32_t tlv_header;
	uint32_t lro_enable;
	uint32_t res;
	uint32_t th_4[ATH11K_IPV4_TH_SEED_SIZE];
	uint32_t th_6[ATH11K_IPV6_TH_SEED_SIZE];
	uint32_t pdev_id;
} __packed;

#define ATH11K_WMI_SPECTRAL_COUNT_DEFAULT                 0
#define ATH11K_WMI_SPECTRAL_PERIOD_DEFAULT              224
#define ATH11K_WMI_SPECTRAL_PRIORITY_DEFAULT              1
#define ATH11K_WMI_SPECTRAL_FFT_SIZE_DEFAULT              7
#define ATH11K_WMI_SPECTRAL_GC_ENA_DEFAULT                1
#define ATH11K_WMI_SPECTRAL_RESTART_ENA_DEFAULT           0
#define ATH11K_WMI_SPECTRAL_NOISE_FLOOR_REF_DEFAULT     -96
#define ATH11K_WMI_SPECTRAL_INIT_DELAY_DEFAULT           80
#define ATH11K_WMI_SPECTRAL_NB_TONE_THR_DEFAULT          12
#define ATH11K_WMI_SPECTRAL_STR_BIN_THR_DEFAULT           8
#define ATH11K_WMI_SPECTRAL_WB_RPT_MODE_DEFAULT           0
#define ATH11K_WMI_SPECTRAL_RSSI_RPT_MODE_DEFAULT         0
#define ATH11K_WMI_SPECTRAL_RSSI_THR_DEFAULT           0xf0
#define ATH11K_WMI_SPECTRAL_PWR_FORMAT_DEFAULT            0
#define ATH11K_WMI_SPECTRAL_RPT_MODE_DEFAULT              2
#define ATH11K_WMI_SPECTRAL_BIN_SCALE_DEFAULT             1
#define ATH11K_WMI_SPECTRAL_DBM_ADJ_DEFAULT               1
#define ATH11K_WMI_SPECTRAL_CHN_MASK_DEFAULT              1

struct ath11k_wmi_vdev_spectral_conf_param {
	uint32_t vdev_id;
	uint32_t scan_count;
	uint32_t scan_period;
	uint32_t scan_priority;
	uint32_t scan_fft_size;
	uint32_t scan_gc_ena;
	uint32_t scan_restart_ena;
	uint32_t scan_noise_floor_ref;
	uint32_t scan_init_delay;
	uint32_t scan_nb_tone_thr;
	uint32_t scan_str_bin_thr;
	uint32_t scan_wb_rpt_mode;
	uint32_t scan_rssi_rpt_mode;
	uint32_t scan_rssi_thr;
	uint32_t scan_pwr_format;
	uint32_t scan_rpt_mode;
	uint32_t scan_bin_scale;
	uint32_t scan_dbm_adj;
	uint32_t scan_chn_mask;
} __packed;

struct ath11k_wmi_vdev_spectral_conf_cmd {
	uint32_t tlv_header;
	struct ath11k_wmi_vdev_spectral_conf_param param;
} __packed;

#define ATH11K_WMI_SPECTRAL_TRIGGER_CMD_TRIGGER  1
#define ATH11K_WMI_SPECTRAL_TRIGGER_CMD_CLEAR    2
#define ATH11K_WMI_SPECTRAL_ENABLE_CMD_ENABLE    1
#define ATH11K_WMI_SPECTRAL_ENABLE_CMD_DISABLE   2

struct ath11k_wmi_vdev_spectral_enable_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t trigger_cmd;
	uint32_t enable_cmd;
} __packed;

struct ath11k_wmi_pdev_dma_ring_cfg_req_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t module_id;		/* see enum wmi_direct_buffer_module */
	uint32_t base_paddr_lo;
	uint32_t base_paddr_hi;
	uint32_t head_idx_paddr_lo;
	uint32_t head_idx_paddr_hi;
	uint32_t tail_idx_paddr_lo;
	uint32_t tail_idx_paddr_hi;
	uint32_t num_elems;		/* Number of elems in the ring */
	uint32_t buf_size;		/* size of allocated buffer in bytes */

	/* Number of wmi_dma_buf_release_entry packed together */
	uint32_t num_resp_per_event;

	/* Target should timeout and send whatever resp
	 * it has if this time expires, units in milliseconds
	 */
	uint32_t event_timeout_ms;
} __packed;

struct ath11k_wmi_dma_buf_release_fixed_param {
	uint32_t pdev_id;
	uint32_t module_id;
	uint32_t num_buf_release_entry;
	uint32_t num_meta_data_entry;
} __packed;

struct wmi_dma_buf_release_entry {
	uint32_t tlv_header;
	uint32_t paddr_lo;

	/* Bits 11:0:   address of data
	 * Bits 31:12:  host context data
	 */
	uint32_t paddr_hi;
} __packed;

#define WMI_SPECTRAL_META_INFO1_FREQ1		GENMASK(15, 0)
#define WMI_SPECTRAL_META_INFO1_FREQ2		GENMASK(31, 16)

#define WMI_SPECTRAL_META_INFO2_CHN_WIDTH	GENMASK(7, 0)

struct wmi_dma_buf_release_meta_data {
	uint32_t tlv_header;
	int32_t noise_floor[WMI_MAX_CHAINS];
	uint32_t reset_delay;
	uint32_t freq1;
	uint32_t freq2;
	uint32_t ch_width;
} __packed;

enum wmi_fils_discovery_cmd_type {
	WMI_FILS_DISCOVERY_CMD,
	WMI_UNSOL_BCAST_PROBE_RESP,
};

struct wmi_fils_discovery_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t interval;
	uint32_t config; /* enum wmi_fils_discovery_cmd_type */
} __packed;

struct wmi_fils_discovery_tmpl_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t buf_len;
} __packed;

struct wmi_probe_tmpl_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t buf_len;
} __packed;

struct target_resource_config {
	uint32_t num_vdevs;
	uint32_t num_peers;
	uint32_t num_active_peers;
	uint32_t num_offload_peers;
	uint32_t num_offload_reorder_buffs;
	uint32_t num_peer_keys;
	uint32_t num_tids;
	uint32_t ast_skid_limit;
	uint32_t tx_chain_mask;
	uint32_t rx_chain_mask;
	uint32_t rx_timeout_pri[4];
	uint32_t rx_decap_mode;
	uint32_t scan_max_pending_req;
	uint32_t bmiss_offload_max_vdev;
	uint32_t roam_offload_max_vdev;
	uint32_t roam_offload_max_ap_profiles;
	uint32_t num_mcast_groups;
	uint32_t num_mcast_table_elems;
	uint32_t mcast2ucast_mode;
	uint32_t tx_dbg_log_size;
	uint32_t num_wds_entries;
	uint32_t dma_burst_size;
	uint32_t mac_aggr_delim;
	uint32_t rx_skip_defrag_timeout_dup_detection_check;
	uint32_t vow_config;
	uint32_t gtk_offload_max_vdev;
	uint32_t num_msdu_desc;
	uint32_t max_frag_entries;
	uint32_t max_peer_ext_stats;
	uint32_t smart_ant_cap;
	uint32_t bk_minfree;
	uint32_t be_minfree;
	uint32_t vi_minfree;
	uint32_t vo_minfree;
	uint32_t rx_batchmode;
	uint32_t tt_support;
	uint32_t flag1;
	uint32_t iphdr_pad_config;
	uint32_t qwrap_config:16,
	    alloc_frag_desc_for_data_pkt:16;
	uint32_t num_tdls_vdevs;
	uint32_t num_tdls_conn_table_entries;
	uint32_t beacon_tx_offload_max_vdev;
	uint32_t num_multicast_filter_entries;
	uint32_t num_wow_filters;
	uint32_t num_keep_alive_pattern;
	uint32_t keep_alive_pattern_size;
	uint32_t max_tdls_concurrent_sleep_sta;
	uint32_t max_tdls_concurrent_buffer_sta;
	uint32_t wmi_send_separate;
	uint32_t num_ocb_vdevs;
	uint32_t num_ocb_channels;
	uint32_t num_ocb_schedules;
	uint32_t num_ns_ext_tuples_cfg;
	uint32_t bpf_instruction_size;
	uint32_t max_bssid_rx_filters;
	uint32_t use_pdev_id;
	uint32_t peer_map_unmap_v2_support;
	uint32_t sched_params;
	uint32_t twt_ap_pdev_count;
	uint32_t twt_ap_sta_count;
	uint8_t is_reg_cc_ext_event_supported;
	uint32_t ema_max_vap_cnt;
	uint32_t ema_max_profile_period;
};

enum wmi_debug_log_param {
	WMI_DEBUG_LOG_PARAM_LOG_LEVEL = 0x1,
	WMI_DEBUG_LOG_PARAM_VDEV_ENABLE,
	WMI_DEBUG_LOG_PARAM_VDEV_DISABLE,
	WMI_DEBUG_LOG_PARAM_VDEV_ENABLE_BITMAP,
	WMI_DEBUG_LOG_PARAM_MOD_ENABLE_BITMAP,
	WMI_DEBUG_LOG_PARAM_WOW_MOD_ENABLE_BITMAP,
};

struct wmi_debug_log_config_cmd_fixed_param {
	uint32_t tlv_header;
	uint32_t dbg_log_param;
	uint32_t value;
} __packed;

#define WMI_MAX_MEM_REQS 32

#define MAX_RADIOS 3

#define WMI_SERVICE_READY_TIMEOUT_HZ (5 * HZ)
#define WMI_SEND_TIMEOUT_HZ (3 * HZ)

enum ath11k_wmi_peer_ps_state {
	WMI_PEER_PS_STATE_OFF,
	WMI_PEER_PS_STATE_ON,
	WMI_PEER_PS_STATE_DISABLED,
};

enum wmi_peer_ps_supported_bitmap {
	/* Used to indicate that power save state change is valid */
	WMI_PEER_PS_VALID = 0x1,
	WMI_PEER_PS_STATE_TIMESTAMP = 0x2,
};

struct wmi_peer_sta_ps_state_chg_event {
	struct wmi_mac_addr peer_macaddr;
	uint32_t peer_ps_state;
	uint32_t ps_supported_bitmap;
	uint32_t peer_ps_valid;
	uint32_t peer_ps_timestamp;
} __packed;

/* Definition of HW data filtering */
enum hw_data_filter_type {
	WMI_HW_DATA_FILTER_DROP_NON_ARP_BC = BIT(0),
	WMI_HW_DATA_FILTER_DROP_NON_ICMPV6_MC = BIT(1),
};

struct wmi_hw_data_filter_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t enable;
	uint32_t hw_filter_bitmap;
} __packed;

/* WOW structures */
enum wmi_wow_wakeup_event {
	WOW_BMISS_EVENT = 0,
	WOW_BETTER_AP_EVENT,
	WOW_DEAUTH_RECVD_EVENT,
	WOW_MAGIC_PKT_RECVD_EVENT,
	WOW_GTK_ERR_EVENT,
	WOW_FOURWAY_HSHAKE_EVENT,
	WOW_EAPOL_RECVD_EVENT,
	WOW_NLO_DETECTED_EVENT,
	WOW_DISASSOC_RECVD_EVENT,
	WOW_PATTERN_MATCH_EVENT,
	WOW_CSA_IE_EVENT,
	WOW_PROBE_REQ_WPS_IE_EVENT,
	WOW_AUTH_REQ_EVENT,
	WOW_ASSOC_REQ_EVENT,
	WOW_HTT_EVENT,
	WOW_RA_MATCH_EVENT,
	WOW_HOST_AUTO_SHUTDOWN_EVENT,
	WOW_IOAC_MAGIC_EVENT,
	WOW_IOAC_SHORT_EVENT,
	WOW_IOAC_EXTEND_EVENT,
	WOW_IOAC_TIMER_EVENT,
	WOW_DFS_PHYERR_RADAR_EVENT,
	WOW_BEACON_EVENT,
	WOW_CLIENT_KICKOUT_EVENT,
	WOW_EVENT_MAX,
};

enum wmi_wow_interface_cfg {
	WOW_IFACE_PAUSE_ENABLED,
	WOW_IFACE_PAUSE_DISABLED
};

#define C2S(x) case x: return #x

static inline const char *wow_wakeup_event(enum wmi_wow_wakeup_event ev)
{
	switch (ev) {
	C2S(WOW_BMISS_EVENT);
	C2S(WOW_BETTER_AP_EVENT);
	C2S(WOW_DEAUTH_RECVD_EVENT);
	C2S(WOW_MAGIC_PKT_RECVD_EVENT);
	C2S(WOW_GTK_ERR_EVENT);
	C2S(WOW_FOURWAY_HSHAKE_EVENT);
	C2S(WOW_EAPOL_RECVD_EVENT);
	C2S(WOW_NLO_DETECTED_EVENT);
	C2S(WOW_DISASSOC_RECVD_EVENT);
	C2S(WOW_PATTERN_MATCH_EVENT);
	C2S(WOW_CSA_IE_EVENT);
	C2S(WOW_PROBE_REQ_WPS_IE_EVENT);
	C2S(WOW_AUTH_REQ_EVENT);
	C2S(WOW_ASSOC_REQ_EVENT);
	C2S(WOW_HTT_EVENT);
	C2S(WOW_RA_MATCH_EVENT);
	C2S(WOW_HOST_AUTO_SHUTDOWN_EVENT);
	C2S(WOW_IOAC_MAGIC_EVENT);
	C2S(WOW_IOAC_SHORT_EVENT);
	C2S(WOW_IOAC_EXTEND_EVENT);
	C2S(WOW_IOAC_TIMER_EVENT);
	C2S(WOW_DFS_PHYERR_RADAR_EVENT);
	C2S(WOW_BEACON_EVENT);
	C2S(WOW_CLIENT_KICKOUT_EVENT);
	C2S(WOW_EVENT_MAX);
	default:
		return NULL;
	}
}

enum wmi_wow_wake_reason {
	WOW_REASON_UNSPECIFIED = -1,
	WOW_REASON_NLOD = 0,
	WOW_REASON_AP_ASSOC_LOST,
	WOW_REASON_LOW_RSSI,
	WOW_REASON_DEAUTH_RECVD,
	WOW_REASON_DISASSOC_RECVD,
	WOW_REASON_GTK_HS_ERR,
	WOW_REASON_EAP_REQ,
	WOW_REASON_FOURWAY_HS_RECV,
	WOW_REASON_TIMER_INTR_RECV,
	WOW_REASON_PATTERN_MATCH_FOUND,
	WOW_REASON_RECV_MAGIC_PATTERN,
	WOW_REASON_P2P_DISC,
	WOW_REASON_WLAN_HB,
	WOW_REASON_CSA_EVENT,
	WOW_REASON_PROBE_REQ_WPS_IE_RECV,
	WOW_REASON_AUTH_REQ_RECV,
	WOW_REASON_ASSOC_REQ_RECV,
	WOW_REASON_HTT_EVENT,
	WOW_REASON_RA_MATCH,
	WOW_REASON_HOST_AUTO_SHUTDOWN,
	WOW_REASON_IOAC_MAGIC_EVENT,
	WOW_REASON_IOAC_SHORT_EVENT,
	WOW_REASON_IOAC_EXTEND_EVENT,
	WOW_REASON_IOAC_TIMER_EVENT,
	WOW_REASON_ROAM_HO,
	WOW_REASON_DFS_PHYERR_RADADR_EVENT,
	WOW_REASON_BEACON_RECV,
	WOW_REASON_CLIENT_KICKOUT_EVENT,
	WOW_REASON_PAGE_FAULT = 0x3a,
	WOW_REASON_DEBUG_TEST = 0xFF,
};

static inline const char *wow_reason(enum wmi_wow_wake_reason reason)
{
	switch (reason) {
	C2S(WOW_REASON_UNSPECIFIED);
	C2S(WOW_REASON_NLOD);
	C2S(WOW_REASON_AP_ASSOC_LOST);
	C2S(WOW_REASON_LOW_RSSI);
	C2S(WOW_REASON_DEAUTH_RECVD);
	C2S(WOW_REASON_DISASSOC_RECVD);
	C2S(WOW_REASON_GTK_HS_ERR);
	C2S(WOW_REASON_EAP_REQ);
	C2S(WOW_REASON_FOURWAY_HS_RECV);
	C2S(WOW_REASON_TIMER_INTR_RECV);
	C2S(WOW_REASON_PATTERN_MATCH_FOUND);
	C2S(WOW_REASON_RECV_MAGIC_PATTERN);
	C2S(WOW_REASON_P2P_DISC);
	C2S(WOW_REASON_WLAN_HB);
	C2S(WOW_REASON_CSA_EVENT);
	C2S(WOW_REASON_PROBE_REQ_WPS_IE_RECV);
	C2S(WOW_REASON_AUTH_REQ_RECV);
	C2S(WOW_REASON_ASSOC_REQ_RECV);
	C2S(WOW_REASON_HTT_EVENT);
	C2S(WOW_REASON_RA_MATCH);
	C2S(WOW_REASON_HOST_AUTO_SHUTDOWN);
	C2S(WOW_REASON_IOAC_MAGIC_EVENT);
	C2S(WOW_REASON_IOAC_SHORT_EVENT);
	C2S(WOW_REASON_IOAC_EXTEND_EVENT);
	C2S(WOW_REASON_IOAC_TIMER_EVENT);
	C2S(WOW_REASON_ROAM_HO);
	C2S(WOW_REASON_DFS_PHYERR_RADADR_EVENT);
	C2S(WOW_REASON_BEACON_RECV);
	C2S(WOW_REASON_CLIENT_KICKOUT_EVENT);
	C2S(WOW_REASON_PAGE_FAULT);
	C2S(WOW_REASON_DEBUG_TEST);
	default:
		return NULL;
	}
}

#undef C2S

struct wmi_wow_ev_arg {
	uint32_t vdev_id;
	uint32_t flag;
	enum wmi_wow_wake_reason wake_reason;
	uint32_t data_len;
};

enum wmi_tlv_pattern_type {
	WOW_PATTERN_MIN = 0,
	WOW_BITMAP_PATTERN = WOW_PATTERN_MIN,
	WOW_IPV4_SYNC_PATTERN,
	WOW_IPV6_SYNC_PATTERN,
	WOW_WILD_CARD_PATTERN,
	WOW_TIMER_PATTERN,
	WOW_MAGIC_PATTERN,
	WOW_IPV6_RA_PATTERN,
	WOW_IOAC_PKT_PATTERN,
	WOW_IOAC_TMR_PATTERN,
	WOW_PATTERN_MAX
};

#define WOW_DEFAULT_BITMAP_PATTERN_SIZE		148
#define WOW_DEFAULT_BITMASK_SIZE		148

#define WOW_MIN_PATTERN_SIZE	1
#define WOW_MAX_PATTERN_SIZE	148
#define WOW_MAX_PKT_OFFSET	128
#define WOW_HDR_LEN	(sizeof(struct ieee80211_hdr_3addr) + \
	sizeof(struct rfc1042_hdr))
#define WOW_MAX_REDUCE	(WOW_HDR_LEN - sizeof(struct ethhdr) - \
	offsetof(struct ieee80211_hdr_3addr, addr1))

struct wmi_wow_add_del_event_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t is_add;
	uint32_t event_bitmap;
} __packed;

struct wmi_wow_enable_cmd {
	uint32_t tlv_header;
	uint32_t enable;
	uint32_t pause_iface_config;
	uint32_t flags;
}  __packed;

struct wmi_wow_host_wakeup_ind {
	uint32_t tlv_header;
	uint32_t reserved;
} __packed;

struct wmi_tlv_wow_event_info {
	uint32_t vdev_id;
	uint32_t flag;
	uint32_t wake_reason;
	uint32_t data_len;
} __packed;

struct wmi_wow_bitmap_pattern {
	uint32_t tlv_header;
	uint8_t patternbuf[WOW_DEFAULT_BITMAP_PATTERN_SIZE];
	uint8_t bitmaskbuf[WOW_DEFAULT_BITMASK_SIZE];
	uint32_t pattern_offset;
	uint32_t pattern_len;
	uint32_t bitmask_len;
	uint32_t pattern_id;
} __packed;

struct wmi_wow_add_pattern_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t pattern_id;
	uint32_t pattern_type;
} __packed;

struct wmi_wow_del_pattern_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t pattern_id;
	uint32_t pattern_type;
} __packed;

#define WMI_PNO_MAX_SCHED_SCAN_PLANS      2
#define WMI_PNO_MAX_SCHED_SCAN_PLAN_INT   7200
#define WMI_PNO_MAX_SCHED_SCAN_PLAN_ITRNS 100
#define WMI_PNO_MAX_NETW_CHANNELS         26
#define WMI_PNO_MAX_NETW_CHANNELS_EX      60
#define WMI_PNO_MAX_SUPP_NETWORKS         WLAN_SCAN_PARAMS_MAX_SSID
#define WMI_PNO_MAX_IE_LENGTH             WLAN_SCAN_PARAMS_MAX_IE_LEN

/* size based of dot11 declaration without extra IEs as we will not carry those for PNO */
#define WMI_PNO_MAX_PB_REQ_SIZE    450

#define WMI_PNO_24G_DEFAULT_CH     1
#define WMI_PNO_5G_DEFAULT_CH      36

#define WMI_ACTIVE_MAX_CHANNEL_TIME 40
#define WMI_PASSIVE_MAX_CHANNEL_TIME   110

/* SSID broadcast type */
enum wmi_ssid_bcast_type {
	BCAST_UNKNOWN      = 0,
	BCAST_NORMAL       = 1,
	BCAST_HIDDEN       = 2,
};

#define WMI_NLO_MAX_SSIDS    16
#define WMI_NLO_MAX_CHAN     48

#define WMI_NLO_CONFIG_STOP                             BIT(0)
#define WMI_NLO_CONFIG_START                            BIT(1)
#define WMI_NLO_CONFIG_RESET                            BIT(2)
#define WMI_NLO_CONFIG_SLOW_SCAN                        BIT(4)
#define WMI_NLO_CONFIG_FAST_SCAN                        BIT(5)
#define WMI_NLO_CONFIG_SSID_HIDE_EN                     BIT(6)

/* This bit is used to indicate if EPNO or supplicant PNO is enabled.
 * Only one of them can be enabled at a given time
 */
#define WMI_NLO_CONFIG_ENLO                             BIT(7)
#define WMI_NLO_CONFIG_SCAN_PASSIVE                     BIT(8)
#define WMI_NLO_CONFIG_ENLO_RESET                       BIT(9)
#define WMI_NLO_CONFIG_SPOOFED_MAC_IN_PROBE_REQ         BIT(10)
#define WMI_NLO_CONFIG_RANDOM_SEQ_NO_IN_PROBE_REQ       BIT(11)
#define WMI_NLO_CONFIG_ENABLE_IE_WHITELIST_IN_PROBE_REQ BIT(12)
#define WMI_NLO_CONFIG_ENABLE_CNLO_RSSI_CONFIG          BIT(13)

struct wmi_nlo_ssid_param {
	uint32_t valid;
	struct wmi_ssid ssid;
} __packed;

struct wmi_nlo_enc_param {
	uint32_t valid;
	uint32_t enc_type;
} __packed;

struct wmi_nlo_auth_param {
	uint32_t valid;
	uint32_t auth_type;
} __packed;

struct wmi_nlo_bcast_nw_param {
	uint32_t valid;
	uint32_t bcast_nw_type;
} __packed;

struct wmi_nlo_rssi_param {
	uint32_t valid;
	int32_t rssi;
} __packed;

struct nlo_configured_parameters {
	/* TLV tag and len;*/
	uint32_t tlv_header;
	struct wmi_nlo_ssid_param ssid;
	struct wmi_nlo_enc_param enc_type;
	struct wmi_nlo_auth_param auth_type;
	struct wmi_nlo_rssi_param rssi_cond;

	/* indicates if the SSID is hidden or not */
	struct wmi_nlo_bcast_nw_param bcast_nw_type;
} __packed;

struct wmi_network_type {
	struct wmi_ssid ssid;
	uint32_t authentication;
	uint32_t encryption;
	uint32_t bcast_nw_type;
	uint8_t channel_count;
	uint16_t channels[WMI_PNO_MAX_NETW_CHANNELS_EX];
	int32_t rssi_threshold;
};

struct wmi_pno_scan_req {
	uint8_t enable;
	uint8_t vdev_id;
	uint8_t uc_networks_count;
	struct wmi_network_type a_networks[WMI_PNO_MAX_SUPP_NETWORKS];
	uint32_t fast_scan_period;
	uint32_t slow_scan_period;
	uint8_t fast_scan_max_cycles;

	bool do_passive_scan;

	uint32_t delay_start_time;
	uint32_t active_min_time;
	uint32_t active_max_time;
	uint32_t passive_min_time;
	uint32_t passive_max_time;

	/* mac address randomization attributes */
	uint32_t enable_pno_scan_randomization;
	uint8_t mac_addr[IEEE80211_ADDR_LEN];
	uint8_t mac_addr_mask[IEEE80211_ADDR_LEN];
};

struct wmi_wow_nlo_config_cmd {
	uint32_t tlv_header;
	uint32_t flags;
	uint32_t vdev_id;
	uint32_t fast_scan_max_cycles;
	uint32_t active_dwell_time;
	uint32_t passive_dwell_time;
	uint32_t probe_bundle_size;

	/* ART = IRT */
	uint32_t rest_time;

	/* Max value that can be reached after SBM */
	uint32_t max_rest_time;

	/* SBM */
	uint32_t scan_backoff_multiplier;

	/* SCBM */
	uint32_t fast_scan_period;

	/* specific to windows */
	uint32_t slow_scan_period;

	uint32_t no_of_ssids;

	uint32_t num_of_channels;

	/* NLO scan start delay time in milliseconds */
	uint32_t delay_start_time;

	/* MAC Address to use in Probe Req as SA */
	struct wmi_mac_addr mac_addr;

	/* Mask on which MAC has to be randomized */
	struct wmi_mac_addr mac_mask;

	/* IE bitmap to use in Probe Req */
	uint32_t ie_bitmap[8];

	/* Number of vendor OUIs. In the TLV vendor_oui[] */
	uint32_t num_vendor_oui;

	/* Number of connected NLO band preferences */
	uint32_t num_cnlo_band_pref;

	/* The TLVs will follow.
	 * nlo_configured_parameters nlo_list[];
	 * uint32_t channel_list[num_of_channels];
	 */
} __packed;

#define WMI_MAX_NS_OFFLOADS           2
#define WMI_MAX_ARP_OFFLOADS          2

#define WMI_ARPOL_FLAGS_VALID              BIT(0)
#define WMI_ARPOL_FLAGS_MAC_VALID          BIT(1)
#define WMI_ARPOL_FLAGS_REMOTE_IP_VALID    BIT(2)

struct wmi_arp_offload_tuple {
	uint32_t tlv_header;
	uint32_t flags;
	uint8_t target_ipaddr[4];
	uint8_t remote_ipaddr[4];
	struct wmi_mac_addr target_mac;
} __packed;

#define WMI_NSOL_FLAGS_VALID               BIT(0)
#define WMI_NSOL_FLAGS_MAC_VALID           BIT(1)
#define WMI_NSOL_FLAGS_REMOTE_IP_VALID     BIT(2)
#define WMI_NSOL_FLAGS_IS_IPV6_ANYCAST     BIT(3)

#define WMI_NSOL_MAX_TARGET_IPS    2

struct wmi_ns_offload_tuple {
	uint32_t tlv_header;
	uint32_t flags;
	uint8_t target_ipaddr[WMI_NSOL_MAX_TARGET_IPS][16];
	uint8_t solicitation_ipaddr[16];
	uint8_t remote_ipaddr[16];
	struct wmi_mac_addr target_mac;
} __packed;

struct wmi_set_arp_ns_offload_cmd {
	uint32_t tlv_header;
	uint32_t flags;
	uint32_t vdev_id;
	uint32_t num_ns_ext_tuples;
	/* The TLVs follow:
	 * wmi_ns_offload_tuple  ns_tuples[WMI_MAX_NS_OFFLOADS];
	 * wmi_arp_offload_tuple arp_tuples[WMI_MAX_ARP_OFFLOADS];
	 * wmi_ns_offload_tuple  ns_ext_tuples[num_ns_ext_tuples];
	 */
} __packed;

#define GTK_OFFLOAD_OPCODE_MASK             0xFF000000
#define GTK_OFFLOAD_ENABLE_OPCODE           0x01000000
#define GTK_OFFLOAD_DISABLE_OPCODE          0x02000000
#define GTK_OFFLOAD_REQUEST_STATUS_OPCODE   0x04000000

#define GTK_OFFLOAD_KEK_BYTES       16
#define GTK_OFFLOAD_KCK_BYTES       16
#define GTK_REPLAY_COUNTER_BYTES    8
#define WMI_MAX_KEY_LEN             32
#define IGTK_PN_SIZE                6

struct wmi_replayc_cnt {
	union {
		uint8_t counter[GTK_REPLAY_COUNTER_BYTES];
		struct {
			uint32_t word0;
			uint32_t word1;
		} __packed;
	} __packed;
} __packed;

struct wmi_gtk_offload_status_event {
	uint32_t vdev_id;
	uint32_t flags;
	uint32_t refresh_cnt;
	struct wmi_replayc_cnt replay_ctr;
	uint8_t igtk_key_index;
	uint8_t igtk_key_length;
	uint8_t igtk_key_rsc[IGTK_PN_SIZE];
	uint8_t igtk_key[WMI_MAX_KEY_LEN];
	uint8_t gtk_key_index;
	uint8_t gtk_key_length;
	uint8_t gtk_key_rsc[GTK_REPLAY_COUNTER_BYTES];
	uint8_t gtk_key[WMI_MAX_KEY_LEN];
} __packed;

struct wmi_gtk_rekey_offload_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t flags;
	uint8_t kek[GTK_OFFLOAD_KEK_BYTES];
	uint8_t kck[GTK_OFFLOAD_KCK_BYTES];
	uint8_t replay_ctr[GTK_REPLAY_COUNTER_BYTES];
} __packed;

#define BIOS_SAR_TABLE_LEN	(22)
#define BIOS_SAR_RSVD1_LEN	(6)
#define BIOS_SAR_RSVD2_LEN	(18)

struct wmi_pdev_set_sar_table_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t sar_len;
	uint32_t rsvd_len;
} __packed;

struct wmi_pdev_set_geo_table_cmd {
	uint32_t tlv_header;
	uint32_t pdev_id;
	uint32_t rsvd_len;
} __packed;

struct wmi_sta_keepalive_cmd {
	uint32_t tlv_header;
	uint32_t vdev_id;
	uint32_t enabled;

	/* WMI_STA_KEEPALIVE_METHOD_ */
	uint32_t method;

	/* in seconds */
	uint32_t interval;

	/* following this structure is the TLV for struct
	 * wmi_sta_keepalive_arp_resp
	 */
} __packed;

struct wmi_sta_keepalive_arp_resp {
	uint32_t tlv_header;
	uint32_t src_ip4_addr;
	uint32_t dest_ip4_addr;
	struct wmi_mac_addr dest_mac_addr;
} __packed;

struct wmi_sta_keepalive_arg {
	uint32_t vdev_id;
	uint32_t enabled;
	uint32_t method;
	uint32_t interval;
	uint32_t src_ip4_addr;
	uint32_t dest_ip4_addr;
	const uint8_t dest_mac_addr[IEEE80211_ADDR_LEN];
};

enum wmi_sta_keepalive_method {
	WMI_STA_KEEPALIVE_METHOD_NULL_FRAME = 1,
	WMI_STA_KEEPALIVE_METHOD_UNSOLICITED_ARP_RESPONSE = 2,
	WMI_STA_KEEPALIVE_METHOD_ETHERNET_LOOPBACK = 3,
	WMI_STA_KEEPALIVE_METHOD_GRATUITOUS_ARP_REQUEST = 4,
	WMI_STA_KEEPALIVE_METHOD_MGMT_VENDOR_ACTION = 5,
};

#define WMI_STA_KEEPALIVE_INTERVAL_DEFAULT	30
#define WMI_STA_KEEPALIVE_INTERVAL_DISABLE	0


/*
 * qrtr.h
 */

#define QRTR_PROTO_VER_1	1
#define QRTR_PROTO_VER_2	3 /* (sic!) */

struct qrtr_hdr_v1 {
	uint32_t version;
	uint32_t type;
	uint32_t src_node_id;
	uint32_t src_port_id;
	uint32_t confirm_rx;
	uint32_t size;
	uint32_t dst_node_id;
	uint32_t dst_port_id;
} __packed;

struct qrtr_hdr_v2 {
	uint8_t version;
	uint8_t type;
	uint8_t flags;
	uint8_t optlen;
	uint32_t size;
	uint16_t src_node_id;
	uint16_t src_port_id;
	uint16_t dst_node_id;
	uint16_t dst_port_id;
};

struct qrtr_ctrl_pkt {
	uint32_t cmd;

	union {
		struct {
			uint32_t service;
			uint32_t instance;
			uint32_t node;
			uint32_t port;
		} server;
		struct {
			uint32_t node;
			uint32_t port;
		} client;
	};
} __packed;

#define QRTR_TYPE_DATA		1
#define QRTR_TYPE_HELLO		2
#define QRTR_TYPE_BYE		3
#define QRTR_TYPE_NEW_SERVER	4
#define QRTR_TYPE_DEL_SERVER	5
#define QRTR_TYPE_DEL_CLIENT	6
#define QRTR_TYPE_RESUME_TX	7
#define QRTR_TYPE_EXIT		8
#define QRTR_TYPE_PING		9
#define QRTR_TYPE_NEW_LOOKUP	10
#define QRTR_TYPE_DEL_LOOKUP	11

#define QRTR_FLAGS_CONFIRM_RX	(1 << 0)

#define QRTR_NODE_BCAST		0xffffffffU
#define QRTR_PORT_CTRL		0xfffffffeU

/*
 * qmi.h
 */

#define QMI_REQUEST	0
#define QMI_RESPONSE	2
#define QMI_INDICATION	4

struct qmi_header {
	uint8_t type;
	uint16_t txn_id;
	uint16_t msg_id;
	uint16_t msg_len;
} __packed;

#define QMI_COMMON_TLV_TYPE	0

enum qmi_elem_type {
	QMI_EOTI,
	QMI_OPT_FLAG,
	QMI_DATA_LEN,
	QMI_UNSIGNED_1_BYTE,
	QMI_UNSIGNED_2_BYTE,
	QMI_UNSIGNED_4_BYTE,
	QMI_UNSIGNED_8_BYTE,
	QMI_SIGNED_2_BYTE_ENUM,
	QMI_SIGNED_4_BYTE_ENUM,
	QMI_STRUCT,
	QMI_STRING,
	QMI_NUM_DATA_TYPES
};

enum qmi_array_type {
	NO_ARRAY,
	STATIC_ARRAY,
	VAR_LEN_ARRAY,
};

struct qmi_elem_info {
	enum qmi_elem_type data_type;
	uint32_t elem_len;
	uint32_t elem_size;
	enum qmi_array_type array_type;
	uint8_t tlv_type;
	uint32_t offset;
	const struct qmi_elem_info *ei_array;
};

#define QMI_RESULT_SUCCESS_V01			0
#define QMI_RESULT_FAILURE_V01			1

#define QMI_ERR_NONE_V01			0
#define QMI_ERR_MALFORMED_MSG_V01		1
#define QMI_ERR_NO_MEMORY_V01			2
#define QMI_ERR_INTERNAL_V01			3
#define QMI_ERR_CLIENT_IDS_EXHAUSTED_V01	5
#define QMI_ERR_INVALID_ID_V01			41
#define QMI_ERR_ENCODING_V01			58
#define QMI_ERR_DISABLED_V01                    69
#define QMI_ERR_INCOMPATIBLE_STATE_V01		90
#define QMI_ERR_NOT_SUPPORTED_V01		94

struct qmi_response_type_v01 {
	uint16_t result;
	uint16_t error;
};

#define QMI_WLANFW_IND_REGISTER_REQ_MSG_V01_MAX_LEN		54
#define QMI_WLANFW_IND_REGISTER_REQ_V01				0x0020
#define QMI_WLANFW_IND_REGISTER_RESP_MSG_V01_MAX_LEN		18
#define QMI_WLANFW_IND_REGISTER_RESP_V01			0x0020
#define QMI_WLANFW_CLIENT_ID					0x4b4e454c

struct qmi_wlanfw_ind_register_req_msg_v01 {
	uint8_t fw_ready_enable_valid;
	uint8_t fw_ready_enable;
	uint8_t initiate_cal_download_enable_valid;
	uint8_t initiate_cal_download_enable;
	uint8_t initiate_cal_update_enable_valid;
	uint8_t initiate_cal_update_enable;
	uint8_t msa_ready_enable_valid;
	uint8_t msa_ready_enable;
	uint8_t pin_connect_result_enable_valid;
	uint8_t pin_connect_result_enable;
	uint8_t client_id_valid;
	uint32_t client_id;
	uint8_t request_mem_enable_valid;
	uint8_t request_mem_enable;
	uint8_t fw_mem_ready_enable_valid;
	uint8_t fw_mem_ready_enable;
	uint8_t fw_init_done_enable_valid;
	uint8_t fw_init_done_enable;
	uint8_t rejuvenate_enable_valid;
	uint32_t rejuvenate_enable;
	uint8_t xo_cal_enable_valid;
	uint8_t xo_cal_enable;
	uint8_t cal_done_enable_valid;
	uint8_t cal_done_enable;
};

struct qmi_wlanfw_ind_register_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
	uint8_t fw_status_valid;
	uint64_t fw_status;
};

#define QMI_WLANFW_HOST_CAP_REQ_MSG_V01_MAX_LEN		261
#define QMI_WLANFW_HOST_CAP_REQ_V01			0x0034
#define QMI_WLANFW_HOST_CAP_RESP_MSG_V01_MAX_LEN	7
#define QMI_WLFW_HOST_CAP_RESP_V01			0x0034
#define QMI_WLFW_MAX_NUM_GPIO_V01			32
#define QMI_IPQ8074_FW_MEM_MODE				0xFF
#define HOST_DDR_REGION_TYPE				0x1
#define BDF_MEM_REGION_TYPE				0x2
#define M3_DUMP_REGION_TYPE				0x3
#define CALDB_MEM_REGION_TYPE				0x4

struct qmi_wlanfw_host_cap_req_msg_v01 {
	uint8_t num_clients_valid;
	uint32_t num_clients;
	uint8_t wake_msi_valid;
	uint32_t wake_msi;
	uint8_t gpios_valid;
	uint32_t gpios_len;
	uint32_t gpios[QMI_WLFW_MAX_NUM_GPIO_V01];
	uint8_t nm_modem_valid;
	uint8_t nm_modem;
	uint8_t bdf_support_valid;
	uint8_t bdf_support;
	uint8_t bdf_cache_support_valid;
	uint8_t bdf_cache_support;
	uint8_t m3_support_valid;
	uint8_t m3_support;
	uint8_t m3_cache_support_valid;
	uint8_t m3_cache_support;
	uint8_t cal_filesys_support_valid;
	uint8_t cal_filesys_support;
	uint8_t cal_cache_support_valid;
	uint8_t cal_cache_support;
	uint8_t cal_done_valid;
	uint8_t cal_done;
	uint8_t mem_bucket_valid;
	uint32_t mem_bucket;
	uint8_t mem_cfg_mode_valid;
	uint8_t mem_cfg_mode;
};

struct qmi_wlanfw_host_cap_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
};

#define ATH11K_HOST_VERSION_STRING		"WIN"
#define ATH11K_QMI_WLANFW_TIMEOUT_MS		10000
#define ATH11K_QMI_MAX_BDF_FILE_NAME_SIZE	64
#define ATH11K_QMI_CALDB_ADDRESS		0x4BA00000
#define ATH11K_QMI_WLANFW_MAX_BUILD_ID_LEN_V01	128
#define ATH11K_QMI_WLFW_SERVICE_ID_V01		0x45
#define ATH11K_QMI_WLFW_SERVICE_VERS_V01	0x01
#define ATH11K_QMI_WLFW_SERVICE_INS_ID_V01	0x02
#define ATH11K_QMI_WLFW_SERVICE_INS_ID_V01_QCA6390	0x01
#define ATH11K_QMI_WLFW_SERVICE_INS_ID_V01_IPQ8074	0x02
#define ATH11K_QMI_WLFW_SERVICE_INS_ID_V01_QCN9074	0x07
#define ATH11K_QMI_WLFW_SERVICE_INS_ID_V01_WCN6750	0x03
#define ATH11K_QMI_WLANFW_MAX_TIMESTAMP_LEN_V01	32

#define ATH11K_QMI_RESP_LEN_MAX			8192
#define ATH11K_QMI_WLANFW_MAX_NUM_MEM_SEG_V01	52
#define ATH11K_QMI_CALDB_SIZE			0x480000
#define ATH11K_QMI_BDF_EXT_STR_LENGTH		0x20
#define ATH11K_QMI_FW_MEM_REQ_SEGMENT_CNT	5

#define QMI_WLFW_REQUEST_MEM_IND_V01		0x0035
#define QMI_WLFW_RESPOND_MEM_RESP_V01		0x0036
#define QMI_WLFW_FW_MEM_READY_IND_V01		0x0037
#define QMI_WLFW_COLD_BOOT_CAL_DONE_IND_V01	0x003E
#define QMI_WLFW_FW_READY_IND_V01		0x0021
#define QMI_WLFW_FW_INIT_DONE_IND_V01		0x0038

#define QMI_WLANFW_MAX_DATA_SIZE_V01		6144
#define ATH11K_FIRMWARE_MODE_OFF		4
#define ATH11K_COLD_BOOT_FW_RESET_DELAY		(40 * HZ)

#define QMI_WLANFW_REQUEST_MEM_IND_MSG_V01_MAX_LEN	1824
#define QMI_WLANFW_RESPOND_MEM_REQ_MSG_V01_MAX_LEN	888
#define QMI_WLANFW_RESPOND_MEM_RESP_MSG_V01_MAX_LEN	7
#define QMI_WLANFW_REQUEST_MEM_IND_V01			0x0035
#define QMI_WLANFW_RESPOND_MEM_REQ_V01			0x0036
#define QMI_WLANFW_RESPOND_MEM_RESP_V01			0x0036
#define QMI_WLANFW_MAX_NUM_MEM_CFG_V01			2

struct qmi_wlanfw_mem_cfg_s_v01 {
	uint64_t offset;
	uint32_t size;
	uint8_t secure_flag;
};

enum qmi_wlanfw_mem_type_enum_v01 {
	WLANFW_MEM_TYPE_ENUM_MIN_VAL_V01 = INT_MIN,
	QMI_WLANFW_MEM_TYPE_MSA_V01 = 0,
	QMI_WLANFW_MEM_TYPE_DDR_V01 = 1,
	QMI_WLANFW_MEM_BDF_V01 = 2,
	QMI_WLANFW_MEM_M3_V01 = 3,
	QMI_WLANFW_MEM_CAL_V01 = 4,
	QMI_WLANFW_MEM_DPD_V01 = 5,
	WLANFW_MEM_TYPE_ENUM_MAX_VAL_V01 = INT_MAX,
};

struct qmi_wlanfw_mem_seg_s_v01 {
	uint32_t size;
	enum qmi_wlanfw_mem_type_enum_v01 type;
	uint32_t mem_cfg_len;
	struct qmi_wlanfw_mem_cfg_s_v01 mem_cfg[QMI_WLANFW_MAX_NUM_MEM_CFG_V01];
};

struct qmi_wlanfw_request_mem_ind_msg_v01 {
	uint32_t mem_seg_len;
	struct qmi_wlanfw_mem_seg_s_v01 mem_seg[ATH11K_QMI_WLANFW_MAX_NUM_MEM_SEG_V01];
};

struct qmi_wlanfw_mem_seg_resp_s_v01 {
	uint64_t addr;
	uint32_t size;
	enum qmi_wlanfw_mem_type_enum_v01 type;
	uint8_t restore;
};

struct qmi_wlanfw_respond_mem_req_msg_v01 {
	uint32_t mem_seg_len;
	struct qmi_wlanfw_mem_seg_resp_s_v01 mem_seg[ATH11K_QMI_WLANFW_MAX_NUM_MEM_SEG_V01];
};

struct qmi_wlanfw_respond_mem_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
};

struct qmi_wlanfw_fw_mem_ready_ind_msg_v01 {
	char placeholder;
};

struct qmi_wlanfw_fw_ready_ind_msg_v01 {
	char placeholder;
};

struct qmi_wlanfw_fw_cold_cal_done_ind_msg_v01 {
	char placeholder;
};

struct qmi_wlfw_fw_init_done_ind_msg_v01 {
	char placeholder;
};

#define QMI_WLANFW_CAP_REQ_MSG_V01_MAX_LEN		0
#define QMI_WLANFW_CAP_RESP_MSG_V01_MAX_LEN		235
#define QMI_WLANFW_CAP_REQ_V01				0x0024
#define QMI_WLANFW_CAP_RESP_V01				0x0024
#define QMI_WLANFW_DEVICE_INFO_REQ_V01			0x004C
#define QMI_WLANFW_DEVICE_INFO_REQ_MSG_V01_MAX_LEN	0

enum qmi_wlanfw_pipedir_enum_v01 {
	QMI_WLFW_PIPEDIR_NONE_V01 = 0,
	QMI_WLFW_PIPEDIR_IN_V01 = 1,
	QMI_WLFW_PIPEDIR_OUT_V01 = 2,
	QMI_WLFW_PIPEDIR_INOUT_V01 = 3,
};

struct qmi_wlanfw_ce_tgt_pipe_cfg_s_v01 {
	uint32_t pipe_num;
	uint32_t pipe_dir;
	uint32_t nentries;
	uint32_t nbytes_max;
	uint32_t flags;
};

struct qmi_wlanfw_ce_svc_pipe_cfg_s_v01 {
	uint32_t service_id;
	uint32_t pipe_dir;
	uint32_t pipe_num;
};

struct qmi_wlanfw_shadow_reg_cfg_s_v01 {
	uint16_t id;
	uint16_t offset;
};

struct qmi_wlanfw_shadow_reg_v2_cfg_s_v01 {
	uint32_t addr;
};

struct qmi_wlanfw_memory_region_info_s_v01 {
	uint64_t region_addr;
	uint32_t size;
	uint8_t secure_flag;
};

struct qmi_wlanfw_rf_chip_info_s_v01 {
	uint32_t chip_id;
	uint32_t chip_family;
};

struct qmi_wlanfw_rf_board_info_s_v01 {
	uint32_t board_id;
};

struct qmi_wlanfw_soc_info_s_v01 {
	uint32_t soc_id;
};

struct qmi_wlanfw_fw_version_info_s_v01 {
	uint32_t fw_version;
	char fw_build_timestamp[ATH11K_QMI_WLANFW_MAX_TIMESTAMP_LEN_V01 + 1];
};

enum qmi_wlanfw_cal_temp_id_enum_v01 {
	QMI_WLANFW_CAL_TEMP_IDX_0_V01 = 0,
	QMI_WLANFW_CAL_TEMP_IDX_1_V01 = 1,
	QMI_WLANFW_CAL_TEMP_IDX_2_V01 = 2,
	QMI_WLANFW_CAL_TEMP_IDX_3_V01 = 3,
	QMI_WLANFW_CAL_TEMP_IDX_4_V01 = 4,
	QMI_WLANFW_CAL_TEMP_ID_MAX_V01 = 0xFF,
};

struct qmi_wlanfw_cap_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
	uint8_t chip_info_valid;
	struct qmi_wlanfw_rf_chip_info_s_v01 chip_info;
	uint8_t board_info_valid;
	struct qmi_wlanfw_rf_board_info_s_v01 board_info;
	uint8_t soc_info_valid;
	struct qmi_wlanfw_soc_info_s_v01 soc_info;
	uint8_t fw_version_info_valid;
	struct qmi_wlanfw_fw_version_info_s_v01 fw_version_info;
	uint8_t fw_build_id_valid;
	char fw_build_id[ATH11K_QMI_WLANFW_MAX_BUILD_ID_LEN_V01 + 1];
	uint8_t num_macs_valid;
	uint8_t num_macs;
	uint8_t voltage_mv_valid;
	uint32_t voltage_mv;
	uint8_t time_freq_hz_valid;
	uint32_t time_freq_hz;
	uint8_t otp_version_valid;
	uint32_t otp_version;
	uint8_t eeprom_read_timeout_valid;
	uint32_t eeprom_read_timeout;
};

struct qmi_wlanfw_cap_req_msg_v01 {
	char placeholder;
};

#define QMI_WLANFW_BDF_DOWNLOAD_REQ_MSG_V01_MAX_LEN	6182
#define QMI_WLANFW_BDF_DOWNLOAD_RESP_MSG_V01_MAX_LEN	7
#define QMI_WLANFW_BDF_DOWNLOAD_RESP_V01		0x0025
#define QMI_WLANFW_BDF_DOWNLOAD_REQ_V01			0x0025
/* TODO: Need to check with MCL and FW team that data can be pointer and
 * can be last element in structure
 */
struct qmi_wlanfw_bdf_download_req_msg_v01 {
	uint8_t valid;
	uint8_t file_id_valid;
	enum qmi_wlanfw_cal_temp_id_enum_v01 file_id;
	uint8_t total_size_valid;
	uint32_t total_size;
	uint8_t seg_id_valid;
	uint32_t seg_id;
	uint8_t data_valid;
	uint32_t data_len;
	uint8_t data[QMI_WLANFW_MAX_DATA_SIZE_V01];
	uint8_t end_valid;
	uint8_t end;
	uint8_t bdf_type_valid;
	uint8_t bdf_type;
};

struct qmi_wlanfw_bdf_download_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
};

#define QMI_WLANFW_M3_INFO_REQ_MSG_V01_MAX_MSG_LEN	18
#define QMI_WLANFW_M3_INFO_RESP_MSG_V01_MAX_MSG_LEN	7
#define QMI_WLANFW_M3_INFO_RESP_V01		0x003c
#define QMI_WLANFW_M3_INFO_REQ_V01		0x003c

struct qmi_wlanfw_m3_info_req_msg_v01 {
	uint64_t addr;
	uint32_t size;
};

struct qmi_wlanfw_m3_info_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
};

#define QMI_WLANFW_WLAN_MODE_REQ_MSG_V01_MAX_LEN	11
#define QMI_WLANFW_WLAN_MODE_RESP_MSG_V01_MAX_LEN	7
#define QMI_WLANFW_WLAN_CFG_REQ_MSG_V01_MAX_LEN		803
#define QMI_WLANFW_WLAN_CFG_RESP_MSG_V01_MAX_LEN	7
#define QMI_WLANFW_WLAN_INI_REQ_MSG_V01_MAX_LEN		4
#define QMI_WLANFW_WLAN_MODE_REQ_V01			0x0022
#define QMI_WLANFW_WLAN_MODE_RESP_V01			0x0022
#define QMI_WLANFW_WLAN_CFG_REQ_V01			0x0023
#define QMI_WLANFW_WLAN_CFG_RESP_V01			0x0023
#define QMI_WLANFW_WLAN_INI_REQ_V01			0x002f
#define QMI_WLANFW_WLAN_INI_RESP_V01			0x002f
#define QMI_WLANFW_MAX_STR_LEN_V01			16
#define QMI_WLANFW_MAX_NUM_CE_V01			12
#define QMI_WLANFW_MAX_NUM_SVC_V01			24
#define QMI_WLANFW_MAX_NUM_SHADOW_REG_V01		24
#define QMI_WLANFW_MAX_NUM_SHADOW_REG_V2_V01		36

struct qmi_wlanfw_wlan_mode_req_msg_v01 {
	uint32_t mode;
	uint8_t hw_debug_valid;
	uint8_t hw_debug;
};

struct qmi_wlanfw_wlan_mode_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
};

struct qmi_wlanfw_wlan_cfg_req_msg_v01 {
	uint8_t host_version_valid;
	char host_version[QMI_WLANFW_MAX_STR_LEN_V01 + 1];
	uint8_t tgt_cfg_valid;
	uint32_t tgt_cfg_len;
	struct qmi_wlanfw_ce_tgt_pipe_cfg_s_v01
	    tgt_cfg[QMI_WLANFW_MAX_NUM_CE_V01];
	uint8_t svc_cfg_valid;
	uint32_t svc_cfg_len;
	struct qmi_wlanfw_ce_svc_pipe_cfg_s_v01
	    svc_cfg[QMI_WLANFW_MAX_NUM_SVC_V01];
	uint8_t shadow_reg_valid;
	uint32_t shadow_reg_len;
	struct qmi_wlanfw_shadow_reg_cfg_s_v01
	    shadow_reg[QMI_WLANFW_MAX_NUM_SHADOW_REG_V01];
	uint8_t shadow_reg_v2_valid;
	uint32_t shadow_reg_v2_len;
	struct qmi_wlanfw_shadow_reg_v2_cfg_s_v01
		shadow_reg_v2[QMI_WLANFW_MAX_NUM_SHADOW_REG_V2_V01];
};

struct qmi_wlanfw_wlan_cfg_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
};

struct qmi_wlanfw_wlan_ini_req_msg_v01 {
	/* Must be set to true if enablefwlog is being passed */
	uint8_t enablefwlog_valid;
	uint8_t enablefwlog;
};

struct qmi_wlanfw_wlan_ini_resp_msg_v01 {
	struct qmi_response_type_v01 resp;
};

enum ath11k_qmi_file_type {
	ATH11K_QMI_FILE_TYPE_BDF_GOLDEN,
	ATH11K_QMI_FILE_TYPE_CALDATA = 2,
	ATH11K_QMI_FILE_TYPE_EEPROM,
	ATH11K_QMI_MAX_FILE_TYPE,
};

enum ath11k_qmi_bdf_type {
	ATH11K_QMI_BDF_TYPE_BIN			= 0,
	ATH11K_QMI_BDF_TYPE_ELF			= 1,
	ATH11K_QMI_BDF_TYPE_REGDB		= 4,
};

#define HAL_LINK_DESC_SIZE			(32 << 2)
#define HAL_LINK_DESC_ALIGN			128
#define HAL_NUM_MPDUS_PER_LINK_DESC		6
#define HAL_NUM_TX_MSDUS_PER_LINK_DESC		7
#define HAL_NUM_RX_MSDUS_PER_LINK_DESC		6
#define HAL_NUM_MPDU_LINKS_PER_QUEUE_DESC	12
#define HAL_MAX_AVAIL_BLK_RES			3

#define HAL_RING_BASE_ALIGN	8

#define HAL_WBM_IDLE_SCATTER_BUF_SIZE_MAX	32704
/* TODO: Check with hw team on the supported scatter buf size */
#define HAL_WBM_IDLE_SCATTER_NEXT_PTR_SIZE	8
#define HAL_WBM_IDLE_SCATTER_BUF_SIZE (HAL_WBM_IDLE_SCATTER_BUF_SIZE_MAX - \
				       HAL_WBM_IDLE_SCATTER_NEXT_PTR_SIZE)

#define HAL_DSCP_TID_MAP_TBL_NUM_ENTRIES_MAX	48
#define HAL_DSCP_TID_TBL_SIZE			24

/* calculate the register address from bar0 of shadow register x */
#define HAL_SHADOW_BASE_ADDR(sc)		\
	(sc->hw_params.regs->hal_shadow_base_addr)
#define HAL_SHADOW_NUM_REGS			36
#define HAL_HP_OFFSET_IN_REG_START		1
#define HAL_OFFSET_FROM_HP_TO_TP		4

#define HAL_SHADOW_REG(sc, x) (HAL_SHADOW_BASE_ADDR(sc) + (4 * (x)))

enum hal_srng_ring_id {
	HAL_SRNG_RING_ID_REO2SW1 = 0,
	HAL_SRNG_RING_ID_REO2SW2,
	HAL_SRNG_RING_ID_REO2SW3,
	HAL_SRNG_RING_ID_REO2SW4,
	HAL_SRNG_RING_ID_REO2TCL,
	HAL_SRNG_RING_ID_SW2REO,

	HAL_SRNG_RING_ID_REO_CMD = 8,
	HAL_SRNG_RING_ID_REO_STATUS,

	HAL_SRNG_RING_ID_SW2TCL1 = 16,
	HAL_SRNG_RING_ID_SW2TCL2,
	HAL_SRNG_RING_ID_SW2TCL3,
	HAL_SRNG_RING_ID_SW2TCL4,

	HAL_SRNG_RING_ID_SW2TCL_CMD = 24,
	HAL_SRNG_RING_ID_TCL_STATUS,

	HAL_SRNG_RING_ID_CE0_SRC = 32,
	HAL_SRNG_RING_ID_CE1_SRC,
	HAL_SRNG_RING_ID_CE2_SRC,
	HAL_SRNG_RING_ID_CE3_SRC,
	HAL_SRNG_RING_ID_CE4_SRC,
	HAL_SRNG_RING_ID_CE5_SRC,
	HAL_SRNG_RING_ID_CE6_SRC,
	HAL_SRNG_RING_ID_CE7_SRC,
	HAL_SRNG_RING_ID_CE8_SRC,
	HAL_SRNG_RING_ID_CE9_SRC,
	HAL_SRNG_RING_ID_CE10_SRC,
	HAL_SRNG_RING_ID_CE11_SRC,

	HAL_SRNG_RING_ID_CE0_DST = 56,
	HAL_SRNG_RING_ID_CE1_DST,
	HAL_SRNG_RING_ID_CE2_DST,
	HAL_SRNG_RING_ID_CE3_DST,
	HAL_SRNG_RING_ID_CE4_DST,
	HAL_SRNG_RING_ID_CE5_DST,
	HAL_SRNG_RING_ID_CE6_DST,
	HAL_SRNG_RING_ID_CE7_DST,
	HAL_SRNG_RING_ID_CE8_DST,
	HAL_SRNG_RING_ID_CE9_DST,
	HAL_SRNG_RING_ID_CE10_DST,
	HAL_SRNG_RING_ID_CE11_DST,

	HAL_SRNG_RING_ID_CE0_DST_STATUS = 80,
	HAL_SRNG_RING_ID_CE1_DST_STATUS,
	HAL_SRNG_RING_ID_CE2_DST_STATUS,
	HAL_SRNG_RING_ID_CE3_DST_STATUS,
	HAL_SRNG_RING_ID_CE4_DST_STATUS,
	HAL_SRNG_RING_ID_CE5_DST_STATUS,
	HAL_SRNG_RING_ID_CE6_DST_STATUS,
	HAL_SRNG_RING_ID_CE7_DST_STATUS,
	HAL_SRNG_RING_ID_CE8_DST_STATUS,
	HAL_SRNG_RING_ID_CE9_DST_STATUS,
	HAL_SRNG_RING_ID_CE10_DST_STATUS,
	HAL_SRNG_RING_ID_CE11_DST_STATUS,

	HAL_SRNG_RING_ID_WBM_IDLE_LINK = 104,
	HAL_SRNG_RING_ID_WBM_SW_RELEASE,
	HAL_SRNG_RING_ID_WBM2SW0_RELEASE,
	HAL_SRNG_RING_ID_WBM2SW1_RELEASE,
	HAL_SRNG_RING_ID_WBM2SW2_RELEASE,
	HAL_SRNG_RING_ID_WBM2SW3_RELEASE,
	HAL_SRNG_RING_ID_WBM2SW4_RELEASE,

	HAL_SRNG_RING_ID_UMAC_ID_END = 127,
	HAL_SRNG_RING_ID_LMAC1_ID_START,

	HAL_SRNG_RING_ID_WMAC1_SW2RXDMA0_BUF = HAL_SRNG_RING_ID_LMAC1_ID_START,
	HAL_SRNG_RING_ID_WMAC1_SW2RXDMA1_BUF,
	HAL_SRNG_RING_ID_WMAC1_SW2RXDMA2_BUF,
	HAL_SRNG_RING_ID_WMAC1_SW2RXDMA0_STATBUF,
	HAL_SRNG_RING_ID_WMAC1_SW2RXDMA1_STATBUF,
	HAL_SRNG_RING_ID_WMAC1_RXDMA2SW0,
	HAL_SRNG_RING_ID_WMAC1_RXDMA2SW1,
	HAL_SRNG_RING_ID_WMAC1_SW2RXDMA1_DESC,
	HAL_SRNG_RING_ID_RXDMA_DIR_BUF,

	HAL_SRNG_RING_ID_LMAC1_ID_END = 143
};

/* SRNG registers are split into two groups R0 and R2 */
#define HAL_SRNG_REG_GRP_R0	0
#define HAL_SRNG_REG_GRP_R2	1
#define HAL_SRNG_NUM_REG_GRP    2

#define HAL_SRNG_NUM_LMACS      3
#define HAL_SRNG_REO_EXCEPTION  HAL_SRNG_RING_ID_REO2SW1
#define HAL_SRNG_RINGS_PER_LMAC (HAL_SRNG_RING_ID_LMAC1_ID_END - \
				 HAL_SRNG_RING_ID_LMAC1_ID_START)
#define HAL_SRNG_NUM_LMAC_RINGS (HAL_SRNG_NUM_LMACS * HAL_SRNG_RINGS_PER_LMAC)
#define HAL_SRNG_RING_ID_MAX    (HAL_SRNG_RING_ID_UMAC_ID_END + \
				 HAL_SRNG_NUM_LMAC_RINGS)

#define HAL_RX_MAX_BA_WINDOW	256

#define HAL_DEFAULT_REO_TIMEOUT_USEC		(40 * 1000)

/**
 * enum hal_reo_cmd_type: Enum for REO command type
 * @HAL_REO_CMD_GET_QUEUE_STATS: Get REO queue status/stats
 * @HAL_REO_CMD_FLUSH_QUEUE: Flush all frames in REO queue
 * @HAL_REO_CMD_FLUSH_CACHE: Flush descriptor entries in the cache
 * @HAL_REO_CMD_UNBLOCK_CACHE: Unblock a descriptor's address that was blocked
 *      earlier with a 'REO_FLUSH_CACHE' command
 * @HAL_REO_CMD_FLUSH_TIMEOUT_LIST: Flush buffers/descriptors from timeout list
 * @HAL_REO_CMD_UPDATE_RX_QUEUE: Update REO queue settings
 */
enum hal_reo_cmd_type {
	HAL_REO_CMD_GET_QUEUE_STATS     = 0,
	HAL_REO_CMD_FLUSH_QUEUE         = 1,
	HAL_REO_CMD_FLUSH_CACHE         = 2,
	HAL_REO_CMD_UNBLOCK_CACHE       = 3,
	HAL_REO_CMD_FLUSH_TIMEOUT_LIST  = 4,
	HAL_REO_CMD_UPDATE_RX_QUEUE     = 5,
};

/**
 * enum hal_reo_cmd_status: Enum for execution status of REO command
 * @HAL_REO_CMD_SUCCESS: Command has successfully executed
 * @HAL_REO_CMD_BLOCKED: Command could not be executed as the queue
 *			 or cache was blocked
 * @HAL_REO_CMD_FAILED: Command execution failed, could be due to
 *			invalid queue desc
 * @HAL_REO_CMD_RESOURCE_BLOCKED:
 * @HAL_REO_CMD_DRAIN:
 */
enum hal_reo_cmd_status {
	HAL_REO_CMD_SUCCESS		= 0,
	HAL_REO_CMD_BLOCKED		= 1,
	HAL_REO_CMD_FAILED		= 2,
	HAL_REO_CMD_RESOURCE_BLOCKED	= 3,
	HAL_REO_CMD_DRAIN		= 0xff,
};

/* Interrupt mitigation - Batch threshold in terms of number of frames */
#define HAL_SRNG_INT_BATCH_THRESHOLD_TX 256
#define HAL_SRNG_INT_BATCH_THRESHOLD_RX 128
#define HAL_SRNG_INT_BATCH_THRESHOLD_OTHER 1

/* Interrupt mitigation - timer threshold in us */
#define HAL_SRNG_INT_TIMER_THRESHOLD_TX 1000
#define HAL_SRNG_INT_TIMER_THRESHOLD_RX 500
#define HAL_SRNG_INT_TIMER_THRESHOLD_OTHER 256

/* WCSS Relative address */
#define HAL_SEQ_WCSS_UMAC_OFFSET		0x00a00000
#define HAL_SEQ_WCSS_UMAC_REO_REG		0x00a38000
#define HAL_SEQ_WCSS_UMAC_TCL_REG		0x00a44000
#define HAL_SEQ_WCSS_UMAC_CE0_SRC_REG(sc) \
	(sc->hw_params.regs->hal_seq_wcss_umac_ce0_src_reg)
#define HAL_SEQ_WCSS_UMAC_CE0_DST_REG(sc) \
	(sc->hw_params.regs->hal_seq_wcss_umac_ce0_dst_reg)
#define HAL_SEQ_WCSS_UMAC_CE1_SRC_REG(sc) \
	(sc->hw_params.regs->hal_seq_wcss_umac_ce1_src_reg)
#define HAL_SEQ_WCSS_UMAC_CE1_DST_REG(sc) \
	(sc->hw_params.regs->hal_seq_wcss_umac_ce1_dst_reg)
#define HAL_SEQ_WCSS_UMAC_WBM_REG		0x00a34000

#define HAL_CE_WFSS_CE_REG_BASE			0x01b80000
#define HAL_WLAON_REG_BASE			0x01f80000

/* SW2TCL(x) R0 ring configuration address */
#define HAL_TCL1_RING_CMN_CTRL_REG		0x00000014
#define HAL_TCL1_RING_DSCP_TID_MAP		0x0000002c
#define HAL_TCL1_RING_BASE_LSB(sc)		\
	(sc->hw_params.regs->hal_tcl1_ring_base_lsb)
#define HAL_TCL1_RING_BASE_MSB(sc)		\
	(sc->hw_params.regs->hal_tcl1_ring_base_msb)
#define HAL_TCL1_RING_ID(sc)			\
	(sc->hw_params.regs->hal_tcl1_ring_id)
#define HAL_TCL1_RING_MISC(sc)			\
	(sc->hw_params.regs->hal_tcl1_ring_misc)
#define HAL_TCL1_RING_TP_ADDR_LSB(sc) \
	(sc->hw_params.regs->hal_tcl1_ring_tp_addr_lsb)
#define HAL_TCL1_RING_TP_ADDR_MSB(sc) \
	(sc->hw_params.regs->hal_tcl1_ring_tp_addr_msb)
#define HAL_TCL1_RING_CONSUMER_INT_SETUP_IX0(sc) \
	(sc->hw_params.regs->hal_tcl1_ring_consumer_int_setup_ix0)
#define HAL_TCL1_RING_CONSUMER_INT_SETUP_IX1(sc) \
	(sc->hw_params.regs->hal_tcl1_ring_consumer_int_setup_ix1)
#define HAL_TCL1_RING_MSI1_BASE_LSB(sc) \
	(sc->hw_params.regs->hal_tcl1_ring_msi1_base_lsb)
#define HAL_TCL1_RING_MSI1_BASE_MSB(sc) \
	(sc->hw_params.regs->hal_tcl1_ring_msi1_base_msb)
#define HAL_TCL1_RING_MSI1_DATA(sc) \
	(sc->hw_params.regs->hal_tcl1_ring_msi1_data)
#define HAL_TCL2_RING_BASE_LSB(sc)		\
	(sc->hw_params.regs->hal_tcl2_ring_base_lsb)
#define HAL_TCL_RING_BASE_LSB(sc)		\
	(sc->hw_params.regs->hal_tcl_ring_base_lsb)

#define HAL_TCL1_RING_MSI1_BASE_LSB_OFFSET(sc)				\
	(HAL_TCL1_RING_MSI1_BASE_LSB(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_MSI1_BASE_MSB_OFFSET(sc)				\
	(HAL_TCL1_RING_MSI1_BASE_MSB(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_MSI1_DATA_OFFSET(sc)				\
	(HAL_TCL1_RING_MSI1_DATA(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_BASE_MSB_OFFSET(sc)				\
	(HAL_TCL1_RING_BASE_MSB(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_ID_OFFSET(sc)				\
	(HAL_TCL1_RING_ID(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_CONSR_INT_SETUP_IX0_OFFSET(sc)			\
	(HAL_TCL1_RING_CONSUMER_INT_SETUP_IX0(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_CONSR_INT_SETUP_IX1_OFFSET(sc) \
		(HAL_TCL1_RING_CONSUMER_INT_SETUP_IX1(sc) - \
		HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_TP_ADDR_LSB_OFFSET(sc) \
		(HAL_TCL1_RING_TP_ADDR_LSB(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_TP_ADDR_MSB_OFFSET(sc) \
		(HAL_TCL1_RING_TP_ADDR_MSB(sc) - HAL_TCL1_RING_BASE_LSB(sc))
#define HAL_TCL1_RING_MISC_OFFSET(sc) \
		(HAL_TCL1_RING_MISC(sc) - HAL_TCL1_RING_BASE_LSB(sc))

/* SW2TCL(x) R2 ring pointers (head/tail) address */
#define HAL_TCL1_RING_HP			0x00002000
#define HAL_TCL1_RING_TP			0x00002004
#define HAL_TCL2_RING_HP			0x00002008
#define HAL_TCL_RING_HP				0x00002018

#define HAL_TCL1_RING_TP_OFFSET \
		(HAL_TCL1_RING_TP - HAL_TCL1_RING_HP)

/* TCL STATUS ring address */
#define HAL_TCL_STATUS_RING_BASE_LSB(sc) \
	(sc->hw_params.regs->hal_tcl_status_ring_base_lsb)
#define HAL_TCL_STATUS_RING_HP			0x00002030

/* REO2SW(x) R0 ring configuration address */
#define HAL_REO1_GEN_ENABLE			0x00000000
#define HAL_REO1_DEST_RING_CTRL_IX_0		0x00000004
#define HAL_REO1_DEST_RING_CTRL_IX_1		0x00000008
#define HAL_REO1_DEST_RING_CTRL_IX_2		0x0000000c
#define HAL_REO1_DEST_RING_CTRL_IX_3		0x00000010
#define HAL_REO1_MISC_CTL(sc)			\
	(sc->hw_params.regs->hal_reo1_misc_ctl)
#define HAL_REO1_RING_BASE_LSB(sc)		\
	(sc->hw_params.regs->hal_reo1_ring_base_lsb)
#define HAL_REO1_RING_BASE_MSB(sc)		\
	(sc->hw_params.regs->hal_reo1_ring_base_msb)
#define HAL_REO1_RING_ID(sc)			\
	(sc->hw_params.regs->hal_reo1_ring_id)
#define HAL_REO1_RING_MISC(sc)			\
	(sc->hw_params.regs->hal_reo1_ring_misc)
#define HAL_REO1_RING_HP_ADDR_LSB(sc) \
	(sc->hw_params.regs->hal_reo1_ring_hp_addr_lsb)
#define HAL_REO1_RING_HP_ADDR_MSB(sc) \
	(sc->hw_params.regs->hal_reo1_ring_hp_addr_msb)
#define HAL_REO1_RING_PRODUCER_INT_SETUP(sc) \
	(sc->hw_params.regs->hal_reo1_ring_producer_int_setup)
#define HAL_REO1_RING_MSI1_BASE_LSB(sc) \
	(sc->hw_params.regs->hal_reo1_ring_msi1_base_lsb)
#define HAL_REO1_RING_MSI1_BASE_MSB(sc) \
	(sc->hw_params.regs->hal_reo1_ring_msi1_base_msb)
#define HAL_REO1_RING_MSI1_DATA(sc) \
	(sc->hw_params.regs->hal_reo1_ring_msi1_data)
#define HAL_REO2_RING_BASE_LSB(sc)		\
	(sc->hw_params.regs->hal_reo2_ring_base_lsb)
#define HAL_REO1_AGING_THRESH_IX_0(sc) \
	(sc->hw_params.regs->hal_reo1_aging_thresh_ix_0)
#define HAL_REO1_AGING_THRESH_IX_1(sc) \
	(sc->hw_params.regs->hal_reo1_aging_thresh_ix_1)
#define HAL_REO1_AGING_THRESH_IX_2(sc) \
	(sc->hw_params.regs->hal_reo1_aging_thresh_ix_2)
#define HAL_REO1_AGING_THRESH_IX_3(sc) \
	(sc->hw_params.regs->hal_reo1_aging_thresh_ix_3)

#define HAL_REO1_RING_MSI1_BASE_LSB_OFFSET(sc) \
		(HAL_REO1_RING_MSI1_BASE_LSB(sc) - HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_MSI1_BASE_MSB_OFFSET(sc) \
		(HAL_REO1_RING_MSI1_BASE_MSB(sc) - HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_MSI1_DATA_OFFSET(sc) \
		(HAL_REO1_RING_MSI1_DATA(sc) - HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_BASE_MSB_OFFSET(sc) \
		(HAL_REO1_RING_BASE_MSB(sc) - HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_ID_OFFSET(sc) (HAL_REO1_RING_ID(sc) - \
					HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_PRODUCER_INT_SETUP_OFFSET(sc) \
		(HAL_REO1_RING_PRODUCER_INT_SETUP(sc) - \
		HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_HP_ADDR_LSB_OFFSET(sc) \
		(HAL_REO1_RING_HP_ADDR_LSB(sc) - HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_HP_ADDR_MSB_OFFSET(sc) \
		(HAL_REO1_RING_HP_ADDR_MSB(sc) - HAL_REO1_RING_BASE_LSB(sc))
#define HAL_REO1_RING_MISC_OFFSET(sc) \
	(HAL_REO1_RING_MISC(sc) - HAL_REO1_RING_BASE_LSB(sc))

/* REO2SW(x) R2 ring pointers (head/tail) address */
#define HAL_REO1_RING_HP(sc)			\
	(sc->hw_params.regs->hal_reo1_ring_hp)
#define HAL_REO1_RING_TP(sc)			\
	(sc->hw_params.regs->hal_reo1_ring_tp)
#define HAL_REO2_RING_HP(sc)			\
	(sc->hw_params.regs->hal_reo2_ring_hp)

#define HAL_REO1_RING_TP_OFFSET(sc)	\
	(HAL_REO1_RING_TP(sc) - HAL_REO1_RING_HP(sc))

/* REO2TCL R0 ring configuration address */
#define HAL_REO_TCL_RING_BASE_LSB(sc) \
	(sc->hw_params.regs->hal_reo_tcl_ring_base_lsb)

/* REO2TCL R2 ring pointer (head/tail) address */
#define HAL_REO_TCL_RING_HP(sc)			\
	(sc->hw_params.regs->hal_reo_tcl_ring_hp)

/* REO CMD R0 address */
#define HAL_REO_CMD_RING_BASE_LSB(sc) \
	(sc->hw_params.regs->hal_reo_cmd_ring_base_lsb)

/* REO CMD R2 address */
#define HAL_REO_CMD_HP(sc)			\
	(sc->hw_params.regs->hal_reo_cmd_ring_hp)

/* SW2REO R0 address */
#define HAL_SW2REO_RING_BASE_LSB(sc) \
	(sc->hw_params.regs->hal_sw2reo_ring_base_lsb)

/* SW2REO R2 address */
#define HAL_SW2REO_RING_HP(sc)			\
	(sc->hw_params.regs->hal_sw2reo_ring_hp)

/* CE ring R0 address */
#define HAL_CE_DST_RING_BASE_LSB		0x00000000
#define HAL_CE_DST_STATUS_RING_BASE_LSB		0x00000058
#define HAL_CE_DST_RING_CTRL			0x000000b0

/* CE ring R2 address */
#define HAL_CE_DST_RING_HP			0x00000400
#define HAL_CE_DST_STATUS_RING_HP		0x00000408

/* REO status address */
#define HAL_REO_STATUS_RING_BASE_LSB(sc) \
	(sc->hw_params.regs->hal_reo_status_ring_base_lsb)
#define HAL_REO_STATUS_HP(sc)			\
	(sc->hw_params.regs->hal_reo_status_hp)

/* WBM Idle R0 address */
#define HAL_WBM_IDLE_LINK_RING_BASE_LSB(x) \
		(sc->hw_params.regs->hal_wbm_idle_link_ring_base_lsb)
#define HAL_WBM_IDLE_LINK_RING_MISC_ADDR(x) \
		(sc->hw_params.regs->hal_wbm_idle_link_ring_misc)
#define HAL_WBM_R0_IDLE_LIST_CONTROL_ADDR	0x00000048
#define HAL_WBM_R0_IDLE_LIST_SIZE_ADDR		0x0000004c
#define HAL_WBM_SCATTERED_RING_BASE_LSB		0x00000058
#define HAL_WBM_SCATTERED_RING_BASE_MSB		0x0000005c
#define HAL_WBM_SCATTERED_DESC_PTR_HEAD_INFO_IX0 0x00000068
#define HAL_WBM_SCATTERED_DESC_PTR_HEAD_INFO_IX1 0x0000006c
#define HAL_WBM_SCATTERED_DESC_PTR_TAIL_INFO_IX0 0x00000078
#define HAL_WBM_SCATTERED_DESC_PTR_TAIL_INFO_IX1 0x0000007c
#define HAL_WBM_SCATTERED_DESC_PTR_HP_ADDR	 0x00000084

/* WBM Idle R2 address */
#define HAL_WBM_IDLE_LINK_RING_HP		0x000030b0

/* SW2WBM R0 release address */
#define HAL_WBM_RELEASE_RING_BASE_LSB(x) \
		(sc->hw_params.regs->hal_wbm_release_ring_base_lsb)

/* SW2WBM R2 release address */
#define HAL_WBM_RELEASE_RING_HP			0x00003018

/* WBM2SW R0 release address */
#define HAL_WBM0_RELEASE_RING_BASE_LSB(x) \
		(sc->hw_params.regs->hal_wbm0_release_ring_base_lsb)
#define HAL_WBM1_RELEASE_RING_BASE_LSB(x) \
		(sc->hw_params.regs->hal_wbm1_release_ring_base_lsb)

/* WBM2SW R2 release address */
#define HAL_WBM0_RELEASE_RING_HP		0x000030c0
#define HAL_WBM1_RELEASE_RING_HP		0x000030c8

/* TCL ring field mask and offset */
#define HAL_TCL1_RING_BASE_MSB_RING_SIZE		GENMASK(27, 8)
#define HAL_TCL1_RING_BASE_MSB_RING_BASE_ADDR_MSB	GENMASK(7, 0)
#define HAL_TCL1_RING_ID_ENTRY_SIZE			GENMASK(7, 0)
#define HAL_TCL1_RING_MISC_MSI_LOOPCNT_DISABLE		BIT(1)
#define HAL_TCL1_RING_MISC_MSI_SWAP			BIT(3)
#define HAL_TCL1_RING_MISC_HOST_FW_SWAP			BIT(4)
#define HAL_TCL1_RING_MISC_DATA_TLV_SWAP		BIT(5)
#define HAL_TCL1_RING_MISC_SRNG_ENABLE			BIT(6)
#define HAL_TCL1_RING_CONSR_INT_SETUP_IX0_INTR_TMR_THOLD   GENMASK(31, 16)
#define HAL_TCL1_RING_CONSR_INT_SETUP_IX0_BATCH_COUNTER_THOLD GENMASK(14, 0)
#define HAL_TCL1_RING_CONSR_INT_SETUP_IX1_LOW_THOLD	GENMASK(15, 0)
#define HAL_TCL1_RING_MSI1_BASE_MSB_MSI1_ENABLE		BIT(8)
#define HAL_TCL1_RING_MSI1_BASE_MSB_ADDR		GENMASK(7, 0)
#define HAL_TCL1_RING_CMN_CTRL_DSCP_TID_MAP_PROG_EN	BIT(17)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP		GENMASK(31, 0)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP0		GENMASK(2, 0)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP1		GENMASK(5, 3)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP2		GENMASK(8, 6)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP3		GENMASK(11, 9)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP4		GENMASK(14, 12)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP5		GENMASK(17, 15)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP6		GENMASK(20, 18)
#define HAL_TCL1_RING_FIELD_DSCP_TID_MAP7		GENMASK(23, 21)

/* REO ring field mask and offset */
#define HAL_REO1_RING_BASE_MSB_RING_SIZE		GENMASK(27, 8)
#define HAL_REO1_RING_BASE_MSB_RING_BASE_ADDR_MSB	GENMASK(7, 0)
#define HAL_REO1_RING_ID_RING_ID			GENMASK(15, 8)
#define HAL_REO1_RING_ID_ENTRY_SIZE			GENMASK(7, 0)
#define HAL_REO1_RING_MISC_MSI_SWAP			BIT(3)
#define HAL_REO1_RING_MISC_HOST_FW_SWAP			BIT(4)
#define HAL_REO1_RING_MISC_DATA_TLV_SWAP		BIT(5)
#define HAL_REO1_RING_MISC_SRNG_ENABLE			BIT(6)
#define HAL_REO1_RING_PRDR_INT_SETUP_INTR_TMR_THOLD	GENMASK(31, 16)
#define HAL_REO1_RING_PRDR_INT_SETUP_BATCH_COUNTER_THOLD GENMASK(14, 0)
#define HAL_REO1_RING_MSI1_BASE_MSB_MSI1_ENABLE		BIT(8)
#define HAL_REO1_RING_MSI1_BASE_MSB_ADDR		GENMASK(7, 0)
#define HAL_REO1_GEN_ENABLE_FRAG_DST_RING		GENMASK(25, 23)
#define HAL_REO1_GEN_ENABLE_AGING_LIST_ENABLE		BIT(2)
#define HAL_REO1_GEN_ENABLE_AGING_FLUSH_ENABLE		BIT(3)
#define HAL_REO1_MISC_CTL_FRAGMENT_DST_RING		GENMASK(20, 17)

/* CE ring bit field mask and shift */
#define HAL_CE_DST_R0_DEST_CTRL_MAX_LEN			GENMASK(15, 0)

#define HAL_ADDR_LSB_REG_MASK				0xffffffff

#define HAL_ADDR_MSB_REG_SHIFT				32

/* WBM ring bit field mask and shift */
#define HAL_WBM_LINK_DESC_IDLE_LIST_MODE		BIT(1)
#define HAL_WBM_SCATTER_BUFFER_SIZE			GENMASK(10, 2)
#define HAL_WBM_SCATTER_RING_SIZE_OF_IDLE_LINK_DESC_LIST GENMASK(31, 16)
#define HAL_WBM_SCATTERED_DESC_MSB_BASE_ADDR_39_32	GENMASK(7, 0)
#define HAL_WBM_SCATTERED_DESC_MSB_BASE_ADDR_MATCH_TAG	GENMASK(31, 8)

#define HAL_WBM_SCATTERED_DESC_HEAD_P_OFFSET_IX1	GENMASK(20, 8)
#define HAL_WBM_SCATTERED_DESC_TAIL_P_OFFSET_IX1	GENMASK(20, 8)

#define BASE_ADDR_MATCH_TAG_VAL 0x5

#define HAL_REO_REO2SW1_RING_BASE_MSB_RING_SIZE		0x000fffff
#define HAL_REO_REO2TCL_RING_BASE_MSB_RING_SIZE		0x000fffff
#define HAL_REO_SW2REO_RING_BASE_MSB_RING_SIZE		0x0000ffff
#define HAL_REO_CMD_RING_BASE_MSB_RING_SIZE		0x0000ffff
#define HAL_REO_STATUS_RING_BASE_MSB_RING_SIZE		0x0000ffff
#define HAL_SW2TCL1_RING_BASE_MSB_RING_SIZE		0x000fffff
#define HAL_SW2TCL1_CMD_RING_BASE_MSB_RING_SIZE		0x000fffff
#define HAL_TCL_STATUS_RING_BASE_MSB_RING_SIZE		0x0000ffff
#define HAL_CE_SRC_RING_BASE_MSB_RING_SIZE		0x0000ffff
#define HAL_CE_DST_RING_BASE_MSB_RING_SIZE		0x0000ffff
#define HAL_CE_DST_STATUS_RING_BASE_MSB_RING_SIZE	0x0000ffff
#define HAL_WBM_IDLE_LINK_RING_BASE_MSB_RING_SIZE	0x0000ffff
#define HAL_SW2WBM_RELEASE_RING_BASE_MSB_RING_SIZE	0x0000ffff
#define HAL_WBM2SW_RELEASE_RING_BASE_MSB_RING_SIZE	0x000fffff
#define HAL_RXDMA_RING_MAX_SIZE				0x0000ffff

/* IPQ5018 ce registers */
#define HAL_IPQ5018_CE_WFSS_REG_BASE		0x08400000
#define HAL_IPQ5018_CE_SIZE			0x200000

#define BUFFER_ADDR_INFO0_ADDR         GENMASK(31, 0)

#define BUFFER_ADDR_INFO1_ADDR         GENMASK(7, 0)
#define BUFFER_ADDR_INFO1_RET_BUF_MGR  GENMASK(10, 8)
#define BUFFER_ADDR_INFO1_SW_COOKIE    GENMASK(31, 11)

struct ath11k_buffer_addr {
	uint32_t info0;
	uint32_t info1;
} __packed;

/* ath11k_buffer_addr
 *
 * info0
 *		Address (lower 32 bits) of the msdu buffer or msdu extension
 *		descriptor or Link descriptor
 *
 * addr
 *		Address (upper 8 bits) of the msdu buffer or msdu extension
 *		descriptor or Link descriptor
 *
 * return_buffer_manager (RBM)
 *		Consumer: WBM
 *		Producer: SW/FW
 *		Indicates to which buffer manager the buffer or MSDU_EXTENSION
 *		descriptor or link descriptor that is being pointed to shall be
 *		returned after the frame has been processed. It is used by WBM
 *		for routing purposes.
 *
 *		Values are defined in enum %HAL_RX_BUF_RBM_
 *
 * sw_buffer_cookie
 *		Cookie field exclusively used by SW. HW ignores the contents,
 *		accept that it passes the programmed value on to other
 *		descriptors together with the physical address.
 *
 *		Field can be used by SW to for example associate the buffers
 *		physical address with the virtual address.
 */

enum hal_tlv_tag {
	HAL_MACTX_CBF_START                    =   0 /* 0x0 */,
	HAL_PHYRX_DATA                         =   1 /* 0x1 */,
	HAL_PHYRX_CBF_DATA_RESP                =   2 /* 0x2 */,
	HAL_PHYRX_ABORT_REQUEST                =   3 /* 0x3 */,
	HAL_PHYRX_USER_ABORT_NOTIFICATION      =   4 /* 0x4 */,
	HAL_MACTX_DATA_RESP                    =   5 /* 0x5 */,
	HAL_MACTX_CBF_DATA                     =   6 /* 0x6 */,
	HAL_MACTX_CBF_DONE                     =   7 /* 0x7 */,
	HAL_MACRX_CBF_READ_REQUEST             =   8 /* 0x8 */,
	HAL_MACRX_CBF_DATA_REQUEST             =   9 /* 0x9 */,
	HAL_MACRX_EXPECT_NDP_RECEPTION         =  10 /* 0xa */,
	HAL_MACRX_FREEZE_CAPTURE_CHANNEL       =  11 /* 0xb */,
	HAL_MACRX_NDP_TIMEOUT                  =  12 /* 0xc */,
	HAL_MACRX_ABORT_ACK                    =  13 /* 0xd */,
	HAL_MACRX_REQ_IMPLICIT_FB              =  14 /* 0xe */,
	HAL_MACRX_CHAIN_MASK                   =  15 /* 0xf */,
	HAL_MACRX_NAP_USER                     =  16 /* 0x10 */,
	HAL_MACRX_ABORT_REQUEST                =  17 /* 0x11 */,
	HAL_PHYTX_OTHER_TRANSMIT_INFO16        =  18 /* 0x12 */,
	HAL_PHYTX_ABORT_ACK                    =  19 /* 0x13 */,
	HAL_PHYTX_ABORT_REQUEST                =  20 /* 0x14 */,
	HAL_PHYTX_PKT_END                      =  21 /* 0x15 */,
	HAL_PHYTX_PPDU_HEADER_INFO_REQUEST     =  22 /* 0x16 */,
	HAL_PHYTX_REQUEST_CTRL_INFO            =  23 /* 0x17 */,
	HAL_PHYTX_DATA_REQUEST                 =  24 /* 0x18 */,
	HAL_PHYTX_BF_CV_LOADING_DONE           =  25 /* 0x19 */,
	HAL_PHYTX_NAP_ACK                      =  26 /* 0x1a */,
	HAL_PHYTX_NAP_DONE                     =  27 /* 0x1b */,
	HAL_PHYTX_OFF_ACK                      =  28 /* 0x1c */,
	HAL_PHYTX_ON_ACK                       =  29 /* 0x1d */,
	HAL_PHYTX_SYNTH_OFF_ACK                =  30 /* 0x1e */,
	HAL_PHYTX_DEBUG16                      =  31 /* 0x1f */,
	HAL_MACTX_ABORT_REQUEST                =  32 /* 0x20 */,
	HAL_MACTX_ABORT_ACK                    =  33 /* 0x21 */,
	HAL_MACTX_PKT_END                      =  34 /* 0x22 */,
	HAL_MACTX_PRE_PHY_DESC                 =  35 /* 0x23 */,
	HAL_MACTX_BF_PARAMS_COMMON             =  36 /* 0x24 */,
	HAL_MACTX_BF_PARAMS_PER_USER           =  37 /* 0x25 */,
	HAL_MACTX_PREFETCH_CV                  =  38 /* 0x26 */,
	HAL_MACTX_USER_DESC_COMMON             =  39 /* 0x27 */,
	HAL_MACTX_USER_DESC_PER_USER           =  40 /* 0x28 */,
	HAL_EXAMPLE_USER_TLV_16                =  41 /* 0x29 */,
	HAL_EXAMPLE_TLV_16                     =  42 /* 0x2a */,
	HAL_MACTX_PHY_OFF                      =  43 /* 0x2b */,
	HAL_MACTX_PHY_ON                       =  44 /* 0x2c */,
	HAL_MACTX_SYNTH_OFF                    =  45 /* 0x2d */,
	HAL_MACTX_EXPECT_CBF_COMMON            =  46 /* 0x2e */,
	HAL_MACTX_EXPECT_CBF_PER_USER          =  47 /* 0x2f */,
	HAL_MACTX_PHY_DESC                     =  48 /* 0x30 */,
	HAL_MACTX_L_SIG_A                      =  49 /* 0x31 */,
	HAL_MACTX_L_SIG_B                      =  50 /* 0x32 */,
	HAL_MACTX_HT_SIG                       =  51 /* 0x33 */,
	HAL_MACTX_VHT_SIG_A                    =  52 /* 0x34 */,
	HAL_MACTX_VHT_SIG_B_SU20               =  53 /* 0x35 */,
	HAL_MACTX_VHT_SIG_B_SU40               =  54 /* 0x36 */,
	HAL_MACTX_VHT_SIG_B_SU80               =  55 /* 0x37 */,
	HAL_MACTX_VHT_SIG_B_SU160              =  56 /* 0x38 */,
	HAL_MACTX_VHT_SIG_B_MU20               =  57 /* 0x39 */,
	HAL_MACTX_VHT_SIG_B_MU40               =  58 /* 0x3a */,
	HAL_MACTX_VHT_SIG_B_MU80               =  59 /* 0x3b */,
	HAL_MACTX_VHT_SIG_B_MU160              =  60 /* 0x3c */,
	HAL_MACTX_SERVICE                      =  61 /* 0x3d */,
	HAL_MACTX_HE_SIG_A_SU                  =  62 /* 0x3e */,
	HAL_MACTX_HE_SIG_A_MU_DL               =  63 /* 0x3f */,
	HAL_MACTX_HE_SIG_A_MU_UL               =  64 /* 0x40 */,
	HAL_MACTX_HE_SIG_B1_MU                 =  65 /* 0x41 */,
	HAL_MACTX_HE_SIG_B2_MU                 =  66 /* 0x42 */,
	HAL_MACTX_HE_SIG_B2_OFDMA              =  67 /* 0x43 */,
	HAL_MACTX_DELETE_CV                    =  68 /* 0x44 */,
	HAL_MACTX_MU_UPLINK_COMMON             =  69 /* 0x45 */,
	HAL_MACTX_MU_UPLINK_USER_SETUP         =  70 /* 0x46 */,
	HAL_MACTX_OTHER_TRANSMIT_INFO          =  71 /* 0x47 */,
	HAL_MACTX_PHY_NAP                      =  72 /* 0x48 */,
	HAL_MACTX_DEBUG                        =  73 /* 0x49 */,
	HAL_PHYRX_ABORT_ACK                    =  74 /* 0x4a */,
	HAL_PHYRX_GENERATED_CBF_DETAILS        =  75 /* 0x4b */,
	HAL_PHYRX_RSSI_LEGACY                  =  76 /* 0x4c */,
	HAL_PHYRX_RSSI_HT                      =  77 /* 0x4d */,
	HAL_PHYRX_USER_INFO                    =  78 /* 0x4e */,
	HAL_PHYRX_PKT_END                      =  79 /* 0x4f */,
	HAL_PHYRX_DEBUG                        =  80 /* 0x50 */,
	HAL_PHYRX_CBF_TRANSFER_DONE            =  81 /* 0x51 */,
	HAL_PHYRX_CBF_TRANSFER_ABORT           =  82 /* 0x52 */,
	HAL_PHYRX_L_SIG_A                      =  83 /* 0x53 */,
	HAL_PHYRX_L_SIG_B                      =  84 /* 0x54 */,
	HAL_PHYRX_HT_SIG                       =  85 /* 0x55 */,
	HAL_PHYRX_VHT_SIG_A                    =  86 /* 0x56 */,
	HAL_PHYRX_VHT_SIG_B_SU20               =  87 /* 0x57 */,
	HAL_PHYRX_VHT_SIG_B_SU40               =  88 /* 0x58 */,
	HAL_PHYRX_VHT_SIG_B_SU80               =  89 /* 0x59 */,
	HAL_PHYRX_VHT_SIG_B_SU160              =  90 /* 0x5a */,
	HAL_PHYRX_VHT_SIG_B_MU20               =  91 /* 0x5b */,
	HAL_PHYRX_VHT_SIG_B_MU40               =  92 /* 0x5c */,
	HAL_PHYRX_VHT_SIG_B_MU80               =  93 /* 0x5d */,
	HAL_PHYRX_VHT_SIG_B_MU160              =  94 /* 0x5e */,
	HAL_PHYRX_HE_SIG_A_SU                  =  95 /* 0x5f */,
	HAL_PHYRX_HE_SIG_A_MU_DL               =  96 /* 0x60 */,
	HAL_PHYRX_HE_SIG_A_MU_UL               =  97 /* 0x61 */,
	HAL_PHYRX_HE_SIG_B1_MU                 =  98 /* 0x62 */,
	HAL_PHYRX_HE_SIG_B2_MU                 =  99 /* 0x63 */,
	HAL_PHYRX_HE_SIG_B2_OFDMA              = 100 /* 0x64 */,
	HAL_PHYRX_OTHER_RECEIVE_INFO           = 101 /* 0x65 */,
	HAL_PHYRX_COMMON_USER_INFO             = 102 /* 0x66 */,
	HAL_PHYRX_DATA_DONE                    = 103 /* 0x67 */,
	HAL_RECEIVE_RSSI_INFO                  = 104 /* 0x68 */,
	HAL_RECEIVE_USER_INFO                  = 105 /* 0x69 */,
	HAL_MIMO_CONTROL_INFO                  = 106 /* 0x6a */,
	HAL_RX_LOCATION_INFO                   = 107 /* 0x6b */,
	HAL_COEX_TX_REQ                        = 108 /* 0x6c */,
	HAL_DUMMY                              = 109 /* 0x6d */,
	HAL_RX_TIMING_OFFSET_INFO              = 110 /* 0x6e */,
	HAL_EXAMPLE_TLV_32_NAME                = 111 /* 0x6f */,
	HAL_MPDU_LIMIT                         = 112 /* 0x70 */,
	HAL_NA_LENGTH_END                      = 113 /* 0x71 */,
	HAL_OLE_BUF_STATUS                     = 114 /* 0x72 */,
	HAL_PCU_PPDU_SETUP_DONE                = 115 /* 0x73 */,
	HAL_PCU_PPDU_SETUP_END                 = 116 /* 0x74 */,
	HAL_PCU_PPDU_SETUP_INIT                = 117 /* 0x75 */,
	HAL_PCU_PPDU_SETUP_START               = 118 /* 0x76 */,
	HAL_PDG_FES_SETUP                      = 119 /* 0x77 */,
	HAL_PDG_RESPONSE                       = 120 /* 0x78 */,
	HAL_PDG_TX_REQ                         = 121 /* 0x79 */,
	HAL_SCH_WAIT_INSTR                     = 122 /* 0x7a */,
	HAL_SCHEDULER_TLV                      = 123 /* 0x7b */,
	HAL_TQM_FLOW_EMPTY_STATUS              = 124 /* 0x7c */,
	HAL_TQM_FLOW_NOT_EMPTY_STATUS          = 125 /* 0x7d */,
	HAL_TQM_GEN_MPDU_LENGTH_LIST           = 126 /* 0x7e */,
	HAL_TQM_GEN_MPDU_LENGTH_LIST_STATUS    = 127 /* 0x7f */,
	HAL_TQM_GEN_MPDUS                      = 128 /* 0x80 */,
	HAL_TQM_GEN_MPDUS_STATUS               = 129 /* 0x81 */,
	HAL_TQM_REMOVE_MPDU                    = 130 /* 0x82 */,
	HAL_TQM_REMOVE_MPDU_STATUS             = 131 /* 0x83 */,
	HAL_TQM_REMOVE_MSDU                    = 132 /* 0x84 */,
	HAL_TQM_REMOVE_MSDU_STATUS             = 133 /* 0x85 */,
	HAL_TQM_UPDATE_TX_MPDU_COUNT           = 134 /* 0x86 */,
	HAL_TQM_WRITE_CMD                      = 135 /* 0x87 */,
	HAL_OFDMA_TRIGGER_DETAILS              = 136 /* 0x88 */,
	HAL_TX_DATA                            = 137 /* 0x89 */,
	HAL_TX_FES_SETUP                       = 138 /* 0x8a */,
	HAL_RX_PACKET                          = 139 /* 0x8b */,
	HAL_EXPECTED_RESPONSE                  = 140 /* 0x8c */,
	HAL_TX_MPDU_END                        = 141 /* 0x8d */,
	HAL_TX_MPDU_START                      = 142 /* 0x8e */,
	HAL_TX_MSDU_END                        = 143 /* 0x8f */,
	HAL_TX_MSDU_START                      = 144 /* 0x90 */,
	HAL_TX_SW_MODE_SETUP                   = 145 /* 0x91 */,
	HAL_TXPCU_BUFFER_STATUS                = 146 /* 0x92 */,
	HAL_TXPCU_USER_BUFFER_STATUS           = 147 /* 0x93 */,
	HAL_DATA_TO_TIME_CONFIG                = 148 /* 0x94 */,
	HAL_EXAMPLE_USER_TLV_32                = 149 /* 0x95 */,
	HAL_MPDU_INFO                          = 150 /* 0x96 */,
	HAL_PDG_USER_SETUP                     = 151 /* 0x97 */,
	HAL_TX_11AH_SETUP                      = 152 /* 0x98 */,
	HAL_REO_UPDATE_RX_REO_QUEUE_STATUS     = 153 /* 0x99 */,
	HAL_TX_PEER_ENTRY                      = 154 /* 0x9a */,
	HAL_TX_RAW_OR_NATIVE_FRAME_SETUP       = 155 /* 0x9b */,
	HAL_EXAMPLE_STRUCT_NAME                = 156 /* 0x9c */,
	HAL_PCU_PPDU_SETUP_END_INFO            = 157 /* 0x9d */,
	HAL_PPDU_RATE_SETTING                  = 158 /* 0x9e */,
	HAL_PROT_RATE_SETTING                  = 159 /* 0x9f */,
	HAL_RX_MPDU_DETAILS                    = 160 /* 0xa0 */,
	HAL_EXAMPLE_USER_TLV_42                = 161 /* 0xa1 */,
	HAL_RX_MSDU_LINK                       = 162 /* 0xa2 */,
	HAL_RX_REO_QUEUE                       = 163 /* 0xa3 */,
	HAL_ADDR_SEARCH_ENTRY                  = 164 /* 0xa4 */,
	HAL_SCHEDULER_CMD                      = 165 /* 0xa5 */,
	HAL_TX_FLUSH                           = 166 /* 0xa6 */,
	HAL_TQM_ENTRANCE_RING                  = 167 /* 0xa7 */,
	HAL_TX_DATA_WORD                       = 168 /* 0xa8 */,
	HAL_TX_MPDU_DETAILS                    = 169 /* 0xa9 */,
	HAL_TX_MPDU_LINK                       = 170 /* 0xaa */,
	HAL_TX_MPDU_LINK_PTR                   = 171 /* 0xab */,
	HAL_TX_MPDU_QUEUE_HEAD                 = 172 /* 0xac */,
	HAL_TX_MPDU_QUEUE_EXT                  = 173 /* 0xad */,
	HAL_TX_MPDU_QUEUE_EXT_PTR              = 174 /* 0xae */,
	HAL_TX_MSDU_DETAILS                    = 175 /* 0xaf */,
	HAL_TX_MSDU_EXTENSION                  = 176 /* 0xb0 */,
	HAL_TX_MSDU_FLOW                       = 177 /* 0xb1 */,
	HAL_TX_MSDU_LINK                       = 178 /* 0xb2 */,
	HAL_TX_MSDU_LINK_ENTRY_PTR             = 179 /* 0xb3 */,
	HAL_RESPONSE_RATE_SETTING              = 180 /* 0xb4 */,
	HAL_TXPCU_BUFFER_BASICS                = 181 /* 0xb5 */,
	HAL_UNIFORM_DESCRIPTOR_HEADER          = 182 /* 0xb6 */,
	HAL_UNIFORM_TQM_CMD_HEADER             = 183 /* 0xb7 */,
	HAL_UNIFORM_TQM_STATUS_HEADER          = 184 /* 0xb8 */,
	HAL_USER_RATE_SETTING                  = 185 /* 0xb9 */,
	HAL_WBM_BUFFER_RING                    = 186 /* 0xba */,
	HAL_WBM_LINK_DESCRIPTOR_RING           = 187 /* 0xbb */,
	HAL_WBM_RELEASE_RING                   = 188 /* 0xbc */,
	HAL_TX_FLUSH_REQ                       = 189 /* 0xbd */,
	HAL_RX_MSDU_DETAILS                    = 190 /* 0xbe */,
	HAL_TQM_WRITE_CMD_STATUS               = 191 /* 0xbf */,
	HAL_TQM_GET_MPDU_QUEUE_STATS           = 192 /* 0xc0 */,
	HAL_TQM_GET_MSDU_FLOW_STATS            = 193 /* 0xc1 */,
	HAL_EXAMPLE_USER_CTLV_32               = 194 /* 0xc2 */,
	HAL_TX_FES_STATUS_START                = 195 /* 0xc3 */,
	HAL_TX_FES_STATUS_USER_PPDU            = 196 /* 0xc4 */,
	HAL_TX_FES_STATUS_USER_RESPONSE        = 197 /* 0xc5 */,
	HAL_TX_FES_STATUS_END                  = 198 /* 0xc6 */,
	HAL_RX_TRIG_INFO                       = 199 /* 0xc7 */,
	HAL_RXPCU_TX_SETUP_CLEAR               = 200 /* 0xc8 */,
	HAL_RX_FRAME_BITMAP_REQ                = 201 /* 0xc9 */,
	HAL_RX_FRAME_BITMAP_ACK                = 202 /* 0xca */,
	HAL_COEX_RX_STATUS                     = 203 /* 0xcb */,
	HAL_RX_START_PARAM                     = 204 /* 0xcc */,
	HAL_RX_PPDU_START                      = 205 /* 0xcd */,
	HAL_RX_PPDU_END                        = 206 /* 0xce */,
	HAL_RX_MPDU_START                      = 207 /* 0xcf */,
	HAL_RX_MPDU_END                        = 208 /* 0xd0 */,
	HAL_RX_MSDU_START                      = 209 /* 0xd1 */,
	HAL_RX_MSDU_END                        = 210 /* 0xd2 */,
	HAL_RX_ATTENTION                       = 211 /* 0xd3 */,
	HAL_RECEIVED_RESPONSE_INFO             = 212 /* 0xd4 */,
	HAL_RX_PHY_SLEEP                       = 213 /* 0xd5 */,
	HAL_RX_HEADER                          = 214 /* 0xd6 */,
	HAL_RX_PEER_ENTRY                      = 215 /* 0xd7 */,
	HAL_RX_FLUSH                           = 216 /* 0xd8 */,
	HAL_RX_RESPONSE_REQUIRED_INFO          = 217 /* 0xd9 */,
	HAL_RX_FRAMELESS_BAR_DETAILS           = 218 /* 0xda */,
	HAL_TQM_GET_MPDU_QUEUE_STATS_STATUS    = 219 /* 0xdb */,
	HAL_TQM_GET_MSDU_FLOW_STATS_STATUS     = 220 /* 0xdc */,
	HAL_TX_CBF_INFO                        = 221 /* 0xdd */,
	HAL_PCU_PPDU_SETUP_USER                = 222 /* 0xde */,
	HAL_RX_MPDU_PCU_START                  = 223 /* 0xdf */,
	HAL_RX_PM_INFO                         = 224 /* 0xe0 */,
	HAL_RX_USER_PPDU_END                   = 225 /* 0xe1 */,
	HAL_RX_PRE_PPDU_START                  = 226 /* 0xe2 */,
	HAL_RX_PREAMBLE                        = 227 /* 0xe3 */,
	HAL_TX_FES_SETUP_COMPLETE              = 228 /* 0xe4 */,
	HAL_TX_LAST_MPDU_FETCHED               = 229 /* 0xe5 */,
	HAL_TXDMA_STOP_REQUEST                 = 230 /* 0xe6 */,
	HAL_RXPCU_SETUP                        = 231 /* 0xe7 */,
	HAL_RXPCU_USER_SETUP                   = 232 /* 0xe8 */,
	HAL_TX_FES_STATUS_ACK_OR_BA            = 233 /* 0xe9 */,
	HAL_TQM_ACKED_MPDU                     = 234 /* 0xea */,
	HAL_COEX_TX_RESP                       = 235 /* 0xeb */,
	HAL_COEX_TX_STATUS                     = 236 /* 0xec */,
	HAL_MACTX_COEX_PHY_CTRL                = 237 /* 0xed */,
	HAL_COEX_STATUS_BROADCAST              = 238 /* 0xee */,
	HAL_RESPONSE_START_STATUS              = 239 /* 0xef */,
	HAL_RESPONSE_END_STATUS                = 240 /* 0xf0 */,
	HAL_CRYPTO_STATUS                      = 241 /* 0xf1 */,
	HAL_RECEIVED_TRIGGER_INFO              = 242 /* 0xf2 */,
	HAL_REO_ENTRANCE_RING                  = 243 /* 0xf3 */,
	HAL_RX_MPDU_LINK                       = 244 /* 0xf4 */,
	HAL_COEX_TX_STOP_CTRL                  = 245 /* 0xf5 */,
	HAL_RX_PPDU_ACK_REPORT                 = 246 /* 0xf6 */,
	HAL_RX_PPDU_NO_ACK_REPORT              = 247 /* 0xf7 */,
	HAL_SCH_COEX_STATUS                    = 248 /* 0xf8 */,
	HAL_SCHEDULER_COMMAND_STATUS           = 249 /* 0xf9 */,
	HAL_SCHEDULER_RX_PPDU_NO_RESPONSE_STATUS = 250 /* 0xfa */,
	HAL_TX_FES_STATUS_PROT                 = 251 /* 0xfb */,
	HAL_TX_FES_STATUS_START_PPDU           = 252 /* 0xfc */,
	HAL_TX_FES_STATUS_START_PROT           = 253 /* 0xfd */,
	HAL_TXPCU_PHYTX_DEBUG32                = 254 /* 0xfe */,
	HAL_TXPCU_PHYTX_OTHER_TRANSMIT_INFO32  = 255 /* 0xff */,
	HAL_TX_MPDU_COUNT_TRANSFER_END         = 256 /* 0x100 */,
	HAL_WHO_ANCHOR_OFFSET                  = 257 /* 0x101 */,
	HAL_WHO_ANCHOR_VALUE                   = 258 /* 0x102 */,
	HAL_WHO_CCE_INFO                       = 259 /* 0x103 */,
	HAL_WHO_COMMIT                         = 260 /* 0x104 */,
	HAL_WHO_COMMIT_DONE                    = 261 /* 0x105 */,
	HAL_WHO_FLUSH                          = 262 /* 0x106 */,
	HAL_WHO_L2_LLC                         = 263 /* 0x107 */,
	HAL_WHO_L2_PAYLOAD                     = 264 /* 0x108 */,
	HAL_WHO_L3_CHECKSUM                    = 265 /* 0x109 */,
	HAL_WHO_L3_INFO                        = 266 /* 0x10a */,
	HAL_WHO_L4_CHECKSUM                    = 267 /* 0x10b */,
	HAL_WHO_L4_INFO                        = 268 /* 0x10c */,
	HAL_WHO_MSDU                           = 269 /* 0x10d */,
	HAL_WHO_MSDU_MISC                      = 270 /* 0x10e */,
	HAL_WHO_PACKET_DATA                    = 271 /* 0x10f */,
	HAL_WHO_PACKET_HDR                     = 272 /* 0x110 */,
	HAL_WHO_PPDU_END                       = 273 /* 0x111 */,
	HAL_WHO_PPDU_START                     = 274 /* 0x112 */,
	HAL_WHO_TSO                            = 275 /* 0x113 */,
	HAL_WHO_WMAC_HEADER_PV0                = 276 /* 0x114 */,
	HAL_WHO_WMAC_HEADER_PV1                = 277 /* 0x115 */,
	HAL_WHO_WMAC_IV                        = 278 /* 0x116 */,
	HAL_MPDU_INFO_END                      = 279 /* 0x117 */,
	HAL_MPDU_INFO_BITMAP                   = 280 /* 0x118 */,
	HAL_TX_QUEUE_EXTENSION                 = 281 /* 0x119 */,
	HAL_RX_PEER_ENTRY_DETAILS              = 282 /* 0x11a */,
	HAL_RX_REO_QUEUE_REFERENCE             = 283 /* 0x11b */,
	HAL_RX_REO_QUEUE_EXT                   = 284 /* 0x11c */,
	HAL_SCHEDULER_SELFGEN_RESPONSE_STATUS  = 285 /* 0x11d */,
	HAL_TQM_UPDATE_TX_MPDU_COUNT_STATUS    = 286 /* 0x11e */,
	HAL_TQM_ACKED_MPDU_STATUS              = 287 /* 0x11f */,
	HAL_TQM_ADD_MSDU_STATUS                = 288 /* 0x120 */,
	HAL_RX_MPDU_LINK_PTR                   = 289 /* 0x121 */,
	HAL_REO_DESTINATION_RING               = 290 /* 0x122 */,
	HAL_TQM_LIST_GEN_DONE                  = 291 /* 0x123 */,
	HAL_WHO_TERMINATE                      = 292 /* 0x124 */,
	HAL_TX_LAST_MPDU_END                   = 293 /* 0x125 */,
	HAL_TX_CV_DATA                         = 294 /* 0x126 */,
	HAL_TCL_ENTRANCE_FROM_PPE_RING         = 295 /* 0x127 */,
	HAL_PPDU_TX_END                        = 296 /* 0x128 */,
	HAL_PROT_TX_END                        = 297 /* 0x129 */,
	HAL_PDG_RESPONSE_RATE_SETTING          = 298 /* 0x12a */,
	HAL_MPDU_INFO_GLOBAL_END               = 299 /* 0x12b */,
	HAL_TQM_SCH_INSTR_GLOBAL_END           = 300 /* 0x12c */,
	HAL_RX_PPDU_END_USER_STATS             = 301 /* 0x12d */,
	HAL_RX_PPDU_END_USER_STATS_EXT         = 302 /* 0x12e */,
	HAL_NO_ACK_REPORT                      = 303 /* 0x12f */,
	HAL_ACK_REPORT                         = 304 /* 0x130 */,
	HAL_UNIFORM_REO_CMD_HEADER             = 305 /* 0x131 */,
	HAL_REO_GET_QUEUE_STATS                = 306 /* 0x132 */,
	HAL_REO_FLUSH_QUEUE                    = 307 /* 0x133 */,
	HAL_REO_FLUSH_CACHE                    = 308 /* 0x134 */,
	HAL_REO_UNBLOCK_CACHE                  = 309 /* 0x135 */,
	HAL_UNIFORM_REO_STATUS_HEADER          = 310 /* 0x136 */,
	HAL_REO_GET_QUEUE_STATS_STATUS         = 311 /* 0x137 */,
	HAL_REO_FLUSH_QUEUE_STATUS             = 312 /* 0x138 */,
	HAL_REO_FLUSH_CACHE_STATUS             = 313 /* 0x139 */,
	HAL_REO_UNBLOCK_CACHE_STATUS           = 314 /* 0x13a */,
	HAL_TQM_FLUSH_CACHE                    = 315 /* 0x13b */,
	HAL_TQM_UNBLOCK_CACHE                  = 316 /* 0x13c */,
	HAL_TQM_FLUSH_CACHE_STATUS             = 317 /* 0x13d */,
	HAL_TQM_UNBLOCK_CACHE_STATUS           = 318 /* 0x13e */,
	HAL_RX_PPDU_END_STATUS_DONE            = 319 /* 0x13f */,
	HAL_RX_STATUS_BUFFER_DONE              = 320 /* 0x140 */,
	HAL_BUFFER_ADDR_INFO                   = 321 /* 0x141 */,
	HAL_RX_MSDU_DESC_INFO                  = 322 /* 0x142 */,
	HAL_RX_MPDU_DESC_INFO                  = 323 /* 0x143 */,
	HAL_TCL_DATA_CMD                       = 324 /* 0x144 */,
	HAL_TCL_GSE_CMD                        = 325 /* 0x145 */,
	HAL_TCL_EXIT_BASE                      = 326 /* 0x146 */,
	HAL_TCL_COMPACT_EXIT_RING              = 327 /* 0x147 */,
	HAL_TCL_REGULAR_EXIT_RING              = 328 /* 0x148 */,
	HAL_TCL_EXTENDED_EXIT_RING             = 329 /* 0x149 */,
	HAL_UPLINK_COMMON_INFO                 = 330 /* 0x14a */,
	HAL_UPLINK_USER_SETUP_INFO             = 331 /* 0x14b */,
	HAL_TX_DATA_SYNC                       = 332 /* 0x14c */,
	HAL_PHYRX_CBF_READ_REQUEST_ACK         = 333 /* 0x14d */,
	HAL_TCL_STATUS_RING                    = 334 /* 0x14e */,
	HAL_TQM_GET_MPDU_HEAD_INFO             = 335 /* 0x14f */,
	HAL_TQM_SYNC_CMD                       = 336 /* 0x150 */,
	HAL_TQM_GET_MPDU_HEAD_INFO_STATUS      = 337 /* 0x151 */,
	HAL_TQM_SYNC_CMD_STATUS                = 338 /* 0x152 */,
	HAL_TQM_THRESHOLD_DROP_NOTIFICATION_STATUS = 339 /* 0x153 */,
	HAL_TQM_DESCRIPTOR_THRESHOLD_REACHED_STATUS = 340 /* 0x154 */,
	HAL_REO_FLUSH_TIMEOUT_LIST             = 341 /* 0x155 */,
	HAL_REO_FLUSH_TIMEOUT_LIST_STATUS      = 342 /* 0x156 */,
	HAL_REO_TO_PPE_RING                    = 343 /* 0x157 */,
	HAL_RX_MPDU_INFO                       = 344 /* 0x158 */,
	HAL_REO_DESCRIPTOR_THRESHOLD_REACHED_STATUS = 345 /* 0x159 */,
	HAL_SCHEDULER_RX_SIFS_RESPONSE_TRIGGER_STATUS = 346 /* 0x15a */,
	HAL_EXAMPLE_USER_TLV_32_NAME           = 347 /* 0x15b */,
	HAL_RX_PPDU_START_USER_INFO            = 348 /* 0x15c */,
	HAL_RX_RXPCU_CLASSIFICATION_OVERVIEW   = 349 /* 0x15d */,
	HAL_RX_RING_MASK                       = 350 /* 0x15e */,
	HAL_WHO_CLASSIFY_INFO                  = 351 /* 0x15f */,
	HAL_TXPT_CLASSIFY_INFO                 = 352 /* 0x160 */,
	HAL_RXPT_CLASSIFY_INFO                 = 353 /* 0x161 */,
	HAL_TX_FLOW_SEARCH_ENTRY               = 354 /* 0x162 */,
	HAL_RX_FLOW_SEARCH_ENTRY               = 355 /* 0x163 */,
	HAL_RECEIVED_TRIGGER_INFO_DETAILS      = 356 /* 0x164 */,
	HAL_COEX_MAC_NAP                       = 357 /* 0x165 */,
	HAL_MACRX_ABORT_REQUEST_INFO           = 358 /* 0x166 */,
	HAL_MACTX_ABORT_REQUEST_INFO           = 359 /* 0x167 */,
	HAL_PHYRX_ABORT_REQUEST_INFO           = 360 /* 0x168 */,
	HAL_PHYTX_ABORT_REQUEST_INFO           = 361 /* 0x169 */,
	HAL_RXPCU_PPDU_END_INFO                = 362 /* 0x16a */,
	HAL_WHO_MESH_CONTROL                   = 363 /* 0x16b */,
	HAL_L_SIG_A_INFO                       = 364 /* 0x16c */,
	HAL_L_SIG_B_INFO                       = 365 /* 0x16d */,
	HAL_HT_SIG_INFO                        = 366 /* 0x16e */,
	HAL_VHT_SIG_A_INFO                     = 367 /* 0x16f */,
	HAL_VHT_SIG_B_SU20_INFO                = 368 /* 0x170 */,
	HAL_VHT_SIG_B_SU40_INFO                = 369 /* 0x171 */,
	HAL_VHT_SIG_B_SU80_INFO                = 370 /* 0x172 */,
	HAL_VHT_SIG_B_SU160_INFO               = 371 /* 0x173 */,
	HAL_VHT_SIG_B_MU20_INFO                = 372 /* 0x174 */,
	HAL_VHT_SIG_B_MU40_INFO                = 373 /* 0x175 */,
	HAL_VHT_SIG_B_MU80_INFO                = 374 /* 0x176 */,
	HAL_VHT_SIG_B_MU160_INFO               = 375 /* 0x177 */,
	HAL_SERVICE_INFO                       = 376 /* 0x178 */,
	HAL_HE_SIG_A_SU_INFO                   = 377 /* 0x179 */,
	HAL_HE_SIG_A_MU_DL_INFO                = 378 /* 0x17a */,
	HAL_HE_SIG_A_MU_UL_INFO                = 379 /* 0x17b */,
	HAL_HE_SIG_B1_MU_INFO                  = 380 /* 0x17c */,
	HAL_HE_SIG_B2_MU_INFO                  = 381 /* 0x17d */,
	HAL_HE_SIG_B2_OFDMA_INFO               = 382 /* 0x17e */,
	HAL_PDG_SW_MODE_BW_START               = 383 /* 0x17f */,
	HAL_PDG_SW_MODE_BW_END                 = 384 /* 0x180 */,
	HAL_PDG_WAIT_FOR_MAC_REQUEST           = 385 /* 0x181 */,
	HAL_PDG_WAIT_FOR_PHY_REQUEST           = 386 /* 0x182 */,
	HAL_SCHEDULER_END                      = 387 /* 0x183 */,
	HAL_PEER_TABLE_ENTRY                   = 388 /* 0x184 */,
	HAL_SW_PEER_INFO                       = 389 /* 0x185 */,
	HAL_RXOLE_CCE_CLASSIFY_INFO            = 390 /* 0x186 */,
	HAL_TCL_CCE_CLASSIFY_INFO              = 391 /* 0x187 */,
	HAL_RXOLE_CCE_INFO                     = 392 /* 0x188 */,
	HAL_TCL_CCE_INFO                       = 393 /* 0x189 */,
	HAL_TCL_CCE_SUPERRULE                  = 394 /* 0x18a */,
	HAL_CCE_RULE                           = 395 /* 0x18b */,
	HAL_RX_PPDU_START_DROPPED              = 396 /* 0x18c */,
	HAL_RX_PPDU_END_DROPPED                = 397 /* 0x18d */,
	HAL_RX_PPDU_END_STATUS_DONE_DROPPED    = 398 /* 0x18e */,
	HAL_RX_MPDU_START_DROPPED              = 399 /* 0x18f */,
	HAL_RX_MSDU_START_DROPPED              = 400 /* 0x190 */,
	HAL_RX_MSDU_END_DROPPED                = 401 /* 0x191 */,
	HAL_RX_MPDU_END_DROPPED                = 402 /* 0x192 */,
	HAL_RX_ATTENTION_DROPPED               = 403 /* 0x193 */,
	HAL_TXPCU_USER_SETUP                   = 404 /* 0x194 */,
	HAL_RXPCU_USER_SETUP_EXT               = 405 /* 0x195 */,
	HAL_CE_SRC_DESC                        = 406 /* 0x196 */,
	HAL_CE_STAT_DESC                       = 407 /* 0x197 */,
	HAL_RXOLE_CCE_SUPERRULE                = 408 /* 0x198 */,
	HAL_TX_RATE_STATS_INFO                 = 409 /* 0x199 */,
	HAL_CMD_PART_0_END                     = 410 /* 0x19a */,
	HAL_MACTX_SYNTH_ON                     = 411 /* 0x19b */,
	HAL_SCH_CRITICAL_TLV_REFERENCE         = 412 /* 0x19c */,
	HAL_TQM_MPDU_GLOBAL_START              = 413 /* 0x19d */,
	HAL_EXAMPLE_TLV_32                     = 414 /* 0x19e */,
	HAL_TQM_UPDATE_TX_MSDU_FLOW            = 415 /* 0x19f */,
	HAL_TQM_UPDATE_TX_MPDU_QUEUE_HEAD      = 416 /* 0x1a0 */,
	HAL_TQM_UPDATE_TX_MSDU_FLOW_STATUS     = 417 /* 0x1a1 */,
	HAL_TQM_UPDATE_TX_MPDU_QUEUE_HEAD_STATUS = 418 /* 0x1a2 */,
	HAL_REO_UPDATE_RX_REO_QUEUE            = 419 /* 0x1a3 */,
	HAL_CE_DST_DESC			       = 420 /* 0x1a4 */,
	HAL_TLV_BASE                           = 511 /* 0x1ff */,
};

#define HAL_TLV_HDR_TAG		GENMASK(9, 1)
#define HAL_TLV_HDR_LEN		GENMASK(25, 10)
#define HAL_TLV_USR_ID		GENMASK(31, 26)

#define HAL_TLV_ALIGN	4

struct hal_tlv_hdr {
	uint32_t tl;
	uint8_t value[];
} __packed;

#define RX_MPDU_DESC_INFO0_MSDU_COUNT		0xff
#define RX_MPDU_DESC_INFO0_SEQ_NUM		0xfff00
#define RX_MPDU_DESC_INFO0_FRAG_FLAG		(1 << 20)
#define RX_MPDU_DESC_INFO0_MPDU_RETRY		(1 << 21)
#define RX_MPDU_DESC_INFO0_AMPDU_FLAG		(1 << 22)
#define RX_MPDU_DESC_INFO0_BAR_FRAME		(1 << 23)
#define RX_MPDU_DESC_INFO0_VALID_PN		(1 << 24)
#define RX_MPDU_DESC_INFO0_VALID_SA		(1 << 25)
#define RX_MPDU_DESC_INFO0_SA_IDX_TIMEOUT	(1 << 26)
#define RX_MPDU_DESC_INFO0_VALID_DA		(1 << 27)
#define RX_MPDU_DESC_INFO0_DA_MCBC		(1 << 28)
#define RX_MPDU_DESC_INFO0_DA_IDX_TIMEOUT	(1 << 29)
#define RX_MPDU_DESC_INFO0_RAW_MPDU		(1 << 30)

#define RX_MPDU_DESC_META_DATA_PEER_ID		0xffff

struct rx_mpdu_desc {
	uint32_t info0; /* %RX_MPDU_DESC_INFO */
	uint32_t meta_data;
} __packed;

/* rx_mpdu_desc
 *		Producer: RXDMA
 *		Consumer: REO/SW/FW
 *
 * msdu_count
 *		The number of MSDUs within the MPDU
 *
 * mpdu_sequence_number
 *		The field can have two different meanings based on the setting
 *		of field 'bar_frame'. If 'bar_frame' is set, it means the MPDU
 *		start sequence number from the BAR frame otherwise it means
 *		the MPDU sequence number of the received frame.
 *
 * fragment_flag
 *		When set, this MPDU is a fragment and REO should forward this
 *		fragment MPDU to the REO destination ring without any reorder
 *		checks, pn checks or bitmap update. This implies that REO is
 *		forwarding the pointer to the MSDU link descriptor.
 *
 * mpdu_retry_bit
 *		The retry bit setting from the MPDU header of the received frame
 *
 * ampdu_flag
 *		Indicates the MPDU was received as part of an A-MPDU.
 *
 * bar_frame
 *		Indicates the received frame is a BAR frame. After processing,
 *		this frame shall be pushed to SW or deleted.
 *
 * valid_pn
 *		When not set, REO will not perform a PN sequence number check.
 *
 * valid_sa
 *		Indicates OLE found a valid SA entry for all MSDUs in this MPDU.
 *
 * sa_idx_timeout
 *		Indicates, at least 1 MSDU within the MPDU has an unsuccessful
 *		MAC source address search due to the expiration of search timer.
 *
 * valid_da
 *		When set, OLE found a valid DA entry for all MSDUs in this MPDU.
 *
 * da_mcbc
 *		Field Only valid if valid_da is set. Indicates at least one of
 *		the DA addresses is a Multicast or Broadcast address.
 *
 * da_idx_timeout
 *		Indicates, at least 1 MSDU within the MPDU has an unsuccessful
 *		MAC destination address search due to the expiration of search
 *		timer.
 *
 * raw_mpdu
 *		Field only valid when first_msdu_in_mpdu_flag is set. Indicates
 *		the contents in the MSDU buffer contains a 'RAW' MPDU.
 */

enum hal_rx_msdu_desc_reo_dest_ind {
	HAL_RX_MSDU_DESC_REO_DEST_IND_TCL,
	HAL_RX_MSDU_DESC_REO_DEST_IND_SW1,
	HAL_RX_MSDU_DESC_REO_DEST_IND_SW2,
	HAL_RX_MSDU_DESC_REO_DEST_IND_SW3,
	HAL_RX_MSDU_DESC_REO_DEST_IND_SW4,
	HAL_RX_MSDU_DESC_REO_DEST_IND_RELEASE,
	HAL_RX_MSDU_DESC_REO_DEST_IND_FW,
};

#define RX_MSDU_DESC_INFO0_FIRST_MSDU_IN_MPDU	(1 << 0)
#define RX_MSDU_DESC_INFO0_LAST_MSDU_IN_MPDU	(1 << 1)
#define RX_MSDU_DESC_INFO0_MSDU_CONTINUATION	(1 << 2)
#define RX_MSDU_DESC_INFO0_MSDU_LENGTH		GENMASK(16, 3)
#define RX_MSDU_DESC_INFO0_REO_DEST_IND		GENMASK(21, 17)
#define RX_MSDU_DESC_INFO0_MSDU_DROP		(1 << 22)
#define RX_MSDU_DESC_INFO0_VALID_SA		(1 << 23)
#define RX_MSDU_DESC_INFO0_SA_IDX_TIMEOUT	(1 << 24)
#define RX_MSDU_DESC_INFO0_VALID_DA		(1 << 25)
#define RX_MSDU_DESC_INFO0_DA_MCBC		(1 << 26)
#define RX_MSDU_DESC_INFO0_DA_IDX_TIMEOUT	(1 << 27)

#define HAL_RX_MSDU_PKT_LENGTH_GET(val)		\
	(FIELD_GET(RX_MSDU_DESC_INFO0_MSDU_LENGTH, (val)))

struct rx_msdu_desc {
	uint32_t info0;
	uint32_t rsvd0;
} __packed;

/* rx_msdu_desc
 *
 * first_msdu_in_mpdu
 *		Indicates first msdu in mpdu.
 *
 * last_msdu_in_mpdu
 *		Indicates last msdu in mpdu. This flag can be true only when
 *		'Msdu_continuation' set to 0. This implies that when an msdu
 *		is spread out over multiple buffers and thus msdu_continuation
 *		is set, only for the very last buffer of the msdu, can the
 *		'last_msdu_in_mpdu' be set.
 *
 *		When both first_msdu_in_mpdu and last_msdu_in_mpdu are set,
 *		the MPDU that this MSDU belongs to only contains a single MSDU.
 *
 * msdu_continuation
 *		When set, this MSDU buffer was not able to hold the entire MSDU.
 *		The next buffer will therefore contain additional information
 *		related to this MSDU.
 *
 * msdu_length
 *		Field is only valid in combination with the 'first_msdu_in_mpdu'
 *		being set. Full MSDU length in bytes after decapsulation. This
 *		field is still valid for MPDU frames without A-MSDU. It still
 *		represents MSDU length after decapsulation Or in case of RAW
 *		MPDUs, it indicates the length of the entire MPDU (without FCS
 *		field).
 *
 * reo_destination_indication
 *		The id of the reo exit ring where the msdu frame shall push
 *		after (MPDU level) reordering has finished. Values are defined
 *		in enum %HAL_RX_MSDU_DESC_REO_DEST_IND_.
 *
 * msdu_drop
 *		Indicates that REO shall drop this MSDU and not forward it to
 *		any other ring.
 *
 * valid_sa
 *		Indicates OLE found a valid SA entry for this MSDU.
 *
 * sa_idx_timeout
 *		Indicates, an unsuccessful MAC source address search due to
 *		the expiration of search timer for this MSDU.
 *
 * valid_da
 *		When set, OLE found a valid DA entry for this MSDU.
 *
 * da_mcbc
 *		Field Only valid if valid_da is set. Indicates the DA address
 *		is a Multicast or Broadcast address for this MSDU.
 *
 * da_idx_timeout
 *		Indicates, an unsuccessful MAC destination address search due
 *		to the expiration of search timer for this MSDU.
 */

enum hal_reo_dest_ring_buffer_type {
	HAL_REO_DEST_RING_BUFFER_TYPE_MSDU,
	HAL_REO_DEST_RING_BUFFER_TYPE_LINK_DESC,
};

enum hal_reo_dest_ring_push_reason {
	HAL_REO_DEST_RING_PUSH_REASON_ERR_DETECTED,
	HAL_REO_DEST_RING_PUSH_REASON_ROUTING_INSTRUCTION,
};

enum hal_reo_dest_ring_error_code {
	HAL_REO_DEST_RING_ERROR_CODE_DESC_ADDR_ZERO,
	HAL_REO_DEST_RING_ERROR_CODE_DESC_INVALID,
	HAL_REO_DEST_RING_ERROR_CODE_AMPDU_IN_NON_BA,
	HAL_REO_DEST_RING_ERROR_CODE_NON_BA_DUPLICATE,
	HAL_REO_DEST_RING_ERROR_CODE_BA_DUPLICATE,
	HAL_REO_DEST_RING_ERROR_CODE_FRAME_2K_JUMP,
	HAL_REO_DEST_RING_ERROR_CODE_BAR_2K_JUMP,
	HAL_REO_DEST_RING_ERROR_CODE_FRAME_OOR,
	HAL_REO_DEST_RING_ERROR_CODE_BAR_OOR,
	HAL_REO_DEST_RING_ERROR_CODE_NO_BA_SESSION,
	HAL_REO_DEST_RING_ERROR_CODE_FRAME_SN_EQUALS_SSN,
	HAL_REO_DEST_RING_ERROR_CODE_PN_CHECK_FAILED,
	HAL_REO_DEST_RING_ERROR_CODE_2K_ERR_FLAG_SET,
	HAL_REO_DEST_RING_ERROR_CODE_PN_ERR_FLAG_SET,
	HAL_REO_DEST_RING_ERROR_CODE_DESC_BLOCKED,
	HAL_REO_DEST_RING_ERROR_CODE_MAX,
};

#define HAL_REO_DEST_RING_INFO0_QUEUE_ADDR_HI		GENMASK(7, 0)
#define HAL_REO_DEST_RING_INFO0_BUFFER_TYPE		(1 << 8)
#define HAL_REO_DEST_RING_INFO0_PUSH_REASON		GENMASK(10, 9)
#define HAL_REO_DEST_RING_INFO0_ERROR_CODE		GENMASK(15, 11)
#define HAL_REO_DEST_RING_INFO0_RX_QUEUE_NUM		GENMASK(31, 16)

#define HAL_REO_DEST_RING_INFO1_REORDER_INFO_VALID	(1 << 0)
#define HAL_REO_DEST_RING_INFO1_REORDER_OPCODE		GENMASK(4, 1)
#define HAL_REO_DEST_RING_INFO1_REORDER_SLOT_IDX	GENMASK(12, 5)

#define HAL_REO_DEST_RING_INFO2_RING_ID			GENMASK(27, 20)
#define HAL_REO_DEST_RING_INFO2_LOOPING_COUNT		GENMASK(31, 28)

struct hal_reo_dest_ring {
	struct ath11k_buffer_addr buf_addr_info;
	struct rx_mpdu_desc rx_mpdu_info;
	struct rx_msdu_desc rx_msdu_info;
	uint32_t queue_addr_lo;
	uint32_t info0; /* %HAL_REO_DEST_RING_INFO0_ */
	uint32_t info1; /* %HAL_REO_DEST_RING_INFO1_ */
	uint32_t rsvd0;
	uint32_t rsvd1;
	uint32_t rsvd2;
	uint32_t rsvd3;
	uint32_t rsvd4;
	uint32_t rsvd5;
	uint32_t info2; /* %HAL_REO_DEST_RING_INFO2_ */
} __packed;

/* hal_reo_dest_ring
 *
 *		Producer: RXDMA
 *		Consumer: REO/SW/FW
 *
 * buf_addr_info
 *		Details of the physical address of a buffer or MSDU
 *		link descriptor.
 *
 * rx_mpdu_info
 *		General information related to the MPDU that is passed
 *		on from REO entrance ring to the REO destination ring.
 *
 * rx_msdu_info
 *		General information related to the MSDU that is passed
 *		on from RXDMA all the way to the REO destination ring.
 *
 * queue_addr_lo
 *		Address (lower 32 bits) of the REO queue descriptor.
 *
 * queue_addr_hi
 *		Address (upper 8 bits) of the REO queue descriptor.
 *
 * buffer_type
 *		Indicates the type of address provided in the buf_addr_info.
 *		Values are defined in enum %HAL_REO_DEST_RING_BUFFER_TYPE_.
 *
 * push_reason
 *		Reason for pushing this frame to this exit ring. Values are
 *		defined in enum %HAL_REO_DEST_RING_PUSH_REASON_.
 *
 * error_code
 *		Valid only when 'push_reason' is set. All error codes are
 *		defined in enum %HAL_REO_DEST_RING_ERROR_CODE_.
 *
 * rx_queue_num
 *		Indicates the REO MPDU reorder queue id from which this frame
 *		originated.
 *
 * reorder_info_valid
 *		When set, REO has been instructed to not perform the actual
 *		re-ordering of frames for this queue, but just to insert
 *		the reorder opcodes.
 *
 * reorder_opcode
 *		Field is valid when 'reorder_info_valid' is set. This field is
 *		always valid for debug purpose as well.
 *
 * reorder_slot_idx
 *		Valid only when 'reorder_info_valid' is set.
 *
 * ring_id
 *		The buffer pointer ring id.
 *		0 - Idle ring
 *		1 - N refers to other rings.
 *
 * looping_count
 *		Indicates the number of times the producer of entries into
 *		this ring has looped around the ring.
 */

enum hal_reo_entr_rxdma_ecode {
	HAL_REO_ENTR_RING_RXDMA_ECODE_OVERFLOW_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_MPDU_LEN_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_FCS_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_DECRYPT_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_TKIP_MIC_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_UNECRYPTED_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_MSDU_LEN_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_MSDU_LIMIT_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_WIFI_PARSE_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_AMSDU_PARSE_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_SA_TIMEOUT_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_DA_TIMEOUT_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_FLOW_TIMEOUT_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_FLUSH_REQUEST_ERR,
	HAL_REO_ENTR_RING_RXDMA_ECODE_MAX,
};

#define HAL_REO_ENTR_RING_INFO0_QUEUE_ADDR_HI		GENMASK(7, 0)
#define HAL_REO_ENTR_RING_INFO0_MPDU_BYTE_COUNT		GENMASK(21, 8)
#define HAL_REO_ENTR_RING_INFO0_DEST_IND		GENMASK(26, 22)
#define HAL_REO_ENTR_RING_INFO0_FRAMELESS_BAR		BIT(27)

#define HAL_REO_ENTR_RING_INFO1_RXDMA_PUSH_REASON	GENMASK(1, 0)
#define HAL_REO_ENTR_RING_INFO1_RXDMA_ERROR_CODE	GENMASK(6, 2)

struct hal_reo_entrance_ring {
	struct ath11k_buffer_addr buf_addr_info;
	struct rx_mpdu_desc rx_mpdu_info;
	uint32_t queue_addr_lo;
	uint32_t info0; /* %HAL_REO_ENTR_RING_INFO0_ */
	uint32_t info1; /* %HAL_REO_ENTR_RING_INFO1_ */
	uint32_t info2; /* %HAL_REO_DEST_RING_INFO2_ */

} __packed;

/* hal_reo_entrance_ring
 *
 *		Producer: RXDMA
 *		Consumer: REO
 *
 * buf_addr_info
 *		Details of the physical address of a buffer or MSDU
 *		link descriptor.
 *
 * rx_mpdu_info
 *		General information related to the MPDU that is passed
 *		on from REO entrance ring to the REO destination ring.
 *
 * queue_addr_lo
 *		Address (lower 32 bits) of the REO queue descriptor.
 *
 * queue_addr_hi
 *		Address (upper 8 bits) of the REO queue descriptor.
 *
 * mpdu_byte_count
 *		An approximation of the number of bytes received in this MPDU.
 *		Used to keeps stats on the amount of data flowing
 *		through a queue.
 *
 * reo_destination_indication
 *		The id of the reo exit ring where the msdu frame shall push
 *		after (MPDU level) reordering has finished. Values are defined
 *		in enum %HAL_RX_MSDU_DESC_REO_DEST_IND_.
 *
 * frameless_bar
 *		Indicates that this REO entrance ring struct contains BAR info
 *		from a multi TID BAR frame. The original multi TID BAR frame
 *		itself contained all the REO info for the first TID, but all
 *		the subsequent TID info and their linkage to the REO descriptors
 *		is passed down as 'frameless' BAR info.
 *
 *		The only fields valid in this descriptor when this bit is set
 *		are queue_addr_lo, queue_addr_hi, mpdu_sequence_number,
 *		bar_frame and peer_meta_data.
 *
 * rxdma_push_reason
 *		Reason for pushing this frame to this exit ring. Values are
 *		defined in enum %HAL_REO_DEST_RING_PUSH_REASON_.
 *
 * rxdma_error_code
 *		Valid only when 'push_reason' is set. All error codes are
 *		defined in enum %HAL_REO_ENTR_RING_RXDMA_ECODE_.
 *
 * ring_id
 *		The buffer pointer ring id.
 *		0 - Idle ring
 *		1 - N refers to other rings.
 *
 * looping_count
 *		Indicates the number of times the producer of entries into
 *		this ring has looped around the ring.
 */

#define HAL_SW_MON_RING_INFO0_RXDMA_PUSH_REASON	GENMASK(1, 0)
#define HAL_SW_MON_RING_INFO0_RXDMA_ERROR_CODE	GENMASK(6, 2)
#define HAL_SW_MON_RING_INFO0_MPDU_FRAG_NUMBER	GENMASK(10, 7)
#define HAL_SW_MON_RING_INFO0_FRAMELESS_BAR	BIT(11)
#define HAL_SW_MON_RING_INFO0_STATUS_BUF_CNT	GENMASK(15, 12)
#define HAL_SW_MON_RING_INFO0_END_OF_PPDU	BIT(16)

#define HAL_SW_MON_RING_INFO1_PHY_PPDU_ID	GENMASK(15, 0)
#define HAL_SW_MON_RING_INFO1_RING_ID		GENMASK(27, 20)
#define HAL_SW_MON_RING_INFO1_LOOPING_COUNT	GENMASK(31, 28)

struct hal_sw_monitor_ring {
	struct ath11k_buffer_addr buf_addr_info;
	struct rx_mpdu_desc rx_mpdu_info;
	struct ath11k_buffer_addr status_buf_addr_info;
	uint32_t info0;
	uint32_t info1;
} __packed;

#define HAL_REO_CMD_HDR_INFO0_CMD_NUMBER	GENMASK(15, 0)
#define HAL_REO_CMD_HDR_INFO0_STATUS_REQUIRED	BIT(16)

struct hal_reo_cmd_hdr {
	uint32_t info0;
} __packed;


#define HAL_SRNG_DESC_LOOP_CNT		0xf0000000

#define HAL_REO_CMD_FLG_NEED_STATUS		BIT(0)
#define HAL_REO_CMD_FLG_STATS_CLEAR		BIT(1)
#define HAL_REO_CMD_FLG_FLUSH_BLOCK_LATER	BIT(2)
#define HAL_REO_CMD_FLG_FLUSH_RELEASE_BLOCKING	BIT(3)
#define HAL_REO_CMD_FLG_FLUSH_NO_INVAL		BIT(4)
#define HAL_REO_CMD_FLG_FLUSH_FWD_ALL_MPDUS	BIT(5)
#define HAL_REO_CMD_FLG_FLUSH_ALL		BIT(6)
#define HAL_REO_CMD_FLG_UNBLK_RESOURCE		BIT(7)
#define HAL_REO_CMD_FLG_UNBLK_CACHE		BIT(8)

/* Should be matching with HAL_REO_UPD_RX_QUEUE_INFO0_UPD_* fields */
#define HAL_REO_CMD_UPD0_RX_QUEUE_NUM		BIT(8)
#define HAL_REO_CMD_UPD0_VLD			BIT(9)
#define HAL_REO_CMD_UPD0_ALDC			BIT(10)
#define HAL_REO_CMD_UPD0_DIS_DUP_DETECTION	BIT(11)
#define HAL_REO_CMD_UPD0_SOFT_REORDER_EN	BIT(12)
#define HAL_REO_CMD_UPD0_AC			BIT(13)
#define HAL_REO_CMD_UPD0_BAR			BIT(14)
#define HAL_REO_CMD_UPD0_RETRY			BIT(15)
#define HAL_REO_CMD_UPD0_CHECK_2K_MODE		BIT(16)
#define HAL_REO_CMD_UPD0_OOR_MODE		BIT(17)
#define HAL_REO_CMD_UPD0_BA_WINDOW_SIZE		BIT(18)
#define HAL_REO_CMD_UPD0_PN_CHECK		BIT(19)
#define HAL_REO_CMD_UPD0_EVEN_PN		BIT(20)
#define HAL_REO_CMD_UPD0_UNEVEN_PN		BIT(21)
#define HAL_REO_CMD_UPD0_PN_HANDLE_ENABLE	BIT(22)
#define HAL_REO_CMD_UPD0_PN_SIZE		BIT(23)
#define HAL_REO_CMD_UPD0_IGNORE_AMPDU_FLG	BIT(24)
#define HAL_REO_CMD_UPD0_SVLD			BIT(25)
#define HAL_REO_CMD_UPD0_SSN			BIT(26)
#define HAL_REO_CMD_UPD0_SEQ_2K_ERR		BIT(27)
#define HAL_REO_CMD_UPD0_PN_ERR			BIT(28)
#define HAL_REO_CMD_UPD0_PN_VALID		BIT(29)
#define HAL_REO_CMD_UPD0_PN			BIT(30)

/* Should be matching with HAL_REO_UPD_RX_QUEUE_INFO1_* fields */
#define HAL_REO_CMD_UPD1_VLD			BIT(16)
#define HAL_REO_CMD_UPD1_ALDC			GENMASK(18, 17)
#define HAL_REO_CMD_UPD1_DIS_DUP_DETECTION	BIT(19)
#define HAL_REO_CMD_UPD1_SOFT_REORDER_EN	BIT(20)
#define HAL_REO_CMD_UPD1_AC			GENMASK(22, 21)
#define HAL_REO_CMD_UPD1_BAR			BIT(23)
#define HAL_REO_CMD_UPD1_RETRY			BIT(24)
#define HAL_REO_CMD_UPD1_CHECK_2K_MODE		BIT(25)
#define HAL_REO_CMD_UPD1_OOR_MODE		BIT(26)
#define HAL_REO_CMD_UPD1_PN_CHECK		BIT(27)
#define HAL_REO_CMD_UPD1_EVEN_PN		BIT(28)
#define HAL_REO_CMD_UPD1_UNEVEN_PN		BIT(29)
#define HAL_REO_CMD_UPD1_PN_HANDLE_ENABLE	BIT(30)
#define HAL_REO_CMD_UPD1_IGNORE_AMPDU_FLG	BIT(31)

/* Should be matching with HAL_REO_UPD_RX_QUEUE_INFO2_* fields */
#define HAL_REO_CMD_UPD2_SVLD			BIT(10)
#define HAL_REO_CMD_UPD2_SSN			GENMASK(22, 11)
#define HAL_REO_CMD_UPD2_SEQ_2K_ERR		BIT(23)
#define HAL_REO_CMD_UPD2_PN_ERR			BIT(24)

#define HAL_REO_DEST_RING_CTRL_HASH_RING_MAP	GENMASK(31, 8)

struct ath11k_hal_reo_cmd {
	uint32_t addr_lo;
	uint32_t flag;
	uint32_t upd0;
	uint32_t upd1;
	uint32_t upd2;
	uint32_t pn[4];
	uint16_t rx_queue_num;
	uint16_t min_rel;
	uint16_t min_fwd;
	uint8_t addr_hi;
	uint8_t ac_list;
	uint8_t blocking_idx;
	uint16_t ba_window_size;
	uint8_t pn_size;
};

#define HAL_REO_GET_QUEUE_STATS_INFO0_QUEUE_ADDR_HI	GENMASK(7, 0)
#define HAL_REO_GET_QUEUE_STATS_INFO0_CLEAR_STATS	BIT(8)

struct hal_reo_get_queue_stats {
	struct hal_reo_cmd_hdr cmd;
	uint32_t queue_addr_lo;
	uint32_t info0;
	uint32_t rsvd0[6];
} __packed;

/* hal_reo_get_queue_stats
 *		Producer: SW
 *		Consumer: REO
 *
 * cmd
 *		Details for command execution tracking purposes.
 *
 * queue_addr_lo
 *		Address (lower 32 bits) of the REO queue descriptor.
 *
 * queue_addr_hi
 *		Address (upper 8 bits) of the REO queue descriptor.
 *
 * clear_stats
 *		Clear stats settings. When set, Clear the stats after
 *		generating the status.
 *
 *		Following stats will be cleared.
 *		Timeout_count
 *		Forward_due_to_bar_count
 *		Duplicate_count
 *		Frames_in_order_count
 *		BAR_received_count
 *		MPDU_Frames_processed_count
 *		MSDU_Frames_processed_count
 *		Total_processed_byte_count
 *		Late_receive_MPDU_count
 *		window_jump_2k
 *		Hole_count
 */

#define HAL_REO_FLUSH_QUEUE_INFO0_DESC_ADDR_HI		GENMASK(7, 0)
#define HAL_REO_FLUSH_QUEUE_INFO0_BLOCK_DESC_ADDR	BIT(8)
#define HAL_REO_FLUSH_QUEUE_INFO0_BLOCK_RESRC_IDX	GENMASK(10, 9)

struct hal_reo_flush_queue {
	struct hal_reo_cmd_hdr cmd;
	uint32_t desc_addr_lo;
	uint32_t info0;
	uint32_t rsvd0[6];
} __packed;

#define HAL_REO_FLUSH_CACHE_INFO0_CACHE_ADDR_HI		GENMASK(7, 0)
#define HAL_REO_FLUSH_CACHE_INFO0_FWD_ALL_MPDUS		BIT(8)
#define HAL_REO_FLUSH_CACHE_INFO0_RELEASE_BLOCK_IDX	BIT(9)
#define HAL_REO_FLUSH_CACHE_INFO0_BLOCK_RESRC_IDX	GENMASK(11, 10)
#define HAL_REO_FLUSH_CACHE_INFO0_FLUSH_WO_INVALIDATE	BIT(12)
#define HAL_REO_FLUSH_CACHE_INFO0_BLOCK_CACHE_USAGE	BIT(13)
#define HAL_REO_FLUSH_CACHE_INFO0_FLUSH_ALL		BIT(14)

struct hal_reo_flush_cache {
	struct hal_reo_cmd_hdr cmd;
	uint32_t cache_addr_lo;
	uint32_t info0;
	uint32_t rsvd0[6];
} __packed;

#define HAL_TCL_DATA_CMD_INFO0_DESC_TYPE	BIT(0)
#define HAL_TCL_DATA_CMD_INFO0_EPD		BIT(1)
#define HAL_TCL_DATA_CMD_INFO0_ENCAP_TYPE	GENMASK(3, 2)
#define HAL_TCL_DATA_CMD_INFO0_ENCRYPT_TYPE	GENMASK(7, 4)
#define HAL_TCL_DATA_CMD_INFO0_SRC_BUF_SWAP	BIT(8)
#define HAL_TCL_DATA_CMD_INFO0_LNK_META_SWAP	BIT(9)
#define HAL_TCL_DATA_CMD_INFO0_SEARCH_TYPE	GENMASK(13, 12)
#define HAL_TCL_DATA_CMD_INFO0_ADDR_EN		GENMASK(15, 14)
#define HAL_TCL_DATA_CMD_INFO0_CMD_NUM		GENMASK(31, 16)

#define HAL_TCL_DATA_CMD_INFO1_DATA_LEN		GENMASK(15, 0)
#define HAL_TCL_DATA_CMD_INFO1_IP4_CKSUM_EN	BIT(16)
#define HAL_TCL_DATA_CMD_INFO1_UDP4_CKSUM_EN	BIT(17)
#define HAL_TCL_DATA_CMD_INFO1_UDP6_CKSUM_EN	BIT(18)
#define HAL_TCL_DATA_CMD_INFO1_TCP4_CKSUM_EN	BIT(19)
#define HAL_TCL_DATA_CMD_INFO1_TCP6_CKSUM_EN	BIT(20)
#define HAL_TCL_DATA_CMD_INFO1_TO_FW		BIT(21)
#define HAL_TCL_DATA_CMD_INFO1_PKT_OFFSET	GENMASK(31, 23)

#define HAL_TCL_DATA_CMD_INFO2_BUF_TIMESTAMP		GENMASK(18, 0)
#define HAL_TCL_DATA_CMD_INFO2_BUF_T_VALID		BIT(19)
#define HAL_IPQ8074_TCL_DATA_CMD_INFO2_MESH_ENABLE	BIT(20)
#define HAL_TCL_DATA_CMD_INFO2_TID_OVERWRITE		BIT(21)
#define HAL_TCL_DATA_CMD_INFO2_TID			GENMASK(25, 22)
#define HAL_TCL_DATA_CMD_INFO2_LMAC_ID			GENMASK(27, 26)

#define HAL_TCL_DATA_CMD_INFO3_DSCP_TID_TABLE_IDX	GENMASK(5, 0)
#define HAL_TCL_DATA_CMD_INFO3_SEARCH_INDEX		GENMASK(25, 6)
#define HAL_TCL_DATA_CMD_INFO3_CACHE_SET_NUM		GENMASK(29, 26)
#define HAL_QCN9074_TCL_DATA_CMD_INFO3_MESH_ENABLE	GENMASK(31, 30)

#define HAL_TCL_DATA_CMD_INFO4_RING_ID			GENMASK(27, 20)
#define HAL_TCL_DATA_CMD_INFO4_LOOPING_COUNT		GENMASK(31, 28)

enum hal_encrypt_type {
	HAL_ENCRYPT_TYPE_WEP_40,
	HAL_ENCRYPT_TYPE_WEP_104,
	HAL_ENCRYPT_TYPE_TKIP_NO_MIC,
	HAL_ENCRYPT_TYPE_WEP_128,
	HAL_ENCRYPT_TYPE_TKIP_MIC,
	HAL_ENCRYPT_TYPE_WAPI,
	HAL_ENCRYPT_TYPE_CCMP_128,
	HAL_ENCRYPT_TYPE_OPEN,
	HAL_ENCRYPT_TYPE_CCMP_256,
	HAL_ENCRYPT_TYPE_GCMP_128,
	HAL_ENCRYPT_TYPE_AES_GCMP_256,
	HAL_ENCRYPT_TYPE_WAPI_GCM_SM4,
};

enum hal_tcl_encap_type {
	HAL_TCL_ENCAP_TYPE_RAW,
	HAL_TCL_ENCAP_TYPE_NATIVE_WIFI,
	HAL_TCL_ENCAP_TYPE_ETHERNET,
	HAL_TCL_ENCAP_TYPE_802_3 = 3,
};

enum hal_tcl_desc_type {
	HAL_TCL_DESC_TYPE_BUFFER,
	HAL_TCL_DESC_TYPE_EXT_DESC,
};

enum hal_wbm_htt_tx_comp_status {
	HAL_WBM_REL_HTT_TX_COMP_STATUS_OK,
	HAL_WBM_REL_HTT_TX_COMP_STATUS_DROP,
	HAL_WBM_REL_HTT_TX_COMP_STATUS_TTL,
	HAL_WBM_REL_HTT_TX_COMP_STATUS_REINJ,
	HAL_WBM_REL_HTT_TX_COMP_STATUS_INSPECT,
	HAL_WBM_REL_HTT_TX_COMP_STATUS_MEC_NOTIFY,
};

struct hal_tcl_data_cmd {
	struct ath11k_buffer_addr buf_addr_info;
	uint32_t info0;
	uint32_t info1;
	uint32_t info2;
	uint32_t info3;
	uint32_t info4;
} __packed;

/* hal_tcl_data_cmd
 *
 * buf_addr_info
 *		Details of the physical address of a buffer or MSDU
 *		link descriptor.
 *
 * desc_type
 *		Indicates the type of address provided in the buf_addr_info.
 *		Values are defined in enum %HAL_REO_DEST_RING_BUFFER_TYPE_.
 *
 * epd
 *		When this bit is set then input packet is an EPD type.
 *
 * encap_type
 *		Indicates the encapsulation that HW will perform. Values are
 *		defined in enum %HAL_TCL_ENCAP_TYPE_.
 *
 * encrypt_type
 *		Field only valid for encap_type: RAW
 *		Values are defined in enum %HAL_ENCRYPT_TYPE_.
 *
 * src_buffer_swap
 *		Treats source memory (packet buffer) organization as big-endian.
 *		1'b0: Source memory is little endian
 *		1'b1: Source memory is big endian
 *
 * link_meta_swap
 *		Treats link descriptor and Metadata as big-endian.
 *		1'b0: memory is little endian
 *		1'b1: memory is big endian
 *
 * search_type
 *		Search type select
 *		0 - Normal search, 1 - Index based address search,
 *		2 - Index based flow search
 *
 * addrx_en
 * addry_en
 *		Address X/Y search enable in ASE correspondingly.
 *		1'b0: Search disable
 *		1'b1: Search Enable
 *
 * cmd_num
 *		This number can be used to match against status.
 *
 * data_length
 *		MSDU length in case of direct descriptor. Length of link
 *		extension descriptor in case of Link extension descriptor.
 *
 * *_checksum_en
 *		Enable checksum replacement for ipv4, udp_over_ipv4, ipv6,
 *		udp_over_ipv6, tcp_over_ipv4 and tcp_over_ipv6.
 *
 * to_fw
 *		Forward packet to FW along with classification result. The
 *		packet will not be forward to TQM when this bit is set.
 *		1'b0: Use classification result to forward the packet.
 *		1'b1: Override classification result & forward packet only to fw
 *
 * packet_offset
 *		Packet offset from Metadata in case of direct buffer descriptor.
 *
 * buffer_timestamp
 * buffer_timestamp_valid
 *		Frame system entrance timestamp. It shall be filled by first
 *		module (SW, TCL or TQM) that sees the frames first.
 *
 * mesh_enable
 *		For raw WiFi frames, this indicates transmission to a mesh STA,
 *		enabling the interpretation of the 'Mesh Control Present' bit
 *		(bit 8) of QoS Control.
 *		For native WiFi frames, this indicates that a 'Mesh Control'
 *		field is present between the header and the LLC.
 *
 * hlos_tid_overwrite
 *
 *		When set, TCL shall ignore the IP DSCP and VLAN PCP
 *		fields and use HLOS_TID as the final TID. Otherwise TCL
 *		shall consider the DSCP and PCP fields as well as HLOS_TID
 *		and choose a final TID based on the configured priority
 *
 * hlos_tid
 *		HLOS MSDU priority
 *		Field is used when HLOS_TID_overwrite is set.
 *
 * lmac_id
 *		TCL uses this LMAC_ID in address search, i.e, while
 *		finding matching entry for the packet in AST corresponding
 *		to given LMAC_ID
 *
 *		If LMAC ID is all 1s (=> value 3), it indicates wildcard
 *		match for any MAC
 *
 * dscp_tid_table_num
 *		DSCP to TID mapping table number that need to be used
 *		for the MSDU.
 *
 * search_index
 *		The index that will be used for index based address or
 *		flow search. The field is valid when 'search_type' is  1 or 2.
 *
 * cache_set_num
 *
 *		Cache set number that should be used to cache the index
 *		based search results, for address and flow search. This
 *		value should be equal to LSB four bits of the hash value of
 *		match data, in case of search index points to an entry which
 *		may be used in content based search also. The value can be
 *		anything when the entry pointed by search index will not be
 *		used for content based search.
 *
 * ring_id
 *		The buffer pointer ring ID.
 *		0 refers to the IDLE ring
 *		1 - N refers to other rings
 *
 * looping_count
 *
 *		A count value that indicates the number of times the
 *		producer of entries into the Ring has looped around the
 *		ring.
 *
 *		At initialization time, this value is set to 0. On the
 *		first loop, this value is set to 1. After the max value is
 *		reached allowed by the number of bits for this field, the
 *		count value continues with 0 again.
 *
 *		In case SW is the consumer of the ring entries, it can
 *		use this field to figure out up to where the producer of
 *		entries has created new entries. This eliminates the need to
 *		check where the head pointer' of the ring is located once
 *		the SW starts processing an interrupt indicating that new
 *		entries have been put into this ring...
 *
 *		Also note that SW if it wants only needs to look at the
 *		LSB bit of this count value.
 */

#define HAL_TCL_DESC_LEN sizeof(struct hal_tcl_data_cmd)

enum hal_tcl_gse_ctrl {
	HAL_TCL_GSE_CTRL_RD_STAT,
	HAL_TCL_GSE_CTRL_SRCH_DIS,
	HAL_TCL_GSE_CTRL_WR_BK_SINGLE,
	HAL_TCL_GSE_CTRL_WR_BK_ALL,
	HAL_TCL_GSE_CTRL_INVAL_SINGLE,
	HAL_TCL_GSE_CTRL_INVAL_ALL,
	HAL_TCL_GSE_CTRL_WR_BK_INVAL_SINGLE,
	HAL_TCL_GSE_CTRL_WR_BK_INVAL_ALL,
	HAL_TCL_GSE_CTRL_CLR_STAT_SINGLE,
};

/* hal_tcl_gse_ctrl
 *
 * rd_stat
 *		Report or Read statistics
 * srch_dis
 *		Search disable. Report only Hash.
 * wr_bk_single
 *		Write Back single entry
 * wr_bk_all
 *		Write Back entire cache entry
 * inval_single
 *		Invalidate single cache entry
 * inval_all
 *		Invalidate entire cache
 * wr_bk_inval_single
 *		Write back and invalidate single entry in cache
 * wr_bk_inval_all
 *		Write back and invalidate entire cache
 * clr_stat_single
 *		Clear statistics for single entry
 */

#define HAL_TCL_GSE_CMD_INFO0_CTRL_BUF_ADDR_HI		GENMASK(7, 0)
#define HAL_TCL_GSE_CMD_INFO0_GSE_CTRL			GENMASK(11, 8)
#define HAL_TCL_GSE_CMD_INFO0_GSE_SEL			BIT(12)
#define HAL_TCL_GSE_CMD_INFO0_STATUS_DEST_RING_ID	BIT(13)
#define HAL_TCL_GSE_CMD_INFO0_SWAP			BIT(14)

#define HAL_TCL_GSE_CMD_INFO1_RING_ID			GENMASK(27, 20)
#define HAL_TCL_GSE_CMD_INFO1_LOOPING_COUNT		GENMASK(31, 28)

struct hal_tcl_gse_cmd {
	uint32_t ctrl_buf_addr_lo;
	uint32_t info0;
	uint32_t meta_data[2];
	uint32_t rsvd0[2];
	uint32_t info1;
} __packed;

/* hal_tcl_gse_cmd
 *
 * ctrl_buf_addr_lo, ctrl_buf_addr_hi
 *		Address of a control buffer containing additional info needed
 *		for this command execution.
 *
 * gse_ctrl
 *		GSE control operations. This includes cache operations and table
 *		entry statistics read/clear operation. Values are defined in
 *		enum %HAL_TCL_GSE_CTRL.
 *
 * gse_sel
 *		To select the ASE/FSE to do the operation mention by GSE_ctrl.
 *		0: FSE select 1: ASE select
 *
 * status_destination_ring_id
 *		TCL status ring to which the GSE status needs to be send.
 *
 * swap
 *		Bit to enable byte swapping of contents of buffer.
 *
 * meta_data
 *		Meta data to be returned in the status descriptor
 */

enum hal_tcl_cache_op_res {
	HAL_TCL_CACHE_OP_RES_DONE,
	HAL_TCL_CACHE_OP_RES_NOT_FOUND,
	HAL_TCL_CACHE_OP_RES_TIMEOUT,
};

#define HAL_TCL_STATUS_RING_INFO0_GSE_CTRL		GENMASK(3, 0)
#define HAL_TCL_STATUS_RING_INFO0_GSE_SEL		BIT(4)
#define HAL_TCL_STATUS_RING_INFO0_CACHE_OP_RES		GENMASK(6, 5)
#define HAL_TCL_STATUS_RING_INFO0_MSDU_CNT		GENMASK(31, 8)

#define HAL_TCL_STATUS_RING_INFO1_HASH_IDX		GENMASK(19, 0)

#define HAL_TCL_STATUS_RING_INFO2_RING_ID		GENMASK(27, 20)
#define HAL_TCL_STATUS_RING_INFO2_LOOPING_COUNT		GENMASK(31, 28)

struct hal_tcl_status_ring {
	uint32_t info0;
	uint32_t msdu_byte_count;
	uint32_t msdu_timestamp;
	uint32_t meta_data[2];
	uint32_t info1;
	uint32_t rsvd0;
	uint32_t info2;
} __packed;

/* hal_tcl_status_ring
 *
 * gse_ctrl
 *		GSE control operations. This includes cache operations and table
 *		entry statistics read/clear operation. Values are defined in
 *		enum %HAL_TCL_GSE_CTRL.
 *
 * gse_sel
 *		To select the ASE/FSE to do the operation mention by GSE_ctrl.
 *		0: FSE select 1: ASE select
 *
 * cache_op_res
 *		Cache operation result. Values are defined in enum
 *		%HAL_TCL_CACHE_OP_RES_.
 *
 * msdu_cnt
 * msdu_byte_count
 *		MSDU count of Entry and MSDU byte count for entry 1.
 *
 * hash_indx
 *		Hash value of the entry in case of search failed or disabled.
 */

#define HAL_CE_SRC_DESC_ADDR_INFO_ADDR_HI	GENMASK(7, 0)
#define HAL_CE_SRC_DESC_ADDR_INFO_HASH_EN	BIT(8)
#define HAL_CE_SRC_DESC_ADDR_INFO_BYTE_SWAP	BIT(9)
#define HAL_CE_SRC_DESC_ADDR_INFO_DEST_SWAP	BIT(10)
#define HAL_CE_SRC_DESC_ADDR_INFO_GATHER	BIT(11)
#define HAL_CE_SRC_DESC_ADDR_INFO_LEN		GENMASK(31, 16)

#define HAL_CE_SRC_DESC_META_INFO_DATA		GENMASK(15, 0)

#define HAL_CE_SRC_DESC_FLAGS_RING_ID		GENMASK(27, 20)
#define HAL_CE_SRC_DESC_FLAGS_LOOP_CNT		HAL_SRNG_DESC_LOOP_CNT

struct hal_ce_srng_src_desc {
	uint32_t buffer_addr_low;
	uint32_t buffer_addr_info; /* %HAL_CE_SRC_DESC_ADDR_INFO_ */
	uint32_t meta_info; /* %HAL_CE_SRC_DESC_META_INFO_ */
	uint32_t flags; /* %HAL_CE_SRC_DESC_FLAGS_ */
} __packed;

/*
 * hal_ce_srng_src_desc
 *
 * buffer_addr_lo
 *		LSB 32 bits of the 40 Bit Pointer to the source buffer
 *
 * buffer_addr_hi
 *		MSB 8 bits of the 40 Bit Pointer to the source buffer
 *
 * toeplitz_en
 *		Enable generation of 32-bit Toeplitz-LFSR hash for
 *		data transfer. In case of gather field in first source
 *		ring entry of the gather copy cycle in taken into account.
 *
 * src_swap
 *		Treats source memory organization as big-endian. For
 *		each dword read (4 bytes), the byte 0 is swapped with byte 3
 *		and byte 1 is swapped with byte 2.
 *		In case of gather field in first source ring entry of
 *		the gather copy cycle in taken into account.
 *
 * dest_swap
 *		Treats destination memory organization as big-endian.
 *		For each dword write (4 bytes), the byte 0 is swapped with
 *		byte 3 and byte 1 is swapped with byte 2.
 *		In case of gather field in first source ring entry of
 *		the gather copy cycle in taken into account.
 *
 * gather
 *		Enables gather of multiple copy engine source
 *		descriptors to one destination.
 *
 * ce_res_0
 *		Reserved
 *
 *
 * length
 *		Length of the buffer in units of octets of the current
 *		descriptor
 *
 * fw_metadata
 *		Meta data used by FW.
 *		In case of gather field in first source ring entry of
 *		the gather copy cycle in taken into account.
 *
 * ce_res_1
 *		Reserved
 *
 * ce_res_2
 *		Reserved
 *
 * ring_id
 *		The buffer pointer ring ID.
 *		0 refers to the IDLE ring
 *		1 - N refers to other rings
 *		Helps with debugging when dumping ring contents.
 *
 * looping_count
 *		A count value that indicates the number of times the
 *		producer of entries into the Ring has looped around the
 *		ring.
 *
 *		At initialization time, this value is set to 0. On the
 *		first loop, this value is set to 1. After the max value is
 *		reached allowed by the number of bits for this field, the
 *		count value continues with 0 again.
 *
 *		In case SW is the consumer of the ring entries, it can
 *		use this field to figure out up to where the producer of
 *		entries has created new entries. This eliminates the need to
 *		check where the head pointer' of the ring is located once
 *		the SW starts processing an interrupt indicating that new
 *		entries have been put into this ring...
 *
 *		Also note that SW if it wants only needs to look at the
 *		LSB bit of this count value.
 */

#define HAL_CE_DEST_DESC_ADDR_INFO_ADDR_HI		GENMASK(7, 0)
#define HAL_CE_DEST_DESC_ADDR_INFO_RING_ID		GENMASK(27, 20)
#define HAL_CE_DEST_DESC_ADDR_INFO_LOOP_CNT		HAL_SRNG_DESC_LOOP_CNT

struct hal_ce_srng_dest_desc {
	uint32_t buffer_addr_low;
	uint32_t buffer_addr_info; /* %HAL_CE_DEST_DESC_ADDR_INFO_ */
} __packed;

/* hal_ce_srng_dest_desc
 *
 * dst_buffer_low
 *		LSB 32 bits of the 40 Bit Pointer to the Destination
 *		buffer
 *
 * dst_buffer_high
 *		MSB 8 bits of the 40 Bit Pointer to the Destination
 *		buffer
 *
 * ce_res_4
 *		Reserved
 *
 * ring_id
 *		The buffer pointer ring ID.
 *		0 refers to the IDLE ring
 *		1 - N refers to other rings
 *		Helps with debugging when dumping ring contents.
 *
 * looping_count
 *		A count value that indicates the number of times the
 *		producer of entries into the Ring has looped around the
 *		ring.
 *
 *		At initialization time, this value is set to 0. On the
 *		first loop, this value is set to 1. After the max value is
 *		reached allowed by the number of bits for this field, the
 *		count value continues with 0 again.
 *
 *		In case SW is the consumer of the ring entries, it can
 *		use this field to figure out up to where the producer of
 *		entries has created new entries. This eliminates the need to
 *		check where the head pointer' of the ring is located once
 *		the SW starts processing an interrupt indicating that new
 *		entries have been put into this ring...
 *
 *		Also note that SW if it wants only needs to look at the
 *		LSB bit of this count value.
 */

#define HAL_CE_DST_STATUS_DESC_FLAGS_HASH_EN		BIT(8)
#define HAL_CE_DST_STATUS_DESC_FLAGS_BYTE_SWAP		BIT(9)
#define HAL_CE_DST_STATUS_DESC_FLAGS_DEST_SWAP		BIT(10)
#define HAL_CE_DST_STATUS_DESC_FLAGS_GATHER		BIT(11)
#define HAL_CE_DST_STATUS_DESC_FLAGS_LEN		GENMASK(31, 16)

#define HAL_CE_DST_STATUS_DESC_META_INFO_DATA		GENMASK(15, 0)
#define HAL_CE_DST_STATUS_DESC_META_INFO_RING_ID	GENMASK(27, 20)
#define HAL_CE_DST_STATUS_DESC_META_INFO_LOOP_CNT	HAL_SRNG_DESC_LOOP_CNT

struct hal_ce_srng_dst_status_desc {
	uint32_t flags; /* %HAL_CE_DST_STATUS_DESC_FLAGS_ */
	uint32_t toeplitz_hash0;
	uint32_t toeplitz_hash1;
	uint32_t meta_info; /* HAL_CE_DST_STATUS_DESC_META_INFO_ */
} __packed;

/* hal_ce_srng_dst_status_desc
 *
 * ce_res_5
 *		Reserved
 *
 * toeplitz_en
 *
 * src_swap
 *		Source memory buffer swapped
 *
 * dest_swap
 *		Destination  memory buffer swapped
 *
 * gather
 *		Gather of multiple copy engine source descriptors to one
 *		destination enabled
 *
 * ce_res_6
 *		Reserved
 *
 * length
 *		Sum of all the Lengths of the source descriptor in the
 *		gather chain
 *
 * toeplitz_hash_0
 *		32 LS bits of 64 bit Toeplitz LFSR hash result
 *
 * toeplitz_hash_1
 *		32 MS bits of 64 bit Toeplitz LFSR hash result
 *
 * fw_metadata
 *		Meta data used by FW
 *		In case of gather field in first source ring entry of
 *		the gather copy cycle in taken into account.
 *
 * ce_res_7
 *		Reserved
 *
 * ring_id
 *		The buffer pointer ring ID.
 *		0 refers to the IDLE ring
 *		1 - N refers to other rings
 *		Helps with debugging when dumping ring contents.
 *
 * looping_count
 *		A count value that indicates the number of times the
 *		producer of entries into the Ring has looped around the
 *		ring.
 *
 *		At initialization time, this value is set to 0. On the
 *		first loop, this value is set to 1. After the max value is
 *		reached allowed by the number of bits for this field, the
 *		count value continues with 0 again.
 *
 *		In case SW is the consumer of the ring entries, it can
 *		use this field to figure out up to where the producer of
 *		entries has created new entries. This eliminates the need to
 *		check where the head pointer' of the ring is located once
 *		the SW starts processing an interrupt indicating that new
 *		entries have been put into this ring...
 *
 *		Also note that SW if it wants only needs to look at the
 *			LSB bit of this count value.
 */

#define HAL_TX_RATE_STATS_INFO0_VALID		BIT(0)
#define HAL_TX_RATE_STATS_INFO0_BW		GENMASK(2, 1)
#define HAL_TX_RATE_STATS_INFO0_PKT_TYPE	GENMASK(6, 3)
#define HAL_TX_RATE_STATS_INFO0_STBC		BIT(7)
#define HAL_TX_RATE_STATS_INFO0_LDPC		BIT(8)
#define HAL_TX_RATE_STATS_INFO0_SGI		GENMASK(10, 9)
#define HAL_TX_RATE_STATS_INFO0_MCS		GENMASK(14, 11)
#define HAL_TX_RATE_STATS_INFO0_OFDMA_TX	BIT(15)
#define HAL_TX_RATE_STATS_INFO0_TONES_IN_RU	GENMASK(27, 16)

enum hal_tx_rate_stats_bw {
	HAL_TX_RATE_STATS_BW_20,
	HAL_TX_RATE_STATS_BW_40,
	HAL_TX_RATE_STATS_BW_80,
	HAL_TX_RATE_STATS_BW_160,
};

enum hal_tx_rate_stats_pkt_type {
	HAL_TX_RATE_STATS_PKT_TYPE_11A,
	HAL_TX_RATE_STATS_PKT_TYPE_11B,
	HAL_TX_RATE_STATS_PKT_TYPE_11N,
	HAL_TX_RATE_STATS_PKT_TYPE_11AC,
	HAL_TX_RATE_STATS_PKT_TYPE_11AX,
};

enum hal_tx_rate_stats_sgi {
	HAL_TX_RATE_STATS_SGI_08US,
	HAL_TX_RATE_STATS_SGI_04US,
	HAL_TX_RATE_STATS_SGI_16US,
	HAL_TX_RATE_STATS_SGI_32US,
};

struct hal_tx_rate_stats {
	uint32_t info0;
	uint32_t tsf;
} __packed;

struct hal_wbm_link_desc {
	struct ath11k_buffer_addr buf_addr_info;
} __packed;

/* hal_wbm_link_desc
 *
 *	Producer: WBM
 *	Consumer: WBM
 *
 * buf_addr_info
 *		Details of the physical address of a buffer or MSDU
 *		link descriptor.
 */

enum hal_wbm_rel_src_module {
	HAL_WBM_REL_SRC_MODULE_TQM,
	HAL_WBM_REL_SRC_MODULE_RXDMA,
	HAL_WBM_REL_SRC_MODULE_REO,
	HAL_WBM_REL_SRC_MODULE_FW,
	HAL_WBM_REL_SRC_MODULE_SW,
};

enum hal_wbm_rel_desc_type {
	HAL_WBM_REL_DESC_TYPE_REL_MSDU,
	HAL_WBM_REL_DESC_TYPE_MSDU_LINK,
	HAL_WBM_REL_DESC_TYPE_MPDU_LINK,
	HAL_WBM_REL_DESC_TYPE_MSDU_EXT,
	HAL_WBM_REL_DESC_TYPE_QUEUE_EXT,
};

/* hal_wbm_rel_desc_type
 *
 * msdu_buffer
 *	The address points to an MSDU buffer
 *
 * msdu_link_descriptor
 *	The address points to an Tx MSDU link descriptor
 *
 * mpdu_link_descriptor
 *	The address points to an MPDU link descriptor
 *
 * msdu_ext_descriptor
 *	The address points to an MSDU extension descriptor
 *
 * queue_ext_descriptor
 *	The address points to an TQM queue extension descriptor. WBM should
 *	treat this is the same way as a link descriptor.
 */

enum hal_wbm_rel_bm_act {
	HAL_WBM_REL_BM_ACT_PUT_IN_IDLE,
	HAL_WBM_REL_BM_ACT_REL_MSDU,
};

/* hal_wbm_rel_bm_act
 *
 * put_in_idle_list
 *	Put the buffer or descriptor back in the idle list. In case of MSDU or
 *	MDPU link descriptor, BM does not need to check to release any
 *	individual MSDU buffers.
 *
 * release_msdu_list
 *	This BM action can only be used in combination with desc_type being
 *	msdu_link_descriptor. Field first_msdu_index points out which MSDU
 *	pointer in the MSDU link descriptor is the first of an MPDU that is
 *	released. BM shall release all the MSDU buffers linked to this first
 *	MSDU buffer pointer. All related MSDU buffer pointer entries shall be
 *	set to value 0, which represents the 'NULL' pointer. When all MSDU
 *	buffer pointers in the MSDU link descriptor are 'NULL', the MSDU link
 *	descriptor itself shall also be released.
 */

#define HAL_WBM_RELEASE_INFO0_REL_SRC_MODULE		GENMASK(2, 0)
#define HAL_WBM_RELEASE_INFO0_BM_ACTION			GENMASK(5, 3)
#define HAL_WBM_RELEASE_INFO0_DESC_TYPE			GENMASK(8, 6)
#define HAL_WBM_RELEASE_INFO0_FIRST_MSDU_IDX		GENMASK(12, 9)
#define HAL_WBM_RELEASE_INFO0_TQM_RELEASE_REASON	GENMASK(16, 13)
#define HAL_WBM_RELEASE_INFO0_RXDMA_PUSH_REASON		GENMASK(18, 17)
#define HAL_WBM_RELEASE_INFO0_RXDMA_ERROR_CODE		GENMASK(23, 19)
#define HAL_WBM_RELEASE_INFO0_REO_PUSH_REASON		GENMASK(25, 24)
#define HAL_WBM_RELEASE_INFO0_REO_ERROR_CODE		GENMASK(30, 26)
#define HAL_WBM_RELEASE_INFO0_WBM_INTERNAL_ERROR	BIT(31)

#define HAL_WBM_RELEASE_INFO1_TQM_STATUS_NUMBER		GENMASK(23, 0)
#define HAL_WBM_RELEASE_INFO1_TRANSMIT_COUNT		GENMASK(30, 24)

#define HAL_WBM_RELEASE_INFO2_ACK_FRAME_RSSI		GENMASK(7, 0)
#define HAL_WBM_RELEASE_INFO2_SW_REL_DETAILS_VALID	BIT(8)
#define HAL_WBM_RELEASE_INFO2_FIRST_MSDU		BIT(9)
#define HAL_WBM_RELEASE_INFO2_LAST_MSDU			BIT(10)
#define HAL_WBM_RELEASE_INFO2_MSDU_IN_AMSDU		BIT(11)
#define HAL_WBM_RELEASE_INFO2_FW_TX_NOTIF_FRAME		BIT(12)
#define HAL_WBM_RELEASE_INFO2_BUFFER_TIMESTAMP		GENMASK(31, 13)

#define HAL_WBM_RELEASE_INFO3_PEER_ID			GENMASK(15, 0)
#define HAL_WBM_RELEASE_INFO3_TID			GENMASK(19, 16)
#define HAL_WBM_RELEASE_INFO3_RING_ID			GENMASK(27, 20)
#define HAL_WBM_RELEASE_INFO3_LOOPING_COUNT		GENMASK(31, 28)

#define HAL_WBM_REL_HTT_TX_COMP_INFO0_STATUS		GENMASK(12, 9)
#define HAL_WBM_REL_HTT_TX_COMP_INFO0_REINJ_REASON	GENMASK(16, 13)
#define HAL_WBM_REL_HTT_TX_COMP_INFO0_EXP_FRAME		BIT(17)

struct hal_wbm_release_ring {
	struct ath11k_buffer_addr buf_addr_info;
	uint32_t info0;
	uint32_t info1;
	uint32_t info2;
	struct hal_tx_rate_stats rate_stats;
	uint32_t info3;
} __packed;

/* hal_wbm_release_ring
 *
 *	Producer: SW/TQM/RXDMA/REO/SWITCH
 *	Consumer: WBM/SW/FW
 *
 * HTT tx status is overlaid on wbm_release ring on 4-byte words 2, 3, 4 and 5
 * for software based completions.
 *
 * buf_addr_info
 *	Details of the physical address of the buffer or link descriptor.
 *
 * release_source_module
 *	Indicates which module initiated the release of this buffer/descriptor.
 *	Values are defined in enum %HAL_WBM_REL_SRC_MODULE_.
 *
 * bm_action
 *	Field only valid when the field return_buffer_manager in
 *	Released_buff_or_desc_addr_info indicates:
 *		WBM_IDLE_BUF_LIST / WBM_IDLE_DESC_LIST
 *	Values are defined in enum %HAL_WBM_REL_BM_ACT_.
 *
 * buffer_or_desc_type
 *	Field only valid when WBM is marked as the return_buffer_manager in
 *	the Released_Buffer_address_info. Indicates that type of buffer or
 *	descriptor is being released. Values are in enum %HAL_WBM_REL_DESC_TYPE.
 *
 * first_msdu_index
 *	Field only valid for the bm_action release_msdu_list. The index of the
 *	first MSDU in an MSDU link descriptor all belonging to the same MPDU.
 *
 * tqm_release_reason
 *	Field only valid when Release_source_module is set to release_source_TQM
 *	Release reasons are defined in enum %HAL_WBM_TQM_REL_REASON_.
 *
 * rxdma_push_reason
 * reo_push_reason
 *	Indicates why rxdma/reo pushed the frame to this ring and values are
 *	defined in enum %HAL_REO_DEST_RING_PUSH_REASON_.
 *
 * rxdma_error_code
 *	Field only valid when 'rxdma_push_reason' set to 'error_detected'.
 *	Values are defined in enum %HAL_REO_ENTR_RING_RXDMA_ECODE_.
 *
 * reo_error_code
 *	Field only valid when 'reo_push_reason' set to 'error_detected'. Values
 *	are defined in enum %HAL_REO_DEST_RING_ERROR_CODE_.
 *
 * wbm_internal_error
 *	Is set when WBM got a buffer pointer but the action was to push it to
 *	the idle link descriptor ring or do link related activity OR
 *	Is set when WBM got a link buffer pointer but the action was to push it
 *	to the buffer descriptor ring.
 *
 * tqm_status_number
 *	The value in this field is equal to tqm_cmd_number in TQM command. It is
 *	used to correlate the statu with TQM commands. Only valid when
 *	release_source_module is TQM.
 *
 * transmit_count
 *	The number of times the frame has been transmitted, valid only when
 *	release source in TQM.
 *
 * ack_frame_rssi
 *	This field is only valid when the source is TQM. If this frame is
 *	removed as the result of the reception of an ACK or BA, this field
 *	indicates the RSSI of the received ACK or BA frame.
 *
 * sw_release_details_valid
 *	This is set when WMB got a 'release_msdu_list' command from TQM and
 *	return buffer manager is not WMB. WBM will then de-aggregate all MSDUs
 *	and pass them one at a time on to the 'buffer owner'.
 *
 * first_msdu
 *	Field only valid when SW_release_details_valid is set.
 *	When set, this MSDU is the first MSDU pointed to in the
 *	'release_msdu_list' command.
 *
 * last_msdu
 *	Field only valid when SW_release_details_valid is set.
 *	When set, this MSDU is the last MSDU pointed to in the
 *	'release_msdu_list' command.
 *
 * msdu_part_of_amsdu
 *	Field only valid when SW_release_details_valid is set.
 *	When set, this MSDU was part of an A-MSDU in MPDU
 *
 * fw_tx_notify_frame
 *	Field only valid when SW_release_details_valid is set.
 *
 * buffer_timestamp
 *	Field only valid when SW_release_details_valid is set.
 *	This is the Buffer_timestamp field from the
 *	Timestamp in units of 1024 us
 *
 * struct hal_tx_rate_stats rate_stats
 *	Details for command execution tracking purposes.
 *
 * sw_peer_id
 * tid
 *	Field only valid when Release_source_module is set to
 *	release_source_TQM
 *
 *	1) Release of msdu buffer due to drop_frame = 1. Flow is
 *	not fetched and hence sw_peer_id and tid = 0
 *
 *	buffer_or_desc_type = e_num 0
 *	MSDU_rel_buffertqm_release_reason = e_num 1
 *	tqm_rr_rem_cmd_rem
 *
 *	2) Release of msdu buffer due to Flow is not fetched and
 *	hence sw_peer_id and tid = 0
 *
 *	buffer_or_desc_type = e_num 0
 *	MSDU_rel_buffertqm_release_reason = e_num 1
 *	tqm_rr_rem_cmd_rem
 *
 *	3) Release of msdu link due to remove_mpdu or acked_mpdu
 *	command.
 *
 *	buffer_or_desc_type = e_num1
 *	msdu_link_descriptortqm_release_reason can be:e_num 1
 *	tqm_rr_rem_cmd_reme_num 2 tqm_rr_rem_cmd_tx
 *	e_num 3 tqm_rr_rem_cmd_notxe_num 4 tqm_rr_rem_cmd_aged
 *
 *	This field represents the TID from the TX_MSDU_FLOW
 *	descriptor or TX_MPDU_QUEUE descriptor
 *
 * rind_id
 *	For debugging.
 *	This field is filled in by the SRNG module.
 *	It help to identify the ring that is being looked
 *
 * looping_count
 *	A count value that indicates the number of times the
 *	producer of entries into the Buffer Manager Ring has looped
 *	around the ring.
 *
 *	At initialization time, this value is set to 0. On the
 *	first loop, this value is set to 1. After the max value is
 *	reached allowed by the number of bits for this field, the
 *	count value continues with 0 again.
 *
 *	In case SW is the consumer of the ring entries, it can
 *	use this field to figure out up to where the producer of
 *	entries has created new entries. This eliminates the need to
 *	check where the head pointer' of the ring is located once
 *	the SW starts processing an interrupt indicating that new
 *	entries have been put into this ring...
 *
 *	Also note that SW if it wants only needs to look at the
 *	LSB bit of this count value.
 */

/**
 * enum hal_wbm_tqm_rel_reason - TQM release reason code
 * @HAL_WBM_TQM_REL_REASON_FRAME_ACKED: ACK or BACK received for the frame
 * @HAL_WBM_TQM_REL_REASON_CMD_REMOVE_MPDU: Command remove_mpdus initiated by SW
 * @HAL_WBM_TQM_REL_REASON_CMD_REMOVE_TX: Command remove transmitted_mpdus
 *	initiated by sw.
 * @HAL_WBM_TQM_REL_REASON_CMD_REMOVE_NOTX: Command remove untransmitted_mpdus
 *	initiated by sw.
 * @HAL_WBM_TQM_REL_REASON_CMD_REMOVE_AGED_FRAMES: Command remove aged msdus or
 *	mpdus.
 * @HAL_WBM_TQM_REL_REASON_CMD_REMOVE_RESEAON1: Remove command initiated by
 *	fw with fw_reason1.
 * @HAL_WBM_TQM_REL_REASON_CMD_REMOVE_RESEAON2: Remove command initiated by
 *	fw with fw_reason2.
 * @HAL_WBM_TQM_REL_REASON_CMD_REMOVE_RESEAON3: Remove command initiated by
 *	fw with fw_reason3.
 */
enum hal_wbm_tqm_rel_reason {
	HAL_WBM_TQM_REL_REASON_FRAME_ACKED,
	HAL_WBM_TQM_REL_REASON_CMD_REMOVE_MPDU,
	HAL_WBM_TQM_REL_REASON_CMD_REMOVE_TX,
	HAL_WBM_TQM_REL_REASON_CMD_REMOVE_NOTX,
	HAL_WBM_TQM_REL_REASON_CMD_REMOVE_AGED_FRAMES,
	HAL_WBM_TQM_REL_REASON_CMD_REMOVE_RESEAON1,
	HAL_WBM_TQM_REL_REASON_CMD_REMOVE_RESEAON2,
	HAL_WBM_TQM_REL_REASON_CMD_REMOVE_RESEAON3,
};

struct hal_wbm_buffer_ring {
	struct ath11k_buffer_addr buf_addr_info;
};

enum hal_desc_owner {
	HAL_DESC_OWNER_WBM,
	HAL_DESC_OWNER_SW,
	HAL_DESC_OWNER_TQM,
	HAL_DESC_OWNER_RXDMA,
	HAL_DESC_OWNER_REO,
	HAL_DESC_OWNER_SWITCH,
};

enum hal_desc_buf_type {
	HAL_DESC_BUF_TYPE_TX_MSDU_LINK,
	HAL_DESC_BUF_TYPE_TX_MPDU_LINK,
	HAL_DESC_BUF_TYPE_TX_MPDU_QUEUE_HEAD,
	HAL_DESC_BUF_TYPE_TX_MPDU_QUEUE_EXT,
	HAL_DESC_BUF_TYPE_TX_FLOW,
	HAL_DESC_BUF_TYPE_TX_BUFFER,
	HAL_DESC_BUF_TYPE_RX_MSDU_LINK,
	HAL_DESC_BUF_TYPE_RX_MPDU_LINK,
	HAL_DESC_BUF_TYPE_RX_REO_QUEUE,
	HAL_DESC_BUF_TYPE_RX_REO_QUEUE_EXT,
	HAL_DESC_BUF_TYPE_RX_BUFFER,
	HAL_DESC_BUF_TYPE_IDLE_LINK,
};

#define HAL_DESC_REO_OWNED		4
#define HAL_DESC_REO_QUEUE_DESC		8
#define HAL_DESC_REO_QUEUE_EXT_DESC	9
#define HAL_DESC_REO_NON_QOS_TID	16

#define HAL_DESC_HDR_INFO0_OWNER	GENMASK(3, 0)
#define HAL_DESC_HDR_INFO0_BUF_TYPE	GENMASK(7, 4)
#define HAL_DESC_HDR_INFO0_DBG_RESERVED	GENMASK(31, 8)

struct hal_desc_header {
	uint32_t info0;
} __packed;

struct hal_rx_mpdu_link_ptr {
	struct ath11k_buffer_addr addr_info;
} __packed;

struct hal_rx_msdu_details {
	struct ath11k_buffer_addr buf_addr_info;
	struct rx_msdu_desc rx_msdu_info;
} __packed;

#define HAL_RX_MSDU_LNK_INFO0_RX_QUEUE_NUMBER		GENMASK(15, 0)
#define HAL_RX_MSDU_LNK_INFO0_FIRST_MSDU_LNK		BIT(16)

struct hal_rx_msdu_link {
	struct hal_desc_header desc_hdr;
	struct ath11k_buffer_addr buf_addr_info;
	uint32_t info0;
	uint32_t pn[4];
	struct hal_rx_msdu_details msdu_link[6];
} __packed;

struct hal_rx_reo_queue_ext {
	struct hal_desc_header desc_hdr;
	uint32_t rsvd;
	struct hal_rx_mpdu_link_ptr mpdu_link[15];
} __packed;

/* hal_rx_reo_queue_ext
 *	Consumer: REO
 *	Producer: REO
 *
 * descriptor_header
 *	Details about which module owns this struct.
 *
 * mpdu_link
 *	Pointer to the next MPDU_link descriptor in the MPDU queue.
 */

enum hal_rx_reo_queue_pn_size {
	HAL_RX_REO_QUEUE_PN_SIZE_24,
	HAL_RX_REO_QUEUE_PN_SIZE_48,
	HAL_RX_REO_QUEUE_PN_SIZE_128,
};

#define HAL_RX_REO_QUEUE_RX_QUEUE_NUMBER		GENMASK(15, 0)

#define HAL_RX_REO_QUEUE_INFO0_VLD			BIT(0)
#define HAL_RX_REO_QUEUE_INFO0_ASSOC_LNK_DESC_COUNTER	GENMASK(2, 1)
#define HAL_RX_REO_QUEUE_INFO0_DIS_DUP_DETECTION	BIT(3)
#define HAL_RX_REO_QUEUE_INFO0_SOFT_REORDER_EN		BIT(4)
#define HAL_RX_REO_QUEUE_INFO0_AC			GENMASK(6, 5)
#define HAL_RX_REO_QUEUE_INFO0_BAR			BIT(7)
#define HAL_RX_REO_QUEUE_INFO0_RETRY			BIT(8)
#define HAL_RX_REO_QUEUE_INFO0_CHECK_2K_MODE		BIT(9)
#define HAL_RX_REO_QUEUE_INFO0_OOR_MODE			BIT(10)
#define HAL_RX_REO_QUEUE_INFO0_BA_WINDOW_SIZE		GENMASK(18, 11)
#define HAL_RX_REO_QUEUE_INFO0_PN_CHECK			BIT(19)
#define HAL_RX_REO_QUEUE_INFO0_EVEN_PN			BIT(20)
#define HAL_RX_REO_QUEUE_INFO0_UNEVEN_PN		BIT(21)
#define HAL_RX_REO_QUEUE_INFO0_PN_HANDLE_ENABLE		BIT(22)
#define HAL_RX_REO_QUEUE_INFO0_PN_SIZE			GENMASK(24, 23)
#define HAL_RX_REO_QUEUE_INFO0_IGNORE_AMPDU_FLG		BIT(25)

#define HAL_RX_REO_QUEUE_INFO1_SVLD			BIT(0)
#define HAL_RX_REO_QUEUE_INFO1_SSN			GENMASK(12, 1)
#define HAL_RX_REO_QUEUE_INFO1_CURRENT_IDX		GENMASK(20, 13)
#define HAL_RX_REO_QUEUE_INFO1_SEQ_2K_ERR		BIT(21)
#define HAL_RX_REO_QUEUE_INFO1_PN_ERR			BIT(22)
#define HAL_RX_REO_QUEUE_INFO1_PN_VALID			BIT(31)

#define HAL_RX_REO_QUEUE_INFO2_MPDU_COUNT		GENMASK(6, 0)
#define HAL_RX_REO_QUEUE_INFO2_MSDU_COUNT		(31, 7)

#define HAL_RX_REO_QUEUE_INFO3_TIMEOUT_COUNT		GENMASK(9, 4)
#define HAL_RX_REO_QUEUE_INFO3_FWD_DUE_TO_BAR_CNT	GENMASK(15, 10)
#define HAL_RX_REO_QUEUE_INFO3_DUPLICATE_COUNT		GENMASK(31, 16)

#define HAL_RX_REO_QUEUE_INFO4_FRAME_IN_ORD_COUNT	GENMASK(23, 0)
#define HAL_RX_REO_QUEUE_INFO4_BAR_RECVD_COUNT		GENMASK(31, 24)

#define HAL_RX_REO_QUEUE_INFO5_LATE_RX_MPDU_COUNT	GENMASK(11, 0)
#define HAL_RX_REO_QUEUE_INFO5_WINDOW_JUMP_2K		GENMASK(15, 12)
#define HAL_RX_REO_QUEUE_INFO5_HOLE_COUNT		GENMASK(31, 16)

struct hal_rx_reo_queue {
	struct hal_desc_header desc_hdr;
	uint32_t rx_queue_num;
	uint32_t info0;
	uint32_t info1;
	uint32_t pn[4];
	uint32_t last_rx_enqueue_timestamp;
	uint32_t last_rx_dequeue_timestamp;
	uint32_t next_aging_queue[2];
	uint32_t prev_aging_queue[2];
	uint32_t rx_bitmap[8];
	uint32_t info2;
	uint32_t info3;
	uint32_t info4;
	uint32_t processed_mpdus;
	uint32_t processed_msdus;
	uint32_t processed_total_bytes;
	uint32_t info5;
	uint32_t rsvd[3];
	struct hal_rx_reo_queue_ext ext_desc[];
} __packed;

/* hal_rx_reo_queue
 *
 * descriptor_header
 *	Details about which module owns this struct. Note that sub field
 *	Buffer_type shall be set to receive_reo_queue_descriptor.
 *
 * receive_queue_number
 *	Indicates the MPDU queue ID to which this MPDU link descriptor belongs.
 *
 * vld
 *	Valid bit indicating a session is established and the queue descriptor
 *	is valid.
 * associated_link_descriptor_counter
 *	Indicates which of the 3 link descriptor counters shall be incremented
 *	or decremented when link descriptors are added or removed from this
 *	flow queue.
 * disable_duplicate_detection
 *	When set, do not perform any duplicate detection.
 * soft_reorder_enable
 *	When set, REO has been instructed to not perform the actual re-ordering
 *	of frames for this queue, but just to insert the reorder opcodes.
 * ac
 *	Indicates the access category of the queue descriptor.
 * bar
 *	Indicates if BAR has been received.
 * retry
 *	Retry bit is checked if this bit is set.
 * chk_2k_mode
 *	Indicates what type of operation is expected from Reo when the received
 *	frame SN falls within the 2K window.
 * oor_mode
 *	Indicates what type of operation is expected when the received frame
 *	falls within the OOR window.
 * ba_window_size
 *	Indicates the negotiated (window size + 1). Max of 256 bits.
 *
 *	A value 255 means 256 bitmap, 63 means 64 bitmap, 0 (means non-BA
 *	session, with window size of 0). The 3 values here are the main values
 *	validated, but other values should work as well.
 *
 *	A BA window size of 0 (=> one frame entry bitmat), means that there is
 *	no additional rx_reo_queue_ext desc. following rx_reo_queue in memory.
 *	A BA window size of 1 - 105, means that there is 1 rx_reo_queue_ext.
 *	A BA window size of 106 - 210, means that there are 2 rx_reo_queue_ext.
 *	A BA window size of 211 - 256, means that there are 3 rx_reo_queue_ext.
 * pn_check_needed, pn_shall_be_even, pn_shall_be_uneven, pn_handling_enable,
 * pn_size
 *	REO shall perform the PN increment check, even number check, uneven
 *	number check, PN error check and size of the PN field check.
 * ignore_ampdu_flag
 *	REO shall ignore the ampdu_flag on entrance descriptor for this queue.
 *
 * svld
 *	Sequence number in next field is valid one.
 * ssn
 *	 Starting Sequence number of the session.
 * current_index
 *	Points to last forwarded packet
 * seq_2k_error_detected_flag
 *	REO has detected a 2k error jump in the sequence number and from that
 *	moment forward, all new frames are forwarded directly to FW, without
 *	duplicate detect, reordering, etc.
 * pn_error_detected_flag
 *	REO has detected a PN error.
 */

#define HAL_REO_UPD_RX_QUEUE_INFO0_QUEUE_ADDR_HI		GENMASK(7, 0)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_RX_QUEUE_NUM		BIT(8)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_VLD			BIT(9)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_ASSOC_LNK_DESC_CNT	BIT(10)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_DIS_DUP_DETECTION	BIT(11)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_SOFT_REORDER_EN		BIT(12)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_AC			BIT(13)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_BAR			BIT(14)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_RETRY			BIT(15)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_CHECK_2K_MODE		BIT(16)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_OOR_MODE			BIT(17)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_BA_WINDOW_SIZE		BIT(18)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_PN_CHECK			BIT(19)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_EVEN_PN			BIT(20)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_UNEVEN_PN		BIT(21)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_PN_HANDLE_ENABLE		BIT(22)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_PN_SIZE			BIT(23)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_IGNORE_AMPDU_FLG		BIT(24)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_SVLD			BIT(25)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_SSN			BIT(26)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_SEQ_2K_ERR		BIT(27)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_PN_ERR			BIT(28)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_PN_VALID			BIT(29)
#define HAL_REO_UPD_RX_QUEUE_INFO0_UPD_PN			BIT(30)

#define HAL_REO_UPD_RX_QUEUE_INFO1_RX_QUEUE_NUMBER		GENMASK(15, 0)
#define HAL_REO_UPD_RX_QUEUE_INFO1_VLD				BIT(16)
#define HAL_REO_UPD_RX_QUEUE_INFO1_ASSOC_LNK_DESC_COUNTER	GENMASK(18, 17)
#define HAL_REO_UPD_RX_QUEUE_INFO1_DIS_DUP_DETECTION		BIT(19)
#define HAL_REO_UPD_RX_QUEUE_INFO1_SOFT_REORDER_EN		BIT(20)
#define HAL_REO_UPD_RX_QUEUE_INFO1_AC				GENMASK(22, 21)
#define HAL_REO_UPD_RX_QUEUE_INFO1_BAR				BIT(23)
#define HAL_REO_UPD_RX_QUEUE_INFO1_RETRY			BIT(24)
#define HAL_REO_UPD_RX_QUEUE_INFO1_CHECK_2K_MODE		BIT(25)
#define HAL_REO_UPD_RX_QUEUE_INFO1_OOR_MODE			BIT(26)
#define HAL_REO_UPD_RX_QUEUE_INFO1_PN_CHECK			BIT(27)
#define HAL_REO_UPD_RX_QUEUE_INFO1_EVEN_PN			BIT(28)
#define HAL_REO_UPD_RX_QUEUE_INFO1_UNEVEN_PN			BIT(29)
#define HAL_REO_UPD_RX_QUEUE_INFO1_PN_HANDLE_ENABLE		BIT(30)
#define HAL_REO_UPD_RX_QUEUE_INFO1_IGNORE_AMPDU_FLG		BIT(31)

#define HAL_REO_UPD_RX_QUEUE_INFO2_BA_WINDOW_SIZE		GENMASK(7, 0)
#define HAL_REO_UPD_RX_QUEUE_INFO2_PN_SIZE			GENMASK(9, 8)
#define HAL_REO_UPD_RX_QUEUE_INFO2_SVLD				BIT(10)
#define HAL_REO_UPD_RX_QUEUE_INFO2_SSN				GENMASK(22, 11)
#define HAL_REO_UPD_RX_QUEUE_INFO2_SEQ_2K_ERR			BIT(23)
#define HAL_REO_UPD_RX_QUEUE_INFO2_PN_ERR			BIT(24)
#define HAL_REO_UPD_RX_QUEUE_INFO2_PN_VALID			BIT(25)

struct hal_reo_update_rx_queue {
	struct hal_reo_cmd_hdr cmd;
	uint32_t queue_addr_lo;
	uint32_t info0;
	uint32_t info1;
	uint32_t info2;
	uint32_t pn[4];
} __packed;

#define HAL_REO_UNBLOCK_CACHE_INFO0_UNBLK_CACHE		BIT(0)
#define HAL_REO_UNBLOCK_CACHE_INFO0_RESOURCE_IDX	GENMASK(2, 1)

struct hal_reo_unblock_cache {
	struct hal_reo_cmd_hdr cmd;
	uint32_t info0;
	uint32_t rsvd[7];
} __packed;

enum hal_reo_exec_status {
	HAL_REO_EXEC_STATUS_SUCCESS,
	HAL_REO_EXEC_STATUS_BLOCKED,
	HAL_REO_EXEC_STATUS_FAILED,
	HAL_REO_EXEC_STATUS_RESOURCE_BLOCKED,
};

#define HAL_REO_STATUS_HDR_INFO0_STATUS_NUM	GENMASK(15, 0)
#define HAL_REO_STATUS_HDR_INFO0_EXEC_TIME	GENMASK(25, 16)
#define HAL_REO_STATUS_HDR_INFO0_EXEC_STATUS	GENMASK(27, 26)

#define HAL_HASH_ROUTING_RING_TCL 0
#define HAL_HASH_ROUTING_RING_SW1 1
#define HAL_HASH_ROUTING_RING_SW2 2
#define HAL_HASH_ROUTING_RING_SW3 3
#define HAL_HASH_ROUTING_RING_SW4 4
#define HAL_HASH_ROUTING_RING_REL 5
#define HAL_HASH_ROUTING_RING_FW  6

struct hal_reo_status_hdr {
	uint32_t info0;
	uint32_t timestamp;
} __packed;

/* hal_reo_status_hdr
 *		Producer: REO
 *		Consumer: SW
 *
 * status_num
 *		The value in this field is equal to value of the reo command
 *		number. This field helps to correlate the statuses with the REO
 *		commands.
 *
 * execution_time (in us)
 *		The amount of time REO took to execute the command. Note that
 *		this time does not include the duration of the command waiting
 *		in the command ring, before the execution started.
 *
 * execution_status
 *		Execution status of the command. Values are defined in
 *		enum %HAL_REO_EXEC_STATUS_.
 */
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO0_SSN		GENMASK(11, 0)
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO0_CUR_IDX		GENMASK(19, 12)

#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO1_MPDU_COUNT		GENMASK(6, 0)
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO1_MSDU_COUNT		GENMASK(31, 7)

#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO2_TIMEOUT_COUNT	GENMASK(9, 4)
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO2_FDTB_COUNT		GENMASK(15, 10)
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO2_DUPLICATE_COUNT	GENMASK(31, 16)

#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO3_FIO_COUNT		GENMASK(23, 0)
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO3_BAR_RCVD_CNT	GENMASK(31, 24)

#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO4_LATE_RX_MPDU	GENMASK(11, 0)
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO4_WINDOW_JMP2K	GENMASK(15, 12)
#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO4_HOLE_COUNT		GENMASK(31, 16)

#define HAL_REO_GET_QUEUE_STATS_STATUS_INFO5_LOOPING_CNT	GENMASK(31, 28)

struct hal_reo_get_queue_stats_status {
	struct hal_reo_status_hdr hdr;
	uint32_t info0;
	uint32_t pn[4];
	uint32_t last_rx_enqueue_timestamp;
	uint32_t last_rx_dequeue_timestamp;
	uint32_t rx_bitmap[8];
	uint32_t info1;
	uint32_t info2;
	uint32_t info3;
	uint32_t num_mpdu_frames;
	uint32_t num_msdu_frames;
	uint32_t total_bytes;
	uint32_t info4;
	uint32_t info5;
} __packed;

/* hal_reo_get_queue_stats_status
 *		Producer: REO
 *		Consumer: SW
 *
 * status_hdr
 *		Details that can link this status with the original command. It
 *		also contains info on how long REO took to execute this command.
 *
 * ssn
 *		Starting Sequence number of the session, this changes whenever
 *		window moves (can be filled by SW then maintained by REO).
 *
 * current_index
 *		Points to last forwarded packet.
 *
 * pn
 *		Bits of the PN number.
 *
 * last_rx_enqueue_timestamp
 * last_rx_dequeue_timestamp
 *		Timestamp of arrival of the last MPDU for this queue and
 *		Timestamp of forwarding an MPDU accordingly.
 *
 * rx_bitmap
 *		When a bit is set, the corresponding frame is currently held
 *		in the re-order queue. The bitmap  is Fully managed by HW.
 *
 * current_mpdu_count
 * current_msdu_count
 *		The number of MPDUs and MSDUs in the queue.
 *
 * timeout_count
 *		The number of times REO started forwarding frames even though
 *		there is a hole in the bitmap. Forwarding reason is timeout.
 *
 * forward_due_to_bar_count
 *		The number of times REO started forwarding frames even though
 *		there is a hole in the bitmap. Fwd reason is reception of BAR.
 *
 * duplicate_count
 *		The number of duplicate frames that have been detected.
 *
 * frames_in_order_count
 *		The number of frames that have been received in order (without
 *		a hole that prevented them from being forwarded immediately).
 *
 * bar_received_count
 *		The number of times a BAR frame is received.
 *
 * mpdu_frames_processed_count
 * msdu_frames_processed_count
 *		The total number of MPDU/MSDU frames that have been processed.
 *
 * total_bytes
 *		An approximation of the number of bytes received for this queue.
 *
 * late_receive_mpdu_count
 *		The number of MPDUs received after the window had already moved
 *		on. The 'late' sequence window is defined as
 *		(Window SSN - 256) - (Window SSN - 1).
 *
 * window_jump_2k
 *		The number of times the window moved more than 2K
 *
 * hole_count
 *		The number of times a hole was created in the receive bitmap.
 *
 * looping_count
 *		A count value that indicates the number of times the producer of
 *		entries into this Ring has looped around the ring.
 */

#define HAL_REO_STATUS_LOOP_CNT			GENMASK(31, 28)

#define HAL_REO_FLUSH_QUEUE_INFO0_ERR_DETECTED	BIT(0)
#define HAL_REO_FLUSH_QUEUE_INFO0_RSVD		GENMASK(31, 1)
#define HAL_REO_FLUSH_QUEUE_INFO1_RSVD		GENMASK(27, 0)

struct hal_reo_flush_queue_status {
	struct hal_reo_status_hdr hdr;
	uint32_t info0;
	uint32_t rsvd0[21];
	uint32_t info1;
} __packed;

/* hal_reo_flush_queue_status
 *		Producer: REO
 *		Consumer: SW
 *
 * status_hdr
 *		Details that can link this status with the original command. It
 *		also contains info on how long REO took to execute this command.
 *
 * error_detected
 *		Status of blocking resource
 *
 *		0 - No error has been detected while executing this command
 *		1 - Error detected. The resource to be used for blocking was
 *		    already in use.
 *
 * looping_count
 *		A count value that indicates the number of times the producer of
 *		entries into this Ring has looped around the ring.
 */

#define HAL_REO_FLUSH_CACHE_STATUS_INFO0_IS_ERR			BIT(0)
#define HAL_REO_FLUSH_CACHE_STATUS_INFO0_BLOCK_ERR_CODE		GENMASK(2, 1)
#define HAL_REO_FLUSH_CACHE_STATUS_INFO0_FLUSH_STATUS_HIT	BIT(8)
#define HAL_REO_FLUSH_CACHE_STATUS_INFO0_FLUSH_DESC_TYPE	GENMASK(11, 9)
#define HAL_REO_FLUSH_CACHE_STATUS_INFO0_FLUSH_CLIENT_ID	GENMASK(15, 12)
#define HAL_REO_FLUSH_CACHE_STATUS_INFO0_FLUSH_ERR		GENMASK(17, 16)
#define HAL_REO_FLUSH_CACHE_STATUS_INFO0_FLUSH_COUNT		GENMASK(25, 18)

struct hal_reo_flush_cache_status {
	struct hal_reo_status_hdr hdr;
	uint32_t info0;
	uint32_t rsvd0[21];
	uint32_t info1;
} __packed;

/* hal_reo_flush_cache_status
 *		Producer: REO
 *		Consumer: SW
 *
 * status_hdr
 *		Details that can link this status with the original command. It
 *		also contains info on how long REO took to execute this command.
 *
 * error_detected
 *		Status for blocking resource handling
 *
 *		0 - No error has been detected while executing this command
 *		1 - An error in the blocking resource management was detected
 *
 * block_error_details
 *		only valid when error_detected is set
 *
 *		0 - No blocking related errors found
 *		1 - Blocking resource is already in use
 *		2 - Resource requested to be unblocked, was not blocked
 *
 * cache_controller_flush_status_hit
 *		The status that the cache controller returned on executing the
 *		flush command.
 *
 *		0 - miss; 1 - hit
 *
 * cache_controller_flush_status_desc_type
 *		Flush descriptor type
 *
 * cache_controller_flush_status_client_id
 *		Module who made the flush request
 *
 *		In REO, this is always 0
 *
 * cache_controller_flush_status_error
 *		Error condition
 *
 *		0 - No error found
 *		1 - HW interface is still busy
 *		2 - Line currently locked. Used for one line flush command
 *		3 - At least one line is still locked.
 *		    Used for cache flush command.
 *
 * cache_controller_flush_count
 *		The number of lines that were actually flushed out
 *
 * looping_count
 *		A count value that indicates the number of times the producer of
 *		entries into this Ring has looped around the ring.
 */

#define HAL_REO_UNBLOCK_CACHE_STATUS_INFO0_IS_ERR	BIT(0)
#define HAL_REO_UNBLOCK_CACHE_STATUS_INFO0_TYPE		BIT(1)

struct hal_reo_unblock_cache_status {
	struct hal_reo_status_hdr hdr;
	uint32_t info0;
	uint32_t rsvd0[21];
	uint32_t info1;
} __packed;

/* hal_reo_unblock_cache_status
 *		Producer: REO
 *		Consumer: SW
 *
 * status_hdr
 *		Details that can link this status with the original command. It
 *		also contains info on how long REO took to execute this command.
 *
 * error_detected
 *		0 - No error has been detected while executing this command
 *		1 - The blocking resource was not in use, and therefore it could
 *		    not be unblocked.
 *
 * unblock_type
 *		Reference to the type of unblock command
 *		0 - Unblock a blocking resource
 *		1 - The entire cache usage is unblock
 *
 * looping_count
 *		A count value that indicates the number of times the producer of
 *		entries into this Ring has looped around the ring.
 */

#define HAL_REO_FLUSH_TIMEOUT_STATUS_INFO0_IS_ERR		BIT(0)
#define HAL_REO_FLUSH_TIMEOUT_STATUS_INFO0_LIST_EMPTY		BIT(1)

#define HAL_REO_FLUSH_TIMEOUT_STATUS_INFO1_REL_DESC_COUNT	GENMASK(15, 0)
#define HAL_REO_FLUSH_TIMEOUT_STATUS_INFO1_FWD_BUF_COUNT	GENMASK(31, 16)

struct hal_reo_flush_timeout_list_status {
	struct hal_reo_status_hdr hdr;
	uint32_t info0;
	uint32_t info1;
	uint32_t rsvd0[20];
	uint32_t info2;
} __packed;

/* hal_reo_flush_timeout_list_status
 *		Producer: REO
 *		Consumer: SW
 *
 * status_hdr
 *		Details that can link this status with the original command. It
 *		also contains info on how long REO took to execute this command.
 *
 * error_detected
 *		0 - No error has been detected while executing this command
 *		1 - Command not properly executed and returned with error
 *
 * timeout_list_empty
 *		When set, REO has depleted the timeout list and all entries are
 *		gone.
 *
 * release_desc_count
 *		Producer: SW; Consumer: REO
 *		The number of link descriptor released
 *
 * forward_buf_count
 *		Producer: SW; Consumer: REO
 *		The number of buffers forwarded to the REO destination rings
 *
 * looping_count
 *		A count value that indicates the number of times the producer of
 *		entries into this Ring has looped around the ring.
 */

#define HAL_REO_DESC_THRESH_STATUS_INFO0_THRESH_INDEX		GENMASK(1, 0)
#define HAL_REO_DESC_THRESH_STATUS_INFO1_LINK_DESC_COUNTER0	GENMASK(23, 0)
#define HAL_REO_DESC_THRESH_STATUS_INFO2_LINK_DESC_COUNTER1	GENMASK(23, 0)
#define HAL_REO_DESC_THRESH_STATUS_INFO3_LINK_DESC_COUNTER2	GENMASK(23, 0)
#define HAL_REO_DESC_THRESH_STATUS_INFO4_LINK_DESC_COUNTER_SUM	GENMASK(25, 0)

struct hal_reo_desc_thresh_reached_status {
	struct hal_reo_status_hdr hdr;
	uint32_t info0;
	uint32_t info1;
	uint32_t info2;
	uint32_t info3;
	uint32_t info4;
	uint32_t rsvd0[17];
	uint32_t info5;
} __packed;

/* hal_reo_desc_thresh_reached_status
 *		Producer: REO
 *		Consumer: SW
 *
 * status_hdr
 *		Details that can link this status with the original command. It
 *		also contains info on how long REO took to execute this command.
 *
 * threshold_index
 *		The index of the threshold register whose value got reached
 *
 * link_descriptor_counter0
 * link_descriptor_counter1
 * link_descriptor_counter2
 * link_descriptor_counter_sum
 *		Value of the respective counters at generation of this message
 *
 * looping_count
 *		A count value that indicates the number of times the producer of
 *		entries into this Ring has looped around the ring.
 */

#define REO_QUEUE_DESC_MAGIC_DEBUG_PATTERN_0 0xDDBEEF
#define REO_QUEUE_DESC_MAGIC_DEBUG_PATTERN_1 0xADBEEF
#define REO_QUEUE_DESC_MAGIC_DEBUG_PATTERN_2 0xBDBEEF
#define REO_QUEUE_DESC_MAGIC_DEBUG_PATTERN_3 0xCDBEEF

#define HAL_TX_ADDRX_EN			1
#define HAL_TX_ADDRY_EN			2

#define HAL_TX_ADDR_SEARCH_DEFAULT	0
#define HAL_TX_ADDR_SEARCH_INDEX	1

/* 
 * Copy Engine
 */

#define CE_COUNT_MAX 12

/* Byte swap data words */
#define CE_ATTR_BYTE_SWAP_DATA 2

/* no interrupt on copy completion */
#define CE_ATTR_DIS_INTR		8

/* Host software's Copy Engine configuration. */
#ifdef __BIG_ENDIAN
#define CE_ATTR_FLAGS CE_ATTR_BYTE_SWAP_DATA
#else
#define CE_ATTR_FLAGS 0
#endif

/* Threshold to poll for tx completion in case of Interrupt disabled CE's */
#define ATH11K_CE_USAGE_THRESHOLD 32

/*
 * Directions for interconnect pipe configuration.
 * These definitions may be used during configuration and are shared
 * between Host and Target.
 *
 * Pipe Directions are relative to the Host, so PIPEDIR_IN means
 * "coming IN over air through Target to Host" as with a WiFi Rx operation.
 * Conversely, PIPEDIR_OUT means "going OUT from Host through Target over air"
 * as with a WiFi Tx operation. This is somewhat awkward for the "middle-man"
 * Target since things that are "PIPEDIR_OUT" are coming IN to the Target
 * over the interconnect.
 */
#define PIPEDIR_NONE		0
#define PIPEDIR_IN		1 /* Target-->Host, WiFi Rx direction */
#define PIPEDIR_OUT		2 /* Host->Target, WiFi Tx direction */
#define PIPEDIR_INOUT		3 /* bidirectional */
#define PIPEDIR_INOUT_H2H	4 /* bidirectional, host to host */

/* CE address/mask */
#define CE_HOST_IE_ADDRESS	0x00A1803C
#define CE_HOST_IE_2_ADDRESS	0x00A18040
#define CE_HOST_IE_3_ADDRESS	CE_HOST_IE_ADDRESS

/* CE IE registers are different for IPQ5018 */
#define CE_HOST_IPQ5018_IE_ADDRESS		0x0841804C
#define CE_HOST_IPQ5018_IE_2_ADDRESS		0x08418050
#define CE_HOST_IPQ5018_IE_3_ADDRESS		CE_HOST_IPQ5018_IE_ADDRESS

#define CE_HOST_IE_3_SHIFT	0xC

#define CE_RING_IDX_INCR(nentries_mask, idx) (((idx) + 1) & (nentries_mask))

/*
 * Establish a mapping between a service/direction and a pipe.
 * Configuration information for a Copy Engine pipe and services.
 * Passed from Host to Target through QMI message and must be in
 * little endian format.
 */
struct service_to_pipe {
	uint32_t service_id;
	uint32_t pipedir;
	uint32_t pipenum;
};

/*
 * Configuration information for a Copy Engine pipe.
 * Passed from Host to Target through QMI message during startup (one per CE).
 *
 * NOTE: Structure is shared between Host software and Target firmware!
 */
struct ce_pipe_config {
	uint32_t pipenum;
	uint32_t pipedir;
	uint32_t nentries;
	uint32_t nbytes_max;
	uint32_t flags;
	uint32_t reserved;
};

/*
 * HTC
 */

#define HTC_HDR_ENDPOINTID                       GENMASK(7, 0)
#define HTC_HDR_FLAGS                            GENMASK(15, 8)
#define HTC_HDR_PAYLOADLEN                       GENMASK(31, 16)
#define HTC_HDR_CONTROLBYTES0                    GENMASK(7, 0)
#define HTC_HDR_CONTROLBYTES1                    GENMASK(15, 8)
#define HTC_HDR_RESERVED                         GENMASK(31, 16)

#define HTC_SVC_MSG_SERVICE_ID                   GENMASK(31, 16)
#define HTC_SVC_MSG_CONNECTIONFLAGS              GENMASK(15, 0)
#define HTC_SVC_MSG_SERVICEMETALENGTH            GENMASK(23, 16)
#define HTC_READY_MSG_CREDITCOUNT                GENMASK(31, 16)
#define HTC_READY_MSG_CREDITSIZE                 GENMASK(15, 0)
#define HTC_READY_MSG_MAXENDPOINTS               GENMASK(23, 16)

#define HTC_READY_EX_MSG_HTCVERSION              GENMASK(7, 0)
#define HTC_READY_EX_MSG_MAXMSGSPERHTCBUNDLE     GENMASK(15, 8)

#define HTC_SVC_RESP_MSG_SERVICEID           GENMASK(31, 16)
#define HTC_SVC_RESP_MSG_STATUS              GENMASK(7, 0)
#define HTC_SVC_RESP_MSG_ENDPOINTID          GENMASK(15, 8)
#define HTC_SVC_RESP_MSG_MAXMSGSIZE          GENMASK(31, 16)
#define HTC_SVC_RESP_MSG_SERVICEMETALENGTH   GENMASK(7, 0)

#define HTC_MSG_MESSAGEID                        GENMASK(15, 0)
#define HTC_SETUP_COMPLETE_EX_MSG_SETUPFLAGS     GENMASK(31, 0)
#define HTC_SETUP_COMPLETE_EX_MSG_MAXMSGSPERBUNDLEDRECV      GENMASK(7, 0)
#define HTC_SETUP_COMPLETE_EX_MSG_RSVD0          GENMASK(15, 8)
#define HTC_SETUP_COMPLETE_EX_MSG_RSVD1          GENMASK(23, 16)
#define HTC_SETUP_COMPLETE_EX_MSG_RSVD2          GENMASK(31, 24)

enum ath11k_htc_tx_flags {
	ATH11K_HTC_FLAG_NEED_CREDIT_UPDATE = 0x01,
	ATH11K_HTC_FLAG_SEND_BUNDLE        = 0x02
};

enum ath11k_htc_rx_flags {
	ATH11K_HTC_FLAG_TRAILER_PRESENT = 0x02,
	ATH11K_HTC_FLAG_BUNDLE_MASK     = 0xF0
};


struct ath11k_htc_hdr {
	uint32_t htc_info;
	uint32_t ctrl_info;
} __packed __aligned(4);

enum ath11k_htc_msg_id {
	ATH11K_HTC_MSG_READY_ID                = 1,
	ATH11K_HTC_MSG_CONNECT_SERVICE_ID      = 2,
	ATH11K_HTC_MSG_CONNECT_SERVICE_RESP_ID = 3,
	ATH11K_HTC_MSG_SETUP_COMPLETE_ID       = 4,
	ATH11K_HTC_MSG_SETUP_COMPLETE_EX_ID    = 5,
	ATH11K_HTC_MSG_SEND_SUSPEND_COMPLETE   = 6,
	ATH11K_HTC_MSG_NACK_SUSPEND	       = 7,
	ATH11K_HTC_MSG_WAKEUP_FROM_SUSPEND_ID  = 8,
};

enum ath11k_htc_version {
	ATH11K_HTC_VERSION_2P0 = 0x00, /* 2.0 */
	ATH11K_HTC_VERSION_2P1 = 0x01, /* 2.1 */
};

#define ATH11K_HTC_CONN_FLAGS_THRESHOLD_LEVEL_MASK GENMASK(1, 0)
#define ATH11K_HTC_CONN_FLAGS_RECV_ALLOC GENMASK(15, 8)

enum ath11k_htc_conn_flags {
	ATH11K_HTC_CONN_FLAGS_THRESHOLD_LEVEL_ONE_FOURTH    = 0x0,
	ATH11K_HTC_CONN_FLAGS_THRESHOLD_LEVEL_ONE_HALF      = 0x1,
	ATH11K_HTC_CONN_FLAGS_THRESHOLD_LEVEL_THREE_FOURTHS = 0x2,
	ATH11K_HTC_CONN_FLAGS_THRESHOLD_LEVEL_UNITY         = 0x3,
	ATH11K_HTC_CONN_FLAGS_REDUCE_CREDIT_DRIBBLE	    = 0x4,
	ATH11K_HTC_CONN_FLAGS_DISABLE_CREDIT_FLOW_CTRL	    = 0x8,
};

enum ath11k_htc_conn_svc_status {
	ATH11K_HTC_CONN_SVC_STATUS_SUCCESS      = 0,
	ATH11K_HTC_CONN_SVC_STATUS_NOT_FOUND    = 1,
	ATH11K_HTC_CONN_SVC_STATUS_FAILED       = 2,
	ATH11K_HTC_CONN_SVC_STATUS_NO_RESOURCES = 3,
	ATH11K_HTC_CONN_SVC_STATUS_NO_MORE_EP   = 4
};

struct ath11k_htc_ready {
	uint32_t id_credit_count;
	uint32_t size_ep;
} __packed;

struct ath11k_htc_ready_extended {
	struct ath11k_htc_ready base;
	uint32_t ver_bundle;
} __packed;

struct ath11k_htc_conn_svc {
	uint32_t msg_svc_id;
	uint32_t flags_len;
} __packed;

struct ath11k_htc_conn_svc_resp {
	uint32_t msg_svc_id;
	uint32_t flags_len;
	uint32_t svc_meta_pad;
} __packed;

#define ATH11K_GLOBAL_DISABLE_CREDIT_FLOW BIT(1)

struct ath11k_htc_setup_complete_extended {
	uint32_t msg_id;
	uint32_t flags;
	uint32_t max_msgs_per_bundled_recv;
} __packed;

struct ath11k_htc_msg {
	uint32_t msg_svc_id;
	uint32_t flags_len;
} __packed __aligned(4);

enum ath11k_htc_record_id {
	ATH11K_HTC_RECORD_NULL    = 0,
	ATH11K_HTC_RECORD_CREDITS = 1
};

struct ath11k_htc_record_hdr {
	uint8_t id; /* @enum ath11k_htc_record_id */
	uint8_t len;
	uint8_t pad0;
	uint8_t pad1;
} __packed;

struct ath11k_htc_credit_report {
	uint8_t eid; /* @enum ath11k_htc_ep_id */
	uint8_t credits;
	uint8_t pad0;
	uint8_t pad1;
} __packed;

struct ath11k_htc_record {
	struct ath11k_htc_record_hdr hdr;
	union {
		struct ath11k_htc_credit_report credit_report[0];
		uint8_t payload[0];
	};
} __packed __aligned(4);

/* note: the trailer offset is dynamic depending
 * on payload length. this is only a struct layout draft
 */
struct ath11k_htc_frame {
	struct ath11k_htc_hdr hdr;
	union {
		struct ath11k_htc_msg msg;
		uint8_t payload[0];
	};
	struct ath11k_htc_record trailer[0];
} __packed __aligned(4);

enum ath11k_htc_svc_gid {
	ATH11K_HTC_SVC_GRP_RSVD = 0,
	ATH11K_HTC_SVC_GRP_WMI = 1,
	ATH11K_HTC_SVC_GRP_NMI = 2,
	ATH11K_HTC_SVC_GRP_HTT = 3,
	ATH11K_HTC_SVC_GRP_CFG = 4,
	ATH11K_HTC_SVC_GRP_IPA = 5,
	ATH11K_HTC_SVC_GRP_PKTLOG = 6,

	ATH11K_HTC_SVC_GRP_TEST = 254,
	ATH11K_HTC_SVC_GRP_LAST = 255,
};

#define SVC(group, idx) \
	(int)(((int)(group) << 8) | (int)(idx))

enum ath11k_htc_svc_id {
	/* NOTE: service ID of 0x0000 is reserved and should never be used */
	ATH11K_HTC_SVC_ID_RESERVED	= 0x0000,
	ATH11K_HTC_SVC_ID_UNUSED	= ATH11K_HTC_SVC_ID_RESERVED,

	ATH11K_HTC_SVC_ID_RSVD_CTRL	= SVC(ATH11K_HTC_SVC_GRP_RSVD, 1),
	ATH11K_HTC_SVC_ID_WMI_CONTROL	= SVC(ATH11K_HTC_SVC_GRP_WMI, 0),
	ATH11K_HTC_SVC_ID_WMI_DATA_BE	= SVC(ATH11K_HTC_SVC_GRP_WMI, 1),
	ATH11K_HTC_SVC_ID_WMI_DATA_BK	= SVC(ATH11K_HTC_SVC_GRP_WMI, 2),
	ATH11K_HTC_SVC_ID_WMI_DATA_VI	= SVC(ATH11K_HTC_SVC_GRP_WMI, 3),
	ATH11K_HTC_SVC_ID_WMI_DATA_VO	= SVC(ATH11K_HTC_SVC_GRP_WMI, 4),
	ATH11K_HTC_SVC_ID_WMI_CONTROL_MAC1 = SVC(ATH11K_HTC_SVC_GRP_WMI, 5),
	ATH11K_HTC_SVC_ID_WMI_CONTROL_MAC2 = SVC(ATH11K_HTC_SVC_GRP_WMI, 6),

	ATH11K_HTC_SVC_ID_NMI_CONTROL	= SVC(ATH11K_HTC_SVC_GRP_NMI, 0),
	ATH11K_HTC_SVC_ID_NMI_DATA	= SVC(ATH11K_HTC_SVC_GRP_NMI, 1),

	ATH11K_HTC_SVC_ID_HTT_DATA_MSG	= SVC(ATH11K_HTC_SVC_GRP_HTT, 0),

	/* raw stream service (i.e. flash, tcmd, calibration apps) */
	ATH11K_HTC_SVC_ID_TEST_RAW_STREAMS = SVC(ATH11K_HTC_SVC_GRP_TEST, 0),
	ATH11K_HTC_SVC_ID_IPA_TX = SVC(ATH11K_HTC_SVC_GRP_IPA, 0),
	ATH11K_HTC_SVC_ID_PKT_LOG = SVC(ATH11K_HTC_SVC_GRP_PKTLOG, 0),
};

#undef SVC

enum ath11k_htc_ep_id {
	ATH11K_HTC_EP_UNUSED = -1,
	ATH11K_HTC_EP_0 = 0,
	ATH11K_HTC_EP_1 = 1,
	ATH11K_HTC_EP_2,
	ATH11K_HTC_EP_3,
	ATH11K_HTC_EP_4,
	ATH11K_HTC_EP_5,
	ATH11K_HTC_EP_6,
	ATH11K_HTC_EP_7,
	ATH11K_HTC_EP_8,
	ATH11K_HTC_EP_COUNT,
};

/*
 * hw.h
 */

/* Target configuration defines */

/* Num VDEVS per radio */
#define TARGET_NUM_VDEVS(sc)	(sc->hw_params.num_vdevs)

#define TARGET_NUM_PEERS_PDEV(sc) (sc->hw_params.num_peers + TARGET_NUM_VDEVS(sc))

/* Num of peers for Single Radio mode */
#define TARGET_NUM_PEERS_SINGLE(sc) (TARGET_NUM_PEERS_PDEV(sc))

/* Num of peers for DBS */
#define TARGET_NUM_PEERS_DBS(sc) (2 * TARGET_NUM_PEERS_PDEV(sc))

/* Num of peers for DBS_SBS */
#define TARGET_NUM_PEERS_DBS_SBS(sc)	(3 * TARGET_NUM_PEERS_PDEV(sc))

/* Max num of stations (per radio) */
#define TARGET_NUM_STATIONS(sc)	(sc->hw_params.num_peers)

#define TARGET_NUM_PEERS(sc, x)	TARGET_NUM_PEERS_##x(sc)
#define TARGET_NUM_PEER_KEYS	2
#define TARGET_NUM_TIDS(sc, x)	(2 * TARGET_NUM_PEERS(sc, x) +	\
				 4 * TARGET_NUM_VDEVS(sc) + 8)

#define TARGET_AST_SKID_LIMIT	16
#define TARGET_NUM_OFFLD_PEERS	4
#define TARGET_NUM_OFFLD_REORDER_BUFFS 4

#define TARGET_TX_CHAIN_MASK	(BIT(0) | BIT(1) | BIT(2) | BIT(4))
#define TARGET_RX_CHAIN_MASK	(BIT(0) | BIT(1) | BIT(2) | BIT(4))
#define TARGET_RX_TIMEOUT_LO_PRI	100
#define TARGET_RX_TIMEOUT_HI_PRI	40

#define TARGET_DECAP_MODE_RAW		0
#define TARGET_DECAP_MODE_NATIVE_WIFI	1
#define TARGET_DECAP_MODE_ETH		2

#define TARGET_SCAN_MAX_PENDING_REQS	4
#define TARGET_BMISS_OFFLOAD_MAX_VDEV	3
#define TARGET_ROAM_OFFLOAD_MAX_VDEV	3
#define TARGET_ROAM_OFFLOAD_MAX_AP_PROFILES	8
#define TARGET_GTK_OFFLOAD_MAX_VDEV	3
#define TARGET_NUM_MCAST_GROUPS		12
#define TARGET_NUM_MCAST_TABLE_ELEMS	64
#define TARGET_MCAST2UCAST_MODE		2
#define TARGET_TX_DBG_LOG_SIZE		1024
#define TARGET_RX_SKIP_DEFRAG_TIMEOUT_DUP_DETECTION_CHECK 1
#define TARGET_VOW_CONFIG		0
#define TARGET_NUM_MSDU_DESC		(2500)
#define TARGET_MAX_FRAG_ENTRIES		6
#define TARGET_MAX_BCN_OFFLD		16
#define TARGET_NUM_WDS_ENTRIES		32
#define TARGET_DMA_BURST_SIZE		1
#define TARGET_RX_BATCHMODE		1
#define TARGET_EMA_MAX_PROFILE_PERIOD	8

#define ATH11K_HW_MAX_QUEUES		4
#define ATH11K_QUEUE_LEN		4096

#define ATH11k_HW_RATECODE_CCK_SHORT_PREAM_MASK  0x4

enum ath11k_hw_rate_cck {
	ATH11K_HW_RATE_CCK_LP_11M = 0,
	ATH11K_HW_RATE_CCK_LP_5_5M,
	ATH11K_HW_RATE_CCK_LP_2M,
	ATH11K_HW_RATE_CCK_LP_1M,
	ATH11K_HW_RATE_CCK_SP_11M,
	ATH11K_HW_RATE_CCK_SP_5_5M,
	ATH11K_HW_RATE_CCK_SP_2M,
};

enum ath11k_hw_rate_ofdm {
	ATH11K_HW_RATE_OFDM_48M = 0,
	ATH11K_HW_RATE_OFDM_24M,
	ATH11K_HW_RATE_OFDM_12M,
	ATH11K_HW_RATE_OFDM_6M,
	ATH11K_HW_RATE_OFDM_54M,
	ATH11K_HW_RATE_OFDM_36M,
	ATH11K_HW_RATE_OFDM_18M,
	ATH11K_HW_RATE_OFDM_9M,
};

enum ath11k_bus {
	ATH11K_BUS_AHB,
	ATH11K_BUS_PCI,
};

#define ATH11K_EXT_IRQ_GRP_NUM_MAX 11

/*
 * rx_desc.h
 */

enum rx_desc_rxpcu_filter {
	RX_DESC_RXPCU_FILTER_PASS,
	RX_DESC_RXPCU_FILTER_MONITOR_CLIENT,
	RX_DESC_RXPCU_FILTER_MONITOR_OTHER,
};

/* rxpcu_filter_pass
 *		This MPDU passed the normal frame filter programming of rxpcu.
 *
 * rxpcu_filter_monitor_client
 *		 This MPDU did not pass the regular frame filter and would
 *		 have been dropped, were it not for the frame fitting into the
 *		 'monitor_client' category.
 *
 * rxpcu_filter_monitor_other
 *		This MPDU did not pass the regular frame filter and also did
 *		not pass the rxpcu_monitor_client filter. It would have been
 *		dropped accept that it did pass the 'monitor_other' category.
 */

#define RX_DESC_INFO0_RXPCU_MPDU_FITLER	GENMASK(1, 0)
#define RX_DESC_INFO0_SW_FRAME_GRP_ID	GENMASK(8, 2)

enum rx_desc_sw_frame_grp_id {
	RX_DESC_SW_FRAME_GRP_ID_NDP_FRAME,
	RX_DESC_SW_FRAME_GRP_ID_MCAST_DATA,
	RX_DESC_SW_FRAME_GRP_ID_UCAST_DATA,
	RX_DESC_SW_FRAME_GRP_ID_NULL_DATA,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0000,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0001,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0010,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0011,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0100,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0101,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0110,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_0111,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1000,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1001,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1010,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1011,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1100,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1101,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1110,
	RX_DESC_SW_FRAME_GRP_ID_MGMT_1111,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0000,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0001,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0010,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0011,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0100,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0101,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0110,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_0111,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1000,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1001,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1010,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1011,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1100,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1101,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1110,
	RX_DESC_SW_FRAME_GRP_ID_CTRL_1111,
	RX_DESC_SW_FRAME_GRP_ID_UNSUPPORTED,
	RX_DESC_SW_FRAME_GRP_ID_PHY_ERR,
};

#define DP_MAX_NWIFI_HDR_LEN	30

#define DP_RX_MPDU_ERR_FCS			BIT(0)
#define DP_RX_MPDU_ERR_DECRYPT			BIT(1)
#define DP_RX_MPDU_ERR_TKIP_MIC			BIT(2)
#define DP_RX_MPDU_ERR_AMSDU_ERR		BIT(3)
#define DP_RX_MPDU_ERR_OVERFLOW			BIT(4)
#define DP_RX_MPDU_ERR_MSDU_LEN			BIT(5)
#define DP_RX_MPDU_ERR_MPDU_LEN			BIT(6)
#define DP_RX_MPDU_ERR_UNENCRYPTED_FRAME	BIT(7)

enum dp_rx_decap_type {
	DP_RX_DECAP_TYPE_RAW,
	DP_RX_DECAP_TYPE_NATIVE_WIFI,
	DP_RX_DECAP_TYPE_ETHERNET2_DIX,
	DP_RX_DECAP_TYPE_8023,
};

enum rx_desc_decap_type {
	RX_DESC_DECAP_TYPE_RAW,
	RX_DESC_DECAP_TYPE_NATIVE_WIFI,
	RX_DESC_DECAP_TYPE_ETHERNET2_DIX,
	RX_DESC_DECAP_TYPE_8023,
};

enum rx_desc_decrypt_status_code {
	RX_DESC_DECRYPT_STATUS_CODE_OK,
	RX_DESC_DECRYPT_STATUS_CODE_UNPROTECTED_FRAME,
	RX_DESC_DECRYPT_STATUS_CODE_DATA_ERR,
	RX_DESC_DECRYPT_STATUS_CODE_KEY_INVALID,
	RX_DESC_DECRYPT_STATUS_CODE_PEER_ENTRY_INVALID,
	RX_DESC_DECRYPT_STATUS_CODE_OTHER,
};

#define RX_ATTENTION_INFO1_FIRST_MPDU		BIT(0)
#define RX_ATTENTION_INFO1_RSVD_1A		BIT(1)
#define RX_ATTENTION_INFO1_MCAST_BCAST		BIT(2)
#define RX_ATTENTION_INFO1_AST_IDX_NOT_FOUND	BIT(3)
#define RX_ATTENTION_INFO1_AST_IDX_TIMEDOUT	BIT(4)
#define RX_ATTENTION_INFO1_POWER_MGMT		BIT(5)
#define RX_ATTENTION_INFO1_NON_QOS		BIT(6)
#define RX_ATTENTION_INFO1_NULL_DATA		BIT(7)
#define RX_ATTENTION_INFO1_MGMT_TYPE		BIT(8)
#define RX_ATTENTION_INFO1_CTRL_TYPE		BIT(9)
#define RX_ATTENTION_INFO1_MORE_DATA		BIT(10)
#define RX_ATTENTION_INFO1_EOSP			BIT(11)
#define RX_ATTENTION_INFO1_A_MSDU_ERROR		BIT(12)
#define RX_ATTENTION_INFO1_FRAGMENT		BIT(13)
#define RX_ATTENTION_INFO1_ORDER		BIT(14)
#define RX_ATTENTION_INFO1_CCE_MATCH		BIT(15)
#define RX_ATTENTION_INFO1_OVERFLOW_ERR		BIT(16)
#define RX_ATTENTION_INFO1_MSDU_LEN_ERR		BIT(17)
#define RX_ATTENTION_INFO1_TCP_UDP_CKSUM_FAIL	BIT(18)
#define RX_ATTENTION_INFO1_IP_CKSUM_FAIL	BIT(19)
#define RX_ATTENTION_INFO1_SA_IDX_INVALID	BIT(20)
#define RX_ATTENTION_INFO1_DA_IDX_INVALID	BIT(21)
#define RX_ATTENTION_INFO1_RSVD_1B		BIT(22)
#define RX_ATTENTION_INFO1_RX_IN_TX_DECRYPT_BYP	BIT(23)
#define RX_ATTENTION_INFO1_ENCRYPT_REQUIRED	BIT(24)
#define RX_ATTENTION_INFO1_DIRECTED		BIT(25)
#define RX_ATTENTION_INFO1_BUFFER_FRAGMENT	BIT(26)
#define RX_ATTENTION_INFO1_MPDU_LEN_ERR		BIT(27)
#define RX_ATTENTION_INFO1_TKIP_MIC_ERR		BIT(28)
#define RX_ATTENTION_INFO1_DECRYPT_ERR		BIT(29)
#define RX_ATTENTION_INFO1_UNDECRYPT_FRAME_ERR	BIT(30)
#define RX_ATTENTION_INFO1_FCS_ERR		BIT(31)

#define RX_ATTENTION_INFO2_FLOW_IDX_TIMEOUT	BIT(0)
#define RX_ATTENTION_INFO2_FLOW_IDX_INVALID	BIT(1)
#define RX_ATTENTION_INFO2_WIFI_PARSER_ERR	BIT(2)
#define RX_ATTENTION_INFO2_AMSDU_PARSER_ERR	BIT(3)
#define RX_ATTENTION_INFO2_SA_IDX_TIMEOUT	BIT(4)
#define RX_ATTENTION_INFO2_DA_IDX_TIMEOUT	BIT(5)
#define RX_ATTENTION_INFO2_MSDU_LIMIT_ERR	BIT(6)
#define RX_ATTENTION_INFO2_DA_IS_VALID		BIT(7)
#define RX_ATTENTION_INFO2_DA_IS_MCBC		BIT(8)
#define RX_ATTENTION_INFO2_SA_IS_VALID		BIT(9)
#define RX_ATTENTION_INFO2_DCRYPT_STATUS_CODE	GENMASK(12, 10)
#define RX_ATTENTION_INFO2_RX_BITMAP_NOT_UPDED	BIT(13)
#define RX_ATTENTION_INFO2_MSDU_DONE		BIT(31)

struct rx_attention {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint32_t info1;
	uint32_t info2;
} __packed;

/* rx_attention
 *
 * rxpcu_mpdu_filter_in_category
 *		Field indicates what the reason was that this mpdu frame
 *		was allowed to come into the receive path by rxpcu. Values
 *		are defined in enum %RX_DESC_RXPCU_FILTER_*.
 *
 * sw_frame_group_id
 *		SW processes frames based on certain classifications. Values
 *		are defined in enum %RX_DESC_SW_FRAME_GRP_ID_*.
 *
 * phy_ppdu_id
 *		A ppdu counter value that PHY increments for every PPDU
 *		received. The counter value wraps around.
 *
 * first_mpdu
 *		Indicates the first MSDU of the PPDU.  If both first_mpdu
 *		and last_mpdu are set in the MSDU then this is a not an
 *		A-MPDU frame but a stand alone MPDU.  Interior MPDU in an
 *		A-MPDU shall have both first_mpdu and last_mpdu bits set to
 *		0.  The PPDU start status will only be valid when this bit
 *		is set.
 *
 * mcast_bcast
 *		Multicast / broadcast indicator.  Only set when the MAC
 *		address 1 bit 0 is set indicating mcast/bcast and the BSSID
 *		matches one of the 4 BSSID registers. Only set when
 *		first_msdu is set.
 *
 * ast_index_not_found
 *		Only valid when first_msdu is set. Indicates no AST matching
 *		entries within the max search count.
 *
 * ast_index_timeout
 *		Only valid when first_msdu is set. Indicates an unsuccessful
 *		search in the address search table due to timeout.
 *
 * power_mgmt
 *		Power management bit set in the 802.11 header.  Only set
 *		when first_msdu is set.
 *
 * non_qos
 *		Set if packet is not a non-QoS data frame.  Only set when
 *		first_msdu is set.
 *
 * null_data
 *		Set if frame type indicates either null data or QoS null
 *		data format.  Only set when first_msdu is set.
 *
 * mgmt_type
 *		Set if packet is a management packet.  Only set when
 *		first_msdu is set.
 *
 * ctrl_type
 *		Set if packet is a control packet.  Only set when first_msdu
 *		is set.
 *
 * more_data
 *		Set if more bit in frame control is set.  Only set when
 *		first_msdu is set.
 *
 * eosp
 *		Set if the EOSP (end of service period) bit in the QoS
 *		control field is set.  Only set when first_msdu is set.
 *
 * a_msdu_error
 *		Set if number of MSDUs in A-MSDU is above a threshold or if the
 *		size of the MSDU is invalid. This receive buffer will contain
 *		all of the remainder of MSDUs in this MPDU w/o decapsulation.
 *
 * fragment
 *		Indicates that this is an 802.11 fragment frame.  This is
 *		set when either the more_frag bit is set in the frame
 *		control or the fragment number is not zero.  Only set when
 *		first_msdu is set.
 *
 * order
 *		Set if the order bit in the frame control is set.  Only set
 *		when first_msdu is set.
 *
 * cce_match
 *		Indicates that this status has a corresponding MSDU that
 *		requires FW processing. The OLE will have classification
 *		ring mask registers which will indicate the ring(s) for
 *		packets and descriptors which need FW attention.
 *
 * overflow_err
 *		PCU Receive FIFO does not have enough space to store the
 *		full receive packet.  Enough space is reserved in the
 *		receive FIFO for the status is written.  This MPDU remaining
 *		packets in the PPDU will be filtered and no Ack response
 *		will be transmitted.
 *
 * msdu_length_err
 *		Indicates that the MSDU length from the 802.3 encapsulated
 *		length field extends beyond the MPDU boundary.
 *
 * tcp_udp_chksum_fail
 *		Indicates that the computed checksum (tcp_udp_chksum) did
 *		not match the checksum in the TCP/UDP header.
 *
 * ip_chksum_fail
 *		Indicates that the computed checksum did not match the
 *		checksum in the IP header.
 *
 * sa_idx_invalid
 *		Indicates no matching entry was found in the address search
 *		table for the source MAC address.
 *
 * da_idx_invalid
 *		Indicates no matching entry was found in the address search
 *		table for the destination MAC address.
 *
 * rx_in_tx_decrypt_byp
 *		Indicates that RX packet is not decrypted as Crypto is busy
 *		with TX packet processing.
 *
 * encrypt_required
 *		Indicates that this data type frame is not encrypted even if
 *		the policy for this MPDU requires encryption as indicated in
 *		the peer table key type.
 *
 * directed
 *		MPDU is a directed packet which means that the RA matched
 *		our STA addresses.  In proxySTA it means that the TA matched
 *		an entry in our address search table with the corresponding
 *		'no_ack' bit is the address search entry cleared.
 *
 * buffer_fragment
 *		Indicates that at least one of the rx buffers has been
 *		fragmented.  If set the FW should look at the rx_frag_info
 *		descriptor described below.
 *
 * mpdu_length_err
 *		Indicates that the MPDU was pre-maturely terminated
 *		resulting in a truncated MPDU.  Don't trust the MPDU length
 *		field.
 *
 * tkip_mic_err
 *		Indicates that the MPDU Michael integrity check failed
 *
 * decrypt_err
 *		Indicates that the MPDU decrypt integrity check failed
 *
 * fcs_err
 *		Indicates that the MPDU FCS check failed
 *
 * flow_idx_timeout
 *		Indicates an unsuccessful flow search due to the expiring of
 *		the search timer.
 *
 * flow_idx_invalid
 *		flow id is not valid.
 *
 * amsdu_parser_error
 *		A-MSDU could not be properly de-agregated.
 *
 * sa_idx_timeout
 *		Indicates an unsuccessful search for the source MAC address
 *		due to the expiring of the search timer.
 *
 * da_idx_timeout
 *		Indicates an unsuccessful search for the destination MAC
 *		address due to the expiring of the search timer.
 *
 * msdu_limit_error
 *		Indicates that the MSDU threshold was exceeded and thus
 *		all the rest of the MSDUs will not be scattered and will not
 *		be decapsulated but will be DMA'ed in RAW format as a single
 *		MSDU buffer.
 *
 * da_is_valid
 *		Indicates that OLE found a valid DA entry.
 *
 * da_is_mcbc
 *		Field Only valid if da_is_valid is set. Indicates the DA address
 *		was a Multicast or Broadcast address.
 *
 * sa_is_valid
 *		Indicates that OLE found a valid SA entry.
 *
 * decrypt_status_code
 *		Field provides insight into the decryption performed. Values are
 *		defined in enum %RX_DESC_DECRYPT_STATUS_CODE*.
 *
 * rx_bitmap_not_updated
 *		Frame is received, but RXPCU could not update the receive bitmap
 *		due to (temporary) fifo constraints.
 *
 * msdu_done
 *		If set indicates that the RX packet data, RX header data, RX
 *		PPDU start descriptor, RX MPDU start/end descriptor, RX MSDU
 *		start/end descriptors and RX Attention descriptor are all
 *		valid.  This bit must be in the last octet of the
 *		descriptor.
 */

#define RX_MPDU_START_INFO0_NDP_FRAME		BIT(9)
#define RX_MPDU_START_INFO0_PHY_ERR		BIT(10)
#define RX_MPDU_START_INFO0_PHY_ERR_MPDU_HDR	BIT(11)
#define RX_MPDU_START_INFO0_PROTO_VER_ERR	BIT(12)
#define RX_MPDU_START_INFO0_AST_LOOKUP_VALID	BIT(13)

#define RX_MPDU_START_INFO1_MPDU_FCTRL_VALID	BIT(0)
#define RX_MPDU_START_INFO1_MPDU_DUR_VALID	BIT(1)
#define RX_MPDU_START_INFO1_MAC_ADDR1_VALID	BIT(2)
#define RX_MPDU_START_INFO1_MAC_ADDR2_VALID	BIT(3)
#define RX_MPDU_START_INFO1_MAC_ADDR3_VALID	BIT(4)
#define RX_MPDU_START_INFO1_MAC_ADDR4_VALID	BIT(5)
#define RX_MPDU_START_INFO1_MPDU_SEQ_CTRL_VALID	BIT(6)
#define RX_MPDU_START_INFO1_MPDU_QOS_CTRL_VALID	BIT(7)
#define RX_MPDU_START_INFO1_MPDU_HT_CTRL_VALID	BIT(8)
#define RX_MPDU_START_INFO1_ENCRYPT_INFO_VALID	BIT(9)
#define RX_MPDU_START_INFO1_MPDU_FRAG_NUMBER	GENMASK(13, 10)
#define RX_MPDU_START_INFO1_MORE_FRAG_FLAG	BIT(14)
#define RX_MPDU_START_INFO1_FROM_DS		BIT(16)
#define RX_MPDU_START_INFO1_TO_DS		BIT(17)
#define RX_MPDU_START_INFO1_ENCRYPTED		BIT(18)
#define RX_MPDU_START_INFO1_MPDU_RETRY		BIT(19)
#define RX_MPDU_START_INFO1_MPDU_SEQ_NUM	GENMASK(31, 20)

#define RX_MPDU_START_INFO2_EPD_EN		BIT(0)
#define RX_MPDU_START_INFO2_ALL_FRAME_ENCPD	BIT(1)
#define RX_MPDU_START_INFO2_ENC_TYPE		GENMASK(5, 2)
#define RX_MPDU_START_INFO2_VAR_WEP_KEY_WIDTH	GENMASK(7, 6)
#define RX_MPDU_START_INFO2_MESH_STA		BIT(8)
#define RX_MPDU_START_INFO2_BSSID_HIT		BIT(9)
#define RX_MPDU_START_INFO2_BSSID_NUM		GENMASK(13, 10)
#define RX_MPDU_START_INFO2_TID			GENMASK(17, 14)
#define RX_MPDU_START_INFO2_TID_WCN6855		GENMASK(18, 15)

#define RX_MPDU_START_INFO3_REO_DEST_IND		GENMASK(4, 0)
#define RX_MPDU_START_INFO3_FLOW_ID_TOEPLITZ		BIT(7)
#define RX_MPDU_START_INFO3_PKT_SEL_FP_UCAST_DATA	BIT(8)
#define RX_MPDU_START_INFO3_PKT_SEL_FP_MCAST_DATA	BIT(9)
#define RX_MPDU_START_INFO3_PKT_SEL_FP_CTRL_BAR		BIT(10)
#define RX_MPDU_START_INFO3_RXDMA0_SRC_RING_SEL		GENMASK(12, 11)
#define RX_MPDU_START_INFO3_RXDMA0_DST_RING_SEL		GENMASK(14, 13)

#define RX_MPDU_START_INFO4_REO_QUEUE_DESC_HI	GENMASK(7, 0)
#define RX_MPDU_START_INFO4_RECV_QUEUE_NUM	GENMASK(23, 8)
#define RX_MPDU_START_INFO4_PRE_DELIM_ERR_WARN	BIT(24)
#define RX_MPDU_START_INFO4_FIRST_DELIM_ERR	BIT(25)

#define RX_MPDU_START_INFO5_KEY_ID		GENMASK(7, 0)
#define RX_MPDU_START_INFO5_NEW_PEER_ENTRY	BIT(8)
#define RX_MPDU_START_INFO5_DECRYPT_NEEDED	BIT(9)
#define RX_MPDU_START_INFO5_DECAP_TYPE		GENMASK(11, 10)
#define RX_MPDU_START_INFO5_VLAN_TAG_C_PADDING	BIT(12)
#define RX_MPDU_START_INFO5_VLAN_TAG_S_PADDING	BIT(13)
#define RX_MPDU_START_INFO5_STRIP_VLAN_TAG_C	BIT(14)
#define RX_MPDU_START_INFO5_STRIP_VLAN_TAG_S	BIT(15)
#define RX_MPDU_START_INFO5_PRE_DELIM_COUNT	GENMASK(27, 16)
#define RX_MPDU_START_INFO5_AMPDU_FLAG		BIT(28)
#define RX_MPDU_START_INFO5_BAR_FRAME		BIT(29)

#define RX_MPDU_START_INFO6_MPDU_LEN		GENMASK(13, 0)
#define RX_MPDU_START_INFO6_FIRST_MPDU		BIT(14)
#define RX_MPDU_START_INFO6_MCAST_BCAST		BIT(15)
#define RX_MPDU_START_INFO6_AST_IDX_NOT_FOUND	BIT(16)
#define RX_MPDU_START_INFO6_AST_IDX_TIMEOUT	BIT(17)
#define RX_MPDU_START_INFO6_POWER_MGMT		BIT(18)
#define RX_MPDU_START_INFO6_NON_QOS		BIT(19)
#define RX_MPDU_START_INFO6_NULL_DATA		BIT(20)
#define RX_MPDU_START_INFO6_MGMT_TYPE		BIT(21)
#define RX_MPDU_START_INFO6_CTRL_TYPE		BIT(22)
#define RX_MPDU_START_INFO6_MORE_DATA		BIT(23)
#define RX_MPDU_START_INFO6_EOSP		BIT(24)
#define RX_MPDU_START_INFO6_FRAGMENT		BIT(25)
#define RX_MPDU_START_INFO6_ORDER		BIT(26)
#define RX_MPDU_START_INFO6_UAPSD_TRIGGER	BIT(27)
#define RX_MPDU_START_INFO6_ENCRYPT_REQUIRED	BIT(28)
#define RX_MPDU_START_INFO6_DIRECTED		BIT(29)

#define RX_MPDU_START_RAW_MPDU			BIT(0)

struct rx_mpdu_start_ipq8074 {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint16_t ast_index;
	uint16_t sw_peer_id;
	uint32_t info1;
	uint32_t info2;
	uint32_t pn[4];
	uint32_t peer_meta_data;
	uint32_t info3;
	uint32_t reo_queue_desc_lo;
	uint32_t info4;
	uint32_t info5;
	uint32_t info6;
	uint16_t frame_ctrl;
	uint16_t duration;
	uint8_t addr1[IEEE80211_ADDR_LEN];
	uint8_t addr2[IEEE80211_ADDR_LEN];
	uint8_t addr3[IEEE80211_ADDR_LEN];
	uint16_t seq_ctrl;
	uint8_t addr4[IEEE80211_ADDR_LEN];
	uint16_t qos_ctrl;
	uint32_t ht_ctrl;
	uint32_t raw;
} __packed;

#define RX_MPDU_START_INFO7_REO_DEST_IND		GENMASK(4, 0)
#define RX_MPDU_START_INFO7_LMAC_PEER_ID_MSB		GENMASK(6, 5)
#define RX_MPDU_START_INFO7_FLOW_ID_TOEPLITZ		BIT(7)
#define RX_MPDU_START_INFO7_PKT_SEL_FP_UCAST_DATA	BIT(8)
#define RX_MPDU_START_INFO7_PKT_SEL_FP_MCAST_DATA	BIT(9)
#define RX_MPDU_START_INFO7_PKT_SEL_FP_CTRL_BAR		BIT(10)
#define RX_MPDU_START_INFO7_RXDMA0_SRC_RING_SEL		GENMASK(12, 11)
#define RX_MPDU_START_INFO7_RXDMA0_DST_RING_SEL		GENMASK(14, 13)

#define RX_MPDU_START_INFO8_REO_QUEUE_DESC_HI		GENMASK(7, 0)
#define RX_MPDU_START_INFO8_RECV_QUEUE_NUM		GENMASK(23, 8)
#define RX_MPDU_START_INFO8_PRE_DELIM_ERR_WARN		BIT(24)
#define RX_MPDU_START_INFO8_FIRST_DELIM_ERR		BIT(25)

#define RX_MPDU_START_INFO9_EPD_EN			BIT(0)
#define RX_MPDU_START_INFO9_ALL_FRAME_ENCPD		BIT(1)
#define RX_MPDU_START_INFO9_ENC_TYPE			GENMASK(5, 2)
#define RX_MPDU_START_INFO9_VAR_WEP_KEY_WIDTH		GENMASK(7, 6)
#define RX_MPDU_START_INFO9_MESH_STA			GENMASK(9, 8)
#define RX_MPDU_START_INFO9_BSSID_HIT			BIT(10)
#define RX_MPDU_START_INFO9_BSSID_NUM			GENMASK(14, 11)
#define RX_MPDU_START_INFO9_TID				GENMASK(18, 15)

#define RX_MPDU_START_INFO10_RXPCU_MPDU_FLTR		GENMASK(1, 0)
#define RX_MPDU_START_INFO10_SW_FRAME_GRP_ID		GENMASK(8, 2)
#define RX_MPDU_START_INFO10_NDP_FRAME			BIT(9)
#define RX_MPDU_START_INFO10_PHY_ERR			BIT(10)
#define RX_MPDU_START_INFO10_PHY_ERR_MPDU_HDR		BIT(11)
#define RX_MPDU_START_INFO10_PROTO_VER_ERR		BIT(12)
#define RX_MPDU_START_INFO10_AST_LOOKUP_VALID		BIT(13)

#define RX_MPDU_START_INFO11_MPDU_FCTRL_VALID		BIT(0)
#define RX_MPDU_START_INFO11_MPDU_DUR_VALID		BIT(1)
#define RX_MPDU_START_INFO11_MAC_ADDR1_VALID		BIT(2)
#define RX_MPDU_START_INFO11_MAC_ADDR2_VALID		BIT(3)
#define RX_MPDU_START_INFO11_MAC_ADDR3_VALID		BIT(4)
#define RX_MPDU_START_INFO11_MAC_ADDR4_VALID		BIT(5)
#define RX_MPDU_START_INFO11_MPDU_SEQ_CTRL_VALID	BIT(6)
#define RX_MPDU_START_INFO11_MPDU_QOS_CTRL_VALID	BIT(7)
#define RX_MPDU_START_INFO11_MPDU_HT_CTRL_VALID		BIT(8)
#define RX_MPDU_START_INFO11_ENCRYPT_INFO_VALID		BIT(9)
#define RX_MPDU_START_INFO11_MPDU_FRAG_NUMBER		GENMASK(13, 10)
#define RX_MPDU_START_INFO11_MORE_FRAG_FLAG		BIT(14)
#define RX_MPDU_START_INFO11_FROM_DS			BIT(16)
#define RX_MPDU_START_INFO11_TO_DS			BIT(17)
#define RX_MPDU_START_INFO11_ENCRYPTED			BIT(18)
#define RX_MPDU_START_INFO11_MPDU_RETRY			BIT(19)
#define RX_MPDU_START_INFO11_MPDU_SEQ_NUM		GENMASK(31, 20)

#define RX_MPDU_START_INFO12_KEY_ID			GENMASK(7, 0)
#define RX_MPDU_START_INFO12_NEW_PEER_ENTRY		BIT(8)
#define RX_MPDU_START_INFO12_DECRYPT_NEEDED		BIT(9)
#define RX_MPDU_START_INFO12_DECAP_TYPE			GENMASK(11, 10)
#define RX_MPDU_START_INFO12_VLAN_TAG_C_PADDING		BIT(12)
#define RX_MPDU_START_INFO12_VLAN_TAG_S_PADDING		BIT(13)
#define RX_MPDU_START_INFO12_STRIP_VLAN_TAG_C		BIT(14)
#define RX_MPDU_START_INFO12_STRIP_VLAN_TAG_S		BIT(15)
#define RX_MPDU_START_INFO12_PRE_DELIM_COUNT		GENMASK(27, 16)
#define RX_MPDU_START_INFO12_AMPDU_FLAG			BIT(28)
#define RX_MPDU_START_INFO12_BAR_FRAME			BIT(29)
#define RX_MPDU_START_INFO12_RAW_MPDU			BIT(30)

#define RX_MPDU_START_INFO13_MPDU_LEN			GENMASK(13, 0)
#define RX_MPDU_START_INFO13_FIRST_MPDU			BIT(14)
#define RX_MPDU_START_INFO13_MCAST_BCAST		BIT(15)
#define RX_MPDU_START_INFO13_AST_IDX_NOT_FOUND		BIT(16)
#define RX_MPDU_START_INFO13_AST_IDX_TIMEOUT		BIT(17)
#define RX_MPDU_START_INFO13_POWER_MGMT			BIT(18)
#define RX_MPDU_START_INFO13_NON_QOS			BIT(19)
#define RX_MPDU_START_INFO13_NULL_DATA			BIT(20)
#define RX_MPDU_START_INFO13_MGMT_TYPE			BIT(21)
#define RX_MPDU_START_INFO13_CTRL_TYPE			BIT(22)
#define RX_MPDU_START_INFO13_MORE_DATA			BIT(23)
#define RX_MPDU_START_INFO13_EOSP			BIT(24)
#define RX_MPDU_START_INFO13_FRAGMENT			BIT(25)
#define RX_MPDU_START_INFO13_ORDER			BIT(26)
#define RX_MPDU_START_INFO13_UAPSD_TRIGGER		BIT(27)
#define RX_MPDU_START_INFO13_ENCRYPT_REQUIRED		BIT(28)
#define RX_MPDU_START_INFO13_DIRECTED			BIT(29)
#define RX_MPDU_START_INFO13_AMSDU_PRESENT		BIT(30)

struct rx_mpdu_start_qcn9074 {
	uint32_t info7;
	uint32_t reo_queue_desc_lo;
	uint32_t info8;
	uint32_t pn[4];
	uint32_t info9;
	uint32_t peer_meta_data;
	uint16_t info10;
	uint16_t phy_ppdu_id;
	uint16_t ast_index;
	uint16_t sw_peer_id;
	uint32_t info11;
	uint32_t info12;
	uint32_t info13;
	uint16_t frame_ctrl;
	uint16_t duration;
	uint8_t addr1[IEEE80211_ADDR_LEN];
	uint8_t addr2[IEEE80211_ADDR_LEN];
	uint8_t addr3[IEEE80211_ADDR_LEN];
	uint16_t seq_ctrl;
	uint8_t addr4[IEEE80211_ADDR_LEN];
	uint16_t qos_ctrl;
	uint32_t ht_ctrl;
} __packed;

struct rx_mpdu_start_wcn6855 {
	uint32_t info3;
	uint32_t reo_queue_desc_lo;
	uint32_t info4;
	uint32_t pn[4];
	uint32_t info2;
	uint32_t peer_meta_data;
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint16_t ast_index;
	uint16_t sw_peer_id;
	uint32_t info1;
	uint32_t info5;
	uint32_t info6;
	uint16_t frame_ctrl;
	uint16_t duration;
	uint8_t addr1[IEEE80211_ADDR_LEN];
	uint8_t addr2[IEEE80211_ADDR_LEN];
	uint8_t addr3[IEEE80211_ADDR_LEN];
	uint16_t seq_ctrl;
	uint8_t addr4[IEEE80211_ADDR_LEN];
	uint16_t qos_ctrl;
	uint32_t ht_ctrl;
} __packed;

/* rx_mpdu_start
 *
 * rxpcu_mpdu_filter_in_category
 *		Field indicates what the reason was that this mpdu frame
 *		was allowed to come into the receive path by rxpcu. Values
 *		are defined in enum %RX_DESC_RXPCU_FILTER_*.
 *		Note: for ndp frame, if it was expected because the preceding
 *		NDPA was filter_pass, the setting rxpcu_filter_pass will be
 *		used. This setting will also be used for every ndp frame in
 *		case Promiscuous mode is enabled.
 *
 * sw_frame_group_id
 *		SW processes frames based on certain classifications. Values
 *		are defined in enum %RX_DESC_SW_FRAME_GRP_ID_*.
 *
 * ndp_frame
 *		Indicates that the received frame was an NDP frame.
 *
 * phy_err
 *		Indicates that PHY error was received before MAC received data.
 *
 * phy_err_during_mpdu_header
 *		PHY error was received before MAC received the complete MPDU
 *		header which was needed for proper decoding.
 *
 * protocol_version_err
 *		RXPCU detected a version error in the frame control field.
 *
 * ast_based_lookup_valid
 *		AST based lookup for this frame has found a valid result.
 *
 * phy_ppdu_id
 *		A ppdu counter value that PHY increments for every PPDU
 *		received. The counter value wraps around.
 *
 * ast_index
 *		This field indicates the index of the AST entry corresponding
 *		to this MPDU. It is provided by the GSE module instantiated in
 *		RXPCU. A value of 0xFFFF indicates an invalid AST index.
 *
 * sw_peer_id
 *		This field indicates a unique peer identifier. It is set equal
 *		to field 'sw_peer_id' from the AST entry.
 *
 * mpdu_frame_control_valid, mpdu_duration_valid, mpdu_qos_control_valid,
 * mpdu_ht_control_valid, frame_encryption_info_valid
 *		Indicates that each fields have valid entries.
 *
 * mac_addr_adx_valid
 *		Corresponding mac_addr_adx_{lo/hi} has valid entries.
 *
 * from_ds, to_ds
 *		Valid only when mpdu_frame_control_valid is set. Indicates that
 *		frame is received from DS and sent to DS.
 *
 * encrypted
 *		Protected bit from the frame control.
 *
 * mpdu_retry
 *		Retry bit from frame control. Only valid when first_msdu is set.
 *
 * mpdu_sequence_number
 *		The sequence number from the 802.11 header.
 *
 * epd_en
 *		If set, use EPD instead of LPD.
 *
 * all_frames_shall_be_encrypted
 *		If set, all frames (data only?) shall be encrypted. If not,
 *		RX CRYPTO shall set an error flag.
 *
 * encrypt_type
 *		Values are defined in enum %HAL_ENCRYPT_TYPE_.
 *
 * mesh_sta
 *		Indicates a Mesh (11s) STA.
 *
 * bssid_hit
 *		 BSSID of the incoming frame matched one of the 8 BSSID
 *		 register values.
 *
 * bssid_number
 *		This number indicates which one out of the 8 BSSID register
 *		values matched the incoming frame.
 *
 * tid
 *		TID field in the QoS control field
 *
 * pn
 *		The PN number.
 *
 * peer_meta_data
 *		Meta data that SW has programmed in the Peer table entry
 *		of the transmitting STA.
 *
 * rx_reo_queue_desc_addr_lo
 *		Address (lower 32 bits) of the REO queue descriptor.
 *
 * rx_reo_queue_desc_addr_hi
 *		Address (upper 8 bits) of the REO queue descriptor.
 *
 * receive_queue_number
 *		Indicates the MPDU queue ID to which this MPDU link
 *		descriptor belongs.
 *
 * pre_delim_err_warning
 *		Indicates that a delimiter FCS error was found in between the
 *		previous MPDU and this MPDU. Note that this is just a warning,
 *		and does not mean that this MPDU is corrupted in any way. If
 *		it is, there will be other errors indicated such as FCS or
 *		decrypt errors.
 *
 * first_delim_err
 *		Indicates that the first delimiter had a FCS failure.
 *
 * key_id
 *		The key ID octet from the IV.
 *
 * new_peer_entry
 *		Set if new RX_PEER_ENTRY TLV follows. If clear, RX_PEER_ENTRY
 *		doesn't follow so RX DECRYPTION module either uses old peer
 *		entry or not decrypt.
 *
 * decrypt_needed
 *		When RXPCU sets bit 'ast_index_not_found or ast_index_timeout',
 *		RXPCU will also ensure that this bit is NOT set. CRYPTO for that
 *		reason only needs to evaluate this bit and non of the other ones
 *
 * decap_type
 *		Used by the OLE during decapsulation. Values are defined in
 *		enum %MPDU_START_DECAP_TYPE_*.
 *
 * rx_insert_vlan_c_tag_padding
 * rx_insert_vlan_s_tag_padding
 *		Insert 4 byte of all zeros as VLAN tag or double VLAN tag if
 *		the rx payload does not have VLAN.
 *
 * strip_vlan_c_tag_decap
 * strip_vlan_s_tag_decap
 *		Strip VLAN or double VLAN during decapsulation.
 *
 * pre_delim_count
 *		The number of delimiters before this MPDU. Note that this
 *		number is cleared at PPDU start. If this MPDU is the first
 *		received MPDU in the PPDU and this MPDU gets filtered-in,
 *		this field will indicate the number of delimiters located
 *		after the last MPDU in the previous PPDU.
 *
 *		If this MPDU is located after the first received MPDU in
 *		an PPDU, this field will indicate the number of delimiters
 *		located between the previous MPDU and this MPDU.
 *
 * ampdu_flag
 *		Received frame was part of an A-MPDU.
 *
 * bar_frame
 *		Received frame is a BAR frame
 *
 * mpdu_length
 *		MPDU length before decapsulation.
 *
 * first_mpdu..directed
 *		See definition in RX attention descriptor
 *
 */

enum rx_msdu_start_pkt_type {
	RX_MSDU_START_PKT_TYPE_11A,
	RX_MSDU_START_PKT_TYPE_11B,
	RX_MSDU_START_PKT_TYPE_11N,
	RX_MSDU_START_PKT_TYPE_11AC,
	RX_MSDU_START_PKT_TYPE_11AX,
};

enum rx_msdu_start_sgi {
	RX_MSDU_START_SGI_0_8_US,
	RX_MSDU_START_SGI_0_4_US,
	RX_MSDU_START_SGI_1_6_US,
	RX_MSDU_START_SGI_3_2_US,
};

enum rx_msdu_start_recv_bw {
	RX_MSDU_START_RECV_BW_20MHZ,
	RX_MSDU_START_RECV_BW_40MHZ,
	RX_MSDU_START_RECV_BW_80MHZ,
	RX_MSDU_START_RECV_BW_160MHZ,
};

enum rx_msdu_start_reception_type {
	RX_MSDU_START_RECEPTION_TYPE_SU,
	RX_MSDU_START_RECEPTION_TYPE_DL_MU_MIMO,
	RX_MSDU_START_RECEPTION_TYPE_DL_MU_OFDMA,
	RX_MSDU_START_RECEPTION_TYPE_DL_MU_OFDMA_MIMO,
	RX_MSDU_START_RECEPTION_TYPE_UL_MU_MIMO,
	RX_MSDU_START_RECEPTION_TYPE_UL_MU_OFDMA,
	RX_MSDU_START_RECEPTION_TYPE_UL_MU_OFDMA_MIMO,
};

#define RX_MSDU_START_INFO1_MSDU_LENGTH		GENMASK(13, 0)
#define RX_MSDU_START_INFO1_RSVD_1A		BIT(14)
#define RX_MSDU_START_INFO1_IPSEC_ESP		BIT(15)
#define RX_MSDU_START_INFO1_L3_OFFSET		GENMASK(22, 16)
#define RX_MSDU_START_INFO1_IPSEC_AH		BIT(23)
#define RX_MSDU_START_INFO1_L4_OFFSET		GENMASK(31, 24)

#define RX_MSDU_START_INFO2_MSDU_NUMBER		GENMASK(7, 0)
#define RX_MSDU_START_INFO2_DECAP_TYPE		GENMASK(9, 8)
#define RX_MSDU_START_INFO2_IPV4		BIT(10)
#define RX_MSDU_START_INFO2_IPV6		BIT(11)
#define RX_MSDU_START_INFO2_TCP			BIT(12)
#define RX_MSDU_START_INFO2_UDP			BIT(13)
#define RX_MSDU_START_INFO2_IP_FRAG		BIT(14)
#define RX_MSDU_START_INFO2_TCP_ONLY_ACK	BIT(15)
#define RX_MSDU_START_INFO2_DA_IS_BCAST_MCAST	BIT(16)
#define RX_MSDU_START_INFO2_SELECTED_TOEPLITZ_HASH	GENMASK(18, 17)
#define RX_MSDU_START_INFO2_IP_FIXED_HDR_VALID		BIT(19)
#define RX_MSDU_START_INFO2_IP_EXTN_HDR_VALID		BIT(20)
#define RX_MSDU_START_INFO2_IP_TCP_UDP_HDR_VALID	BIT(21)
#define RX_MSDU_START_INFO2_MESH_CTRL_PRESENT		BIT(22)
#define RX_MSDU_START_INFO2_LDPC			BIT(23)
#define RX_MSDU_START_INFO2_IP4_IP6_NXT_HDR		GENMASK(31, 24)
#define RX_MSDU_START_INFO2_DECAP_FORMAT		GENMASK(9, 8)

#define RX_MSDU_START_INFO3_USER_RSSI		GENMASK(7, 0)
#define RX_MSDU_START_INFO3_PKT_TYPE		GENMASK(11, 8)
#define RX_MSDU_START_INFO3_STBC		BIT(12)
#define RX_MSDU_START_INFO3_SGI			GENMASK(14, 13)
#define RX_MSDU_START_INFO3_RATE_MCS		GENMASK(18, 15)
#define RX_MSDU_START_INFO3_RECV_BW		GENMASK(20, 19)
#define RX_MSDU_START_INFO3_RECEPTION_TYPE	GENMASK(23, 21)
#define RX_MSDU_START_INFO3_MIMO_SS_BITMAP	GENMASK(31, 24)

struct rx_msdu_start_ipq8074 {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint32_t info1;
	uint32_t info2;
	uint32_t toeplitz_hash;
	uint32_t flow_id_toeplitz;
	uint32_t info3;
	uint32_t ppdu_start_timestamp;
	uint32_t phy_meta_data;
} __packed;

struct rx_msdu_start_qcn9074 {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint32_t info1;
	uint32_t info2;
	uint32_t toeplitz_hash;
	uint32_t flow_id_toeplitz;
	uint32_t info3;
	uint32_t ppdu_start_timestamp;
	uint32_t phy_meta_data;
	uint16_t vlan_ctag_c1;
	uint16_t vlan_stag_c1;
} __packed;

struct rx_msdu_start_wcn6855 {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint32_t info1;
	uint32_t info2;
	uint32_t toeplitz_hash;
	uint32_t flow_id_toeplitz;
	uint32_t info3;
	uint32_t ppdu_start_timestamp;
	uint32_t phy_meta_data;
	uint16_t vlan_ctag_ci;
	uint16_t vlan_stag_ci;
} __packed;

/* rx_msdu_start
 *
 * rxpcu_mpdu_filter_in_category
 *		Field indicates what the reason was that this mpdu frame
 *		was allowed to come into the receive path by rxpcu. Values
 *		are defined in enum %RX_DESC_RXPCU_FILTER_*.
 *
 * sw_frame_group_id
 *		SW processes frames based on certain classifications. Values
 *		are defined in enum %RX_DESC_SW_FRAME_GRP_ID_*.
 *
 * phy_ppdu_id
 *		A ppdu counter value that PHY increments for every PPDU
 *		received. The counter value wraps around.
 *
 * msdu_length
 *		MSDU length in bytes after decapsulation.
 *
 * ipsec_esp
 *		Set if IPv4/v6 packet is using IPsec ESP.
 *
 * l3_offset
 *		Depending upon mode bit, this field either indicates the
 *		L3 offset in bytes from the start of the RX_HEADER or the IP
 *		offset in bytes from the start of the packet after
 *		decapsulation. The latter is only valid if ipv4_proto or
 *		ipv6_proto is set.
 *
 * ipsec_ah
 *		Set if IPv4/v6 packet is using IPsec AH
 *
 * l4_offset
 *		Depending upon mode bit, this field either indicates the
 *		L4 offset in bytes from the start of RX_HEADER (only valid
 *		if either ipv4_proto or ipv6_proto is set to 1) or indicates
 *		the offset in bytes to the start of TCP or UDP header from
 *		the start of the IP header after decapsulation (Only valid if
 *		tcp_proto or udp_proto is set). The value 0 indicates that
 *		the offset is longer than 127 bytes.
 *
 * msdu_number
 *		Indicates the MSDU number within a MPDU.  This value is
 *		reset to zero at the start of each MPDU.  If the number of
 *		MSDU exceeds 255 this number will wrap using modulo 256.
 *
 * decap_type
 *		Indicates the format after decapsulation. Values are defined in
 *		enum %MPDU_START_DECAP_TYPE_*.
 *
 * ipv4_proto
 *		Set if L2 layer indicates IPv4 protocol.
 *
 * ipv6_proto
 *		Set if L2 layer indicates IPv6 protocol.
 *
 * tcp_proto
 *		Set if the ipv4_proto or ipv6_proto are set and the IP protocol
 *		indicates TCP.
 *
 * udp_proto
 *		Set if the ipv4_proto or ipv6_proto are set and the IP protocol
 *		indicates UDP.
 *
 * ip_frag
 *		Indicates that either the IP More frag bit is set or IP frag
 *		number is non-zero.  If set indicates that this is a fragmented
 *		IP packet.
 *
 * tcp_only_ack
 *		Set if only the TCP Ack bit is set in the TCP flags and if
 *		the TCP payload is 0.
 *
 * da_is_bcast_mcast
 *		The destination address is broadcast or multicast.
 *
 * toeplitz_hash
 *		Actual chosen Hash.
 *		0 - Toeplitz hash of 2-tuple (IP source address, IP
 *		    destination address)
 *		1 - Toeplitz hash of 4-tuple (IP source	address,
 *		    IP destination address, L4 (TCP/UDP) source port,
 *		    L4 (TCP/UDP) destination port)
 *		2 - Toeplitz of flow_id
 *		3 - Zero is used
 *
 * ip_fixed_header_valid
 *		Fixed 20-byte IPv4 header or 40-byte IPv6 header parsed
 *		fully within first 256 bytes of the packet
 *
 * ip_extn_header_valid
 *		IPv6/IPv6 header, including IPv4 options and
 *		recognizable extension headers parsed fully within first 256
 *		bytes of the packet
 *
 * tcp_udp_header_valid
 *		Fixed 20-byte TCP (excluding TCP options) or 8-byte UDP
 *		header parsed fully within first 256 bytes of the packet
 *
 * mesh_control_present
 *		When set, this MSDU includes the 'Mesh Control' field
 *
 * ldpc
 *
 * ip4_protocol_ip6_next_header
 *		For IPv4, this is the 8 bit protocol field set). For IPv6 this
 *		is the 8 bit next_header field.
 *
 * toeplitz_hash_2_or_4
 *		Controlled by RxOLE register - If register bit set to 0,
 *		Toeplitz hash is computed over 2-tuple IPv4 or IPv6 src/dest
 *		addresses; otherwise, toeplitz hash is computed over 4-tuple
 *		IPv4 or IPv6 src/dest addresses and src/dest ports.
 *
 * flow_id_toeplitz
 *		Toeplitz hash of 5-tuple
 *		{IP source address, IP destination address, IP source port, IP
 *		destination port, L4 protocol}  in case of non-IPSec.
 *
 *		In case of IPSec - Toeplitz hash of 4-tuple
 *		{IP source address, IP destination address, SPI, L4 protocol}
 *
 *		The relevant Toeplitz key registers are provided in RxOLE's
 *		instance of common parser module. These registers are separate
 *		from the Toeplitz keys used by ASE/FSE modules inside RxOLE.
 *		The actual value will be passed on from common parser module
 *		to RxOLE in one of the WHO_* TLVs.
 *
 * user_rssi
 *		RSSI for this user
 *
 * pkt_type
 *		Values are defined in enum %RX_MSDU_START_PKT_TYPE_*.
 *
 * stbc
 *		When set, use STBC transmission rates.
 *
 * sgi
 *		Field only valid when pkt type is HT, VHT or HE. Values are
 *		defined in enum %RX_MSDU_START_SGI_*.
 *
 * rate_mcs
 *		MCS Rate used.
 *
 * receive_bandwidth
 *		Full receive Bandwidth. Values are defined in enum
 *		%RX_MSDU_START_RECV_*.
 *
 * reception_type
 *		Indicates what type of reception this is and defined in enum
 *		%RX_MSDU_START_RECEPTION_TYPE_*.
 *
 * mimo_ss_bitmap
 *		Field only valid when
 *		Reception_type is RX_MSDU_START_RECEPTION_TYPE_DL_MU_MIMO or
 *		RX_MSDU_START_RECEPTION_TYPE_DL_MU_OFDMA_MIMO.
 *
 *		Bitmap, with each bit indicating if the related spatial
 *		stream is used for this STA
 *
 *		LSB related to SS 0
 *
 *		0 - spatial stream not used for this reception
 *		1 - spatial stream used for this reception
 *
 * ppdu_start_timestamp
 *		Timestamp that indicates when the PPDU that contained this MPDU
 *		started on the medium.
 *
 * phy_meta_data
 *		SW programmed Meta data provided by the PHY. Can be used for SW
 *		to indicate the channel the device is on.
 */

#define RX_MSDU_END_INFO0_RXPCU_MPDU_FITLER	GENMASK(1, 0)
#define RX_MSDU_END_INFO0_SW_FRAME_GRP_ID	GENMASK(8, 2)

#define RX_MSDU_END_INFO1_KEY_ID		GENMASK(7, 0)
#define RX_MSDU_END_INFO1_CCE_SUPER_RULE	GENMASK(13, 8)
#define RX_MSDU_END_INFO1_CCND_TRUNCATE		BIT(14)
#define RX_MSDU_END_INFO1_CCND_CCE_DIS		BIT(15)
#define RX_MSDU_END_INFO1_EXT_WAPI_PN		GENMASK(31, 16)

#define RX_MSDU_END_INFO2_REPORTED_MPDU_LEN	GENMASK(13, 0)
#define RX_MSDU_END_INFO2_FIRST_MSDU		BIT(14)
#define RX_MSDU_END_INFO2_FIRST_MSDU_WCN6855	BIT(28)
#define RX_MSDU_END_INFO2_LAST_MSDU		BIT(15)
#define RX_MSDU_END_INFO2_LAST_MSDU_WCN6855	BIT(29)
#define RX_MSDU_END_INFO2_SA_IDX_TIMEOUT	BIT(16)
#define RX_MSDU_END_INFO2_DA_IDX_TIMEOUT	BIT(17)
#define RX_MSDU_END_INFO2_MSDU_LIMIT_ERR	BIT(18)
#define RX_MSDU_END_INFO2_FLOW_IDX_TIMEOUT	BIT(19)
#define RX_MSDU_END_INFO2_FLOW_IDX_INVALID	BIT(20)
#define RX_MSDU_END_INFO2_WIFI_PARSER_ERR	BIT(21)
#define RX_MSDU_END_INFO2_AMSDU_PARSET_ERR	BIT(22)
#define RX_MSDU_END_INFO2_SA_IS_VALID		BIT(23)
#define RX_MSDU_END_INFO2_DA_IS_VALID		BIT(24)
#define RX_MSDU_END_INFO2_DA_IS_MCBC		BIT(25)
#define RX_MSDU_END_INFO2_L3_HDR_PADDING	GENMASK(27, 26)

#define RX_MSDU_END_INFO3_TCP_FLAG		GENMASK(8, 0)
#define RX_MSDU_END_INFO3_LRO_ELIGIBLE		BIT(9)

#define RX_MSDU_END_INFO4_DA_OFFSET		GENMASK(5, 0)
#define RX_MSDU_END_INFO4_SA_OFFSET		GENMASK(11, 6)
#define RX_MSDU_END_INFO4_DA_OFFSET_VALID	BIT(12)
#define RX_MSDU_END_INFO4_SA_OFFSET_VALID	BIT(13)
#define RX_MSDU_END_INFO4_L3_TYPE		GENMASK(31, 16)

#define RX_MSDU_END_INFO5_MSDU_DROP		BIT(0)
#define RX_MSDU_END_INFO5_REO_DEST_IND		GENMASK(5, 1)
#define RX_MSDU_END_INFO5_FLOW_IDX		GENMASK(25, 6)

struct rx_msdu_end_ipq8074 {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint16_t ip_hdr_cksum;
	uint16_t tcp_udp_cksum;
	uint32_t info1;
	uint32_t ext_wapi_pn[2];
	uint32_t info2;
	uint32_t ipv6_options_crc;
	uint32_t tcp_seq_num;
	uint32_t tcp_ack_num;
	uint16_t info3;
	uint16_t window_size;
	uint32_t info4;
	uint32_t rule_indication[2];
	uint16_t sa_idx;
	uint16_t da_idx;
	uint32_t info5;
	uint32_t fse_metadata;
	uint16_t cce_metadata;
	uint16_t sa_sw_peer_id;
} __packed;

struct rx_msdu_end_wcn6855 {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint16_t ip_hdr_cksum;
	uint16_t reported_mpdu_len;
	uint32_t info1;
	uint32_t ext_wapi_pn[2];
	uint32_t info4;
	uint32_t ipv6_options_crc;
	uint32_t tcp_seq_num;
	uint32_t tcp_ack_num;
	uint16_t info3;
	uint16_t window_size;
	uint32_t info2;
	uint16_t sa_idx;
	uint16_t da_idx;
	uint32_t info5;
	uint32_t fse_metadata;
	uint16_t cce_metadata;
	uint16_t sa_sw_peer_id;
	uint32_t rule_indication[2];
	uint32_t info6;
	uint32_t info7;
} __packed;

#define RX_MSDU_END_MPDU_LENGTH_INFO		GENMASK(13, 0)

#define RX_MSDU_END_INFO2_DA_OFFSET		GENMASK(5, 0)
#define RX_MSDU_END_INFO2_SA_OFFSET		GENMASK(11, 6)
#define RX_MSDU_END_INFO2_DA_OFFSET_VALID	BIT(12)
#define RX_MSDU_END_INFO2_SA_OFFSET_VALID	BIT(13)
#define RX_MSDU_END_INFO2_L3_TYPE		GENMASK(31, 16)

#define RX_MSDU_END_INFO4_SA_IDX_TIMEOUT	BIT(0)
#define RX_MSDU_END_INFO4_DA_IDX_TIMEOUT	BIT(1)
#define RX_MSDU_END_INFO4_MSDU_LIMIT_ERR	BIT(2)
#define RX_MSDU_END_INFO4_FLOW_IDX_TIMEOUT	BIT(3)
#define RX_MSDU_END_INFO4_FLOW_IDX_INVALID	BIT(4)
#define RX_MSDU_END_INFO4_WIFI_PARSER_ERR	BIT(5)
#define RX_MSDU_END_INFO4_AMSDU_PARSER_ERR	BIT(6)
#define RX_MSDU_END_INFO4_SA_IS_VALID		BIT(7)
#define RX_MSDU_END_INFO4_DA_IS_VALID		BIT(8)
#define RX_MSDU_END_INFO4_DA_IS_MCBC		BIT(9)
#define RX_MSDU_END_INFO4_L3_HDR_PADDING	GENMASK(11, 10)
#define RX_MSDU_END_INFO4_FIRST_MSDU		BIT(12)
#define RX_MSDU_END_INFO4_LAST_MSDU		BIT(13)

#define RX_MSDU_END_INFO6_AGGR_COUNT		GENMASK(7, 0)
#define RX_MSDU_END_INFO6_FLOW_AGGR_CONTN	BIT(8)
#define RX_MSDU_END_INFO6_FISA_TIMEOUT		BIT(9)

struct rx_msdu_end_qcn9074 {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint16_t ip_hdr_cksum;
	uint16_t mpdu_length_info;
	uint32_t info1;
	uint32_t rule_indication[2];
	uint32_t info2;
	uint32_t ipv6_options_crc;
	uint32_t tcp_seq_num;
	uint32_t tcp_ack_num;
	uint16_t info3;
	uint16_t window_size;
	uint16_t tcp_udp_cksum;
	uint16_t info4;
	uint16_t sa_idx;
	uint16_t da_idx;
	uint32_t info5;
	uint32_t fse_metadata;
	uint16_t cce_metadata;
	uint16_t sa_sw_peer_id;
	uint32_t info6;
	uint16_t cum_l4_cksum;
	uint16_t cum_ip_length;
} __packed;

/* rx_msdu_end
 *
 * rxpcu_mpdu_filter_in_category
 *		Field indicates what the reason was that this mpdu frame
 *		was allowed to come into the receive path by rxpcu. Values
 *		are defined in enum %RX_DESC_RXPCU_FILTER_*.
 *
 * sw_frame_group_id
 *		SW processes frames based on certain classifications. Values
 *		are defined in enum %RX_DESC_SW_FRAME_GRP_ID_*.
 *
 * phy_ppdu_id
 *		A ppdu counter value that PHY increments for every PPDU
 *		received. The counter value wraps around.
 *
 * ip_hdr_cksum
 *		This can include the IP header checksum or the pseudo
 *		header checksum used by TCP/UDP checksum.
 *
 * tcp_udp_chksum
 *		The value of the computed TCP/UDP checksum.  A mode bit
 *		selects whether this checksum is the full checksum or the
 *		partial checksum which does not include the pseudo header.
 *
 * key_id
 *		The key ID octet from the IV. Only valid when first_msdu is set.
 *
 * cce_super_rule
 *		Indicates the super filter rule.
 *
 * cce_classify_not_done_truncate
 *		Classification failed due to truncated frame.
 *
 * cce_classify_not_done_cce_dis
 *		Classification failed due to CCE global disable
 *
 * ext_wapi_pn*
 *		Extension PN (packet number) which is only used by WAPI.
 *
 * reported_mpdu_length
 *		MPDU length before decapsulation. Only valid when first_msdu is
 *		set. This field is taken directly from the length field of the
 *		A-MPDU delimiter or the preamble length field for non-A-MPDU
 *		frames.
 *
 * first_msdu
 *		Indicates the first MSDU of A-MSDU. If both first_msdu and
 *		last_msdu are set in the MSDU then this is a non-aggregated MSDU
 *		frame: normal MPDU. Interior MSDU in an A-MSDU shall have both
 *		first_mpdu and last_mpdu bits set to 0.
 *
 * last_msdu
 *		Indicates the last MSDU of the A-MSDU. MPDU end status is only
 *		valid when last_msdu is set.
 *
 * sa_idx_timeout
 *		Indicates an unsuccessful MAC source address search due to the
 *		expiring of the search timer.
 *
 * da_idx_timeout
 *		Indicates an unsuccessful MAC destination address search due to
 *		the expiring of the search timer.
 *
 * msdu_limit_error
 *		Indicates that the MSDU threshold was exceeded and thus all the
 *		rest of the MSDUs will not be scattered and will not be
 *		decapsulated but will be DMA'ed in RAW format as a single MSDU.
 *
 * flow_idx_timeout
 *		Indicates an unsuccessful flow search due to the expiring of
 *		the search timer.
 *
 * flow_idx_invalid
 *		flow id is not valid.
 *
 * amsdu_parser_error
 *		A-MSDU could not be properly de-agregated.
 *
 * sa_is_valid
 *		Indicates that OLE found a valid SA entry.
 *
 * da_is_valid
 *		Indicates that OLE found a valid DA entry.
 *
 * da_is_mcbc
 *		Field Only valid if da_is_valid is set. Indicates the DA address
 *		was a Multicast of Broadcast address.
 *
 * l3_header_padding
 *		Number of bytes padded  to make sure that the L3 header will
 *		always start of a Dword boundary.
 *
 * ipv6_options_crc
 *		32 bit CRC computed out of  IP v6 extension headers.
 *
 * tcp_seq_number
 *		TCP sequence number.
 *
 * tcp_ack_number
 *		TCP acknowledge number.
 *
 * tcp_flag
 *		TCP flags {NS, CWR, ECE, URG, ACK, PSH, RST, SYN, FIN}.
 *
 * lro_eligible
 *		Computed out of TCP and IP fields to indicate that this
 *		MSDU is eligible for LRO.
 *
 * window_size
 *		TCP receive window size.
 *
 * da_offset
 *		Offset into MSDU buffer for DA.
 *
 * sa_offset
 *		Offset into MSDU buffer for SA.
 *
 * da_offset_valid
 *		da_offset field is valid. This will be set to 0 in case
 *		of a dynamic A-MSDU when DA is compressed.
 *
 * sa_offset_valid
 *		sa_offset field is valid. This will be set to 0 in case
 *		of a dynamic A-MSDU when SA is compressed.
 *
 * l3_type
 *		The 16-bit type value indicating the type of L3 later
 *		extracted from LLC/SNAP, set to zero if SNAP is not
 *		available.
 *
 * rule_indication
 *		Bitmap indicating which of rules have matched.
 *
 * sa_idx
 *		The offset in the address table which matches MAC source address
 *
 * da_idx
 *		The offset in the address table which matches MAC destination
 *		address.
 *
 * msdu_drop
 *		REO shall drop this MSDU and not forward it to any other ring.
 *
 * reo_destination_indication
 *		The id of the reo exit ring where the msdu frame shall push
 *		after (MPDU level) reordering has finished. Values are defined
 *		in enum %HAL_RX_MSDU_DESC_REO_DEST_IND_.
 *
 * flow_idx
 *		Flow table index.
 *
 * fse_metadata
 *		FSE related meta data.
 *
 * cce_metadata
 *		CCE related meta data.
 *
 * sa_sw_peer_id
 *		sw_peer_id from the address search entry corresponding to the
 *		source address of the MSDU.
 */

enum rx_mpdu_end_rxdma_dest_ring {
	RX_MPDU_END_RXDMA_DEST_RING_RELEASE,
	RX_MPDU_END_RXDMA_DEST_RING_FW,
	RX_MPDU_END_RXDMA_DEST_RING_SW,
	RX_MPDU_END_RXDMA_DEST_RING_REO,
};

#define RX_MPDU_END_INFO1_UNSUP_KTYPE_SHORT_FRAME	BIT(11)
#define RX_MPDU_END_INFO1_RX_IN_TX_DECRYPT_BYT		BIT(12)
#define RX_MPDU_END_INFO1_OVERFLOW_ERR			BIT(13)
#define RX_MPDU_END_INFO1_MPDU_LEN_ERR			BIT(14)
#define RX_MPDU_END_INFO1_TKIP_MIC_ERR			BIT(15)
#define RX_MPDU_END_INFO1_DECRYPT_ERR			BIT(16)
#define RX_MPDU_END_INFO1_UNENCRYPTED_FRAME_ERR		BIT(17)
#define RX_MPDU_END_INFO1_PN_FIELDS_VALID		BIT(18)
#define RX_MPDU_END_INFO1_FCS_ERR			BIT(19)
#define RX_MPDU_END_INFO1_MSDU_LEN_ERR			BIT(20)
#define RX_MPDU_END_INFO1_RXDMA0_DEST_RING		GENMASK(22, 21)
#define RX_MPDU_END_INFO1_RXDMA1_DEST_RING		GENMASK(24, 23)
#define RX_MPDU_END_INFO1_DECRYPT_STATUS_CODE		GENMASK(27, 25)
#define RX_MPDU_END_INFO1_RX_BITMAP_NOT_UPD		BIT(28)

struct rx_mpdu_end {
	uint16_t info0;
	uint16_t phy_ppdu_id;
	uint32_t info1;
} __packed;

/* rx_mpdu_end
 *
 * rxpcu_mpdu_filter_in_category
 *		Field indicates what the reason was that this mpdu frame
 *		was allowed to come into the receive path by rxpcu. Values
 *		are defined in enum %RX_DESC_RXPCU_FILTER_*.
 *
 * sw_frame_group_id
 *		SW processes frames based on certain classifications. Values
 *		are defined in enum %RX_DESC_SW_FRAME_GRP_ID_*.
 *
 * phy_ppdu_id
 *		A ppdu counter value that PHY increments for every PPDU
 *		received. The counter value wraps around.
 *
 * unsup_ktype_short_frame
 *		This bit will be '1' when WEP or TKIP or WAPI key type is
 *		received for 11ah short frame. Crypto will bypass the received
 *		packet without decryption to RxOLE after setting this bit.
 *
 * rx_in_tx_decrypt_byp
 *		Indicates that RX packet is not decrypted as Crypto is
 *		busy with TX packet processing.
 *
 * overflow_err
 *		RXPCU Receive FIFO ran out of space to receive the full MPDU.
 *		Therefore this MPDU is terminated early and is thus corrupted.
 *
 *		This MPDU will not be ACKed.
 *
 *		RXPCU might still be able to correctly receive the following
 *		MPDUs in the PPDU if enough fifo space became available in time.
 *
 * mpdu_length_err
 *		Set by RXPCU if the expected MPDU length does not correspond
 *		with the actually received number of bytes in the MPDU.
 *
 * tkip_mic_err
 *		Set by Rx crypto when crypto detected a TKIP MIC error for
 *		this MPDU.
 *
 * decrypt_err
 *		Set by RX CRYPTO when CRYPTO detected a decrypt error for this
 *		MPDU or CRYPTO received an encrypted frame, but did not get a
 *		valid corresponding key id in the peer entry.
 *
 * unencrypted_frame_err
 *		Set by RX CRYPTO when CRYPTO detected an unencrypted frame while
 *		in the peer entry field 'All_frames_shall_be_encrypted' is set.
 *
 * pn_fields_contain_valid_info
 *		Set by RX CRYPTO to indicate that there is a valid PN field
 *		present in this MPDU.
 *
 * fcs_err
 *		Set by RXPCU when there is an FCS error detected for this MPDU.
 *
 * msdu_length_err
 *		Set by RXOLE when there is an msdu length error detected
 *		in at least 1 of the MSDUs embedded within the MPDU.
 *
 * rxdma0_destination_ring
 * rxdma1_destination_ring
 *		The ring to which RXDMA0/1 shall push the frame, assuming
 *		no MPDU level errors are detected. In case of MPDU level
 *		errors, RXDMA0/1 might change the RXDMA0/1 destination. Values
 *		are defined in %enum RX_MPDU_END_RXDMA_DEST_RING_*.
 *
 * decrypt_status_code
 *		Field provides insight into the decryption performed. Values
 *		are defined in enum %RX_DESC_DECRYPT_STATUS_CODE_*.
 *
 * rx_bitmap_not_updated
 *		Frame is received, but RXPCU could not update the receive bitmap
 *		due to (temporary) fifo constraints.
 */

/* Padding bytes to avoid TLV's spanning across 128 byte boundary */
#define HAL_RX_DESC_PADDING0_BYTES	4
#define HAL_RX_DESC_PADDING1_BYTES	16

#define HAL_RX_DESC_HDR_STATUS_LEN	120

struct hal_rx_desc_ipq8074 {
	uint32_t msdu_end_tag;
	struct rx_msdu_end_ipq8074 msdu_end;
	uint32_t rx_attn_tag;
	struct rx_attention attention;
	uint32_t msdu_start_tag;
	struct rx_msdu_start_ipq8074 msdu_start;
	uint8_t rx_padding0[HAL_RX_DESC_PADDING0_BYTES];
	uint32_t mpdu_start_tag;
	struct rx_mpdu_start_ipq8074 mpdu_start;
	uint32_t mpdu_end_tag;
	struct rx_mpdu_end mpdu_end;
	uint8_t rx_padding1[HAL_RX_DESC_PADDING1_BYTES];
	uint32_t hdr_status_tag;
	uint32_t phy_ppdu_id;
	uint8_t hdr_status[HAL_RX_DESC_HDR_STATUS_LEN];
	uint8_t msdu_payload[];
} __packed;

struct hal_rx_desc_qcn9074 {
	uint32_t msdu_end_tag;
	struct rx_msdu_end_qcn9074 msdu_end;
	uint32_t rx_attn_tag;
	struct rx_attention attention;
	uint32_t msdu_start_tag;
	struct rx_msdu_start_qcn9074 msdu_start;
	uint8_t rx_padding0[HAL_RX_DESC_PADDING0_BYTES];
	uint32_t mpdu_start_tag;
	struct rx_mpdu_start_qcn9074 mpdu_start;
	uint32_t mpdu_end_tag;
	struct rx_mpdu_end mpdu_end;
	uint8_t rx_padding1[HAL_RX_DESC_PADDING1_BYTES];
	uint32_t hdr_status_tag;
	uint32_t phy_ppdu_id;
	uint8_t hdr_status[HAL_RX_DESC_HDR_STATUS_LEN];
	uint8_t msdu_payload[];
} __packed;

struct hal_rx_desc_wcn6855 {
	uint32_t msdu_end_tag;
	struct rx_msdu_end_wcn6855 msdu_end;
	uint32_t rx_attn_tag;
	struct rx_attention attention;
	uint32_t msdu_start_tag;
	struct rx_msdu_start_wcn6855 msdu_start;
	uint8_t rx_padding0[HAL_RX_DESC_PADDING0_BYTES];
	uint32_t mpdu_start_tag;
	struct rx_mpdu_start_wcn6855 mpdu_start;
	uint32_t mpdu_end_tag;
	struct rx_mpdu_end mpdu_end;
	uint8_t rx_padding1[HAL_RX_DESC_PADDING1_BYTES];
	uint32_t hdr_status_tag;
	uint32_t phy_ppdu_id;
	uint8_t hdr_status[HAL_RX_DESC_HDR_STATUS_LEN];
	uint8_t msdu_payload[];
} __packed;

struct hal_rx_desc {
	union {
		struct hal_rx_desc_ipq8074 ipq8074;
		struct hal_rx_desc_qcn9074 qcn9074;
		struct hal_rx_desc_wcn6855 wcn6855;
	} u;
} __packed;

#define HAL_RX_RU_ALLOC_TYPE_MAX 6
#define RU_26  1
#define RU_52  2
#define RU_106 4
#define RU_242 9
#define RU_484 18
#define RU_996 37

/*
 * dp.h
 */

/* HTT definitions */

#define HTT_TCL_META_DATA_TYPE			BIT(0)
#define HTT_TCL_META_DATA_VALID_HTT		BIT(1)

/* vdev meta data */
#define HTT_TCL_META_DATA_VDEV_ID		GENMASK(9, 2)
#define HTT_TCL_META_DATA_PDEV_ID		GENMASK(11, 10)
#define HTT_TCL_META_DATA_HOST_INSPECTED	BIT(12)

/* peer meta data */
#define HTT_TCL_META_DATA_PEER_ID		GENMASK(15, 2)

#define HTT_TX_WBM_COMP_STATUS_OFFSET 8

#define HTT_INVALID_PEER_ID	0xffff

/* HTT tx completion is overlaid in wbm_release_ring */
#define HTT_TX_WBM_COMP_INFO0_STATUS		GENMASK(12, 9)
#define HTT_TX_WBM_COMP_INFO0_REINJECT_REASON	GENMASK(16, 13)
#define HTT_TX_WBM_COMP_INFO0_REINJECT_REASON	GENMASK(16, 13)

#define HTT_TX_WBM_COMP_INFO1_ACK_RSSI		GENMASK(31, 24)
#define HTT_TX_WBM_COMP_INFO2_SW_PEER_ID	GENMASK(15, 0)
#define HTT_TX_WBM_COMP_INFO2_VALID		BIT(21)

struct htt_tx_wbm_completion {
	uint32_t info0;
	uint32_t info1;
	uint32_t info2;
	uint32_t info3;
} __packed;

enum htt_h2t_msg_type {
	HTT_H2T_MSG_TYPE_VERSION_REQ		= 0,
	HTT_H2T_MSG_TYPE_SRING_SETUP		= 0xb,
	HTT_H2T_MSG_TYPE_RX_RING_SELECTION_CFG	= 0xc,
	HTT_H2T_MSG_TYPE_EXT_STATS_CFG		= 0x10,
	HTT_H2T_MSG_TYPE_PPDU_STATS_CFG		= 0x11,
	HTT_H2T_MSG_TYPE_RX_FULL_MONITOR_MODE	= 0x17,
};

#define HTT_VER_REQ_INFO_MSG_ID		GENMASK(7, 0)

struct htt_ver_req_cmd {
	uint32_t ver_reg_info;
} __packed;

enum htt_srng_ring_type {
	HTT_HW_TO_SW_RING,
	HTT_SW_TO_HW_RING,
	HTT_SW_TO_SW_RING,
};

enum htt_srng_ring_id {
	HTT_RXDMA_HOST_BUF_RING,
	HTT_RXDMA_MONITOR_STATUS_RING,
	HTT_RXDMA_MONITOR_BUF_RING,
	HTT_RXDMA_MONITOR_DESC_RING,
	HTT_RXDMA_MONITOR_DEST_RING,
	HTT_HOST1_TO_FW_RXBUF_RING,
	HTT_HOST2_TO_FW_RXBUF_RING,
	HTT_RXDMA_NON_MONITOR_DEST_RING,
};

/* host -> target  HTT_SRING_SETUP message
 *
 * After target is booted up, Host can send SRING setup message for
 * each host facing LMAC SRING. Target setups up HW registers based
 * on setup message and confirms back to Host if response_required is set.
 * Host should wait for confirmation message before sending new SRING
 * setup message
 *
 * The message would appear as follows:
 *
 * |31            24|23    20|19|18 16|15|14          8|7                0|
 * |--------------- +-----------------+----------------+------------------|
 * |    ring_type   |      ring_id    |    pdev_id     |     msg_type     |
 * |----------------------------------------------------------------------|
 * |                          ring_base_addr_lo                           |
 * |----------------------------------------------------------------------|
 * |                         ring_base_addr_hi                            |
 * |----------------------------------------------------------------------|
 * |ring_misc_cfg_flag|ring_entry_size|            ring_size              |
 * |----------------------------------------------------------------------|
 * |                         ring_head_offset32_remote_addr_lo            |
 * |----------------------------------------------------------------------|
 * |                         ring_head_offset32_remote_addr_hi            |
 * |----------------------------------------------------------------------|
 * |                         ring_tail_offset32_remote_addr_lo            |
 * |----------------------------------------------------------------------|
 * |                         ring_tail_offset32_remote_addr_hi            |
 * |----------------------------------------------------------------------|
 * |                          ring_msi_addr_lo                            |
 * |----------------------------------------------------------------------|
 * |                          ring_msi_addr_hi                            |
 * |----------------------------------------------------------------------|
 * |                          ring_msi_data                               |
 * |----------------------------------------------------------------------|
 * |         intr_timer_th            |IM|      intr_batch_counter_th     |
 * |----------------------------------------------------------------------|
 * |          reserved        |RR|PTCF|        intr_low_threshold         |
 * |----------------------------------------------------------------------|
 * Where
 *     IM = sw_intr_mode
 *     RR = response_required
 *     PTCF = prefetch_timer_cfg
 *
 * The message is interpreted as follows:
 * dword0  - b'0:7   - msg_type: This will be set to
 *                     HTT_H2T_MSG_TYPE_SRING_SETUP
 *           b'8:15  - pdev_id:
 *                     0 (for rings at SOC/UMAC level),
 *                     1/2/3 mac id (for rings at LMAC level)
 *           b'16:23 - ring_id: identify which ring is to setup,
 *                     more details can be got from enum htt_srng_ring_id
 *           b'24:31 - ring_type: identify type of host rings,
 *                     more details can be got from enum htt_srng_ring_type
 * dword1  - b'0:31  - ring_base_addr_lo: Lower 32bits of ring base address
 * dword2  - b'0:31  - ring_base_addr_hi: Upper 32bits of ring base address
 * dword3  - b'0:15  - ring_size: size of the ring in unit of 4-bytes words
 *           b'16:23 - ring_entry_size: Size of each entry in 4-byte word units
 *           b'24:31 - ring_misc_cfg_flag: Valid only for HW_TO_SW_RING and
 *                     SW_TO_HW_RING.
 *                     Refer to HTT_SRING_SETUP_RING_MISC_CFG_RING defs.
 * dword4  - b'0:31  - ring_head_off32_remote_addr_lo:
 *                     Lower 32 bits of memory address of the remote variable
 *                     storing the 4-byte word offset that identifies the head
 *                     element within the ring.
 *                     (The head offset variable has type uint32_t.)
 *                     Valid for HW_TO_SW and SW_TO_SW rings.
 * dword5  - b'0:31  - ring_head_off32_remote_addr_hi:
 *                     Upper 32 bits of memory address of the remote variable
 *                     storing the 4-byte word offset that identifies the head
 *                     element within the ring.
 *                     (The head offset variable has type uint32_t.)
 *                     Valid for HW_TO_SW and SW_TO_SW rings.
 * dword6  - b'0:31  - ring_tail_off32_remote_addr_lo:
 *                     Lower 32 bits of memory address of the remote variable
 *                     storing the 4-byte word offset that identifies the tail
 *                     element within the ring.
 *                     (The tail offset variable has type uint32_t.)
 *                     Valid for HW_TO_SW and SW_TO_SW rings.
 * dword7  - b'0:31  - ring_tail_off32_remote_addr_hi:
 *                     Upper 32 bits of memory address of the remote variable
 *                     storing the 4-byte word offset that identifies the tail
 *                     element within the ring.
 *                     (The tail offset variable has type uint32_t.)
 *                     Valid for HW_TO_SW and SW_TO_SW rings.
 * dword8  - b'0:31  - ring_msi_addr_lo: Lower 32bits of MSI cfg address
 *                     valid only for HW_TO_SW_RING and SW_TO_HW_RING
 * dword9  - b'0:31  - ring_msi_addr_hi: Upper 32bits of MSI cfg address
 *                     valid only for HW_TO_SW_RING and SW_TO_HW_RING
 * dword10 - b'0:31  - ring_msi_data: MSI data
 *                     Refer to HTT_SRING_SETUP_RING_MSC_CFG_xxx defs
 *                     valid only for HW_TO_SW_RING and SW_TO_HW_RING
 * dword11 - b'0:14  - intr_batch_counter_th:
 *                     batch counter threshold is in units of 4-byte words.
 *                     HW internally maintains and increments batch count.
 *                     (see SRING spec for detail description).
 *                     When batch count reaches threshold value, an interrupt
 *                     is generated by HW.
 *           b'15    - sw_intr_mode:
 *                     This configuration shall be static.
 *                     Only programmed at power up.
 *                     0: generate pulse style sw interrupts
 *                     1: generate level style sw interrupts
 *           b'16:31 - intr_timer_th:
 *                     The timer init value when timer is idle or is
 *                     initialized to start downcounting.
 *                     In 8us units (to cover a range of 0 to 524 ms)
 * dword12 - b'0:15  - intr_low_threshold:
 *                     Used only by Consumer ring to generate ring_sw_int_p.
 *                     Ring entries low threshold water mark, that is used
 *                     in combination with the interrupt timer as well as
 *                     the clearing of the level interrupt.
 *           b'16:18 - prefetch_timer_cfg:
 *                     Used only by Consumer ring to set timer mode to
 *                     support Application prefetch handling.
 *                     The external tail offset/pointer will be updated
 *                     at following intervals:
 *                     3'b000: (Prefetch feature disabled; used only for debug)
 *                     3'b001: 1 usec
 *                     3'b010: 4 usec
 *                     3'b011: 8 usec (default)
 *                     3'b100: 16 usec
 *                     Others: Reserved
 *           b'19    - response_required:
 *                     Host needs HTT_T2H_MSG_TYPE_SRING_SETUP_DONE as response
 *           b'20:31 - reserved:  reserved for future use
 */

#define HTT_SRNG_SETUP_CMD_INFO0_MSG_TYPE	GENMASK(7, 0)
#define HTT_SRNG_SETUP_CMD_INFO0_PDEV_ID	GENMASK(15, 8)
#define HTT_SRNG_SETUP_CMD_INFO0_RING_ID	GENMASK(23, 16)
#define HTT_SRNG_SETUP_CMD_INFO0_RING_TYPE	GENMASK(31, 24)

#define HTT_SRNG_SETUP_CMD_INFO1_RING_SIZE			GENMASK(15, 0)
#define HTT_SRNG_SETUP_CMD_INFO1_RING_ENTRY_SIZE		GENMASK(23, 16)
#define HTT_SRNG_SETUP_CMD_INFO1_RING_LOOP_CNT_DIS		BIT(25)
#define HTT_SRNG_SETUP_CMD_INFO1_RING_FLAGS_MSI_SWAP		BIT(27)
#define HTT_SRNG_SETUP_CMD_INFO1_RING_FLAGS_HOST_FW_SWAP	BIT(28)
#define HTT_SRNG_SETUP_CMD_INFO1_RING_FLAGS_TLV_SWAP		BIT(29)

#define HTT_SRNG_SETUP_CMD_INTR_INFO_BATCH_COUNTER_THRESH	GENMASK(14, 0)
#define HTT_SRNG_SETUP_CMD_INTR_INFO_SW_INTR_MODE		BIT(15)
#define HTT_SRNG_SETUP_CMD_INTR_INFO_INTR_TIMER_THRESH		GENMASK(31, 16)

#define HTT_SRNG_SETUP_CMD_INFO2_INTR_LOW_THRESH	GENMASK(15, 0)
#define HTT_SRNG_SETUP_CMD_INFO2_PRE_FETCH_TIMER_CFG	BIT(16)
#define HTT_SRNG_SETUP_CMD_INFO2_RESPONSE_REQUIRED	BIT(19)

struct htt_srng_setup_cmd {
	uint32_t info0;
	uint32_t ring_base_addr_lo;
	uint32_t ring_base_addr_hi;
	uint32_t info1;
	uint32_t ring_head_off32_remote_addr_lo;
	uint32_t ring_head_off32_remote_addr_hi;
	uint32_t ring_tail_off32_remote_addr_lo;
	uint32_t ring_tail_off32_remote_addr_hi;
	uint32_t ring_msi_addr_lo;
	uint32_t ring_msi_addr_hi;
	uint32_t msi_data;
	uint32_t intr_info;
	uint32_t info2;
} __packed;

/* host -> target FW  PPDU_STATS config message
 *
 * @details
 * The following field definitions describe the format of the HTT host
 * to target FW for PPDU_STATS_CFG msg.
 * The message allows the host to configure the PPDU_STATS_IND messages
 * produced by the target.
 *
 * |31          24|23          16|15           8|7            0|
 * |-----------------------------------------------------------|
 * |    REQ bit mask             |   pdev_mask  |   msg type   |
 * |-----------------------------------------------------------|
 * Header fields:
 *  - MSG_TYPE
 *    Bits 7:0
 *    Purpose: identifies this is a req to configure ppdu_stats_ind from target
 *    Value: 0x11
 *  - PDEV_MASK
 *    Bits 8:15
 *    Purpose: identifies which pdevs this PPDU stats configuration applies to
 *    Value: This is a overloaded field, refer to usage and interpretation of
 *           PDEV in interface document.
 *           Bit   8    :  Reserved for SOC stats
 *           Bit 9 - 15 :  Indicates PDEV_MASK in DBDC
 *                         Indicates MACID_MASK in DBS
 *  - REQ_TLV_BIT_MASK
 *    Bits 16:31
 *    Purpose: each set bit indicates the corresponding PPDU stats TLV type
 *        needs to be included in the target's PPDU_STATS_IND messages.
 *    Value: refer htt_ppdu_stats_tlv_tag_t <<<???
 *
 */

struct htt_ppdu_stats_cfg_cmd {
	uint32_t msg;
} __packed;

#define HTT_PPDU_STATS_CFG_MSG_TYPE		GENMASK(7, 0)
#define HTT_PPDU_STATS_CFG_SOC_STATS		BIT(8)
#define HTT_PPDU_STATS_CFG_PDEV_ID		GENMASK(15, 9)
#define HTT_PPDU_STATS_CFG_TLV_TYPE_BITMASK	GENMASK(31, 16)

enum htt_ppdu_stats_tag_type {
	HTT_PPDU_STATS_TAG_COMMON,
	HTT_PPDU_STATS_TAG_USR_COMMON,
	HTT_PPDU_STATS_TAG_USR_RATE,
	HTT_PPDU_STATS_TAG_USR_MPDU_ENQ_BITMAP_64,
	HTT_PPDU_STATS_TAG_USR_MPDU_ENQ_BITMAP_256,
	HTT_PPDU_STATS_TAG_SCH_CMD_STATUS,
	HTT_PPDU_STATS_TAG_USR_COMPLTN_COMMON,
	HTT_PPDU_STATS_TAG_USR_COMPLTN_BA_BITMAP_64,
	HTT_PPDU_STATS_TAG_USR_COMPLTN_BA_BITMAP_256,
	HTT_PPDU_STATS_TAG_USR_COMPLTN_ACK_BA_STATUS,
	HTT_PPDU_STATS_TAG_USR_COMPLTN_FLUSH,
	HTT_PPDU_STATS_TAG_USR_COMMON_ARRAY,
	HTT_PPDU_STATS_TAG_INFO,
	HTT_PPDU_STATS_TAG_TX_MGMTCTRL_PAYLOAD,

	/* New TLV's are added above to this line */
	HTT_PPDU_STATS_TAG_MAX,
};

#define HTT_PPDU_STATS_TAG_DEFAULT (BIT(HTT_PPDU_STATS_TAG_COMMON) \
				   | BIT(HTT_PPDU_STATS_TAG_USR_COMMON) \
				   | BIT(HTT_PPDU_STATS_TAG_USR_RATE) \
				   | BIT(HTT_PPDU_STATS_TAG_SCH_CMD_STATUS) \
				   | BIT(HTT_PPDU_STATS_TAG_USR_COMPLTN_COMMON) \
				   | BIT(HTT_PPDU_STATS_TAG_USR_COMPLTN_ACK_BA_STATUS) \
				   | BIT(HTT_PPDU_STATS_TAG_USR_COMPLTN_FLUSH) \
				   | BIT(HTT_PPDU_STATS_TAG_USR_COMMON_ARRAY))

#define HTT_PPDU_STATS_TAG_PKTLOG  (BIT(HTT_PPDU_STATS_TAG_USR_MPDU_ENQ_BITMAP_64) | \
				    BIT(HTT_PPDU_STATS_TAG_USR_MPDU_ENQ_BITMAP_256) | \
				    BIT(HTT_PPDU_STATS_TAG_USR_COMPLTN_BA_BITMAP_64) | \
				    BIT(HTT_PPDU_STATS_TAG_USR_COMPLTN_BA_BITMAP_256) | \
				    BIT(HTT_PPDU_STATS_TAG_INFO) | \
				    BIT(HTT_PPDU_STATS_TAG_TX_MGMTCTRL_PAYLOAD) | \
				    HTT_PPDU_STATS_TAG_DEFAULT)

/* HTT_H2T_MSG_TYPE_RX_RING_SELECTION_CFG Message
 *
 * details:
 *    HTT_H2T_MSG_TYPE_RX_RING_SELECTION_CFG message is sent by host to
 *    configure RXDMA rings.
 *    The configuration is per ring based and includes both packet subtypes
 *    and PPDU/MPDU TLVs.
 *
 *    The message would appear as follows:
 *
 *    |31       26|25|24|23            16|15             8|7             0|
 *    |-----------------+----------------+----------------+---------------|
 *    |   rsvd1   |PS|SS|     ring_id    |     pdev_id    |    msg_type   |
 *    |-------------------------------------------------------------------|
 *    |              rsvd2               |           ring_buffer_size     |
 *    |-------------------------------------------------------------------|
 *    |                        packet_type_enable_flags_0                 |
 *    |-------------------------------------------------------------------|
 *    |                        packet_type_enable_flags_1                 |
 *    |-------------------------------------------------------------------|
 *    |                        packet_type_enable_flags_2                 |
 *    |-------------------------------------------------------------------|
 *    |                        packet_type_enable_flags_3                 |
 *    |-------------------------------------------------------------------|
 *    |                         tlv_filter_in_flags                       |
 *    |-------------------------------------------------------------------|
 * Where:
 *     PS = pkt_swap
 *     SS = status_swap
 * The message is interpreted as follows:
 * dword0 - b'0:7   - msg_type: This will be set to
 *                    HTT_H2T_MSG_TYPE_RX_RING_SELECTION_CFG
 *          b'8:15  - pdev_id:
 *                    0 (for rings at SOC/UMAC level),
 *                    1/2/3 mac id (for rings at LMAC level)
 *          b'16:23 - ring_id : Identify the ring to configure.
 *                    More details can be got from enum htt_srng_ring_id
 *          b'24    - status_swap: 1 is to swap status TLV
 *          b'25    - pkt_swap:  1 is to swap packet TLV
 *          b'26:31 - rsvd1:  reserved for future use
 * dword1 - b'0:16  - ring_buffer_size: size of buffers referenced by rx ring,
 *                    in byte units.
 *                    Valid only for HW_TO_SW_RING and SW_TO_HW_RING
 *        - b'16:31 - rsvd2: Reserved for future use
 * dword2 - b'0:31  - packet_type_enable_flags_0:
 *                    Enable MGMT packet from 0b0000 to 0b1001
 *                    bits from low to high: FP, MD, MO - 3 bits
 *                        FP: Filter_Pass
 *                        MD: Monitor_Direct
 *                        MO: Monitor_Other
 *                    10 mgmt subtypes * 3 bits -> 30 bits
 *                    Refer to PKT_TYPE_ENABLE_FLAG0_xxx_MGMT_xxx defs
 * dword3 - b'0:31  - packet_type_enable_flags_1:
 *                    Enable MGMT packet from 0b1010 to 0b1111
 *                    bits from low to high: FP, MD, MO - 3 bits
 *                    Refer to PKT_TYPE_ENABLE_FLAG1_xxx_MGMT_xxx defs
 * dword4 - b'0:31 -  packet_type_enable_flags_2:
 *                    Enable CTRL packet from 0b0000 to 0b1001
 *                    bits from low to high: FP, MD, MO - 3 bits
 *                    Refer to PKT_TYPE_ENABLE_FLAG2_xxx_CTRL_xxx defs
 * dword5 - b'0:31  - packet_type_enable_flags_3:
 *                    Enable CTRL packet from 0b1010 to 0b1111,
 *                    MCAST_DATA, UCAST_DATA, NULL_DATA
 *                    bits from low to high: FP, MD, MO - 3 bits
 *                    Refer to PKT_TYPE_ENABLE_FLAG3_xxx_CTRL_xxx defs
 * dword6 - b'0:31 -  tlv_filter_in_flags:
 *                    Filter in Attention/MPDU/PPDU/Header/User tlvs
 *                    Refer to CFG_TLV_FILTER_IN_FLAG defs
 */

#define HTT_RX_RING_SELECTION_CFG_CMD_INFO0_MSG_TYPE	GENMASK(7, 0)
#define HTT_RX_RING_SELECTION_CFG_CMD_INFO0_PDEV_ID	GENMASK(15, 8)
#define HTT_RX_RING_SELECTION_CFG_CMD_INFO0_RING_ID	GENMASK(23, 16)
#define HTT_RX_RING_SELECTION_CFG_CMD_INFO0_SS		BIT(24)
#define HTT_RX_RING_SELECTION_CFG_CMD_INFO0_PS		BIT(25)

#define HTT_RX_RING_SELECTION_CFG_CMD_INFO1_BUF_SIZE	GENMASK(15, 0)

enum htt_rx_filter_tlv_flags {
	HTT_RX_FILTER_TLV_FLAGS_MPDU_START		= BIT(0),
	HTT_RX_FILTER_TLV_FLAGS_MSDU_START		= BIT(1),
	HTT_RX_FILTER_TLV_FLAGS_RX_PACKET		= BIT(2),
	HTT_RX_FILTER_TLV_FLAGS_MSDU_END		= BIT(3),
	HTT_RX_FILTER_TLV_FLAGS_MPDU_END		= BIT(4),
	HTT_RX_FILTER_TLV_FLAGS_PACKET_HEADER		= BIT(5),
	HTT_RX_FILTER_TLV_FLAGS_PER_MSDU_HEADER		= BIT(6),
	HTT_RX_FILTER_TLV_FLAGS_ATTENTION		= BIT(7),
	HTT_RX_FILTER_TLV_FLAGS_PPDU_START		= BIT(8),
	HTT_RX_FILTER_TLV_FLAGS_PPDU_END		= BIT(9),
	HTT_RX_FILTER_TLV_FLAGS_PPDU_END_USER_STATS	= BIT(10),
	HTT_RX_FILTER_TLV_FLAGS_PPDU_END_USER_STATS_EXT	= BIT(11),
	HTT_RX_FILTER_TLV_FLAGS_PPDU_END_STATUS_DONE	= BIT(12),
};

enum htt_rx_mgmt_pkt_filter_tlv_flags0 {
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_REQ		= BIT(0),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_REQ		= BIT(1),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_REQ		= BIT(2),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_RESP		= BIT(3),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_RESP		= BIT(4),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_RESP		= BIT(5),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_REQ	= BIT(6),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_REQ	= BIT(7),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_REQ	= BIT(8),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_RESP	= BIT(9),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_RESP	= BIT(10),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_RESP	= BIT(11),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_REQ		= BIT(12),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_REQ		= BIT(13),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_REQ		= BIT(14),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_RESP		= BIT(15),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_RESP		= BIT(16),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_RESP		= BIT(17),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_TIMING_ADV	= BIT(18),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_TIMING_ADV	= BIT(19),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_TIMING_ADV	= BIT(20),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_RESERVED_7		= BIT(21),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_RESERVED_7		= BIT(22),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_RESERVED_7		= BIT(23),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_BEACON		= BIT(24),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_BEACON		= BIT(25),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_BEACON		= BIT(26),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_ATIM		= BIT(27),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_ATIM		= BIT(28),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_ATIM		= BIT(29),
};

enum htt_rx_mgmt_pkt_filter_tlv_flags1 {
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_DISASSOC		= BIT(0),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_DISASSOC		= BIT(1),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_DISASSOC		= BIT(2),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_AUTH		= BIT(3),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_AUTH		= BIT(4),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_AUTH		= BIT(5),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_DEAUTH		= BIT(6),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_DEAUTH		= BIT(7),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_DEAUTH		= BIT(8),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION		= BIT(9),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION		= BIT(10),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION		= BIT(11),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION_NOACK	= BIT(12),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION_NOACK	= BIT(13),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION_NOACK	= BIT(14),
	HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_RESERVED_15	= BIT(15),
	HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_RESERVED_15	= BIT(16),
	HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_RESERVED_15	= BIT(17),
};

enum htt_rx_ctrl_pkt_filter_tlv_flags2 {
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_1	= BIT(0),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_1	= BIT(1),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_1	= BIT(2),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_2	= BIT(3),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_2	= BIT(4),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_2	= BIT(5),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_TRIGGER	= BIT(6),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_TRIGGER	= BIT(7),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_TRIGGER	= BIT(8),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_4	= BIT(9),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_4	= BIT(10),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_4	= BIT(11),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_BF_REP_POLL	= BIT(12),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_BF_REP_POLL	= BIT(13),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_BF_REP_POLL	= BIT(14),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_VHT_NDP	= BIT(15),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_VHT_NDP	= BIT(16),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_VHT_NDP	= BIT(17),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_FRAME_EXT	= BIT(18),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_FRAME_EXT	= BIT(19),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_FRAME_EXT	= BIT(20),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_WRAPPER	= BIT(21),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_WRAPPER	= BIT(22),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_WRAPPER	= BIT(23),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_BAR		= BIT(24),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_BAR		= BIT(25),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_BAR		= BIT(26),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_BA			= BIT(27),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_BA			= BIT(28),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_BA			= BIT(29),
};

enum htt_rx_ctrl_pkt_filter_tlv_flags3 {
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_PSPOLL		= BIT(0),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_PSPOLL		= BIT(1),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_PSPOLL		= BIT(2),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_RTS		= BIT(3),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_RTS		= BIT(4),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_RTS		= BIT(5),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_CTS		= BIT(6),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_CTS		= BIT(7),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_CTS		= BIT(8),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_ACK		= BIT(9),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_ACK		= BIT(10),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_ACK		= BIT(11),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND		= BIT(12),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND		= BIT(13),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND		= BIT(14),
	HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND_ACK		= BIT(15),
	HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND_ACK		= BIT(16),
	HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND_ACK		= BIT(17),
};

enum htt_rx_data_pkt_filter_tlv_flasg3 {
	HTT_RX_FP_DATA_PKT_FILTER_TLV_FLASG3_MCAST	= BIT(18),
	HTT_RX_MD_DATA_PKT_FILTER_TLV_FLASG3_MCAST	= BIT(19),
	HTT_RX_MO_DATA_PKT_FILTER_TLV_FLASG3_MCAST	= BIT(20),
	HTT_RX_FP_DATA_PKT_FILTER_TLV_FLASG3_UCAST	= BIT(21),
	HTT_RX_MD_DATA_PKT_FILTER_TLV_FLASG3_UCAST	= BIT(22),
	HTT_RX_MO_DATA_PKT_FILTER_TLV_FLASG3_UCAST	= BIT(23),
	HTT_RX_FP_DATA_PKT_FILTER_TLV_FLASG3_NULL_DATA	= BIT(24),
	HTT_RX_MD_DATA_PKT_FILTER_TLV_FLASG3_NULL_DATA	= BIT(25),
	HTT_RX_MO_DATA_PKT_FILTER_TLV_FLASG3_NULL_DATA	= BIT(26),
};

#define HTT_RX_FP_MGMT_FILTER_FLAGS0 \
	(HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_REQ \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_RESP \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_REQ \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_RESP \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_REQ \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_RESP \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_TIMING_ADV \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_BEACON \
	| HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_ATIM)

#define HTT_RX_MD_MGMT_FILTER_FLAGS0 \
	(HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_REQ \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_RESP \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_REQ \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_RESP \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_REQ \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_RESP \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_TIMING_ADV \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_BEACON \
	| HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS0_ATIM)

#define HTT_RX_MO_MGMT_FILTER_FLAGS0 \
	(HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_REQ \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_ASSOC_RESP \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_REQ \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_REASSOC_RESP \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_REQ \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_RESP \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_PROBE_TIMING_ADV \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_BEACON \
	| HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_ATIM)

#define HTT_RX_FP_MGMT_FILTER_FLAGS1 (HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_DISASSOC \
				     | HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_AUTH \
				     | HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_DEAUTH \
				     | HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION \
				     | HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION_NOACK)

#define HTT_RX_MD_MGMT_FILTER_FLAGS1 (HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_DISASSOC \
				     | HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_AUTH \
				     | HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_DEAUTH \
				     | HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION \
				     | HTT_RX_MD_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION_NOACK)

#define HTT_RX_MO_MGMT_FILTER_FLAGS1 (HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_DISASSOC \
				     | HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_AUTH \
				     | HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_DEAUTH \
				     | HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION \
				     | HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_ACTION_NOACK)

#define HTT_RX_FP_CTRL_FILTER_FLASG2 (HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_WRAPPER \
				     | HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_BAR \
				     | HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_BA)

#define HTT_RX_MD_CTRL_FILTER_FLASG2 (HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_WRAPPER \
				     | HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_BAR \
				     | HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS2_BA)

#define HTT_RX_MO_CTRL_FILTER_FLASG2 (HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_WRAPPER \
				     | HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_BAR \
				     | HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_BA)

#define HTT_RX_FP_CTRL_FILTER_FLASG3 (HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_PSPOLL \
				     | HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_RTS \
				     | HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_CTS \
				     | HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_ACK \
				     | HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND \
				     | HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND_ACK)

#define HTT_RX_MD_CTRL_FILTER_FLASG3 (HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_PSPOLL \
				     | HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_RTS \
				     | HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_CTS \
				     | HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_ACK \
				     | HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND \
				     | HTT_RX_MD_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND_ACK)

#define HTT_RX_MO_CTRL_FILTER_FLASG3 (HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_PSPOLL \
				     | HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_RTS \
				     | HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_CTS \
				     | HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_ACK \
				     | HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND \
				     | HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS3_CFEND_ACK)

#define HTT_RX_FP_DATA_FILTER_FLASG3 (HTT_RX_FP_DATA_PKT_FILTER_TLV_FLASG3_MCAST \
				     | HTT_RX_FP_DATA_PKT_FILTER_TLV_FLASG3_UCAST \
				     | HTT_RX_FP_DATA_PKT_FILTER_TLV_FLASG3_NULL_DATA)

#define HTT_RX_MD_DATA_FILTER_FLASG3 (HTT_RX_MD_DATA_PKT_FILTER_TLV_FLASG3_MCAST \
				     | HTT_RX_MD_DATA_PKT_FILTER_TLV_FLASG3_UCAST \
				     | HTT_RX_MD_DATA_PKT_FILTER_TLV_FLASG3_NULL_DATA)

#define HTT_RX_MO_DATA_FILTER_FLASG3 (HTT_RX_MO_DATA_PKT_FILTER_TLV_FLASG3_MCAST \
				     | HTT_RX_MO_DATA_PKT_FILTER_TLV_FLASG3_UCAST \
				     | HTT_RX_MO_DATA_PKT_FILTER_TLV_FLASG3_NULL_DATA)

#define HTT_RX_MON_FP_MGMT_FILTER_FLAGS0 \
		(HTT_RX_FP_MGMT_FILTER_FLAGS0 | \
		HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS0_RESERVED_7)

#define HTT_RX_MON_MO_MGMT_FILTER_FLAGS0 \
		(HTT_RX_MO_MGMT_FILTER_FLAGS0 | \
		HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS0_RESERVED_7)

#define HTT_RX_MON_FP_MGMT_FILTER_FLAGS1 \
		(HTT_RX_FP_MGMT_FILTER_FLAGS1 | \
		HTT_RX_FP_MGMT_PKT_FILTER_TLV_FLAGS1_RESERVED_15)

#define HTT_RX_MON_MO_MGMT_FILTER_FLAGS1 \
		(HTT_RX_MO_MGMT_FILTER_FLAGS1 | \
		HTT_RX_MO_MGMT_PKT_FILTER_TLV_FLAGS1_RESERVED_15)

#define HTT_RX_MON_FP_CTRL_FILTER_FLASG2 \
		(HTT_RX_FP_CTRL_FILTER_FLASG2 | \
		HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_1 | \
		HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_2 | \
		HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_TRIGGER | \
		HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_4 | \
		HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_BF_REP_POLL | \
		HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_VHT_NDP | \
		HTT_RX_FP_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_FRAME_EXT)

#define HTT_RX_MON_MO_CTRL_FILTER_FLASG2 \
		(HTT_RX_MO_CTRL_FILTER_FLASG2 | \
		HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_1 | \
		HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_2 | \
		HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_TRIGGER | \
		HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_RESERVED_4 | \
		HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_BF_REP_POLL | \
		HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_VHT_NDP | \
		HTT_RX_MO_CTRL_PKT_FILTER_TLV_FLAGS2_CTRL_FRAME_EXT)

#define HTT_RX_MON_FP_CTRL_FILTER_FLASG3 HTT_RX_FP_CTRL_FILTER_FLASG3

#define HTT_RX_MON_MO_CTRL_FILTER_FLASG3 HTT_RX_MO_CTRL_FILTER_FLASG3

#define HTT_RX_MON_FP_DATA_FILTER_FLASG3 HTT_RX_FP_DATA_FILTER_FLASG3

#define HTT_RX_MON_MO_DATA_FILTER_FLASG3 HTT_RX_MO_DATA_FILTER_FLASG3

#define HTT_RX_MON_FILTER_TLV_FLAGS \
		(HTT_RX_FILTER_TLV_FLAGS_MPDU_START | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_START | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END_USER_STATS | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END_USER_STATS_EXT | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END_STATUS_DONE)

#define HTT_RX_MON_FILTER_TLV_FLAGS_MON_STATUS_RING \
		(HTT_RX_FILTER_TLV_FLAGS_MPDU_START | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_START | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END_USER_STATS | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END_USER_STATS_EXT | \
		HTT_RX_FILTER_TLV_FLAGS_PPDU_END_STATUS_DONE)

#define HTT_RX_MON_FILTER_TLV_FLAGS_MON_BUF_RING \
		(HTT_RX_FILTER_TLV_FLAGS_MPDU_START | \
		HTT_RX_FILTER_TLV_FLAGS_MSDU_START | \
		HTT_RX_FILTER_TLV_FLAGS_RX_PACKET | \
		HTT_RX_FILTER_TLV_FLAGS_MSDU_END | \
		HTT_RX_FILTER_TLV_FLAGS_MPDU_END | \
		HTT_RX_FILTER_TLV_FLAGS_PACKET_HEADER | \
		HTT_RX_FILTER_TLV_FLAGS_PER_MSDU_HEADER | \
		HTT_RX_FILTER_TLV_FLAGS_ATTENTION)

struct htt_rx_ring_selection_cfg_cmd {
	uint32_t info0;
	uint32_t info1;
	uint32_t pkt_type_en_flags0;
	uint32_t pkt_type_en_flags1;
	uint32_t pkt_type_en_flags2;
	uint32_t pkt_type_en_flags3;
	uint32_t rx_filter_tlv;
} __packed;

struct htt_rx_ring_tlv_filter {
	uint32_t rx_filter; /* see htt_rx_filter_tlv_flags */
	uint32_t pkt_filter_flags0; /* MGMT */
	uint32_t pkt_filter_flags1; /* MGMT */
	uint32_t pkt_filter_flags2; /* CTRL */
	uint32_t pkt_filter_flags3; /* DATA */
};

#define HTT_RX_FULL_MON_MODE_CFG_CMD_INFO0_MSG_TYPE	GENMASK(7, 0)
#define HTT_RX_FULL_MON_MODE_CFG_CMD_INFO0_PDEV_ID	GENMASK(15, 8)

#define HTT_RX_FULL_MON_MODE_CFG_CMD_CFG_ENABLE			BIT(0)
#define HTT_RX_FULL_MON_MODE_CFG_CMD_CFG_ZERO_MPDUS_END		BIT(1)
#define HTT_RX_FULL_MON_MODE_CFG_CMD_CFG_NON_ZERO_MPDUS_END	BIT(2)
#define HTT_RX_FULL_MON_MODE_CFG_CMD_CFG_RELEASE_RING		GENMASK(10, 3)

/* Enumeration for full monitor mode destination ring select
 * 0 - REO destination ring select
 * 1 - FW destination ring select
 * 2 - SW destination ring select
 * 3 - Release destination ring select
 */
enum htt_rx_full_mon_release_ring {
	HTT_RX_MON_RING_REO,
	HTT_RX_MON_RING_FW,
	HTT_RX_MON_RING_SW,
	HTT_RX_MON_RING_RELEASE,
};

struct htt_rx_full_monitor_mode_cfg_cmd {
	uint32_t info0;
	uint32_t cfg;
} __packed;

/* HTT message target->host */

enum htt_t2h_msg_type {
	HTT_T2H_MSG_TYPE_VERSION_CONF,
	HTT_T2H_MSG_TYPE_PEER_MAP	= 0x3,
	HTT_T2H_MSG_TYPE_PEER_UNMAP	= 0x4,
	HTT_T2H_MSG_TYPE_RX_ADDBA	= 0x5,
	HTT_T2H_MSG_TYPE_PKTLOG		= 0x8,
	HTT_T2H_MSG_TYPE_SEC_IND	= 0xb,
	HTT_T2H_MSG_TYPE_PEER_MAP2	= 0x1e,
	HTT_T2H_MSG_TYPE_PEER_UNMAP2	= 0x1f,
	HTT_T2H_MSG_TYPE_PPDU_STATS_IND = 0x1d,
	HTT_T2H_MSG_TYPE_EXT_STATS_CONF = 0x1c,
	HTT_T2H_MSG_TYPE_BKPRESSURE_EVENT_IND = 0x24,
};

#define HTT_TARGET_VERSION_MAJOR 3

#define HTT_T2H_MSG_TYPE		GENMASK(7, 0)
#define HTT_T2H_VERSION_CONF_MINOR	GENMASK(15, 8)
#define HTT_T2H_VERSION_CONF_MAJOR	GENMASK(23, 16)

struct htt_t2h_version_conf_msg {
	uint32_t version;
} __packed;

#define HTT_T2H_PEER_MAP_INFO_VDEV_ID	GENMASK(15, 8)
#define HTT_T2H_PEER_MAP_INFO_PEER_ID	GENMASK(31, 16)
#define HTT_T2H_PEER_MAP_INFO1_MAC_ADDR_H16	GENMASK(15, 0)
#define HTT_T2H_PEER_MAP_INFO1_HW_PEER_ID	GENMASK(31, 16)
#define HTT_T2H_PEER_MAP_INFO2_AST_HASH_VAL	GENMASK(15, 0)
#define HTT_T2H_PEER_MAP_INFO2_NEXT_HOP_M	BIT(16)
#define HTT_T2H_PEER_MAP_INFO2_NEXT_HOP_S	16

struct htt_t2h_peer_map_event {
	uint32_t info;
	uint32_t mac_addr_l32;
	uint32_t info1;
	uint32_t info2;
} __packed;

#define HTT_T2H_PEER_UNMAP_INFO_VDEV_ID	HTT_T2H_PEER_MAP_INFO_VDEV_ID
#define HTT_T2H_PEER_UNMAP_INFO_PEER_ID	HTT_T2H_PEER_MAP_INFO_PEER_ID
#define HTT_T2H_PEER_UNMAP_INFO1_MAC_ADDR_H16 \
					HTT_T2H_PEER_MAP_INFO1_MAC_ADDR_H16
#define HTT_T2H_PEER_MAP_INFO1_NEXT_HOP_M HTT_T2H_PEER_MAP_INFO2_NEXT_HOP_M
#define HTT_T2H_PEER_MAP_INFO1_NEXT_HOP_S HTT_T2H_PEER_MAP_INFO2_NEXT_HOP_S

struct htt_t2h_peer_unmap_event {
	uint32_t info;
	uint32_t mac_addr_l32;
	uint32_t info1;
} __packed;

struct htt_resp_msg {
	union {
		struct htt_t2h_version_conf_msg version_msg;
		struct htt_t2h_peer_map_event peer_map_ev;
		struct htt_t2h_peer_unmap_event peer_unmap_ev;
	};
} __packed;

#define HTT_BACKPRESSURE_EVENT_PDEV_ID_M GENMASK(15, 8)
#define HTT_BACKPRESSURE_EVENT_RING_TYPE_M GENMASK(23, 16)
#define HTT_BACKPRESSURE_EVENT_RING_ID_M GENMASK(31, 24)

#define HTT_BACKPRESSURE_EVENT_HP_M GENMASK(15, 0)
#define HTT_BACKPRESSURE_EVENT_TP_M GENMASK(31, 16)

#define HTT_BACKPRESSURE_UMAC_RING_TYPE	0
#define HTT_BACKPRESSURE_LMAC_RING_TYPE	1

enum htt_backpressure_umac_ringid {
	HTT_SW_RING_IDX_REO_REO2SW1_RING,
	HTT_SW_RING_IDX_REO_REO2SW2_RING,
	HTT_SW_RING_IDX_REO_REO2SW3_RING,
	HTT_SW_RING_IDX_REO_REO2SW4_RING,
	HTT_SW_RING_IDX_REO_WBM2REO_LINK_RING,
	HTT_SW_RING_IDX_REO_REO2TCL_RING,
	HTT_SW_RING_IDX_REO_REO2FW_RING,
	HTT_SW_RING_IDX_REO_REO_RELEASE_RING,
	HTT_SW_RING_IDX_WBM_PPE_RELEASE_RING,
	HTT_SW_RING_IDX_TCL_TCL2TQM_RING,
	HTT_SW_RING_IDX_WBM_TQM_RELEASE_RING,
	HTT_SW_RING_IDX_WBM_REO_RELEASE_RING,
	HTT_SW_RING_IDX_WBM_WBM2SW0_RELEASE_RING,
	HTT_SW_RING_IDX_WBM_WBM2SW1_RELEASE_RING,
	HTT_SW_RING_IDX_WBM_WBM2SW2_RELEASE_RING,
	HTT_SW_RING_IDX_WBM_WBM2SW3_RELEASE_RING,
	HTT_SW_RING_IDX_REO_REO_CMD_RING,
	HTT_SW_RING_IDX_REO_REO_STATUS_RING,
	HTT_SW_UMAC_RING_IDX_MAX,
};

enum htt_backpressure_lmac_ringid {
	HTT_SW_RING_IDX_FW2RXDMA_BUF_RING,
	HTT_SW_RING_IDX_FW2RXDMA_STATUS_RING,
	HTT_SW_RING_IDX_FW2RXDMA_LINK_RING,
	HTT_SW_RING_IDX_SW2RXDMA_BUF_RING,
	HTT_SW_RING_IDX_WBM2RXDMA_LINK_RING,
	HTT_SW_RING_IDX_RXDMA2FW_RING,
	HTT_SW_RING_IDX_RXDMA2SW_RING,
	HTT_SW_RING_IDX_RXDMA2RELEASE_RING,
	HTT_SW_RING_IDX_RXDMA2REO_RING,
	HTT_SW_RING_IDX_MONITOR_STATUS_RING,
	HTT_SW_RING_IDX_MONITOR_BUF_RING,
	HTT_SW_RING_IDX_MONITOR_DESC_RING,
	HTT_SW_RING_IDX_MONITOR_DEST_RING,
	HTT_SW_LMAC_RING_IDX_MAX,
};

/* ppdu stats
 *
 * @details
 * The following field definitions describe the format of the HTT target
 * to host ppdu stats indication message.
 *
 *
 * |31                         16|15   12|11   10|9      8|7            0 |
 * |----------------------------------------------------------------------|
 * |    payload_size             | rsvd  |pdev_id|mac_id  |    msg type   |
 * |----------------------------------------------------------------------|
 * |                          ppdu_id                                     |
 * |----------------------------------------------------------------------|
 * |                        Timestamp in us                               |
 * |----------------------------------------------------------------------|
 * |                          reserved                                    |
 * |----------------------------------------------------------------------|
 * |                    type-specific stats info                          |
 * |                     (see htt_ppdu_stats.h)                           |
 * |----------------------------------------------------------------------|
 * Header fields:
 *  - MSG_TYPE
 *    Bits 7:0
 *    Purpose: Identifies this is a PPDU STATS indication
 *             message.
 *    Value: 0x1d
 *  - mac_id
 *    Bits 9:8
 *    Purpose: mac_id of this ppdu_id
 *    Value: 0-3
 *  - pdev_id
 *    Bits 11:10
 *    Purpose: pdev_id of this ppdu_id
 *    Value: 0-3
 *     0 (for rings at SOC level),
 *     1/2/3 PDEV -> 0/1/2
 *  - payload_size
 *    Bits 31:16
 *    Purpose: total tlv size
 *    Value: payload_size in bytes
 */

#define HTT_T2H_PPDU_STATS_INFO_PDEV_ID GENMASK(11, 10)
#define HTT_T2H_PPDU_STATS_INFO_PAYLOAD_SIZE GENMASK(31, 16)

struct ath11k_htt_ppdu_stats_msg {
	uint32_t info;
	uint32_t ppdu_id;
	uint32_t timestamp;
	uint32_t rsvd;
	uint8_t data[];
} __packed;

struct htt_tlv {
	uint32_t header;
	uint8_t *value;
} __packed;

#define HTT_TLV_TAG			GENMASK(11, 0)
#define HTT_TLV_LEN			GENMASK(23, 12)

enum HTT_PPDU_STATS_BW {
	HTT_PPDU_STATS_BANDWIDTH_5MHZ   = 0,
	HTT_PPDU_STATS_BANDWIDTH_10MHZ  = 1,
	HTT_PPDU_STATS_BANDWIDTH_20MHZ  = 2,
	HTT_PPDU_STATS_BANDWIDTH_40MHZ  = 3,
	HTT_PPDU_STATS_BANDWIDTH_80MHZ  = 4,
	HTT_PPDU_STATS_BANDWIDTH_160MHZ = 5, /* includes 80+80 */
	HTT_PPDU_STATS_BANDWIDTH_DYN    = 6,
};

#define HTT_PPDU_STATS_CMN_FLAGS_FRAME_TYPE_M	GENMASK(7, 0)
#define HTT_PPDU_STATS_CMN_FLAGS_QUEUE_TYPE_M	GENMASK(15, 8)
/* bw - HTT_PPDU_STATS_BW */
#define HTT_PPDU_STATS_CMN_FLAGS_BW_M		GENMASK(19, 16)

struct htt_ppdu_stats_common {
	uint32_t ppdu_id;
	uint16_t sched_cmdid;
	uint8_t ring_id;
	uint8_t num_users;
	uint32_t flags; /* %HTT_PPDU_STATS_COMMON_FLAGS_*/
	uint32_t chain_mask;
	uint32_t fes_duration_us; /* frame exchange sequence */
	uint32_t ppdu_sch_eval_start_tstmp_us;
	uint32_t ppdu_sch_end_tstmp_us;
	uint32_t ppdu_start_tstmp_us;
	/* BIT [15 :  0] - phy mode (WLAN_PHY_MODE) with which ppdu was transmitted
	 * BIT [31 : 16] - bandwidth (in MHz) with which ppdu was transmitted
	 */
	uint16_t phy_mode;
	uint16_t bw_mhz;
} __packed;

enum htt_ppdu_stats_gi {
	HTT_PPDU_STATS_SGI_0_8_US,
	HTT_PPDU_STATS_SGI_0_4_US,
	HTT_PPDU_STATS_SGI_1_6_US,
	HTT_PPDU_STATS_SGI_3_2_US,
};

#define HTT_PPDU_STATS_USER_RATE_INFO0_USER_POS_M	GENMASK(3, 0)
#define HTT_PPDU_STATS_USER_RATE_INFO0_MU_GROUP_ID_M	GENMASK(11, 4)

#define HTT_PPDU_STATS_USER_RATE_INFO1_RESP_TYPE_VALD_M	BIT(0)
#define HTT_PPDU_STATS_USER_RATE_INFO1_PPDU_TYPE_M	GENMASK(5, 1)

#define HTT_PPDU_STATS_USER_RATE_FLAGS_LTF_SIZE_M	GENMASK(1, 0)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_STBC_M		BIT(2)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_HE_RE_M		BIT(3)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_TXBF_M		GENMASK(7, 4)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_BW_M		GENMASK(11, 8)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_NSS_M		GENMASK(15, 12)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_MCS_M		GENMASK(19, 16)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_PREAMBLE_M	GENMASK(23, 20)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_GI_M		GENMASK(27, 24)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_DCM_M		BIT(28)
#define HTT_PPDU_STATS_USER_RATE_FLAGS_LDPC_M		BIT(29)

#define HTT_USR_RATE_PREAMBLE(_val) \
		FIELD_GET(HTT_PPDU_STATS_USER_RATE_FLAGS_PREAMBLE_M, _val)
#define HTT_USR_RATE_BW(_val) \
		FIELD_GET(HTT_PPDU_STATS_USER_RATE_FLAGS_BW_M, _val)
#define HTT_USR_RATE_NSS(_val) \
		FIELD_GET(HTT_PPDU_STATS_USER_RATE_FLAGS_NSS_M, _val)
#define HTT_USR_RATE_MCS(_val) \
		FIELD_GET(HTT_PPDU_STATS_USER_RATE_FLAGS_MCS_M, _val)
#define HTT_USR_RATE_GI(_val) \
		FIELD_GET(HTT_PPDU_STATS_USER_RATE_FLAGS_GI_M, _val)
#define HTT_USR_RATE_DCM(_val) \
		FIELD_GET(HTT_PPDU_STATS_USER_RATE_FLAGS_DCM_M, _val)

#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_LTF_SIZE_M		GENMASK(1, 0)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_STBC_M		BIT(2)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_HE_RE_M		BIT(3)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_TXBF_M		GENMASK(7, 4)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_BW_M		GENMASK(11, 8)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_NSS_M		GENMASK(15, 12)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_MCS_M		GENMASK(19, 16)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_PREAMBLE_M		GENMASK(23, 20)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_GI_M		GENMASK(27, 24)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_DCM_M		BIT(28)
#define HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_LDPC_M		BIT(29)

struct htt_ppdu_stats_user_rate {
	uint8_t tid_num;
	uint8_t reserved0;
	uint16_t sw_peer_id;
	uint32_t info0; /* %HTT_PPDU_STATS_USER_RATE_INFO0_*/
	uint16_t ru_end;
	uint16_t ru_start;
	uint16_t resp_ru_end;
	uint16_t resp_ru_start;
	uint32_t info1; /* %HTT_PPDU_STATS_USER_RATE_INFO1_ */
	uint32_t rate_flags; /* %HTT_PPDU_STATS_USER_RATE_FLAGS_ */
	/* Note: resp_rate_info is only valid for if resp_type is UL */
	uint32_t resp_rate_flags; /* %HTT_PPDU_STATS_USER_RATE_RESP_FLAGS_ */
} __packed;

#define HTT_PPDU_STATS_TX_INFO_FLAGS_RATECODE_M		GENMASK(7, 0)
#define HTT_PPDU_STATS_TX_INFO_FLAGS_IS_AMPDU_M		BIT(8)
#define HTT_PPDU_STATS_TX_INFO_FLAGS_BA_ACK_FAILED_M	GENMASK(10, 9)
#define HTT_PPDU_STATS_TX_INFO_FLAGS_BW_M		GENMASK(13, 11)
#define HTT_PPDU_STATS_TX_INFO_FLAGS_SGI_M		BIT(14)
#define HTT_PPDU_STATS_TX_INFO_FLAGS_PEERID_M		GENMASK(31, 16)

#define HTT_TX_INFO_IS_AMSDU(_flags) \
			FIELD_GET(HTT_PPDU_STATS_TX_INFO_FLAGS_IS_AMPDU_M, _flags)
#define HTT_TX_INFO_BA_ACK_FAILED(_flags) \
			FIELD_GET(HTT_PPDU_STATS_TX_INFO_FLAGS_BA_ACK_FAILED_M, _flags)
#define HTT_TX_INFO_RATECODE(_flags) \
			FIELD_GET(HTT_PPDU_STATS_TX_INFO_FLAGS_RATECODE_M, _flags)
#define HTT_TX_INFO_PEERID(_flags) \
			FIELD_GET(HTT_PPDU_STATS_TX_INFO_FLAGS_PEERID_M, _flags)

struct htt_tx_ppdu_stats_info {
	struct htt_tlv tlv_hdr;
	uint32_t tx_success_bytes;
	uint32_t tx_retry_bytes;
	uint32_t tx_failed_bytes;
	uint32_t flags; /* %HTT_PPDU_STATS_TX_INFO_FLAGS_ */
	uint16_t tx_success_msdus;
	uint16_t tx_retry_msdus;
	uint16_t tx_failed_msdus;
	uint16_t tx_duration; /* united in us */
} __packed;

enum  htt_ppdu_stats_usr_compln_status {
	HTT_PPDU_STATS_USER_STATUS_OK,
	HTT_PPDU_STATS_USER_STATUS_FILTERED,
	HTT_PPDU_STATS_USER_STATUS_RESP_TIMEOUT,
	HTT_PPDU_STATS_USER_STATUS_RESP_MISMATCH,
	HTT_PPDU_STATS_USER_STATUS_ABORT,
};

#define HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_LONG_RETRY_M	GENMASK(3, 0)
#define HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_SHORT_RETRY_M	GENMASK(7, 4)
#define HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_IS_AMPDU_M		BIT(8)
#define HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_RESP_TYPE_M		GENMASK(12, 9)

#define HTT_USR_CMPLTN_IS_AMPDU(_val) \
	    FIELD_GET(HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_IS_AMPDU_M, _val)
#define HTT_USR_CMPLTN_LONG_RETRY(_val) \
	    FIELD_GET(HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_LONG_RETRY_M, _val)
#define HTT_USR_CMPLTN_SHORT_RETRY(_val) \
	    FIELD_GET(HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_SHORT_RETRY_M, _val)

struct htt_ppdu_stats_usr_cmpltn_cmn {
	uint8_t status;
	uint8_t tid_num;
	uint16_t sw_peer_id;
	/* RSSI value of last ack packet (units = dB above noise floor) */
	uint32_t ack_rssi;
	uint16_t mpdu_tried;
	uint16_t mpdu_success;
	uint32_t flags; /* %HTT_PPDU_STATS_USR_CMPLTN_CMN_FLAGS_LONG_RETRIES*/
} __packed;

#define HTT_PPDU_STATS_ACK_BA_INFO_NUM_MPDU_M	GENMASK(8, 0)
#define HTT_PPDU_STATS_ACK_BA_INFO_NUM_MSDU_M	GENMASK(24, 9)
#define HTT_PPDU_STATS_ACK_BA_INFO_TID_NUM	GENMASK(31, 25)

#define HTT_PPDU_STATS_NON_QOS_TID	16

struct htt_ppdu_stats_usr_cmpltn_ack_ba_status {
	uint32_t ppdu_id;
	uint16_t sw_peer_id;
	uint16_t reserved0;
	uint32_t info; /* %HTT_PPDU_STATS_USR_CMPLTN_CMN_INFO_ */
	uint16_t current_seq;
	uint16_t start_seq;
	uint32_t success_bytes;
} __packed;

struct htt_ppdu_stats_usr_cmn_array {
	struct htt_tlv tlv_hdr;
	uint32_t num_ppdu_stats;
	/* tx_ppdu_stats_info is filled by multiple struct htt_tx_ppdu_stats_info
	 * elements.
	 * tx_ppdu_stats_info is variable length, with length =
	 *     number_of_ppdu_stats * sizeof (struct htt_tx_ppdu_stats_info)
	 */
	struct htt_tx_ppdu_stats_info tx_ppdu_info[];
} __packed;

struct htt_ppdu_user_stats {
	uint16_t peer_id;
	uint32_t tlv_flags;
	bool is_valid_peer_id;
	struct htt_ppdu_stats_user_rate rate;
	struct htt_ppdu_stats_usr_cmpltn_cmn cmpltn_cmn;
	struct htt_ppdu_stats_usr_cmpltn_ack_ba_status ack_ba;
};

#define HTT_PPDU_STATS_MAX_USERS	8
#define HTT_PPDU_DESC_MAX_DEPTH	16

struct htt_ppdu_stats {
	struct htt_ppdu_stats_common common;
	struct htt_ppdu_user_stats user_stats[HTT_PPDU_STATS_MAX_USERS];
};

struct htt_ppdu_stats_info {
	uint32_t ppdu_id;
	struct htt_ppdu_stats ppdu_stats;
#if 0
	struct list_head list;
#endif
};

/* @brief target -> host packet log message
 *
 * @details
 * The following field definitions describe the format of the packet log
 * message sent from the target to the host.
 * The message consists of a 4-octet header,followed by a variable number
 * of 32-bit character values.
 *
 * |31                         16|15  12|11   10|9    8|7            0|
 * |------------------------------------------------------------------|
 * |        payload_size         | rsvd |pdev_id|mac_id|   msg type   |
 * |------------------------------------------------------------------|
 * |                              payload                             |
 * |------------------------------------------------------------------|
 *   - MSG_TYPE
 *     Bits 7:0
 *     Purpose: identifies this as a pktlog message
 *     Value: HTT_T2H_MSG_TYPE_PKTLOG
 *   - mac_id
 *     Bits 9:8
 *     Purpose: identifies which MAC/PHY instance generated this pktlog info
 *     Value: 0-3
 *   - pdev_id
 *     Bits 11:10
 *     Purpose: pdev_id
 *     Value: 0-3
 *     0 (for rings at SOC level),
 *     1/2/3 PDEV -> 0/1/2
 *   - payload_size
 *     Bits 31:16
 *     Purpose: explicitly specify the payload size
 *     Value: payload size in bytes (payload size is a multiple of 4 bytes)
 */
struct htt_pktlog_msg {
	uint32_t hdr;
	uint8_t payload[];
};

/* @brief host -> target FW extended statistics retrieve
 *
 * @details
 * The following field definitions describe the format of the HTT host
 * to target FW extended stats retrieve message.
 * The message specifies the type of stats the host wants to retrieve.
 *
 * |31          24|23          16|15           8|7            0|
 * |-----------------------------------------------------------|
 * |   reserved   | stats type   |   pdev_mask  |   msg type   |
 * |-----------------------------------------------------------|
 * |                   config param [0]                        |
 * |-----------------------------------------------------------|
 * |                   config param [1]                        |
 * |-----------------------------------------------------------|
 * |                   config param [2]                        |
 * |-----------------------------------------------------------|
 * |                   config param [3]                        |
 * |-----------------------------------------------------------|
 * |                         reserved                          |
 * |-----------------------------------------------------------|
 * |                        cookie LSBs                        |
 * |-----------------------------------------------------------|
 * |                        cookie MSBs                        |
 * |-----------------------------------------------------------|
 * Header fields:
 *  - MSG_TYPE
 *    Bits 7:0
 *    Purpose: identifies this is a extended stats upload request message
 *    Value: 0x10
 *  - PDEV_MASK
 *    Bits 8:15
 *    Purpose: identifies the mask of PDEVs to retrieve stats from
 *    Value: This is a overloaded field, refer to usage and interpretation of
 *           PDEV in interface document.
 *           Bit   8    :  Reserved for SOC stats
 *           Bit 9 - 15 :  Indicates PDEV_MASK in DBDC
 *                         Indicates MACID_MASK in DBS
 *  - STATS_TYPE
 *    Bits 23:16
 *    Purpose: identifies which FW statistics to upload
 *    Value: Defined by htt_dbg_ext_stats_type (see htt_stats.h)
 *  - Reserved
 *    Bits 31:24
 *  - CONFIG_PARAM [0]
 *    Bits 31:0
 *    Purpose: give an opaque configuration value to the specified stats type
 *    Value: stats-type specific configuration value
 *           Refer to htt_stats.h for interpretation for each stats sub_type
 *  - CONFIG_PARAM [1]
 *    Bits 31:0
 *    Purpose: give an opaque configuration value to the specified stats type
 *    Value: stats-type specific configuration value
 *           Refer to htt_stats.h for interpretation for each stats sub_type
 *  - CONFIG_PARAM [2]
 *    Bits 31:0
 *    Purpose: give an opaque configuration value to the specified stats type
 *    Value: stats-type specific configuration value
 *           Refer to htt_stats.h for interpretation for each stats sub_type
 *  - CONFIG_PARAM [3]
 *    Bits 31:0
 *    Purpose: give an opaque configuration value to the specified stats type
 *    Value: stats-type specific configuration value
 *           Refer to htt_stats.h for interpretation for each stats sub_type
 *  - Reserved [31:0] for future use.
 *  - COOKIE_LSBS
 *    Bits 31:0
 *    Purpose: Provide a mechanism to match a target->host stats confirmation
 *        message with its preceding host->target stats request message.
 *    Value: LSBs of the opaque cookie specified by the host-side requestor
 *  - COOKIE_MSBS
 *    Bits 31:0
 *    Purpose: Provide a mechanism to match a target->host stats confirmation
 *        message with its preceding host->target stats request message.
 *    Value: MSBs of the opaque cookie specified by the host-side requestor
 */

struct htt_ext_stats_cfg_hdr {
	uint8_t msg_type;
	uint8_t pdev_mask;
	uint8_t stats_type;
	uint8_t reserved;
} __packed;

struct htt_ext_stats_cfg_cmd {
	struct htt_ext_stats_cfg_hdr hdr;
	uint32_t cfg_param0;
	uint32_t cfg_param1;
	uint32_t cfg_param2;
	uint32_t cfg_param3;
	uint32_t reserved;
	uint32_t cookie_lsb;
	uint32_t cookie_msb;
} __packed;

/* htt stats config default params */
#define HTT_STAT_DEFAULT_RESET_START_OFFSET 0
#define HTT_STAT_DEFAULT_CFG0_ALL_HWQS 0xffffffff
#define HTT_STAT_DEFAULT_CFG0_ALL_TXQS 0xffffffff
#define HTT_STAT_DEFAULT_CFG0_ALL_CMDQS 0xffff
#define HTT_STAT_DEFAULT_CFG0_ALL_RINGS 0xffff
#define HTT_STAT_DEFAULT_CFG0_ACTIVE_PEERS 0xff
#define HTT_STAT_DEFAULT_CFG0_CCA_CUMULATIVE 0x00
#define HTT_STAT_DEFAULT_CFG0_ACTIVE_VDEVS 0x00

/* HTT_DBG_EXT_STATS_PEER_INFO
 * PARAMS:
 * @config_param0:
 *  [Bit0] - [0] for sw_peer_id, [1] for mac_addr based request
 *  [Bit15 : Bit 1] htt_peer_stats_req_mode_t
 *  [Bit31 : Bit16] sw_peer_id
 * @config_param1:
 *  peer_stats_req_type_mask:32 (enum htt_peer_stats_tlv_enum)
 *   0 bit htt_peer_stats_cmn_tlv
 *   1 bit htt_peer_details_tlv
 *   2 bit htt_tx_peer_rate_stats_tlv
 *   3 bit htt_rx_peer_rate_stats_tlv
 *   4 bit htt_tx_tid_stats_tlv/htt_tx_tid_stats_v1_tlv
 *   5 bit htt_rx_tid_stats_tlv
 *   6 bit htt_msdu_flow_stats_tlv
 * @config_param2: [Bit31 : Bit0] mac_addr31to0
 * @config_param3: [Bit15 : Bit0] mac_addr47to32
 *                [Bit31 : Bit16] reserved
 */
#define HTT_STAT_PEER_INFO_MAC_ADDR BIT(0)
#define HTT_STAT_DEFAULT_PEER_REQ_TYPE 0x7f

/* Used to set different configs to the specified stats type.*/
struct htt_ext_stats_cfg_params {
	uint32_t cfg0;
	uint32_t cfg1;
	uint32_t cfg2;
	uint32_t cfg3;
};

/* @brief target -> host extended statistics upload
 *
 * @details
 * The following field definitions describe the format of the HTT target
 * to host stats upload confirmation message.
 * The message contains a cookie echoed from the HTT host->target stats
 * upload request, which identifies which request the confirmation is
 * for, and a single stats can span over multiple HTT stats indication
 * due to the HTT message size limitation so every HTT ext stats indication
 * will have tag-length-value stats information elements.
 * The tag-length header for each HTT stats IND message also includes a
 * status field, to indicate whether the request for the stat type in
 * question was fully met, partially met, unable to be met, or invalid
 * (if the stat type in question is disabled in the target).
 * A Done bit 1's indicate the end of the of stats info elements.
 *
 *
 * |31                         16|15    12|11|10 8|7   5|4       0|
 * |--------------------------------------------------------------|
 * |                   reserved                   |    msg type   |
 * |--------------------------------------------------------------|
 * |                         cookie LSBs                          |
 * |--------------------------------------------------------------|
 * |                         cookie MSBs                          |
 * |--------------------------------------------------------------|
 * |      stats entry length     | rsvd   | D|  S |   stat type   |
 * |--------------------------------------------------------------|
 * |                   type-specific stats info                   |
 * |                      (see htt_stats.h)                       |
 * |--------------------------------------------------------------|
 * Header fields:
 *  - MSG_TYPE
 *    Bits 7:0
 *    Purpose: Identifies this is a extended statistics upload confirmation
 *             message.
 *    Value: 0x1c
 *  - COOKIE_LSBS
 *    Bits 31:0
 *    Purpose: Provide a mechanism to match a target->host stats confirmation
 *        message with its preceding host->target stats request message.
 *    Value: LSBs of the opaque cookie specified by the host-side requestor
 *  - COOKIE_MSBS
 *    Bits 31:0
 *    Purpose: Provide a mechanism to match a target->host stats confirmation
 *        message with its preceding host->target stats request message.
 *    Value: MSBs of the opaque cookie specified by the host-side requestor
 *
 * Stats Information Element tag-length header fields:
 *  - STAT_TYPE
 *    Bits 7:0
 *    Purpose: identifies the type of statistics info held in the
 *        following information element
 *    Value: htt_dbg_ext_stats_type
 *  - STATUS
 *    Bits 10:8
 *    Purpose: indicate whether the requested stats are present
 *    Value: htt_dbg_ext_stats_status
 *  - DONE
 *    Bits 11
 *    Purpose:
 *        Indicates the completion of the stats entry, this will be the last
 *        stats conf HTT segment for the requested stats type.
 *    Value:
 *        0 -> the stats retrieval is ongoing
 *        1 -> the stats retrieval is complete
 *  - LENGTH
 *    Bits 31:16
 *    Purpose: indicate the stats information size
 *    Value: This field specifies the number of bytes of stats information
 *       that follows the element tag-length header.
 *       It is expected but not required that this length is a multiple of
 *       4 bytes.
 */

#define HTT_T2H_EXT_STATS_INFO1_DONE	BIT(11)
#define HTT_T2H_EXT_STATS_INFO1_LENGTH   GENMASK(31, 16)

struct ath11k_htt_extd_stats_msg {
	uint32_t info0;
	uint64_t cookie;
	uint32_t info1;
	uint8_t data[];
} __packed;

#define	HTT_MAC_ADDR_L32_0	GENMASK(7, 0)
#define	HTT_MAC_ADDR_L32_1	GENMASK(15, 8)
#define	HTT_MAC_ADDR_L32_2	GENMASK(23, 16)
#define	HTT_MAC_ADDR_L32_3	GENMASK(31, 24)
#define	HTT_MAC_ADDR_H16_0	GENMASK(7, 0)
#define	HTT_MAC_ADDR_H16_1	GENMASK(15, 8)
