untrusted comment: signature from openbsd 5.8 base secret key
RWQNNZXtC/MqP6TwWoUSDoNQ8kJqeVztM44Xq/DZNTIv/bUEiI6B/pwxqYlJhyslvPI33jfc+E7j1ON8YhT/Abes1YjXivrcLgc=

OpenBSD 5.8 errata 19, Jul 14, 2016:

ufs_readdir failed to limit size of memory allocation, leading to panics.

Apply by doing:
    signify -Vep /etc/signify/openbsd-58-base.pub -x 019_dirent.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/ufs/ufs/ufs_vnops.c
===================================================================
RCS file: /cvs/src/sys/ufs/ufs/ufs_vnops.c,v
retrieving revision 1.121.4.1
diff -u -p -u -r1.121 -r1.121.4.1
--- sys/ufs/ufs/ufs_vnops.c	17 Apr 2015 04:43:21 -0000	1.121
+++ sys/ufs/ufs/ufs_vnops.c	14 Jul 2016 03:37:42 -0000	1.121.4.1
@@ -1459,7 +1459,7 @@ ufs_readdir(void *v)
 	 */
 
 	/* read from disk, stopping on a block boundary, max 64kB */
-	readcnt = max(count, 64*1024) - entries;
+	readcnt = min(count, 64*1024) - entries;
 
 	auio = *uio;
 	auio.uio_iov = &aiov;
