untrusted comment: signature from openbsd 5.9 base secret key
RWQJVNompF3pwesxkrLps2cdf+wDoQtWpNARdw7/rcw0725Y3VIhGVadXmLXcPgzKyc5o/9xg/YLm261ifNQh5hyGKszRgHXSA4=

OpenBSD 5.9 errata 008, May 18, 2016:

A problem in the bnx(4) driver may result in corrupted network data.

Apply by doing:
    signify -Vep /etc/signify/openbsd-59-base.pub -x 008_bnx.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/pci/if_bnx.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/if_bnx.c,v
retrieving revision 1.120
retrieving revision 1.120.2.1
diff -u -p -r1.120 -r1.120.2.1
--- sys/dev/pci/if_bnx.c	11 Dec 2015 16:07:01 -0000	1.120
+++ sys/dev/pci/if_bnx.c	6 May 2016 03:26:38 -0000	1.120.2.1
@@ -2418,7 +2418,7 @@ bnx_dma_alloc(struct bnx_softc *sc)
 	 */
 	for (i = 0; i < TOTAL_TX_BD; i++) {
 		if (bus_dmamap_create(sc->bnx_dmatag,
-		    MCLBYTES * BNX_MAX_SEGMENTS, USABLE_TX_BD,
+		    MCLBYTES * BNX_MAX_SEGMENTS, BNX_MAX_SEGMENTS,
 		    MCLBYTES, 0, BUS_DMA_NOWAIT, &sc->tx_mbuf_map[i])) {
 			printf(": Could not create Tx mbuf %d DMA map!\n", 1);
 			rc = ENOMEM;
@@ -4893,7 +4893,8 @@ bnx_start(struct ifnet *ifp)
 	 */
 	used = 0;
 	while (1) {
-		if (sc->used_tx_bd + used + BNX_MAX_SEGMENTS >= sc->max_tx_bd) {
+		if (sc->used_tx_bd + used + BNX_MAX_SEGMENTS + 1 >=
+		    sc->max_tx_bd) {
 			DBPRINT(sc, BNX_INFO_SEND, "TX chain is closed for "
 			    "business! Total tx_bd used = %d\n",
 			    sc->used_tx_bd + used);
