untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEml3TkqBRg680RBxu/ZjYLuIcw4QfG1sCxlmtYdq78vDWDLrOKVepw5RgmvBQIsQIPex5Hx9HNRQHzjAh8ZtNgs=

OpenBSD 6.1 errata 019, August 3, 2017:

With an invalid address family, tcp_usrreq() may take an unintended code path.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 019_tcp_usrreq.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/tcp_usrreq.c
===================================================================
RCS file: /cvs/src/sys/netinet/tcp_usrreq.c,v
--- sys/netinet/tcp_usrreq.c	20 Jul 2016 19:57:53 -0000	1.134
+++ sys/netinet/tcp_usrreq.c	2 Aug 2017 16:37:39 -0000
@@ -236,9 +236,9 @@ tcp_usrreq(so, req, m, nam, control, p)
 			}
 
 			error = in6_pcbconnect(inp, nam);
-		} else if (sin->sin_family == AF_INET)
+		} else
 #endif /* INET6 */
-		{
+		if (sin->sin_family == AF_INET) {
 			if ((sin->sin_addr.s_addr == INADDR_ANY) ||
 			    (sin->sin_addr.s_addr == INADDR_BROADCAST) ||
 			    IN_MULTICAST(sin->sin_addr.s_addr) ||
@@ -248,6 +248,8 @@ tcp_usrreq(so, req, m, nam, control, p)
 			}
 
 			error = in_pcbconnect(inp, nam);
+		} else {
+			error = EAFNOSUPPORT;
 		}
 
 		if (error)
