untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76ZfapRV3SqPXG7xb/EdhSN04N25+2Ylq5zoMZ4nkFMt2JTDcLzreIXGVQ/jrTJG6+uSI2hBwaO97iDa+ZppfqJAY=

OpenBSD 6.3 errata 014, July 31, 2018:

On AMD cpus, set a chicken bit which turns LFENCE into a serialization
instruction against speculation.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 014_amdlfence.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/identcpu.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/identcpu.c,v
retrieving revision 1.95.2.1
diff -u -p -u -r1.95.2.1 identcpu.c
--- sys/arch/amd64/amd64/identcpu.c	16 Jun 2018 20:37:22 -0000	1.95.2.1
+++ sys/arch/amd64/amd64/identcpu.c	24 Jul 2018 17:40:34 -0000
@@ -635,6 +635,27 @@ identifycpu(struct cpu_info *ci)
 	x86_print_cacheinfo(ci);
 
 	/*
+	 * "Mitigation G-2" per AMD's Whitepaper "Software Techniques
+	 * for Managing Speculation on AMD Processors"
+	 *
+	 * By setting MSR C001_1029[1]=1, LFENCE becomes a dispatch
+	 * serializing instruction.
+	 *
+	 * This MSR is available on all AMD families >= 10h, except 11h
+	 * where LFENCE is always serializing.
+	 */
+	if (!strcmp(cpu_vendor, "AuthenticAMD")) {
+		if (ci->ci_family >= 0x10 && ci->ci_family != 0x11) {
+			uint64_t msr;
+
+			msr = rdmsr(MSR_DE_CFG);
+#define DE_CFG_SERIALIZE_LFENCE	(1 << 1)
+			msr |= DE_CFG_SERIALIZE_LFENCE;
+			wrmsr(MSR_DE_CFG, msr);
+		}
+	}
+
+	/*
 	 * Attempt to disable Silicon Debug and lock the configuration
 	 * if it's enabled and unlocked.
 	 */
Index: sys/arch/i386/i386/machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/i386/i386/machdep.c,v
retrieving revision 1.612
diff -u -p -u -r1.612 machdep.c
--- sys/arch/i386/i386/machdep.c	22 Mar 2018 19:30:18 -0000	1.612
+++ sys/arch/i386/i386/machdep.c	24 Jul 2018 17:40:34 -0000
@@ -2009,6 +2009,27 @@ identifycpu(struct cpu_info *ci)
 	}
 
 	/*
+	 * "Mitigation G-2" per AMD's Whitepaper "Software Techniques
+	 * for Managing Speculation on AMD Processors"
+	 *
+	 * By setting MSR C001_1029[1]=1, LFENCE becomes a dispatch
+	 * serializing instruction.
+	 *
+	 * This MSR is available on all AMD families >= 10h, except 11h
+ 	 * where LFENCE is always serializing.
+	 */
+	if (!strcmp(cpu_vendor, "AuthenticAMD")) {
+		if (ci->ci_family >= 0x10 && ci->ci_family != 0x11) {
+			uint64_t msr;
+
+			msr = rdmsr(MSR_DE_CFG);
+#define DE_CFG_SERIALIZE_LFENCE	(1 << 1)
+			msr |= DE_CFG_SERIALIZE_LFENCE;
+			wrmsr(MSR_DE_CFG, msr);
+		}
+	}
+
+	/*
 	 * Attempt to disable Silicon Debug and lock the configuration
 	 * if it's enabled and unlocked.
 	 */
