untrusted comment: verify with openbsd-64-base.pub
RWQq6XmS4eDAcSEH7nmDNqOnhZqTvJZeTHqOhsDnaqVyRUC0apDsnvAsL7fochPDsukTGS8UMjD2djL2XdDTZRS/v+IMVjlK6Q0=

OpenBSD 6.4 errata 014, March 1, 2019:

Fragmented IPv6 packets may be erroneously passed by pf or lead to a crash.

Apply by doing:
    signify -Vep /etc/signify/openbsd-64-base.pub -x 014_pf6frag.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/pf_norm.c
===================================================================
RCS file: /cvs/src/sys/net/pf_norm.c,v
retrieving revision 1.216
diff -u -p -r1.216 pf_norm.c
--- sys/net/pf_norm.c	10 Sep 2018 16:14:07 -0000	1.216
+++ sys/net/pf_norm.c	27 Feb 2019 16:06:34 -0000
@@ -877,10 +877,10 @@ pf_reassemble6(struct mbuf **m0, struct 
 	}
 
 	/* We have all the data */
-	extoff = frent->fe_extoff;
-	maxlen = frag->fr_maxlen;
 	frent = TAILQ_FIRST(&frag->fr_queue);
 	KASSERT(frent != NULL);
+	extoff = frent->fe_extoff;
+	maxlen = frag->fr_maxlen;
 	total = TAILQ_LAST(&frag->fr_queue, pf_fragq)->fe_off +
 	    TAILQ_LAST(&frag->fr_queue, pf_fragq)->fe_len;
 	hdrlen = frent->fe_hdrlen - sizeof(struct ip6_frag);
