untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3lFvWhNE4oyxTrNfITgylCLqxGI8l3HmC6xooCuQiTjGdHBU3jPgrFVcihZHZ3FBjZv3f5htbnHil6anLswlHQA=

OpenBSD 6.7 errata 024, October 6, 2020:

mmap(2) can exhaust kernel memory for PROT_NONE MAP_SHARED mappings.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 024_mmap.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/uvm/uvm_mmap.c
===================================================================
RCS file: /cvs/src/sys/uvm/uvm_mmap.c,v
retrieving revision 1.161
diff -u -p -r1.161 uvm_mmap.c
--- sys/uvm/uvm_mmap.c	4 Mar 2020 21:15:39 -0000	1.161
+++ sys/uvm/uvm_mmap.c	5 Oct 2020 12:44:25 -0000
@@ -404,7 +404,7 @@ is_anon:	/* label for SunOS style /dev/z
 		if ((flags & __MAP_NOFAULT) != 0)
 			return EINVAL;
 
-		if (prot != PROT_NONE) {
+		if (prot != PROT_NONE || (flags & MAP_SHARED)) {
 			limit = lim_cur(RLIMIT_DATA);
 			if (limit < size ||
 			    limit - size < ptoa(p->p_vmspace->vm_dused)) {
