untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3r0xxdKD6xW8q9wccSFE9em2p0fePSi3g2S6LuF4UzWlRHuk7brvX0LPEv4a79BVWFJhSZR+8lpA0TPMz0RodQQ=

OpenBSD 6.7 errata 029, November 10, 2020:

rpki-client incorrectly checks the manifest validity interval.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 029_rpki.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install rpki-client:
    cd /usr/src/usr.sbin/rpki-client
    make obj
    make
    make install

Index: usr.sbin/rpki-client/mft.c
===================================================================
RCS file: /cvs/src/usr.sbin/rpki-client/mft.c,v
retrieving revision 1.14
diff -u -p -r1.14 mft.c
--- usr.sbin/rpki-client/mft.c	11 Apr 2020 15:53:44 -0000	1.14
+++ usr.sbin/rpki-client/mft.c	4 Nov 2020 19:07:16 -0000
@@ -55,33 +55,59 @@ gentime2str(const ASN1_GENERALIZEDTIME *
 }
 
 /*
+ * Convert an ASN1_GENERALIZEDTIME to a struct tm.
+ * Returns 1 on success, 0 on failure.
+ */
+static int
+generalizedtime_to_tm(const ASN1_GENERALIZEDTIME *gtime, struct tm *tm)
+{
+	const char *data;
+	size_t len;
+
+	data = ASN1_STRING_get0_data(gtime);
+	len = ASN1_STRING_length(gtime);
+
+	return ASN1_time_parse(data, len, tm, V_ASN1_GENERALIZEDTIME) ==
+	    V_ASN1_GENERALIZEDTIME;
+}
+
+/*
  * Validate and verify the time validity of the mft.
  * Returns 1 if all is good, 0 if mft is stale, any other case -1.
- * XXX should use ASN1_time_tm_cmp() once libressl is used.
  */
-static time_t
+static int
 check_validity(const ASN1_GENERALIZEDTIME *from,
     const ASN1_GENERALIZEDTIME *until, const char *fn, int force)
 {
 	time_t now = time(NULL);
+	struct tm tm_from, tm_until, tm_now;
 
-	if (!ASN1_GENERALIZEDTIME_check(from) ||
-	    !ASN1_GENERALIZEDTIME_check(until)) {
-		warnx("%s: embedded time format invalid", fn);
+	if (gmtime_r(&now, &tm_now) == NULL) {
+		warnx("%s: could not get current time", fn);
 		return -1;
 	}
+
+	if (!generalizedtime_to_tm(from, &tm_from)) {
+		warnx("%s: embedded from time format invalid", fn);
+		return -1;
+	}
+	if (!generalizedtime_to_tm(until, &tm_until)) {
+		warnx("%s: embedded until time format invalid", fn);
+		return -1;
+	}
+
 	/* check that until is not before from */
-	if (ASN1_STRING_cmp(until, from) < 0) {
+	if (ASN1_time_tm_cmp(&tm_until, &tm_from) < 0) {
 		warnx("%s: bad update interval", fn);
 		return -1;
 	}
 	/* check that now is not before from */
-	if (X509_cmp_time(from, &now) > 0) {
+	if (ASN1_time_tm_cmp(&tm_from, &tm_now) > 0) {
 		warnx("%s: mft not yet valid %s", fn, gentime2str(from));
 		return -1;
 	}
 	/* check that now is not after until */
-	if (X509_cmp_time(until, &now) < 0) {
+	if (ASN1_time_tm_cmp(&tm_until, &tm_now) < 0) {
 		warnx("%s: mft expired on %s%s", fn, gentime2str(until),
 		    force ? " (ignoring)" : "");
 		if (!force)
