untrusted comment: verify with openbsd-68-base.pub
RWQZj25CSG5R2h7LFmAu1l2QlTNpkZM5O9FpvyBh29lTUHqg5lv+cy1JX6sjnHI4hTCxfZyw13PgXDKpfHyHFjSAXFf4liknwQU=

OpenBSD 6.8 errata 012, January 13, 2021:

Use of bpf(4) on a carp interface could result in a use after free
error.

Apply by doing:
    signify -Vep /etc/signify/openbsd-68-base.pub -x 012_carp.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/netinet/ip_carp.c
===================================================================
RCS file: /cvs/src/sys/netinet/ip_carp.c,v
retrieving revision 1.349
diff -u -p -r1.349 ip_carp.c
--- sys/netinet/ip_carp.c	28 Jul 2020 16:44:34 -0000	1.349
+++ sys/netinet/ip_carp.c	8 Jan 2021 13:38:29 -0000
@@ -2282,10 +2282,8 @@ carp_transmit(struct carp_softc *sc, str
 #if NBPFILTER > 0
 	{
 		caddr_t if_bpf = ifp->if_bpf;
-		if (if_bpf) {
-			if (bpf_mtap_ether(if_bpf, m, BPF_DIRECTION_OUT))
-				m_freem(m);
-		}
+		if (if_bpf)
+			bpf_mtap_ether(if_bpf, m, BPF_DIRECTION_OUT);
 	}
 #endif /* NBPFILTER > 0 */
 
