untrusted comment: verify with openbsd-69-base.pub
RWQQsAemppS46DkY6ou6NbZXY5NxVVdvSsaui94j3hU7gVVuZeWmRHiBuyw3IgxCFywvug7TQJbh8sD781N9fSg4saY8YUylhgc=

OpenBSD 6.9 errata 002, May 18, 2021:

Request length checks were missing in libX11.

Apply by doing:
    signify -Vep /etc/signify/openbsd-69-base.pub -x 002_libx11.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then rebuild and install libX11:
    cd /usr/xenocara/lib/libX11
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: lib/libX11/src/Font.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/Font.c,v
retrieving revision 1.13
diff -u -p -r1.13 Font.c
--- lib/libX11/src/Font.c	28 Nov 2020 14:39:48 -0000	1.13
+++ lib/libX11/src/Font.c	9 May 2021 19:59:33 -0000
@@ -102,6 +102,8 @@ XFontStruct *XLoadQueryFont(
     XF86BigfontCodes *extcodes = _XF86BigfontCodes(dpy);
 #endif
 
+    if (strlen(name) >= USHRT_MAX)
+        return NULL;
     if (_XF86LoadQueryLocaleFont(dpy, name, &font_result, (Font *)0))
       return font_result;
     LockDisplay(dpy);
@@ -663,7 +665,7 @@ int _XF86LoadQueryLocaleFont(
     if (!name)
 	return 0;
     l = (int) strlen(name);
-    if (l < 2 || name[l - 1] != '*' || name[l - 2] != '-')
+    if (l < 2 || name[l - 1] != '*' || name[l - 2] != '-' || l >= USHRT_MAX)
 	return 0;
     charset = NULL;
     /* next three lines stolen from _XkbGetCharset() */
Index: lib/libX11/src/FontInfo.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/FontInfo.c,v
retrieving revision 1.10
diff -u -p -r1.10 FontInfo.c
--- lib/libX11/src/FontInfo.c	28 Nov 2020 14:39:48 -0000	1.10
+++ lib/libX11/src/FontInfo.c	9 May 2021 19:59:33 -0000
@@ -58,6 +58,9 @@ XFontStruct **info)	/* RETURN */
     register xListFontsReq *req;
     int j;
 
+    if (strlen(pattern) >= USHRT_MAX)
+        return NULL;
+
     LockDisplay(dpy);
     GetReq(ListFontsWithInfo, req);
     req->maxNames = maxNames;
Index: lib/libX11/src/FontNames.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/FontNames.c,v
retrieving revision 1.14
diff -u -p -r1.14 FontNames.c
--- lib/libX11/src/FontNames.c	28 Nov 2020 14:39:48 -0000	1.14
+++ lib/libX11/src/FontNames.c	9 May 2021 19:59:33 -0000
@@ -51,6 +51,9 @@ int *actualCount)	/* RETURN */
     register xListFontsReq *req;
     unsigned long rlen = 0;
 
+    if (strlen(pattern) >= USHRT_MAX)
+        return NULL;
+
     LockDisplay(dpy);
     GetReq(ListFonts, req);
     req->maxNames = maxNames;
Index: lib/libX11/src/GetColor.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/GetColor.c,v
retrieving revision 1.5
diff -u -p -r1.5 GetColor.c
--- lib/libX11/src/GetColor.c	28 Nov 2020 14:39:48 -0000	1.5
+++ lib/libX11/src/GetColor.c	9 May 2021 19:59:33 -0000
@@ -27,6 +27,7 @@ in this Software without prior written a
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
 #include <stdio.h>
 #include "Xlibint.h"
 #include "Xcmsint.h"
@@ -47,6 +48,9 @@ XColor *exact_def) /* RETURN */
     XcmsCCC ccc;
     XcmsColor cmsColor_exact;
     Status ret;
+
+    if (strlen(colorname) >= USHRT_MAX)
+        return (0);
 
 #ifdef XCMS
     /*
Index: lib/libX11/src/LoadFont.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/LoadFont.c,v
retrieving revision 1.4
diff -u -p -r1.4 LoadFont.c
--- lib/libX11/src/LoadFont.c	28 Nov 2020 14:39:48 -0000	1.4
+++ lib/libX11/src/LoadFont.c	9 May 2021 19:59:35 -0000
@@ -27,6 +27,7 @@ in this Software without prior written a
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
 #include "Xlibint.h"
 
 Font
@@ -37,6 +38,9 @@ XLoadFont (
     register long nbytes;
     Font fid;
     register xOpenFontReq *req;
+
+    if (strlen(name) >= USHRT_MAX)
+        return (0);
 
     if (_XF86LoadQueryLocaleFont(dpy, name, (XFontStruct **)0, &fid))
       return fid;
Index: lib/libX11/src/LookupCol.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/LookupCol.c,v
retrieving revision 1.5
diff -u -p -r1.5 LookupCol.c
--- lib/libX11/src/LookupCol.c	28 Nov 2020 14:39:48 -0000	1.5
+++ lib/libX11/src/LookupCol.c	9 May 2021 19:59:35 -0000
@@ -27,6 +27,7 @@ in this Software without prior written a
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
 #include <stdio.h>
 #include "Xlibint.h"
 #include "Xcmsint.h"
@@ -46,6 +47,9 @@ XLookupColor (
 	XcmsCCC ccc;
 	XcmsColor cmsColor_exact;
 
+	n = (int) strlen (spec);
+	if (n >= USHRT_MAX)
+            return 0;
 #ifdef XCMS
 	/*
 	 * Let's Attempt to use Xcms and i18n approach to Parse Color
@@ -77,8 +81,6 @@ XLookupColor (
 	 * Xcms and i18n methods failed, so lets pass it to the server
 	 * for parsing.
 	 */
-
-	n = (int) strlen (spec);
 	LockDisplay(dpy);
 	GetReq (LookupColor, req);
 	req->cmap = cmap;
Index: lib/libX11/src/ParseCol.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/ParseCol.c,v
retrieving revision 1.5
diff -u -p -r1.5 ParseCol.c
--- lib/libX11/src/ParseCol.c	28 Nov 2020 14:39:48 -0000	1.5
+++ lib/libX11/src/ParseCol.c	9 May 2021 19:59:35 -0000
@@ -27,6 +27,7 @@ in this Software without prior written a
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
 #include <stdio.h>
 #include "Xlibint.h"
 #include "Xcmsint.h"
@@ -47,6 +48,8 @@ XParseColor (
 
         if (!spec) return(0);
 	n = (int) strlen (spec);
+	if (n >= USHRT_MAX)
+            return(0);
 	if (*spec == '#') {
 	    /*
 	     * RGB
Index: lib/libX11/src/QuExt.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/QuExt.c,v
retrieving revision 1.5
diff -u -p -r1.5 QuExt.c
--- lib/libX11/src/QuExt.c	28 Nov 2020 14:39:48 -0000	1.5
+++ lib/libX11/src/QuExt.c	9 May 2021 19:59:35 -0000
@@ -27,6 +27,8 @@ in this Software without prior written a
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
+#include <stdbool.h>
 #include "Xlibint.h"
 
 Bool
@@ -39,6 +41,9 @@ XQueryExtension(
 {
     xQueryExtensionReply rep;
     register xQueryExtensionReq *req;
+
+    if (strlen(name) >= USHRT_MAX)
+        return false;
 
     LockDisplay(dpy);
     GetReq(QueryExtension, req);
Index: lib/libX11/src/SetFPath.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/SetFPath.c,v
retrieving revision 1.5
diff -u -p -r1.5 SetFPath.c
--- lib/libX11/src/SetFPath.c	28 Nov 2020 14:39:48 -0000	1.5
+++ lib/libX11/src/SetFPath.c	9 May 2021 19:59:35 -0000
@@ -26,6 +26,7 @@ in this Software without prior written a
 
 #ifdef HAVE_CONFIG_H
 #include <config.h>
+#include <limits.h>
 #endif
 #include "Xlibint.h"
 
@@ -49,6 +50,11 @@ XSetFontPath (
 	req->nFonts = ndirs;
 	for (i = 0; i < ndirs; i++) {
 		n = (int) ((size_t) n + (safestrlen (directories[i]) + 1));
+		if (n >= USHRT_MAX) {
+			UnlockDisplay(dpy);
+			SyncHandle();
+			return 0;
+		}
 	}
 	nbytes = (n + 3) & ~3;
 	req->length += nbytes >> 2;
Index: lib/libX11/src/SetHints.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/SetHints.c,v
retrieving revision 1.9
diff -u -p -r1.9 SetHints.c
--- lib/libX11/src/SetHints.c	28 Nov 2020 14:39:48 -0000	1.9
+++ lib/libX11/src/SetHints.c	9 May 2021 19:59:35 -0000
@@ -49,6 +49,7 @@ SOFTWARE.
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
 #include <X11/Xlibint.h>
 #include <X11/Xutil.h>
 #include "Xatomtype.h"
@@ -214,6 +215,8 @@ XSetCommand (
 	register char *buf, *bp;
 	for (i = 0, nbytes = 0; i < argc; i++) {
 		nbytes += safestrlen(argv[i]) + 1;
+		if (nbytes >= USHRT_MAX)
+                    return 1;
 	}
 	if ((bp = buf = Xmalloc(nbytes))) {
 	    /* copy arguments into single buffer */
@@ -256,6 +259,8 @@ XSetStandardProperties (
 
 	if (name != NULL) XStoreName (dpy, w, name);
 
+        if (safestrlen(icon_string) >= USHRT_MAX)
+            return 1;
 	if (icon_string != NULL) {
 	    XChangeProperty (dpy, w, XA_WM_ICON_NAME, XA_STRING, 8,
                              PropModeReplace,
@@ -298,6 +303,8 @@ XSetClassHint(
 
 	len_nm = safestrlen(classhint->res_name);
 	len_cl = safestrlen(classhint->res_class);
+        if (len_nm + len_cl >= USHRT_MAX)
+            return 1;
 	if ((class_string = s = Xmalloc(len_nm + len_cl + 2))) {
 	    if (len_nm) {
 		strcpy(s, classhint->res_name);
Index: lib/libX11/src/StNColor.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/StNColor.c,v
retrieving revision 1.4
diff -u -p -r1.4 StNColor.c
--- lib/libX11/src/StNColor.c	28 Nov 2020 14:39:48 -0000	1.4
+++ lib/libX11/src/StNColor.c	9 May 2021 19:59:35 -0000
@@ -27,6 +27,7 @@ in this Software without prior written a
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
 #include <stdio.h>
 #include "Xlibint.h"
 #include "Xcmsint.h"
@@ -46,6 +47,8 @@ int flags)  /* DoRed, DoGreen, DoBlue */
     XcmsColor cmsColor_exact;
     XColor scr_def;
 
+    if (strlen(name) >= USHRT_MAX)
+        return 0;
 #ifdef XCMS
     /*
      * Let's Attempt to use Xcms approach to Parse Color
Index: lib/libX11/src/StName.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/src/StName.c,v
retrieving revision 1.5
diff -u -p -r1.5 StName.c
--- lib/libX11/src/StName.c	28 Nov 2020 14:39:48 -0000	1.5
+++ lib/libX11/src/StName.c	9 May 2021 19:59:35 -0000
@@ -27,6 +27,7 @@ in this Software without prior written a
 #ifdef HAVE_CONFIG_H
 #include <config.h>
 #endif
+#include <limits.h>
 #include <X11/Xlibint.h>
 #include <X11/Xatom.h>
 
@@ -36,7 +37,9 @@ XStoreName (
     Window w,
     _Xconst char *name)
 {
-    return XChangeProperty(dpy, w, XA_WM_NAME, XA_STRING,
+    if (strlen(name) >= USHRT_MAX)
+        return 0;
+    return XChangeProperty(dpy, w, XA_WM_NAME, XA_STRING, /*  */
 			   8, PropModeReplace, (_Xconst unsigned char *)name,
 			   name ? (int) strlen(name) : 0);
 }
@@ -47,6 +50,8 @@ XSetIconName (
     Window w,
     _Xconst char *icon_name)
 {
+    if (strlen(icon_name) >= USHRT_MAX)
+        return 0;
     return XChangeProperty(dpy, w, XA_WM_ICON_NAME, XA_STRING, 8,
                            PropModeReplace, (_Xconst unsigned char *)icon_name,
 			   icon_name ? (int) strlen(icon_name) : 0);
