#!/usr/local/bin/python3
"""
Searches for `.so` linked manual pages and converts them to symlinks.

usage: man_symlinks.py <prefix>
"""

import os
import sys


def main(root_dir):
    print("# This file is auto-generated by the 'man_symlinks' target.\n")

    lines = []
    for f in os.scandir(root_dir):
        if not f.is_dir() or not f.name.startswith("man"):
            continue
        man_dir = os.path.join(root_dir, f.name)
        links = process_mandir(man_dir)

        man_dir = os.path.join("${PREFIX}", "man", f.name)
        if len(links) > 0:
            lines.append(f"cd {man_dir}")
            lines.extend(links)

    if len(lines) > 0:
        print("MAN_SYMLINKS_CMD = \\")
        print(" && \\\n".join([f"\t{line}" for line in lines]))


def process_mandir(direc):
    links = []
    for f in os.scandir(direc):
        if not f.is_file():
            continue

        path = os.path.join(direc, f.name)
        with open(path, "r", errors="ignore") as fh:
            for line in fh:
                line = line.strip()
                if line == "":
                    continue
                elif line.startswith(".so "):
                    src = os.path.join("..", line[4:])
                    links.append(f"ln -sf {src} {f.name}")
                break
    return links


if __name__ == "__main__":
    if len(sys.argv) != 2:
        sys.stderr.write(__doc__)
        sys.exit(1)

    main(sys.argv[1])
