untrusted comment: verify with openbsd-70-base.pub
RWR3KL+gSr4QZ7/QIJOaamJM4cF+Tc/JvQt0kUv11tu8k7smFH8Pi9Q7O2LJ3oQQuTisbxnooCJiyh7WUfHMQbjdpeXShNOyLQw=

OpenBSD 7.0 errata 023, July 24, 2022:

cron(8) aborted due to strange poll timevals.

Apply by doing:
    signify -Vep /etc/signify/openbsd-70-base.pub -x 023_cron.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install cron:
    cd /usr/src/usr.sbin/cron
    make obj
    make
    make install

Index: usr.sbin/cron/cron.c
===================================================================
RCS file: /cvs/src/usr.sbin/cron/cron.c,v
retrieving revision 1.79
diff -u -p -r1.79 cron.c
--- usr.sbin/cron/cron.c	16 Apr 2020 17:51:56 -0000	1.79
+++ usr.sbin/cron/cron.c	19 Jul 2022 23:05:52 -0000
@@ -358,6 +358,8 @@ cron_sleep(time_t target, sigset_t *mask
 	clock_gettime(CLOCK_REALTIME, &t1);
 	t1.tv_sec += GMToff;
 	timeout.tv_sec = (target * SECONDS_PER_MINUTE - t1.tv_sec) + 1;
+	if (timeout.tv_sec < 0)
+		timeout.tv_sec = 0;
 	timeout.tv_nsec = 0;
 
 	pfd[0].fd = cronSock;
@@ -411,9 +413,7 @@ cron_sleep(time_t target, sigset_t *mask
 		timespecsub(&timeout, &t1, &timeout);
 		memcpy(&t1, &t2, sizeof(t1));
 		if (timeout.tv_sec < 0)
-			timeout.tv_sec = 0;
-		if (timeout.tv_nsec < 0)
-			timeout.tv_nsec = 0;
+			timespecclear(&timeout);
 	}
 }
 
