/* Corebird.c generated by valac 0.34.6, the Vala compiler
 * generated from Corebird.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gst/gst.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include "CbMediaDownloader.h"
#include "CbTweet.h"
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"


#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
typedef struct _CorebirdPrivate CorebirdPrivate;

#define TYPE_SETTINGS_DIALOG (settings_dialog_get_type ())
#define SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SETTINGS_DIALOG, SettingsDialog))
#define SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SETTINGS_DIALOG, SettingsDialogClass))
#define IS_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SETTINGS_DIALOG))
#define IS_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SETTINGS_DIALOG))
#define SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SETTINGS_DIALOG, SettingsDialogClass))

typedef struct _SettingsDialog SettingsDialog;
typedef struct _SettingsDialogClass SettingsDialogClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define TYPE_ABOUT_DIALOG (about_dialog_get_type ())
#define ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABOUT_DIALOG, AboutDialog))
#define ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABOUT_DIALOG, AboutDialogClass))
#define IS_ABOUT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABOUT_DIALOG))
#define IS_ABOUT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABOUT_DIALOG))
#define ABOUT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABOUT_DIALOG, AboutDialogClass))

typedef struct _AboutDialog AboutDialog;
typedef struct _AboutDialogClass AboutDialogClass;

#define TYPE_COMPOSE_IMAGE_MANAGER (compose_image_manager_get_type ())
#define COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager))
#define COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))
#define IS_COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_IMAGE_MANAGER))
#define IS_COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_IMAGE_MANAGER))
#define COMPOSE_IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))

typedef struct _ComposeImageManager ComposeImageManager;
typedef struct _ComposeImageManagerClass ComposeImageManagerClass;

#define TYPE_LAZY_MENU_BUTTON (lazy_menu_button_get_type ())
#define LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButton))
#define LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))
#define IS_LAZY_MENU_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LAZY_MENU_BUTTON))
#define IS_LAZY_MENU_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LAZY_MENU_BUTTON))
#define LAZY_MENU_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LAZY_MENU_BUTTON, LazyMenuButtonClass))

typedef struct _LazyMenuButton LazyMenuButton;
typedef struct _LazyMenuButtonClass LazyMenuButtonClass;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _AccountPrivate AccountPrivate;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_PAGE (page_get_type ())

struct _Corebird {
	GtkApplication parent_instance;
	CorebirdPrivate * priv;
};

struct _CorebirdClass {
	GtkApplicationClass parent_class;
};

struct _CorebirdPrivate {
	SettingsDialog* settings_dialog;
	GPtrArray* active_accounts;
	gboolean started_as_service;
};

struct _Block1Data {
	int _ref_count_;
	Corebird* self;
	GSimpleAction* action;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;


static gpointer corebird_parent_class = NULL;
extern SqlDatabase* corebird_db;
SqlDatabase* corebird_db = NULL;
extern SnippetManager* corebird_snippet_manager;
SnippetManager* corebird_snippet_manager = NULL;

GType corebird_get_type (void) G_GNUC_CONST;
GType settings_dialog_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define COREBIRD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COREBIRD, CorebirdPrivate))
enum  {
	COREBIRD_DUMMY_PROPERTY
};
GType sql_database_get_type (void) G_GNUC_CONST;
GType snippet_manager_get_type (void) G_GNUC_CONST;
static void corebird_show_settings_activated (Corebird* self);
static void _corebird_show_settings_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_shortcuts_activated (Corebird* self);
static void _corebird_show_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_quit_application (Corebird* self);
static void _corebird_quit_application_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_about_activated (Corebird* self);
static void _corebird_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_dm_thread (Corebird* self, GSimpleAction* a, GVariant* value);
static void _corebird_show_dm_thread_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_show_window (Corebird* self, GSimpleAction* a, GVariant* value);
static void _corebird_show_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_mark_read_activated (Corebird* self, GSimpleAction* a, GVariant* v);
static void _corebird_mark_read_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void corebird_reply_to_tweet_activated (Corebird* self, GSimpleAction* a, GVariant* v);
static void _corebird_reply_to_tweet_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Corebird* corebird_new (void);
Corebird* corebird_construct (GType object_type);
SnippetManager* snippet_manager_new (void);
SnippetManager* snippet_manager_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
void dirs_create_dirs (void);
gchar* dirs_config (const gchar* path);
#define SQL_COREBIRD_INIT_FILE "/org/baedert/corebird/sql/init/Create.%d.sql"
#define SQL_COREBIRD_SQL_VERSION 2
SqlDatabase* sql_database_new (const gchar* filename, const gchar* init_file, gint max_version);
SqlDatabase* sql_database_construct (GType object_type, const gchar* filename, const gchar* init_file, gint max_version);
static gint corebird_real_command_line (GApplication* base, GApplicationCommandLine* cmd);
GSettings* settings_get (void);
static void corebird_open_startup_windows (Corebird* self, const gchar* compose_screen_name);
static void corebird_real_activate (GApplication* base);
guint account_get_n (void);
Account* account_query_account (const gchar* screen_name);
void corebird_start_account (Corebird* self, Account* acc);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
SettingsDialog* settings_dialog_new (Corebird* application);
SettingsDialog* settings_dialog_construct (GType object_type, Corebird* application);
static gboolean __lambda205_ (Block1Data* _data1_);
static gboolean ___lambda205__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
GType about_dialog_get_type (void) G_GNUC_CONST;
AboutDialog* about_dialog_new (void);
AboutDialog* about_dialog_construct (GType object_type);
static void corebird_real_startup (GApplication* base);
ComposeImageManager* compose_image_manager_new (void);
ComposeImageManager* compose_image_manager_construct (GType object_type);
GType compose_image_manager_get_type (void) G_GNUC_CONST;
LazyMenuButton* lazy_menu_button_new (void);
LazyMenuButton* lazy_menu_button_construct (GType object_type);
GType lazy_menu_button_get_type (void) G_GNUC_CONST;
void utils_load_custom_css (void);
void utils_load_custom_icons (void);
void utils_init_soup_session (void);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_init (Twitter* self);
gchar* settings_get_accel (const gchar* accel_name);
gboolean settings_use_dark_theme (void);
static void corebird_real_shutdown (GApplication* base);
void account_init_proxy (Account* self, gboolean load_secrets, gboolean force);
void account_query_user_info_by_screen_name (Account* self, const gchar* screen_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_query_user_info_by_screen_name_finish (Account* self, GAsyncResult* _res_);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
gboolean corebird_add_window_for_screen_name (Corebird* self, const gchar* screen_name);
Account* account_get_nth (guint index);
const gchar* account_get_screen_name (Account* self);
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
gboolean corebird_is_window_open_for_screen_name (Corebird* self, const gchar* screen_name, MainWindow** window);
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window);
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void corebird_add_window_for_account (Corebird* self, Account* account);
GType main_widget_get_type (void) G_GNUC_CONST;
#define ACCOUNT_DUMMY "screen_name"
void main_window_save_geometry (MainWindow* self);
void user_stream_start (UserStream* self);
void account_init_information (Account* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void account_init_information_finish (Account* self, GAsyncResult* _res_);
void corebird_stop_account (Corebird* self, Account* acc);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
void account_uninit (Account* self);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
Account* account_query_account_by_id (gint64 id);
void main_window_mark_tweet_as_read (MainWindow* self, gint64 tweet_id);
void main_window_reply_to_tweet (MainWindow* self, gint64 tweet_id);
static void g_cclosure_user_marshal_VOID__INT64_INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void corebird_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry COREBIRD_app_entries[8] = {{"show-settings", _corebird_show_settings_activated_gsimple_action_activate_callback}, {"show-shortcuts", _corebird_show_shortcuts_activated_gsimple_action_activate_callback}, {"quit", _corebird_quit_application_gsimple_action_activate_callback}, {"show-about-dialog", _corebird_about_activated_gsimple_action_activate_callback}, {"show-dm-thread", _corebird_show_dm_thread_gsimple_action_activate_callback, "(xx)"}, {"show-window", _corebird_show_window_gsimple_action_activate_callback, "x"}, {"mark-read", _corebird_mark_read_activated_gsimple_action_activate_callback, "(xx)"}, {"reply-to-tweet", _corebird_reply_to_tweet_activated_gsimple_action_activate_callback, "(xx)"}};

static void _corebird_show_settings_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_settings_activated ((Corebird*) self);
}


static void _corebird_show_shortcuts_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_shortcuts_activated ((Corebird*) self);
}


static void _corebird_quit_application_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_quit_application ((Corebird*) self);
}


static void _corebird_about_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_about_activated ((Corebird*) self);
}


static void _corebird_show_dm_thread_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_dm_thread ((Corebird*) self, action, parameter);
}


static void _corebird_show_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_show_window ((Corebird*) self, action, parameter);
}


static void _corebird_mark_read_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_mark_read_activated ((Corebird*) self, action, parameter);
}


static void _corebird_reply_to_tweet_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	corebird_reply_to_tweet_activated ((Corebird*) self, action, parameter);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


Corebird* corebird_construct (GType object_type) {
	Corebird * self = NULL;
	SnippetManager* _tmp0_ = NULL;
	GPtrArray* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	SqlDatabase* _tmp4_ = NULL;
	self = (Corebird*) g_object_new (object_type, "application-id", "org.baedert.corebird", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	_tmp0_ = snippet_manager_new ();
	_g_object_unref0 (corebird_snippet_manager);
	corebird_snippet_manager = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_g_ptr_array_unref0 (self->priv->active_accounts);
	self->priv->active_accounts = _tmp1_;
	dirs_create_dirs ();
	_tmp2_ = dirs_config ("Corebird.db");
	_tmp3_ = _tmp2_;
	_tmp4_ = sql_database_new (_tmp3_, SQL_COREBIRD_INIT_FILE, SQL_COREBIRD_SQL_VERSION);
	_g_object_unref0 (corebird_db);
	corebird_db = _tmp4_;
	_g_free0 (_tmp3_);
	return self;
}


Corebird* corebird_new (void) {
	return corebird_construct (TYPE_COREBIRD);
}


static gint corebird_real_command_line (GApplication* base, GApplicationCommandLine* cmd) {
	Corebird * self;
	gint result = 0;
	gchar* compose_screen_name = NULL;
	gboolean start_service = FALSE;
	gboolean stop_service = FALSE;
	gboolean print_startup_accounts = FALSE;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp0_ = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	GOptionEntry* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GOptionEntry _tmp2_ = {0};
	GOptionEntry _tmp3_ = {0};
	GOptionEntry* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_ = {0};
	GOptionEntry* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	GOptionEntry _tmp8_ = {0};
	GOptionEntry _tmp9_ = {0};
	GOptionEntry* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GOptionEntry _tmp11_ = {0};
	GOptionEntry _tmp12_ = {0};
	GOptionEntry* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	GOptionEntry _tmp14_ = {0};
	GOptionEntry _tmp15_ = {0};
	gchar** args = NULL;
	GApplicationCommandLine* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gchar** _tmp18_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar** _args = NULL;
	gchar** _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gchar** _tmp20_ = NULL;
	gint _args_length1 = 0;
	gint __args_size_ = 0;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp47_ = FALSE;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	g_return_val_if_fail (G_IS_APPLICATION_COMMAND_LINE (cmd), 0);
	compose_screen_name = NULL;
	start_service = FALSE;
	stop_service = FALSE;
	print_startup_accounts = FALSE;
	_tmp0_ = g_new0 (GOptionEntry, 5);
	options = _tmp0_;
	options_length1 = 5;
	_options_size_ = options_length1;
	_tmp1_ = options;
	_tmp1__length1 = options_length1;
	_tmp2_.long_name = "tweet";
	_tmp2_.short_name = 't';
	_tmp2_.flags = 0;
	_tmp2_.arg = G_OPTION_ARG_STRING;
	_tmp2_.arg_data = &compose_screen_name;
	_tmp2_.description = "Shows only the 'compose tweet' window for the given account, nothing e" \
"lse.";
	_tmp2_.arg_description = "SCREEN_NAME";
	_tmp1_[0] = _tmp2_;
	_tmp3_ = _tmp1_[0];
	_tmp4_ = options;
	_tmp4__length1 = options_length1;
	_tmp5_.long_name = "start-service";
	_tmp5_.short_name = 's';
	_tmp5_.flags = 0;
	_tmp5_.arg = G_OPTION_ARG_NONE;
	_tmp5_.arg_data = &start_service;
	_tmp5_.description = "Start service";
	_tmp5_.arg_description = NULL;
	_tmp4_[1] = _tmp5_;
	_tmp6_ = _tmp4_[1];
	_tmp7_ = options;
	_tmp7__length1 = options_length1;
	_tmp8_.long_name = "stop-service";
	_tmp8_.short_name = 'p';
	_tmp8_.flags = 0;
	_tmp8_.arg = G_OPTION_ARG_NONE;
	_tmp8_.arg_data = &stop_service;
	_tmp8_.description = "Stop service, if it has been started as a service";
	_tmp8_.arg_description = NULL;
	_tmp7_[2] = _tmp8_;
	_tmp9_ = _tmp7_[2];
	_tmp10_ = options;
	_tmp10__length1 = options_length1;
	_tmp11_.long_name = "print-startup-accounts";
	_tmp11_.short_name = 'a';
	_tmp11_.flags = 0;
	_tmp11_.arg = G_OPTION_ARG_NONE;
	_tmp11_.arg_data = &print_startup_accounts;
	_tmp11_.description = "Print configured startup accounts";
	_tmp11_.arg_description = NULL;
	_tmp10_[3] = _tmp11_;
	_tmp12_ = _tmp10_[3];
	_tmp13_ = options;
	_tmp13__length1 = options_length1;
	_tmp14_.long_name = NULL;
	_tmp13_[4] = _tmp14_;
	_tmp15_ = _tmp13_[4];
	_tmp16_ = cmd;
	_tmp18_ = g_application_command_line_get_arguments (_tmp16_, &_tmp17_);
	args = _tmp18_;
	args_length1 = _tmp17_;
	_args_size_ = args_length1;
	_tmp19_ = args;
	_tmp19__length1 = args_length1;
	_tmp20_ = g_new0 (gchar*, _tmp19__length1 + 1);
	_args = _tmp20_;
	_args_length1 = _tmp19__length1;
	__args_size_ = _args_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gint _tmp23_ = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				const gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				const gchar* _tmp29_ = NULL;
				const gchar* _tmp30_ = NULL;
				if (!_tmp21_) {
					gint _tmp22_ = 0;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				_tmp23_ = i;
				_tmp24_ = args;
				_tmp24__length1 = args_length1;
				if (!(_tmp23_ < _tmp24__length1)) {
					break;
				}
				_tmp25_ = _args;
				_tmp25__length1 = _args_length1;
				_tmp26_ = i;
				_tmp27_ = args;
				_tmp27__length1 = args_length1;
				_tmp28_ = i;
				_tmp29_ = _tmp27_[_tmp28_];
				_tmp25_[_tmp26_] = _tmp29_;
				_tmp30_ = _tmp25_[_tmp26_];
			}
		}
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp31_ = NULL;
		GOptionContext* _tmp32_ = NULL;
		GOptionContext* _tmp33_ = NULL;
		GOptionEntry* _tmp34_ = NULL;
		gint _tmp34__length1 = 0;
		GOptionContext* _tmp35_ = NULL;
		GOptionGroup* _tmp36_ = NULL;
		GOptionContext* _tmp37_ = NULL;
		GOptionGroup* _tmp38_ = NULL;
		gchar** tmp = NULL;
		const gchar** _tmp39_ = NULL;
		gint _tmp39__length1 = 0;
		gint tmp_length1 = 0;
		gint _tmp_size_ = 0;
		GOptionContext* _tmp40_ = NULL;
		_tmp31_ = g_option_context_new ("");
		opt_context = _tmp31_;
		_tmp32_ = opt_context;
		g_option_context_set_help_enabled (_tmp32_, TRUE);
		_tmp33_ = opt_context;
		_tmp34_ = options;
		_tmp34__length1 = options_length1;
		g_option_context_add_main_entries (_tmp33_, _tmp34_, GETTEXT_PACKAGE);
		_tmp35_ = opt_context;
		_tmp36_ = gtk_get_option_group (FALSE);
		g_option_context_add_group (_tmp35_, _tmp36_);
		_tmp37_ = opt_context;
		_tmp38_ = gst_init_get_option_group ();
		g_option_context_add_group (_tmp37_, _tmp38_);
		_tmp39_ = _args;
		_tmp39__length1 = _args_length1;
		tmp = _tmp39_;
		tmp_length1 = _tmp39__length1;
		_tmp_size_ = tmp_length1;
		_tmp40_ = opt_context;
		g_option_context_parse (_tmp40_, &tmp_length1, &tmp, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp41_ = 0;
			_g_option_context_free0 (opt_context);
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (opt_context);
			_args = (g_free (_args), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			options = (g_free (options), NULL);
			_g_free0 (compose_screen_name);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp41_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GApplicationCommandLine* _tmp42_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = cmd;
		g_application_command_line_print (_tmp42_, "Use --help to see available options\n");
		g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
		result = -1;
		_g_error_free0 (e);
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		options = (g_free (options), NULL);
		_g_free0 (compose_screen_name);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp43_ = 0;
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		options = (g_free (options), NULL);
		_g_free0 (compose_screen_name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp43_;
	}
	_tmp45_ = stop_service;
	if (_tmp45_) {
		gboolean _tmp46_ = FALSE;
		_tmp46_ = start_service;
		_tmp44_ = _tmp46_;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		g_error ("Corebird.vala:101: Can't stop and start service at the same time.");
	}
	_tmp47_ = stop_service;
	if (_tmp47_) {
		gboolean _tmp48_ = FALSE;
		_tmp48_ = self->priv->started_as_service;
		if (_tmp48_) {
			g_debug ("Corebird.vala:107: Stopping service");
			g_application_release (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
		} else {
			g_warning ("Corebird.vala:111: --stop-service passed, but corebird has not been st" \
"arted as a service");
		}
	} else {
		gboolean _tmp49_ = FALSE;
		_tmp49_ = print_startup_accounts;
		if (_tmp49_) {
			gchar** startup_accounts = NULL;
			GSettings* _tmp50_ = NULL;
			GSettings* _tmp51_ = NULL;
			gchar** _tmp52_ = NULL;
			gchar** _tmp53_ = NULL;
			gchar** _tmp54_ = NULL;
			gint _tmp54__length1 = 0;
			gint startup_accounts_length1 = 0;
			gint _startup_accounts_size_ = 0;
			gchar** _tmp55_ = NULL;
			gint _tmp55__length1 = 0;
			_tmp50_ = settings_get ();
			_tmp51_ = _tmp50_;
			_tmp53_ = _tmp52_ = g_settings_get_strv (_tmp51_, "startup-accounts");
			_tmp54_ = _tmp53_;
			_tmp54__length1 = _vala_array_length (_tmp52_);
			_g_object_unref0 (_tmp51_);
			startup_accounts = _tmp54_;
			startup_accounts_length1 = _tmp54__length1;
			_startup_accounts_size_ = startup_accounts_length1;
			_tmp55_ = startup_accounts;
			_tmp55__length1 = startup_accounts_length1;
			{
				gchar** acc_collection = NULL;
				gint acc_collection_length1 = 0;
				gint _acc_collection_size_ = 0;
				gint acc_it = 0;
				acc_collection = _tmp55_;
				acc_collection_length1 = _tmp55__length1;
				for (acc_it = 0; acc_it < _tmp55__length1; acc_it = acc_it + 1) {
					const gchar* acc = NULL;
					acc = acc_collection[acc_it];
					{
						FILE* _tmp56_ = NULL;
						const gchar* _tmp57_ = NULL;
						_tmp56_ = stdout;
						_tmp57_ = acc;
						fprintf (_tmp56_, "%s\n", _tmp57_);
					}
				}
			}
			startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		} else {
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			_tmp59_ = start_service;
			if (_tmp59_) {
				gboolean _tmp60_ = FALSE;
				_tmp60_ = self->priv->started_as_service;
				_tmp58_ = !_tmp60_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				self->priv->started_as_service = TRUE;
				g_application_activate (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
			} else {
				const gchar* _tmp61_ = NULL;
				_tmp61_ = compose_screen_name;
				corebird_open_startup_windows (self, _tmp61_);
			}
		}
	}
	result = 0;
	_args = (g_free (_args), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	options = (g_free (options), NULL);
	_g_free0 (compose_screen_name);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void corebird_real_activate (GApplication* base) {
	Corebird * self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	_tmp0_ = self->priv->started_as_service;
	if (_tmp0_) {
		gchar** startup_accounts = NULL;
		GSettings* _tmp1_ = NULL;
		GSettings* _tmp2_ = NULL;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_ = NULL;
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint startup_accounts_length1 = 0;
		gint _startup_accounts_size_ = 0;
		gboolean _tmp6_ = FALSE;
		gchar** _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		guint n_accounts = 0U;
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		g_application_hold (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication));
		_tmp1_ = settings_get ();
		_tmp2_ = _tmp1_;
		_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "startup-accounts");
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _vala_array_length (_tmp3_);
		_g_object_unref0 (_tmp2_);
		startup_accounts = _tmp5_;
		startup_accounts_length1 = _tmp5__length1;
		_startup_accounts_size_ = startup_accounts_length1;
		_tmp7_ = startup_accounts;
		_tmp7__length1 = startup_accounts_length1;
		if (_tmp7__length1 == 1) {
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			const gchar* _tmp9_ = NULL;
			_tmp8_ = startup_accounts;
			_tmp8__length1 = startup_accounts_length1;
			_tmp9_ = _tmp8_[0];
			_tmp6_ = g_strcmp0 (_tmp9_, "") == 0;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			gint _tmp10_ = 0;
			_tmp10_ = 0;
			startup_accounts = g_renew (gchar*, startup_accounts, 0);
			(_tmp10_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp10_ - startup_accounts_length1)) : NULL;
			startup_accounts_length1 = _tmp10_;
			_startup_accounts_size_ = _tmp10_;
		}
		_tmp11_ = startup_accounts;
		_tmp11__length1 = startup_accounts_length1;
		g_debug ("Corebird.vala:136: Configured startup accounts: %d", _tmp11__length1);
		_tmp12_ = account_get_n ();
		n_accounts = _tmp12_;
		_tmp13_ = n_accounts;
		g_debug ("Corebird.vala:138: Configured accounts: %u", _tmp13_);
		_tmp14_ = startup_accounts;
		_tmp14__length1 = startup_accounts_length1;
		{
			gchar** screen_name_collection = NULL;
			gint screen_name_collection_length1 = 0;
			gint _screen_name_collection_size_ = 0;
			gint screen_name_it = 0;
			screen_name_collection = _tmp14_;
			screen_name_collection_length1 = _tmp14__length1;
			for (screen_name_it = 0; screen_name_it < _tmp14__length1; screen_name_it = screen_name_it + 1) {
				const gchar* screen_name = NULL;
				screen_name = screen_name_collection[screen_name_it];
				{
					Account* acc = NULL;
					const gchar* _tmp15_ = NULL;
					Account* _tmp16_ = NULL;
					Account* _tmp17_ = NULL;
					Account* _tmp18_ = NULL;
					_tmp15_ = screen_name;
					_tmp16_ = account_query_account (_tmp15_);
					_tmp17_ = _g_object_ref0 (_tmp16_);
					acc = _tmp17_;
					_tmp18_ = acc;
					if (_tmp18_ != NULL) {
						const gchar* _tmp19_ = NULL;
						Account* _tmp20_ = NULL;
						_tmp19_ = screen_name;
						g_debug ("Corebird.vala:143: Service: Starting account %s...", _tmp19_);
						_tmp20_ = acc;
						corebird_start_account (self, _tmp20_);
					} else {
						const gchar* _tmp21_ = NULL;
						_tmp21_ = screen_name;
						g_warning ("Corebird.vala:146: Invalid startup account: '%s'", _tmp21_);
					}
					_g_object_unref0 (acc);
				}
			}
		}
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		corebird_open_startup_windows (self, NULL);
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Corebird* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->action);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda205_ (Block1Data* _data1_) {
	Corebird* self;
	gboolean result = FALSE;
	GSimpleAction* _tmp0_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->action;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_g_object_unref0 (self->priv->settings_dialog);
	self->priv->settings_dialog = NULL;
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean ___lambda205__gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = __lambda205_ (self);
	return result;
}


static void corebird_show_settings_activated (Corebird* self) {
	Block1Data* _data1_;
	SettingsDialog* _tmp0_ = NULL;
	SettingsDialog* dialog = NULL;
	SettingsDialog* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	SettingsDialog* _tmp5_ = NULL;
	SettingsDialog* _tmp6_ = NULL;
	g_return_if_fail (IS_COREBIRD (self));
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->settings_dialog;
	if (_tmp0_ != NULL) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp1_ = settings_dialog_new (self);
	g_object_ref_sink (_tmp1_);
	dialog = _tmp1_;
	_tmp2_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), "show-settings");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_simple_action_get_type (), GSimpleAction));
	_data1_->action = _tmp3_;
	_tmp4_ = _data1_->action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	_tmp5_ = dialog;
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) ___lambda205__gtk_widget_delete_event, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp6_ = dialog;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void corebird_about_activated (Corebird* self) {
	GtkWindow* active_window = NULL;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	AboutDialog* ad = NULL;
	AboutDialog* _tmp2_ = NULL;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	active_window = _tmp1_;
	_tmp2_ = about_dialog_new ();
	g_object_ref_sink (_tmp2_);
	ad = _tmp2_;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_window_get_type (), GtkWindow), active_window);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (ad, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ad);
	_g_object_unref0 (active_window);
}


static void corebird_show_shortcuts_activated (Corebird* self) {
	gboolean _tmp0_ = FALSE;
	guint _tmp1_ = 0U;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp1_ = gtk_get_major_version ();
	if (_tmp1_ == ((guint) 3)) {
		guint _tmp2_ = 0U;
		_tmp2_ = gtk_get_minor_version ();
		_tmp0_ = _tmp2_ >= ((guint) 19);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkBuilder* builder = NULL;
		GtkBuilder* _tmp3_ = NULL;
		GtkWindow* shortcuts_window = NULL;
		GtkBuilder* _tmp4_ = NULL;
		GObject* _tmp5_ = NULL;
		GtkWindow* _tmp6_ = NULL;
		GtkWindow* _tmp7_ = NULL;
		_tmp3_ = gtk_builder_new_from_resource ("/org/baedert/corebird/ui/shortcuts-window.ui");
		builder = _tmp3_;
		_tmp4_ = builder;
		_tmp5_ = gtk_builder_get_object (_tmp4_, "shortcuts_window");
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow));
		shortcuts_window = _tmp6_;
		_tmp7_ = shortcuts_window;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (shortcuts_window);
		_g_object_unref0 (builder);
	} else {
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		_tmp8_ = gtk_get_major_version ();
		_tmp9_ = gtk_get_minor_version ();
		g_warning ("Corebird.vala:186: The shortcuts window is only available in gtk+ >= 3" \
".20, version is %u.%u", _tmp8_, _tmp9_);
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void corebird_real_startup (GApplication* base) {
	Corebird * self;
	ComposeImageManager* _tmp0_ = NULL;
	ComposeImageManager* _tmp1_ = NULL;
	LazyMenuButton* _tmp2_ = NULL;
	LazyMenuButton* _tmp3_ = NULL;
	Twitter* _tmp4_ = NULL;
	Twitter* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gchar* _tmp30_ = NULL;
	gchar** _tmp31_ = NULL;
	gchar** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	gchar* _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	gchar* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar** _tmp41_ = NULL;
	gchar** _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	gchar* _tmp43_ = NULL;
	gchar** _tmp44_ = NULL;
	gchar** _tmp45_ = NULL;
	gint _tmp45__length1 = 0;
	gchar* _tmp46_ = NULL;
	gchar** _tmp47_ = NULL;
	gchar** _tmp48_ = NULL;
	gint _tmp48__length1 = 0;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar** _tmp51_ = NULL;
	gchar** _tmp52_ = NULL;
	gint _tmp52__length1 = 0;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_ = NULL;
	gchar** _tmp55_ = NULL;
	gchar** _tmp56_ = NULL;
	gint _tmp56__length1 = 0;
	gchar* _tmp57_ = NULL;
	gchar** _tmp58_ = NULL;
	gchar** _tmp59_ = NULL;
	gint _tmp59__length1 = 0;
	gchar* _tmp60_ = NULL;
	gchar** _tmp61_ = NULL;
	gchar** _tmp62_ = NULL;
	gint _tmp62__length1 = 0;
	gboolean _tmp63_ = FALSE;
	guint _tmp64_ = 0U;
	GtkSettings* gtk_s = NULL;
	GtkSettings* _tmp67_ = NULL;
	GtkSettings* _tmp68_ = NULL;
	gboolean _tmp69_ = FALSE;
	GtkSettings* _tmp71_ = NULL;
	gchar* _tmp72_ = NULL;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_ = NULL;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	G_APPLICATION_CLASS (corebird_parent_class)->startup (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	g_application_set_resource_base_path (G_TYPE_CHECK_INSTANCE_CAST (self, g_application_get_type (), GApplication), "/org/baedert/corebird");
	_tmp0_ = compose_image_manager_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = lazy_menu_button_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	g_debug ("Corebird.vala:202: startup");
	setlocale (LC_ALL, DATADIR "/locale");
	bindtextdomain (GETTEXT_PACKAGE, NULL);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	utils_load_custom_css ();
	utils_load_custom_icons ();
	utils_init_soup_session ();
	_tmp4_ = twitter_get ();
	_tmp5_ = _tmp4_;
	twitter_init (_tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = settings_get_accel ("compose-tweet");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.compose-tweet", _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = settings_get_accel ("toggle-sidebar");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.toggle-sidebar", _tmp11_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp12_ = g_strdup ("<Alt>1");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(0)", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = g_strdup ("<Alt>2");
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp17__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(1)", _tmp17_);
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = g_strdup ("<Alt>3");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(2)", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp21_ = g_strdup ("<Alt>4");
	_tmp22_ = g_new0 (gchar*, 1 + 1);
	_tmp22_[0] = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp23__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(3)", _tmp23_);
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = g_strdup ("<Alt>5");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(4)", _tmp26_);
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = g_strdup ("<Alt>6");
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp29__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(5)", _tmp29_);
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = g_strdup ("<Alt>7");
	_tmp31_ = g_new0 (gchar*, 1 + 1);
	_tmp31_[0] = _tmp30_;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.switch-page(6)", _tmp32_);
	_tmp32_ = (_vala_array_free (_tmp32_, _tmp32__length1, (GDestroyNotify) g_free), NULL);
	_tmp33_ = settings_get_accel ("show-settings");
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.show-settings", _tmp35_);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	_tmp36_ = g_strdup ("<Primary>Q");
	_tmp37_ = g_new0 (gchar*, 1 + 1);
	_tmp37_[0] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.quit", _tmp38_);
	_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
	_tmp39_ = g_strdup ("<Primary>question");
	_tmp40_ = g_strdup ("<Primary>F1");
	_tmp41_ = g_new0 (gchar*, 2 + 1);
	_tmp41_[0] = _tmp39_;
	_tmp41_[1] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 2;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "app.show-shortcuts", _tmp42_);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = settings_get_accel ("show-account-dialog");
	_tmp44_ = g_new0 (gchar*, 1 + 1);
	_tmp44_[0] = _tmp43_;
	_tmp45_ = _tmp44_;
	_tmp45__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.show-account-dialog", _tmp45_);
	_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
	_tmp46_ = settings_get_accel ("show-account-list");
	_tmp47_ = g_new0 (gchar*, 1 + 1);
	_tmp47_[0] = _tmp46_;
	_tmp48_ = _tmp47_;
	_tmp48__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.show-account-list", _tmp48_);
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	_tmp49_ = g_strdup ("<Alt>Left");
	_tmp50_ = g_strdup ("Back");
	_tmp51_ = g_new0 (gchar*, 2 + 1);
	_tmp51_[0] = _tmp49_;
	_tmp51_[1] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 2;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.previous", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_strdup ("<Alt>Right");
	_tmp54_ = g_strdup ("Forward");
	_tmp55_ = g_new0 (gchar*, 2 + 1);
	_tmp55_[0] = _tmp53_;
	_tmp55_[1] = _tmp54_;
	_tmp56_ = _tmp55_;
	_tmp56__length1 = 2;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "win.next", _tmp56_);
	_tmp56_ = (_vala_array_free (_tmp56_, _tmp56__length1, (GDestroyNotify) g_free), NULL);
	_tmp57_ = g_strdup ("r");
	_tmp58_ = g_new0 (gchar*, 1 + 1);
	_tmp58_[0] = _tmp57_;
	_tmp59_ = _tmp58_;
	_tmp59__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "tweet.reply", _tmp59_);
	_tmp59_ = (_vala_array_free (_tmp59_, _tmp59__length1, (GDestroyNotify) g_free), NULL);
	_tmp60_ = g_strdup ("f");
	_tmp61_ = g_new0 (gchar*, 1 + 1);
	_tmp61_[0] = _tmp60_;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), "tweet.favorite", _tmp62_);
	_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), COREBIRD_app_entries, G_N_ELEMENTS (COREBIRD_app_entries), self);
	_tmp64_ = gtk_get_major_version ();
	if (_tmp64_ == ((guint) 3)) {
		guint _tmp65_ = 0U;
		_tmp65_ = gtk_get_minor_version ();
		_tmp63_ = _tmp65_ < ((guint) 19);
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		GAction* _tmp66_ = NULL;
		_tmp66_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), "show-shortcuts");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_tmp67_ = gtk_settings_get_default ();
	_tmp68_ = _g_object_ref0 (_tmp67_);
	gtk_s = _tmp68_;
	_tmp69_ = settings_use_dark_theme ();
	if (_tmp69_) {
		GtkSettings* _tmp70_ = NULL;
		_tmp70_ = gtk_s;
		g_object_set (_tmp70_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	}
	_tmp71_ = gtk_s;
	g_object_get (_tmp71_, "gtk-decoration-layout", &_tmp72_, NULL);
	_tmp73_ = _tmp72_;
	_tmp74_ = _tmp73_;
	_tmp75_ = string_contains (_tmp74_, "menu");
	_tmp76_ = _tmp75_;
	_g_free0 (_tmp74_);
	if (_tmp76_) {
		GtkSettings* _tmp77_ = NULL;
		GtkSettings* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		gchar* _tmp82_ = NULL;
		gchar* _tmp83_ = NULL;
		_tmp77_ = gtk_s;
		_tmp78_ = gtk_s;
		g_object_get (_tmp78_, "gtk-decoration-layout", &_tmp79_, NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = _tmp80_;
		_tmp82_ = string_replace (_tmp81_, "menu", "");
		_tmp83_ = _tmp82_;
		g_object_set (_tmp77_, "gtk-decoration-layout", _tmp83_, NULL);
		_g_free0 (_tmp83_);
		_g_free0 (_tmp81_);
	}
	_g_object_unref0 (gtk_s);
}


static void corebird_real_shutdown (GApplication* base) {
	Corebird * self;
	CbMediaDownloader* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_COREBIRD, Corebird);
	_tmp0_ = cb_media_downloader_get_default ();
	cb_media_downloader_shutdown (_tmp0_);
	G_APPLICATION_CLASS (corebird_parent_class)->shutdown (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
}


/**
   * Open startup windows.
   * Semantics: Open a window for every account in the startup-accounts array.
   * If that array is empty, look at all the account and if there is one, open that one.
   * If there is none, open a MainWindow with a null account.
   */
static void corebird_open_startup_windows (Corebird* self, const gchar* compose_screen_name) {
	const gchar* _tmp0_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp17_ = FALSE;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	guint n_accounts = 0U;
	guint _tmp22_ = 0U;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = compose_screen_name;
	if (_tmp0_ != NULL) {
		Account* acc = NULL;
		const gchar* _tmp1_ = NULL;
		Account* _tmp2_ = NULL;
		Account* _tmp3_ = NULL;
		Account* _tmp4_ = NULL;
		Account* _tmp6_ = NULL;
		Account* _tmp7_ = NULL;
		ComposeTweetWindow* cw = NULL;
		Account* _tmp8_ = NULL;
		ComposeTweetWindow* _tmp9_ = NULL;
		ComposeTweetWindow* _tmp10_ = NULL;
		ComposeTweetWindow* _tmp11_ = NULL;
		_tmp1_ = compose_screen_name;
		_tmp2_ = account_query_account (_tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		acc = _tmp3_;
		_tmp4_ = acc;
		if (_tmp4_ == NULL) {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = compose_screen_name;
			g_critical ("Corebird.vala:274: No account named `%s` is configured. Exiting.", _tmp5_);
			_g_object_unref0 (acc);
			return;
		}
		_tmp6_ = acc;
		account_init_proxy (_tmp6_, TRUE, FALSE);
		_tmp7_ = acc;
		account_query_user_info_by_screen_name (_tmp7_, NULL, NULL, NULL);
		_tmp8_ = acc;
		_tmp9_ = compose_tweet_window_new (NULL, _tmp8_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL);
		g_object_ref_sink (_tmp9_);
		cw = _tmp9_;
		_tmp10_ = cw;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = cw;
		gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (cw);
		_g_object_unref0 (acc);
		return;
	}
	_tmp12_ = settings_get ();
	_tmp13_ = _tmp12_;
	_tmp15_ = _tmp14_ = g_settings_get_strv (_tmp13_, "startup-accounts");
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _vala_array_length (_tmp14_);
	_g_object_unref0 (_tmp13_);
	startup_accounts = _tmp16_;
	startup_accounts_length1 = _tmp16__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp18_ = startup_accounts;
	_tmp18__length1 = startup_accounts_length1;
	if (_tmp18__length1 == 1) {
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		const gchar* _tmp20_ = NULL;
		_tmp19_ = startup_accounts;
		_tmp19__length1 = startup_accounts_length1;
		_tmp20_ = _tmp19_[0];
		_tmp17_ = g_strcmp0 (_tmp20_, "") == 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gint _tmp21_ = 0;
		_tmp21_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp21_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp21_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp21_;
		_startup_accounts_size_ = _tmp21_;
	}
	_tmp22_ = account_get_n ();
	n_accounts = _tmp22_;
	_tmp23_ = startup_accounts;
	_tmp23__length1 = startup_accounts_length1;
	if (_tmp23__length1 == 0) {
		guint _tmp24_ = 0U;
		_tmp24_ = n_accounts;
		if (_tmp24_ == ((guint) 1)) {
			Account* _tmp25_ = NULL;
			Account* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			_tmp25_ = account_get_nth ((guint) 0);
			_tmp26_ = _tmp25_;
			_tmp27_ = account_get_screen_name (_tmp26_);
			_tmp28_ = _tmp27_;
			corebird_add_window_for_screen_name (self, _tmp28_);
			_g_object_unref0 (_tmp26_);
		} else {
			guint _tmp29_ = 0U;
			_tmp29_ = n_accounts;
			if (_tmp29_ == ((guint) 0)) {
				MainWindow* window = NULL;
				MainWindow* _tmp30_ = NULL;
				MainWindow* _tmp31_ = NULL;
				MainWindow* _tmp32_ = NULL;
				_tmp30_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), NULL);
				g_object_ref_sink (_tmp30_);
				window = _tmp30_;
				_tmp31_ = window;
				gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_window_get_type (), GtkWindow));
				_tmp32_ = window;
				gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (window);
			} else {
				Account* _tmp33_ = NULL;
				Account* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				_tmp33_ = account_get_nth ((guint) 0);
				_tmp34_ = _tmp33_;
				_tmp35_ = account_get_screen_name (_tmp34_);
				_tmp36_ = _tmp35_;
				corebird_add_window_for_screen_name (self, _tmp36_);
				_g_object_unref0 (_tmp34_);
			}
		}
	} else {
		gboolean opened_window = FALSE;
		gchar** _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
		gboolean _tmp42_ = FALSE;
		opened_window = FALSE;
		_tmp37_ = startup_accounts;
		_tmp37__length1 = startup_accounts_length1;
		{
			gchar** account_collection = NULL;
			gint account_collection_length1 = 0;
			gint _account_collection_size_ = 0;
			gint account_it = 0;
			account_collection = _tmp37_;
			account_collection_length1 = _tmp37__length1;
			for (account_it = 0; account_it < _tmp37__length1; account_it = account_it + 1) {
				const gchar* account = NULL;
				account = account_collection[account_it];
				{
					const gchar* _tmp38_ = NULL;
					gboolean _tmp39_ = FALSE;
					_tmp38_ = account;
					_tmp39_ = corebird_is_window_open_for_screen_name (self, _tmp38_, NULL);
					if (!_tmp39_) {
						const gchar* _tmp40_ = NULL;
						gboolean _tmp41_ = FALSE;
						_tmp40_ = account;
						_tmp41_ = corebird_add_window_for_screen_name (self, _tmp40_);
						if (_tmp41_) {
							opened_window = TRUE;
						}
					}
				}
			}
		}
		_tmp42_ = opened_window;
		if (!_tmp42_) {
			guint _tmp43_ = 0U;
			GList* _tmp54_ = NULL;
			MainWindow* m = NULL;
			MainWindow* _tmp60_ = NULL;
			MainWindow* _tmp61_ = NULL;
			MainWindow* _tmp62_ = NULL;
			_tmp43_ = n_accounts;
			if (_tmp43_ > ((guint) 0)) {
				{
					guint i = 0U;
					i = (guint) 0;
					{
						gboolean _tmp44_ = FALSE;
						_tmp44_ = TRUE;
						while (TRUE) {
							guint _tmp46_ = 0U;
							guint _tmp47_ = 0U;
							Account* account = NULL;
							guint _tmp48_ = 0U;
							Account* _tmp49_ = NULL;
							Account* _tmp50_ = NULL;
							gint64 _tmp51_ = 0LL;
							gboolean _tmp52_ = FALSE;
							if (!_tmp44_) {
								guint _tmp45_ = 0U;
								_tmp45_ = i;
								i = _tmp45_ + 1;
							}
							_tmp44_ = FALSE;
							_tmp46_ = i;
							_tmp47_ = account_get_n ();
							if (!(_tmp46_ < _tmp47_)) {
								break;
							}
							_tmp48_ = i;
							_tmp49_ = account_get_nth (_tmp48_);
							account = _tmp49_;
							_tmp50_ = account;
							_tmp51_ = _tmp50_->id;
							_tmp52_ = corebird_is_window_open_for_user_id (self, _tmp51_, NULL);
							if (!_tmp52_) {
								Account* _tmp53_ = NULL;
								_tmp53_ = account;
								corebird_add_window_for_account (self, _tmp53_);
								_g_object_unref0 (account);
								startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
								return;
							}
							_g_object_unref0 (account);
						}
					}
				}
			}
			_tmp54_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
			{
				GList* w_collection = NULL;
				GList* w_it = NULL;
				w_collection = _tmp54_;
				for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
					GtkWindow* _tmp55_ = NULL;
					GtkWindow* w = NULL;
					_tmp55_ = _g_object_ref0 ((GtkWindow*) w_it->data);
					w = _tmp55_;
					{
						GtkWindow* _tmp56_ = NULL;
						Account* _tmp57_ = NULL;
						const gchar* _tmp58_ = NULL;
						const gchar* _tmp59_ = NULL;
						_tmp56_ = w;
						_tmp57_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, TYPE_MAIN_WINDOW, MainWindow)->account;
						_tmp58_ = account_get_screen_name (_tmp57_);
						_tmp59_ = _tmp58_;
						if (g_strcmp0 (_tmp59_, ACCOUNT_DUMMY) == 0) {
							_g_object_unref0 (w);
							startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
							return;
						}
						_g_object_unref0 (w);
					}
				}
			}
			_tmp60_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), NULL);
			g_object_ref_sink (_tmp60_);
			m = _tmp60_;
			_tmp61_ = m;
			gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_window_get_type (), GtkWindow));
			_tmp62_ = m;
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (m);
		}
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


/**
   * Adds a new MainWindow instance with the account that
   * has the given screen name.
   * Note that this only works if the account is already properly
   * set up and won't warn or fail if if isn't.
   *
   * @param screen_name The screen name of the account to add a
   *                    MainWindow for.
   *
   * @return true if a window has been opened, false otherwise
   */
gboolean corebird_add_window_for_screen_name (Corebird* self, const gchar* screen_name) {
	gboolean result = FALSE;
	Account* acc = NULL;
	const gchar* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	const gchar* _tmp5_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	g_return_val_if_fail (screen_name != NULL, FALSE);
	_tmp0_ = screen_name;
	_tmp1_ = account_query_account (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	acc = _tmp2_;
	_tmp3_ = acc;
	if (_tmp3_ != NULL) {
		Account* _tmp4_ = NULL;
		_tmp4_ = acc;
		corebird_add_window_for_account (self, _tmp4_);
		result = TRUE;
		_g_object_unref0 (acc);
		return result;
	}
	_tmp5_ = screen_name;
	g_warning ("Corebird.vala:360: Could not add window for account '%s'", _tmp5_);
	result = FALSE;
	_g_object_unref0 (acc);
	return result;
}


void corebird_add_window_for_account (Corebird* self, Account* account) {
	MainWindow* window = NULL;
	Account* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	_tmp1_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp0_);
	g_object_ref_sink (_tmp1_);
	window = _tmp1_;
	gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (window, gtk_window_get_type (), GtkWindow));
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (window, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (window);
}


/**
   * Checks if there's currently a MainWindow instance open that has a
   * reference to the account with the given screen name.
   * (This makes a linear search over all open windows, with a text comparison
   * in each iteration)
   *
   * @param screen_name The screen name to search for
   * @return TRUE if a window with the account associated to the given
   *         screen name is open, FALSE otherwise.
   */
gboolean corebird_is_window_open_for_screen_name (Corebird* self, const gchar* screen_name, MainWindow** window) {
	MainWindow* _vala_window = NULL;
	gboolean result = FALSE;
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	g_return_val_if_fail (screen_name != NULL, FALSE);
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp1_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp2_ = NULL;
			GtkWindow* win = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp2_;
			{
				GtkWindow* _tmp3_ = NULL;
				_tmp3_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp4_ = NULL;
					Account* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					_tmp4_ = win;
					_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp6_ = account_get_screen_name (_tmp5_);
					_tmp7_ = _tmp6_;
					_tmp8_ = screen_name;
					if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
						GtkWindow* _tmp9_ = NULL;
						MainWindow* _tmp10_ = NULL;
						_tmp9_ = win;
						_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MAIN_WINDOW, MainWindow));
						_g_object_unref0 (_vala_window);
						_vala_window = _tmp10_;
						result = TRUE;
						_g_object_unref0 (win);
						if (window) {
							*window = _vala_window;
						} else {
							_g_object_unref0 (_vala_window);
						}
						return result;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_g_object_unref0 (_vala_window);
	_vala_window = NULL;
	result = FALSE;
	if (window) {
		*window = _vala_window;
	} else {
		_g_object_unref0 (_vala_window);
	}
	return result;
}


gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window) {
	MainWindow* _vala_window = NULL;
	gboolean result = FALSE;
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (IS_COREBIRD (self), FALSE);
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp1_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp2_ = NULL;
			GtkWindow* win = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp2_;
			{
				GtkWindow* _tmp3_ = NULL;
				_tmp3_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp4_ = NULL;
					Account* _tmp5_ = NULL;
					gint64 _tmp6_ = 0LL;
					gint64 _tmp7_ = 0LL;
					_tmp4_ = win;
					_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp6_ = _tmp5_->id;
					_tmp7_ = user_id;
					if (_tmp6_ == _tmp7_) {
						GtkWindow* _tmp8_ = NULL;
						MainWindow* _tmp9_ = NULL;
						_tmp8_ = win;
						_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MAIN_WINDOW, MainWindow));
						_g_object_unref0 (_vala_window);
						_vala_window = _tmp9_;
						result = TRUE;
						_g_object_unref0 (win);
						if (window) {
							*window = _vala_window;
						} else {
							_g_object_unref0 (_vala_window);
						}
						return result;
					}
				}
				_g_object_unref0 (win);
			}
		}
	}
	_g_object_unref0 (_vala_window);
	_vala_window = NULL;
	result = FALSE;
	if (window) {
		*window = _vala_window;
	} else {
		_g_object_unref0 (_vala_window);
	}
	return result;
}


/**
   * Quits the application, saving all open windows and their geometries.
   */
static void corebird_quit_application (Corebird* self) {
	GList* windows = NULL;
	GList* _tmp0_ = NULL;
	gchar** startup_accounts = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar** account_names = NULL;
	GList* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	gchar** _tmp14_ = NULL;
	gint account_names_length1 = 0;
	gint _account_names_size_ = 0;
	gint index = 0;
	GList* _tmp15_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	GSettings* _tmp33_ = NULL;
	GSettings* _tmp34_ = NULL;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	g_return_if_fail (IS_COREBIRD (self));
	_tmp0_ = gtk_application_get_windows (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	windows = _tmp0_;
	_tmp1_ = settings_get ();
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_settings_get_strv (_tmp2_, "startup-accounts");
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_object_unref0 (_tmp2_);
	startup_accounts = _tmp5_;
	startup_accounts_length1 = _tmp5__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp7_ = startup_accounts;
	_tmp7__length1 = startup_accounts_length1;
	if (_tmp7__length1 == 1) {
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
		_tmp8_ = startup_accounts;
		_tmp8__length1 = startup_accounts_length1;
		_tmp9_ = _tmp8_[0];
		_tmp6_ = g_strcmp0 (_tmp9_, "") == 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gint _tmp10_ = 0;
		_tmp10_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp10_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp10_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp10_;
		_startup_accounts_size_ = _tmp10_;
	}
	_tmp11_ = startup_accounts;
	_tmp11__length1 = startup_accounts_length1;
	if (_tmp11__length1 != 0) {
		g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp12_ = windows;
	_tmp13_ = g_list_length (_tmp12_);
	_tmp14_ = g_new0 (gchar*, _tmp13_ + 1);
	account_names = _tmp14_;
	account_names_length1 = _tmp13_;
	_account_names_size_ = account_names_length1;
	index = 0;
	_tmp15_ = windows;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp15_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* win = NULL;
			win = (GtkWindow*) win_it->data;
			{
				GtkWindow* _tmp16_ = NULL;
				MainWindow* mw = NULL;
				GtkWindow* _tmp17_ = NULL;
				MainWindow* _tmp18_ = NULL;
				gchar* screen_name = NULL;
				MainWindow* _tmp19_ = NULL;
				Account* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				MainWindow* _tmp24_ = NULL;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				_tmp16_ = win;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TYPE_MAIN_WINDOW)) {
					continue;
				}
				_tmp17_ = win;
				_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MAIN_WINDOW, MainWindow));
				mw = _tmp18_;
				_tmp19_ = mw;
				_tmp20_ = _tmp19_->account;
				_tmp21_ = account_get_screen_name (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strdup (_tmp22_);
				screen_name = _tmp23_;
				_tmp24_ = mw;
				main_window_save_geometry (_tmp24_);
				_tmp25_ = account_names;
				_tmp25__length1 = account_names_length1;
				_tmp26_ = index;
				_tmp27_ = screen_name;
				_tmp28_ = g_strdup (_tmp27_);
				_g_free0 (_tmp25_[_tmp26_]);
				_tmp25_[_tmp26_] = _tmp28_;
				_tmp29_ = _tmp25_[_tmp26_];
				_tmp30_ = index;
				index = _tmp30_ + 1;
				_g_free0 (screen_name);
				_g_object_unref0 (mw);
			}
		}
	}
	_tmp31_ = index;
	_tmp32_ = _tmp31_ + 1;
	account_names = g_renew (gchar*, account_names, _tmp31_ + 1);
	(_tmp32_ > account_names_length1) ? memset (account_names + account_names_length1, 0, sizeof (gchar*) * (_tmp32_ - account_names_length1)) : NULL;
	account_names_length1 = _tmp32_;
	_account_names_size_ = _tmp32_;
	_tmp33_ = settings_get ();
	_tmp34_ = _tmp33_;
	_tmp35_ = account_names;
	_tmp35__length1 = account_names_length1;
	g_settings_set_strv (_tmp34_, "startup-accounts", _tmp35_);
	_g_object_unref0 (_tmp34_);
	g_application_quit (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), g_application_get_type (), GApplication));
	account_names = (_vala_array_free (account_names, account_names_length1, (GDestroyNotify) g_free), NULL);
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


void corebird_start_account (Corebird* self, Account* acc) {
	Account* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	UserStream* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	GPtrArray* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	Account* _tmp21_ = NULL;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (acc));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				Account* account = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				Account* _tmp9_ = NULL;
				Account* _tmp10_ = NULL;
				Account* _tmp11_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->active_accounts;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->active_accounts;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((Account*) _tmp8_);
				account = _tmp9_;
				_tmp10_ = acc;
				_tmp11_ = account;
				if (_tmp10_ == _tmp11_) {
					Account* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					_tmp12_ = acc;
					_tmp13_ = account_get_screen_name (_tmp12_);
					_tmp14_ = _tmp13_;
					g_debug ("Corebird.vala:446: Account %s is already active", _tmp14_);
					_g_object_unref0 (account);
					return;
				}
				_g_object_unref0 (account);
			}
		}
	}
	_tmp15_ = acc;
	account_init_proxy (_tmp15_, TRUE, FALSE);
	_tmp16_ = acc;
	_tmp17_ = _tmp16_->user_stream;
	user_stream_start (_tmp17_);
	_tmp18_ = acc;
	account_init_information (_tmp18_, NULL, NULL);
	_tmp19_ = self->priv->active_accounts;
	_tmp20_ = acc;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	g_ptr_array_add (_tmp19_, _tmp21_);
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


void corebird_stop_account (Corebird* self, Account* acc) {
	gboolean found = FALSE;
	gboolean _tmp12_ = FALSE;
	gchar** startup_accounts = NULL;
	GSettings* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (IS_ACCOUNT (acc));
	found = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				GPtrArray* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				Account* account = NULL;
				GPtrArray* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gconstpointer _tmp8_ = NULL;
				Account* _tmp9_ = NULL;
				Account* _tmp10_ = NULL;
				Account* _tmp11_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->active_accounts;
				_tmp4_ = g_ptr_array_get_length (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->active_accounts;
				_tmp7_ = i;
				_tmp8_ = g_ptr_array_index (_tmp6_, (guint) _tmp7_);
				_tmp9_ = _g_object_ref0 ((Account*) _tmp8_);
				account = _tmp9_;
				_tmp10_ = account;
				_tmp11_ = acc;
				if (_tmp10_ == _tmp11_) {
					found = TRUE;
					_g_object_unref0 (account);
					break;
				}
				_g_object_unref0 (account);
			}
		}
	}
	_tmp12_ = found;
	if (!_tmp12_) {
		Account* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp13_ = acc;
		_tmp14_ = account_get_screen_name (_tmp13_);
		_tmp15_ = _tmp14_;
		g_warning ("Corebird.vala:469: Can't stop account %s since it's not in the list of" \
" active accounts", _tmp15_);
		return;
	}
	_tmp16_ = settings_get ();
	_tmp17_ = _tmp16_;
	_tmp19_ = _tmp18_ = g_settings_get_strv (_tmp17_, "startup-accounts");
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _vala_array_length (_tmp18_);
	_g_object_unref0 (_tmp17_);
	startup_accounts = _tmp20_;
	startup_accounts_length1 = _tmp20__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp22_ = self->priv->started_as_service;
	if (_tmp22_) {
		Account* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		_tmp23_ = acc;
		_tmp24_ = account_get_screen_name (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = startup_accounts;
		_tmp26__length1 = startup_accounts_length1;
		_tmp21_ = _vala_string_array_contains (_tmp26_, _tmp26__length1, _tmp25_);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
	} else {
		Account* _tmp27_ = NULL;
		GPtrArray* _tmp28_ = NULL;
		Account* _tmp29_ = NULL;
		_tmp27_ = acc;
		account_uninit (_tmp27_);
		_tmp28_ = self->priv->active_accounts;
		_tmp29_ = acc;
		g_ptr_array_remove (_tmp28_, _tmp29_);
	}
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
}


/********************************************************/
static void corebird_show_dm_thread (Corebird* self, GSimpleAction* a, GVariant* value) {
	gint64 account_id = 0LL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 sender_id = 0LL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	MainWindow* main_window = NULL;
	gint64 _tmp10_ = 0LL;
	MainWindow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = value;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int64 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	account_id = _tmp4_;
	_tmp5_ = value;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_int64 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	sender_id = _tmp9_;
	_tmp10_ = account_id;
	_tmp12_ = corebird_is_window_open_for_user_id (self, _tmp10_, &_tmp11_);
	_g_object_unref0 (main_window);
	main_window = _tmp11_;
	if (_tmp12_) {
		Bundle* bundle = NULL;
		Bundle* _tmp13_ = NULL;
		Bundle* _tmp14_ = NULL;
		gint64 _tmp15_ = 0LL;
		MainWindow* _tmp16_ = NULL;
		MainWidget* _tmp17_ = NULL;
		Bundle* _tmp18_ = NULL;
		MainWindow* _tmp19_ = NULL;
		_tmp13_ = bundle_new ();
		bundle = _tmp13_;
		_tmp14_ = bundle;
		_tmp15_ = sender_id;
		bundle_put_int64 (_tmp14_, "sender_id", _tmp15_);
		_tmp16_ = main_window;
		_tmp17_ = _tmp16_->main_widget;
		_tmp18_ = bundle;
		main_widget_switch_page (_tmp17_, (gint) PAGE_DM, _tmp18_);
		_tmp19_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (bundle);
	} else {
		Account* account = NULL;
		gint64 _tmp20_ = 0LL;
		Account* _tmp21_ = NULL;
		Account* _tmp22_ = NULL;
		Account* _tmp23_ = NULL;
		Account* _tmp27_ = NULL;
		MainWindow* _tmp28_ = NULL;
		MainWindow* _tmp29_ = NULL;
		Bundle* bundle = NULL;
		Bundle* _tmp30_ = NULL;
		Bundle* _tmp31_ = NULL;
		gint64 _tmp32_ = 0LL;
		MainWindow* _tmp33_ = NULL;
		MainWidget* _tmp34_ = NULL;
		Bundle* _tmp35_ = NULL;
		MainWindow* _tmp36_ = NULL;
		_tmp20_ = account_id;
		_tmp21_ = account_query_account_by_id (_tmp20_);
		_tmp22_ = _g_object_ref0 (_tmp21_);
		account = _tmp22_;
		_tmp23_ = account;
		if (_tmp23_ == NULL) {
			gint64 _tmp24_ = 0LL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			_tmp24_ = account_id;
			_tmp25_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp24_);
			_tmp26_ = _tmp25_;
			g_critical ("Corebird.vala:501: No account with id %s found", _tmp26_);
			_g_free0 (_tmp26_);
			_g_object_unref0 (account);
			_g_object_unref0 (main_window);
			return;
		}
		_tmp27_ = account;
		_tmp28_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp27_);
		g_object_ref_sink (_tmp28_);
		_g_object_unref0 (main_window);
		main_window = _tmp28_;
		_tmp29_ = main_window;
		gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_window_get_type (), GtkWindow));
		_tmp30_ = bundle_new ();
		bundle = _tmp30_;
		_tmp31_ = bundle;
		_tmp32_ = sender_id;
		bundle_put_int64 (_tmp31_, "sender_id", _tmp32_);
		_tmp33_ = main_window;
		_tmp34_ = _tmp33_->main_widget;
		_tmp35_ = bundle;
		main_widget_switch_page (_tmp34_, (gint) PAGE_DM, _tmp35_);
		_tmp36_ = main_window;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (bundle);
		_g_object_unref0 (account);
	}
	_g_object_unref0 (main_window);
}


static void corebird_show_window (Corebird* self, GSimpleAction* a, GVariant* value) {
	gint64 user_id = 0LL;
	GVariant* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	MainWindow* main_window = NULL;
	gint64 _tmp2_ = 0LL;
	MainWindow* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = value;
	_tmp1_ = g_variant_get_int64 (_tmp0_);
	user_id = _tmp1_;
	_tmp2_ = user_id;
	_tmp4_ = corebird_is_window_open_for_user_id (self, _tmp2_, &_tmp3_);
	_g_object_unref0 (main_window);
	main_window = _tmp3_;
	if (_tmp4_) {
		MainWindow* _tmp5_ = NULL;
		_tmp5_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_window_get_type (), GtkWindow));
	} else {
		Account* account = NULL;
		gint64 _tmp6_ = 0LL;
		Account* _tmp7_ = NULL;
		Account* _tmp8_ = NULL;
		Account* _tmp9_ = NULL;
		Account* _tmp13_ = NULL;
		MainWindow* _tmp14_ = NULL;
		MainWindow* _tmp15_ = NULL;
		MainWindow* _tmp16_ = NULL;
		_tmp6_ = user_id;
		_tmp7_ = account_query_account_by_id (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		account = _tmp8_;
		_tmp9_ = account;
		if (_tmp9_ == NULL) {
			gint64 _tmp10_ = 0LL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp10_ = user_id;
			_tmp11_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp10_);
			_tmp12_ = _tmp11_;
			g_critical ("Corebird.vala:523: No account with id %s found", _tmp12_);
			_g_free0 (_tmp12_);
			_g_object_unref0 (account);
			_g_object_unref0 (main_window);
			return;
		}
		_tmp13_ = account;
		_tmp14_ = main_window_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), _tmp13_);
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (main_window);
		main_window = _tmp14_;
		_tmp15_ = main_window;
		gtk_application_add_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_window_get_type (), GtkWindow));
		_tmp16_ = main_window;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (account);
	}
	_g_object_unref0 (main_window);
}


static void corebird_mark_read_activated (Corebird* self, GSimpleAction* a, GVariant* v) {
	gint64 account_id = 0LL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 tweet_id = 0LL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	MainWindow* main_window = NULL;
	gint64 _tmp10_ = 0LL;
	MainWindow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = v;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int64 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	account_id = _tmp4_;
	_tmp5_ = v;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_int64 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	tweet_id = _tmp9_;
	_tmp10_ = account_id;
	_tmp12_ = corebird_is_window_open_for_user_id (self, _tmp10_, &_tmp11_);
	_g_object_unref0 (main_window);
	main_window = _tmp11_;
	if (_tmp12_) {
		MainWindow* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		_tmp13_ = main_window;
		_tmp14_ = tweet_id;
		main_window_mark_tweet_as_read (_tmp13_, _tmp14_);
	}
	_g_object_unref0 (main_window);
}


static void corebird_reply_to_tweet_activated (Corebird* self, GSimpleAction* a, GVariant* v) {
	gint64 account_id = 0LL;
	GVariant* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	gint64 tweet_id = 0LL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gint64 _tmp9_ = 0LL;
	MainWindow* main_window = NULL;
	gint64 _tmp10_ = 0LL;
	MainWindow* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (IS_COREBIRD (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = v;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int64 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_variant_unref0 (_tmp2_);
	account_id = _tmp4_;
	_tmp5_ = v;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_get_int64 (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_variant_unref0 (_tmp7_);
	tweet_id = _tmp9_;
	_tmp10_ = account_id;
	_tmp12_ = corebird_is_window_open_for_user_id (self, _tmp10_, &_tmp11_);
	_g_object_unref0 (main_window);
	main_window = _tmp11_;
	if (_tmp12_) {
		MainWindow* _tmp13_ = NULL;
		gint64 _tmp14_ = 0LL;
		MainWindow* _tmp15_ = NULL;
		_tmp13_ = main_window;
		_tmp14_ = tweet_id;
		main_window_reply_to_tweet (_tmp13_, _tmp14_);
		_tmp15_ = main_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_window_get_type (), GtkWindow));
	}
	_g_object_unref0 (main_window);
}


static void g_cclosure_user_marshal_VOID__INT64_INT64 (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT64_INT64) (gpointer data1, gint64 arg_1, gint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT64_INT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT64_INT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int64 (param_values + 1), g_value_get_int64 (param_values + 2), data2);
}


static void corebird_class_init (CorebirdClass * klass) {
	corebird_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CorebirdPrivate));
	((GApplicationClass *) klass)->command_line = (gint (*)(GApplication*, GApplicationCommandLine*)) corebird_real_command_line;
	((GApplicationClass *) klass)->activate = (void (*)(GApplication*)) corebird_real_activate;
	((GApplicationClass *) klass)->startup = (void (*)(GApplication*)) corebird_real_startup;
	((GApplicationClass *) klass)->shutdown = (void (*)(GApplication*)) corebird_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = corebird_finalize;
	g_signal_new ("account_added", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_ACCOUNT);
	g_signal_new ("account_removed", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_ACCOUNT);
	g_signal_new ("account_window_changed", TYPE_COREBIRD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT64_INT64, G_TYPE_NONE, 2, G_TYPE_INT64, G_TYPE_INT64);
}


static void corebird_instance_init (Corebird * self) {
	self->priv = COREBIRD_GET_PRIVATE (self);
	self->priv->settings_dialog = NULL;
	self->priv->started_as_service = FALSE;
}


static void corebird_finalize (GObject* obj) {
	Corebird * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COREBIRD, Corebird);
	_g_object_unref0 (self->priv->settings_dialog);
	_g_ptr_array_unref0 (self->priv->active_accounts);
	G_OBJECT_CLASS (corebird_parent_class)->finalize (obj);
}


GType corebird_get_type (void) {
	static volatile gsize corebird_type_id__volatile = 0;
	if (g_once_init_enter (&corebird_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CorebirdClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) corebird_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Corebird), 0, (GInstanceInitFunc) corebird_instance_init, NULL };
		GType corebird_type_id;
		corebird_type_id = g_type_register_static (gtk_application_get_type (), "Corebird", &g_define_type_info, 0);
		g_once_init_leave (&corebird_type_id__volatile, corebird_type_id);
	}
	return corebird_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



