/* ListStatusesPage.c generated by valac 0.38.7, the Vala compiler
 * generated from ListStatusesPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include "CbDeltaUpdater.h"
#include "CbTweetModel.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include "rest/rest-proxy-call.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include <json-glib/json-glib.h>
#include "CbUtils.h"
#include "CbTwitterItem.h"
#include "CbTweet.h"
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_LIST_STATUSES_PAGE (list_statuses_page_get_type ())
#define LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPage))
#define LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))
#define IS_LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STATUSES_PAGE))
#define IS_LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STATUSES_PAGE))
#define LIST_STATUSES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))

typedef struct _ListStatusesPage ListStatusesPage;
typedef struct _ListStatusesPageClass ListStatusesPageClass;
typedef struct _ListStatusesPagePrivate ListStatusesPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_MAX_SIZE_CONTAINER (max_size_container_get_type ())
#define MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainer))
#define MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))
#define IS_MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAX_SIZE_CONTAINER))
#define IS_MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAX_SIZE_CONTAINER))
#define MAX_SIZE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))

typedef struct _MaxSizeContainer MaxSizeContainer;
typedef struct _MaxSizeContainerClass MaxSizeContainerClass;
enum  {
	LIST_STATUSES_PAGE_0_PROPERTY,
	LIST_STATUSES_PAGE_ID_PROPERTY,
	LIST_STATUSES_PAGE_WINDOW_PROPERTY,
	LIST_STATUSES_PAGE_NUM_PROPERTIES
};
static GParamSpec* list_statuses_page_properties[LIST_STATUSES_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _ListStatusesPageLoadNewestData ListStatusesPageLoadNewestData;
typedef struct _ListStatusesPageLoadOlderData ListStatusesPageLoadOlderData;
typedef struct _Block33Data Block33Data;
typedef struct _Block34Data Block34Data;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _ListStatusesPageLoadNewerData ListStatusesPageLoadNewerData;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, CbBundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _ListStatusesPage {
	ScrollWidget parent_instance;
	ListStatusesPagePrivate * priv;
	Account* account;
};

struct _ListStatusesPageClass {
	ScrollWidgetClass parent_class;
};

struct _ListStatusesPagePrivate {
	gint _id;
	MainWindow* main_window;
	gint64 list_id;
	guint tweet_remove_timeout;
	TweetListBox* tweet_list;
	MaxSizeContainer* max_size_container;
	GtkMenuButton* delete_button;
	GtkButton* edit_button;
	GtkLabel* description_label;
	GtkLabel* name_label;
	GtkLabel* creator_label;
	GtkLabel* subscribers_label;
	GtkLabel* members_label;
	GtkLabel* created_at_label;
	GtkStack* name_stack;
	GtkEntry* name_entry;
	GtkStack* description_stack;
	GtkEntry* description_entry;
	GtkStack* delete_stack;
	GtkButton* cancel_button;
	GtkStack* edit_stack;
	GtkButton* save_button;
	GtkStack* mode_stack;
	GtkLabel* mode_label;
	GtkComboBoxText* mode_combo_box;
	GtkButton* refresh_button;
	gboolean loading;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	CbDeltaUpdater* delta_updater;
	Account* account;
	CbTweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _ListStatusesPageLoadNewestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ListStatusesPage* self;
	TweetListBox* _tmp0_;
	guint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	guint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	JsonNode* root;
	JsonNode* _tmp18_;
	RestProxyCall* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	TweetListBox* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	JsonArray* root_array;
	JsonNode* _tmp30_;
	JsonArray* _tmp31_;
	JsonArray* _tmp32_;
	JsonArray* _tmp33_;
	guint _tmp34_;
	TweetListBox* _tmp35_;
	JsonArray* _tmp36_;
	TweetListBox* _tmp37_;
	Account* _tmp38_;
	GError * _inner_error_;
};

struct _ListStatusesPageLoadOlderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ListStatusesPage* self;
	gboolean _tmp0_;
	guint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	TweetListBox* _tmp12_;
	CbTweetModel* _tmp13_;
	gint64 _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	RestProxyCall* _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	JsonNode* root;
	JsonNode* _tmp21_;
	RestProxyCall* _tmp22_;
	JsonNode* _tmp23_;
	JsonNode* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	JsonArray* root_array;
	JsonNode* _tmp27_;
	JsonArray* _tmp28_;
	JsonArray* _tmp29_;
	JsonArray* _tmp30_;
	TweetListBox* _tmp31_;
	Account* _tmp32_;
	GError * _inner_error_;
};

struct _Block33Data {
	int _ref_count_;
	ListStatusesPage* self;
	RestProxyCall* call;
};

struct _Block34Data {
	int _ref_count_;
	ListStatusesPage* self;
	RestProxyCall* call;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _ListStatusesPageLoadNewerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ListStatusesPage* self;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	RestProxyCall* _tmp9_;
	gint64 since_id;
	TweetListBox* _tmp10_;
	CbTweetModel* _tmp11_;
	gint64 _tmp12_;
	gint64 _tmp13_;
	RestProxyCall* _tmp14_;
	gint64 _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint64 _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint64 _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	JsonNode* root;
	JsonNode* _tmp24_;
	RestProxyCall* _tmp25_;
	JsonNode* _tmp26_;
	JsonNode* _tmp27_;
	GError* e;
	GError* _tmp28_;
	const gchar* _tmp29_;
	JsonArray* root_array;
	JsonNode* _tmp30_;
	JsonArray* _tmp31_;
	JsonArray* _tmp32_;
	JsonArray* _tmp33_;
	guint _tmp34_;
	JsonArray* _tmp35_;
	TweetListBox* _tmp36_;
	Account* _tmp37_;
	GError * _inner_error_;
};


static gpointer list_statuses_page_parent_class = NULL;
static IPageIface * list_statuses_page_ipage_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType list_statuses_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType max_size_container_get_type (void) G_GNUC_CONST;
#define LIST_STATUSES_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIST_STATUSES_PAGE, ListStatusesPagePrivate))
#define LIST_STATUSES_PAGE_KEY_USER_LIST 0
#define LIST_STATUSES_PAGE_KEY_NAME 1
#define LIST_STATUSES_PAGE_KEY_DESCRIPTION 2
#define LIST_STATUSES_PAGE_KEY_CREATOR 3
#define LIST_STATUSES_PAGE_KEY_N_SUBSCRIBERS 4
#define LIST_STATUSES_PAGE_KEY_N_MEMBERS 5
#define LIST_STATUSES_PAGE_KEY_CREATED_AT 6
#define LIST_STATUSES_PAGE_KEY_MODE 7
#define LIST_STATUSES_PAGE_KEY_LIST_ID 8
ListStatusesPage* list_statuses_page_new (gint id, Account* account);
ListStatusesPage* list_statuses_page_construct (GType object_type, gint id, Account* account);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
static gboolean list_statuses_page_scroll_event_cb (ListStatusesPage* self, GdkEventScroll* evt);
static gboolean _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void list_statuses_page_load_older (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_older_finish (ListStatusesPage* self, GAsyncResult* _res_);
static void _list_statuses_page_load_older_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
void list_statuses_page_handle_scrolled_to_start (ListStatusesPage* self);
static void _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
gint max_size_container_get_max_size (MaxSizeContainer* self);
void max_size_container_set_max_size (MaxSizeContainer* self, gint value);
static void list_statuses_page_real_on_join (IPage* base, gint page_id, CbBundle* args);
gchar* utils_capitalize (const gchar* s);
static void list_statuses_page_load_newer (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_newer_finish (ListStatusesPage* self, GAsyncResult* _res_);
static void list_statuses_page_load_newest (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_newest_finish (ListStatusesPage* self, GAsyncResult* _res_);
static void list_statuses_page_real_on_leave (IPage* base);
static void list_statuses_page_load_newest_data_free (gpointer _data);
static gboolean list_statuses_page_load_newest_co (ListStatusesPageLoadNewestData* _data_);
void tweet_list_box_set_unempty (TweetListBox* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void list_statuses_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
static void list_statuses_page_load_older_data_free (gpointer _data);
static gboolean list_statuses_page_load_older_co (ListStatusesPageLoadOlderData* _data_);
static void list_statuses_page_load_older_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void list_statuses_page_edit_button_clicked_cb (ListStatusesPage* self);
static gchar* list_statuses_page_real_list_name (ListStatusesPage* self);
static void _list_statuses_page_edit_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_cancel_button_clicked_cb (ListStatusesPage* self);
static void _list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_save_button_clicked_cb (ListStatusesPage* self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda72_ (Block33Data* _data33_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_statuses_page_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_delete_confirmation_item_clicked_cb (ListStatusesPage* self);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void __lambda73_ (Block34Data* _data34_, GObject* o, GAsyncResult* res);
static void ___lambda73__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
#define LISTS_PAGE_KEY_MODE 0
#define LISTS_PAGE_MODE_DELETE 1
#define LISTS_PAGE_KEY_LIST_ID 1
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void list_statuses_page_refresh_button_clicked_cb (ListStatusesPage* self);
static void __lambda81_ (ListStatusesPage* self);
static void ___lambda81__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_tweet_activated_cb (ListStatusesPage* self, GtkListBoxRow* row);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_KEY_MODE 0
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_KEY_TWEET 1
static void _list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void list_statuses_page_load_newer_data_free (gpointer _data);
static gboolean list_statuses_page_load_newer_co (ListStatusesPageLoadNewerData* _data_);
static void list_statuses_page_load_newer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define DEFAULT_TIMELINE_REST 25
static gboolean ___lambda71_ (ListStatusesPage* self);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
static gboolean ____lambda71__gsource_func (gpointer self);
static gchar* list_statuses_page_real_get_title (IPage* base);
static void list_statuses_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* list_statuses_page_real_get_radio_button (IPage* base);
static void list_statuses_page_finalize (GObject * obj);
gint ipage_get_id (IPage* self);
static void _vala_list_statuses_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_list_statuses_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gboolean _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = list_statuses_page_scroll_event_cb ((ListStatusesPage*) self, event);
	return result;
}


static void _list_statuses_page_load_older_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	list_statuses_page_load_older ((ListStatusesPage*) self, NULL, NULL);
}


static void _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	list_statuses_page_handle_scrolled_to_start ((ListStatusesPage*) self);
}


ListStatusesPage* list_statuses_page_construct (GType object_type, gint id, Account* account) {
	ListStatusesPage * self = NULL;
	gint _tmp0_;
	Account* _tmp1_;
	TweetListBox* _tmp2_;
	Account* _tmp3_;
	TweetListBox* _tmp4_;
	GtkAdjustment* _tmp5_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (ListStatusesPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->tweet_list;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) _list_statuses_page_load_older_scroll_widget_scrolled_to_end, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-start", (GCallback) _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start, self, 0);
	_tmp4_ = self->priv->tweet_list;
	_tmp5_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	gtk_list_box_set_adjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_box_get_type (), GtkListBox), _tmp5_);
	return self;
}


ListStatusesPage* list_statuses_page_new (gint id, Account* account) {
	return list_statuses_page_construct (TYPE_LIST_STATUSES_PAGE, id, account);
}


static gboolean list_statuses_page_scroll_event_cb (ListStatusesPage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventScroll* _tmp1_;
	gdouble _tmp2_;
	g_return_val_if_fail (IS_LIST_STATUSES_PAGE (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->delta_y;
	if (_tmp2_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp3_;
		GtkAdjustment* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp3_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_adjustment_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint inc = 0;
		GtkAdjustment* _tmp7_;
		GtkAdjustment* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		GdkEventScroll* _tmp11_;
		gdouble _tmp12_;
		MaxSizeContainer* _tmp13_;
		MaxSizeContainer* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp7_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp8_ = _tmp7_;
		_tmp9_ = gtk_adjustment_get_step_increment (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = evt;
		_tmp12_ = _tmp11_->delta_y;
		inc = (gint) (_tmp10_ * (-_tmp12_));
		_tmp13_ = self->priv->max_size_container;
		_tmp14_ = self->priv->max_size_container;
		_tmp15_ = max_size_container_get_max_size (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = inc;
		max_size_container_set_max_size (_tmp14_, _tmp16_ + _tmp17_);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


/**
   * va_list params:
   *  - int64 list_id - The id of the list to show
   *  - string name - The lists's name
   *  - bool user_list - true if the list belongs to the user, false otherwise
   *  - string description - the lists's description
   *  - string creator
   *  - int subscribers_count
   *  - int memebers_count
   *  - int64 created_at
   *  - string mode
   */
static void list_statuses_page_real_on_join (IPage* base, gint page_id, CbBundle* args) {
	ListStatusesPage * self;
	gint64 list_id = 0LL;
	CbBundle* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gchar* list_name = NULL;
	CbBundle* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint64 _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gint64 _tmp58_;
	gint64 _tmp59_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	g_return_if_fail ((args == NULL) || CB_IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = cb_bundle_get_int64 (_tmp0_, LIST_STATUSES_PAGE_KEY_LIST_ID);
	list_id = _tmp1_;
	_tmp2_ = list_id;
	if (_tmp2_ == ((gint64) 0)) {
		gint64 _tmp3_;
		_tmp3_ = self->priv->list_id;
		list_id = _tmp3_;
		return;
	}
	_tmp4_ = args;
	_tmp5_ = cb_bundle_get_string (_tmp4_, LIST_STATUSES_PAGE_KEY_NAME);
	_tmp6_ = g_strdup (_tmp5_);
	list_name = _tmp6_;
	_tmp7_ = list_name;
	if (_tmp7_ != NULL) {
		gboolean user_list = FALSE;
		CbBundle* _tmp8_;
		gboolean _tmp9_;
		gchar* description = NULL;
		CbBundle* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* creator = NULL;
		CbBundle* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gint n_subscribers = 0;
		CbBundle* _tmp16_;
		gint _tmp17_;
		gint n_members = 0;
		CbBundle* _tmp18_;
		gint _tmp19_;
		gint64 created_at = 0LL;
		CbBundle* _tmp20_;
		gint64 _tmp21_;
		gchar* mode = NULL;
		CbBundle* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		GtkMenuButton* _tmp25_;
		gboolean _tmp26_;
		GtkButton* _tmp27_;
		gboolean _tmp28_;
		GtkLabel* _tmp29_;
		const gchar* _tmp30_;
		GtkLabel* _tmp31_;
		const gchar* _tmp32_;
		GtkLabel* _tmp33_;
		const gchar* _tmp34_;
		GtkLabel* _tmp35_;
		gint _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GtkLabel* _tmp39_;
		gint _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		GtkLabel* _tmp43_;
		gint64 _tmp44_;
		GDateTime* _tmp45_;
		GDateTime* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		GtkLabel* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp8_ = args;
		_tmp9_ = cb_bundle_get_bool (_tmp8_, LIST_STATUSES_PAGE_KEY_USER_LIST);
		user_list = _tmp9_;
		_tmp10_ = args;
		_tmp11_ = cb_bundle_get_string (_tmp10_, LIST_STATUSES_PAGE_KEY_DESCRIPTION);
		_tmp12_ = g_strdup (_tmp11_);
		description = _tmp12_;
		_tmp13_ = args;
		_tmp14_ = cb_bundle_get_string (_tmp13_, LIST_STATUSES_PAGE_KEY_CREATOR);
		_tmp15_ = g_strdup (_tmp14_);
		creator = _tmp15_;
		_tmp16_ = args;
		_tmp17_ = cb_bundle_get_int (_tmp16_, LIST_STATUSES_PAGE_KEY_N_SUBSCRIBERS);
		n_subscribers = _tmp17_;
		_tmp18_ = args;
		_tmp19_ = cb_bundle_get_int (_tmp18_, LIST_STATUSES_PAGE_KEY_N_MEMBERS);
		n_members = _tmp19_;
		_tmp20_ = args;
		_tmp21_ = cb_bundle_get_int64 (_tmp20_, LIST_STATUSES_PAGE_KEY_CREATED_AT);
		created_at = _tmp21_;
		_tmp22_ = args;
		_tmp23_ = cb_bundle_get_string (_tmp22_, LIST_STATUSES_PAGE_KEY_MODE);
		_tmp24_ = g_strdup (_tmp23_);
		mode = _tmp24_;
		_tmp25_ = self->priv->delete_button;
		_tmp26_ = user_list;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), _tmp26_);
		_tmp27_ = self->priv->edit_button;
		_tmp28_ = user_list;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), _tmp28_);
		_tmp29_ = self->priv->name_label;
		_tmp30_ = list_name;
		gtk_label_set_label (_tmp29_, _tmp30_);
		_tmp31_ = self->priv->description_label;
		_tmp32_ = description;
		gtk_label_set_label (_tmp31_, _tmp32_);
		_tmp33_ = self->priv->creator_label;
		_tmp34_ = creator;
		gtk_label_set_label (_tmp33_, _tmp34_);
		_tmp35_ = self->priv->members_label;
		_tmp36_ = n_members;
		_tmp37_ = g_strdup_printf ("%'d", _tmp36_);
		_tmp38_ = _tmp37_;
		gtk_label_set_label (_tmp35_, _tmp38_);
		_g_free0 (_tmp38_);
		_tmp39_ = self->priv->subscribers_label;
		_tmp40_ = n_subscribers;
		_tmp41_ = g_strdup_printf ("%'d", _tmp40_);
		_tmp42_ = _tmp41_;
		gtk_label_set_label (_tmp39_, _tmp42_);
		_g_free0 (_tmp42_);
		_tmp43_ = self->priv->created_at_label;
		_tmp44_ = created_at;
		_tmp45_ = g_date_time_new_from_unix_local (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_date_time_format (_tmp46_, "%x, %X");
		_tmp48_ = _tmp47_;
		gtk_label_set_label (_tmp43_, _tmp48_);
		_g_free0 (_tmp48_);
		_g_date_time_unref0 (_tmp46_);
		_tmp49_ = self->priv->mode_label;
		_tmp50_ = mode;
		_tmp51_ = utils_capitalize (_tmp50_);
		_tmp52_ = _tmp51_;
		gtk_label_set_label (_tmp49_, _tmp52_);
		_g_free0 (_tmp52_);
		_g_free0 (mode);
		_g_free0 (creator);
		_g_free0 (description);
	}
	_tmp53_ = list_id;
	_tmp54_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_strconcat ("Showing list with id ", _tmp55_, NULL);
	_tmp57_ = _tmp56_;
	g_debug ("ListStatusesPage.vala:148: %s", _tmp57_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp55_);
	_tmp58_ = list_id;
	_tmp59_ = self->priv->list_id;
	if (_tmp58_ == _tmp59_) {
		gint64 _tmp60_;
		_tmp60_ = list_id;
		self->priv->list_id = _tmp60_;
		list_statuses_page_load_newer (self, NULL, NULL);
	} else {
		MaxSizeContainer* _tmp61_;
		gint64 _tmp62_;
		TweetListBox* _tmp63_;
		CbTweetModel* _tmp64_;
		_tmp61_ = self->priv->max_size_container;
		max_size_container_set_max_size (_tmp61_, 0);
		_tmp62_ = list_id;
		self->priv->list_id = _tmp62_;
		_tmp63_ = self->priv->tweet_list;
		_tmp64_ = _tmp63_->model;
		cb_tweet_model_clear (_tmp64_);
		list_statuses_page_load_newest (self, NULL, NULL);
	}
	_g_free0 (list_name);
}


static void list_statuses_page_real_on_leave (IPage* base) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
}


static void list_statuses_page_load_newest_data_free (gpointer _data) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadNewestData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void list_statuses_page_load_newest (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadNewestData* _data_;
	ListStatusesPage* _tmp0_;
	_data_ = g_slice_new0 (ListStatusesPageLoadNewestData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, list_statuses_page_load_newest_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_newest_co (_data_);
}


static void list_statuses_page_load_newest_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void list_statuses_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_newest_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gboolean list_statuses_page_load_newest_co (ListStatusesPageLoadNewestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->loading = TRUE;
	_data_->_tmp0_ = _data_->self->priv->tweet_list;
	tweet_list_box_set_unempty (_data_->_tmp0_);
	_data_->requested_tweet_count = (guint) 25;
	_data_->_tmp1_ = _data_->self->account;
	_data_->_tmp2_ = _data_->_tmp1_->proxy;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/lists/statuses.json");
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp5_, "tweet_mode", "extended");
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = _data_->self->priv->list_id;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	g_debug ("ListStatusesPage.vala:171: USING LIST ID %s", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = _data_->self->priv->list_id;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp10_, "list_id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = _data_->requested_tweet_count;
	_data_->_tmp16_ = g_strdup_printf ("%u", _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	rest_proxy_call_add_param (_data_->_tmp14_, "count", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->root = NULL;
	{
		_data_->_tmp19_ = _data_->call;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp19_, NULL, list_statuses_page_load_newest_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp20_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp18_ = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch31_g_error;
		}
		_data_->_tmp21_ = _data_->_tmp18_;
		_data_->_tmp18_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp21_;
		__vala_JsonNode_free0 (_data_->_tmp18_);
	}
	goto __finally31;
	__catch31_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp22_ = _data_->e;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		_data_->_tmp24_ = g_utf8_strdown (_data_->_tmp23_, (gssize) -1);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = g_strcmp0 (_data_->_tmp25_, "not found") == 0;
		_g_free0 (_data_->_tmp25_);
		if (_data_->_tmp26_) {
			_data_->_tmp27_ = _data_->self->priv->tweet_list;
			tweet_list_box_set_empty (_data_->_tmp27_);
		}
		_data_->_tmp28_ = _data_->e;
		_data_->_tmp29_ = _data_->_tmp28_->message;
		g_warning ("ListStatusesPage.vala:182: %s", _data_->_tmp29_);
		_data_->self->priv->loading = FALSE;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally31:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = _data_->root;
	_data_->_tmp31_ = json_node_get_array (_data_->_tmp30_);
	_data_->_tmp32_ = _json_array_ref0 (_data_->_tmp31_);
	_data_->root_array = _data_->_tmp32_;
	_data_->_tmp33_ = _data_->root_array;
	_data_->_tmp34_ = json_array_get_length (_data_->_tmp33_);
	if (_data_->_tmp34_ == ((guint) 0)) {
		_data_->_tmp35_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp35_);
		_data_->self->priv->loading = FALSE;
		_json_array_unref0 (_data_->root_array);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = _data_->root_array;
	_data_->_tmp37_ = _data_->self->priv->tweet_list;
	_data_->_tmp38_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp36_, _data_->_tmp37_, _data_->_tmp38_);
	_data_->self->priv->loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void list_statuses_page_load_older_data_free (gpointer _data) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadOlderData, _data_);
}


static void list_statuses_page_load_older (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadOlderData* _data_;
	ListStatusesPage* _tmp0_;
	_data_ = g_slice_new0 (ListStatusesPageLoadOlderData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, list_statuses_page_load_older_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_older_co (_data_);
}


static void list_statuses_page_load_older_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void list_statuses_page_load_older_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_older_co (_data_);
}


static gboolean list_statuses_page_load_older_co (ListStatusesPageLoadOlderData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->loading;
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->loading = TRUE;
	_data_->requested_tweet_count = (guint) 25;
	_data_->_tmp1_ = _data_->self->account;
	_data_->_tmp2_ = _data_->_tmp1_->proxy;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/lists/statuses.json");
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp5_, "tweet_mode", "extended");
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = _data_->call;
	_data_->_tmp8_ = _data_->self->priv->list_id;
	_data_->_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_add_param (_data_->_tmp7_, "list_id", _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->call;
	_data_->_tmp12_ = _data_->self->priv->tweet_list;
	_data_->_tmp13_ = _data_->_tmp12_->model;
	_data_->_tmp14_ = _data_->_tmp13_->min_id;
	_data_->_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp14_ - 1);
	_data_->_tmp16_ = _data_->_tmp15_;
	rest_proxy_call_add_param (_data_->_tmp11_, "max_id", _data_->_tmp16_);
	_g_free0 (_data_->_tmp16_);
	_data_->_tmp17_ = _data_->call;
	_data_->_tmp18_ = _data_->requested_tweet_count;
	_data_->_tmp19_ = g_strdup_printf ("%u", _data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	rest_proxy_call_add_param (_data_->_tmp17_, "count", _data_->_tmp20_);
	_g_free0 (_data_->_tmp20_);
	_data_->root = NULL;
	{
		_data_->_tmp22_ = _data_->call;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp22_, NULL, list_statuses_page_load_older_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp23_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp21_ = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch32_g_error;
		}
		_data_->_tmp24_ = _data_->_tmp21_;
		_data_->_tmp21_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp24_;
		__vala_JsonNode_free0 (_data_->_tmp21_);
	}
	goto __finally32;
	__catch32_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp25_ = _data_->e;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning ("ListStatusesPage.vala:218: %s", _data_->_tmp26_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally32:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->root;
	_data_->_tmp28_ = json_node_get_array (_data_->_tmp27_);
	_data_->_tmp29_ = _json_array_ref0 (_data_->_tmp28_);
	_data_->root_array = _data_->_tmp29_;
	_data_->_tmp30_ = _data_->root_array;
	_data_->_tmp31_ = _data_->self->priv->tweet_list;
	_data_->_tmp32_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_);
	_data_->self->priv->loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void list_statuses_page_edit_button_clicked_cb (ListStatusesPage* self) {
	GtkStack* _tmp0_;
	GtkEntry* _tmp1_;
	GtkStack* _tmp2_;
	GtkEntry* _tmp3_;
	GtkStack* _tmp4_;
	GtkButton* _tmp5_;
	GtkStack* _tmp6_;
	GtkButton* _tmp7_;
	GtkStack* _tmp8_;
	GtkComboBoxText* _tmp9_;
	GtkEntry* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkEntry* _tmp13_;
	GtkLabel* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GtkComboBoxText* _tmp17_;
	GtkLabel* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->name_stack;
	_tmp1_ = self->priv->name_entry;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->description_stack;
	_tmp3_ = self->priv->description_entry;
	gtk_stack_set_visible_child (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = self->priv->delete_stack;
	_tmp5_ = self->priv->cancel_button;
	gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->edit_stack;
	_tmp7_ = self->priv->save_button;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->mode_stack;
	_tmp9_ = self->priv->mode_combo_box;
	gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->name_entry;
	_tmp11_ = list_statuses_page_real_list_name (self);
	_tmp12_ = _tmp11_;
	gtk_entry_set_text (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->description_entry;
	_tmp14_ = self->priv->description_label;
	_tmp15_ = gtk_label_get_label (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_entry_set_text (_tmp13_, _tmp16_);
	_tmp17_ = self->priv->mode_combo_box;
	_tmp18_ = self->priv->mode_label;
	_tmp19_ = gtk_label_get_label (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_combo_box_set_active_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_combo_box_get_type (), GtkComboBox), _tmp20_);
}


static void _list_statuses_page_edit_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_edit_button_clicked_cb ((ListStatusesPage*) self);
}


static void list_statuses_page_cancel_button_clicked_cb (ListStatusesPage* self) {
	GtkStack* _tmp0_;
	GtkLabel* _tmp1_;
	GtkStack* _tmp2_;
	GtkLabel* _tmp3_;
	GtkStack* _tmp4_;
	GtkMenuButton* _tmp5_;
	GtkStack* _tmp6_;
	GtkButton* _tmp7_;
	GtkStack* _tmp8_;
	GtkLabel* _tmp9_;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->name_stack;
	_tmp1_ = self->priv->name_label;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->description_stack;
	_tmp3_ = self->priv->description_label;
	gtk_stack_set_visible_child (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = self->priv->delete_stack;
	_tmp5_ = self->priv->delete_button;
	gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->edit_stack;
	_tmp7_ = self->priv->edit_button;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->mode_stack;
	_tmp9_ = self->priv->mode_label;
	gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
}


static void _list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_cancel_button_clicked_cb ((ListStatusesPage*) self);
}


static Block33Data* block33_data_ref (Block33Data* _data33_) {
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}


static void block33_data_unref (void * _userdata_) {
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->call);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}


static void __lambda72_ (Block33Data* _data33_, GObject* o, GAsyncResult* res) {
	ListStatusesPage* self;
	GtkButton* _tmp5_;
	GtkMenuButton* _tmp6_;
	GError * _inner_error_ = NULL;
	self = _data33_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data33_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		MainWindow* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data33_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 273, "ListStatusesPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally33:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = self->priv->edit_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp6_ = self->priv->delete_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda72_ (self, source_object, res);
	block33_data_unref (self);
}


static void list_statuses_page_save_button_clicked_cb (ListStatusesPage* self) {
	Block33Data* _data33_;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	GtkEntry* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GtkLabel* _tmp12_;
	GtkComboBoxText* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GtkButton* _tmp16_;
	GtkMenuButton* _tmp17_;
	Account* _tmp18_;
	OAuthProxy* _tmp19_;
	RestProxyCall* _tmp20_;
	gint64 _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkLabel* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkLabel* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = self->priv->creator_label;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->name_entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_strdup_printf ("@%s/%s", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->description_label;
	_tmp9_ = self->priv->description_entry;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp8_, _tmp11_);
	_tmp12_ = self->priv->mode_label;
	_tmp13_ = self->priv->mode_combo_box;
	_tmp14_ = gtk_combo_box_get_active_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_combo_box_get_type (), GtkComboBox));
	_tmp15_ = _tmp14_;
	gtk_label_set_label (_tmp12_, _tmp15_);
	list_statuses_page_cancel_button_clicked_cb (self);
	_tmp16_ = self->priv->edit_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp17_ = self->priv->delete_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp18_ = self->account;
	_tmp19_ = _tmp18_->proxy;
	_tmp20_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, rest_proxy_get_type (), RestProxy));
	_data33_->call = _tmp20_;
	rest_proxy_call_set_function (_data33_->call, "1.1/lists/update.json");
	rest_proxy_call_set_method (_data33_->call, "POST");
	_tmp21_ = self->priv->list_id;
	_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp21_);
	_tmp23_ = _tmp22_;
	rest_proxy_call_add_param (_data33_->call, "list_id", _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = list_statuses_page_real_list_name (self);
	_tmp25_ = _tmp24_;
	rest_proxy_call_add_param (_data33_->call, "name", _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->mode_label;
	_tmp27_ = gtk_label_get_label (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_utf8_strdown (_tmp28_, (gssize) -1);
	_tmp30_ = _tmp29_;
	rest_proxy_call_add_param (_data33_->call, "mode", _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = self->priv->description_label;
	_tmp32_ = gtk_label_get_label (_tmp31_);
	_tmp33_ = _tmp32_;
	rest_proxy_call_add_param (_data33_->call, "description", _tmp33_);
	rest_proxy_call_invoke_async (_data33_->call, NULL, ___lambda72__gasync_ready_callback, block33_data_ref (_data33_));
	block33_data_unref (_data33_);
	_data33_ = NULL;
}


static void _list_statuses_page_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_save_button_clicked_cb ((ListStatusesPage*) self);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* list_statuses_page_real_list_name (ListStatusesPage* self) {
	gchar* result = NULL;
	gchar* cur_name = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint slash_index = 0;
	gint _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (IS_LIST_STATUSES_PAGE (self), NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	cur_name = _tmp3_;
	_tmp4_ = string_index_of (cur_name, "/", 0);
	slash_index = _tmp4_;
	_tmp5_ = string_substring (cur_name, (glong) (slash_index + 1), (glong) -1);
	result = _tmp5_;
	_g_free0 (cur_name);
	return result;
}


static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->call);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}


static void __lambda73_ (Block34Data* _data34_, GObject* o, GAsyncResult* res) {
	ListStatusesPage* self;
	GError * _inner_error_ = NULL;
	self = _data34_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data34_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		MainWindow* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data34_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 297, "ListStatusesPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda73__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda73_ (self, source_object, res);
	block34_data_unref (self);
}


static void list_statuses_page_delete_confirmation_item_clicked_cb (ListStatusesPage* self) {
	Block34Data* _data34_;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	CbBundle* bundle = NULL;
	CbBundle* _tmp6_;
	gint64 _tmp7_;
	MainWindow* _tmp8_;
	MainWidget* _tmp9_;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_data34_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data34_->call = _tmp2_;
	rest_proxy_call_set_function (_data34_->call, "1.1/lists/destroy.json");
	_tmp3_ = self->priv->list_id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data34_->call, "list_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_set_method (_data34_->call, "POST");
	rest_proxy_call_invoke_async (_data34_->call, NULL, ___lambda73__gasync_ready_callback, block34_data_ref (_data34_));
	_tmp6_ = cb_bundle_new ();
	bundle = _tmp6_;
	cb_bundle_put_int (bundle, LISTS_PAGE_KEY_MODE, LISTS_PAGE_MODE_DELETE);
	_tmp7_ = self->priv->list_id;
	cb_bundle_put_int64 (bundle, LISTS_PAGE_KEY_LIST_ID, _tmp7_);
	_tmp8_ = self->priv->main_window;
	_tmp9_ = _tmp8_->main_widget;
	main_widget_switch_page (_tmp9_, (gint) PAGE_LISTS, bundle);
	_g_object_unref0 (bundle);
	block34_data_unref (_data34_);
	_data34_ = NULL;
}


static void _list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	list_statuses_page_delete_confirmation_item_clicked_cb ((ListStatusesPage*) self);
}


static void __lambda81_ (ListStatusesPage* self) {
	GtkButton* _tmp0_;
	_tmp0_ = self->priv->refresh_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda81__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda81_ ((ListStatusesPage*) self);
	g_object_unref (self);
}


static void list_statuses_page_refresh_button_clicked_cb (ListStatusesPage* self) {
	GtkButton* _tmp0_;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->refresh_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	list_statuses_page_load_newer (self, ___lambda81__gasync_ready_callback, g_object_ref (self));
}


static void _list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_refresh_button_clicked_cb ((ListStatusesPage*) self);
}


static void list_statuses_page_tweet_activated_cb (ListStatusesPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TWEET_LIST_ENTRY)) {
		CbBundle* bundle = NULL;
		CbBundle* _tmp1_;
		CbBundle* _tmp2_;
		CbBundle* _tmp3_;
		GtkListBoxRow* _tmp4_;
		CbTweet* _tmp5_;
		MainWindow* _tmp6_;
		MainWidget* _tmp7_;
		CbBundle* _tmp8_;
		_tmp1_ = cb_bundle_new ();
		bundle = _tmp1_;
		_tmp2_ = bundle;
		cb_bundle_put_int (_tmp2_, TWEET_INFO_PAGE_KEY_MODE, TWEET_INFO_PAGE_BY_INSTANCE);
		_tmp3_ = bundle;
		_tmp4_ = row;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
		cb_bundle_put_object (_tmp3_, TWEET_INFO_PAGE_KEY_TWEET, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject));
		_tmp6_ = self->priv->main_window;
		_tmp7_ = _tmp6_->main_widget;
		_tmp8_ = bundle;
		main_widget_switch_page (_tmp7_, (gint) PAGE_TWEET_INFO, _tmp8_);
		_g_object_unref0 (bundle);
	} else {
		g_warning ("ListStatusesPage.vala:323: row is of unknown type");
	}
}


static void _list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	list_statuses_page_tweet_activated_cb ((ListStatusesPage*) self, row);
}


static void list_statuses_page_load_newer_data_free (gpointer _data) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadNewerData, _data_);
}


static void list_statuses_page_load_newer (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadNewerData* _data_;
	ListStatusesPage* _tmp0_;
	_data_ = g_slice_new0 (ListStatusesPageLoadNewerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, list_statuses_page_load_newer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_newer_co (_data_);
}


static void list_statuses_page_load_newer_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static void list_statuses_page_load_newer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_newer_co (_data_);
}


static gboolean list_statuses_page_load_newer_co (ListStatusesPageLoadNewerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->account;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp3_, "1.1/lists/statuses.json");
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = _data_->self->priv->list_id;
	_data_->_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp6_);
	_data_->_tmp8_ = _data_->_tmp7_;
	rest_proxy_call_add_param (_data_->_tmp5_, "list_id", _data_->_tmp8_);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", "30");
	_data_->_tmp10_ = _data_->self->priv->tweet_list;
	_data_->_tmp11_ = _data_->_tmp10_->model;
	_data_->_tmp12_ = _data_->_tmp11_->max_id;
	_data_->since_id = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->since_id;
	if (_data_->_tmp13_ < ((gint64) 0)) {
		_data_->since_id = (gint64) 1;
	}
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = _data_->since_id;
	_data_->_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp15_);
	_data_->_tmp17_ = _data_->_tmp16_;
	rest_proxy_call_add_param (_data_->_tmp14_, "since_id", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp18_ = _data_->since_id;
	_data_->_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp18_);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = _data_->self->priv->list_id;
	_data_->_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp21_);
	_data_->_tmp23_ = _data_->_tmp22_;
	g_debug ("ListStatusesPage.vala:337: Getting statuses since %s for list_id %s", _data_->_tmp20_, _data_->_tmp23_);
	_g_free0 (_data_->_tmp23_);
	_g_free0 (_data_->_tmp20_);
	_data_->root = NULL;
	{
		_data_->_tmp25_ = _data_->call;
		_data_->_state_ = 1;
		cb_utils_load_threaded_async (_data_->_tmp25_, NULL, list_statuses_page_load_newer_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp26_ = cb_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp24_ = _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch35_g_error;
		}
		_data_->_tmp27_ = _data_->_tmp24_;
		_data_->_tmp24_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp27_;
		__vala_JsonNode_free0 (_data_->_tmp24_);
	}
	goto __finally35;
	__catch35_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp28_ = _data_->e;
		_data_->_tmp29_ = _data_->_tmp28_->message;
		g_warning ("ListStatusesPage.vala:344: %s", _data_->_tmp29_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally35:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp30_ = _data_->root;
	_data_->_tmp31_ = json_node_get_array (_data_->_tmp30_);
	_data_->_tmp32_ = _json_array_ref0 (_data_->_tmp31_);
	_data_->root_array = _data_->_tmp32_;
	_data_->_tmp33_ = _data_->root_array;
	_data_->_tmp34_ = json_array_get_length (_data_->_tmp33_);
	if (_data_->_tmp34_ > ((guint) 0)) {
		_data_->_tmp35_ = _data_->root_array;
		_data_->_tmp36_ = _data_->self->priv->tweet_list;
		_data_->_tmp37_ = _data_->self->account;
		tweet_utils_work_array (_data_->_tmp35_, _data_->_tmp36_, _data_->_tmp37_);
	}
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean ___lambda71_ (ListStatusesPage* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TweetListBox* _tmp2_;
	CbTweetModel* _tmp3_;
	TweetListBox* _tmp4_;
	CbTweetModel* _tmp5_;
	guint _tmp6_;
	_tmp0_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		self->priv->tweet_remove_timeout = (guint) 0;
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->tweet_list;
	_tmp3_ = _tmp2_->model;
	_tmp4_ = self->priv->tweet_list;
	_tmp5_ = _tmp4_->model;
	_tmp6_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_list_model_get_type (), GListModel));
	cb_tweet_model_remove_last_n_visible (_tmp3_, _tmp6_ - DEFAULT_TIMELINE_REST);
	self->priv->tweet_remove_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda71__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda71_ ((ListStatusesPage*) self);
	return result;
}


void list_statuses_page_handle_scrolled_to_start (ListStatusesPage* self) {
	guint _tmp0_;
	TweetListBox* _tmp1_;
	CbTweetModel* _tmp2_;
	guint _tmp3_;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->tweet_remove_timeout;
	if (_tmp0_ != ((guint) 0)) {
		return;
	}
	_tmp1_ = self->priv->tweet_list;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_model_get_type (), GListModel));
	if (_tmp3_ > ((guint) DEFAULT_TIMELINE_REST)) {
		guint _tmp4_;
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda71__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->tweet_remove_timeout = _tmp4_;
	} else {
		guint _tmp5_;
		_tmp5_ = self->priv->tweet_remove_timeout;
		if (_tmp5_ != ((guint) 0)) {
			guint _tmp6_;
			_tmp6_ = self->priv->tweet_remove_timeout;
			g_source_remove (_tmp6_);
			self->priv->tweet_remove_timeout = (guint) 0;
		}
	}
}


static gchar* list_statuses_page_real_get_title (IPage* base) {
	ListStatusesPage * self;
	gchar* result = NULL;
	gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = g_strdup (_ ("List"));
	result = _tmp0_;
	return result;
}


static void list_statuses_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* list_statuses_page_real_get_radio_button (IPage* base) {
	ListStatusesPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	result = NULL;
	return result;
}


static gint list_statuses_page_real_get_id (IPage* base) {
	gint result;
	ListStatusesPage* self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void list_statuses_page_real_set_id (IPage* base, gint value) {
	ListStatusesPage* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	if (list_statuses_page_real_get_id (base) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, list_statuses_page_properties[LIST_STATUSES_PAGE_ID_PROPERTY]);
	}
}


static void list_statuses_page_real_set_window (IPage* base, MainWindow* value) {
	ListStatusesPage* self;
	MainWindow* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, list_statuses_page_properties[LIST_STATUSES_PAGE_WINDOW_PROPERTY]);
}


static void list_statuses_page_class_init (ListStatusesPageClass * klass) {
	gint ListStatusesPage_private_offset;
	list_statuses_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListStatusesPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_list_statuses_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_list_statuses_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = list_statuses_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_ID_PROPERTY, list_statuses_page_properties[LIST_STATUSES_PAGE_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_WINDOW_PROPERTY, list_statuses_page_properties[LIST_STATUSES_PAGE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	ListStatusesPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/list-statuses-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_size_container", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, max_size_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, delete_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, edit_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "creator_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, creator_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribers_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, subscribers_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "members_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, members_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "created_at_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, created_at_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_entry", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, delete_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, edit_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_combo_box", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_combo_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "refresh_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, refresh_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "edit_button_clicked_cb", G_CALLBACK(_list_statuses_page_edit_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_clicked_cb", G_CALLBACK(_list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_button_clicked_cb", G_CALLBACK(_list_statuses_page_save_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_confirmation_item_clicked_cb", G_CALLBACK(_list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "refresh_button_clicked_cb", G_CALLBACK(_list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "tweet_activated_cb", G_CALLBACK(_list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated));
}


static void list_statuses_page_ipage_interface_init (IPageIface * iface) {
	list_statuses_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*) (IPage *, gint, CbBundle*)) list_statuses_page_real_on_join;
	iface->on_leave = (void (*) (IPage *)) list_statuses_page_real_on_leave;
	iface->get_title = (gchar* (*) (IPage *)) list_statuses_page_real_get_title;
	iface->create_radio_button = (void (*) (IPage *, GtkRadioButton*)) list_statuses_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*) (IPage *)) list_statuses_page_real_get_radio_button;
	iface->get_id = list_statuses_page_real_get_id;
	iface->set_id = list_statuses_page_real_set_id;
	iface->set_window = list_statuses_page_real_set_window;
}


static void list_statuses_page_instance_init (ListStatusesPage * self) {
	self->priv = LIST_STATUSES_PAGE_GET_PRIVATE (self);
	self->priv->tweet_remove_timeout = (guint) 0;
	self->priv->loading = FALSE;
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_MAX_SIZE_CONTAINER);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void list_statuses_page_finalize (GObject * obj) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->max_size_container);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->creator_label);
	_g_object_unref0 (self->priv->subscribers_label);
	_g_object_unref0 (self->priv->members_label);
	_g_object_unref0 (self->priv->created_at_label);
	_g_object_unref0 (self->priv->name_stack);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->description_stack);
	_g_object_unref0 (self->priv->description_entry);
	_g_object_unref0 (self->priv->delete_stack);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->edit_stack);
	_g_object_unref0 (self->priv->save_button);
	_g_object_unref0 (self->priv->mode_stack);
	_g_object_unref0 (self->priv->mode_label);
	_g_object_unref0 (self->priv->mode_combo_box);
	_g_object_unref0 (self->priv->refresh_button);
	G_OBJECT_CLASS (list_statuses_page_parent_class)->finalize (obj);
}


GType list_statuses_page_get_type (void) {
	static volatile gsize list_statuses_page_type_id__volatile = 0;
	if (g_once_init_enter (&list_statuses_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListStatusesPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_statuses_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListStatusesPage), 0, (GInstanceInitFunc) list_statuses_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) list_statuses_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType list_statuses_page_type_id;
		list_statuses_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ListStatusesPage", &g_define_type_info, 0);
		g_type_add_interface_static (list_statuses_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&list_statuses_page_type_id__volatile, list_statuses_page_type_id);
	}
	return list_statuses_page_type_id__volatile;
}


static void _vala_list_statuses_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	switch (property_id) {
		case LIST_STATUSES_PAGE_ID_PROPERTY:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_list_statuses_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	switch (property_id) {
		case LIST_STATUSES_PAGE_ID_PROPERTY:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case LIST_STATUSES_PAGE_WINDOW_PROPERTY:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



