/* BackendRackspace.c generated by valac 0.30.2, the Vala compiler
 * generated from BackendRackspace.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libsecret/secret.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_TOOL_JOB_TYPE_MODE (deja_dup_tool_job_mode_get_type ())

#define DEJA_DUP_TYPE_BACKEND_RACKSPACE (deja_dup_backend_rackspace_get_type ())
#define DEJA_DUP_BACKEND_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspace))
#define DEJA_DUP_BACKEND_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspaceClass))
#define DEJA_DUP_IS_BACKEND_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE))
#define DEJA_DUP_IS_BACKEND_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_RACKSPACE))
#define DEJA_DUP_BACKEND_RACKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspaceClass))

typedef struct _DejaDupBackendRackspace DejaDupBackendRackspace;
typedef struct _DejaDupBackendRackspaceClass DejaDupBackendRackspaceClass;
typedef struct _DejaDupBackendRackspacePrivate DejaDupBackendRackspacePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_CHECKER (deja_dup_checker_get_type ())
#define DEJA_DUP_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupChecker))
#define DEJA_DUP_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))
#define DEJA_DUP_IS_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_IS_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_CHECKER))
#define DEJA_DUP_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_CHECKER, DejaDupCheckerClass))

typedef struct _DejaDupChecker DejaDupChecker;
typedef struct _DejaDupCheckerClass DejaDupCheckerClass;

#define DEJA_DUP_TYPE_PYTHON_CHECKER (deja_dup_python_checker_get_type ())
#define DEJA_DUP_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonChecker))
#define DEJA_DUP_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))
#define DEJA_DUP_IS_PYTHON_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_IS_PYTHON_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_PYTHON_CHECKER))
#define DEJA_DUP_PYTHON_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_PYTHON_CHECKER, DejaDupPythonCheckerClass))

typedef struct _DejaDupPythonChecker DejaDupPythonChecker;
typedef struct _DejaDupPythonCheckerClass DejaDupPythonCheckerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DEJA_DUP_TYPE_NETWORK (deja_dup_network_get_type ())
#define DEJA_DUP_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetwork))
#define DEJA_DUP_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))
#define DEJA_DUP_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_NETWORK))
#define DEJA_DUP_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_NETWORK, DejaDupNetworkClass))

typedef struct _DejaDupNetwork DejaDupNetwork;
typedef struct _DejaDupNetworkClass DejaDupNetworkClass;
typedef struct _DejaDupBackendRackspaceIsReadyData DejaDupBackendRackspaceIsReadyData;

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendRackspaceGetEnvpData DejaDupBackendRackspaceGetEnvpData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupBackendRackspaceGotPasswordReplyData DejaDupBackendRackspaceGotPasswordReplyData;

typedef enum  {
	DEJA_DUP_TOOL_JOB_MODE_INVALID,
	DEJA_DUP_TOOL_JOB_MODE_BACKUP,
	DEJA_DUP_TOOL_JOB_MODE_RESTORE,
	DEJA_DUP_TOOL_JOB_MODE_STATUS,
	DEJA_DUP_TOOL_JOB_MODE_LIST,
	DEJA_DUP_TOOL_JOB_MODE_HISTORY
} DejaDupToolJobMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, gboolean* as_root);
	gchar* (*get_location_pretty) (DejaDupBackend* self);
	void (*is_ready) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*is_ready_finish) (DejaDupBackend* self, GAsyncResult* _res_, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendRackspace {
	DejaDupBackend parent_instance;
	DejaDupBackendRackspacePrivate * priv;
};

struct _DejaDupBackendRackspaceClass {
	DejaDupBackendClass parent_class;
};

struct _DejaDupBackendRackspacePrivate {
	gchar* settings_id;
	gchar* id;
	gchar* secret_key;
};

struct _DejaDupBackendRackspaceIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendRackspace* self;
	gchar* when;
	gboolean result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
};

struct _DejaDupBackendRackspaceGetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendRackspace* self;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp0_;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	SecretSchema* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* e;
	GError * _inner_error_;
};

struct _DejaDupBackendRackspaceGotPasswordReplyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackendRackspace* self;
	GMountOperation* mount_op;
	GMountOperationResult _result_;
	GMountOperationResult _tmp0_;
	GList* _tmp1_;
	const gchar* _tmp2_;
	GMountOperation* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GMountOperation* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GPasswordSave remember;
	GMountOperation* _tmp11_;
	GPasswordSave _tmp12_;
	GPasswordSave _tmp13_;
	GPasswordSave _tmp14_;
	const gchar* _tmp15_;
	GPasswordSave _tmp16_;
	gchar* where;
	gchar* _tmp17_;
	SecretSchema* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	GError* e;
	GError* _tmp25_;
	const gchar* _tmp26_;
	GError * _inner_error_;
};


static gpointer deja_dup_backend_rackspace_parent_class = NULL;

#define DEJA_DUP_RACKSPACE_ROOT "Rackspace"
#define DEJA_DUP_RACKSPACE_USERNAME_KEY "username"
#define DEJA_DUP_RACKSPACE_CONTAINER_KEY "container"
#define DEJA_DUP_RACKSPACE_SERVER "auth.api.rackspacecloud.com"
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_mode_get_type (void) G_GNUC_CONST;
GType deja_dup_backend_rackspace_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_RACKSPACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspacePrivate))
enum  {
	DEJA_DUP_BACKEND_RACKSPACE_DUMMY_PROPERTY
};
GType deja_dup_checker_get_type (void) G_GNUC_CONST;
DejaDupChecker* deja_dup_backend_rackspace_get_checker (void);
GType deja_dup_python_checker_get_type (void) G_GNUC_CONST;
DejaDupPythonChecker* deja_dup_python_checker_get_checker (const gchar* module);
static DejaDupBackend* deja_dup_backend_rackspace_real_clone (DejaDupBackend* base);
DejaDupBackendRackspace* deja_dup_backend_rackspace_new (void);
DejaDupBackendRackspace* deja_dup_backend_rackspace_construct (GType object_type);
static gboolean deja_dup_backend_rackspace_real_is_native (DejaDupBackend* base);
static GIcon* deja_dup_backend_rackspace_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_rackspace_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_rackspace_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_rackspace_real_is_ready_co (DejaDupBackendRackspaceIsReadyData* _data_);
GType deja_dup_network_get_type (void) G_GNUC_CONST;
DejaDupNetwork* deja_dup_network_get (void);
void deja_dup_network_can_reach (DejaDupNetwork* self, const gchar* url, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean deja_dup_network_can_reach_finish (DejaDupNetwork* self, GAsyncResult* _res_);
static void deja_dup_backend_rackspace_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar* deja_dup_backend_rackspace_real_get_location (DejaDupBackend* base, gboolean* as_root);
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
gchar* deja_dup_get_folder_key (DejaDupFilteredSettings* settings, const gchar* key);
void deja_dup_filtered_settings_set_string (DejaDupFilteredSettings* self, const gchar* k, const gchar* v);
static gchar* deja_dup_backend_rackspace_real_get_location_pretty (DejaDupBackend* base);
static void deja_dup_backend_rackspace_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_rackspace_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean deja_dup_backend_rackspace_real_get_envp_co (DejaDupBackendRackspaceGetEnvpData* _data_);
static void deja_dup_backend_rackspace_got_secret_key (DejaDupBackendRackspace* self);
static void deja_dup_backend_rackspace_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_backend_rackspace_ask_password (DejaDupBackendRackspace* self);
static void deja_dup_backend_rackspace_got_password_reply_data_free (gpointer _data);
static void deja_dup_backend_rackspace_got_password_reply (DejaDupBackendRackspace* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void deja_dup_backend_rackspace_got_password_reply_finish (DejaDupBackendRackspace* self, GAsyncResult* _res_);
static gboolean deja_dup_backend_rackspace_got_password_reply_co (DejaDupBackendRackspaceGotPasswordReplyData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void deja_dup_backend_rackspace_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
static void _deja_dup_backend_rackspace_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
DejaDupBackend* deja_dup_backend_construct (GType object_type);
static void deja_dup_backend_rackspace_finalize (GObject* obj);


DejaDupChecker* deja_dup_backend_rackspace_get_checker (void) {
	DejaDupChecker* result = NULL;
	DejaDupPythonChecker* _tmp0_ = NULL;
	_tmp0_ = deja_dup_python_checker_get_checker ("cloudfiles");
	result = (DejaDupChecker*) _tmp0_;
	return result;
}


static DejaDupBackend* deja_dup_backend_rackspace_real_clone (DejaDupBackend* base) {
	DejaDupBackendRackspace * self;
	DejaDupBackend* result = NULL;
	DejaDupBackendRackspace* _tmp0_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = deja_dup_backend_rackspace_new ();
	result = (DejaDupBackend*) _tmp0_;
	return result;
}


static gboolean deja_dup_backend_rackspace_real_is_native (DejaDupBackend* base) {
	DejaDupBackendRackspace * self;
	gboolean result = FALSE;
	self = (DejaDupBackendRackspace*) base;
	result = FALSE;
	return result;
}


static GIcon* deja_dup_backend_rackspace_real_get_icon (DejaDupBackend* base) {
	DejaDupBackendRackspace * self;
	GIcon* result = NULL;
	GThemedIcon* _tmp0_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-cloud");
	result = (GIcon*) _tmp0_;
	return result;
}


static void deja_dup_backend_rackspace_real_is_ready_data_free (gpointer _data) {
	DejaDupBackendRackspaceIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRackspaceIsReadyData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_rackspace_real_is_ready (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendRackspace * self;
	DejaDupBackendRackspaceIsReadyData* _data_;
	DejaDupBackendRackspace* _tmp0_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_data_ = g_slice_new0 (DejaDupBackendRackspaceIsReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_rackspace_real_is_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_rackspace_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rackspace_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_rackspace_real_is_ready_finish (DejaDupBackend* base, GAsyncResult* _res_, gchar** when) {
	gboolean result;
	DejaDupBackendRackspaceIsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (when) {
		*when = _data_->when;
	} else {
		_g_free0 (_data_->when);
	}
	_data_->when = NULL;
	result = _data_->result;
	return result;
}


static void deja_dup_backend_rackspace_is_ready_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendRackspaceIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rackspace_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_rackspace_real_is_ready_co (DejaDupBackendRackspaceIsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Backup will begin when a network connection becomes available.");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_g_free0 (_data_->when);
	_data_->when = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = deja_dup_network_get ();
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_strdup_printf ("http://%s/", DEJA_DUP_RACKSPACE_SERVER);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 1;
	deja_dup_network_can_reach (_data_->_tmp3_, _data_->_tmp5_, deja_dup_backend_rackspace_is_ready_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = FALSE;
	_data_->_tmp6_ = deja_dup_network_can_reach_finish (_data_->_tmp3_, _data_->_res_);
	_data_->_tmp7_ = FALSE;
	_data_->_tmp7_ = _data_->_tmp6_;
	_g_free0 (_data_->_tmp5_);
	_g_object_unref0 (_data_->_tmp3_);
	_data_->result = _data_->_tmp7_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* deja_dup_backend_rackspace_real_get_location (DejaDupBackend* base, gboolean* as_root) {
	DejaDupBackendRackspace * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* container = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_RACKSPACE_CONTAINER_KEY);
	container = _tmp2_;
	_tmp3_ = container;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		DejaDupFilteredSettings* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp4_ = g_get_host_name ();
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (container);
		container = _tmp5_;
		_tmp6_ = settings;
		_tmp7_ = container;
		deja_dup_filtered_settings_set_string (_tmp6_, DEJA_DUP_RACKSPACE_CONTAINER_KEY, _tmp7_);
	}
	_tmp8_ = container;
	_tmp9_ = g_strdup_printf ("cf+http://%s", _tmp8_);
	result = _tmp9_;
	_g_free0 (container);
	_g_object_unref0 (settings);
	return result;
}


static gchar* deja_dup_backend_rackspace_real_get_location_pretty (DejaDupBackend* base) {
	DejaDupBackendRackspace * self;
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* container = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_RACKSPACE_CONTAINER_KEY);
	container = _tmp2_;
	_tmp3_ = container;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp4_ = _ ("Rackspace Cloud Files");
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_free0 (container);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = _ ("%s on Rackspace Cloud Files");
		_tmp7_ = container;
		_tmp8_ = g_strdup_printf (_tmp6_, _tmp7_);
		result = _tmp8_;
		_g_free0 (container);
		_g_object_unref0 (settings);
		return result;
	}
	_g_free0 (container);
	_g_object_unref0 (settings);
}


static void deja_dup_backend_rackspace_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendRackspaceGetEnvpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRackspaceGetEnvpData, _data_);
}


static void deja_dup_backend_rackspace_real_get_envp (DejaDupBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendRackspace * self;
	DejaDupBackendRackspaceGetEnvpData* _data_;
	DejaDupBackendRackspace* _tmp0_ = NULL;
	self = (DejaDupBackendRackspace*) base;
	_data_ = g_slice_new0 (DejaDupBackendRackspaceGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_rackspace_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_rackspace_real_get_envp_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_rackspace_real_get_envp_co (_data_);
}


static void deja_dup_backend_rackspace_real_get_envp_finish (DejaDupBackend* base, GAsyncResult* _res_, GError** error) {
	DejaDupBackendRackspaceGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_backend_rackspace_get_envp_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendRackspaceGetEnvpData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rackspace_real_get_envp_co (_data_);
}


static gboolean deja_dup_backend_rackspace_real_get_envp_co (DejaDupBackendRackspaceGetEnvpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	_data_->settings = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->settings;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_settings_get_string ((GSettings*) _data_->_tmp1_, DEJA_DUP_RACKSPACE_USERNAME_KEY);
	_g_free0 (_data_->self->priv->settings_id);
	_data_->self->priv->settings_id = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->settings_id;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp3_ = "";
	} else {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->settings_id;
		_data_->_tmp3_ = _data_->_tmp5_;
	}
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp3_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp8_, "") != 0) {
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->secret_key;
		_data_->_tmp7_ = _data_->_tmp9_ != NULL;
	} else {
		_data_->_tmp7_ = FALSE;
	}
	if (_data_->_tmp7_) {
		deja_dup_backend_rackspace_got_secret_key (_data_->self);
		_g_object_unref0 (_data_->settings);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->id;
	if (g_strcmp0 (_data_->_tmp10_, "") != 0) {
		{
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = _data_->self->priv->id;
			_data_->_state_ = 1;
			secret_password_lookup (_data_->_tmp12_, NULL, deja_dup_backend_rackspace_get_envp_ready, _data_, "user", _data_->_tmp13_, "server", DEJA_DUP_RACKSPACE_SERVER, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = secret_password_lookup_finish (_data_->_res_, &_data_->_inner_error_);
			_data_->_tmp11_ = _data_->_tmp14_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch17_g_error;
			}
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->_tmp11_;
			_data_->_tmp11_ = NULL;
			_g_free0 (_data_->self->priv->secret_key);
			_data_->self->priv->secret_key = _data_->_tmp15_;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->self->priv->secret_key;
			if (_data_->_tmp16_ != NULL) {
				deja_dup_backend_rackspace_got_secret_key (_data_->self);
				_g_free0 (_data_->_tmp11_);
				_g_object_unref0 (_data_->settings);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_free0 (_data_->_tmp11_);
		}
		goto __finally17;
		__catch17_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->e);
		}
		__finally17:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->settings);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	deja_dup_backend_rackspace_ask_password (_data_->self);
	_g_object_unref0 (_data_->settings);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void deja_dup_backend_rackspace_got_password_reply_data_free (gpointer _data) {
	DejaDupBackendRackspaceGotPasswordReplyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->mount_op);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendRackspaceGotPasswordReplyData, _data_);
}


static void deja_dup_backend_rackspace_got_password_reply (DejaDupBackendRackspace* self, GMountOperation* mount_op, GMountOperationResult _result_, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendRackspaceGotPasswordReplyData* _data_;
	DejaDupBackendRackspace* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	GMountOperation* _tmp2_ = NULL;
	GMountOperationResult _tmp3_ = 0;
	_data_ = g_slice_new0 (DejaDupBackendRackspaceGotPasswordReplyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_rackspace_got_password_reply);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_rackspace_got_password_reply_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = mount_op;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->mount_op);
	_data_->mount_op = _tmp2_;
	_tmp3_ = _result_;
	_data_->_result_ = _tmp3_;
	deja_dup_backend_rackspace_got_password_reply_co (_data_);
}


static void deja_dup_backend_rackspace_got_password_reply_finish (DejaDupBackendRackspace* self, GAsyncResult* _res_) {
	DejaDupBackendRackspaceGotPasswordReplyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void deja_dup_backend_rackspace_got_password_reply_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupBackendRackspaceGotPasswordReplyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_rackspace_got_password_reply_co (_data_);
}


static gboolean deja_dup_backend_rackspace_got_password_reply_co (DejaDupBackendRackspaceGotPasswordReplyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp0_ = _data_->_result_;
	if (_data_->_tmp0_ != G_MOUNT_OPERATION_HANDLED) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = NULL;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _ ("Permission denied");
		g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "envp-ready", FALSE, _data_->_tmp1_, _data_->_tmp2_);
		__g_list_free__g_free0_0 (_data_->_tmp1_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->mount_op;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_mount_operation_get_username (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
	_g_free0 (_data_->self->priv->id);
	_data_->self->priv->id = _data_->_tmp6_;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->mount_op;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_mount_operation_get_password (_data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_g_free0 (_data_->self->priv->secret_key);
	_data_->self->priv->secret_key = _data_->_tmp10_;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->mount_op;
	_data_->_tmp12_ = 0;
	_data_->_tmp12_ = g_mount_operation_get_password_save (_data_->_tmp11_);
	_data_->_tmp13_ = 0;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->remember = _data_->_tmp13_;
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = _data_->remember;
	if (_data_->_tmp14_ != G_PASSWORD_SAVE_NEVER) {
		_data_->_tmp16_ = 0;
		_data_->_tmp16_ = _data_->remember;
		if (_data_->_tmp16_ == G_PASSWORD_SAVE_FOR_SESSION) {
			_data_->_tmp15_ = SECRET_COLLECTION_SESSION;
		} else {
			_data_->_tmp15_ = SECRET_COLLECTION_DEFAULT;
		}
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp15_);
		_data_->where = _data_->_tmp17_;
		{
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = SECRET_SCHEMA_COMPAT_NETWORK;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->where;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->self->priv->id;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_strdup_printf ("%s@%s", _data_->_tmp20_, DEJA_DUP_RACKSPACE_SERVER);
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = _data_->self->priv->secret_key;
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _data_->self->priv->id;
			_data_->_state_ = 1;
			secret_password_store (_data_->_tmp18_, _data_->_tmp19_, _data_->_tmp22_, _data_->_tmp23_, NULL, deja_dup_backend_rackspace_got_password_reply_ready, _data_, "user", _data_->_tmp24_, "server", DEJA_DUP_RACKSPACE_SERVER, "protocol", "https", NULL);
			return FALSE;
			_state_1:
			secret_password_store_finish (_data_->_res_, &_data_->_inner_error_);
			_g_free0 (_data_->_tmp22_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch18_g_error;
			}
		}
		goto __finally18;
		__catch18_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = _data_->e;
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_tmp25_->message;
			g_warning ("BackendRackspace.vala:138: %s\n", _data_->_tmp26_);
			_g_error_free0 (_data_->e);
		}
		__finally18:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->where);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_free0 (_data_->where);
	}
	deja_dup_backend_rackspace_got_secret_key (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _deja_dup_backend_rackspace_got_password_reply_g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	deja_dup_backend_rackspace_got_password_reply ((DejaDupBackendRackspace*) self, _sender, _result_, NULL, NULL);
}


static void deja_dup_backend_rackspace_ask_password (DejaDupBackendRackspace* self) {
	GMountOperation* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GMountOperation* _tmp5_ = NULL;
	GMountOperation* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GMountOperation* _tmp8_ = NULL;
	GMountOperation* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GMountOperation* _tmp11_ = NULL;
	GMountOperation* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	GMountOperation* _tmp14_ = NULL;
	GMountOperation* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GMountOperation* _tmp17_ = NULL;
	GMountOperation* _tmp18_ = NULL;
	GMountOperation* _tmp19_ = NULL;
	GMountOperation* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _ ("You can sign up for a Rackspace Cloud Files account <a href=\"%s\">onl" \
"ine</a>.");
	_tmp3_ = g_strdup_printf (_tmp2_, "https://signup.rackspacecloud.com/signup");
	_tmp4_ = _tmp3_;
	g_object_set ((GObject*) _tmp1_, "label_help", _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_tmp5_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _ ("Connect to Rackspace Cloud Files");
	g_object_set ((GObject*) _tmp6_, "label_title", _tmp7_, NULL);
	_tmp8_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _ ("_API access key");
	g_object_set ((GObject*) _tmp9_, "label_password", _tmp10_, NULL);
	_tmp11_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _ ("S_how API access key");
	g_object_set ((GObject*) _tmp12_, "label_show_password", _tmp13_, NULL);
	_tmp14_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = _ ("_Remember API access key");
	g_object_set ((GObject*) _tmp15_, "label_remember_password", _tmp16_, NULL);
	_tmp17_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp18_ = _tmp17_;
	g_signal_connect_object (_tmp18_, "reply", (GCallback) _deja_dup_backend_rackspace_got_password_reply_g_mount_operation_reply, self, 0);
	_tmp19_ = deja_dup_backend_get_mount_op ((DejaDupBackend*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->id;
	g_signal_emit_by_name (_tmp20_, "ask-password", "", _tmp21_, "", (G_ASK_PASSWORD_NEED_PASSWORD | G_ASK_PASSWORD_NEED_USERNAME) | G_ASK_PASSWORD_SAVING_SUPPORTED);
}


static void deja_dup_backend_rackspace_got_secret_key (DejaDupBackendRackspace* self) {
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GList* envp = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_get_settings (DEJA_DUP_RACKSPACE_ROOT);
	settings = _tmp0_;
	_tmp1_ = self->priv->id;
	_tmp2_ = self->priv->settings_id;
	if (g_strcmp0 (_tmp1_, _tmp2_) != 0) {
		DejaDupFilteredSettings* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = settings;
		_tmp4_ = self->priv->id;
		deja_dup_filtered_settings_set_string (_tmp3_, DEJA_DUP_RACKSPACE_USERNAME_KEY, _tmp4_);
	}
	envp = NULL;
	_tmp5_ = self->priv->id;
	_tmp6_ = g_strdup_printf ("CLOUDFILES_USERNAME=%s", _tmp5_);
	envp = g_list_append (envp, _tmp6_);
	_tmp7_ = self->priv->secret_key;
	_tmp8_ = g_strdup_printf ("CLOUDFILES_APIKEY=%s", _tmp7_);
	envp = g_list_append (envp, _tmp8_);
	g_signal_emit_by_name ((DejaDupBackend*) self, "envp-ready", TRUE, envp, NULL);
	__g_list_free__g_free0_0 (envp);
	_g_object_unref0 (settings);
}


DejaDupBackendRackspace* deja_dup_backend_rackspace_construct (GType object_type) {
	DejaDupBackendRackspace * self = NULL;
	self = (DejaDupBackendRackspace*) deja_dup_backend_construct (object_type);
	return self;
}


DejaDupBackendRackspace* deja_dup_backend_rackspace_new (void) {
	return deja_dup_backend_rackspace_construct (DEJA_DUP_TYPE_BACKEND_RACKSPACE);
}


static void deja_dup_backend_rackspace_class_init (DejaDupBackendRackspaceClass * klass) {
	deja_dup_backend_rackspace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendRackspacePrivate));
	((DejaDupBackendClass *) klass)->clone = deja_dup_backend_rackspace_real_clone;
	((DejaDupBackendClass *) klass)->is_native = deja_dup_backend_rackspace_real_is_native;
	((DejaDupBackendClass *) klass)->get_icon = deja_dup_backend_rackspace_real_get_icon;
	((DejaDupBackendClass *) klass)->is_ready = deja_dup_backend_rackspace_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = deja_dup_backend_rackspace_real_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_location = deja_dup_backend_rackspace_real_get_location;
	((DejaDupBackendClass *) klass)->get_location_pretty = deja_dup_backend_rackspace_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->get_envp = deja_dup_backend_rackspace_real_get_envp;
	((DejaDupBackendClass *) klass)->get_envp_finish = deja_dup_backend_rackspace_real_get_envp_finish;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_rackspace_finalize;
}


static void deja_dup_backend_rackspace_instance_init (DejaDupBackendRackspace * self) {
	self->priv = DEJA_DUP_BACKEND_RACKSPACE_GET_PRIVATE (self);
}


static void deja_dup_backend_rackspace_finalize (GObject* obj) {
	DejaDupBackendRackspace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspace);
	_g_free0 (self->priv->settings_id);
	_g_free0 (self->priv->id);
	_g_free0 (self->priv->secret_key);
	G_OBJECT_CLASS (deja_dup_backend_rackspace_parent_class)->finalize (obj);
}


GType deja_dup_backend_rackspace_get_type (void) {
	static volatile gsize deja_dup_backend_rackspace_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_rackspace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendRackspaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_rackspace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendRackspace), 0, (GInstanceInitFunc) deja_dup_backend_rackspace_instance_init, NULL };
		GType deja_dup_backend_rackspace_type_id;
		deja_dup_backend_rackspace_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendRackspace", &g_define_type_info, 0);
		g_once_init_leave (&deja_dup_backend_rackspace_type_id__volatile, deja_dup_backend_rackspace_type_id);
	}
	return deja_dup_backend_rackspace_type_id__volatile;
}



