/* CommonUtils.c generated by valac 0.30.2, the Vala compiler
 * generated from CommonUtils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <sys/utsname.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <libpeas/peas.h>
#include <locale.h>
#include "uriutils.h"
#include <libsecret/secret.h>


#define DEJA_DUP_TYPE_TIMESTAMP_TYPE (deja_dup_timestamp_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define DEJA_DUP_TYPE_TOOL_PLUGIN (deja_dup_tool_plugin_get_type ())
#define DEJA_DUP_TOOL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_TOOL_PLUGIN, DejaDupToolPlugin))
#define DEJA_DUP_TOOL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_TOOL_PLUGIN, DejaDupToolPluginClass))
#define DEJA_DUP_IS_TOOL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_TOOL_PLUGIN))
#define DEJA_DUP_IS_TOOL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_TOOL_PLUGIN))
#define DEJA_DUP_TOOL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_TOOL_PLUGIN, DejaDupToolPluginClass))

typedef struct _DejaDupToolPlugin DejaDupToolPlugin;
typedef struct _DejaDupToolPluginClass DejaDupToolPluginClass;
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))

#define DEJA_DUP_TYPE_TOOL_JOB (deja_dup_tool_job_get_type ())
#define DEJA_DUP_TOOL_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_TOOL_JOB, DejaDupToolJob))
#define DEJA_DUP_TOOL_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_TOOL_JOB, DejaDupToolJobClass))
#define DEJA_DUP_IS_TOOL_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_TOOL_JOB))
#define DEJA_DUP_IS_TOOL_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_TOOL_JOB))
#define DEJA_DUP_TOOL_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_TOOL_JOB, DejaDupToolJobClass))

typedef struct _DejaDupToolJob DejaDupToolJob;
typedef struct _DejaDupToolJobClass DejaDupToolJobClass;

#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
#define _deja_dup_decoded_uri_free0(var) ((var == NULL) ? NULL : (var = (deja_dup_decoded_uri_free (var), NULL)))
typedef struct _DejaDupGetNicknameData DejaDupGetNicknameData;
typedef struct _DejaDupGetTempdirData DejaDupGetTempdirData;

#define DEJA_DUP_TYPE_RECURSIVE_OP (deja_dup_recursive_op_get_type ())
#define DEJA_DUP_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOp))
#define DEJA_DUP_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))
#define DEJA_DUP_IS_RECURSIVE_OP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_IS_RECURSIVE_OP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_OP))
#define DEJA_DUP_RECURSIVE_OP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_OP, DejaDupRecursiveOpClass))

typedef struct _DejaDupRecursiveOp DejaDupRecursiveOp;
typedef struct _DejaDupRecursiveOpClass DejaDupRecursiveOpClass;

#define DEJA_DUP_TYPE_RECURSIVE_DELETE (deja_dup_recursive_delete_get_type ())
#define DEJA_DUP_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDelete))
#define DEJA_DUP_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))
#define DEJA_DUP_IS_RECURSIVE_DELETE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_IS_RECURSIVE_DELETE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_RECURSIVE_DELETE))
#define DEJA_DUP_RECURSIVE_DELETE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_RECURSIVE_DELETE, DejaDupRecursiveDeleteClass))

typedef struct _DejaDupRecursiveDelete DejaDupRecursiveDelete;
typedef struct _DejaDupRecursiveDeleteClass DejaDupRecursiveDeleteClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _DejaDupCleanTempdirsData DejaDupCleanTempdirsData;

typedef enum  {
	DEJA_DUP_BACKUP_ERROR_BAD_CONFIG,
	DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING
} DejaDupBackupError;
#define DEJA_DUP_BACKUP_ERROR deja_dup_backup_error_quark ()
typedef enum  {
	DEJA_DUP_TIMESTAMP_TYPE_NONE,
	DEJA_DUP_TIMESTAMP_TYPE_BACKUP,
	DEJA_DUP_TIMESTAMP_TYPE_RESTORE
} DejaDupTimestampType;

struct _DejaDupGetNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* f;
	gchar* result;
	gchar* s;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	GFileInfo* info;
	GFile* _tmp3_;
	GFileInfo* _tmp4_;
	const gchar* _tmp5_;
	GFileInfo* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	GError * _inner_error_;
};

struct _DejaDupGetTempdirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* result;
	gchar** tempdirs;
	gint _tmp0_;
	gchar** _tmp1_;
	gint tempdirs_length1;
	gint _tempdirs_size_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp2_;
	GFile** include_list;
	DejaDupFilteredSettings* _tmp3_;
	gint _tmp4_;
	GFile** _tmp5_;
	gint include_list_length1;
	gint _include_list_size_;
	GFile* main_include;
	GFile* home;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile** _tmp8_;
	gint _tmp8__length1;
	GFile** include_collection;
	gint include_collection_length1;
	gint _include_collection_size_;
	gint include_it;
	GFile* _tmp9_;
	GFile* include;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gboolean _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* filesystem_id;
	GFileInfo* info;
	GFile* _tmp22_;
	GFileInfo* _tmp23_;
	GFileInfo* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	GError* e;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gchar** tempdir_collection;
	gint tempdir_collection_length1;
	gint _tempdir_collection_size_;
	gint tempdir_it;
	gchar* _tmp31_;
	gchar* tempdir;
	gchar* temp_id;
	const gchar* _tmp32_;
	GFile* gfile;
	const gchar* _tmp33_;
	GFile* _tmp34_;
	GFileInfo* _vala1_info;
	GFile* _tmp35_;
	GFileInfo* _tmp36_;
	GFileInfo* _tmp37_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	GError* _vala1_e;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	GError * _inner_error_;
};

struct _DejaDupCleanTempdirsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar** tempdirs;
	gint _tmp0_;
	gchar** _tmp1_;
	gint tempdirs_length1;
	gint _tempdirs_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** tempdir_collection;
	gint tempdir_collection_length1;
	gint _tempdir_collection_size_;
	gint tempdir_it;
	gchar* _tmp3_;
	gchar* tempdir;
	GFile* gfile;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFileEnumerator* enumerator;
	GFile* _tmp6_;
	GFileEnumerator* _tmp7_;
	GList* infos;
	GFileEnumerator* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp11_;
	GFileInfo* info;
	GFileInfo* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	GFile* child;
	GFile* _tmp15_;
	GFileInfo* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	GFile* _tmp19_;
	DejaDupRecursiveDelete* _tmp20_;
	DejaDupRecursiveDelete* _tmp21_;
	GList* _tmp22_;
	guint _tmp23_;
	GError* e;
	GError * _inner_error_;
};


extern guint32 deja_dup_machine_id;
guint32 deja_dup_machine_id = (guint32) 0;
extern gboolean deja_dup_settings_read_only;
gboolean deja_dup_settings_read_only = FALSE;
extern GHashTable* deja_dup_settings_table;
GHashTable* deja_dup_settings_table = NULL;
extern DejaDupToolPlugin* deja_dup_tool;
DejaDupToolPlugin* deja_dup_tool = NULL;
extern GFile* deja_dup_home;
GFile* deja_dup_home = NULL;
extern GFile* deja_dup_trash;
GFile* deja_dup_trash = NULL;

glong gethostid (void);
#define DEJA_DUP_INCLUDE_LIST_KEY "include-list"
#define DEJA_DUP_EXCLUDE_LIST_KEY "exclude-list"
#define DEJA_DUP_BACKEND_KEY "backend"
#define DEJA_DUP_ROOT_PROMPT_KEY "root-prompt"
#define DEJA_DUP_LAST_RUN_KEY "last-run"
#define DEJA_DUP_LAST_BACKUP_KEY "last-backup"
#define DEJA_DUP_LAST_RESTORE_KEY "last-restore"
#define DEJA_DUP_PROMPT_CHECK_KEY "prompt-check"
#define DEJA_DUP_NAG_CHECK_KEY "nag-check"
#define DEJA_DUP_PERIODIC_KEY "periodic"
#define DEJA_DUP_PERIODIC_PERIOD_KEY "periodic-period"
#define DEJA_DUP_DELETE_AFTER_KEY "delete-after"
#define DEJA_DUP_FULL_BACKUP_PERIOD_KEY "full-backup-period"
GQuark deja_dup_backup_error_quark (void);
GType deja_dup_timestamp_type_get_type (void) G_GNUC_CONST;
gboolean deja_dup_in_testing_mode (void);
void deja_dup_update_last_run_timestamp (DejaDupTimestampType type);
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
void deja_dup_filtered_settings_set_string (DejaDupFilteredSettings* self, const gchar* k, const gchar* v);
void deja_dup_filtered_settings_apply (DejaDupFilteredSettings* self);
gboolean deja_dup_parse_version (const gchar* version_string, gint* major, gint* minor, gint* micro);
gboolean deja_dup_meets_version (gint major, gint minor, gint micro, gint req_major, gint req_minor, gint req_micro);
gchar* deja_dup_nice_prefix (const gchar* command);
void deja_dup_run_deja_dup (const gchar* args, GAppLaunchContext* ctx, GList* files);
guint32 deja_dup_get_machine_id (void);
GDateTime* deja_dup_most_recent_scheduled_date (GTimeSpan period);
gchar* deja_dup_last_run_date (DejaDupTimestampType type);
GTimeSpan deja_dup_get_day (void);
GDateTime* deja_dup_next_run_date (void);
gint deja_dup_get_prompt_delay (void);
gboolean deja_dup_has_seen_settings (void);
gboolean deja_dup_make_prompt_check (void);
void deja_dup_update_prompt_time (gboolean cancel);
void deja_dup_update_time_key (const gchar* key, gboolean cancel);
void deja_dup_update_nag_time (gboolean cancel);
gint deja_dup_get_nag_delay (void);
gboolean deja_dup_is_nag_time (void);
gchar* deja_dup_get_folder_key (DejaDupFilteredSettings* settings, const gchar* key);
void deja_dup_set_settings_read_only (gboolean ro);
DejaDupFilteredSettings* deja_dup_filtered_settings_new (const gchar* schema, gboolean ro);
DejaDupFilteredSettings* deja_dup_filtered_settings_construct (GType object_type, const gchar* schema, gboolean ro);
GType deja_dup_tool_plugin_get_type (void) G_GNUC_CONST;
void deja_dup_initialize_tool_plugin (GError** error);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
void deja_dup_tool_plugin_activate (DejaDupToolPlugin* self);
GType deja_dup_tool_job_get_type (void) G_GNUC_CONST;
DejaDupToolJob* deja_dup_make_tool_job (GError** error);
DejaDupToolJob* deja_dup_tool_plugin_create_job (DejaDupToolPlugin* self, GError** error);
gboolean deja_dup_initialize (gchar** header, gchar** msg);
GType deja_dup_backend_get_type (void) G_GNUC_CONST;
DejaDupBackend* deja_dup_backend_get_default (void);
void deja_dup_clean_tempdirs (GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_clean_tempdirs_finish (GAsyncResult* _res_);
void deja_dup_i18n_setup (void);
gchar* deja_dup_get_file_desc (GFile* file);
void deja_dup_ensure_special_paths (void);
gchar* deja_dup_get_trash_path (void);
gchar* deja_dup_get_display_name (GFile* f);
static void deja_dup_get_nickname_data_free (gpointer _data);
void deja_dup_get_nickname (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* deja_dup_get_nickname_finish (GAsyncResult* _res_);
static gboolean deja_dup_get_nickname_co (DejaDupGetNicknameData* _data_);
static void deja_dup_get_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint deja_dup_get_full_backup_threshold (void);
void deja_dup_get_full_backup_threshold_date (GDate* result);
SecretSchema* deja_dup_get_passphrase_schema (void);
gboolean deja_dup_ensure_directory_exists (const gchar* path);
static void deja_dup_get_tempdir_data_free (gpointer _data);
void deja_dup_get_tempdir (GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* deja_dup_get_tempdir_finish (GAsyncResult* _res_);
static gboolean deja_dup_get_tempdir_co (DejaDupGetTempdirData* _data_);
gchar** deja_dup_get_tempdirs (int* result_length1);
GFile** deja_dup_filtered_settings_get_file_list (DejaDupFilteredSettings* self, const gchar* k, int* result_length1);
static void deja_dup_get_tempdir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void deja_dup_clean_tempdirs_data_free (gpointer _data);
static gboolean deja_dup_clean_tempdirs_co (DejaDupCleanTempdirsData* _data_);
static void deja_dup_clean_tempdirs_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
DejaDupRecursiveDelete* deja_dup_recursive_delete_new (GFile* source, const gchar* skip);
DejaDupRecursiveDelete* deja_dup_recursive_delete_construct (GType object_type, GFile* source, const gchar* skip);
GType deja_dup_recursive_op_get_type (void) G_GNUC_CONST;
GType deja_dup_recursive_delete_get_type (void) G_GNUC_CONST;
void deja_dup_recursive_op_start_async (DejaDupRecursiveOp* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_recursive_op_start_finish (DejaDupRecursiveOp* self, GAsyncResult* _res_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark deja_dup_backup_error_quark (void) {
	return g_quark_from_static_string ("deja_dup_backup_error-quark");
}


GType deja_dup_timestamp_type_get_type (void) {
	static volatile gsize deja_dup_timestamp_type_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_timestamp_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DEJA_DUP_TIMESTAMP_TYPE_NONE, "DEJA_DUP_TIMESTAMP_TYPE_NONE", "none"}, {DEJA_DUP_TIMESTAMP_TYPE_BACKUP, "DEJA_DUP_TIMESTAMP_TYPE_BACKUP", "backup"}, {DEJA_DUP_TIMESTAMP_TYPE_RESTORE, "DEJA_DUP_TIMESTAMP_TYPE_RESTORE", "restore"}, {0, NULL, NULL}};
		GType deja_dup_timestamp_type_type_id;
		deja_dup_timestamp_type_type_id = g_enum_register_static ("DejaDupTimestampType", values);
		g_once_init_leave (&deja_dup_timestamp_type_type_id__volatile, deja_dup_timestamp_type_type_id);
	}
	return deja_dup_timestamp_type_type_id__volatile;
}


gboolean deja_dup_in_testing_mode (void) {
	gboolean result = FALSE;
	gchar* testing_str = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = testing_str;
		_tmp5_ = atoi (_tmp4_);
		_tmp2_ = _tmp5_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (testing_str);
	return result;
}


void deja_dup_update_last_run_timestamp (DejaDupTimestampType type) {
	GTimeVal cur_time = {0};
	gchar* cur_time_str = NULL;
	gchar* _tmp0_ = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	DejaDupFilteredSettings* _tmp2_ = NULL;
	DejaDupFilteredSettings* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	DejaDupTimestampType _tmp5_ = 0;
	DejaDupFilteredSettings* _tmp11_ = NULL;
	g_get_current_time (&cur_time);
	g_get_current_time (&cur_time);
	_tmp0_ = g_time_val_to_iso8601 (&cur_time);
	cur_time_str = _tmp0_;
	_tmp1_ = deja_dup_get_settings (NULL);
	settings = _tmp1_;
	_tmp2_ = settings;
	g_settings_delay ((GSettings*) _tmp2_);
	_tmp3_ = settings;
	_tmp4_ = cur_time_str;
	deja_dup_filtered_settings_set_string (_tmp3_, DEJA_DUP_LAST_RUN_KEY, _tmp4_);
	_tmp5_ = type;
	if (_tmp5_ == DEJA_DUP_TIMESTAMP_TYPE_BACKUP) {
		DejaDupFilteredSettings* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp6_ = settings;
		_tmp7_ = cur_time_str;
		deja_dup_filtered_settings_set_string (_tmp6_, DEJA_DUP_LAST_BACKUP_KEY, _tmp7_);
	} else {
		DejaDupTimestampType _tmp8_ = 0;
		_tmp8_ = type;
		if (_tmp8_ == DEJA_DUP_TIMESTAMP_TYPE_RESTORE) {
			DejaDupFilteredSettings* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			_tmp9_ = settings;
			_tmp10_ = cur_time_str;
			deja_dup_filtered_settings_set_string (_tmp9_, DEJA_DUP_LAST_RESTORE_KEY, _tmp10_);
		}
	}
	_tmp11_ = settings;
	deja_dup_filtered_settings_apply (_tmp11_);
	_g_object_unref0 (settings);
	_g_free0 (cur_time_str);
}


gboolean deja_dup_parse_version (const gchar* version_string, gint* major, gint* minor, gint* micro) {
	gint _vala_major = 0;
	gint _vala_minor = 0;
	gint _vala_micro = 0;
	gboolean result = FALSE;
	gchar** ver_tokens = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint ver_tokens_length1 = 0;
	gint _ver_tokens_size_ = 0;
	gboolean _tmp3_ = FALSE;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	g_return_val_if_fail (version_string != NULL, FALSE);
	_vala_major = 0;
	_vala_minor = 0;
	_vala_micro = 0;
	_tmp0_ = version_string;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	ver_tokens = _tmp2_;
	ver_tokens_length1 = _vala_array_length (_tmp1_);
	_ver_tokens_size_ = ver_tokens_length1;
	_tmp4_ = ver_tokens;
	_tmp4__length1 = ver_tokens_length1;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = ver_tokens;
		_tmp5__length1 = ver_tokens_length1;
		_tmp6_ = _tmp5_[0];
		_tmp3_ = _tmp6_ == NULL;
	}
	if (_tmp3_) {
		result = FALSE;
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		if (major) {
			*major = _vala_major;
		}
		if (minor) {
			*minor = _vala_minor;
		}
		if (micro) {
			*micro = _vala_micro;
		}
		return result;
	}
	_tmp7_ = ver_tokens;
	_tmp7__length1 = ver_tokens_length1;
	_tmp8_ = _tmp7_[0];
	_tmp9_ = atoi (_tmp8_);
	_vala_major = _tmp9_;
	_tmp10_ = ver_tokens;
	_tmp10__length1 = ver_tokens_length1;
	_tmp11_ = _tmp10_[1];
	if (_tmp11_ != NULL) {
		gchar** _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		const gchar* _tmp16_ = NULL;
		_tmp12_ = ver_tokens;
		_tmp12__length1 = ver_tokens_length1;
		_tmp13_ = _tmp12_[1];
		_tmp14_ = atoi (_tmp13_);
		_vala_minor = _tmp14_;
		_tmp15_ = ver_tokens;
		_tmp15__length1 = ver_tokens_length1;
		_tmp16_ = _tmp15_[2];
		if (_tmp16_ != NULL) {
			gchar** _tmp17_ = NULL;
			gint _tmp17__length1 = 0;
			const gchar* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			_tmp17_ = ver_tokens;
			_tmp17__length1 = ver_tokens_length1;
			_tmp18_ = _tmp17_[2];
			_tmp19_ = atoi (_tmp18_);
			_vala_micro = _tmp19_;
		}
	}
	result = TRUE;
	ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
	if (major) {
		*major = _vala_major;
	}
	if (minor) {
		*minor = _vala_minor;
	}
	if (micro) {
		*micro = _vala_micro;
	}
	return result;
}


gboolean deja_dup_meets_version (gint major, gint minor, gint micro, gint req_major, gint req_minor, gint req_micro) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	_tmp2_ = major;
	_tmp3_ = req_major;
	if (_tmp2_ > _tmp3_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp5_ = major;
		_tmp6_ = req_major;
		if (_tmp5_ == _tmp6_) {
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			_tmp7_ = minor;
			_tmp8_ = req_minor;
			_tmp4_ = _tmp7_ > _tmp8_;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp1_ = _tmp4_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		_tmp11_ = major;
		_tmp12_ = req_major;
		if (_tmp11_ == _tmp12_) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp13_ = minor;
			_tmp14_ = req_minor;
			_tmp10_ = _tmp13_ == _tmp14_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			_tmp15_ = micro;
			_tmp16_ = req_micro;
			_tmp9_ = _tmp15_ >= _tmp16_;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp0_ = _tmp9_;
	}
	result = _tmp0_;
	return result;
}


gchar* deja_dup_nice_prefix (const gchar* command) {
	gchar* result = NULL;
	gchar* cmd = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint major = 0;
	gint minor = 0;
	gint micro = 0;
	struct utsname utsname = {0};
	struct utsname _tmp2_ = {0};
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	struct utsname _tmp23_ = {0};
	const gchar* _tmp24_ = NULL;
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = command;
	_tmp1_ = g_strdup (_tmp0_);
	cmd = _tmp1_;
	uname (&utsname);
	_tmp2_ = utsname;
	_tmp3_ = _tmp2_.release;
	deja_dup_parse_version (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	major = _tmp4_;
	minor = _tmp5_;
	micro = _tmp6_;
	_tmp7_ = g_find_program_in_path ("ionice");
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ != NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		struct utsname _tmp11_ = {0};
		const gchar* _tmp12_ = NULL;
		_tmp11_ = utsname;
		_tmp12_ = _tmp11_.sysname;
		if (g_strcmp0 (_tmp12_, "Linux") == 0) {
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
			gboolean _tmp16_ = FALSE;
			_tmp13_ = major;
			_tmp14_ = minor;
			_tmp15_ = micro;
			_tmp16_ = deja_dup_meets_version (_tmp13_, _tmp14_, _tmp15_, 2, 6, 25);
			_tmp10_ = _tmp16_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			_tmp17_ = cmd;
			_tmp18_ = g_strconcat ("ionice -c3 ", _tmp17_, NULL);
			_g_free0 (cmd);
			cmd = _tmp18_;
		} else {
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			_tmp19_ = cmd;
			_tmp20_ = g_strconcat ("ionice -c2 -n7 ", _tmp19_, NULL);
			_g_free0 (cmd);
			cmd = _tmp20_;
		}
	}
	_tmp23_ = utsname;
	_tmp24_ = _tmp23_.sysname;
	if (g_strcmp0 (_tmp24_, "Linux") == 0) {
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gboolean _tmp28_ = FALSE;
		_tmp25_ = major;
		_tmp26_ = minor;
		_tmp27_ = micro;
		_tmp28_ = deja_dup_meets_version (_tmp25_, _tmp26_, _tmp27_, 2, 6, 23);
		_tmp22_ = _tmp28_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		_tmp29_ = g_find_program_in_path ("chrt");
		_tmp30_ = _tmp29_;
		_tmp21_ = _tmp30_ != NULL;
		_g_free0 (_tmp30_);
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp31_ = cmd;
		_tmp32_ = g_strconcat ("chrt --idle 0 ", _tmp31_, NULL);
		_g_free0 (cmd);
		cmd = _tmp32_;
	} else {
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		_tmp33_ = g_find_program_in_path ("nice");
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_ != NULL;
		_g_free0 (_tmp34_);
		if (_tmp35_) {
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp36_ = cmd;
			_tmp37_ = g_strconcat ("nice -n19 ", _tmp36_, NULL);
			_g_free0 (cmd);
			cmd = _tmp37_;
		}
	}
	result = cmd;
	return result;
}


void deja_dup_run_deja_dup (const gchar* args, GAppLaunchContext* ctx, GList* files) {
	gchar* cmd = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GAppInfoCreateFlags flags = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (args != NULL);
	_tmp0_ = args;
	_tmp1_ = g_strdup_printf ("deja-dup %s", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = deja_dup_nice_prefix (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	cmd = _tmp4_;
	flags = G_APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION | G_APP_INFO_CREATE_SUPPORTS_URIS;
	{
		GAppInfo* app = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GAppInfoCreateFlags _tmp7_ = 0;
		GAppInfo* _tmp8_ = NULL;
		GAppInfo* _tmp9_ = NULL;
		GList* _tmp10_ = NULL;
		GAppLaunchContext* _tmp11_ = NULL;
		_tmp5_ = cmd;
		_tmp6_ = _ ("Déjà Dup Backup Tool");
		_tmp7_ = flags;
		_tmp8_ = g_app_info_create_from_commandline (_tmp5_, _tmp6_, _tmp7_, &_inner_error_);
		app = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
		_tmp9_ = app;
		_tmp10_ = files;
		_tmp11_ = ctx;
		g_app_info_launch (_tmp9_, _tmp10_, _tmp11_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (app);
			goto __catch21_g_error;
		}
		_g_object_unref0 (app);
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("CommonUtils.vala:142: %s\n", _tmp13_);
		_g_error_free0 (e);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (cmd);
}


guint32 deja_dup_get_machine_id (void) {
	guint32 result = 0U;
	guint32 _tmp0_ = 0U;
	gchar* machine_string = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp5_ = NULL;
	guint32 _tmp8_ = 0U;
	guint32 _tmp10_ = 0U;
	GError * _inner_error_ = NULL;
	_tmp0_ = deja_dup_machine_id;
	if (_tmp0_ > ((guint32) 0)) {
		guint32 _tmp1_ = 0U;
		_tmp1_ = deja_dup_machine_id;
		result = _tmp1_;
		return result;
	}
	{
		gchar* _tmp2_ = NULL;
		g_file_get_contents ("/etc/machine-id", &_tmp2_, NULL, &_inner_error_);
		_g_free0 (machine_string);
		machine_string = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (machine_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	_tmp3_ = machine_string;
	if (_tmp3_ == NULL) {
		{
			gchar* _tmp4_ = NULL;
			g_file_get_contents ("/var/lib/dbus/machine-id", &_tmp4_, NULL, &_inner_error_);
			_g_free0 (machine_string);
			machine_string = _tmp4_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch23_g_error;
			}
		}
		goto __finally23;
		__catch23_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally23:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (machine_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0U;
		}
	}
	_tmp5_ = machine_string;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_ = NULL;
		gulong _tmp7_ = 0UL;
		_tmp6_ = machine_string;
		_tmp7_ = strtoul (_tmp6_, NULL, 16);
		deja_dup_machine_id = (guint32) _tmp7_;
	}
	_tmp8_ = deja_dup_machine_id;
	if (_tmp8_ == ((guint32) 0)) {
		glong _tmp9_ = 0L;
		_tmp9_ = gethostid ();
		deja_dup_machine_id = (guint32) _tmp9_;
	}
	_tmp10_ = deja_dup_machine_id;
	result = _tmp10_;
	_g_free0 (machine_string);
	return result;
}


GDateTime* deja_dup_most_recent_scheduled_date (GTimeSpan period) {
	GDateTime* result = NULL;
	GDateTime* epoch = NULL;
	GDateTime* _tmp0_ = NULL;
	GRand* rand = NULL;
	guint32 _tmp1_ = 0U;
	GRand* _tmp2_ = NULL;
	GTimeSpan early_hour = 0LL;
	gdouble _tmp3_ = 0.0;
	GDateTime* _tmp4_ = NULL;
	GDateTime* _tmp5_ = NULL;
	GTimeSpan _tmp6_ = 0LL;
	GDateTime* _tmp7_ = NULL;
	GDateTime* cur_date = NULL;
	GDateTime* _tmp8_ = NULL;
	GTimeSpan between = 0LL;
	GDateTime* _tmp9_ = NULL;
	GTimeSpan _tmp10_ = 0LL;
	GTimeSpan mod = 0LL;
	GTimeSpan _tmp11_ = 0LL;
	GDateTime* _tmp12_ = NULL;
	_tmp0_ = g_date_time_new_from_unix_local ((gint64) 0);
	epoch = _tmp0_;
	_tmp1_ = deja_dup_get_machine_id ();
	_tmp2_ = g_rand_new_with_seed (_tmp1_);
	rand = _tmp2_;
	_tmp3_ = g_rand_double_range (rand, (gdouble) 2, (gdouble) 4);
	early_hour = (GTimeSpan) (_tmp3_ * G_TIME_SPAN_HOUR);
	_tmp4_ = epoch;
	_tmp5_ = epoch;
	_tmp6_ = g_date_time_get_utc_offset (_tmp5_);
	_tmp7_ = g_date_time_add (_tmp4_, early_hour - _tmp6_);
	_g_date_time_unref0 (epoch);
	epoch = _tmp7_;
	_tmp8_ = g_date_time_new_now_local ();
	cur_date = _tmp8_;
	_tmp9_ = epoch;
	_tmp10_ = g_date_time_difference (cur_date, _tmp9_);
	between = _tmp10_;
	_tmp11_ = period;
	mod = between % _tmp11_;
	_tmp12_ = g_date_time_add (cur_date, -1 * mod);
	result = _tmp12_;
	_g_date_time_unref0 (cur_date);
	_g_rand_free0 (rand);
	_g_date_time_unref0 (epoch);
	return result;
}


gchar* deja_dup_last_run_date (DejaDupTimestampType type) {
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* last_run_string = NULL;
	DejaDupTimestampType _tmp1_ = 0;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	last_run_string = NULL;
	_tmp1_ = type;
	if (_tmp1_ == DEJA_DUP_TIMESTAMP_TYPE_BACKUP) {
		DejaDupFilteredSettings* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = settings;
		_tmp3_ = g_settings_get_string ((GSettings*) _tmp2_, DEJA_DUP_LAST_BACKUP_KEY);
		_g_free0 (last_run_string);
		last_run_string = _tmp3_;
	} else {
		DejaDupTimestampType _tmp4_ = 0;
		_tmp4_ = type;
		if (_tmp4_ == DEJA_DUP_TIMESTAMP_TYPE_RESTORE) {
			DejaDupFilteredSettings* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp5_ = settings;
			_tmp6_ = g_settings_get_string ((GSettings*) _tmp5_, DEJA_DUP_LAST_RESTORE_KEY);
			_g_free0 (last_run_string);
			last_run_string = _tmp6_;
		}
	}
	_tmp8_ = last_run_string;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		_tmp9_ = last_run_string;
		_tmp7_ = g_strcmp0 (_tmp9_, "") == 0;
	}
	if (_tmp7_) {
		DejaDupFilteredSettings* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp10_ = settings;
		_tmp11_ = g_settings_get_string ((GSettings*) _tmp10_, DEJA_DUP_LAST_RUN_KEY);
		_g_free0 (last_run_string);
		last_run_string = _tmp11_;
	}
	result = last_run_string;
	_g_object_unref0 (settings);
	return result;
}


GTimeSpan deja_dup_get_day (void) {
	GTimeSpan result = 0LL;
	gboolean _tmp0_ = FALSE;
	_tmp0_ = deja_dup_in_testing_mode ();
	if (_tmp0_) {
		result = G_TIME_SPAN_SECOND * ((GTimeSpan) 10);
		return result;
	} else {
		result = G_TIME_SPAN_DAY;
		return result;
	}
}


GDateTime* deja_dup_next_run_date (void) {
	GDateTime* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gboolean periodic = FALSE;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint period_days = 0;
	DejaDupFilteredSettings* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gchar* last_run_string = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gint _tmp9_ = 0;
	GTimeVal last_run_tval = {0};
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GTimeSpan period = 0LL;
	gint _tmp13_ = 0;
	GTimeSpan _tmp14_ = 0LL;
	GDateTime* last_run = NULL;
	GTimeVal _tmp15_ = {0};
	GDateTime* _tmp16_ = NULL;
	GDateTime* last_scheduled = NULL;
	GTimeSpan _tmp17_ = 0LL;
	GDateTime* _tmp18_ = NULL;
	GDateTime* _tmp19_ = NULL;
	GDateTime* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_boolean ((GSettings*) _tmp1_, DEJA_DUP_PERIODIC_KEY);
	periodic = _tmp2_;
	_tmp3_ = settings;
	_tmp4_ = g_settings_get_int ((GSettings*) _tmp3_, DEJA_DUP_PERIODIC_PERIOD_KEY);
	period_days = _tmp4_;
	_tmp5_ = deja_dup_last_run_date (DEJA_DUP_TIMESTAMP_TYPE_BACKUP);
	last_run_string = _tmp5_;
	_tmp6_ = periodic;
	if (!_tmp6_) {
		result = NULL;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp7_ = last_run_string;
	if (g_strcmp0 (_tmp7_, "") == 0) {
		GDateTime* _tmp8_ = NULL;
		_tmp8_ = g_date_time_new_now_local ();
		result = _tmp8_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp9_ = period_days;
	if (_tmp9_ <= 0) {
		period_days = 1;
	}
	g_get_current_time (&last_run_tval);
	_tmp10_ = last_run_string;
	_tmp11_ = g_time_val_from_iso8601 (_tmp10_, &last_run_tval);
	if (!_tmp11_) {
		GDateTime* _tmp12_ = NULL;
		_tmp12_ = g_date_time_new_now_local ();
		result = _tmp12_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp13_ = period_days;
	_tmp14_ = deja_dup_get_day ();
	period = ((GTimeSpan) _tmp13_) * _tmp14_;
	_tmp15_ = last_run_tval;
	_tmp16_ = g_date_time_new_from_timeval_local (&_tmp15_);
	last_run = _tmp16_;
	_tmp17_ = period;
	_tmp18_ = deja_dup_most_recent_scheduled_date (_tmp17_);
	last_scheduled = _tmp18_;
	_tmp19_ = last_scheduled;
	_tmp20_ = last_run;
	_tmp21_ = g_date_time_compare (_tmp19_, _tmp20_);
	if (_tmp21_ <= 0) {
		GDateTime* _tmp22_ = NULL;
		GTimeSpan _tmp23_ = 0LL;
		GDateTime* _tmp24_ = NULL;
		_tmp22_ = last_scheduled;
		_tmp23_ = period;
		_tmp24_ = g_date_time_add (_tmp22_, _tmp23_);
		_g_date_time_unref0 (last_scheduled);
		last_scheduled = _tmp24_;
	}
	result = last_scheduled;
	_g_date_time_unref0 (last_run);
	_g_free0 (last_run_string);
	_g_object_unref0 (settings);
	return result;
}


gint deja_dup_get_prompt_delay (void) {
	gint result = 0;
	GTimeSpan span = 0LL;
	gboolean _tmp0_ = FALSE;
	GTimeSpan _tmp1_ = 0LL;
	span = (GTimeSpan) 0;
	_tmp0_ = deja_dup_in_testing_mode ();
	if (_tmp0_) {
		span = G_TIME_SPAN_MINUTE * 2;
	} else {
		span = G_TIME_SPAN_DAY * 30;
	}
	_tmp1_ = span;
	result = (gint) (_tmp1_ / G_TIME_SPAN_SECOND);
	return result;
}


gboolean deja_dup_has_seen_settings (void) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = deja_dup_last_run_date (DEJA_DUP_TIMESTAMP_TYPE_NONE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "") != 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}


gboolean deja_dup_make_prompt_check (void) {
	gboolean result = FALSE;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* prompt = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GTimeVal last_run_tval = {0};
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GDateTime* last_run = NULL;
	GTimeVal _tmp8_ = {0};
	GDateTime* _tmp9_ = NULL;
	GDateTime* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GDateTime* _tmp12_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp13_ = NULL;
	GDateTime* _tmp14_ = NULL;
	GDateTime* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_PROMPT_CHECK_KEY);
	prompt = _tmp2_;
	_tmp3_ = prompt;
	if (g_strcmp0 (_tmp3_, "disabled") == 0) {
		result = FALSE;
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = prompt;
		if (g_strcmp0 (_tmp4_, "") == 0) {
			deja_dup_update_prompt_time (FALSE);
			result = FALSE;
			_g_free0 (prompt);
			_g_object_unref0 (settings);
			return result;
		} else {
			gboolean _tmp5_ = FALSE;
			_tmp5_ = deja_dup_has_seen_settings ();
			if (_tmp5_) {
				result = FALSE;
				_g_free0 (prompt);
				_g_object_unref0 (settings);
				return result;
			}
		}
	}
	g_get_current_time (&last_run_tval);
	_tmp6_ = prompt;
	_tmp7_ = g_time_val_from_iso8601 (_tmp6_, &last_run_tval);
	if (!_tmp7_) {
		result = FALSE;
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp8_ = last_run_tval;
	_tmp9_ = g_date_time_new_from_timeval_local (&_tmp8_);
	last_run = _tmp9_;
	_tmp10_ = last_run;
	_tmp11_ = deja_dup_get_prompt_delay ();
	_tmp12_ = g_date_time_add_seconds (_tmp10_, (gdouble) _tmp11_);
	_g_date_time_unref0 (last_run);
	last_run = _tmp12_;
	_tmp13_ = g_date_time_new_now_local ();
	now = _tmp13_;
	_tmp14_ = last_run;
	_tmp15_ = now;
	_tmp16_ = g_date_time_compare (_tmp14_, _tmp15_);
	if (_tmp16_ <= 0) {
		deja_dup_run_deja_dup ("--prompt", NULL, NULL);
		result = TRUE;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (last_run);
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	} else {
		result = FALSE;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (last_run);
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	}
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (last_run);
	_g_free0 (prompt);
	_g_object_unref0 (settings);
}


void deja_dup_update_time_key (const gchar* key, gboolean cancel) {
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gchar* cur_time_str = NULL;
	gboolean _tmp6_ = FALSE;
	DejaDupFilteredSettings* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (key != NULL);
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = key;
	_tmp3_ = g_settings_get_string ((GSettings*) _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp4_, "disabled") == 0;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		_g_object_unref0 (settings);
		return;
	}
	_tmp6_ = cancel;
	if (_tmp6_) {
		gchar* _tmp7_ = NULL;
		_tmp7_ = g_strdup ("disabled");
		_g_free0 (cur_time_str);
		cur_time_str = _tmp7_;
	} else {
		GTimeVal cur_time = {0};
		gchar* _tmp8_ = NULL;
		g_get_current_time (&cur_time);
		g_get_current_time (&cur_time);
		_tmp8_ = g_time_val_to_iso8601 (&cur_time);
		_g_free0 (cur_time_str);
		cur_time_str = _tmp8_;
	}
	_tmp9_ = settings;
	_tmp10_ = key;
	_tmp11_ = cur_time_str;
	deja_dup_filtered_settings_set_string (_tmp9_, _tmp10_, _tmp11_);
	_g_free0 (cur_time_str);
	_g_object_unref0 (settings);
}


void deja_dup_update_prompt_time (gboolean cancel) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = cancel;
	deja_dup_update_time_key (DEJA_DUP_PROMPT_CHECK_KEY, _tmp0_);
}


void deja_dup_update_nag_time (gboolean cancel) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = cancel;
	deja_dup_update_time_key (DEJA_DUP_NAG_CHECK_KEY, _tmp0_);
}


gint deja_dup_get_nag_delay (void) {
	gint result = 0;
	GTimeSpan span = 0LL;
	gboolean _tmp0_ = FALSE;
	GTimeSpan _tmp1_ = 0LL;
	span = (GTimeSpan) 0;
	_tmp0_ = deja_dup_in_testing_mode ();
	if (_tmp0_) {
		span = G_TIME_SPAN_MINUTE * 2;
	} else {
		span = (G_TIME_SPAN_DAY * 30) * 2;
	}
	_tmp1_ = span;
	result = (gint) (_tmp1_ / G_TIME_SPAN_SECOND);
	return result;
}


gboolean deja_dup_is_nag_time (void) {
	gboolean result = FALSE;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* nag = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* last_run_string = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	GTimeVal last_check_tval = {0};
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GDateTime* last_check = NULL;
	GTimeVal _tmp10_ = {0};
	GDateTime* _tmp11_ = NULL;
	GDateTime* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	GDateTime* _tmp14_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp15_ = NULL;
	GDateTime* _tmp16_ = NULL;
	GDateTime* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_NAG_CHECK_KEY);
	nag = _tmp2_;
	_tmp3_ = deja_dup_last_run_date (DEJA_DUP_TIMESTAMP_TYPE_BACKUP);
	last_run_string = _tmp3_;
	_tmp5_ = nag;
	if (g_strcmp0 (_tmp5_, "disabled") == 0) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = last_run_string;
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	if (_tmp4_) {
		result = FALSE;
		_g_free0 (last_run_string);
		_g_free0 (nag);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp7_ = NULL;
		_tmp7_ = nag;
		if (g_strcmp0 (_tmp7_, "") == 0) {
			deja_dup_update_nag_time (FALSE);
			result = FALSE;
			_g_free0 (last_run_string);
			_g_free0 (nag);
			_g_object_unref0 (settings);
			return result;
		}
	}
	g_get_current_time (&last_check_tval);
	_tmp8_ = nag;
	_tmp9_ = g_time_val_from_iso8601 (_tmp8_, &last_check_tval);
	if (!_tmp9_) {
		result = FALSE;
		_g_free0 (last_run_string);
		_g_free0 (nag);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp10_ = last_check_tval;
	_tmp11_ = g_date_time_new_from_timeval_local (&_tmp10_);
	last_check = _tmp11_;
	_tmp12_ = last_check;
	_tmp13_ = deja_dup_get_nag_delay ();
	_tmp14_ = g_date_time_add_seconds (_tmp12_, (gdouble) _tmp13_);
	_g_date_time_unref0 (last_check);
	last_check = _tmp14_;
	_tmp15_ = g_date_time_new_now_local ();
	now = _tmp15_;
	_tmp16_ = last_check;
	_tmp17_ = now;
	_tmp18_ = g_date_time_compare (_tmp16_, _tmp17_);
	result = _tmp18_ <= 0;
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (last_check);
	_g_free0 (last_run_string);
	_g_free0 (nag);
	_g_object_unref0 (settings);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch24_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch24_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally24;
	__catch24_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally24:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


gchar* deja_dup_get_folder_key (DejaDupFilteredSettings* settings, const gchar* key) {
	gchar* result = NULL;
	gchar* folder = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = settings;
	_tmp1_ = key;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp0_, _tmp1_);
	folder = _tmp2_;
	_tmp3_ = folder;
	_tmp4_ = string_contains (_tmp3_, "$HOSTNAME");
	if (_tmp4_) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		DejaDupFilteredSettings* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp5_ = folder;
		_tmp6_ = g_get_host_name ();
		_tmp7_ = string_replace (_tmp5_, "$HOSTNAME", _tmp6_);
		_g_free0 (folder);
		folder = _tmp7_;
		_tmp8_ = settings;
		_tmp9_ = key;
		_tmp10_ = folder;
		deja_dup_filtered_settings_set_string (_tmp8_, _tmp9_, _tmp10_);
	}
	_tmp11_ = folder;
	_tmp12_ = g_str_has_prefix (_tmp11_, "/");
	if (_tmp12_) {
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp13_ = folder;
		_tmp14_ = string_substring (_tmp13_, (glong) 1, (glong) -1);
		_g_free0 (folder);
		folder = _tmp14_;
	}
	result = folder;
	return result;
}


void deja_dup_set_settings_read_only (gboolean ro) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	_tmp0_ = ro;
	deja_dup_settings_read_only = _tmp0_;
	_tmp1_ = deja_dup_settings_read_only;
	if (_tmp1_) {
		GHashFunc _tmp2_ = NULL;
		GEqualFunc _tmp3_ = NULL;
		GDestroyNotify _tmp4_ = NULL;
		GDestroyNotify _tmp5_ = NULL;
		GHashTable* _tmp6_ = NULL;
		_tmp2_ = g_str_hash;
		_tmp3_ = g_str_equal;
		_tmp4_ = g_free;
		_tmp5_ = g_object_unref;
		_tmp6_ = g_hash_table_new_full (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
		_g_hash_table_unref0 (deja_dup_settings_table);
		deja_dup_settings_table = _tmp6_;
	} else {
		_g_hash_table_unref0 (deja_dup_settings_table);
		deja_dup_settings_table = NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir) {
	DejaDupFilteredSettings* result = NULL;
	gchar* schema = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	DejaDupFilteredSettings* rv = NULL;
	gboolean _tmp9_ = FALSE;
	_tmp0_ = g_strdup ("org.gnome.DejaDup");
	schema = _tmp0_;
	_tmp2_ = subdir;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = subdir;
		_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp4_ = schema;
		_tmp5_ = subdir;
		_tmp6_ = g_strconcat (".", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
		_g_free0 (schema);
		schema = _tmp8_;
		_g_free0 (_tmp7_);
	}
	_tmp9_ = deja_dup_settings_read_only;
	if (_tmp9_) {
		GHashTable* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gconstpointer _tmp12_ = NULL;
		DejaDupFilteredSettings* _tmp13_ = NULL;
		DejaDupFilteredSettings* _tmp14_ = NULL;
		_tmp10_ = deja_dup_settings_table;
		_tmp11_ = schema;
		_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
		_tmp13_ = _g_object_ref0 ((DejaDupFilteredSettings*) _tmp12_);
		_g_object_unref0 (rv);
		rv = _tmp13_;
		_tmp14_ = rv;
		if (_tmp14_ == NULL) {
			const gchar* _tmp15_ = NULL;
			DejaDupFilteredSettings* _tmp16_ = NULL;
			DejaDupFilteredSettings* _tmp17_ = NULL;
			GHashTable* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			DejaDupFilteredSettings* _tmp21_ = NULL;
			DejaDupFilteredSettings* _tmp22_ = NULL;
			_tmp15_ = schema;
			_tmp16_ = deja_dup_filtered_settings_new (_tmp15_, TRUE);
			_g_object_unref0 (rv);
			rv = _tmp16_;
			_tmp17_ = rv;
			g_settings_delay ((GSettings*) _tmp17_);
			_tmp18_ = deja_dup_settings_table;
			_tmp19_ = schema;
			_tmp20_ = g_strdup (_tmp19_);
			_tmp21_ = rv;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			g_hash_table_insert (_tmp18_, _tmp20_, _tmp22_);
		}
	} else {
		const gchar* _tmp23_ = NULL;
		DejaDupFilteredSettings* _tmp24_ = NULL;
		_tmp23_ = schema;
		_tmp24_ = deja_dup_filtered_settings_new (_tmp23_, FALSE);
		_g_object_unref0 (rv);
		rv = _tmp24_;
	}
	result = rv;
	_g_free0 (schema);
	return result;
}


static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self) {
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}


static gpointer __vala_PeasPluginInfo_copy0 (gpointer self) {
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}


static void _vala_PeasPluginInfo_free (PeasPluginInfo* self) {
	g_boxed_free (peas_plugin_info_get_type (), self);
}


void deja_dup_initialize_tool_plugin (GError** error) {
	PeasEngine* engine = NULL;
	PeasEngine* _tmp0_ = NULL;
	gchar* search_path = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	PeasEngine* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	PeasPluginInfo* info = NULL;
	PeasEngine* _tmp9_ = NULL;
	PeasPluginInfo* _tmp10_ = NULL;
	PeasPluginInfo* _tmp11_ = NULL;
	PeasPluginInfo* _tmp12_ = NULL;
	PeasEngine* _tmp19_ = NULL;
	PeasPluginInfo* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	PeasExtensionSet* extset = NULL;
	PeasEngine* _tmp24_ = NULL;
	PeasExtensionSet* _tmp25_ = NULL;
	PeasExtension* ext = NULL;
	PeasPluginInfo* _tmp26_ = NULL;
	PeasExtension* _tmp27_ = NULL;
	PeasExtension* _tmp28_ = NULL;
	DejaDupToolPlugin* _tmp29_ = NULL;
	DejaDupToolPlugin* _tmp30_ = NULL;
	DejaDupToolPlugin* _tmp33_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = peas_engine_new ();
	engine = _tmp0_;
	_tmp1_ = g_getenv ("DEJA_DUP_TOOLS_PATH");
	_tmp2_ = g_strdup (_tmp1_);
	search_path = _tmp2_;
	_tmp4_ = search_path;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = search_path;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	if (_tmp3_) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_build_filename (PKG_LIBEXEC_DIR, "tools", NULL);
		_g_free0 (search_path);
		search_path = _tmp6_;
	}
	_tmp7_ = engine;
	_tmp8_ = search_path;
	peas_engine_add_search_path (_tmp7_, _tmp8_, NULL);
	_tmp9_ = engine;
	_tmp10_ = peas_engine_get_plugin_info (_tmp9_, "duplicity");
	_tmp11_ = __vala_PeasPluginInfo_copy0 (_tmp10_);
	info = _tmp11_;
	_tmp12_ = info;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		_tmp13_ = _ ("Could not find backup tool in %s.  Your installation is incomplete.");
		_tmp14_ = search_path;
		_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_inner_error_ = _tmp18_;
		g_propagate_error (error, _inner_error_);
		__vala_PeasPluginInfo_free0 (info);
		_g_free0 (search_path);
		_g_object_unref0 (engine);
		return;
	}
	_tmp19_ = engine;
	_tmp20_ = info;
	_tmp21_ = peas_engine_load_plugin (_tmp19_, _tmp20_);
	if (!_tmp21_) {
		const gchar* _tmp22_ = NULL;
		GError* _tmp23_ = NULL;
		_tmp22_ = _ ("Could not load backup tool.  Your installation is incomplete.");
		_tmp23_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp22_);
		_inner_error_ = _tmp23_;
		g_propagate_error (error, _inner_error_);
		__vala_PeasPluginInfo_free0 (info);
		_g_free0 (search_path);
		_g_object_unref0 (engine);
		return;
	}
	_tmp24_ = engine;
	_tmp25_ = peas_extension_set_new (_tmp24_, peas_activatable_get_type (), NULL);
	extset = _tmp25_;
	_tmp26_ = info;
	_tmp27_ = peas_extension_set_get_extension (extset, _tmp26_);
	_tmp28_ = _g_object_ref0 (_tmp27_);
	ext = _tmp28_;
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (ext, DEJA_DUP_TYPE_TOOL_PLUGIN) ? ((DejaDupToolPlugin*) ext) : NULL);
	_g_object_unref0 (deja_dup_tool);
	deja_dup_tool = _tmp29_;
	_tmp30_ = deja_dup_tool;
	if (_tmp30_ == NULL) {
		const gchar* _tmp31_ = NULL;
		GError* _tmp32_ = NULL;
		_tmp31_ = _ ("Backup tool is broken.  Your installation is incomplete.");
		_tmp32_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp31_);
		_inner_error_ = _tmp32_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ext);
		_g_object_unref0 (extset);
		__vala_PeasPluginInfo_free0 (info);
		_g_free0 (search_path);
		_g_object_unref0 (engine);
		return;
	}
	_tmp33_ = deja_dup_tool;
	deja_dup_tool_plugin_activate (_tmp33_);
	_g_object_unref0 (ext);
	_g_object_unref0 (extset);
	__vala_PeasPluginInfo_free0 (info);
	_g_free0 (search_path);
	_g_object_unref0 (engine);
}


DejaDupToolJob* deja_dup_make_tool_job (GError** error) {
	DejaDupToolJob* result = NULL;
	DejaDupToolPlugin* _tmp0_ = NULL;
	DejaDupToolJob* _tmp1_ = NULL;
	DejaDupToolPlugin* _tmp2_ = NULL;
	DejaDupToolJob* _tmp3_ = NULL;
	DejaDupToolJob* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = deja_dup_tool;
	if (_tmp0_ == NULL) {
		deja_dup_initialize_tool_plugin (&_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	}
	_tmp2_ = deja_dup_tool;
	_tmp3_ = deja_dup_tool_plugin_create_job (_tmp2_, &_inner_error_);
	_tmp1_ = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp4_ = _tmp1_;
	_tmp1_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp1_);
	return result;
}


gboolean deja_dup_initialize (gchar** header, gchar** msg) {
	gchar* _vala_header = NULL;
	gchar* _vala_msg = NULL;
	gboolean result = FALSE;
	DejaDupBackend* unused_backend = NULL;
	DejaDupBackend* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	_g_free0 (_vala_header);
	_vala_header = NULL;
	_g_free0 (_vala_msg);
	_vala_msg = NULL;
	{
		deja_dup_initialize_tool_plugin (&_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Could not start backup tool");
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (_vala_header);
		_vala_header = _tmp1_;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (_vala_msg);
		_vala_msg = _tmp4_;
		result = FALSE;
		_g_error_free0 (e);
		if (header) {
			*header = _vala_header;
		} else {
			_g_free0 (_vala_header);
		}
		if (msg) {
			*msg = _vala_msg;
		} else {
			_g_free0 (_vala_msg);
		}
		return result;
	}
	__finally25:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = deja_dup_backend_get_default ();
	unused_backend = _tmp5_;
	_g_object_unref0 (unused_backend);
	unused_backend = NULL;
	deja_dup_clean_tempdirs (NULL, NULL);
	result = TRUE;
	_g_object_unref0 (unused_backend);
	if (header) {
		*header = _vala_header;
	} else {
		_g_free0 (_vala_header);
	}
	if (msg) {
		*msg = _vala_msg;
	} else {
		_g_free0 (_vala_msg);
	}
	return result;
}


void deja_dup_i18n_setup (void) {
	gchar* localedir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* language = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp12_ = NULL;
	_tmp0_ = g_getenv ("DEJA_DUP_LOCALEDIR");
	_tmp1_ = g_strdup (_tmp0_);
	localedir = _tmp1_;
	_tmp3_ = localedir;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = localedir;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp5_ = NULL;
		_tmp5_ = g_strdup (LOCALE_DIR);
		_g_free0 (localedir);
		localedir = _tmp5_;
	}
	_tmp6_ = g_getenv ("DEJA_DUP_LANGUAGE");
	_tmp7_ = g_strdup (_tmp6_);
	language = _tmp7_;
	_tmp9_ = language;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_ = NULL;
		_tmp10_ = language;
		_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = language;
		g_setenv ("LANGUAGE", _tmp11_, TRUE);
	}
	setlocale (LC_ALL, "");
	textdomain (GETTEXT_PACKAGE);
	_tmp12_ = localedir;
	bindtextdomain (GETTEXT_PACKAGE, _tmp12_);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_g_free0 (language);
	_g_free0 (localedir);
}


gchar* deja_dup_get_file_desc (GFile* file) {
	gchar* result = NULL;
	gchar* desc = NULL;
	GFile* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GFile* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	{
		GFileInfo* info = NULL;
		GFile* _tmp0_ = NULL;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = file;
		_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch26_g_error;
		}
		_tmp2_ = info;
		_tmp3_ = g_file_info_has_attribute (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION);
		if (_tmp3_) {
			GFileInfo* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
			_tmp4_ = info;
			_tmp5_ = g_file_info_get_attribute_string (_tmp4_, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION);
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			_g_object_unref0 (info);
			return result;
		} else {
			GFileInfo* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			_tmp7_ = info;
			_tmp8_ = g_file_info_has_attribute (_tmp7_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME);
			if (_tmp8_) {
				GFileInfo* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				_tmp9_ = info;
				_tmp10_ = g_file_info_get_attribute_string (_tmp9_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME);
				_tmp11_ = g_strdup (_tmp10_);
				result = _tmp11_;
				_g_object_unref0 (info);
				return result;
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally26:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp12_ = file;
	_tmp13_ = g_file_get_parse_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_path_get_basename (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	desc = _tmp16_;
	_tmp17_ = file;
	_tmp18_ = g_file_is_native (_tmp17_);
	if (!_tmp18_) {
		DejaDupDecodedUri* uri = NULL;
		GFile* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		DejaDupDecodedUri* _tmp22_ = NULL;
		DejaDupDecodedUri* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		DejaDupDecodedUri* _tmp26_ = NULL;
		_tmp19_ = file;
		_tmp20_ = g_file_get_uri (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = deja_dup_decoded_uri_decode_uri (_tmp21_);
		_tmp23_ = _tmp22_;
		_g_free0 (_tmp21_);
		uri = _tmp23_;
		_tmp26_ = uri;
		if (_tmp26_ != NULL) {
			DejaDupDecodedUri* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			_tmp27_ = uri;
			_tmp28_ = _tmp27_->host;
			_tmp25_ = _tmp28_ != NULL;
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			DejaDupDecodedUri* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			_tmp29_ = uri;
			_tmp30_ = _tmp29_->host;
			_tmp24_ = g_strcmp0 (_tmp30_, "") != 0;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			DejaDupDecodedUri* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			_tmp31_ = _ ("%1$s on %2$s");
			_tmp32_ = desc;
			_tmp33_ = uri;
			_tmp34_ = _tmp33_->host;
			_tmp35_ = g_strdup_printf (_tmp31_, _tmp32_, _tmp34_);
			_g_free0 (desc);
			desc = _tmp35_;
		}
		_deja_dup_decoded_uri_free0 (uri);
	}
	result = desc;
	return result;
}


void deja_dup_ensure_special_paths (void) {
	GFile* _tmp0_ = NULL;
	_tmp0_ = deja_dup_home;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_g_object_unref0 (deja_dup_home);
		deja_dup_home = _tmp2_;
		_tmp3_ = deja_dup_get_trash_path ();
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_path (_tmp4_);
		_g_object_unref0 (deja_dup_trash);
		deja_dup_trash = _tmp5_;
		_g_free0 (_tmp4_);
	}
}


gchar* deja_dup_get_display_name (GFile* f) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (f != NULL, NULL);
	deja_dup_ensure_special_paths ();
	_tmp0_ = f;
	_tmp1_ = deja_dup_home;
	_tmp2_ = g_file_has_prefix (_tmp0_, _tmp1_);
	if (_tmp2_) {
		gchar* s = NULL;
		GFile* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = deja_dup_home;
		_tmp4_ = f;
		_tmp5_ = g_file_get_relative_path (_tmp3_, _tmp4_);
		s = _tmp5_;
		{
			gchar* _tmp6_ = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp7_ = s;
			_tmp8_ = s;
			_tmp9_ = strlen (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_filename_to_utf8 (_tmp7_, (gssize) _tmp10_, NULL, NULL, &_inner_error_);
			_tmp6_ = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch27_g_convert_error;
				}
				_g_free0 (s);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp12_ = _tmp6_;
			_tmp6_ = NULL;
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strconcat ("~/", _tmp13_, NULL);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			result = _tmp15_;
			_g_free0 (_tmp6_);
			_g_free0 (s);
			return result;
		}
		goto __finally27;
		__catch27_g_convert_error:
		{
			GError* e = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_warning ("CommonUtils.vala:548: %s\n", _tmp17_);
			_g_error_free0 (e);
		}
		__finally27:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (s);
	}
	_tmp18_ = f;
	_tmp19_ = g_file_get_parse_name (_tmp18_);
	result = _tmp19_;
	return result;
}


static void deja_dup_get_nickname_data_free (gpointer _data) {
	DejaDupGetNicknameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->f);
	_g_free0 (_data_->result);
	g_slice_free (DejaDupGetNicknameData, _data_);
}


void deja_dup_get_nickname (GFile* f, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupGetNicknameData* _data_;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	_data_ = g_slice_new0 (DejaDupGetNicknameData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, deja_dup_get_nickname);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_get_nickname_data_free);
	_tmp0_ = f;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->f);
	_data_->f = _tmp1_;
	deja_dup_get_nickname_co (_data_);
}


gchar* deja_dup_get_nickname_finish (GAsyncResult* _res_) {
	gchar* result;
	DejaDupGetNicknameData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void deja_dup_get_nickname_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupGetNicknameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_get_nickname_co (_data_);
}


static gboolean deja_dup_get_nickname_co (DejaDupGetNicknameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	deja_dup_ensure_special_paths ();
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->f;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = deja_dup_home;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = g_file_equal (_data_->_tmp0_, _data_->_tmp1_);
	if (_data_->_tmp2_) {
		{
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = _data_->f;
			_data_->_state_ = 1;
			g_file_query_info_async (_data_->_tmp3_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_DEFAULT, NULL, deja_dup_get_nickname_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = g_file_query_info_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
			_data_->info = _data_->_tmp4_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch28_g_error;
			}
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = _ ("Home (%s)");
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = _data_->info;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = g_file_info_get_display_name (_data_->_tmp6_);
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = g_strdup_printf (_data_->_tmp5_, _data_->_tmp7_);
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp8_;
			_g_object_unref0 (_data_->info);
		}
		goto __finally28;
		__catch28_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			g_warning ("CommonUtils.vala:572: %s\n", _data_->_tmp10_);
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = _ ("Home");
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp12_;
			_g_error_free0 (_data_->e);
		}
		__finally28:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	} else {
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->f;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = deja_dup_trash;
		_data_->_tmp15_ = FALSE;
		_data_->_tmp15_ = g_file_equal (_data_->_tmp13_, _data_->_tmp14_);
		if (_data_->_tmp15_) {
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _ ("Trash");
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp17_;
		} else {
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->f;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = deja_dup_get_display_name (_data_->_tmp18_);
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp19_;
		}
	}
	_data_->result = _data_->s;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->s);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gint deja_dup_get_full_backup_threshold (void) {
	gint result = 0;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gint threshold = 0;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_int ((GSettings*) _tmp1_, DEJA_DUP_FULL_BACKUP_PERIOD_KEY);
	threshold = _tmp2_;
	_tmp3_ = threshold;
	if (_tmp3_ < 1) {
		threshold = 84;
	}
	result = threshold;
	_g_object_unref0 (settings);
	return result;
}


void deja_dup_get_full_backup_threshold_date (GDate* result) {
	GTimeVal now = {0};
	GDate date = {0};
	GTimeVal _tmp0_ = {0};
	gint days = 0;
	gint _tmp1_ = 0;
	g_get_current_time (&now);
	g_get_current_time (&now);
	memset (&date, 0, sizeof (GDate));
	_tmp0_ = now;
	g_date_set_time_val (&date, &_tmp0_);
	_tmp1_ = deja_dup_get_full_backup_threshold ();
	days = _tmp1_;
	g_date_subtract_days (&date, (guint) days);
	*result = date;
	return;
}


SecretSchema* deja_dup_get_passphrase_schema (void) {
	SecretSchema* result = NULL;
	SecretSchema* _tmp0_ = NULL;
	_tmp0_ = secret_schema_new ("org.freedesktop.Secret.Generic", SECRET_SCHEMA_NONE, "owner", SECRET_SCHEMA_ATTRIBUTE_STRING, "type", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	result = _tmp0_;
	return result;
}


gboolean deja_dup_ensure_directory_exists (const gchar* path) {
	gboolean result = FALSE;
	GFile* gfile = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	gfile = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		GFile* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = gfile;
		_tmp4_ = g_file_make_directory_with_parents (_tmp3_, NULL, &_inner_error_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch29_g_io_error_exists;
			}
			goto __catch29_g_error;
		}
		if (_tmp2_) {
			result = TRUE;
			_g_object_unref0 (gfile);
			return result;
		}
	}
	goto __finally29;
	__catch29_g_io_error_exists:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = TRUE;
		_g_error_free0 (e);
		_g_object_unref0 (gfile);
		return result;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("CommonUtils.vala:642: %s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (gfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_object_unref0 (gfile);
	return result;
}


static void deja_dup_get_tempdir_data_free (gpointer _data) {
	DejaDupGetTempdirData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	g_slice_free (DejaDupGetTempdirData, _data_);
}


void deja_dup_get_tempdir (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupGetTempdirData* _data_;
	_data_ = g_slice_new0 (DejaDupGetTempdirData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, deja_dup_get_tempdir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_get_tempdir_data_free);
	deja_dup_get_tempdir_co (_data_);
}


gchar* deja_dup_get_tempdir_finish (GAsyncResult* _res_) {
	gchar* result;
	DejaDupGetTempdirData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void deja_dup_get_tempdir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupGetTempdirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_get_tempdir_co (_data_);
}


static gboolean deja_dup_get_tempdir_co (DejaDupGetTempdirData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = deja_dup_get_tempdirs (&_data_->_tmp0_);
	_data_->tempdirs_length1 = 0;
	_data_->_tempdirs_size_ = 0;
	_data_->tempdirs = _data_->_tmp1_;
	_data_->tempdirs_length1 = _data_->_tmp0_;
	_data_->_tempdirs_size_ = _data_->tempdirs_length1;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = deja_dup_get_settings (NULL);
	_data_->settings = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->settings;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = deja_dup_filtered_settings_get_file_list (_data_->_tmp3_, DEJA_DUP_INCLUDE_LIST_KEY, &_data_->_tmp4_);
	_data_->include_list_length1 = 0;
	_data_->_include_list_size_ = 0;
	_data_->include_list = _data_->_tmp5_;
	_data_->include_list_length1 = _data_->_tmp4_;
	_data_->_include_list_size_ = _data_->include_list_length1;
	_data_->main_include = NULL;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_get_home_dir ();
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_file_new_for_path (_data_->_tmp6_);
	_data_->home = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8__length1 = 0;
	_data_->_tmp8_ = _data_->include_list;
	_data_->_tmp8__length1 = _data_->include_list_length1;
	{
		_data_->include_collection_length1 = 0;
		_data_->_include_collection_size_ = 0;
		_data_->include_collection = _data_->_tmp8_;
		_data_->include_collection_length1 = _data_->_tmp8__length1;
		for (_data_->include_it = 0; _data_->include_it < _data_->_tmp8__length1; _data_->include_it = _data_->include_it + 1) {
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = _g_object_ref0 (_data_->include_collection[_data_->include_it]);
			_data_->include = _data_->_tmp9_;
			{
				_data_->_tmp10_ = NULL;
				_data_->_tmp10_ = _data_->include;
				_data_->_tmp11_ = NULL;
				_data_->_tmp11_ = _data_->home;
				_data_->_tmp12_ = FALSE;
				_data_->_tmp12_ = g_file_equal (_data_->_tmp10_, _data_->_tmp11_);
				if (_data_->_tmp12_) {
					_data_->_tmp13_ = NULL;
					_data_->_tmp13_ = _data_->include;
					_data_->_tmp14_ = NULL;
					_data_->_tmp14_ = _g_object_ref0 (_data_->_tmp13_);
					_g_object_unref0 (_data_->main_include);
					_data_->main_include = _data_->_tmp14_;
					_g_object_unref0 (_data_->include);
					break;
				} else {
					_data_->_tmp15_ = NULL;
					_data_->_tmp15_ = _data_->main_include;
					if (_data_->_tmp15_ == NULL) {
						_data_->_tmp16_ = NULL;
						_data_->_tmp16_ = _data_->include;
						_data_->_tmp17_ = NULL;
						_data_->_tmp17_ = _g_object_ref0 (_data_->_tmp16_);
						_g_object_unref0 (_data_->main_include);
						_data_->main_include = _data_->_tmp17_;
					}
				}
				_g_object_unref0 (_data_->include);
			}
		}
	}
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->main_include;
	if (_data_->_tmp18_ == NULL) {
		_data_->_tmp19_ = NULL;
		_data_->_tmp19__length1 = 0;
		_data_->_tmp19_ = _data_->tempdirs;
		_data_->_tmp19__length1 = _data_->tempdirs_length1;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_[0];
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = g_strdup (_data_->_tmp20_);
		_data_->result = _data_->_tmp21_;
		_g_object_unref0 (_data_->home);
		_g_object_unref0 (_data_->main_include);
		_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data_->settings);
		_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->main_include;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp22_, G_FILE_ATTRIBUTE_ID_FILESYSTEM, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, deja_dup_get_tempdir_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_file_query_info_finish (_data_->_tmp22_, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->info;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = g_file_info_get_attribute_string (_data_->_tmp24_, G_FILE_ATTRIBUTE_ID_FILESYSTEM);
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = g_strdup (_data_->_tmp25_);
		_g_free0 (_data_->filesystem_id);
		_data_->filesystem_id = _data_->_tmp26_;
		_g_object_unref0 (_data_->info);
	}
	goto __finally30;
	__catch30_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27__length1 = 0;
		_data_->_tmp27_ = _data_->tempdirs;
		_data_->_tmp27__length1 = _data_->tempdirs_length1;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_tmp27_[0];
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
		_data_->result = _data_->_tmp29_;
		_g_error_free0 (_data_->e);
		_g_free0 (_data_->filesystem_id);
		_g_object_unref0 (_data_->home);
		_g_object_unref0 (_data_->main_include);
		_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data_->settings);
		_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally30:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_free0 (_data_->filesystem_id);
		_g_object_unref0 (_data_->home);
		_g_object_unref0 (_data_->main_include);
		_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data_->settings);
		_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp30_ = NULL;
	_data_->_tmp30__length1 = 0;
	_data_->_tmp30_ = _data_->tempdirs;
	_data_->_tmp30__length1 = _data_->tempdirs_length1;
	{
		_data_->tempdir_collection_length1 = 0;
		_data_->_tempdir_collection_size_ = 0;
		_data_->tempdir_collection = _data_->_tmp30_;
		_data_->tempdir_collection_length1 = _data_->_tmp30__length1;
		for (_data_->tempdir_it = 0; _data_->tempdir_it < _data_->_tmp30__length1; _data_->tempdir_it = _data_->tempdir_it + 1) {
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = g_strdup (_data_->tempdir_collection[_data_->tempdir_it]);
			_data_->tempdir = _data_->_tmp31_;
			{
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->tempdir;
				deja_dup_ensure_directory_exists (_data_->_tmp32_);
				{
					_data_->_tmp33_ = NULL;
					_data_->_tmp33_ = _data_->tempdir;
					_data_->_tmp34_ = NULL;
					_data_->_tmp34_ = g_file_new_for_path (_data_->_tmp33_);
					_data_->gfile = _data_->_tmp34_;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35_ = _data_->gfile;
					_data_->_state_ = 2;
					g_file_query_info_async (_data_->_tmp35_, G_FILE_ATTRIBUTE_ID_FILESYSTEM, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, deja_dup_get_tempdir_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp36_ = NULL;
					_data_->_tmp36_ = g_file_query_info_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error_);
					_data_->_vala1_info = _data_->_tmp36_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						_g_object_unref0 (_data_->gfile);
						goto __catch31_g_error;
					}
					_data_->_tmp37_ = NULL;
					_data_->_tmp37_ = _data_->_vala1_info;
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = g_file_info_get_attribute_string (_data_->_tmp37_, G_FILE_ATTRIBUTE_ID_FILESYSTEM);
					_data_->_tmp39_ = NULL;
					_data_->_tmp39_ = g_strdup (_data_->_tmp38_);
					_g_free0 (_data_->temp_id);
					_data_->temp_id = _data_->_tmp39_;
					_g_object_unref0 (_data_->_vala1_info);
					_g_object_unref0 (_data_->gfile);
				}
				goto __finally31;
				__catch31_g_error:
				{
					_data_->_vala1_e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_g_error_free0 (_data_->_vala1_e);
					_g_free0 (_data_->temp_id);
					_g_free0 (_data_->tempdir);
					continue;
				}
				__finally31:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_free0 (_data_->temp_id);
					_g_free0 (_data_->tempdir);
					_g_free0 (_data_->filesystem_id);
					_g_object_unref0 (_data_->home);
					_g_object_unref0 (_data_->main_include);
					_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_object_unref0 (_data_->settings);
					_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_data_->_tmp40_ = NULL;
				_data_->_tmp40_ = _data_->temp_id;
				_data_->_tmp41_ = NULL;
				_data_->_tmp41_ = _data_->filesystem_id;
				if (g_strcmp0 (_data_->_tmp40_, _data_->_tmp41_) == 0) {
					_data_->result = _data_->tempdir;
					_g_free0 (_data_->temp_id);
					_g_free0 (_data_->filesystem_id);
					_g_object_unref0 (_data_->home);
					_g_object_unref0 (_data_->main_include);
					_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_object_unref0 (_data_->settings);
					_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_free0 (_data_->temp_id);
				_g_free0 (_data_->tempdir);
			}
		}
	}
	_data_->_tmp42_ = NULL;
	_data_->_tmp42__length1 = 0;
	_data_->_tmp42_ = _data_->tempdirs;
	_data_->_tmp42__length1 = _data_->tempdirs_length1;
	_data_->_tmp43_ = NULL;
	_data_->_tmp43_ = _data_->_tmp42_[0];
	_data_->_tmp44_ = NULL;
	_data_->_tmp44_ = g_strdup (_data_->_tmp43_);
	_data_->result = _data_->_tmp44_;
	_g_free0 (_data_->filesystem_id);
	_g_object_unref0 (_data_->home);
	_g_object_unref0 (_data_->main_include);
	_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->settings);
	_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_free0 (_data_->filesystem_id);
	_g_object_unref0 (_data_->home);
	_g_object_unref0 (_data_->main_include);
	_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->settings);
	_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar** deja_dup_get_tempdirs (int* result_length1) {
	gchar** result = NULL;
	gchar* tempdir = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	_tmp0_ = g_getenv ("DEJA_DUP_TEMPDIR");
	_tmp1_ = g_strdup (_tmp0_);
	tempdir = _tmp1_;
	_tmp3_ = tempdir;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = tempdir;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		_tmp5_ = tempdir;
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		_tmp7_[0] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		_g_free0 (tempdir);
		return result;
	}
	_tmp9_ = g_get_tmp_dir ();
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = g_strdup ("/var/tmp");
	_tmp12_ = g_get_user_cache_dir ();
	_tmp13_ = g_build_filename (_tmp12_, PACKAGE, "tmp", NULL);
	_tmp14_ = g_new0 (gchar*, 3 + 1);
	_tmp14_[0] = _tmp10_;
	_tmp14_[1] = _tmp11_;
	_tmp14_[2] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_free0 (tempdir);
	return result;
}


static void deja_dup_clean_tempdirs_data_free (gpointer _data) {
	DejaDupCleanTempdirsData* _data_;
	_data_ = _data;
	g_slice_free (DejaDupCleanTempdirsData, _data_);
}


void deja_dup_clean_tempdirs (GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupCleanTempdirsData* _data_;
	_data_ = g_slice_new0 (DejaDupCleanTempdirsData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, deja_dup_clean_tempdirs);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_clean_tempdirs_data_free);
	deja_dup_clean_tempdirs_co (_data_);
}


void deja_dup_clean_tempdirs_finish (GAsyncResult* _res_) {
	DejaDupCleanTempdirsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void deja_dup_clean_tempdirs_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	DejaDupCleanTempdirsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_clean_tempdirs_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean deja_dup_clean_tempdirs_co (DejaDupCleanTempdirsData* _data_) {
	static const gint NUM_ENUMERATED = 16;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = deja_dup_get_tempdirs (&_data_->_tmp0_);
	_data_->tempdirs_length1 = 0;
	_data_->_tempdirs_size_ = 0;
	_data_->tempdirs = _data_->_tmp1_;
	_data_->tempdirs_length1 = _data_->_tmp0_;
	_data_->_tempdirs_size_ = _data_->tempdirs_length1;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2__length1 = 0;
	_data_->_tmp2_ = _data_->tempdirs;
	_data_->_tmp2__length1 = _data_->tempdirs_length1;
	{
		_data_->tempdir_collection_length1 = 0;
		_data_->_tempdir_collection_size_ = 0;
		_data_->tempdir_collection = _data_->_tmp2_;
		_data_->tempdir_collection_length1 = _data_->_tmp2__length1;
		for (_data_->tempdir_it = 0; _data_->tempdir_it < _data_->_tmp2__length1; _data_->tempdir_it = _data_->tempdir_it + 1) {
			_data_->_tmp3_ = NULL;
			_data_->_tmp3_ = g_strdup (_data_->tempdir_collection[_data_->tempdir_it]);
			_data_->tempdir = _data_->_tmp3_;
			{
				_data_->_tmp4_ = NULL;
				_data_->_tmp4_ = _data_->tempdir;
				_data_->_tmp5_ = NULL;
				_data_->_tmp5_ = g_file_new_for_path (_data_->_tmp4_);
				_data_->gfile = _data_->_tmp5_;
				{
					_data_->_tmp6_ = NULL;
					_data_->_tmp6_ = _data_->gfile;
					_data_->_state_ = 1;
					g_file_enumerate_children_async (_data_->_tmp6_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_DEFAULT, NULL, deja_dup_clean_tempdirs_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp7_ = NULL;
					_data_->_tmp7_ = g_file_enumerate_children_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
					_data_->enumerator = _data_->_tmp7_;
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						goto __catch32_g_error;
					}
					while (TRUE) {
						_data_->_tmp8_ = NULL;
						_data_->_tmp8_ = _data_->enumerator;
						_data_->_state_ = 2;
						g_file_enumerator_next_files_async (_data_->_tmp8_, NUM_ENUMERATED, G_PRIORITY_DEFAULT, NULL, deja_dup_clean_tempdirs_ready, _data_);
						return FALSE;
						_state_2:
						_data_->_tmp9_ = NULL;
						_data_->_tmp9_ = g_file_enumerator_next_files_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
						_data_->infos = _data_->_tmp9_;
						if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
							_g_object_unref0 (_data_->enumerator);
							goto __catch32_g_error;
						}
						_data_->_tmp10_ = NULL;
						_data_->_tmp10_ = _data_->infos;
						{
							_data_->info_collection = _data_->_tmp10_;
							for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
								_data_->_tmp11_ = NULL;
								_data_->_tmp11_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
								_data_->info = _data_->_tmp11_;
								{
									_data_->_tmp12_ = NULL;
									_data_->_tmp12_ = _data_->info;
									_data_->_tmp13_ = NULL;
									_data_->_tmp13_ = g_file_info_get_name (_data_->_tmp12_);
									_data_->_tmp14_ = FALSE;
									_data_->_tmp14_ = g_str_has_prefix (_data_->_tmp13_, "duplicity-");
									if (_data_->_tmp14_) {
										_data_->_tmp15_ = NULL;
										_data_->_tmp15_ = _data_->gfile;
										_data_->_tmp16_ = NULL;
										_data_->_tmp16_ = _data_->info;
										_data_->_tmp17_ = NULL;
										_data_->_tmp17_ = g_file_info_get_name (_data_->_tmp16_);
										_data_->_tmp18_ = NULL;
										_data_->_tmp18_ = g_file_get_child (_data_->_tmp15_, _data_->_tmp17_);
										_data_->child = _data_->_tmp18_;
										_data_->_tmp19_ = NULL;
										_data_->_tmp19_ = _data_->child;
										_data_->_tmp20_ = NULL;
										_data_->_tmp20_ = deja_dup_recursive_delete_new (_data_->_tmp19_, NULL);
										_data_->_tmp21_ = NULL;
										_data_->_tmp21_ = _data_->_tmp20_;
										_data_->_state_ = 3;
										deja_dup_recursive_op_start_async ((DejaDupRecursiveOp*) _data_->_tmp21_, deja_dup_clean_tempdirs_ready, _data_);
										return FALSE;
										_state_3:
										deja_dup_recursive_op_start_finish ((DejaDupRecursiveOp*) _data_->_tmp21_, _data_->_res_);
										_g_object_unref0 (_data_->_tmp21_);
										_g_object_unref0 (_data_->child);
									}
									_g_object_unref0 (_data_->info);
								}
							}
						}
						_data_->_tmp22_ = NULL;
						_data_->_tmp22_ = _data_->infos;
						_data_->_tmp23_ = 0U;
						_data_->_tmp23_ = g_list_length (_data_->_tmp22_);
						if (_data_->_tmp23_ != ((guint) NUM_ENUMERATED)) {
							__g_list_free__g_object_unref0_0 (_data_->infos);
							break;
						}
						__g_list_free__g_object_unref0_0 (_data_->infos);
					}
					_g_object_unref0 (_data_->enumerator);
				}
				goto __finally32;
				__catch32_g_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_g_error_free0 (_data_->e);
				}
				__finally32:
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					_g_object_unref0 (_data_->gfile);
					_g_free0 (_data_->tempdir);
					_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_g_object_unref0 (_data_->gfile);
				_g_free0 (_data_->tempdir);
			}
		}
	}
	_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



