/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu Dec 10 07:05:40 EST 2020 */

#include "dft/codelet-dft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_twiddle.native -fma -simd -compact -variables 4 -pipeline-latency 8 -twiddle-log3 -precompute-twiddles -n 32 -name t2sv_32 -include dft/simd/ts.h */

/*
 * This function contains 488 FP additions, 350 FP multiplications,
 * (or, 236 additions, 98 multiplications, 252 fused multiply/add),
 * 164 stack variables, 7 constants, and 128 memory accesses
 */
#include "dft/simd/ts.h"

static void t2sv_32(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DVK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + (mb * 8); m < me; m = m + (2 * VL), ri = ri + ((2 * VL) * ms), ii = ii + ((2 * VL) * ms), W = W + ((2 * VL) * 8), MAKE_VOLATILE_STRIDE(64, rs)) {
	       V T2, T8, T3, T6, Te, Ti, T5, T7, TJ, Tb, TM, Tc, Ts, T23, T1w;
	       V T19, TA, TE, T1s, T1N, T1o, T1C, T1F, T1K, T15, T11, T2F, T31, T2J, T34;
	       V T3f, T3z, T3j, T3C, Tw, T3M, T3Q, T1z, T2s, T2w, T1d, T3n, T3r, T26, T2T;
	       V T2X, Th, TR, TP, Td, Tj, TW, Tn, TS, T1U, T2b, T29, T1R, T1V, T2g;
	       V T1Z, T2c;
	       {
		    V Tz, T1n, T10, TD, T1r, T14, T9, T1Q, Tv, T1c;
		    {
			 V T4, T18, Ta, Tr;
			 T2 = LDW(&(W[0]));
			 T8 = LDW(&(W[TWVL * 4]));
			 T3 = LDW(&(W[TWVL * 2]));
			 T6 = LDW(&(W[TWVL * 3]));
			 T4 = VMUL(T2, T3);
			 T18 = VMUL(T3, T8);
			 Ta = VMUL(T2, T6);
			 Tr = VMUL(T2, T8);
			 Te = LDW(&(W[TWVL * 6]));
			 Tz = VMUL(T3, Te);
			 T1n = VMUL(T8, Te);
			 T10 = VMUL(T2, Te);
			 Ti = LDW(&(W[TWVL * 7]));
			 TD = VMUL(T3, Ti);
			 T1r = VMUL(T8, Ti);
			 T14 = VMUL(T2, Ti);
			 T5 = LDW(&(W[TWVL * 1]));
			 T7 = VFMA(T5, T6, T4);
			 TJ = VFNMS(T5, T6, T4);
			 T9 = VMUL(T7, T8);
			 T1Q = VMUL(TJ, T8);
			 Tb = VFNMS(T5, T3, Ta);
			 TM = VFMA(T5, T3, Ta);
			 Tc = LDW(&(W[TWVL * 5]));
			 Tv = VMUL(T2, Tc);
			 T1c = VMUL(T3, Tc);
			 Ts = VFMA(T5, Tc, Tr);
			 T23 = VFMA(T6, Tc, T18);
			 T1w = VFNMS(T5, Tc, Tr);
			 T19 = VFNMS(T6, Tc, T18);
		    }
		    TA = VFMA(T6, Ti, Tz);
		    TE = VFNMS(T6, Te, TD);
		    T1s = VFNMS(Tc, Te, T1r);
		    T1N = VFMA(T6, Te, TD);
		    T1o = VFMA(Tc, Ti, T1n);
		    T1C = VFMA(T5, Ti, T10);
		    T1F = VFNMS(T5, Te, T14);
		    T1K = VFNMS(T6, Ti, Tz);
		    T15 = VFMA(T5, Te, T14);
		    T11 = VFNMS(T5, Ti, T10);
		    {
			 V T2E, T2I, T2S, T2W;
			 T2E = VMUL(T7, Te);
			 T2F = VFMA(Tb, Ti, T2E);
			 T31 = VFNMS(Tb, Ti, T2E);
			 T2I = VMUL(T7, Ti);
			 T2J = VFNMS(Tb, Te, T2I);
			 T34 = VFMA(Tb, Te, T2I);
			 {
			      V T3e, T3i, T3L, T3P;
			      T3e = VMUL(TJ, Te);
			      T3f = VFNMS(TM, Ti, T3e);
			      T3z = VFMA(TM, Ti, T3e);
			      T3i = VMUL(TJ, Ti);
			      T3j = VFMA(TM, Te, T3i);
			      T3C = VFNMS(TM, Te, T3i);
			      T3L = VMUL(Ts, Te);
			      T3P = VMUL(Ts, Ti);
			      Tw = VFNMS(T5, T8, Tv);
			      T3M = VFMA(Tw, Ti, T3L);
			      T3Q = VFNMS(Tw, Te, T3P);
			 }
			 {
			      V T2r, T2v, T3m, T3q;
			      T2r = VMUL(T1w, Te);
			      T2v = VMUL(T1w, Ti);
			      T1z = VFMA(T5, T8, Tv);
			      T2s = VFMA(T1z, Ti, T2r);
			      T2w = VFNMS(T1z, Te, T2v);
			      T3m = VMUL(T19, Te);
			      T3q = VMUL(T19, Ti);
			      T1d = VFMA(T6, T8, T1c);
			      T3n = VFMA(T1d, Ti, T3m);
			      T3r = VFNMS(T1d, Te, T3q);
			 }
			 T2S = VMUL(T23, Te);
			 T2W = VMUL(T23, Ti);
			 T26 = VFNMS(T6, T8, T1c);
			 T2T = VFMA(T26, Ti, T2S);
			 T2X = VFNMS(T26, Te, T2W);
			 {
			      V TQ, TV, Tf, Tm, Tg;
			      Tg = VMUL(T7, Tc);
			      Th = VFMA(Tb, T8, Tg);
			      TR = VFNMS(Tb, T8, Tg);
			      TP = VFMA(Tb, Tc, T9);
			      TQ = VMUL(TP, Te);
			      TV = VMUL(TP, Ti);
			      Td = VFNMS(Tb, Tc, T9);
			      Tf = VMUL(Td, Te);
			      Tm = VMUL(Td, Ti);
			      Tj = VFMA(Th, Ti, Tf);
			      TW = VFNMS(TR, Te, TV);
			      Tn = VFNMS(Th, Te, Tm);
			      TS = VFMA(TR, Ti, TQ);
			 }
			 {
			      V T2a, T2f, T1S, T1Y, T1T;
			      T1T = VMUL(TJ, Tc);
			      T1U = VFMA(TM, T8, T1T);
			      T2b = VFNMS(TM, T8, T1T);
			      T29 = VFMA(TM, Tc, T1Q);
			      T2a = VMUL(T29, Te);
			      T2f = VMUL(T29, Ti);
			      T1R = VFNMS(TM, Tc, T1Q);
			      T1S = VMUL(T1R, Te);
			      T1Y = VMUL(T1R, Ti);
			      T1V = VFMA(T1U, Ti, T1S);
			      T2g = VFNMS(T2b, Te, T2f);
			      T1Z = VFNMS(T1U, Te, T1Y);
			      T2c = VFMA(T2b, Ti, T2a);
			 }
		    }
	       }
	       {
		    V Tq, T46, T8H, T97, TH, T98, T4b, T8D, TZ, T7f, T4j, T6t, T1g, T7g, T4q;
		    V T6u, T1v, T1I, T7m, T7j, T7k, T7l, T4z, T6x, T4G, T6y, T22, T2j, T7o, T7p;
		    V T7q, T7r, T4O, T6A, T4V, T6B, T3G, T7L, T7I, T8n, T5E, T6P, T61, T6M, T2N;
		    V T7A, T7x, T8i, T55, T6I, T5s, T6F, T43, T7J, T7O, T8o, T5L, T62, T5S, T63;
		    V T3c, T7y, T7D, T8j, T5c, T5t, T5j, T5u;
		    {
			 V T1, T8G, Tk, Tl, To, T8E, Tp, T8F;
			 T1 = LD(&(ri[0]), ms, &(ri[0]));
			 T8G = LD(&(ii[0]), ms, &(ii[0]));
			 Tk = LD(&(ri[WS(rs, 16)]), ms, &(ri[0]));
			 Tl = VMUL(Tj, Tk);
			 To = LD(&(ii[WS(rs, 16)]), ms, &(ii[0]));
			 T8E = VMUL(Tj, To);
			 Tp = VFMA(Tn, To, Tl);
			 Tq = VADD(T1, Tp);
			 T46 = VSUB(T1, Tp);
			 T8F = VFNMS(Tn, Tk, T8E);
			 T8H = VADD(T8F, T8G);
			 T97 = VSUB(T8G, T8F);
		    }
		    {
			 V Tt, Tu, Tx, T47, TB, TC, TF, T49;
			 Tt = LD(&(ri[WS(rs, 8)]), ms, &(ri[0]));
			 Tu = VMUL(Ts, Tt);
			 Tx = LD(&(ii[WS(rs, 8)]), ms, &(ii[0]));
			 T47 = VMUL(Ts, Tx);
			 TB = LD(&(ri[WS(rs, 24)]), ms, &(ri[0]));
			 TC = VMUL(TA, TB);
			 TF = LD(&(ii[WS(rs, 24)]), ms, &(ii[0]));
			 T49 = VMUL(TA, TF);
			 {
			      V Ty, TG, T48, T4a;
			      Ty = VFMA(Tw, Tx, Tu);
			      TG = VFMA(TE, TF, TC);
			      TH = VADD(Ty, TG);
			      T98 = VSUB(Ty, TG);
			      T48 = VFNMS(Tw, Tt, T47);
			      T4a = VFNMS(TE, TB, T49);
			      T4b = VSUB(T48, T4a);
			      T8D = VADD(T48, T4a);
			 }
		    }
		    {
			 V TO, T4f, TY, T4h, T4d, T4i;
			 {
			      V TK, TL, TN, T4e;
			      TK = LD(&(ri[WS(rs, 4)]), ms, &(ri[0]));
			      TL = VMUL(TJ, TK);
			      TN = LD(&(ii[WS(rs, 4)]), ms, &(ii[0]));
			      T4e = VMUL(TJ, TN);
			      TO = VFMA(TM, TN, TL);
			      T4f = VFNMS(TM, TK, T4e);
			 }
			 {
			      V TT, TU, TX, T4g;
			      TT = LD(&(ri[WS(rs, 20)]), ms, &(ri[0]));
			      TU = VMUL(TS, TT);
			      TX = LD(&(ii[WS(rs, 20)]), ms, &(ii[0]));
			      T4g = VMUL(TS, TX);
			      TY = VFMA(TW, TX, TU);
			      T4h = VFNMS(TW, TT, T4g);
			 }
			 TZ = VADD(TO, TY);
			 T7f = VADD(T4f, T4h);
			 T4d = VSUB(TO, TY);
			 T4i = VSUB(T4f, T4h);
			 T4j = VADD(T4d, T4i);
			 T6t = VSUB(T4i, T4d);
		    }
		    {
			 V T17, T4m, T1f, T4o, T4k, T4p;
			 {
			      V T12, T13, T16, T4l;
			      T12 = LD(&(ri[WS(rs, 28)]), ms, &(ri[0]));
			      T13 = VMUL(T11, T12);
			      T16 = LD(&(ii[WS(rs, 28)]), ms, &(ii[0]));
			      T4l = VMUL(T11, T16);
			      T17 = VFMA(T15, T16, T13);
			      T4m = VFNMS(T15, T12, T4l);
			 }
			 {
			      V T1a, T1b, T1e, T4n;
			      T1a = LD(&(ri[WS(rs, 12)]), ms, &(ri[0]));
			      T1b = VMUL(T19, T1a);
			      T1e = LD(&(ii[WS(rs, 12)]), ms, &(ii[0]));
			      T4n = VMUL(T19, T1e);
			      T1f = VFMA(T1d, T1e, T1b);
			      T4o = VFNMS(T1d, T1a, T4n);
			 }
			 T1g = VADD(T17, T1f);
			 T7g = VADD(T4m, T4o);
			 T4k = VSUB(T17, T1f);
			 T4p = VSUB(T4m, T4o);
			 T4q = VSUB(T4k, T4p);
			 T6u = VADD(T4k, T4p);
		    }
		    {
			 V T1m, T4u, T1H, T4E, T1u, T4w, T1B, T4C;
			 {
			      V T1j, T1k, T1l, T4t;
			      T1j = LD(&(ri[WS(rs, 2)]), ms, &(ri[0]));
			      T1k = VMUL(T7, T1j);
			      T1l = LD(&(ii[WS(rs, 2)]), ms, &(ii[0]));
			      T4t = VMUL(T7, T1l);
			      T1m = VFMA(Tb, T1l, T1k);
			      T4u = VFNMS(Tb, T1j, T4t);
			 }
			 {
			      V T1D, T1E, T1G, T4D;
			      T1D = LD(&(ri[WS(rs, 26)]), ms, &(ri[0]));
			      T1E = VMUL(T1C, T1D);
			      T1G = LD(&(ii[WS(rs, 26)]), ms, &(ii[0]));
			      T4D = VMUL(T1C, T1G);
			      T1H = VFMA(T1F, T1G, T1E);
			      T4E = VFNMS(T1F, T1D, T4D);
			 }
			 {
			      V T1p, T1q, T1t, T4v;
			      T1p = LD(&(ri[WS(rs, 18)]), ms, &(ri[0]));
			      T1q = VMUL(T1o, T1p);
			      T1t = LD(&(ii[WS(rs, 18)]), ms, &(ii[0]));
			      T4v = VMUL(T1o, T1t);
			      T1u = VFMA(T1s, T1t, T1q);
			      T4w = VFNMS(T1s, T1p, T4v);
			 }
			 {
			      V T1x, T1y, T1A, T4B;
			      T1x = LD(&(ri[WS(rs, 10)]), ms, &(ri[0]));
			      T1y = VMUL(T1w, T1x);
			      T1A = LD(&(ii[WS(rs, 10)]), ms, &(ii[0]));
			      T4B = VMUL(T1w, T1A);
			      T1B = VFMA(T1z, T1A, T1y);
			      T4C = VFNMS(T1z, T1x, T4B);
			 }
			 T1v = VADD(T1m, T1u);
			 T1I = VADD(T1B, T1H);
			 T7m = VSUB(T1v, T1I);
			 T7j = VADD(T4u, T4w);
			 T7k = VADD(T4C, T4E);
			 T7l = VSUB(T7j, T7k);
			 {
			      V T4x, T4y, T4A, T4F;
			      T4x = VSUB(T4u, T4w);
			      T4y = VSUB(T1B, T1H);
			      T4z = VSUB(T4x, T4y);
			      T6x = VADD(T4x, T4y);
			      T4A = VSUB(T1m, T1u);
			      T4F = VSUB(T4C, T4E);
			      T4G = VADD(T4A, T4F);
			      T6y = VSUB(T4A, T4F);
			 }
		    }
		    {
			 V T1P, T4J, T2i, T4T, T21, T4L, T28, T4R;
			 {
			      V T1L, T1M, T1O, T4I;
			      T1L = LD(&(ri[WS(rs, 30)]), ms, &(ri[0]));
			      T1M = VMUL(T1K, T1L);
			      T1O = LD(&(ii[WS(rs, 30)]), ms, &(ii[0]));
			      T4I = VMUL(T1K, T1O);
			      T1P = VFMA(T1N, T1O, T1M);
			      T4J = VFNMS(T1N, T1L, T4I);
			 }
			 {
			      V T2d, T2e, T2h, T4S;
			      T2d = LD(&(ri[WS(rs, 22)]), ms, &(ri[0]));
			      T2e = VMUL(T2c, T2d);
			      T2h = LD(&(ii[WS(rs, 22)]), ms, &(ii[0]));
			      T4S = VMUL(T2c, T2h);
			      T2i = VFMA(T2g, T2h, T2e);
			      T4T = VFNMS(T2g, T2d, T4S);
			 }
			 {
			      V T1W, T1X, T20, T4K;
			      T1W = LD(&(ri[WS(rs, 14)]), ms, &(ri[0]));
			      T1X = VMUL(T1V, T1W);
			      T20 = LD(&(ii[WS(rs, 14)]), ms, &(ii[0]));
			      T4K = VMUL(T1V, T20);
			      T21 = VFMA(T1Z, T20, T1X);
			      T4L = VFNMS(T1Z, T1W, T4K);
			 }
			 {
			      V T24, T25, T27, T4Q;
			      T24 = LD(&(ri[WS(rs, 6)]), ms, &(ri[0]));
			      T25 = VMUL(T23, T24);
			      T27 = LD(&(ii[WS(rs, 6)]), ms, &(ii[0]));
			      T4Q = VMUL(T23, T27);
			      T28 = VFMA(T26, T27, T25);
			      T4R = VFNMS(T26, T24, T4Q);
			 }
			 T22 = VADD(T1P, T21);
			 T2j = VADD(T28, T2i);
			 T7o = VSUB(T22, T2j);
			 T7p = VADD(T4J, T4L);
			 T7q = VADD(T4R, T4T);
			 T7r = VSUB(T7p, T7q);
			 {
			      V T4M, T4N, T4P, T4U;
			      T4M = VSUB(T4J, T4L);
			      T4N = VSUB(T28, T2i);
			      T4O = VSUB(T4M, T4N);
			      T6A = VADD(T4M, T4N);
			      T4P = VSUB(T1P, T21);
			      T4U = VSUB(T4R, T4T);
			      T4V = VADD(T4P, T4U);
			      T6B = VSUB(T4P, T4U);
			 }
		    }
		    {
			 V T3l, T5z, T3E, T5Z, T3t, T5B, T3y, T5X;
			 {
			      V T3g, T3h, T3k, T5y;
			      T3g = LD(&(ri[WS(rs, 31)]), ms, &(ri[WS(rs, 1)]));
			      T3h = VMUL(T3f, T3g);
			      T3k = LD(&(ii[WS(rs, 31)]), ms, &(ii[WS(rs, 1)]));
			      T5y = VMUL(T3f, T3k);
			      T3l = VFMA(T3j, T3k, T3h);
			      T5z = VFNMS(T3j, T3g, T5y);
			 }
			 {
			      V T3A, T3B, T3D, T5Y;
			      T3A = LD(&(ri[WS(rs, 23)]), ms, &(ri[WS(rs, 1)]));
			      T3B = VMUL(T3z, T3A);
			      T3D = LD(&(ii[WS(rs, 23)]), ms, &(ii[WS(rs, 1)]));
			      T5Y = VMUL(T3z, T3D);
			      T3E = VFMA(T3C, T3D, T3B);
			      T5Z = VFNMS(T3C, T3A, T5Y);
			 }
			 {
			      V T3o, T3p, T3s, T5A;
			      T3o = LD(&(ri[WS(rs, 15)]), ms, &(ri[WS(rs, 1)]));
			      T3p = VMUL(T3n, T3o);
			      T3s = LD(&(ii[WS(rs, 15)]), ms, &(ii[WS(rs, 1)]));
			      T5A = VMUL(T3n, T3s);
			      T3t = VFMA(T3r, T3s, T3p);
			      T5B = VFNMS(T3r, T3o, T5A);
			 }
			 {
			      V T3v, T3w, T3x, T5W;
			      T3v = LD(&(ri[WS(rs, 7)]), ms, &(ri[WS(rs, 1)]));
			      T3w = VMUL(TP, T3v);
			      T3x = LD(&(ii[WS(rs, 7)]), ms, &(ii[WS(rs, 1)]));
			      T5W = VMUL(TP, T3x);
			      T3y = VFMA(TR, T3x, T3w);
			      T5X = VFNMS(TR, T3v, T5W);
			 }
			 {
			      V T3u, T3F, T7G, T7H;
			      T3u = VADD(T3l, T3t);
			      T3F = VADD(T3y, T3E);
			      T3G = VADD(T3u, T3F);
			      T7L = VSUB(T3u, T3F);
			      T7G = VADD(T5z, T5B);
			      T7H = VADD(T5X, T5Z);
			      T7I = VSUB(T7G, T7H);
			      T8n = VADD(T7G, T7H);
			 }
			 {
			      V T5C, T5D, T5V, T60;
			      T5C = VSUB(T5z, T5B);
			      T5D = VSUB(T3y, T3E);
			      T5E = VSUB(T5C, T5D);
			      T6P = VADD(T5C, T5D);
			      T5V = VSUB(T3l, T3t);
			      T60 = VSUB(T5X, T5Z);
			      T61 = VADD(T5V, T60);
			      T6M = VSUB(T5V, T60);
			 }
		    }
		    {
			 V T2q, T50, T2L, T5q, T2y, T52, T2D, T5o;
			 {
			      V T2n, T2o, T2p, T4Z;
			      T2n = LD(&(ri[WS(rs, 1)]), ms, &(ri[WS(rs, 1)]));
			      T2o = VMUL(T2, T2n);
			      T2p = LD(&(ii[WS(rs, 1)]), ms, &(ii[WS(rs, 1)]));
			      T4Z = VMUL(T2, T2p);
			      T2q = VFMA(T5, T2p, T2o);
			      T50 = VFNMS(T5, T2n, T4Z);
			 }
			 {
			      V T2G, T2H, T2K, T5p;
			      T2G = LD(&(ri[WS(rs, 25)]), ms, &(ri[WS(rs, 1)]));
			      T2H = VMUL(T2F, T2G);
			      T2K = LD(&(ii[WS(rs, 25)]), ms, &(ii[WS(rs, 1)]));
			      T5p = VMUL(T2F, T2K);
			      T2L = VFMA(T2J, T2K, T2H);
			      T5q = VFNMS(T2J, T2G, T5p);
			 }
			 {
			      V T2t, T2u, T2x, T51;
			      T2t = LD(&(ri[WS(rs, 17)]), ms, &(ri[WS(rs, 1)]));
			      T2u = VMUL(T2s, T2t);
			      T2x = LD(&(ii[WS(rs, 17)]), ms, &(ii[WS(rs, 1)]));
			      T51 = VMUL(T2s, T2x);
			      T2y = VFMA(T2w, T2x, T2u);
			      T52 = VFNMS(T2w, T2t, T51);
			 }
			 {
			      V T2A, T2B, T2C, T5n;
			      T2A = LD(&(ri[WS(rs, 9)]), ms, &(ri[WS(rs, 1)]));
			      T2B = VMUL(T8, T2A);
			      T2C = LD(&(ii[WS(rs, 9)]), ms, &(ii[WS(rs, 1)]));
			      T5n = VMUL(T8, T2C);
			      T2D = VFMA(Tc, T2C, T2B);
			      T5o = VFNMS(Tc, T2A, T5n);
			 }
			 {
			      V T2z, T2M, T7v, T7w;
			      T2z = VADD(T2q, T2y);
			      T2M = VADD(T2D, T2L);
			      T2N = VADD(T2z, T2M);
			      T7A = VSUB(T2z, T2M);
			      T7v = VADD(T50, T52);
			      T7w = VADD(T5o, T5q);
			      T7x = VSUB(T7v, T7w);
			      T8i = VADD(T7v, T7w);
			 }
			 {
			      V T53, T54, T5m, T5r;
			      T53 = VSUB(T50, T52);
			      T54 = VSUB(T2D, T2L);
			      T55 = VSUB(T53, T54);
			      T6I = VADD(T53, T54);
			      T5m = VSUB(T2q, T2y);
			      T5r = VSUB(T5o, T5q);
			      T5s = VADD(T5m, T5r);
			      T6F = VSUB(T5m, T5r);
			 }
		    }
		    {
			 V T3K, T5G, T41, T5Q, T3S, T5I, T3X, T5O;
			 {
			      V T3H, T3I, T3J, T5F;
			      T3H = LD(&(ri[WS(rs, 3)]), ms, &(ri[WS(rs, 1)]));
			      T3I = VMUL(T3, T3H);
			      T3J = LD(&(ii[WS(rs, 3)]), ms, &(ii[WS(rs, 1)]));
			      T5F = VMUL(T3, T3J);
			      T3K = VFMA(T6, T3J, T3I);
			      T5G = VFNMS(T6, T3H, T5F);
			 }
			 {
			      V T3Y, T3Z, T40, T5P;
			      T3Y = LD(&(ri[WS(rs, 11)]), ms, &(ri[WS(rs, 1)]));
			      T3Z = VMUL(Td, T3Y);
			      T40 = LD(&(ii[WS(rs, 11)]), ms, &(ii[WS(rs, 1)]));
			      T5P = VMUL(Td, T40);
			      T41 = VFMA(Th, T40, T3Z);
			      T5Q = VFNMS(Th, T3Y, T5P);
			 }
			 {
			      V T3N, T3O, T3R, T5H;
			      T3N = LD(&(ri[WS(rs, 19)]), ms, &(ri[WS(rs, 1)]));
			      T3O = VMUL(T3M, T3N);
			      T3R = LD(&(ii[WS(rs, 19)]), ms, &(ii[WS(rs, 1)]));
			      T5H = VMUL(T3M, T3R);
			      T3S = VFMA(T3Q, T3R, T3O);
			      T5I = VFNMS(T3Q, T3N, T5H);
			 }
			 {
			      V T3U, T3V, T3W, T5N;
			      T3U = LD(&(ri[WS(rs, 27)]), ms, &(ri[WS(rs, 1)]));
			      T3V = VMUL(Te, T3U);
			      T3W = LD(&(ii[WS(rs, 27)]), ms, &(ii[WS(rs, 1)]));
			      T5N = VMUL(Te, T3W);
			      T3X = VFMA(Ti, T3W, T3V);
			      T5O = VFNMS(Ti, T3U, T5N);
			 }
			 {
			      V T3T, T42, T7M, T7N;
			      T3T = VADD(T3K, T3S);
			      T42 = VADD(T3X, T41);
			      T43 = VADD(T3T, T42);
			      T7J = VSUB(T42, T3T);
			      T7M = VADD(T5G, T5I);
			      T7N = VADD(T5O, T5Q);
			      T7O = VSUB(T7M, T7N);
			      T8o = VADD(T7M, T7N);
			 }
			 {
			      V T5J, T5K, T5M, T5R;
			      T5J = VSUB(T5G, T5I);
			      T5K = VSUB(T3K, T3S);
			      T5L = VSUB(T5J, T5K);
			      T62 = VADD(T5K, T5J);
			      T5M = VSUB(T3X, T41);
			      T5R = VSUB(T5O, T5Q);
			      T5S = VADD(T5M, T5R);
			      T63 = VSUB(T5M, T5R);
			 }
		    }
		    {
			 V T2R, T57, T3a, T5h, T2Z, T59, T36, T5f;
			 {
			      V T2O, T2P, T2Q, T56;
			      T2O = LD(&(ri[WS(rs, 5)]), ms, &(ri[WS(rs, 1)]));
			      T2P = VMUL(T29, T2O);
			      T2Q = LD(&(ii[WS(rs, 5)]), ms, &(ii[WS(rs, 1)]));
			      T56 = VMUL(T29, T2Q);
			      T2R = VFMA(T2b, T2Q, T2P);
			      T57 = VFNMS(T2b, T2O, T56);
			 }
			 {
			      V T37, T38, T39, T5g;
			      T37 = LD(&(ri[WS(rs, 13)]), ms, &(ri[WS(rs, 1)]));
			      T38 = VMUL(T1R, T37);
			      T39 = LD(&(ii[WS(rs, 13)]), ms, &(ii[WS(rs, 1)]));
			      T5g = VMUL(T1R, T39);
			      T3a = VFMA(T1U, T39, T38);
			      T5h = VFNMS(T1U, T37, T5g);
			 }
			 {
			      V T2U, T2V, T2Y, T58;
			      T2U = LD(&(ri[WS(rs, 21)]), ms, &(ri[WS(rs, 1)]));
			      T2V = VMUL(T2T, T2U);
			      T2Y = LD(&(ii[WS(rs, 21)]), ms, &(ii[WS(rs, 1)]));
			      T58 = VMUL(T2T, T2Y);
			      T2Z = VFMA(T2X, T2Y, T2V);
			      T59 = VFNMS(T2X, T2U, T58);
			 }
			 {
			      V T32, T33, T35, T5e;
			      T32 = LD(&(ri[WS(rs, 29)]), ms, &(ri[WS(rs, 1)]));
			      T33 = VMUL(T31, T32);
			      T35 = LD(&(ii[WS(rs, 29)]), ms, &(ii[WS(rs, 1)]));
			      T5e = VMUL(T31, T35);
			      T36 = VFMA(T34, T35, T33);
			      T5f = VFNMS(T34, T32, T5e);
			 }
			 {
			      V T30, T3b, T7B, T7C;
			      T30 = VADD(T2R, T2Z);
			      T3b = VADD(T36, T3a);
			      T3c = VADD(T30, T3b);
			      T7y = VSUB(T3b, T30);
			      T7B = VADD(T57, T59);
			      T7C = VADD(T5f, T5h);
			      T7D = VSUB(T7B, T7C);
			      T8j = VADD(T7B, T7C);
			 }
			 {
			      V T5a, T5b, T5d, T5i;
			      T5a = VSUB(T57, T59);
			      T5b = VSUB(T2R, T2Z);
			      T5c = VSUB(T5a, T5b);
			      T5t = VADD(T5b, T5a);
			      T5d = VSUB(T36, T3a);
			      T5i = VSUB(T5f, T5h);
			      T5j = VADD(T5d, T5i);
			      T5u = VSUB(T5d, T5i);
			 }
		    }
		    {
			 V T1i, T8c, T8z, T8A, T8J, T8O, T2l, T8N, T45, T8L, T8l, T8t, T8q, T8u, T8f;
			 V T8B;
			 {
			      V TI, T1h, T8x, T8y;
			      TI = VADD(Tq, TH);
			      T1h = VADD(TZ, T1g);
			      T1i = VADD(TI, T1h);
			      T8c = VSUB(TI, T1h);
			      T8x = VADD(T8i, T8j);
			      T8y = VADD(T8n, T8o);
			      T8z = VSUB(T8x, T8y);
			      T8A = VADD(T8x, T8y);
			 }
			 {
			      V T8C, T8I, T1J, T2k;
			      T8C = VADD(T7f, T7g);
			      T8I = VADD(T8D, T8H);
			      T8J = VADD(T8C, T8I);
			      T8O = VSUB(T8I, T8C);
			      T1J = VADD(T1v, T1I);
			      T2k = VADD(T22, T2j);
			      T2l = VADD(T1J, T2k);
			      T8N = VSUB(T2k, T1J);
			 }
			 {
			      V T3d, T44, T8h, T8k;
			      T3d = VADD(T2N, T3c);
			      T44 = VADD(T3G, T43);
			      T45 = VADD(T3d, T44);
			      T8L = VSUB(T44, T3d);
			      T8h = VSUB(T2N, T3c);
			      T8k = VSUB(T8i, T8j);
			      T8l = VADD(T8h, T8k);
			      T8t = VSUB(T8k, T8h);
			 }
			 {
			      V T8m, T8p, T8d, T8e;
			      T8m = VSUB(T3G, T43);
			      T8p = VSUB(T8n, T8o);
			      T8q = VSUB(T8m, T8p);
			      T8u = VADD(T8m, T8p);
			      T8d = VADD(T7j, T7k);
			      T8e = VADD(T7p, T7q);
			      T8f = VSUB(T8d, T8e);
			      T8B = VADD(T8d, T8e);
			 }
			 {
			      V T2m, T8K, T8w, T8M;
			      T2m = VADD(T1i, T2l);
			      ST(&(ri[WS(rs, 16)]), VSUB(T2m, T45), ms, &(ri[0]));
			      ST(&(ri[0]), VADD(T2m, T45), ms, &(ri[0]));
			      T8K = VADD(T8B, T8J);
			      ST(&(ii[0]), VADD(T8A, T8K), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 16)]), VSUB(T8K, T8A), ms, &(ii[0]));
			      T8w = VSUB(T1i, T2l);
			      ST(&(ri[WS(rs, 24)]), VSUB(T8w, T8z), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 8)]), VADD(T8w, T8z), ms, &(ri[0]));
			      T8M = VSUB(T8J, T8B);
			      ST(&(ii[WS(rs, 8)]), VADD(T8L, T8M), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 24)]), VSUB(T8M, T8L), ms, &(ii[0]));
			 }
			 {
			      V T8g, T8r, T8P, T8Q;
			      T8g = VADD(T8c, T8f);
			      T8r = VADD(T8l, T8q);
			      ST(&(ri[WS(rs, 20)]), VFNMS(LDK(KP707106781), T8r, T8g), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 4)]), VFMA(LDK(KP707106781), T8r, T8g), ms, &(ri[0]));
			      T8P = VADD(T8N, T8O);
			      T8Q = VADD(T8t, T8u);
			      ST(&(ii[WS(rs, 4)]), VFMA(LDK(KP707106781), T8Q, T8P), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 20)]), VFNMS(LDK(KP707106781), T8Q, T8P), ms, &(ii[0]));
			 }
			 {
			      V T8s, T8v, T8R, T8S;
			      T8s = VSUB(T8c, T8f);
			      T8v = VSUB(T8t, T8u);
			      ST(&(ri[WS(rs, 28)]), VFNMS(LDK(KP707106781), T8v, T8s), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 12)]), VFMA(LDK(KP707106781), T8v, T8s), ms, &(ri[0]));
			      T8R = VSUB(T8O, T8N);
			      T8S = VSUB(T8q, T8l);
			      ST(&(ii[WS(rs, 12)]), VFMA(LDK(KP707106781), T8S, T8R), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 28)]), VFNMS(LDK(KP707106781), T8S, T8R), ms, &(ii[0]));
			 }
		    }
		    {
			 V T7i, T7W, T86, T8a, T8V, T91, T7t, T8W, T7F, T7T, T7Z, T92, T83, T89, T7Q;
			 V T7U;
			 {
			      V T7e, T7h, T84, T85;
			      T7e = VSUB(Tq, TH);
			      T7h = VSUB(T7f, T7g);
			      T7i = VSUB(T7e, T7h);
			      T7W = VADD(T7e, T7h);
			      T84 = VADD(T7L, T7O);
			      T85 = VADD(T7I, T7J);
			      T86 = VFNMS(LDK(KP414213562), T85, T84);
			      T8a = VFMA(LDK(KP414213562), T84, T85);
			 }
			 {
			      V T8T, T8U, T7n, T7s;
			      T8T = VSUB(T1g, TZ);
			      T8U = VSUB(T8H, T8D);
			      T8V = VADD(T8T, T8U);
			      T91 = VSUB(T8U, T8T);
			      T7n = VSUB(T7l, T7m);
			      T7s = VADD(T7o, T7r);
			      T7t = VSUB(T7n, T7s);
			      T8W = VADD(T7n, T7s);
			 }
			 {
			      V T7z, T7E, T7X, T7Y;
			      T7z = VSUB(T7x, T7y);
			      T7E = VSUB(T7A, T7D);
			      T7F = VFMA(LDK(KP414213562), T7E, T7z);
			      T7T = VFNMS(LDK(KP414213562), T7z, T7E);
			      T7X = VADD(T7m, T7l);
			      T7Y = VSUB(T7o, T7r);
			      T7Z = VADD(T7X, T7Y);
			      T92 = VSUB(T7Y, T7X);
			 }
			 {
			      V T81, T82, T7K, T7P;
			      T81 = VADD(T7A, T7D);
			      T82 = VADD(T7x, T7y);
			      T83 = VFMA(LDK(KP414213562), T82, T81);
			      T89 = VFNMS(LDK(KP414213562), T81, T82);
			      T7K = VSUB(T7I, T7J);
			      T7P = VSUB(T7L, T7O);
			      T7Q = VFNMS(LDK(KP414213562), T7P, T7K);
			      T7U = VFMA(LDK(KP414213562), T7K, T7P);
			 }
			 {
			      V T7u, T7R, T93, T94;
			      T7u = VFMA(LDK(KP707106781), T7t, T7i);
			      T7R = VSUB(T7F, T7Q);
			      ST(&(ri[WS(rs, 22)]), VFNMS(LDK(KP923879532), T7R, T7u), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 6)]), VFMA(LDK(KP923879532), T7R, T7u), ms, &(ri[0]));
			      T93 = VFMA(LDK(KP707106781), T92, T91);
			      T94 = VSUB(T7U, T7T);
			      ST(&(ii[WS(rs, 6)]), VFMA(LDK(KP923879532), T94, T93), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 22)]), VFNMS(LDK(KP923879532), T94, T93), ms, &(ii[0]));
			 }
			 {
			      V T7S, T7V, T95, T96;
			      T7S = VFNMS(LDK(KP707106781), T7t, T7i);
			      T7V = VADD(T7T, T7U);
			      ST(&(ri[WS(rs, 14)]), VFNMS(LDK(KP923879532), T7V, T7S), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 30)]), VFMA(LDK(KP923879532), T7V, T7S), ms, &(ri[0]));
			      T95 = VFNMS(LDK(KP707106781), T92, T91);
			      T96 = VADD(T7F, T7Q);
			      ST(&(ii[WS(rs, 14)]), VFNMS(LDK(KP923879532), T96, T95), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 30)]), VFMA(LDK(KP923879532), T96, T95), ms, &(ii[0]));
			 }
			 {
			      V T80, T87, T8X, T8Y;
			      T80 = VFMA(LDK(KP707106781), T7Z, T7W);
			      T87 = VADD(T83, T86);
			      ST(&(ri[WS(rs, 18)]), VFNMS(LDK(KP923879532), T87, T80), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 2)]), VFMA(LDK(KP923879532), T87, T80), ms, &(ri[0]));
			      T8X = VFMA(LDK(KP707106781), T8W, T8V);
			      T8Y = VADD(T89, T8a);
			      ST(&(ii[WS(rs, 2)]), VFMA(LDK(KP923879532), T8Y, T8X), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 18)]), VFNMS(LDK(KP923879532), T8Y, T8X), ms, &(ii[0]));
			 }
			 {
			      V T88, T8b, T8Z, T90;
			      T88 = VFNMS(LDK(KP707106781), T7Z, T7W);
			      T8b = VSUB(T89, T8a);
			      ST(&(ri[WS(rs, 26)]), VFNMS(LDK(KP923879532), T8b, T88), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 10)]), VFMA(LDK(KP923879532), T8b, T88), ms, &(ri[0]));
			      T8Z = VFNMS(LDK(KP707106781), T8W, T8V);
			      T90 = VSUB(T86, T83);
			      ST(&(ii[WS(rs, 10)]), VFMA(LDK(KP923879532), T90, T8Z), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 26)]), VFNMS(LDK(KP923879532), T90, T8Z), ms, &(ii[0]));
			 }
		    }
		    {
			 V T4s, T6c, T4X, T9c, T9b, T9h, T6f, T9i, T66, T6q, T6a, T6m, T5x, T6p, T69;
			 V T6j;
			 {
			      V T4c, T4r, T6d, T6e;
			      T4c = VADD(T46, T4b);
			      T4r = VADD(T4j, T4q);
			      T4s = VFNMS(LDK(KP707106781), T4r, T4c);
			      T6c = VFMA(LDK(KP707106781), T4r, T4c);
			      {
				   V T4H, T4W, T99, T9a;
				   T4H = VFNMS(LDK(KP414213562), T4G, T4z);
				   T4W = VFMA(LDK(KP414213562), T4V, T4O);
				   T4X = VSUB(T4H, T4W);
				   T9c = VADD(T4H, T4W);
				   T99 = VSUB(T97, T98);
				   T9a = VADD(T6t, T6u);
				   T9b = VFMA(LDK(KP707106781), T9a, T99);
				   T9h = VFNMS(LDK(KP707106781), T9a, T99);
			      }
			      T6d = VFMA(LDK(KP414213562), T4z, T4G);
			      T6e = VFNMS(LDK(KP414213562), T4O, T4V);
			      T6f = VADD(T6d, T6e);
			      T9i = VSUB(T6e, T6d);
			      {
				   V T5U, T6l, T65, T6k, T5T, T64;
				   T5T = VADD(T5L, T5S);
				   T5U = VFNMS(LDK(KP707106781), T5T, T5E);
				   T6l = VFMA(LDK(KP707106781), T5T, T5E);
				   T64 = VADD(T62, T63);
				   T65 = VFNMS(LDK(KP707106781), T64, T61);
				   T6k = VFMA(LDK(KP707106781), T64, T61);
				   T66 = VFNMS(LDK(KP668178637), T65, T5U);
				   T6q = VFMA(LDK(KP198912367), T6k, T6l);
				   T6a = VFMA(LDK(KP668178637), T5U, T65);
				   T6m = VFNMS(LDK(KP198912367), T6l, T6k);
			      }
			      {
				   V T5l, T6i, T5w, T6h, T5k, T5v;
				   T5k = VADD(T5c, T5j);
				   T5l = VFNMS(LDK(KP707106781), T5k, T55);
				   T6i = VFMA(LDK(KP707106781), T5k, T55);
				   T5v = VADD(T5t, T5u);
				   T5w = VFNMS(LDK(KP707106781), T5v, T5s);
				   T6h = VFMA(LDK(KP707106781), T5v, T5s);
				   T5x = VFMA(LDK(KP668178637), T5w, T5l);
				   T6p = VFNMS(LDK(KP198912367), T6h, T6i);
				   T69 = VFNMS(LDK(KP668178637), T5l, T5w);
				   T6j = VFMA(LDK(KP198912367), T6i, T6h);
			      }
			 }
			 {
			      V T4Y, T67, T9j, T9k;
			      T4Y = VFMA(LDK(KP923879532), T4X, T4s);
			      T67 = VSUB(T5x, T66);
			      ST(&(ri[WS(rs, 21)]), VFNMS(LDK(KP831469612), T67, T4Y), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 5)]), VFMA(LDK(KP831469612), T67, T4Y), ms, &(ri[WS(rs, 1)]));
			      T9j = VFMA(LDK(KP923879532), T9i, T9h);
			      T9k = VSUB(T6a, T69);
			      ST(&(ii[WS(rs, 5)]), VFMA(LDK(KP831469612), T9k, T9j), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 21)]), VFNMS(LDK(KP831469612), T9k, T9j), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T68, T6b, T9l, T9m;
			      T68 = VFNMS(LDK(KP923879532), T4X, T4s);
			      T6b = VADD(T69, T6a);
			      ST(&(ri[WS(rs, 13)]), VFNMS(LDK(KP831469612), T6b, T68), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 29)]), VFMA(LDK(KP831469612), T6b, T68), ms, &(ri[WS(rs, 1)]));
			      T9l = VFNMS(LDK(KP923879532), T9i, T9h);
			      T9m = VADD(T5x, T66);
			      ST(&(ii[WS(rs, 13)]), VFNMS(LDK(KP831469612), T9m, T9l), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 29)]), VFMA(LDK(KP831469612), T9m, T9l), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T6g, T6n, T9d, T9e;
			      T6g = VFMA(LDK(KP923879532), T6f, T6c);
			      T6n = VADD(T6j, T6m);
			      ST(&(ri[WS(rs, 17)]), VFNMS(LDK(KP980785280), T6n, T6g), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 1)]), VFMA(LDK(KP980785280), T6n, T6g), ms, &(ri[WS(rs, 1)]));
			      T9d = VFMA(LDK(KP923879532), T9c, T9b);
			      T9e = VADD(T6p, T6q);
			      ST(&(ii[WS(rs, 1)]), VFMA(LDK(KP980785280), T9e, T9d), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 17)]), VFNMS(LDK(KP980785280), T9e, T9d), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T6o, T6r, T9f, T9g;
			      T6o = VFNMS(LDK(KP923879532), T6f, T6c);
			      T6r = VSUB(T6p, T6q);
			      ST(&(ri[WS(rs, 25)]), VFNMS(LDK(KP980785280), T6r, T6o), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 9)]), VFMA(LDK(KP980785280), T6r, T6o), ms, &(ri[WS(rs, 1)]));
			      T9f = VFNMS(LDK(KP923879532), T9c, T9b);
			      T9g = VSUB(T6m, T6j);
			      ST(&(ii[WS(rs, 9)]), VFMA(LDK(KP980785280), T9g, T9f), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 25)]), VFNMS(LDK(KP980785280), T9g, T9f), ms, &(ii[WS(rs, 1)]));
			 }
		    }
		    {
			 V T6w, T6Y, T6D, T9w, T9p, T9v, T71, T9q, T6S, T7c, T6W, T78, T6L, T7b, T6V;
			 V T75;
			 {
			      V T6s, T6v, T6Z, T70;
			      T6s = VSUB(T46, T4b);
			      T6v = VSUB(T6t, T6u);
			      T6w = VFMA(LDK(KP707106781), T6v, T6s);
			      T6Y = VFNMS(LDK(KP707106781), T6v, T6s);
			      {
				   V T6z, T6C, T9n, T9o;
				   T6z = VFMA(LDK(KP414213562), T6y, T6x);
				   T6C = VFNMS(LDK(KP414213562), T6B, T6A);
				   T6D = VSUB(T6z, T6C);
				   T9w = VADD(T6z, T6C);
				   T9n = VADD(T98, T97);
				   T9o = VSUB(T4q, T4j);
				   T9p = VFMA(LDK(KP707106781), T9o, T9n);
				   T9v = VFNMS(LDK(KP707106781), T9o, T9n);
			      }
			      T6Z = VFNMS(LDK(KP414213562), T6x, T6y);
			      T70 = VFMA(LDK(KP414213562), T6A, T6B);
			      T71 = VADD(T6Z, T70);
			      T9q = VSUB(T70, T6Z);
			      {
				   V T6O, T77, T6R, T76, T6N, T6Q;
				   T6N = VSUB(T5S, T5L);
				   T6O = VFNMS(LDK(KP707106781), T6N, T6M);
				   T77 = VFMA(LDK(KP707106781), T6N, T6M);
				   T6Q = VSUB(T62, T63);
				   T6R = VFNMS(LDK(KP707106781), T6Q, T6P);
				   T76 = VFMA(LDK(KP707106781), T6Q, T6P);
				   T6S = VFNMS(LDK(KP668178637), T6R, T6O);
				   T7c = VFMA(LDK(KP198912367), T76, T77);
				   T6W = VFMA(LDK(KP668178637), T6O, T6R);
				   T78 = VFNMS(LDK(KP198912367), T77, T76);
			      }
			      {
				   V T6H, T74, T6K, T73, T6G, T6J;
				   T6G = VSUB(T5j, T5c);
				   T6H = VFNMS(LDK(KP707106781), T6G, T6F);
				   T74 = VFMA(LDK(KP707106781), T6G, T6F);
				   T6J = VSUB(T5t, T5u);
				   T6K = VFNMS(LDK(KP707106781), T6J, T6I);
				   T73 = VFMA(LDK(KP707106781), T6J, T6I);
				   T6L = VFMA(LDK(KP668178637), T6K, T6H);
				   T7b = VFNMS(LDK(KP198912367), T73, T74);
				   T6V = VFNMS(LDK(KP668178637), T6H, T6K);
				   T75 = VFMA(LDK(KP198912367), T74, T73);
			      }
			 }
			 {
			      V T6E, T6T, T9r, T9s;
			      T6E = VFMA(LDK(KP923879532), T6D, T6w);
			      T6T = VADD(T6L, T6S);
			      ST(&(ri[WS(rs, 19)]), VFNMS(LDK(KP831469612), T6T, T6E), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 3)]), VFMA(LDK(KP831469612), T6T, T6E), ms, &(ri[WS(rs, 1)]));
			      T9r = VFMA(LDK(KP923879532), T9q, T9p);
			      T9s = VADD(T6V, T6W);
			      ST(&(ii[WS(rs, 3)]), VFMA(LDK(KP831469612), T9s, T9r), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 19)]), VFNMS(LDK(KP831469612), T9s, T9r), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T6U, T6X, T9t, T9u;
			      T6U = VFNMS(LDK(KP923879532), T6D, T6w);
			      T6X = VSUB(T6V, T6W);
			      ST(&(ri[WS(rs, 27)]), VFNMS(LDK(KP831469612), T6X, T6U), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 11)]), VFMA(LDK(KP831469612), T6X, T6U), ms, &(ri[WS(rs, 1)]));
			      T9t = VFNMS(LDK(KP923879532), T9q, T9p);
			      T9u = VSUB(T6S, T6L);
			      ST(&(ii[WS(rs, 11)]), VFMA(LDK(KP831469612), T9u, T9t), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 27)]), VFNMS(LDK(KP831469612), T9u, T9t), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T72, T79, T9x, T9y;
			      T72 = VFNMS(LDK(KP923879532), T71, T6Y);
			      T79 = VSUB(T75, T78);
			      ST(&(ri[WS(rs, 23)]), VFNMS(LDK(KP980785280), T79, T72), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 7)]), VFMA(LDK(KP980785280), T79, T72), ms, &(ri[WS(rs, 1)]));
			      T9x = VFNMS(LDK(KP923879532), T9w, T9v);
			      T9y = VSUB(T7c, T7b);
			      ST(&(ii[WS(rs, 7)]), VFMA(LDK(KP980785280), T9y, T9x), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 23)]), VFNMS(LDK(KP980785280), T9y, T9x), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T7a, T7d, T9z, T9A;
			      T7a = VFMA(LDK(KP923879532), T71, T6Y);
			      T7d = VADD(T7b, T7c);
			      ST(&(ri[WS(rs, 15)]), VFNMS(LDK(KP980785280), T7d, T7a), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 31)]), VFMA(LDK(KP980785280), T7d, T7a), ms, &(ri[WS(rs, 1)]));
			      T9z = VFMA(LDK(KP923879532), T9w, T9v);
			      T9A = VADD(T75, T78);
			      ST(&(ii[WS(rs, 15)]), VFNMS(LDK(KP980785280), T9A, T9z), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 31)]), VFMA(LDK(KP980785280), T9A, T9z), ms, &(ii[WS(rs, 1)]));
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 3),
     VTW(0, 9),
     VTW(0, 27),
     { TW_NEXT, (2 * VL), 0 }
};

static const ct_desc desc = { 32, XSIMD_STRING("t2sv_32"), twinstr, &GENUS, { 236, 98, 252, 0 }, 0, 0, 0 };

void XSIMD(codelet_t2sv_32) (planner *p) {
     X(kdft_dit_register) (p, t2sv_32, &desc);
}
#else

/* Generated by: ../../../genfft/gen_twiddle.native -simd -compact -variables 4 -pipeline-latency 8 -twiddle-log3 -precompute-twiddles -n 32 -name t2sv_32 -include dft/simd/ts.h */

/*
 * This function contains 488 FP additions, 280 FP multiplications,
 * (or, 376 additions, 168 multiplications, 112 fused multiply/add),
 * 158 stack variables, 7 constants, and 128 memory accesses
 */
#include "dft/simd/ts.h"

static void t2sv_32(R *ri, R *ii, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DVK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DVK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DVK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + (mb * 8); m < me; m = m + (2 * VL), ri = ri + ((2 * VL) * ms), ii = ii + ((2 * VL) * ms), W = W + ((2 * VL) * 8), MAKE_VOLATILE_STRIDE(64, rs)) {
	       V T2, T5, T3, T6, T8, TM, TO, Td, T9, Te, Th, Tl, TD, TH, T1y;
	       V T1H, T15, T1A, T11, T1F, T1n, T1p, T2q, T2I, T2u, T2K, T2V, T3b, T2Z, T3d;
	       V Tu, Ty, T3l, T3n, T1t, T1v, T2f, T2h, T1a, T1e, T32, T34, T1W, T1Y, T2C;
	       V T2E, Tg, TR, Tk, TS, Tm, TV, To, TT, T1M, T21, T1P, T22, T1Q, T25;
	       V T1S, T23;
	       {
		    V Ts, T1d, Tx, T18, Tt, T1c, Tw, T19, TB, T14, TG, TZ, TC, T13, TF;
		    V T10;
		    {
			 V T4, Tc, T7, Tb;
			 T2 = LDW(&(W[0]));
			 T5 = LDW(&(W[TWVL * 1]));
			 T3 = LDW(&(W[TWVL * 2]));
			 T6 = LDW(&(W[TWVL * 3]));
			 T4 = VMUL(T2, T3);
			 Tc = VMUL(T5, T3);
			 T7 = VMUL(T5, T6);
			 Tb = VMUL(T2, T6);
			 T8 = VADD(T4, T7);
			 TM = VSUB(T4, T7);
			 TO = VADD(Tb, Tc);
			 Td = VSUB(Tb, Tc);
			 T9 = LDW(&(W[TWVL * 4]));
			 Ts = VMUL(T2, T9);
			 T1d = VMUL(T6, T9);
			 Tx = VMUL(T5, T9);
			 T18 = VMUL(T3, T9);
			 Te = LDW(&(W[TWVL * 5]));
			 Tt = VMUL(T5, Te);
			 T1c = VMUL(T3, Te);
			 Tw = VMUL(T2, Te);
			 T19 = VMUL(T6, Te);
			 Th = LDW(&(W[TWVL * 6]));
			 TB = VMUL(T3, Th);
			 T14 = VMUL(T5, Th);
			 TG = VMUL(T6, Th);
			 TZ = VMUL(T2, Th);
			 Tl = LDW(&(W[TWVL * 7]));
			 TC = VMUL(T6, Tl);
			 T13 = VMUL(T2, Tl);
			 TF = VMUL(T3, Tl);
			 T10 = VMUL(T5, Tl);
		    }
		    TD = VADD(TB, TC);
		    TH = VSUB(TF, TG);
		    T1y = VADD(TZ, T10);
		    T1H = VADD(TF, TG);
		    T15 = VADD(T13, T14);
		    T1A = VSUB(T13, T14);
		    T11 = VSUB(TZ, T10);
		    T1F = VSUB(TB, TC);
		    T1n = VFMA(T9, Th, VMUL(Te, Tl));
		    T1p = VFNMS(Te, Th, VMUL(T9, Tl));
		    {
			 V T2o, T2p, T2s, T2t;
			 T2o = VMUL(T8, Th);
			 T2p = VMUL(Td, Tl);
			 T2q = VADD(T2o, T2p);
			 T2I = VSUB(T2o, T2p);
			 T2s = VMUL(T8, Tl);
			 T2t = VMUL(Td, Th);
			 T2u = VSUB(T2s, T2t);
			 T2K = VADD(T2s, T2t);
		    }
		    {
			 V T2T, T2U, T2X, T2Y;
			 T2T = VMUL(TM, Th);
			 T2U = VMUL(TO, Tl);
			 T2V = VSUB(T2T, T2U);
			 T3b = VADD(T2T, T2U);
			 T2X = VMUL(TM, Tl);
			 T2Y = VMUL(TO, Th);
			 T2Z = VADD(T2X, T2Y);
			 T3d = VSUB(T2X, T2Y);
			 Tu = VADD(Ts, Tt);
			 Ty = VSUB(Tw, Tx);
			 T3l = VFMA(Tu, Th, VMUL(Ty, Tl));
			 T3n = VFNMS(Ty, Th, VMUL(Tu, Tl));
		    }
		    T1t = VSUB(Ts, Tt);
		    T1v = VADD(Tw, Tx);
		    T2f = VFMA(T1t, Th, VMUL(T1v, Tl));
		    T2h = VFNMS(T1v, Th, VMUL(T1t, Tl));
		    T1a = VSUB(T18, T19);
		    T1e = VADD(T1c, T1d);
		    T32 = VFMA(T1a, Th, VMUL(T1e, Tl));
		    T34 = VFNMS(T1e, Th, VMUL(T1a, Tl));
		    T1W = VADD(T18, T19);
		    T1Y = VSUB(T1c, T1d);
		    T2C = VFMA(T1W, Th, VMUL(T1Y, Tl));
		    T2E = VFNMS(T1Y, Th, VMUL(T1W, Tl));
		    {
			 V Ta, Tf, Ti, Tj;
			 Ta = VMUL(T8, T9);
			 Tf = VMUL(Td, Te);
			 Tg = VSUB(Ta, Tf);
			 TR = VADD(Ta, Tf);
			 Ti = VMUL(T8, Te);
			 Tj = VMUL(Td, T9);
			 Tk = VADD(Ti, Tj);
			 TS = VSUB(Ti, Tj);
		    }
		    Tm = VFMA(Tg, Th, VMUL(Tk, Tl));
		    TV = VFNMS(TS, Th, VMUL(TR, Tl));
		    To = VFNMS(Tk, Th, VMUL(Tg, Tl));
		    TT = VFMA(TR, Th, VMUL(TS, Tl));
		    {
			 V T1K, T1L, T1N, T1O;
			 T1K = VMUL(TM, T9);
			 T1L = VMUL(TO, Te);
			 T1M = VSUB(T1K, T1L);
			 T21 = VADD(T1K, T1L);
			 T1N = VMUL(TM, Te);
			 T1O = VMUL(TO, T9);
			 T1P = VADD(T1N, T1O);
			 T22 = VSUB(T1N, T1O);
		    }
		    T1Q = VFMA(T1M, Th, VMUL(T1P, Tl));
		    T25 = VFNMS(T22, Th, VMUL(T21, Tl));
		    T1S = VFNMS(T1P, Th, VMUL(T1M, Tl));
		    T23 = VFMA(T21, Th, VMUL(T22, Tl));
	       }
	       {
		    V TL, T6f, T8c, T8q, T3F, T5t, T7I, T7W, T2y, T6B, T6y, T7j, T4k, T5J, T4B;
		    V T5G, T3h, T6H, T6O, T7o, T4L, T5N, T52, T5Q, T1i, T7V, T6i, T7D, T3K, T5u;
		    V T3P, T5v, T1E, T6n, T6m, T7e, T3W, T5y, T41, T5z, T29, T6p, T6s, T7f, T47;
		    V T5B, T4c, T5C, T2R, T6z, T6E, T7k, T4v, T5H, T4E, T5K, T3y, T6P, T6K, T7p;
		    V T4W, T5R, T55, T5O;
		    {
			 V T1, T7G, Tq, T7F, TA, T3C, TJ, T3D, Tn, Tp;
			 T1 = LD(&(ri[0]), ms, &(ri[0]));
			 T7G = LD(&(ii[0]), ms, &(ii[0]));
			 Tn = LD(&(ri[WS(rs, 16)]), ms, &(ri[0]));
			 Tp = LD(&(ii[WS(rs, 16)]), ms, &(ii[0]));
			 Tq = VFMA(Tm, Tn, VMUL(To, Tp));
			 T7F = VFNMS(To, Tn, VMUL(Tm, Tp));
			 {
			      V Tv, Tz, TE, TI;
			      Tv = LD(&(ri[WS(rs, 8)]), ms, &(ri[0]));
			      Tz = LD(&(ii[WS(rs, 8)]), ms, &(ii[0]));
			      TA = VFMA(Tu, Tv, VMUL(Ty, Tz));
			      T3C = VFNMS(Ty, Tv, VMUL(Tu, Tz));
			      TE = LD(&(ri[WS(rs, 24)]), ms, &(ri[0]));
			      TI = LD(&(ii[WS(rs, 24)]), ms, &(ii[0]));
			      TJ = VFMA(TD, TE, VMUL(TH, TI));
			      T3D = VFNMS(TH, TE, VMUL(TD, TI));
			 }
			 {
			      V Tr, TK, T8a, T8b;
			      Tr = VADD(T1, Tq);
			      TK = VADD(TA, TJ);
			      TL = VADD(Tr, TK);
			      T6f = VSUB(Tr, TK);
			      T8a = VSUB(T7G, T7F);
			      T8b = VSUB(TA, TJ);
			      T8c = VSUB(T8a, T8b);
			      T8q = VADD(T8b, T8a);
			 }
			 {
			      V T3B, T3E, T7E, T7H;
			      T3B = VSUB(T1, Tq);
			      T3E = VSUB(T3C, T3D);
			      T3F = VSUB(T3B, T3E);
			      T5t = VADD(T3B, T3E);
			      T7E = VADD(T3C, T3D);
			      T7H = VADD(T7F, T7G);
			      T7I = VADD(T7E, T7H);
			      T7W = VSUB(T7H, T7E);
			 }
		    }
		    {
			 V T2e, T4g, T2w, T4z, T2j, T4h, T2n, T4y;
			 {
			      V T2c, T2d, T2r, T2v;
			      T2c = LD(&(ri[WS(rs, 1)]), ms, &(ri[WS(rs, 1)]));
			      T2d = LD(&(ii[WS(rs, 1)]), ms, &(ii[WS(rs, 1)]));
			      T2e = VFMA(T2, T2c, VMUL(T5, T2d));
			      T4g = VFNMS(T5, T2c, VMUL(T2, T2d));
			      T2r = LD(&(ri[WS(rs, 25)]), ms, &(ri[WS(rs, 1)]));
			      T2v = LD(&(ii[WS(rs, 25)]), ms, &(ii[WS(rs, 1)]));
			      T2w = VFMA(T2q, T2r, VMUL(T2u, T2v));
			      T4z = VFNMS(T2u, T2r, VMUL(T2q, T2v));
			 }
			 {
			      V T2g, T2i, T2l, T2m;
			      T2g = LD(&(ri[WS(rs, 17)]), ms, &(ri[WS(rs, 1)]));
			      T2i = LD(&(ii[WS(rs, 17)]), ms, &(ii[WS(rs, 1)]));
			      T2j = VFMA(T2f, T2g, VMUL(T2h, T2i));
			      T4h = VFNMS(T2h, T2g, VMUL(T2f, T2i));
			      T2l = LD(&(ri[WS(rs, 9)]), ms, &(ri[WS(rs, 1)]));
			      T2m = LD(&(ii[WS(rs, 9)]), ms, &(ii[WS(rs, 1)]));
			      T2n = VFMA(T9, T2l, VMUL(Te, T2m));
			      T4y = VFNMS(Te, T2l, VMUL(T9, T2m));
			 }
			 {
			      V T2k, T2x, T6w, T6x;
			      T2k = VADD(T2e, T2j);
			      T2x = VADD(T2n, T2w);
			      T2y = VADD(T2k, T2x);
			      T6B = VSUB(T2k, T2x);
			      T6w = VADD(T4g, T4h);
			      T6x = VADD(T4y, T4z);
			      T6y = VSUB(T6w, T6x);
			      T7j = VADD(T6w, T6x);
			 }
			 {
			      V T4i, T4j, T4x, T4A;
			      T4i = VSUB(T4g, T4h);
			      T4j = VSUB(T2n, T2w);
			      T4k = VADD(T4i, T4j);
			      T5J = VSUB(T4i, T4j);
			      T4x = VSUB(T2e, T2j);
			      T4A = VSUB(T4y, T4z);
			      T4B = VSUB(T4x, T4A);
			      T5G = VADD(T4x, T4A);
			 }
		    }
		    {
			 V T31, T4Y, T3f, T4J, T36, T4Z, T3a, T4I;
			 {
			      V T2W, T30, T3c, T3e;
			      T2W = LD(&(ri[WS(rs, 31)]), ms, &(ri[WS(rs, 1)]));
			      T30 = LD(&(ii[WS(rs, 31)]), ms, &(ii[WS(rs, 1)]));
			      T31 = VFMA(T2V, T2W, VMUL(T2Z, T30));
			      T4Y = VFNMS(T2Z, T2W, VMUL(T2V, T30));
			      T3c = LD(&(ri[WS(rs, 23)]), ms, &(ri[WS(rs, 1)]));
			      T3e = LD(&(ii[WS(rs, 23)]), ms, &(ii[WS(rs, 1)]));
			      T3f = VFMA(T3b, T3c, VMUL(T3d, T3e));
			      T4J = VFNMS(T3d, T3c, VMUL(T3b, T3e));
			 }
			 {
			      V T33, T35, T38, T39;
			      T33 = LD(&(ri[WS(rs, 15)]), ms, &(ri[WS(rs, 1)]));
			      T35 = LD(&(ii[WS(rs, 15)]), ms, &(ii[WS(rs, 1)]));
			      T36 = VFMA(T32, T33, VMUL(T34, T35));
			      T4Z = VFNMS(T34, T33, VMUL(T32, T35));
			      T38 = LD(&(ri[WS(rs, 7)]), ms, &(ri[WS(rs, 1)]));
			      T39 = LD(&(ii[WS(rs, 7)]), ms, &(ii[WS(rs, 1)]));
			      T3a = VFMA(TR, T38, VMUL(TS, T39));
			      T4I = VFNMS(TS, T38, VMUL(TR, T39));
			 }
			 {
			      V T37, T3g, T6M, T6N;
			      T37 = VADD(T31, T36);
			      T3g = VADD(T3a, T3f);
			      T3h = VADD(T37, T3g);
			      T6H = VSUB(T37, T3g);
			      T6M = VADD(T4Y, T4Z);
			      T6N = VADD(T4I, T4J);
			      T6O = VSUB(T6M, T6N);
			      T7o = VADD(T6M, T6N);
			 }
			 {
			      V T4H, T4K, T50, T51;
			      T4H = VSUB(T31, T36);
			      T4K = VSUB(T4I, T4J);
			      T4L = VSUB(T4H, T4K);
			      T5N = VADD(T4H, T4K);
			      T50 = VSUB(T4Y, T4Z);
			      T51 = VSUB(T3a, T3f);
			      T52 = VADD(T50, T51);
			      T5Q = VSUB(T50, T51);
			 }
		    }
		    {
			 V TQ, T3G, T1g, T3N, TX, T3H, T17, T3M;
			 {
			      V TN, TP, T1b, T1f;
			      TN = LD(&(ri[WS(rs, 4)]), ms, &(ri[0]));
			      TP = LD(&(ii[WS(rs, 4)]), ms, &(ii[0]));
			      TQ = VFMA(TM, TN, VMUL(TO, TP));
			      T3G = VFNMS(TO, TN, VMUL(TM, TP));
			      T1b = LD(&(ri[WS(rs, 12)]), ms, &(ri[0]));
			      T1f = LD(&(ii[WS(rs, 12)]), ms, &(ii[0]));
			      T1g = VFMA(T1a, T1b, VMUL(T1e, T1f));
			      T3N = VFNMS(T1e, T1b, VMUL(T1a, T1f));
			 }
			 {
			      V TU, TW, T12, T16;
			      TU = LD(&(ri[WS(rs, 20)]), ms, &(ri[0]));
			      TW = LD(&(ii[WS(rs, 20)]), ms, &(ii[0]));
			      TX = VFMA(TT, TU, VMUL(TV, TW));
			      T3H = VFNMS(TV, TU, VMUL(TT, TW));
			      T12 = LD(&(ri[WS(rs, 28)]), ms, &(ri[0]));
			      T16 = LD(&(ii[WS(rs, 28)]), ms, &(ii[0]));
			      T17 = VFMA(T11, T12, VMUL(T15, T16));
			      T3M = VFNMS(T15, T12, VMUL(T11, T16));
			 }
			 {
			      V TY, T1h, T6g, T6h;
			      TY = VADD(TQ, TX);
			      T1h = VADD(T17, T1g);
			      T1i = VADD(TY, T1h);
			      T7V = VSUB(T1h, TY);
			      T6g = VADD(T3G, T3H);
			      T6h = VADD(T3M, T3N);
			      T6i = VSUB(T6g, T6h);
			      T7D = VADD(T6g, T6h);
			 }
			 {
			      V T3I, T3J, T3L, T3O;
			      T3I = VSUB(T3G, T3H);
			      T3J = VSUB(TQ, TX);
			      T3K = VSUB(T3I, T3J);
			      T5u = VADD(T3J, T3I);
			      T3L = VSUB(T17, T1g);
			      T3O = VSUB(T3M, T3N);
			      T3P = VADD(T3L, T3O);
			      T5v = VSUB(T3L, T3O);
			 }
		    }
		    {
			 V T1m, T3S, T1C, T3Z, T1r, T3T, T1x, T3Y;
			 {
			      V T1k, T1l, T1z, T1B;
			      T1k = LD(&(ri[WS(rs, 2)]), ms, &(ri[0]));
			      T1l = LD(&(ii[WS(rs, 2)]), ms, &(ii[0]));
			      T1m = VFMA(T8, T1k, VMUL(Td, T1l));
			      T3S = VFNMS(Td, T1k, VMUL(T8, T1l));
			      T1z = LD(&(ri[WS(rs, 26)]), ms, &(ri[0]));
			      T1B = LD(&(ii[WS(rs, 26)]), ms, &(ii[0]));
			      T1C = VFMA(T1y, T1z, VMUL(T1A, T1B));
			      T3Z = VFNMS(T1A, T1z, VMUL(T1y, T1B));
			 }
			 {
			      V T1o, T1q, T1u, T1w;
			      T1o = LD(&(ri[WS(rs, 18)]), ms, &(ri[0]));
			      T1q = LD(&(ii[WS(rs, 18)]), ms, &(ii[0]));
			      T1r = VFMA(T1n, T1o, VMUL(T1p, T1q));
			      T3T = VFNMS(T1p, T1o, VMUL(T1n, T1q));
			      T1u = LD(&(ri[WS(rs, 10)]), ms, &(ri[0]));
			      T1w = LD(&(ii[WS(rs, 10)]), ms, &(ii[0]));
			      T1x = VFMA(T1t, T1u, VMUL(T1v, T1w));
			      T3Y = VFNMS(T1v, T1u, VMUL(T1t, T1w));
			 }
			 {
			      V T1s, T1D, T6k, T6l;
			      T1s = VADD(T1m, T1r);
			      T1D = VADD(T1x, T1C);
			      T1E = VADD(T1s, T1D);
			      T6n = VSUB(T1s, T1D);
			      T6k = VADD(T3S, T3T);
			      T6l = VADD(T3Y, T3Z);
			      T6m = VSUB(T6k, T6l);
			      T7e = VADD(T6k, T6l);
			 }
			 {
			      V T3U, T3V, T3X, T40;
			      T3U = VSUB(T3S, T3T);
			      T3V = VSUB(T1x, T1C);
			      T3W = VADD(T3U, T3V);
			      T5y = VSUB(T3U, T3V);
			      T3X = VSUB(T1m, T1r);
			      T40 = VSUB(T3Y, T3Z);
			      T41 = VSUB(T3X, T40);
			      T5z = VADD(T3X, T40);
			 }
		    }
		    {
			 V T1J, T43, T27, T4a, T1U, T44, T20, T49;
			 {
			      V T1G, T1I, T24, T26;
			      T1G = LD(&(ri[WS(rs, 30)]), ms, &(ri[0]));
			      T1I = LD(&(ii[WS(rs, 30)]), ms, &(ii[0]));
			      T1J = VFMA(T1F, T1G, VMUL(T1H, T1I));
			      T43 = VFNMS(T1H, T1G, VMUL(T1F, T1I));
			      T24 = LD(&(ri[WS(rs, 22)]), ms, &(ri[0]));
			      T26 = LD(&(ii[WS(rs, 22)]), ms, &(ii[0]));
			      T27 = VFMA(T23, T24, VMUL(T25, T26));
			      T4a = VFNMS(T25, T24, VMUL(T23, T26));
			 }
			 {
			      V T1R, T1T, T1X, T1Z;
			      T1R = LD(&(ri[WS(rs, 14)]), ms, &(ri[0]));
			      T1T = LD(&(ii[WS(rs, 14)]), ms, &(ii[0]));
			      T1U = VFMA(T1Q, T1R, VMUL(T1S, T1T));
			      T44 = VFNMS(T1S, T1R, VMUL(T1Q, T1T));
			      T1X = LD(&(ri[WS(rs, 6)]), ms, &(ri[0]));
			      T1Z = LD(&(ii[WS(rs, 6)]), ms, &(ii[0]));
			      T20 = VFMA(T1W, T1X, VMUL(T1Y, T1Z));
			      T49 = VFNMS(T1Y, T1X, VMUL(T1W, T1Z));
			 }
			 {
			      V T1V, T28, T6q, T6r;
			      T1V = VADD(T1J, T1U);
			      T28 = VADD(T20, T27);
			      T29 = VADD(T1V, T28);
			      T6p = VSUB(T1V, T28);
			      T6q = VADD(T43, T44);
			      T6r = VADD(T49, T4a);
			      T6s = VSUB(T6q, T6r);
			      T7f = VADD(T6q, T6r);
			 }
			 {
			      V T45, T46, T48, T4b;
			      T45 = VSUB(T43, T44);
			      T46 = VSUB(T20, T27);
			      T47 = VADD(T45, T46);
			      T5B = VSUB(T45, T46);
			      T48 = VSUB(T1J, T1U);
			      T4b = VSUB(T49, T4a);
			      T4c = VSUB(T48, T4b);
			      T5C = VADD(T48, T4b);
			 }
		    }
		    {
			 V T2B, T4r, T2G, T4s, T4q, T4t, T2M, T4m, T2P, T4n, T4l, T4o;
			 {
			      V T2z, T2A, T2D, T2F;
			      T2z = LD(&(ri[WS(rs, 5)]), ms, &(ri[WS(rs, 1)]));
			      T2A = LD(&(ii[WS(rs, 5)]), ms, &(ii[WS(rs, 1)]));
			      T2B = VFMA(T21, T2z, VMUL(T22, T2A));
			      T4r = VFNMS(T22, T2z, VMUL(T21, T2A));
			      T2D = LD(&(ri[WS(rs, 21)]), ms, &(ri[WS(rs, 1)]));
			      T2F = LD(&(ii[WS(rs, 21)]), ms, &(ii[WS(rs, 1)]));
			      T2G = VFMA(T2C, T2D, VMUL(T2E, T2F));
			      T4s = VFNMS(T2E, T2D, VMUL(T2C, T2F));
			 }
			 T4q = VSUB(T2B, T2G);
			 T4t = VSUB(T4r, T4s);
			 {
			      V T2J, T2L, T2N, T2O;
			      T2J = LD(&(ri[WS(rs, 29)]), ms, &(ri[WS(rs, 1)]));
			      T2L = LD(&(ii[WS(rs, 29)]), ms, &(ii[WS(rs, 1)]));
			      T2M = VFMA(T2I, T2J, VMUL(T2K, T2L));
			      T4m = VFNMS(T2K, T2J, VMUL(T2I, T2L));
			      T2N = LD(&(ri[WS(rs, 13)]), ms, &(ri[WS(rs, 1)]));
			      T2O = LD(&(ii[WS(rs, 13)]), ms, &(ii[WS(rs, 1)]));
			      T2P = VFMA(T1M, T2N, VMUL(T1P, T2O));
			      T4n = VFNMS(T1P, T2N, VMUL(T1M, T2O));
			 }
			 T4l = VSUB(T2M, T2P);
			 T4o = VSUB(T4m, T4n);
			 {
			      V T2H, T2Q, T6C, T6D;
			      T2H = VADD(T2B, T2G);
			      T2Q = VADD(T2M, T2P);
			      T2R = VADD(T2H, T2Q);
			      T6z = VSUB(T2Q, T2H);
			      T6C = VADD(T4r, T4s);
			      T6D = VADD(T4m, T4n);
			      T6E = VSUB(T6C, T6D);
			      T7k = VADD(T6C, T6D);
			 }
			 {
			      V T4p, T4u, T4C, T4D;
			      T4p = VSUB(T4l, T4o);
			      T4u = VADD(T4q, T4t);
			      T4v = VMUL(LDK(KP707106781), VSUB(T4p, T4u));
			      T5H = VMUL(LDK(KP707106781), VADD(T4u, T4p));
			      T4C = VSUB(T4t, T4q);
			      T4D = VADD(T4l, T4o);
			      T4E = VMUL(LDK(KP707106781), VSUB(T4C, T4D));
			      T5K = VMUL(LDK(KP707106781), VADD(T4C, T4D));
			 }
		    }
		    {
			 V T3k, T4M, T3p, T4N, T4O, T4P, T3t, T4S, T3w, T4T, T4R, T4U;
			 {
			      V T3i, T3j, T3m, T3o;
			      T3i = LD(&(ri[WS(rs, 3)]), ms, &(ri[WS(rs, 1)]));
			      T3j = LD(&(ii[WS(rs, 3)]), ms, &(ii[WS(rs, 1)]));
			      T3k = VFMA(T3, T3i, VMUL(T6, T3j));
			      T4M = VFNMS(T6, T3i, VMUL(T3, T3j));
			      T3m = LD(&(ri[WS(rs, 19)]), ms, &(ri[WS(rs, 1)]));
			      T3o = LD(&(ii[WS(rs, 19)]), ms, &(ii[WS(rs, 1)]));
			      T3p = VFMA(T3l, T3m, VMUL(T3n, T3o));
			      T4N = VFNMS(T3n, T3m, VMUL(T3l, T3o));
			 }
			 T4O = VSUB(T4M, T4N);
			 T4P = VSUB(T3k, T3p);
			 {
			      V T3r, T3s, T3u, T3v;
			      T3r = LD(&(ri[WS(rs, 27)]), ms, &(ri[WS(rs, 1)]));
			      T3s = LD(&(ii[WS(rs, 27)]), ms, &(ii[WS(rs, 1)]));
			      T3t = VFMA(Th, T3r, VMUL(Tl, T3s));
			      T4S = VFNMS(Tl, T3r, VMUL(Th, T3s));
			      T3u = LD(&(ri[WS(rs, 11)]), ms, &(ri[WS(rs, 1)]));
			      T3v = LD(&(ii[WS(rs, 11)]), ms, &(ii[WS(rs, 1)]));
			      T3w = VFMA(Tg, T3u, VMUL(Tk, T3v));
			      T4T = VFNMS(Tk, T3u, VMUL(Tg, T3v));
			 }
			 T4R = VSUB(T3t, T3w);
			 T4U = VSUB(T4S, T4T);
			 {
			      V T3q, T3x, T6I, T6J;
			      T3q = VADD(T3k, T3p);
			      T3x = VADD(T3t, T3w);
			      T3y = VADD(T3q, T3x);
			      T6P = VSUB(T3x, T3q);
			      T6I = VADD(T4M, T4N);
			      T6J = VADD(T4S, T4T);
			      T6K = VSUB(T6I, T6J);
			      T7p = VADD(T6I, T6J);
			 }
			 {
			      V T4Q, T4V, T53, T54;
			      T4Q = VSUB(T4O, T4P);
			      T4V = VADD(T4R, T4U);
			      T4W = VMUL(LDK(KP707106781), VSUB(T4Q, T4V));
			      T5R = VMUL(LDK(KP707106781), VADD(T4Q, T4V));
			      T53 = VSUB(T4R, T4U);
			      T54 = VADD(T4P, T4O);
			      T55 = VMUL(LDK(KP707106781), VSUB(T53, T54));
			      T5O = VMUL(LDK(KP707106781), VADD(T54, T53));
			 }
		    }
		    {
			 V T2b, T7x, T7K, T7M, T3A, T7L, T7A, T7B;
			 {
			      V T1j, T2a, T7C, T7J;
			      T1j = VADD(TL, T1i);
			      T2a = VADD(T1E, T29);
			      T2b = VADD(T1j, T2a);
			      T7x = VSUB(T1j, T2a);
			      T7C = VADD(T7e, T7f);
			      T7J = VADD(T7D, T7I);
			      T7K = VADD(T7C, T7J);
			      T7M = VSUB(T7J, T7C);
			 }
			 {
			      V T2S, T3z, T7y, T7z;
			      T2S = VADD(T2y, T2R);
			      T3z = VADD(T3h, T3y);
			      T3A = VADD(T2S, T3z);
			      T7L = VSUB(T3z, T2S);
			      T7y = VADD(T7j, T7k);
			      T7z = VADD(T7o, T7p);
			      T7A = VSUB(T7y, T7z);
			      T7B = VADD(T7y, T7z);
			 }
			 ST(&(ri[WS(rs, 16)]), VSUB(T2b, T3A), ms, &(ri[0]));
			 ST(&(ii[WS(rs, 16)]), VSUB(T7K, T7B), ms, &(ii[0]));
			 ST(&(ri[0]), VADD(T2b, T3A), ms, &(ri[0]));
			 ST(&(ii[0]), VADD(T7B, T7K), ms, &(ii[0]));
			 ST(&(ri[WS(rs, 24)]), VSUB(T7x, T7A), ms, &(ri[0]));
			 ST(&(ii[WS(rs, 24)]), VSUB(T7M, T7L), ms, &(ii[0]));
			 ST(&(ri[WS(rs, 8)]), VADD(T7x, T7A), ms, &(ri[0]));
			 ST(&(ii[WS(rs, 8)]), VADD(T7L, T7M), ms, &(ii[0]));
		    }
		    {
			 V T7h, T7t, T7Q, T7S, T7m, T7u, T7r, T7v;
			 {
			      V T7d, T7g, T7O, T7P;
			      T7d = VSUB(TL, T1i);
			      T7g = VSUB(T7e, T7f);
			      T7h = VADD(T7d, T7g);
			      T7t = VSUB(T7d, T7g);
			      T7O = VSUB(T29, T1E);
			      T7P = VSUB(T7I, T7D);
			      T7Q = VADD(T7O, T7P);
			      T7S = VSUB(T7P, T7O);
			 }
			 {
			      V T7i, T7l, T7n, T7q;
			      T7i = VSUB(T2y, T2R);
			      T7l = VSUB(T7j, T7k);
			      T7m = VADD(T7i, T7l);
			      T7u = VSUB(T7l, T7i);
			      T7n = VSUB(T3h, T3y);
			      T7q = VSUB(T7o, T7p);
			      T7r = VSUB(T7n, T7q);
			      T7v = VADD(T7n, T7q);
			 }
			 {
			      V T7s, T7N, T7w, T7R;
			      T7s = VMUL(LDK(KP707106781), VADD(T7m, T7r));
			      ST(&(ri[WS(rs, 20)]), VSUB(T7h, T7s), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 4)]), VADD(T7h, T7s), ms, &(ri[0]));
			      T7N = VMUL(LDK(KP707106781), VADD(T7u, T7v));
			      ST(&(ii[WS(rs, 4)]), VADD(T7N, T7Q), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 20)]), VSUB(T7Q, T7N), ms, &(ii[0]));
			      T7w = VMUL(LDK(KP707106781), VSUB(T7u, T7v));
			      ST(&(ri[WS(rs, 28)]), VSUB(T7t, T7w), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 12)]), VADD(T7t, T7w), ms, &(ri[0]));
			      T7R = VMUL(LDK(KP707106781), VSUB(T7r, T7m));
			      ST(&(ii[WS(rs, 12)]), VADD(T7R, T7S), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 28)]), VSUB(T7S, T7R), ms, &(ii[0]));
			 }
		    }
		    {
			 V T6j, T7X, T83, T6X, T6u, T7U, T77, T7b, T70, T82, T6G, T6U, T74, T7a, T6R;
			 V T6V;
			 {
			      V T6o, T6t, T6A, T6F;
			      T6j = VSUB(T6f, T6i);
			      T7X = VADD(T7V, T7W);
			      T83 = VSUB(T7W, T7V);
			      T6X = VADD(T6f, T6i);
			      T6o = VSUB(T6m, T6n);
			      T6t = VADD(T6p, T6s);
			      T6u = VMUL(LDK(KP707106781), VSUB(T6o, T6t));
			      T7U = VMUL(LDK(KP707106781), VADD(T6o, T6t));
			      {
				   V T75, T76, T6Y, T6Z;
				   T75 = VADD(T6H, T6K);
				   T76 = VADD(T6O, T6P);
				   T77 = VFNMS(LDK(KP382683432), T76, VMUL(LDK(KP923879532), T75));
				   T7b = VFMA(LDK(KP923879532), T76, VMUL(LDK(KP382683432), T75));
				   T6Y = VADD(T6n, T6m);
				   T6Z = VSUB(T6p, T6s);
				   T70 = VMUL(LDK(KP707106781), VADD(T6Y, T6Z));
				   T82 = VMUL(LDK(KP707106781), VSUB(T6Z, T6Y));
			      }
			      T6A = VSUB(T6y, T6z);
			      T6F = VSUB(T6B, T6E);
			      T6G = VFMA(LDK(KP923879532), T6A, VMUL(LDK(KP382683432), T6F));
			      T6U = VFNMS(LDK(KP923879532), T6F, VMUL(LDK(KP382683432), T6A));
			      {
				   V T72, T73, T6L, T6Q;
				   T72 = VADD(T6y, T6z);
				   T73 = VADD(T6B, T6E);
				   T74 = VFMA(LDK(KP382683432), T72, VMUL(LDK(KP923879532), T73));
				   T7a = VFNMS(LDK(KP382683432), T73, VMUL(LDK(KP923879532), T72));
				   T6L = VSUB(T6H, T6K);
				   T6Q = VSUB(T6O, T6P);
				   T6R = VFNMS(LDK(KP923879532), T6Q, VMUL(LDK(KP382683432), T6L));
				   T6V = VFMA(LDK(KP382683432), T6Q, VMUL(LDK(KP923879532), T6L));
			      }
			 }
			 {
			      V T6v, T6S, T81, T84;
			      T6v = VADD(T6j, T6u);
			      T6S = VADD(T6G, T6R);
			      ST(&(ri[WS(rs, 22)]), VSUB(T6v, T6S), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 6)]), VADD(T6v, T6S), ms, &(ri[0]));
			      T81 = VADD(T6U, T6V);
			      T84 = VADD(T82, T83);
			      ST(&(ii[WS(rs, 6)]), VADD(T81, T84), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 22)]), VSUB(T84, T81), ms, &(ii[0]));
			 }
			 {
			      V T6T, T6W, T85, T86;
			      T6T = VSUB(T6j, T6u);
			      T6W = VSUB(T6U, T6V);
			      ST(&(ri[WS(rs, 30)]), VSUB(T6T, T6W), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 14)]), VADD(T6T, T6W), ms, &(ri[0]));
			      T85 = VSUB(T6R, T6G);
			      T86 = VSUB(T83, T82);
			      ST(&(ii[WS(rs, 14)]), VADD(T85, T86), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 30)]), VSUB(T86, T85), ms, &(ii[0]));
			 }
			 {
			      V T71, T78, T7T, T7Y;
			      T71 = VADD(T6X, T70);
			      T78 = VADD(T74, T77);
			      ST(&(ri[WS(rs, 18)]), VSUB(T71, T78), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 2)]), VADD(T71, T78), ms, &(ri[0]));
			      T7T = VADD(T7a, T7b);
			      T7Y = VADD(T7U, T7X);
			      ST(&(ii[WS(rs, 2)]), VADD(T7T, T7Y), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 18)]), VSUB(T7Y, T7T), ms, &(ii[0]));
			 }
			 {
			      V T79, T7c, T7Z, T80;
			      T79 = VSUB(T6X, T70);
			      T7c = VSUB(T7a, T7b);
			      ST(&(ri[WS(rs, 26)]), VSUB(T79, T7c), ms, &(ri[0]));
			      ST(&(ri[WS(rs, 10)]), VADD(T79, T7c), ms, &(ri[0]));
			      T7Z = VSUB(T77, T74);
			      T80 = VSUB(T7X, T7U);
			      ST(&(ii[WS(rs, 10)]), VADD(T7Z, T80), ms, &(ii[0]));
			      ST(&(ii[WS(rs, 26)]), VSUB(T80, T7Z), ms, &(ii[0]));
			 }
		    }
		    {
			 V T3R, T5d, T8r, T8x, T4e, T8o, T5n, T5r, T4G, T5a, T5g, T8w, T5k, T5q, T57;
			 V T5b, T3Q, T8p;
			 T3Q = VMUL(LDK(KP707106781), VSUB(T3K, T3P));
			 T3R = VSUB(T3F, T3Q);
			 T5d = VADD(T3F, T3Q);
			 T8p = VMUL(LDK(KP707106781), VSUB(T5v, T5u));
			 T8r = VADD(T8p, T8q);
			 T8x = VSUB(T8q, T8p);
			 {
			      V T42, T4d, T5l, T5m;
			      T42 = VFNMS(LDK(KP923879532), T41, VMUL(LDK(KP382683432), T3W));
			      T4d = VFMA(LDK(KP382683432), T47, VMUL(LDK(KP923879532), T4c));
			      T4e = VSUB(T42, T4d);
			      T8o = VADD(T42, T4d);
			      T5l = VADD(T4L, T4W);
			      T5m = VADD(T52, T55);
			      T5n = VFNMS(LDK(KP555570233), T5m, VMUL(LDK(KP831469612), T5l));
			      T5r = VFMA(LDK(KP831469612), T5m, VMUL(LDK(KP555570233), T5l));
			 }
			 {
			      V T4w, T4F, T5e, T5f;
			      T4w = VSUB(T4k, T4v);
			      T4F = VSUB(T4B, T4E);
			      T4G = VFMA(LDK(KP980785280), T4w, VMUL(LDK(KP195090322), T4F));
			      T5a = VFNMS(LDK(KP980785280), T4F, VMUL(LDK(KP195090322), T4w));
			      T5e = VFMA(LDK(KP923879532), T3W, VMUL(LDK(KP382683432), T41));
			      T5f = VFNMS(LDK(KP923879532), T47, VMUL(LDK(KP382683432), T4c));
			      T5g = VADD(T5e, T5f);
			      T8w = VSUB(T5f, T5e);
			 }
			 {
			      V T5i, T5j, T4X, T56;
			      T5i = VADD(T4k, T4v);
			      T5j = VADD(T4B, T4E);
			      T5k = VFMA(LDK(KP555570233), T5i, VMUL(LDK(KP831469612), T5j));
			      T5q = VFNMS(LDK(KP555570233), T5j, VMUL(LDK(KP831469612), T5i));
			      T4X = VSUB(T4L, T4W);
			      T56 = VSUB(T52, T55);
			      T57 = VFNMS(LDK(KP980785280), T56, VMUL(LDK(KP195090322), T4X));
			      T5b = VFMA(LDK(KP195090322), T56, VMUL(LDK(KP980785280), T4X));
			 }
			 {
			      V T4f, T58, T8v, T8y;
			      T4f = VADD(T3R, T4e);
			      T58 = VADD(T4G, T57);
			      ST(&(ri[WS(rs, 23)]), VSUB(T4f, T58), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 7)]), VADD(T4f, T58), ms, &(ri[WS(rs, 1)]));
			      T8v = VADD(T5a, T5b);
			      T8y = VADD(T8w, T8x);
			      ST(&(ii[WS(rs, 7)]), VADD(T8v, T8y), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 23)]), VSUB(T8y, T8v), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T59, T5c, T8z, T8A;
			      T59 = VSUB(T3R, T4e);
			      T5c = VSUB(T5a, T5b);
			      ST(&(ri[WS(rs, 31)]), VSUB(T59, T5c), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 15)]), VADD(T59, T5c), ms, &(ri[WS(rs, 1)]));
			      T8z = VSUB(T57, T4G);
			      T8A = VSUB(T8x, T8w);
			      ST(&(ii[WS(rs, 15)]), VADD(T8z, T8A), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 31)]), VSUB(T8A, T8z), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T5h, T5o, T8n, T8s;
			      T5h = VADD(T5d, T5g);
			      T5o = VADD(T5k, T5n);
			      ST(&(ri[WS(rs, 19)]), VSUB(T5h, T5o), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 3)]), VADD(T5h, T5o), ms, &(ri[WS(rs, 1)]));
			      T8n = VADD(T5q, T5r);
			      T8s = VADD(T8o, T8r);
			      ST(&(ii[WS(rs, 3)]), VADD(T8n, T8s), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 19)]), VSUB(T8s, T8n), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T5p, T5s, T8t, T8u;
			      T5p = VSUB(T5d, T5g);
			      T5s = VSUB(T5q, T5r);
			      ST(&(ri[WS(rs, 27)]), VSUB(T5p, T5s), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 11)]), VADD(T5p, T5s), ms, &(ri[WS(rs, 1)]));
			      T8t = VSUB(T5n, T5k);
			      T8u = VSUB(T8r, T8o);
			      ST(&(ii[WS(rs, 11)]), VADD(T8t, T8u), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 27)]), VSUB(T8u, T8t), ms, &(ii[WS(rs, 1)]));
			 }
		    }
		    {
			 V T5x, T5Z, T8d, T8j, T5E, T88, T69, T6d, T5M, T5W, T62, T8i, T66, T6c, T5T;
			 V T5X, T5w, T89;
			 T5w = VMUL(LDK(KP707106781), VADD(T5u, T5v));
			 T5x = VSUB(T5t, T5w);
			 T5Z = VADD(T5t, T5w);
			 T89 = VMUL(LDK(KP707106781), VADD(T3K, T3P));
			 T8d = VADD(T89, T8c);
			 T8j = VSUB(T8c, T89);
			 {
			      V T5A, T5D, T67, T68;
			      T5A = VFNMS(LDK(KP382683432), T5z, VMUL(LDK(KP923879532), T5y));
			      T5D = VFMA(LDK(KP923879532), T5B, VMUL(LDK(KP382683432), T5C));
			      T5E = VSUB(T5A, T5D);
			      T88 = VADD(T5A, T5D);
			      T67 = VADD(T5N, T5O);
			      T68 = VADD(T5Q, T5R);
			      T69 = VFNMS(LDK(KP195090322), T68, VMUL(LDK(KP980785280), T67));
			      T6d = VFMA(LDK(KP195090322), T67, VMUL(LDK(KP980785280), T68));
			 }
			 {
			      V T5I, T5L, T60, T61;
			      T5I = VSUB(T5G, T5H);
			      T5L = VSUB(T5J, T5K);
			      T5M = VFMA(LDK(KP555570233), T5I, VMUL(LDK(KP831469612), T5L));
			      T5W = VFNMS(LDK(KP831469612), T5I, VMUL(LDK(KP555570233), T5L));
			      T60 = VFMA(LDK(KP382683432), T5y, VMUL(LDK(KP923879532), T5z));
			      T61 = VFNMS(LDK(KP382683432), T5B, VMUL(LDK(KP923879532), T5C));
			      T62 = VADD(T60, T61);
			      T8i = VSUB(T61, T60);
			 }
			 {
			      V T64, T65, T5P, T5S;
			      T64 = VADD(T5G, T5H);
			      T65 = VADD(T5J, T5K);
			      T66 = VFMA(LDK(KP980785280), T64, VMUL(LDK(KP195090322), T65));
			      T6c = VFNMS(LDK(KP195090322), T64, VMUL(LDK(KP980785280), T65));
			      T5P = VSUB(T5N, T5O);
			      T5S = VSUB(T5Q, T5R);
			      T5T = VFNMS(LDK(KP831469612), T5S, VMUL(LDK(KP555570233), T5P));
			      T5X = VFMA(LDK(KP831469612), T5P, VMUL(LDK(KP555570233), T5S));
			 }
			 {
			      V T5F, T5U, T8h, T8k;
			      T5F = VADD(T5x, T5E);
			      T5U = VADD(T5M, T5T);
			      ST(&(ri[WS(rs, 21)]), VSUB(T5F, T5U), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 5)]), VADD(T5F, T5U), ms, &(ri[WS(rs, 1)]));
			      T8h = VADD(T5W, T5X);
			      T8k = VADD(T8i, T8j);
			      ST(&(ii[WS(rs, 5)]), VADD(T8h, T8k), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 21)]), VSUB(T8k, T8h), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T5V, T5Y, T8l, T8m;
			      T5V = VSUB(T5x, T5E);
			      T5Y = VSUB(T5W, T5X);
			      ST(&(ri[WS(rs, 29)]), VSUB(T5V, T5Y), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 13)]), VADD(T5V, T5Y), ms, &(ri[WS(rs, 1)]));
			      T8l = VSUB(T5T, T5M);
			      T8m = VSUB(T8j, T8i);
			      ST(&(ii[WS(rs, 13)]), VADD(T8l, T8m), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 29)]), VSUB(T8m, T8l), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T63, T6a, T87, T8e;
			      T63 = VADD(T5Z, T62);
			      T6a = VADD(T66, T69);
			      ST(&(ri[WS(rs, 17)]), VSUB(T63, T6a), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 1)]), VADD(T63, T6a), ms, &(ri[WS(rs, 1)]));
			      T87 = VADD(T6c, T6d);
			      T8e = VADD(T88, T8d);
			      ST(&(ii[WS(rs, 1)]), VADD(T87, T8e), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 17)]), VSUB(T8e, T87), ms, &(ii[WS(rs, 1)]));
			 }
			 {
			      V T6b, T6e, T8f, T8g;
			      T6b = VSUB(T5Z, T62);
			      T6e = VSUB(T6c, T6d);
			      ST(&(ri[WS(rs, 25)]), VSUB(T6b, T6e), ms, &(ri[WS(rs, 1)]));
			      ST(&(ri[WS(rs, 9)]), VADD(T6b, T6e), ms, &(ri[WS(rs, 1)]));
			      T8f = VSUB(T69, T66);
			      T8g = VSUB(T8d, T88);
			      ST(&(ii[WS(rs, 9)]), VADD(T8f, T8g), ms, &(ii[WS(rs, 1)]));
			      ST(&(ii[WS(rs, 25)]), VSUB(T8g, T8f), ms, &(ii[WS(rs, 1)]));
			 }
		    }
	       }
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(0, 1),
     VTW(0, 3),
     VTW(0, 9),
     VTW(0, 27),
     { TW_NEXT, (2 * VL), 0 }
};

static const ct_desc desc = { 32, XSIMD_STRING("t2sv_32"), twinstr, &GENUS, { 376, 168, 112, 0 }, 0, 0, 0 };

void XSIMD(codelet_t2sv_32) (planner *p) {
     X(kdft_dit_register) (p, t2sv_32, &desc);
}
#endif
