/* <!-- copyright */
/*
 * libmetalink
 *
 * Copyright (c) 2008 Tatsuhiro Tsujikawa
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/* copyright --> */
#ifndef _D_METALINK_PSTATE_V3_H_
#define _D_METALINK_PSTATE_V3_H_

#include "metalink_config.h"

#include <metalink/metalink.h>

#include "metalink_pstate.h"

/* metalink state <metalink> */
void metalink_state_start_fun_v3(metalink_pstm_t* stm,
				 const char* name, const char* ns_uri,
				 const char** attrs);

void metalink_state_end_fun_v3(metalink_pstm_t* stm,
			       const char* name, const char* ns_uri,
			       const char* characters);

/* identity state <identity> */
void identity_state_start_fun_v3(metalink_pstm_t* stm,
				 const char* name, const char* ns_uri,
				 const char** attrs);

void identity_state_end_fun_v3(metalink_pstm_t* stm,
			       const char* name, const char* ns_uri,
			       const char* characters);

/* tags state <tags> */
void tags_state_start_fun_v3(metalink_pstm_t* stm,
			const char* name, const char* ns_uri,
			const char** attrs);

void tags_state_end_fun_v3(metalink_pstm_t* stm,
			   const char* name, const char* ns_uri,
			   const char* characters);

/* files state <files> */
void files_state_start_fun_v3(metalink_pstm_t* stm,
			      const char* name, const char* ns_uri,
			      const char** attrs);

void files_state_end_fun_v3(metalink_pstm_t* stm,
			    const char* name, const char* ns_uri,
			    const char* characters);

/* file state <file> */
void file_state_start_fun_v3(metalink_pstm_t* stm,
			     const char* name, const char* ns_uri,
			     const char** attrs);

void file_state_end_fun_v3(metalink_pstm_t* stm,
			   const char* name, const char* ns_uri,
			   const char* characters);

/* resources state <resources> */
void resources_state_start_fun_v3(metalink_pstm_t* stm,
				  const char* name, const char* ns_uri,
				  const char** attrs);

void resources_state_end_fun_v3(metalink_pstm_t* stm,
				const char* name, const char* ns_uri,
				const char* characters);

/* verification state <verification> */
void verification_state_start_fun_v3(metalink_pstm_t* stm,
				  const char* name, const char* ns_uri,
				  const char** attrs);

void verification_state_end_fun_v3(metalink_pstm_t* stm,
				   const char* name, const char* ns_uri,
				   const char* characters);

/* pieces state <pieces> */
void pieces_state_start_fun_v3(metalink_pstm_t* stm,
			       const char* name, const char* ns_uri,
			       const char** attrs);

void pieces_state_end_fun_v3(metalink_pstm_t* stm,
			     const char* name, const char* ns_uri,
			     const char* characters);

#endif /* _D_METALINK_PARSER_STATE_V3_H_ */
