/* expr.c generated by valac 0.40.8, the Vala compiler
 * generated from expr.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>


#define SKK_TYPE_EXPR_NODE_TYPE (skk_expr_node_type_get_type ())

#define SKK_TYPE_EXPR_NODE (skk_expr_node_get_type ())
typedef struct _SkkExprNode SkkExprNode;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SKK_TYPE_EXPR_READER (skk_expr_reader_get_type ())
#define SKK_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_READER, SkkExprReader))
#define SKK_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_READER, SkkExprReaderClass))
#define SKK_IS_EXPR_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_READER))
#define SKK_IS_EXPR_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_READER))
#define SKK_EXPR_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_READER, SkkExprReaderClass))

typedef struct _SkkExprReader SkkExprReader;
typedef struct _SkkExprReaderClass SkkExprReaderClass;
typedef struct _SkkExprReaderPrivate SkkExprReaderPrivate;
enum  {
	SKK_EXPR_READER_0_PROPERTY,
	SKK_EXPR_READER_NUM_PROPERTIES
};
static GParamSpec* skk_expr_reader_properties[SKK_EXPR_READER_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _skk_expr_node_free0(var) ((var == NULL) ? NULL : (var = (skk_expr_node_free (var), NULL)))

#define SKK_TYPE_EXPR_EVALUATOR (skk_expr_evaluator_get_type ())
#define SKK_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluator))
#define SKK_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))
#define SKK_IS_EXPR_EVALUATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_IS_EXPR_EVALUATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_EXPR_EVALUATOR))
#define SKK_EXPR_EVALUATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_EXPR_EVALUATOR, SkkExprEvaluatorClass))

typedef struct _SkkExprEvaluator SkkExprEvaluator;
typedef struct _SkkExprEvaluatorClass SkkExprEvaluatorClass;
typedef struct _SkkExprEvaluatorPrivate SkkExprEvaluatorPrivate;
enum  {
	SKK_EXPR_EVALUATOR_0_PROPERTY,
	SKK_EXPR_EVALUATOR_NUM_PROPERTIES
};
static GParamSpec* skk_expr_evaluator_properties[SKK_EXPR_EVALUATOR_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

typedef enum  {
	SKK_EXPR_NODE_TYPE_ARRAY,
	SKK_EXPR_NODE_TYPE_SYMBOL,
	SKK_EXPR_NODE_TYPE_STRING
} SkkExprNodeType;

struct _SkkExprNode {
	SkkExprNodeType type;
	GeeLinkedList* nodes;
	gchar* data;
};

struct _SkkExprReader {
	GObject parent_instance;
	SkkExprReaderPrivate * priv;
};

struct _SkkExprReaderClass {
	GObjectClass parent_class;
};

struct _SkkExprEvaluator {
	GObject parent_instance;
	SkkExprEvaluatorPrivate * priv;
};

struct _SkkExprEvaluatorClass {
	GObjectClass parent_class;
};


static gpointer skk_expr_reader_parent_class = NULL;
static gpointer skk_expr_evaluator_parent_class = NULL;

GType skk_expr_node_type_get_type (void) G_GNUC_CONST;
GType skk_expr_node_get_type (void) G_GNUC_CONST;
SkkExprNode* skk_expr_node_dup (const SkkExprNode* self);
void skk_expr_node_free (SkkExprNode* self);
void skk_expr_node_copy (const SkkExprNode* self,
                         SkkExprNode* dest);
void skk_expr_node_destroy (SkkExprNode* self);
void skk_expr_node_init (SkkExprNode *self,
                         SkkExprNodeType type);
GType skk_expr_reader_get_type (void) G_GNUC_CONST;
void skk_expr_reader_read_symbol (SkkExprReader* self,
                                  const gchar* expr,
                                  gint* index,
                                  SkkExprNode* result);
SkkExprNode* skk_expr_reader_read_string (SkkExprReader* self,
                                          const gchar* expr,
                                          gint* index);
SkkExprNode* skk_expr_reader_read_expr (SkkExprReader* self,
                                        const gchar* expr,
                                        gint* index);
SkkExprReader* skk_expr_reader_new (void);
SkkExprReader* skk_expr_reader_construct (GType object_type);
GType skk_expr_evaluator_get_type (void) G_GNUC_CONST;
gchar* skk_expr_evaluator_eval (SkkExprEvaluator* self,
                                SkkExprNode* node);
SkkExprEvaluator* skk_expr_evaluator_new (void);
SkkExprEvaluator* skk_expr_evaluator_construct (GType object_type);


GType
skk_expr_node_type_get_type (void)
{
	static volatile gsize skk_expr_node_type_type_id__volatile = 0;
	if (g_once_init_enter (&skk_expr_node_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SKK_EXPR_NODE_TYPE_ARRAY, "SKK_EXPR_NODE_TYPE_ARRAY", "array"}, {SKK_EXPR_NODE_TYPE_SYMBOL, "SKK_EXPR_NODE_TYPE_SYMBOL", "symbol"}, {SKK_EXPR_NODE_TYPE_STRING, "SKK_EXPR_NODE_TYPE_STRING", "string"}, {0, NULL, NULL}};
		GType skk_expr_node_type_type_id;
		skk_expr_node_type_type_id = g_enum_register_static ("SkkExprNodeType", values);
		g_once_init_leave (&skk_expr_node_type_type_id__volatile, skk_expr_node_type_type_id);
	}
	return skk_expr_node_type_type_id__volatile;
}


void
skk_expr_node_init (SkkExprNode *self,
                    SkkExprNodeType type)
{
	memset (self, 0, sizeof (SkkExprNode));
	(*self).type = type;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
skk_expr_node_copy (const SkkExprNode* self,
                    SkkExprNode* dest)
{
	SkkExprNodeType _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = (*self).type;
	(*dest).type = _tmp0_;
	_tmp1_ = (*self).nodes;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 ((*dest).nodes);
	(*dest).nodes = _tmp2_;
	_tmp3_ = (*self).data;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp4_;
}


void
skk_expr_node_destroy (SkkExprNode* self)
{
	_g_object_unref0 ((*self).nodes);
	_g_free0 ((*self).data);
}


SkkExprNode*
skk_expr_node_dup (const SkkExprNode* self)
{
	SkkExprNode* dup;
	dup = g_new0 (SkkExprNode, 1);
	skk_expr_node_copy (self, dup);
	return dup;
}


void
skk_expr_node_free (SkkExprNode* self)
{
	skk_expr_node_destroy (self);
	g_free (self);
}


GType
skk_expr_node_get_type (void)
{
	static volatile gsize skk_expr_node_type_id__volatile = 0;
	if (g_once_init_enter (&skk_expr_node_type_id__volatile)) {
		GType skk_expr_node_type_id;
		skk_expr_node_type_id = g_boxed_type_register_static ("SkkExprNode", (GBoxedCopyFunc) skk_expr_node_dup, (GBoxedFreeFunc) skk_expr_node_free);
		g_once_init_leave (&skk_expr_node_type_id__volatile, skk_expr_node_type_id);
	}
	return skk_expr_node_type_id__volatile;
}


static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	_tmp0_ = _vala_c;
	if (_tmp0_ != ((gunichar) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp1_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


void
skk_expr_reader_read_symbol (SkkExprReader* self,
                             const gchar* expr,
                             gint* index,
                             SkkExprNode* result)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean stop = FALSE;
	gunichar uc = 0U;
	SkkExprNode node = {0};
	GString* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	stop = FALSE;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		gunichar _tmp5_;
		_tmp2_ = stop;
		if (!_tmp2_) {
			gunichar _tmp3_ = 0U;
			gboolean _tmp4_;
			_tmp4_ = string_get_next_char (expr, index, &_tmp3_);
			uc = _tmp3_;
			_tmp1_ = _tmp4_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		_tmp5_ = uc;
		switch (_tmp5_) {
			case '\\':
			{
				gunichar _tmp6_ = 0U;
				gboolean _tmp7_;
				_tmp7_ = string_get_next_char (expr, index, &_tmp6_);
				uc = _tmp6_;
				if (_tmp7_) {
					GString* _tmp8_;
					gunichar _tmp9_;
					_tmp8_ = builder;
					_tmp9_ = uc;
					g_string_append_unichar (_tmp8_, _tmp9_);
				}
				break;
			}
			case '(':
			case ')':
			case '"':
			case ' ':
			{
				stop = TRUE;
				break;
			}
			default:
			{
				GString* _tmp10_;
				gunichar _tmp11_;
				_tmp10_ = builder;
				_tmp11_ = uc;
				g_string_append_unichar (_tmp10_, _tmp11_);
				break;
			}
		}
	}
	skk_expr_node_init (&node, SKK_EXPR_NODE_TYPE_SYMBOL);
	_tmp12_ = builder;
	_tmp13_ = _tmp12_->str;
	_tmp14_ = g_strdup (_tmp13_);
	_g_free0 (node.data);
	node.data = _tmp14_;
	*result = node;
	_g_string_free0 (builder);
	return;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gpointer
_skk_expr_node_dup0 (gpointer self)
{
	return self ? skk_expr_node_dup (self) : NULL;
}


SkkExprNode*
skk_expr_reader_read_string (SkkExprReader* self,
                             const gchar* expr,
                             gint* index)
{
	SkkExprNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	GString* builder = NULL;
	GString* _tmp3_;
	gint _tmp4_;
	gboolean stop = FALSE;
	gunichar uc = 0U;
	SkkExprNode node = {0};
	GString* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	SkkExprNode _tmp49_;
	SkkExprNode* _tmp50_;
	SkkExprNode* _tmp51_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1_ = strlen (expr);
	_tmp2_ = _tmp1_;
	if ((*index) < _tmp2_) {
		_tmp0_ = string_get (expr, (glong) (*index)) == '"';
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp3_ = g_string_new ("");
	builder = _tmp3_;
	_tmp4_ = *index;
	*index = _tmp4_ + 1;
	stop = FALSE;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gunichar _tmp9_;
		_tmp6_ = stop;
		if (!_tmp6_) {
			gunichar _tmp7_ = 0U;
			gboolean _tmp8_;
			_tmp8_ = string_get_next_char (expr, index, &_tmp7_);
			uc = _tmp7_;
			_tmp5_ = _tmp8_;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp9_ = uc;
		switch (_tmp9_) {
			case '\\':
			{
				gunichar _tmp10_ = 0U;
				gboolean _tmp11_;
				_tmp11_ = string_get_next_char (expr, index, &_tmp10_);
				uc = _tmp10_;
				if (_tmp11_) {
					gunichar _tmp12_;
					GString* _tmp42_;
					gunichar _tmp43_;
					_tmp12_ = uc;
					switch (_tmp12_) {
						case '0':
						case '1':
						case '2':
						case '3':
						case '4':
						case '5':
						case '6':
						case '7':
						{
							gint start = 0;
							gint num = 0;
							gunichar _tmp13_;
							gint _tmp23_;
							gint _tmp24_;
							start = *index;
							_tmp13_ = uc;
							num = ((gint) _tmp13_) - '0';
							while (TRUE) {
								gunichar _tmp14_ = 0U;
								gboolean _tmp15_;
								gint _tmp16_;
								gboolean _tmp17_ = FALSE;
								gunichar _tmp18_;
								gint _tmp20_;
								gint _tmp21_;
								gunichar _tmp22_;
								_tmp15_ = string_get_next_char (expr, index, &_tmp14_);
								uc = _tmp14_;
								if (!_tmp15_) {
									break;
								}
								_tmp16_ = start;
								if (((*index) - _tmp16_) == 3) {
									break;
								}
								_tmp18_ = uc;
								if (_tmp18_ < ((gunichar) '0')) {
									_tmp17_ = TRUE;
								} else {
									gunichar _tmp19_;
									_tmp19_ = uc;
									_tmp17_ = _tmp19_ > ((gunichar) '7');
								}
								if (_tmp17_) {
									break;
								}
								_tmp20_ = num;
								num = _tmp20_ << 3;
								_tmp21_ = num;
								_tmp22_ = uc;
								num = _tmp21_ + (((gint) _tmp22_) - '0');
							}
							_tmp23_ = *index;
							*index = _tmp23_ - 1;
							_tmp24_ = num;
							uc = (gunichar) _tmp24_;
							break;
						}
						case 'x':
						{
							gint num = 0;
							gint _tmp40_;
							gint _tmp41_;
							num = 0;
							while (TRUE) {
								gunichar _tmp25_ = 0U;
								gboolean _tmp26_;
								gunichar _tmp27_;
								gboolean _tmp28_ = FALSE;
								gunichar _tmp29_;
								_tmp26_ = string_get_next_char (expr, index, &_tmp25_);
								uc = _tmp25_;
								if (!_tmp26_) {
									break;
								}
								_tmp27_ = uc;
								uc = g_unichar_tolower (_tmp27_);
								_tmp29_ = uc;
								if (((gunichar) '0') <= _tmp29_) {
									gunichar _tmp30_;
									_tmp30_ = uc;
									_tmp28_ = _tmp30_ <= ((gunichar) '9');
								} else {
									_tmp28_ = FALSE;
								}
								if (_tmp28_) {
									gint _tmp31_;
									gint _tmp32_;
									gunichar _tmp33_;
									_tmp31_ = num;
									num = _tmp31_ << 4;
									_tmp32_ = num;
									_tmp33_ = uc;
									num = _tmp32_ + (((gint) _tmp33_) - '0');
								} else {
									gboolean _tmp34_ = FALSE;
									gunichar _tmp35_;
									_tmp35_ = uc;
									if (((gunichar) 'a') <= _tmp35_) {
										gunichar _tmp36_;
										_tmp36_ = uc;
										_tmp34_ = _tmp36_ <= ((gunichar) 'f');
									} else {
										_tmp34_ = FALSE;
									}
									if (_tmp34_) {
										gint _tmp37_;
										gint _tmp38_;
										gunichar _tmp39_;
										_tmp37_ = num;
										num = _tmp37_ << 4;
										_tmp38_ = num;
										_tmp39_ = uc;
										num = _tmp38_ + ((((gint) _tmp39_) - 'a') + 10);
									} else {
										break;
									}
								}
							}
							_tmp40_ = *index;
							*index = _tmp40_ - 1;
							_tmp41_ = num;
							uc = (gunichar) _tmp41_;
							break;
						}
						default:
						{
							break;
						}
					}
					_tmp42_ = builder;
					_tmp43_ = uc;
					g_string_append_unichar (_tmp42_, _tmp43_);
				}
				break;
			}
			case '\"':
			{
				stop = TRUE;
				break;
			}
			default:
			{
				GString* _tmp44_;
				gunichar _tmp45_;
				_tmp44_ = builder;
				_tmp45_ = uc;
				g_string_append_unichar (_tmp44_, _tmp45_);
				break;
			}
		}
	}
	skk_expr_node_init (&node, SKK_EXPR_NODE_TYPE_STRING);
	_tmp46_ = builder;
	_tmp47_ = _tmp46_->str;
	_tmp48_ = g_strdup (_tmp47_);
	_g_free0 (node.data);
	node.data = _tmp48_;
	_tmp49_ = node;
	_tmp50_ = _skk_expr_node_dup0 (&_tmp49_);
	_tmp51_ = _tmp50_;
	skk_expr_node_destroy (&_tmp49_);
	result = _tmp51_;
	_g_string_free0 (builder);
	return result;
}


SkkExprNode*
skk_expr_reader_read_expr (SkkExprReader* self,
                           const gchar* expr,
                           gint* index)
{
	SkkExprNode* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	GeeLinkedList* nodes = NULL;
	GeeLinkedList* _tmp3_;
	gboolean stop = FALSE;
	gint _tmp4_;
	gunichar uc = 0U;
	SkkExprNode node = {0};
	GeeLinkedList* _tmp24_;
	GeeLinkedList* _tmp25_;
	SkkExprNode _tmp26_;
	SkkExprNode* _tmp27_;
	SkkExprNode* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	_tmp1_ = strlen (expr);
	_tmp2_ = _tmp1_;
	if ((*index) < _tmp2_) {
		_tmp0_ = string_get (expr, (glong) (*index)) == '(';
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	_tmp3_ = gee_linked_list_new (SKK_TYPE_EXPR_NODE, (GBoxedCopyFunc) skk_expr_node_dup, (GDestroyNotify) skk_expr_node_free, NULL, NULL, NULL);
	nodes = _tmp3_;
	stop = FALSE;
	_tmp4_ = *index;
	*index = _tmp4_ + 1;
	uc = (gunichar) '\0';
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gunichar _tmp9_;
		_tmp6_ = stop;
		if (!_tmp6_) {
			gunichar _tmp7_ = 0U;
			gboolean _tmp8_;
			_tmp8_ = string_get_next_char (expr, index, &_tmp7_);
			uc = _tmp7_;
			_tmp5_ = _tmp8_;
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp9_ = uc;
		switch (_tmp9_) {
			case ' ':
			{
				break;
			}
			case ')':
			{
				gint _tmp10_;
				_tmp10_ = *index;
				*index = _tmp10_ + 1;
				stop = TRUE;
				break;
			}
			case '(':
			{
				gint _tmp11_;
				GeeLinkedList* _tmp12_;
				SkkExprNode* _tmp13_;
				SkkExprNode* _tmp14_;
				_tmp11_ = *index;
				*index = _tmp11_ - 1;
				_tmp12_ = nodes;
				_tmp13_ = skk_expr_reader_read_expr (self, expr, index);
				_tmp14_ = _tmp13_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp14_);
				_skk_expr_node_free0 (_tmp14_);
				break;
			}
			case '"':
			{
				gint _tmp15_;
				GeeLinkedList* _tmp16_;
				SkkExprNode* _tmp17_;
				SkkExprNode* _tmp18_;
				_tmp15_ = *index;
				*index = _tmp15_ - 1;
				_tmp16_ = nodes;
				_tmp17_ = skk_expr_reader_read_string (self, expr, index);
				_tmp18_ = _tmp17_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp18_);
				_skk_expr_node_free0 (_tmp18_);
				break;
			}
			default:
			{
				gint _tmp19_;
				GeeLinkedList* _tmp20_;
				SkkExprNode _tmp21_ = {0};
				SkkExprNode _tmp22_;
				SkkExprNode _tmp23_;
				_tmp19_ = *index;
				*index = _tmp19_ - 1;
				_tmp20_ = nodes;
				skk_expr_reader_read_symbol (self, expr, index, &_tmp21_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _tmp22_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, &_tmp23_);
				skk_expr_node_destroy (&_tmp22_);
				break;
			}
		}
	}
	skk_expr_node_init (&node, SKK_EXPR_NODE_TYPE_ARRAY);
	_tmp24_ = nodes;
	_tmp25_ = _g_object_ref0 (_tmp24_);
	_g_object_unref0 (node.nodes);
	node.nodes = _tmp25_;
	_tmp26_ = node;
	_tmp27_ = _skk_expr_node_dup0 (&_tmp26_);
	_tmp28_ = _tmp27_;
	skk_expr_node_destroy (&_tmp26_);
	result = _tmp28_;
	_g_object_unref0 (nodes);
	return result;
}


SkkExprReader*
skk_expr_reader_construct (GType object_type)
{
	SkkExprReader * self = NULL;
	self = (SkkExprReader*) g_object_new (object_type, NULL);
	return self;
}


SkkExprReader*
skk_expr_reader_new (void)
{
	return skk_expr_reader_construct (SKK_TYPE_EXPR_READER);
}


static void
skk_expr_reader_class_init (SkkExprReaderClass * klass)
{
	skk_expr_reader_parent_class = g_type_class_peek_parent (klass);
}


static void
skk_expr_reader_instance_init (SkkExprReader * self)
{
}


GType
skk_expr_reader_get_type (void)
{
	static volatile gsize skk_expr_reader_type_id__volatile = 0;
	if (g_once_init_enter (&skk_expr_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkExprReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_expr_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkExprReader), 0, (GInstanceInitFunc) skk_expr_reader_instance_init, NULL };
		GType skk_expr_reader_type_id;
		skk_expr_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkExprReader", &g_define_type_info, 0);
		g_once_init_leave (&skk_expr_reader_type_id__volatile, skk_expr_reader_type_id);
	}
	return skk_expr_reader_type_id__volatile;
}


gchar*
skk_expr_evaluator_eval (SkkExprEvaluator* self,
                         SkkExprNode* node)
{
	gchar* result = NULL;
	SkkExprNode _tmp0_;
	SkkExprNodeType _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = *node;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ == SKK_EXPR_NODE_TYPE_ARRAY) {
		GeeListIterator* iter = NULL;
		SkkExprNode _tmp2_;
		GeeLinkedList* _tmp3_;
		GeeListIterator* _tmp4_;
		GeeListIterator* _tmp5_;
		_tmp2_ = *node;
		_tmp3_ = _tmp2_.nodes;
		_tmp4_ = gee_abstract_list_list_iterator ((GeeAbstractList*) _tmp3_);
		iter = _tmp4_;
		_tmp5_ = iter;
		if (gee_iterator_next ((GeeIterator*) _tmp5_)) {
			SkkExprNode* funcall = NULL;
			GeeListIterator* _tmp6_;
			gpointer _tmp7_;
			SkkExprNode* _tmp8_;
			SkkExprNodeType _tmp9_;
			_tmp6_ = iter;
			_tmp7_ = gee_iterator_get ((GeeIterator*) _tmp6_);
			funcall = (SkkExprNode*) _tmp7_;
			_tmp8_ = funcall;
			_tmp9_ = (*_tmp8_).type;
			if (_tmp9_ == SKK_EXPR_NODE_TYPE_SYMBOL) {
				SkkExprNode* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = funcall;
				_tmp11_ = (*_tmp10_).data;
				if (g_strcmp0 (_tmp11_, "concat") == 0) {
					GString* builder = NULL;
					GString* _tmp12_;
					GString* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp12_ = g_string_new ("");
					builder = _tmp12_;
					while (TRUE) {
						GeeListIterator* _tmp13_;
						SkkExprNode* arg = NULL;
						GeeListIterator* _tmp14_;
						gpointer _tmp15_;
						SkkExprNode* _tmp16_;
						SkkExprNodeType _tmp17_;
						_tmp13_ = iter;
						if (!gee_iterator_next ((GeeIterator*) _tmp13_)) {
							break;
						}
						_tmp14_ = iter;
						_tmp15_ = gee_iterator_get ((GeeIterator*) _tmp14_);
						arg = (SkkExprNode*) _tmp15_;
						_tmp16_ = arg;
						_tmp17_ = (*_tmp16_).type;
						if (_tmp17_ == SKK_EXPR_NODE_TYPE_STRING) {
							GString* _tmp18_;
							SkkExprNode* _tmp19_;
							const gchar* _tmp20_;
							_tmp18_ = builder;
							_tmp19_ = arg;
							_tmp20_ = (*_tmp19_).data;
							g_string_append (_tmp18_, _tmp20_);
						}
						_skk_expr_node_free0 (arg);
					}
					_tmp21_ = builder;
					_tmp22_ = _tmp21_->str;
					_tmp23_ = g_strdup (_tmp22_);
					result = _tmp23_;
					_g_string_free0 (builder);
					_skk_expr_node_free0 (funcall);
					_g_object_unref0 (iter);
					return result;
				} else {
					SkkExprNode* _tmp24_;
					const gchar* _tmp25_;
					_tmp24_ = funcall;
					_tmp25_ = (*_tmp24_).data;
					if (g_strcmp0 (_tmp25_, "current-time-string") == 0) {
						GDateTime* datetime = NULL;
						GDateTime* _tmp26_;
						GDateTime* _tmp27_;
						gchar* _tmp28_;
						_tmp26_ = g_date_time_new_now_local ();
						datetime = _tmp26_;
						_tmp27_ = datetime;
						_tmp28_ = g_date_time_format (_tmp27_, "%a, %d %b %Y %T %z");
						result = _tmp28_;
						_g_date_time_unref0 (datetime);
						_skk_expr_node_free0 (funcall);
						_g_object_unref0 (iter);
						return result;
					} else {
						SkkExprNode* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = funcall;
						_tmp30_ = (*_tmp29_).data;
						if (g_strcmp0 (_tmp30_, "pwd") == 0) {
							gchar* _tmp31_;
							_tmp31_ = g_get_current_dir ();
							result = _tmp31_;
							_skk_expr_node_free0 (funcall);
							_g_object_unref0 (iter);
							return result;
						} else {
							SkkExprNode* _tmp32_;
							const gchar* _tmp33_;
							_tmp32_ = funcall;
							_tmp33_ = (*_tmp32_).data;
							if (g_strcmp0 (_tmp33_, "skk-version") == 0) {
								gchar* _tmp34_;
								_tmp34_ = g_strdup_printf ("%s/%s", PACKAGE_NAME, PACKAGE_VERSION);
								result = _tmp34_;
								_skk_expr_node_free0 (funcall);
								_g_object_unref0 (iter);
								return result;
							}
						}
					}
				}
			}
			_skk_expr_node_free0 (funcall);
		}
		_g_object_unref0 (iter);
	}
	result = NULL;
	return result;
}


SkkExprEvaluator*
skk_expr_evaluator_construct (GType object_type)
{
	SkkExprEvaluator * self = NULL;
	self = (SkkExprEvaluator*) g_object_new (object_type, NULL);
	return self;
}


SkkExprEvaluator*
skk_expr_evaluator_new (void)
{
	return skk_expr_evaluator_construct (SKK_TYPE_EXPR_EVALUATOR);
}


static void
skk_expr_evaluator_class_init (SkkExprEvaluatorClass * klass)
{
	skk_expr_evaluator_parent_class = g_type_class_peek_parent (klass);
}


static void
skk_expr_evaluator_instance_init (SkkExprEvaluator * self)
{
}


GType
skk_expr_evaluator_get_type (void)
{
	static volatile gsize skk_expr_evaluator_type_id__volatile = 0;
	if (g_once_init_enter (&skk_expr_evaluator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkExprEvaluatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_expr_evaluator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkExprEvaluator), 0, (GInstanceInitFunc) skk_expr_evaluator_instance_init, NULL };
		GType skk_expr_evaluator_type_id;
		skk_expr_evaluator_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkExprEvaluator", &g_define_type_info, 0);
		g_once_init_leave (&skk_expr_evaluator_type_id__volatile, skk_expr_evaluator_type_id);
	}
	return skk_expr_evaluator_type_id__volatile;
}



