; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx90a < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX90A %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx940 < %s | FileCheck -check-prefixes=GFX9,GFX90APLUS,GFX940 %s


define void @v_shuffle_v2i64_v4i64__u_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v4i64__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> poison
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_u(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v4i64__4_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_u(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 poison>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v6
; GFX900-NEXT:    v_mov_b32_e32 v9, v7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v0
; GFX900-NEXT:    v_mov_b32_e32 v11, v1
; GFX900-NEXT:    global_store_dwordx4 v12, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v8
; GFX90A-NEXT:    v_mov_b32_e32 v3, v9
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v10, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v10, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v8
; GFX940-NEXT:    v_mov_b32_e32 v3, v9
; GFX940-NEXT:    v_mov_b32_e32 v4, v0
; GFX940-NEXT:    v_mov_b32_e32 v5, v1
; GFX940-NEXT:    global_store_dwordx4 v10, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v0, v10
; GFX900-NEXT:    v_mov_b32_e32 v1, v11
; GFX900-NEXT:    global_store_dwordx4 v12, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v0, v10
; GFX90A-NEXT:    v_mov_b32_e32 v1, v11
; GFX90A-NEXT:    global_store_dwordx4 v12, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v12, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v10
; GFX940-NEXT:    v_mov_b32_e32 v1, v11
; GFX940-NEXT:    global_store_dwordx4 v12, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v2, v12
; GFX900-NEXT:    v_mov_b32_e32 v3, v13
; GFX900-NEXT:    global_store_dwordx4 v14, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v2, v12
; GFX90A-NEXT:    v_mov_b32_e32 v3, v13
; GFX90A-NEXT:    global_store_dwordx4 v14, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v14, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[6:13]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v12
; GFX940-NEXT:    v_mov_b32_e32 v3, v13
; GFX940-NEXT:    global_store_dwordx4 v14, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v4, v14
; GFX900-NEXT:    v_mov_b32_e32 v5, v15
; GFX900-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v4, v14
; GFX90A-NEXT:    v_mov_b32_e32 v5, v15
; GFX90A-NEXT:    global_store_dwordx4 v16, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v16, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v14
; GFX940-NEXT:    v_mov_b32_e32 v5, v15
; GFX940-NEXT:    global_store_dwordx4 v16, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v6
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    v_mov_b32_e32 v4, v0
; GFX940-NEXT:    v_mov_b32_e32 v5, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v6
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__7_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__7_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__7_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__7_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v6
; GFX940-NEXT:    v_mov_b32_e32 v5, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__u_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v0
; GFX940-NEXT:    v_mov_b32_e32 v3, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v0
; GFX940-NEXT:    v_mov_b32_e32 v3, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> zeroinitializer
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v0
; GFX940-NEXT:    v_mov_b32_e32 v5, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v0
; GFX940-NEXT:    v_mov_b32_e32 v7, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v6
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    v_mov_b32_e32 v4, v0
; GFX940-NEXT:    v_mov_b32_e32 v5, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v0
; GFX900-NEXT:    v_mov_b32_e32 v3, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v0
; GFX90A-NEXT:    v_mov_b32_e32 v3, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__4_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v0
; GFX940-NEXT:    v_mov_b32_e32 v3, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx4 v10, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx4 v10, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v10, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v0
; GFX940-NEXT:    v_mov_b32_e32 v7, v1
; GFX940-NEXT:    global_store_dwordx4 v10, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_0(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v0
; GFX900-NEXT:    v_mov_b32_e32 v9, v1
; GFX900-NEXT:    global_store_dwordx4 v10, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v0
; GFX90A-NEXT:    v_mov_b32_e32 v9, v1
; GFX90A-NEXT:    global_store_dwordx4 v10, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v10, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v8, v0
; GFX940-NEXT:    v_mov_b32_e32 v9, v1
; GFX940-NEXT:    global_store_dwordx4 v10, v[6:9], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 0>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__u_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v2
; GFX900-NEXT:    v_mov_b32_e32 v5, v3
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v2
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v2
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v2
; GFX940-NEXT:    v_mov_b32_e32 v7, v3
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__4_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v8, v2
; GFX900-NEXT:    v_mov_b32_e32 v9, v3
; GFX900-NEXT:    global_store_dwordx4 v12, v[6:9], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v8, v2
; GFX90A-NEXT:    v_mov_b32_e32 v9, v3
; GFX90A-NEXT:    global_store_dwordx4 v12, v[6:9], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v12, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v8, v2
; GFX940-NEXT:    v_mov_b32_e32 v9, v3
; GFX940-NEXT:    global_store_dwordx4 v12, v[6:9], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_1(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v2
; GFX900-NEXT:    v_mov_b32_e32 v11, v3
; GFX900-NEXT:    global_store_dwordx4 v12, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v2
; GFX90A-NEXT:    v_mov_b32_e32 v11, v3
; GFX90A-NEXT:    global_store_dwordx4 v12, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v12, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v10, v2
; GFX940-NEXT:    v_mov_b32_e32 v11, v3
; GFX940-NEXT:    global_store_dwordx4 v12, v[8:11], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 1>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__u_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v4
; GFX940-NEXT:    v_mov_b32_e32 v3, v5
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v4
; GFX900-NEXT:    v_mov_b32_e32 v7, v5
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v4
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v4
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v6
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__4_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v10, v4
; GFX900-NEXT:    v_mov_b32_e32 v11, v5
; GFX900-NEXT:    global_store_dwordx4 v14, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v10, v4
; GFX90A-NEXT:    v_mov_b32_e32 v11, v5
; GFX90A-NEXT:    global_store_dwordx4 v14, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v14, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[6:13]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v10, v4
; GFX940-NEXT:    v_mov_b32_e32 v11, v5
; GFX940-NEXT:    global_store_dwordx4 v14, v[8:11], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_2(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v12, v4
; GFX900-NEXT:    v_mov_b32_e32 v13, v5
; GFX900-NEXT:    global_store_dwordx4 v14, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v12, v4
; GFX90A-NEXT:    v_mov_b32_e32 v13, v5
; GFX90A-NEXT:    global_store_dwordx4 v14, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v14, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[6:13]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v12, v4
; GFX940-NEXT:    v_mov_b32_e32 v13, v5
; GFX940-NEXT:    global_store_dwordx4 v14, v[10:13], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 2>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__u_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v6
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v6
; GFX940-NEXT:    v_mov_b32_e32 v5, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v6
; GFX940-NEXT:    v_mov_b32_e32 v5, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__4_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v6
; GFX900-NEXT:    v_mov_b32_e32 v13, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, v6
; GFX90A-NEXT:    v_mov_b32_e32 v13, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v16, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v12, v6
; GFX940-NEXT:    v_mov_b32_e32 v13, v7
; GFX940-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_3(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, v6
; GFX900-NEXT:    v_mov_b32_e32 v15, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, v6
; GFX90A-NEXT:    v_mov_b32_e32 v15, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v16, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v14, v6
; GFX940-NEXT:    v_mov_b32_e32 v15, v7
; GFX940-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 3>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_4(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v4i64__u_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v0, v6
; GFX900-NEXT:    v_mov_b32_e32 v1, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v0, v6
; GFX90A-NEXT:    v_mov_b32_e32 v1, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, v6
; GFX940-NEXT:    v_mov_b32_e32 v1, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_4(ptr addrspace(1) inreg %ptr) {
; GFX9-LABEL: v_shuffle_v2i64_v4i64__4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v0
; GFX900-NEXT:    v_mov_b32_e32 v5, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v0
; GFX90A-NEXT:    v_mov_b32_e32 v5, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v0
; GFX940-NEXT:    v_mov_b32_e32 v5, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_4(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v0
; GFX900-NEXT:    v_mov_b32_e32 v7, v1
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v0
; GFX90A-NEXT:    v_mov_b32_e32 v7, v1
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v0
; GFX940-NEXT:    v_mov_b32_e32 v7, v1
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 4>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__u_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 poison, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx4 v10, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v10, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v10, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v4
; GFX940-NEXT:    v_mov_b32_e32 v3, v5
; GFX940-NEXT:    global_store_dwordx4 v10, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 0, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx4 v12, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v12, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v12, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v6
; GFX940-NEXT:    v_mov_b32_e32 v5, v7
; GFX940-NEXT:    global_store_dwordx4 v12, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 1, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v8
; GFX900-NEXT:    v_mov_b32_e32 v7, v9
; GFX900-NEXT:    global_store_dwordx4 v14, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v8
; GFX90A-NEXT:    v_mov_b32_e32 v7, v9
; GFX90A-NEXT:    global_store_dwordx4 v14, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v14, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[6:13]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v8
; GFX940-NEXT:    v_mov_b32_e32 v7, v9
; GFX940-NEXT:    global_store_dwordx4 v14, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 2, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, v6
; GFX900-NEXT:    v_mov_b32_e32 v9, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, v6
; GFX90A-NEXT:    v_mov_b32_e32 v9, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[8:11], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v16, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v8, v6
; GFX940-NEXT:    v_mov_b32_e32 v9, v7
; GFX940-NEXT:    global_store_dwordx4 v16, v[8:11], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 3, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__4_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 4, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v2
; GFX900-NEXT:    v_mov_b32_e32 v5, v3
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v2
; GFX90A-NEXT:    v_mov_b32_e32 v5, v3
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v2
; GFX940-NEXT:    v_mov_b32_e32 v5, v3
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_5(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v2
; GFX900-NEXT:    v_mov_b32_e32 v7, v3
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v2
; GFX90A-NEXT:    v_mov_b32_e32 v7, v3
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v2
; GFX940-NEXT:    v_mov_b32_e32 v7, v3
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 5>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__u_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 poison, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx4 v10, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v10, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v10, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v6
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    global_store_dwordx4 v10, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 0, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v8
; GFX900-NEXT:    v_mov_b32_e32 v5, v9
; GFX900-NEXT:    global_store_dwordx4 v12, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v8
; GFX90A-NEXT:    v_mov_b32_e32 v5, v9
; GFX90A-NEXT:    global_store_dwordx4 v12, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v12, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v8
; GFX940-NEXT:    v_mov_b32_e32 v5, v9
; GFX940-NEXT:    global_store_dwordx4 v12, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 1, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v10
; GFX900-NEXT:    v_mov_b32_e32 v7, v11
; GFX900-NEXT:    global_store_dwordx4 v14, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v10
; GFX90A-NEXT:    v_mov_b32_e32 v7, v11
; GFX90A-NEXT:    global_store_dwordx4 v14, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v14, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[6:13]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v10
; GFX940-NEXT:    v_mov_b32_e32 v7, v11
; GFX940-NEXT:    global_store_dwordx4 v14, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 2, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, v6
; GFX900-NEXT:    v_mov_b32_e32 v11, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, v6
; GFX90A-NEXT:    v_mov_b32_e32 v11, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[10:13], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v16, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v10, v6
; GFX940-NEXT:    v_mov_b32_e32 v11, v7
; GFX940-NEXT:    global_store_dwordx4 v16, v[10:13], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 3, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__4_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v4
; GFX900-NEXT:    v_mov_b32_e32 v3, v5
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__4_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v4
; GFX90A-NEXT:    v_mov_b32_e32 v3, v5
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__4_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v4
; GFX940-NEXT:    v_mov_b32_e32 v3, v5
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 4, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_6(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v4
; GFX900-NEXT:    v_mov_b32_e32 v7, v5
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v4
; GFX90A-NEXT:    v_mov_b32_e32 v7, v5
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v4
; GFX940-NEXT:    v_mov_b32_e32 v7, v5
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 6>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__u_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__u_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 poison, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__0_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__0_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[2:9]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v10, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v8
; GFX900-NEXT:    v_mov_b32_e32 v3, v9
; GFX900-NEXT:    global_store_dwordx4 v10, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__0_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[2:9]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v10, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v8
; GFX90A-NEXT:    v_mov_b32_e32 v3, v9
; GFX90A-NEXT:    global_store_dwordx4 v10, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__0_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v10, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[2:9]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v8
; GFX940-NEXT:    v_mov_b32_e32 v3, v9
; GFX940-NEXT:    global_store_dwordx4 v10, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 0, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__1_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v10
; GFX900-NEXT:    v_mov_b32_e32 v5, v11
; GFX900-NEXT:    global_store_dwordx4 v12, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v10
; GFX90A-NEXT:    v_mov_b32_e32 v5, v11
; GFX90A-NEXT:    global_store_dwordx4 v12, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__1_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v12, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v10
; GFX940-NEXT:    v_mov_b32_e32 v5, v11
; GFX940-NEXT:    global_store_dwordx4 v12, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 1, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__2_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__2_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[6:13]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v14, 0
; GFX900-NEXT:    v_mov_b32_e32 v6, v12
; GFX900-NEXT:    v_mov_b32_e32 v7, v13
; GFX900-NEXT:    global_store_dwordx4 v14, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__2_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[6:13]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v14, 0
; GFX90A-NEXT:    v_mov_b32_e32 v6, v12
; GFX90A-NEXT:    v_mov_b32_e32 v7, v13
; GFX90A-NEXT:    global_store_dwordx4 v14, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__2_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v14, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[6:13]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v6, v12
; GFX940-NEXT:    v_mov_b32_e32 v7, v13
; GFX940-NEXT:    global_store_dwordx4 v14, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 2, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__3_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v16, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v12, v6
; GFX900-NEXT:    v_mov_b32_e32 v13, v7
; GFX900-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v16, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v12, v6
; GFX90A-NEXT:    v_mov_b32_e32 v13, v7
; GFX90A-NEXT:    global_store_dwordx4 v16, v[12:15], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__3_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v16, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    v_mov_b32_e32 v12, v6
; GFX940-NEXT:    v_mov_b32_e32 v13, v7
; GFX940-NEXT:    global_store_dwordx4 v16, v[12:15], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 3, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__4_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__4_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v2, v6
; GFX900-NEXT:    v_mov_b32_e32 v3, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__4_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v2, v6
; GFX90A-NEXT:    v_mov_b32_e32 v3, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[0:3], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__4_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v2, v6
; GFX940-NEXT:    v_mov_b32_e32 v3, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 4, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__5_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__5_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    v_mov_b32_e32 v4, v6
; GFX900-NEXT:    v_mov_b32_e32 v5, v7
; GFX900-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__5_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    v_mov_b32_e32 v4, v6
; GFX90A-NEXT:    v_mov_b32_e32 v5, v7
; GFX90A-NEXT:    global_store_dwordx4 v8, v[2:5], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__5_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    v_mov_b32_e32 v4, v6
; GFX940-NEXT:    v_mov_b32_e32 v5, v7
; GFX940-NEXT:    global_store_dwordx4 v8, v[2:5], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @v_shuffle_v2i64_v4i64__6_7(ptr addrspace(1) inreg %ptr) {
; GFX900-LABEL: v_shuffle_v2i64_v4i64__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_mov_b32_e32 v8, 0
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def v[0:7]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: v_shuffle_v2i64_v4i64__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    v_mov_b32_e32 v8, 0
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def v[0:7]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    global_store_dwordx4 v8, v[4:7], s[16:17]
; GFX90A-NEXT:    s_waitcnt vmcnt(0)
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: v_shuffle_v2i64_v4i64__6_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v8, 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def v[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=v"()
  %vec1 = call <4 x i64> asm "; def $0", "=v"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 7>
  store <2 x i64> %shuf, ptr addrspace(1) %ptr, align 16
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_u() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__u_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> poison
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_u() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__0_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__0_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__0_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_u() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__1_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__1_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__1_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_u() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__2_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__2_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__2_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_u() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__3_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__3_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__3_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_u() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__4_u:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_u() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__5_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__5_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__5_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_u() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__6_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__6_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__6_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_u() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__7_u:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__7_u:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__7_u:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 poison>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_0() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__7_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__7_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__7_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s10
; GFX940-NEXT:    s_mov_b32 s9, s11
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_1() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__7_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__7_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__7_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_2() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__7_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__7_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__7_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s14
; GFX940-NEXT:    s_mov_b32 s9, s15
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_3() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__7_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__7_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__7_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_4() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__7_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__7_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__7_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_5() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__7_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_6() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__7_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__7_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__7_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__7_7() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__7_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 7, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_0() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__u_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__u_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__u_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_0() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__0_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> zeroinitializer
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_0() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__1_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__1_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__1_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_0() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__2_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s4
; GFX9-NEXT:    s_mov_b32 s11, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_0() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__3_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__3_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__3_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_0() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__4_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__4_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__4_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_0() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__5_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__5_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__5_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_0() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__6_0:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__6_0:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__6_0:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 0>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_1() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__u_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__u_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__u_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_1() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__0_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__0_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__0_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_1() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__1_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_1() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__2_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_1() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__3_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s14
; GFX9-NEXT:    s_mov_b32 s9, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_1() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__4_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__4_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__4_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_1() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__5_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__5_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__5_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_1() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__6_1:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s14
; GFX900-NEXT:    s_mov_b32 s11, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__6_1:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s14
; GFX90A-NEXT:    s_mov_b32 s11, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__6_1:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s2
; GFX940-NEXT:    s_mov_b32 s11, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 1>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_2() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__u_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s8
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__u_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s8
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__u_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_2() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__0_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_2() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__1_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__1_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__1_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_2() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__2_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_2() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__3_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__3_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__3_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_2() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__4_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s8
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__4_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s8
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__4_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_2() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__5_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__5_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__5_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s10
; GFX940-NEXT:    s_mov_b32 s9, s11
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_2() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__6_2:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__6_2:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__6_2:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s12
; GFX940-NEXT:    s_mov_b32 s11, s13
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 2>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_3() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__u_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__u_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__u_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_3() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__0_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s14
; GFX9-NEXT:    s_mov_b32 s11, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_3() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__1_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s6
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_3() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__2_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__2_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__2_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_3() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__3_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_3() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__4_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__4_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__4_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_3() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__5_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__5_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__5_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_3() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__6_3:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s14
; GFX900-NEXT:    s_mov_b32 s11, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__6_3:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s14
; GFX90A-NEXT:    s_mov_b32 s11, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__6_3:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s14
; GFX940-NEXT:    s_mov_b32 s11, s15
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 3>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_4() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__u_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 poison, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_4() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__0_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__0_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__0_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 0, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_4() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__1_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__1_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__1_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 1, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_4() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__2_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__2_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__2_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 2, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_4() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__3_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__3_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__3_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 3, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_4() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__4_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> poison, <2 x i32> <i32 4, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_4() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__5_4:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s4
; GFX900-NEXT:    s_mov_b32 s11, s5
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__5_4:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s4
; GFX90A-NEXT:    s_mov_b32 s11, s5
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__5_4:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    s_mov_b32 s10, s0
; GFX940-NEXT:    s_mov_b32 s11, s1
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_4() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__6_4:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s4
; GFX9-NEXT:    s_mov_b32 s11, s5
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 4>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_5() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__u_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__u_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__u_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 poison, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_5() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__0_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s14
; GFX900-NEXT:    s_mov_b32 s11, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__0_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s14
; GFX90A-NEXT:    s_mov_b32 s11, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__0_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s2
; GFX940-NEXT:    s_mov_b32 s11, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 0, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_5() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__1_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__1_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__1_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 1, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_5() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__2_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s14
; GFX900-NEXT:    s_mov_b32 s11, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__2_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s14
; GFX90A-NEXT:    s_mov_b32 s11, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__2_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s2
; GFX940-NEXT:    s_mov_b32 s11, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 2, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_5() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__3_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s18
; GFX900-NEXT:    s_mov_b32 s9, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__3_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s18
; GFX90A-NEXT:    s_mov_b32 s9, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__3_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 3, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_5() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__4_5:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__4_5:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__4_5:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 4, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_5() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__5_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s10
; GFX9-NEXT:    s_mov_b32 s9, s11
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_5() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__6_5:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s6
; GFX9-NEXT:    s_mov_b32 s11, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 5>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_6() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__u_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s8
; GFX900-NEXT:    s_mov_b32 s11, s9
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__u_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s8
; GFX90A-NEXT:    s_mov_b32 s11, s9
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__u_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 poison, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_6() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__0_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__0_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__0_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 0, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_6() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__1_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s6
; GFX900-NEXT:    s_mov_b32 s9, s7
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__1_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s6
; GFX90A-NEXT:    s_mov_b32 s9, s7
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__1_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    s_mov_b32 s10, s12
; GFX940-NEXT:    s_mov_b32 s11, s13
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 1, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_6() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__2_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__2_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__2_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 2, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_6() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__3_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s16
; GFX900-NEXT:    s_mov_b32 s11, s17
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__3_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s16
; GFX90A-NEXT:    s_mov_b32 s11, s17
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__3_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s6
; GFX940-NEXT:    s_mov_b32 s9, s7
; GFX940-NEXT:    s_mov_b32 s10, s12
; GFX940-NEXT:    s_mov_b32 s11, s13
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 3, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_6() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__4_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s12
; GFX9-NEXT:    s_mov_b32 s11, s13
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 4, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_6() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__5_6:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s10
; GFX900-NEXT:    s_mov_b32 s9, s11
; GFX900-NEXT:    s_mov_b32 s10, s12
; GFX900-NEXT:    s_mov_b32 s11, s13
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__5_6:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s10
; GFX90A-NEXT:    s_mov_b32 s9, s11
; GFX90A-NEXT:    s_mov_b32 s10, s12
; GFX90A-NEXT:    s_mov_b32 s11, s13
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__5_6:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    s_mov_b32 s10, s4
; GFX940-NEXT:    s_mov_b32 s11, s5
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_6() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__6_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s8
; GFX9-NEXT:    s_mov_b32 s11, s9
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 6>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__u_7() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__u_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__u_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__u_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 poison, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__0_7() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__0_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s18
; GFX900-NEXT:    s_mov_b32 s11, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__0_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s18
; GFX90A-NEXT:    s_mov_b32 s11, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__0_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s6
; GFX940-NEXT:    s_mov_b32 s11, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 0, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__1_7() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__1_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__1_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__1_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s2
; GFX940-NEXT:    s_mov_b32 s9, s3
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 1, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__2_7() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__2_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[12:19]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s10, s18
; GFX900-NEXT:    s_mov_b32 s11, s19
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__2_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[12:19]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s10, s18
; GFX90A-NEXT:    s_mov_b32 s11, s19
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__2_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[0:7]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s10, s6
; GFX940-NEXT:    s_mov_b32 s11, s7
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 2, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__3_7() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__3_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[8:15]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_mov_b32 s8, s14
; GFX900-NEXT:    s_mov_b32 s9, s15
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__3_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[8:15]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_mov_b32 s8, s14
; GFX90A-NEXT:    s_mov_b32 s9, s15
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__3_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[8:15]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_mov_b32 s8, s14
; GFX940-NEXT:    s_mov_b32 s9, s15
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 3, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__4_7() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__4_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[8:15]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s10, s14
; GFX9-NEXT:    s_mov_b32 s11, s15
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 4, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__5_7() {
; GFX9-LABEL: s_shuffle_v2i64_v4i64__5_7:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; def s[4:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_mov_b32 s8, s6
; GFX9-NEXT:    s_mov_b32 s9, s7
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s[8:11]
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 5, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}

define void @s_shuffle_v2i64_v4i64__6_7() {
; GFX900-LABEL: s_shuffle_v2i64_v4i64__6_7:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; def s[4:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    ;;#ASMSTART
; GFX900-NEXT:    ; use s[8:11]
; GFX900-NEXT:    ;;#ASMEND
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX90A-LABEL: s_shuffle_v2i64_v4i64__6_7:
; GFX90A:       ; %bb.0:
; GFX90A-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; def s[4:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    ;;#ASMSTART
; GFX90A-NEXT:    ; use s[8:11]
; GFX90A-NEXT:    ;;#ASMEND
; GFX90A-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: s_shuffle_v2i64_v4i64__6_7:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; def s[4:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_nop 0
; GFX940-NEXT:    ;;#ASMSTART
; GFX940-NEXT:    ; use s[8:11]
; GFX940-NEXT:    ;;#ASMEND
; GFX940-NEXT:    s_setpc_b64 s[30:31]
  %vec0 = call <4 x i64> asm "; def $0", "=s"()
  %vec1 = call <4 x i64> asm "; def $0", "=s"()
  %shuf = shufflevector <4 x i64> %vec0, <4 x i64> %vec1, <2 x i32> <i32 6, i32 7>
  call void asm sideeffect "; use $0", "{s[8:11]}"(<2 x i64> %shuf)
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX90APLUS: {{.*}}
