/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * BPF Disassembler                                                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTableBPF64[] = {
/* 0 */       MCD::OPC_ExtractField, 56, 8,  // Inst{63-56} ...
/* 3 */       MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 15
/* 7 */       MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 11 */      MCD::OPC_Decode, 200, 2, 0, // Opcode: ADD_ri_32, DecodeIdx: 0
/* 15 */      MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 23
/* 19 */      MCD::OPC_Decode, 230, 2, 1, // Opcode: JMP, DecodeIdx: 1
/* 23 */      MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 31
/* 27 */      MCD::OPC_Decode, 231, 2, 2, // Opcode: JMPL, DecodeIdx: 2
/* 31 */      MCD::OPC_FilterValue, 7, 8, 0, // Skip to: 43
/* 35 */      MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 39 */      MCD::OPC_Decode, 199, 2, 3, // Opcode: ADD_ri, DecodeIdx: 3
/* 43 */      MCD::OPC_FilterValue, 12, 8, 0, // Skip to: 55
/* 47 */      MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 51 */      MCD::OPC_Decode, 202, 2, 4, // Opcode: ADD_rr_32, DecodeIdx: 4
/* 55 */      MCD::OPC_FilterValue, 15, 8, 0, // Skip to: 67
/* 59 */      MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 63 */      MCD::OPC_Decode, 201, 2, 5, // Opcode: ADD_rr, DecodeIdx: 5
/* 67 */      MCD::OPC_FilterValue, 20, 8, 0, // Skip to: 79
/* 71 */      MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 75 */      MCD::OPC_Decode, 231, 3, 0, // Opcode: SUB_ri_32, DecodeIdx: 0
/* 79 */      MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 87
/* 83 */      MCD::OPC_Decode, 226, 2, 6, // Opcode: JEQ_ri, DecodeIdx: 6
/* 87 */      MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 95
/* 91 */      MCD::OPC_Decode, 227, 2, 7, // Opcode: JEQ_ri_32, DecodeIdx: 7
/* 95 */      MCD::OPC_FilterValue, 23, 8, 0, // Skip to: 107
/* 99 */      MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 103 */     MCD::OPC_Decode, 230, 3, 3, // Opcode: SUB_ri, DecodeIdx: 3
/* 107 */     MCD::OPC_FilterValue, 24, 19, 0, // Skip to: 130
/* 111 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 114 */     MCD::OPC_FilterValueOrFail, 0, 
/* 116 */     MCD::OPC_CheckField, 52, 4, 0, 4, 0, // Skip to: 126
/* 122 */     MCD::OPC_Decode, 164, 3, 8, // Opcode: LD_imm64, DecodeIdx: 8
/* 126 */     MCD::OPC_Decode, 165, 3, 9, // Opcode: LD_pseudo, DecodeIdx: 9
/* 130 */     MCD::OPC_FilterValue, 28, 8, 0, // Skip to: 142
/* 134 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 138 */     MCD::OPC_Decode, 233, 3, 4, // Opcode: SUB_rr_32, DecodeIdx: 4
/* 142 */     MCD::OPC_FilterValue, 29, 4, 0, // Skip to: 150
/* 146 */     MCD::OPC_Decode, 228, 2, 10, // Opcode: JEQ_rr, DecodeIdx: 10
/* 150 */     MCD::OPC_FilterValue, 30, 4, 0, // Skip to: 158
/* 154 */     MCD::OPC_Decode, 229, 2, 11, // Opcode: JEQ_rr_32, DecodeIdx: 11
/* 158 */     MCD::OPC_FilterValue, 31, 8, 0, // Skip to: 170
/* 162 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 166 */     MCD::OPC_Decode, 232, 3, 5, // Opcode: SUB_rr, DecodeIdx: 5
/* 170 */     MCD::OPC_FilterValue, 32, 4, 0, // Skip to: 178
/* 174 */     MCD::OPC_Decode, 160, 3, 2, // Opcode: LD_ABS_W, DecodeIdx: 2
/* 178 */     MCD::OPC_FilterValue, 36, 8, 0, // Skip to: 190
/* 182 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 186 */     MCD::OPC_Decode, 184, 3, 0, // Opcode: MUL_ri_32, DecodeIdx: 0
/* 190 */     MCD::OPC_FilterValue, 37, 4, 0, // Skip to: 198
/* 194 */     MCD::OPC_Decode, 132, 3, 6, // Opcode: JUGT_ri, DecodeIdx: 6
/* 198 */     MCD::OPC_FilterValue, 38, 4, 0, // Skip to: 206
/* 202 */     MCD::OPC_Decode, 133, 3, 7, // Opcode: JUGT_ri_32, DecodeIdx: 7
/* 206 */     MCD::OPC_FilterValue, 39, 8, 0, // Skip to: 218
/* 210 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 214 */     MCD::OPC_Decode, 183, 3, 3, // Opcode: MUL_ri, DecodeIdx: 3
/* 218 */     MCD::OPC_FilterValue, 40, 4, 0, // Skip to: 226
/* 222 */     MCD::OPC_Decode, 159, 3, 2, // Opcode: LD_ABS_H, DecodeIdx: 2
/* 226 */     MCD::OPC_FilterValue, 44, 8, 0, // Skip to: 238
/* 230 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 234 */     MCD::OPC_Decode, 186, 3, 4, // Opcode: MUL_rr_32, DecodeIdx: 4
/* 238 */     MCD::OPC_FilterValue, 45, 4, 0, // Skip to: 246
/* 242 */     MCD::OPC_Decode, 134, 3, 10, // Opcode: JUGT_rr, DecodeIdx: 10
/* 246 */     MCD::OPC_FilterValue, 46, 4, 0, // Skip to: 254
/* 250 */     MCD::OPC_Decode, 135, 3, 11, // Opcode: JUGT_rr_32, DecodeIdx: 11
/* 254 */     MCD::OPC_FilterValue, 47, 8, 0, // Skip to: 266
/* 258 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 262 */     MCD::OPC_Decode, 185, 3, 5, // Opcode: MUL_rr, DecodeIdx: 5
/* 266 */     MCD::OPC_FilterValue, 48, 4, 0, // Skip to: 274
/* 270 */     MCD::OPC_Decode, 158, 3, 2, // Opcode: LD_ABS_B, DecodeIdx: 2
/* 274 */     MCD::OPC_FilterValue, 52, 17, 0, // Skip to: 295
/* 278 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 281 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 289
/* 285 */     MCD::OPC_Decode, 220, 2, 0, // Opcode: DIV_ri_32, DecodeIdx: 0
/* 289 */     MCD::OPC_FilterValueOrFail, 1, 
/* 291 */     MCD::OPC_Decode, 196, 3, 0, // Opcode: SDIV_ri_32, DecodeIdx: 0
/* 295 */     MCD::OPC_FilterValue, 53, 4, 0, // Skip to: 303
/* 299 */     MCD::OPC_Decode, 128, 3, 6, // Opcode: JUGE_ri, DecodeIdx: 6
/* 303 */     MCD::OPC_FilterValue, 54, 4, 0, // Skip to: 311
/* 307 */     MCD::OPC_Decode, 129, 3, 7, // Opcode: JUGE_ri_32, DecodeIdx: 7
/* 311 */     MCD::OPC_FilterValue, 55, 17, 0, // Skip to: 332
/* 315 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 318 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 326
/* 322 */     MCD::OPC_Decode, 219, 2, 3, // Opcode: DIV_ri, DecodeIdx: 3
/* 326 */     MCD::OPC_FilterValueOrFail, 1, 
/* 328 */     MCD::OPC_Decode, 195, 3, 3, // Opcode: SDIV_ri, DecodeIdx: 3
/* 332 */     MCD::OPC_FilterValue, 60, 17, 0, // Skip to: 353
/* 336 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 339 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 347
/* 343 */     MCD::OPC_Decode, 222, 2, 4, // Opcode: DIV_rr_32, DecodeIdx: 4
/* 347 */     MCD::OPC_FilterValueOrFail, 1, 
/* 349 */     MCD::OPC_Decode, 198, 3, 4, // Opcode: SDIV_rr_32, DecodeIdx: 4
/* 353 */     MCD::OPC_FilterValue, 61, 4, 0, // Skip to: 361
/* 357 */     MCD::OPC_Decode, 130, 3, 10, // Opcode: JUGE_rr, DecodeIdx: 10
/* 361 */     MCD::OPC_FilterValue, 62, 4, 0, // Skip to: 369
/* 365 */     MCD::OPC_Decode, 131, 3, 11, // Opcode: JUGE_rr_32, DecodeIdx: 11
/* 369 */     MCD::OPC_FilterValue, 63, 17, 0, // Skip to: 390
/* 373 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 376 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 384
/* 380 */     MCD::OPC_Decode, 221, 2, 5, // Opcode: DIV_rr, DecodeIdx: 5
/* 384 */     MCD::OPC_FilterValueOrFail, 1, 
/* 386 */     MCD::OPC_Decode, 197, 3, 5, // Opcode: SDIV_rr, DecodeIdx: 5
/* 390 */     MCD::OPC_FilterValue, 64, 4, 0, // Skip to: 398
/* 394 */     MCD::OPC_Decode, 163, 3, 12, // Opcode: LD_IND_W, DecodeIdx: 12
/* 398 */     MCD::OPC_FilterValue, 68, 8, 0, // Skip to: 410
/* 402 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 406 */     MCD::OPC_Decode, 191, 3, 0, // Opcode: OR_ri_32, DecodeIdx: 0
/* 410 */     MCD::OPC_FilterValue, 69, 4, 0, // Skip to: 418
/* 414 */     MCD::OPC_Decode, 236, 2, 6, // Opcode: JSET_ri, DecodeIdx: 6
/* 418 */     MCD::OPC_FilterValue, 70, 4, 0, // Skip to: 426
/* 422 */     MCD::OPC_Decode, 237, 2, 7, // Opcode: JSET_ri_32, DecodeIdx: 7
/* 426 */     MCD::OPC_FilterValue, 71, 8, 0, // Skip to: 438
/* 430 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 434 */     MCD::OPC_Decode, 190, 3, 3, // Opcode: OR_ri, DecodeIdx: 3
/* 438 */     MCD::OPC_FilterValue, 72, 4, 0, // Skip to: 446
/* 442 */     MCD::OPC_Decode, 162, 3, 12, // Opcode: LD_IND_H, DecodeIdx: 12
/* 446 */     MCD::OPC_FilterValue, 76, 8, 0, // Skip to: 458
/* 450 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 454 */     MCD::OPC_Decode, 193, 3, 4, // Opcode: OR_rr_32, DecodeIdx: 4
/* 458 */     MCD::OPC_FilterValue, 77, 4, 0, // Skip to: 466
/* 462 */     MCD::OPC_Decode, 238, 2, 10, // Opcode: JSET_rr, DecodeIdx: 10
/* 466 */     MCD::OPC_FilterValue, 78, 4, 0, // Skip to: 474
/* 470 */     MCD::OPC_Decode, 239, 2, 11, // Opcode: JSET_rr_32, DecodeIdx: 11
/* 474 */     MCD::OPC_FilterValue, 79, 8, 0, // Skip to: 486
/* 478 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 482 */     MCD::OPC_Decode, 192, 3, 5, // Opcode: OR_rr, DecodeIdx: 5
/* 486 */     MCD::OPC_FilterValue, 80, 4, 0, // Skip to: 494
/* 490 */     MCD::OPC_Decode, 161, 3, 12, // Opcode: LD_IND_B, DecodeIdx: 12
/* 494 */     MCD::OPC_FilterValue, 84, 8, 0, // Skip to: 506
/* 498 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 502 */     MCD::OPC_Decode, 204, 2, 0, // Opcode: AND_ri_32, DecodeIdx: 0
/* 506 */     MCD::OPC_FilterValue, 85, 4, 0, // Skip to: 514
/* 510 */     MCD::OPC_Decode, 232, 2, 6, // Opcode: JNE_ri, DecodeIdx: 6
/* 514 */     MCD::OPC_FilterValue, 86, 4, 0, // Skip to: 522
/* 518 */     MCD::OPC_Decode, 233, 2, 7, // Opcode: JNE_ri_32, DecodeIdx: 7
/* 522 */     MCD::OPC_FilterValue, 87, 8, 0, // Skip to: 534
/* 526 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 530 */     MCD::OPC_Decode, 203, 2, 3, // Opcode: AND_ri, DecodeIdx: 3
/* 534 */     MCD::OPC_FilterValue, 92, 8, 0, // Skip to: 546
/* 538 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 542 */     MCD::OPC_Decode, 206, 2, 4, // Opcode: AND_rr_32, DecodeIdx: 4
/* 546 */     MCD::OPC_FilterValue, 93, 4, 0, // Skip to: 554
/* 550 */     MCD::OPC_Decode, 234, 2, 10, // Opcode: JNE_rr, DecodeIdx: 10
/* 554 */     MCD::OPC_FilterValue, 94, 4, 0, // Skip to: 562
/* 558 */     MCD::OPC_Decode, 235, 2, 11, // Opcode: JNE_rr_32, DecodeIdx: 11
/* 562 */     MCD::OPC_FilterValue, 95, 8, 0, // Skip to: 574
/* 566 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 570 */     MCD::OPC_Decode, 205, 2, 5, // Opcode: AND_rr, DecodeIdx: 5
/* 574 */     MCD::OPC_FilterValue, 97, 4, 0, // Skip to: 582
/* 578 */     MCD::OPC_Decode, 154, 3, 13, // Opcode: LDW, DecodeIdx: 13
/* 582 */     MCD::OPC_FilterValue, 98, 4, 0, // Skip to: 590
/* 586 */     MCD::OPC_Decode, 229, 3, 14, // Opcode: STW_imm, DecodeIdx: 14
/* 590 */     MCD::OPC_FilterValue, 99, 4, 0, // Skip to: 598
/* 594 */     MCD::OPC_Decode, 226, 3, 15, // Opcode: STW, DecodeIdx: 15
/* 598 */     MCD::OPC_FilterValue, 100, 8, 0, // Skip to: 610
/* 602 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 606 */     MCD::OPC_Decode, 200, 3, 0, // Opcode: SLL_ri_32, DecodeIdx: 0
/* 610 */     MCD::OPC_FilterValue, 101, 4, 0, // Skip to: 618
/* 614 */     MCD::OPC_Decode, 244, 2, 6, // Opcode: JSGT_ri, DecodeIdx: 6
/* 618 */     MCD::OPC_FilterValue, 102, 4, 0, // Skip to: 626
/* 622 */     MCD::OPC_Decode, 245, 2, 7, // Opcode: JSGT_ri_32, DecodeIdx: 7
/* 626 */     MCD::OPC_FilterValue, 103, 8, 0, // Skip to: 638
/* 630 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 634 */     MCD::OPC_Decode, 199, 3, 3, // Opcode: SLL_ri, DecodeIdx: 3
/* 638 */     MCD::OPC_FilterValue, 105, 4, 0, // Skip to: 646
/* 642 */     MCD::OPC_Decode, 150, 3, 13, // Opcode: LDH, DecodeIdx: 13
/* 646 */     MCD::OPC_FilterValue, 106, 4, 0, // Skip to: 654
/* 650 */     MCD::OPC_Decode, 225, 3, 14, // Opcode: STH_imm, DecodeIdx: 14
/* 654 */     MCD::OPC_FilterValue, 107, 4, 0, // Skip to: 662
/* 658 */     MCD::OPC_Decode, 222, 3, 15, // Opcode: STH, DecodeIdx: 15
/* 662 */     MCD::OPC_FilterValue, 108, 8, 0, // Skip to: 674
/* 666 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 670 */     MCD::OPC_Decode, 202, 3, 4, // Opcode: SLL_rr_32, DecodeIdx: 4
/* 674 */     MCD::OPC_FilterValue, 109, 4, 0, // Skip to: 682
/* 678 */     MCD::OPC_Decode, 246, 2, 10, // Opcode: JSGT_rr, DecodeIdx: 10
/* 682 */     MCD::OPC_FilterValue, 110, 4, 0, // Skip to: 690
/* 686 */     MCD::OPC_Decode, 247, 2, 11, // Opcode: JSGT_rr_32, DecodeIdx: 11
/* 690 */     MCD::OPC_FilterValue, 111, 8, 0, // Skip to: 702
/* 694 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 698 */     MCD::OPC_Decode, 201, 3, 5, // Opcode: SLL_rr, DecodeIdx: 5
/* 702 */     MCD::OPC_FilterValue, 113, 4, 0, // Skip to: 710
/* 706 */     MCD::OPC_Decode, 144, 3, 13, // Opcode: LDB, DecodeIdx: 13
/* 710 */     MCD::OPC_FilterValue, 114, 4, 0, // Skip to: 718
/* 714 */     MCD::OPC_Decode, 218, 3, 14, // Opcode: STB_imm, DecodeIdx: 14
/* 718 */     MCD::OPC_FilterValue, 115, 4, 0, // Skip to: 726
/* 722 */     MCD::OPC_Decode, 215, 3, 15, // Opcode: STB, DecodeIdx: 15
/* 726 */     MCD::OPC_FilterValue, 116, 8, 0, // Skip to: 738
/* 730 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 734 */     MCD::OPC_Decode, 212, 3, 0, // Opcode: SRL_ri_32, DecodeIdx: 0
/* 738 */     MCD::OPC_FilterValue, 117, 4, 0, // Skip to: 746
/* 742 */     MCD::OPC_Decode, 240, 2, 6, // Opcode: JSGE_ri, DecodeIdx: 6
/* 746 */     MCD::OPC_FilterValue, 118, 4, 0, // Skip to: 754
/* 750 */     MCD::OPC_Decode, 241, 2, 7, // Opcode: JSGE_ri_32, DecodeIdx: 7
/* 754 */     MCD::OPC_FilterValue, 119, 8, 0, // Skip to: 766
/* 758 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 762 */     MCD::OPC_Decode, 211, 3, 3, // Opcode: SRL_ri, DecodeIdx: 3
/* 766 */     MCD::OPC_FilterValue, 121, 4, 0, // Skip to: 774
/* 770 */     MCD::OPC_Decode, 148, 3, 13, // Opcode: LDD, DecodeIdx: 13
/* 774 */     MCD::OPC_FilterValue, 122, 4, 0, // Skip to: 782
/* 778 */     MCD::OPC_Decode, 221, 3, 14, // Opcode: STD_imm, DecodeIdx: 14
/* 782 */     MCD::OPC_FilterValue, 123, 4, 0, // Skip to: 790
/* 786 */     MCD::OPC_Decode, 219, 3, 15, // Opcode: STD, DecodeIdx: 15
/* 790 */     MCD::OPC_FilterValue, 124, 8, 0, // Skip to: 802
/* 794 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 798 */     MCD::OPC_Decode, 214, 3, 4, // Opcode: SRL_rr_32, DecodeIdx: 4
/* 802 */     MCD::OPC_FilterValue, 125, 4, 0, // Skip to: 810
/* 806 */     MCD::OPC_Decode, 242, 2, 10, // Opcode: JSGE_rr, DecodeIdx: 10
/* 810 */     MCD::OPC_FilterValue, 126, 4, 0, // Skip to: 818
/* 814 */     MCD::OPC_Decode, 243, 2, 11, // Opcode: JSGE_rr_32, DecodeIdx: 11
/* 818 */     MCD::OPC_FilterValue, 127, 8, 0, // Skip to: 830
/* 822 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 826 */     MCD::OPC_Decode, 213, 3, 5, // Opcode: SRL_rr, DecodeIdx: 5
/* 830 */     MCD::OPC_FilterValue, 129, 1, 4, 0, // Skip to: 839
/* 835 */     MCD::OPC_Decode, 157, 3, 13, // Opcode: LDWSX, DecodeIdx: 13
/* 839 */     MCD::OPC_FilterValue, 132, 1, 4, 0, // Skip to: 848
/* 844 */     MCD::OPC_Decode, 187, 3, 16, // Opcode: NEG_32, DecodeIdx: 16
/* 848 */     MCD::OPC_FilterValue, 133, 1, 4, 0, // Skip to: 857
/* 853 */     MCD::OPC_Decode, 223, 2, 2, // Opcode: JAL, DecodeIdx: 2
/* 857 */     MCD::OPC_FilterValue, 135, 1, 4, 0, // Skip to: 866
/* 862 */     MCD::OPC_Decode, 188, 3, 17, // Opcode: NEG_64, DecodeIdx: 17
/* 866 */     MCD::OPC_FilterValue, 137, 1, 4, 0, // Skip to: 875
/* 871 */     MCD::OPC_Decode, 153, 3, 13, // Opcode: LDHSX, DecodeIdx: 13
/* 875 */     MCD::OPC_FilterValue, 141, 1, 4, 0, // Skip to: 884
/* 880 */     MCD::OPC_Decode, 224, 2, 18, // Opcode: JALX, DecodeIdx: 18
/* 884 */     MCD::OPC_FilterValue, 145, 1, 4, 0, // Skip to: 893
/* 889 */     MCD::OPC_Decode, 147, 3, 13, // Opcode: LDBSX, DecodeIdx: 13
/* 893 */     MCD::OPC_FilterValue, 148, 1, 17, 0, // Skip to: 915
/* 898 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 901 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 909
/* 905 */     MCD::OPC_Decode, 170, 3, 0, // Opcode: MOD_ri_32, DecodeIdx: 0
/* 909 */     MCD::OPC_FilterValueOrFail, 1, 
/* 911 */     MCD::OPC_Decode, 204, 3, 0, // Opcode: SMOD_ri_32, DecodeIdx: 0
/* 915 */     MCD::OPC_FilterValue, 149, 1, 8, 0, // Skip to: 928
/* 920 */     MCD::OPC_CheckFieldOrFail, 0, 32, 0, 
/* 924 */     MCD::OPC_Decode, 194, 3, 19, // Opcode: RET, DecodeIdx: 19
/* 928 */     MCD::OPC_FilterValue, 151, 1, 17, 0, // Skip to: 950
/* 933 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 936 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 944
/* 940 */     MCD::OPC_Decode, 169, 3, 3, // Opcode: MOD_ri, DecodeIdx: 3
/* 944 */     MCD::OPC_FilterValueOrFail, 1, 
/* 946 */     MCD::OPC_Decode, 203, 3, 3, // Opcode: SMOD_ri, DecodeIdx: 3
/* 950 */     MCD::OPC_FilterValue, 156, 1, 17, 0, // Skip to: 972
/* 955 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 958 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 966
/* 962 */     MCD::OPC_Decode, 172, 3, 4, // Opcode: MOD_rr_32, DecodeIdx: 4
/* 966 */     MCD::OPC_FilterValueOrFail, 1, 
/* 968 */     MCD::OPC_Decode, 206, 3, 4, // Opcode: SMOD_rr_32, DecodeIdx: 4
/* 972 */     MCD::OPC_FilterValue, 159, 1, 17, 0, // Skip to: 994
/* 977 */     MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 980 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 988
/* 984 */     MCD::OPC_Decode, 171, 3, 5, // Opcode: MOD_rr, DecodeIdx: 5
/* 988 */     MCD::OPC_FilterValueOrFail, 1, 
/* 990 */     MCD::OPC_Decode, 205, 3, 5, // Opcode: SMOD_rr, DecodeIdx: 5
/* 994 */     MCD::OPC_FilterValue, 164, 1, 8, 0, // Skip to: 1007
/* 999 */     MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1003 */    MCD::OPC_Decode, 252, 3, 0, // Opcode: XOR_ri_32, DecodeIdx: 0
/* 1007 */    MCD::OPC_FilterValue, 165, 1, 4, 0, // Skip to: 1016
/* 1012 */    MCD::OPC_Decode, 140, 3, 6, // Opcode: JULT_ri, DecodeIdx: 6
/* 1016 */    MCD::OPC_FilterValue, 166, 1, 4, 0, // Skip to: 1025
/* 1021 */    MCD::OPC_Decode, 141, 3, 7, // Opcode: JULT_ri_32, DecodeIdx: 7
/* 1025 */    MCD::OPC_FilterValue, 167, 1, 8, 0, // Skip to: 1038
/* 1030 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1034 */    MCD::OPC_Decode, 251, 3, 3, // Opcode: XOR_ri, DecodeIdx: 3
/* 1038 */    MCD::OPC_FilterValue, 172, 1, 8, 0, // Skip to: 1051
/* 1043 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1047 */    MCD::OPC_Decode, 254, 3, 4, // Opcode: XOR_rr_32, DecodeIdx: 4
/* 1051 */    MCD::OPC_FilterValue, 173, 1, 4, 0, // Skip to: 1060
/* 1056 */    MCD::OPC_Decode, 142, 3, 10, // Opcode: JULT_rr, DecodeIdx: 10
/* 1060 */    MCD::OPC_FilterValue, 174, 1, 4, 0, // Skip to: 1069
/* 1065 */    MCD::OPC_Decode, 143, 3, 11, // Opcode: JULT_rr_32, DecodeIdx: 11
/* 1069 */    MCD::OPC_FilterValue, 175, 1, 8, 0, // Skip to: 1082
/* 1074 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1078 */    MCD::OPC_Decode, 253, 3, 5, // Opcode: XOR_rr, DecodeIdx: 5
/* 1082 */    MCD::OPC_FilterValue, 180, 1, 8, 0, // Skip to: 1095
/* 1087 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1091 */    MCD::OPC_Decode, 180, 3, 20, // Opcode: MOV_ri_32, DecodeIdx: 20
/* 1095 */    MCD::OPC_FilterValue, 181, 1, 4, 0, // Skip to: 1104
/* 1100 */    MCD::OPC_Decode, 136, 3, 6, // Opcode: JULE_ri, DecodeIdx: 6
/* 1104 */    MCD::OPC_FilterValue, 182, 1, 4, 0, // Skip to: 1113
/* 1109 */    MCD::OPC_Decode, 137, 3, 7, // Opcode: JULE_ri_32, DecodeIdx: 7
/* 1113 */    MCD::OPC_FilterValue, 183, 1, 8, 0, // Skip to: 1126
/* 1118 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1122 */    MCD::OPC_Decode, 179, 3, 8, // Opcode: MOV_ri, DecodeIdx: 8
/* 1126 */    MCD::OPC_FilterValue, 188, 1, 25, 0, // Skip to: 1156
/* 1131 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1134 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1142
/* 1138 */    MCD::OPC_Decode, 182, 3, 21, // Opcode: MOV_rr_32, DecodeIdx: 21
/* 1142 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 1150
/* 1146 */    MCD::OPC_Decode, 176, 3, 21, // Opcode: MOVSX_rr_32_8, DecodeIdx: 21
/* 1150 */    MCD::OPC_FilterValueOrFail, 16, 
/* 1152 */    MCD::OPC_Decode, 175, 3, 21, // Opcode: MOVSX_rr_32_16, DecodeIdx: 21
/* 1156 */    MCD::OPC_FilterValue, 189, 1, 4, 0, // Skip to: 1165
/* 1161 */    MCD::OPC_Decode, 138, 3, 10, // Opcode: JULE_rr, DecodeIdx: 10
/* 1165 */    MCD::OPC_FilterValue, 190, 1, 4, 0, // Skip to: 1174
/* 1170 */    MCD::OPC_Decode, 139, 3, 11, // Opcode: JULE_rr_32, DecodeIdx: 11
/* 1174 */    MCD::OPC_FilterValue, 191, 1, 41, 0, // Skip to: 1220
/* 1179 */    MCD::OPC_ExtractField, 32, 16,  // Inst{47-32} ...
/* 1182 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1190
/* 1186 */    MCD::OPC_Decode, 181, 3, 22, // Opcode: MOV_rr, DecodeIdx: 22
/* 1190 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1198
/* 1194 */    MCD::OPC_Decode, 198, 2, 23, // Opcode: ADDR_SPACE_CAST, DecodeIdx: 23
/* 1198 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 1206
/* 1202 */    MCD::OPC_Decode, 177, 3, 22, // Opcode: MOVSX_rr_8, DecodeIdx: 22
/* 1206 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 1214
/* 1210 */    MCD::OPC_Decode, 173, 3, 22, // Opcode: MOVSX_rr_16, DecodeIdx: 22
/* 1214 */    MCD::OPC_FilterValueOrFail, 32, 
/* 1216 */    MCD::OPC_Decode, 174, 3, 22, // Opcode: MOVSX_rr_32, DecodeIdx: 22
/* 1220 */    MCD::OPC_FilterValue, 195, 1, 8, 0, // Skip to: 1233
/* 1225 */    MCD::OPC_CheckFieldOrFail, 4, 4, 0, 
/* 1229 */    MCD::OPC_Decode, 235, 3, 24, // Opcode: XADDW, DecodeIdx: 24
/* 1233 */    MCD::OPC_FilterValue, 196, 1, 8, 0, // Skip to: 1246
/* 1238 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1242 */    MCD::OPC_Decode, 208, 3, 0, // Opcode: SRA_ri_32, DecodeIdx: 0
/* 1246 */    MCD::OPC_FilterValue, 197, 1, 4, 0, // Skip to: 1255
/* 1251 */    MCD::OPC_Decode, 252, 2, 6, // Opcode: JSLT_ri, DecodeIdx: 6
/* 1255 */    MCD::OPC_FilterValue, 198, 1, 4, 0, // Skip to: 1264
/* 1260 */    MCD::OPC_Decode, 253, 2, 7, // Opcode: JSLT_ri_32, DecodeIdx: 7
/* 1264 */    MCD::OPC_FilterValue, 199, 1, 8, 0, // Skip to: 1277
/* 1269 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1273 */    MCD::OPC_Decode, 207, 3, 3, // Opcode: SRA_ri, DecodeIdx: 3
/* 1277 */    MCD::OPC_FilterValue, 204, 1, 8, 0, // Skip to: 1290
/* 1282 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1286 */    MCD::OPC_Decode, 210, 3, 4, // Opcode: SRA_rr_32, DecodeIdx: 4
/* 1290 */    MCD::OPC_FilterValue, 205, 1, 4, 0, // Skip to: 1299
/* 1295 */    MCD::OPC_Decode, 254, 2, 10, // Opcode: JSLT_rr, DecodeIdx: 10
/* 1299 */    MCD::OPC_FilterValue, 206, 1, 4, 0, // Skip to: 1308
/* 1304 */    MCD::OPC_Decode, 255, 2, 11, // Opcode: JSLT_rr_32, DecodeIdx: 11
/* 1308 */    MCD::OPC_FilterValue, 207, 1, 8, 0, // Skip to: 1321
/* 1313 */    MCD::OPC_CheckFieldOrFail, 32, 16, 0, 
/* 1317 */    MCD::OPC_Decode, 209, 3, 5, // Opcode: SRA_rr, DecodeIdx: 5
/* 1321 */    MCD::OPC_FilterValue, 212, 1, 25, 0, // Skip to: 1351
/* 1326 */    MCD::OPC_ExtractField, 0, 32,  // Inst{31-0} ...
/* 1329 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 1337
/* 1333 */    MCD::OPC_Decode, 166, 3, 17, // Opcode: LE16, DecodeIdx: 17
/* 1337 */    MCD::OPC_FilterValue, 32, 4, 0, // Skip to: 1345
/* 1341 */    MCD::OPC_Decode, 167, 3, 17, // Opcode: LE32, DecodeIdx: 17
/* 1345 */    MCD::OPC_FilterValueOrFail, 64, 
/* 1347 */    MCD::OPC_Decode, 168, 3, 17, // Opcode: LE64, DecodeIdx: 17
/* 1351 */    MCD::OPC_FilterValue, 213, 1, 4, 0, // Skip to: 1360
/* 1356 */    MCD::OPC_Decode, 248, 2, 6, // Opcode: JSLE_ri, DecodeIdx: 6
/* 1360 */    MCD::OPC_FilterValue, 214, 1, 4, 0, // Skip to: 1369
/* 1365 */    MCD::OPC_Decode, 249, 2, 7, // Opcode: JSLE_ri_32, DecodeIdx: 7
/* 1369 */    MCD::OPC_FilterValue, 215, 1, 25, 0, // Skip to: 1399
/* 1374 */    MCD::OPC_ExtractField, 0, 32,  // Inst{31-0} ...
/* 1377 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 1385
/* 1381 */    MCD::OPC_Decode, 210, 2, 17, // Opcode: BSWAP16, DecodeIdx: 17
/* 1385 */    MCD::OPC_FilterValue, 32, 4, 0, // Skip to: 1393
/* 1389 */    MCD::OPC_Decode, 211, 2, 17, // Opcode: BSWAP32, DecodeIdx: 17
/* 1393 */    MCD::OPC_FilterValueOrFail, 64, 
/* 1395 */    MCD::OPC_Decode, 212, 2, 17, // Opcode: BSWAP64, DecodeIdx: 17
/* 1399 */    MCD::OPC_FilterValue, 219, 1, 119, 0, // Skip to: 1523
/* 1404 */    MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 1407 */    MCD::OPC_FilterValue, 0, 24, 0, // Skip to: 1435
/* 1411 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 1421
/* 1417 */    MCD::OPC_Decode, 241, 3, 24, // Opcode: XFADDD, DecodeIdx: 24
/* 1421 */    MCD::OPC_CheckField, 8, 1, 1, 4, 0, // Skip to: 1431
/* 1427 */    MCD::OPC_Decode, 149, 3, 13, // Opcode: LDDACQ, DecodeIdx: 13
/* 1431 */    MCD::OPC_Decode, 234, 3, 24, // Opcode: XADDD, DecodeIdx: 24
/* 1435 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 1447
/* 1439 */    MCD::OPC_CheckFieldOrFail, 8, 1, 1, 
/* 1443 */    MCD::OPC_Decode, 220, 3, 15, // Opcode: STDREL, DecodeIdx: 15
/* 1447 */    MCD::OPC_FilterValue, 4, 14, 0, // Skip to: 1465
/* 1451 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 1461
/* 1457 */    MCD::OPC_Decode, 245, 3, 24, // Opcode: XFORD, DecodeIdx: 24
/* 1461 */    MCD::OPC_Decode, 249, 3, 24, // Opcode: XORD, DecodeIdx: 24
/* 1465 */    MCD::OPC_FilterValue, 5, 14, 0, // Skip to: 1483
/* 1469 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 1479
/* 1475 */    MCD::OPC_Decode, 243, 3, 24, // Opcode: XFANDD, DecodeIdx: 24
/* 1479 */    MCD::OPC_Decode, 237, 3, 24, // Opcode: XANDD, DecodeIdx: 24
/* 1483 */    MCD::OPC_FilterValue, 10, 14, 0, // Skip to: 1501
/* 1487 */    MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 1497
/* 1493 */    MCD::OPC_Decode, 247, 3, 24, // Opcode: XFXORD, DecodeIdx: 24
/* 1497 */    MCD::OPC_Decode, 255, 3, 24, // Opcode: XXORD, DecodeIdx: 24
/* 1501 */    MCD::OPC_FilterValue, 14, 8, 0, // Skip to: 1513
/* 1505 */    MCD::OPC_CheckFieldOrFail, 0, 4, 1, 
/* 1509 */    MCD::OPC_Decode, 239, 3, 24, // Opcode: XCHGD, DecodeIdx: 24
/* 1513 */    MCD::OPC_FilterValueOrFail, 15, 
/* 1515 */    MCD::OPC_CheckFieldOrFail, 0, 4, 1, 
/* 1519 */    MCD::OPC_Decode, 213, 2, 25, // Opcode: CMPXCHGD, DecodeIdx: 25
/* 1523 */    MCD::OPC_FilterValue, 220, 1, 25, 0, // Skip to: 1553
/* 1528 */    MCD::OPC_ExtractField, 0, 32,  // Inst{31-0} ...
/* 1531 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 1539
/* 1535 */    MCD::OPC_Decode, 207, 2, 17, // Opcode: BE16, DecodeIdx: 17
/* 1539 */    MCD::OPC_FilterValue, 32, 4, 0, // Skip to: 1547
/* 1543 */    MCD::OPC_Decode, 208, 2, 17, // Opcode: BE32, DecodeIdx: 17
/* 1547 */    MCD::OPC_FilterValueOrFail, 64, 
/* 1549 */    MCD::OPC_Decode, 209, 2, 17, // Opcode: BE64, DecodeIdx: 17
/* 1553 */    MCD::OPC_FilterValue, 221, 1, 4, 0, // Skip to: 1562
/* 1558 */    MCD::OPC_Decode, 250, 2, 10, // Opcode: JSLE_rr, DecodeIdx: 10
/* 1562 */    MCD::OPC_FilterValue, 222, 1, 4, 0, // Skip to: 1571
/* 1567 */    MCD::OPC_Decode, 251, 2, 11, // Opcode: JSLE_rr_32, DecodeIdx: 11
/* 1571 */    MCD::OPC_FilterValueOrFail, 229, 1, 
/* 1574 */    MCD::OPC_Decode, 225, 2, 1, // Opcode: JCOND, DecodeIdx: 1
/* 1578 */    MCD::OPC_Fail,
  0
};

static const uint8_t DecoderTableBPFALU3264[] = {
/* 0 */       MCD::OPC_ExtractField, 56, 8,  // Inst{63-56} ...
/* 3 */       MCD::OPC_FilterValue, 97, 4, 0, // Skip to: 11
/* 7 */       MCD::OPC_Decode, 155, 3, 26, // Opcode: LDW32, DecodeIdx: 26
/* 11 */      MCD::OPC_FilterValue, 99, 4, 0, // Skip to: 19
/* 15 */      MCD::OPC_Decode, 227, 3, 27, // Opcode: STW32, DecodeIdx: 27
/* 19 */      MCD::OPC_FilterValue, 105, 4, 0, // Skip to: 27
/* 23 */      MCD::OPC_Decode, 151, 3, 26, // Opcode: LDH32, DecodeIdx: 26
/* 27 */      MCD::OPC_FilterValue, 107, 4, 0, // Skip to: 35
/* 31 */      MCD::OPC_Decode, 223, 3, 27, // Opcode: STH32, DecodeIdx: 27
/* 35 */      MCD::OPC_FilterValue, 113, 4, 0, // Skip to: 43
/* 39 */      MCD::OPC_Decode, 145, 3, 26, // Opcode: LDB32, DecodeIdx: 26
/* 43 */      MCD::OPC_FilterValue, 115, 4, 0, // Skip to: 51
/* 47 */      MCD::OPC_Decode, 216, 3, 27, // Opcode: STB32, DecodeIdx: 27
/* 51 */      MCD::OPC_FilterValue, 195, 1, 119, 0, // Skip to: 175
/* 56 */      MCD::OPC_ExtractField, 4, 4,  // Inst{7-4} ...
/* 59 */      MCD::OPC_FilterValue, 0, 24, 0, // Skip to: 87
/* 63 */      MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 73
/* 69 */      MCD::OPC_Decode, 242, 3, 28, // Opcode: XFADDW32, DecodeIdx: 28
/* 73 */      MCD::OPC_CheckField, 8, 1, 1, 4, 0, // Skip to: 83
/* 79 */      MCD::OPC_Decode, 156, 3, 26, // Opcode: LDWACQ32, DecodeIdx: 26
/* 83 */      MCD::OPC_Decode, 236, 3, 28, // Opcode: XADDW32, DecodeIdx: 28
/* 87 */      MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 99
/* 91 */      MCD::OPC_CheckFieldOrFail, 8, 1, 1, 
/* 95 */      MCD::OPC_Decode, 228, 3, 27, // Opcode: STWREL32, DecodeIdx: 27
/* 99 */      MCD::OPC_FilterValue, 4, 14, 0, // Skip to: 117
/* 103 */     MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 113
/* 109 */     MCD::OPC_Decode, 246, 3, 28, // Opcode: XFORW32, DecodeIdx: 28
/* 113 */     MCD::OPC_Decode, 250, 3, 28, // Opcode: XORW32, DecodeIdx: 28
/* 117 */     MCD::OPC_FilterValue, 5, 14, 0, // Skip to: 135
/* 121 */     MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 131
/* 127 */     MCD::OPC_Decode, 244, 3, 28, // Opcode: XFANDW32, DecodeIdx: 28
/* 131 */     MCD::OPC_Decode, 238, 3, 28, // Opcode: XANDW32, DecodeIdx: 28
/* 135 */     MCD::OPC_FilterValue, 10, 14, 0, // Skip to: 153
/* 139 */     MCD::OPC_CheckField, 0, 4, 1, 4, 0, // Skip to: 149
/* 145 */     MCD::OPC_Decode, 248, 3, 28, // Opcode: XFXORW32, DecodeIdx: 28
/* 149 */     MCD::OPC_Decode, 128, 4, 28, // Opcode: XXORW32, DecodeIdx: 28
/* 153 */     MCD::OPC_FilterValue, 14, 8, 0, // Skip to: 165
/* 157 */     MCD::OPC_CheckFieldOrFail, 0, 4, 1, 
/* 161 */     MCD::OPC_Decode, 240, 3, 28, // Opcode: XCHGW32, DecodeIdx: 28
/* 165 */     MCD::OPC_FilterValueOrFail, 15, 
/* 167 */     MCD::OPC_CheckFieldOrFail, 0, 4, 1, 
/* 171 */     MCD::OPC_Decode, 214, 2, 29, // Opcode: CMPXCHGW32, DecodeIdx: 29
/* 175 */     MCD::OPC_FilterValue, 203, 1, 17, 0, // Skip to: 197
/* 180 */     MCD::OPC_ExtractField, 4, 5,  // Inst{8-4} ...
/* 183 */     MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 191
/* 187 */     MCD::OPC_Decode, 152, 3, 26, // Opcode: LDHACQ32, DecodeIdx: 26
/* 191 */     MCD::OPC_FilterValueOrFail, 17, 
/* 193 */     MCD::OPC_Decode, 224, 3, 27, // Opcode: STHREL32, DecodeIdx: 27
/* 197 */     MCD::OPC_FilterValueOrFail, 211, 1, 
/* 200 */     MCD::OPC_ExtractField, 4, 5,  // Inst{8-4} ...
/* 203 */     MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 211
/* 207 */     MCD::OPC_Decode, 146, 3, 26, // Opcode: LDBACQ32, DecodeIdx: 26
/* 211 */     MCD::OPC_FilterValueOrFail, 17, 
/* 213 */     MCD::OPC_Decode, 217, 3, 27, // Opcode: STBREL32, DecodeIdx: 27
/* 217 */     MCD::OPC_Fail,
  0
};

// Handling 30 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 32, 16), 0, 16);
    insertBits(tmp, fieldFromInstruction(insn, 52, 4), 16, 4);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 19:
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 32);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 21:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 16);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 48, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 32, 16), 0, 16);
    insertBits(tmp, fieldFromInstruction(insn, 52, 4), 16, 4);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 28:
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 32, 20);
    if (!Check(S, decodeMemoryOpValue(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 52, 4);
    if (!Check(S, DecodeGPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
