/* midori-tab.c generated by valac 0.26.2, the Vala compiler
 * generated from midori-tab.vala, do not modify */

/*
 Copyright (C) 2007-2013 Christian Dywan <christian@twotoasts.de>
 Copyright (C) 2009 Jean-François Guchens <zcx000@gmail.com>
 Copyright (C) 2011 Peter Hatina <phatina@redhat.com>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "webkit/webkit.h"
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <pango/pango.h>


#define MIDORI_TYPE_NEW_VIEW (midori_new_view_get_type ())

#define MIDORI_TYPE_SECURITY (midori_security_get_type ())

#define MIDORI_TYPE_LOAD_STATUS (midori_load_status_get_type ())

#define MIDORI_TYPE_LOAD_ERROR (midori_load_error_get_type ())

#define MIDORI_TYPE_TAB (midori_tab_get_type ())
#define MIDORI_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_TAB, MidoriTab))
#define MIDORI_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_TAB, MidoriTabClass))
#define MIDORI_IS_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_TAB))
#define MIDORI_IS_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_TAB))
#define MIDORI_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_TAB, MidoriTabClass))

typedef struct _MidoriTab MidoriTab;
typedef struct _MidoriTabClass MidoriTabClass;
typedef struct _MidoriTabPrivate MidoriTabPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MidoriTabUpdateActionsData MidoriTabUpdateActionsData;

#define MIDORI_TYPE_CONTEXT_ACTION (midori_context_action_get_type ())
#define MIDORI_CONTEXT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_CONTEXT_ACTION, MidoriContextAction))
#define MIDORI_CONTEXT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_CONTEXT_ACTION, MidoriContextActionClass))
#define MIDORI_IS_CONTEXT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_CONTEXT_ACTION))
#define MIDORI_IS_CONTEXT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_CONTEXT_ACTION))
#define MIDORI_CONTEXT_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_CONTEXT_ACTION, MidoriContextActionClass))

typedef struct _MidoriContextAction MidoriContextAction;
typedef struct _MidoriContextActionClass MidoriContextActionClass;

typedef enum  {
	MIDORI_NEW_VIEW_TAB,
	MIDORI_NEW_VIEW_BACKGROUND,
	MIDORI_NEW_VIEW_WINDOW
} MidoriNewView;

typedef enum  {
	MIDORI_SECURITY_NONE,
	MIDORI_SECURITY_UNKNOWN,
	MIDORI_SECURITY_TRUSTED
} MidoriSecurity;

typedef enum  {
	MIDORI_LOAD_FINISHED,
	MIDORI_LOAD_COMMITTED,
	MIDORI_LOAD_PROVISIONAL
} MidoriLoadStatus;

typedef enum  {
	MIDORI_LOAD_ERROR_NONE,
	MIDORI_LOAD_ERROR_DELAYED,
	MIDORI_LOAD_ERROR_SECURITY,
	MIDORI_LOAD_ERROR_CRASH,
	MIDORI_LOAD_ERROR_NETWORK
} MidoriLoadError;

struct _MidoriTab {
	GtkVBox parent_instance;
	MidoriTabPrivate * priv;
};

struct _MidoriTabClass {
	GtkVBoxClass parent_class;
};

struct _MidoriTabPrivate {
	MidoriTab* _related;
	WebKitWebView* _web_view;
	gchar* current_uri;
	gboolean _special;
	gboolean _minimized;
	gchar* _mime_type;
	MidoriSecurity _security;
	MidoriLoadStatus _load_status;
	MidoriLoadError _load_error;
	gchar* _statusbar_text;
	GdkColor* _fg_color;
	GdkColor* bg_color_;
	gdouble current_progress;
	gboolean _is_dialog;
};

struct _MidoriTabUpdateActionsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MidoriTab* self;
	GtkActionGroup* actions;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	WebKitWebView* _tmp2_;
	gboolean _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkAction* _tmp5_;
	WebKitWebView* _tmp6_;
	gboolean _tmp7_;
	GtkActionGroup* _tmp8_;
	GtkAction* _tmp9_;
	WebKitWebView* _tmp10_;
	gboolean _tmp11_;
	GtkActionGroup* _tmp12_;
	GtkAction* _tmp13_;
	WebKitWebView* _tmp14_;
	gboolean _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkAction* _tmp17_;
	WebKitWebView* _tmp18_;
	gboolean _tmp19_;
	GtkActionGroup* _tmp20_;
	GtkAction* _tmp21_;
	WebKitWebView* _tmp22_;
	gboolean _tmp23_;
	GtkActionGroup* _tmp24_;
	GtkAction* _tmp25_;
};


static gpointer midori_tab_parent_class = NULL;

GType midori_new_view_get_type (void) G_GNUC_CONST;
GType midori_security_get_type (void) G_GNUC_CONST;
GType midori_load_status_get_type (void) G_GNUC_CONST;
GType midori_load_error_get_type (void) G_GNUC_CONST;
GType midori_tab_get_type (void) G_GNUC_CONST;
#define MIDORI_TAB_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MIDORI_TYPE_TAB, MidoriTabPrivate))
enum  {
	MIDORI_TAB_DUMMY_PROPERTY,
	MIDORI_TAB_RELATED,
	MIDORI_TAB_WEB_VIEW,
	MIDORI_TAB_URI,
	MIDORI_TAB_SPECIAL,
	MIDORI_TAB_MINIMIZED,
	MIDORI_TAB_MIME_TYPE,
	MIDORI_TAB_SECURITY,
	MIDORI_TAB_LOAD_STATUS,
	MIDORI_TAB_LOAD_ERROR,
	MIDORI_TAB_STATUSBAR_TEXT,
	MIDORI_TAB_PROGRESS,
	MIDORI_TAB_IS_DIALOG,
	MIDORI_TAB_VIEW_SOURCE
};
gboolean midori_tab_is_blank (MidoriTab* self);
gboolean midori_uri_is_blank (const gchar* uri);
const gchar* midori_tab_get_uri (MidoriTab* self);
void midori_tab_inject_stylesheet (MidoriTab* self, const gchar* stylesheet);
WebKitWebView* midori_tab_get_web_view (MidoriTab* self);
gboolean midori_tab_can_view_source (MidoriTab* self);
gboolean midori_tab_get_view_source (MidoriTab* self);
const gchar* midori_tab_get_mime_type (MidoriTab* self);
gchar* midori_tab_get_display_title (const gchar* title, const gchar* uri);
gchar* midori_uri_strip_prefix_for_display (const gchar* uri);
PangoEllipsizeMode midori_tab_get_display_ellipsize (const gchar* title, const gchar* uri);
gboolean midori_tab_can_save (MidoriTab* self);
gboolean midori_tab_get_special (MidoriTab* self);
void midori_tab_stop_loading (MidoriTab* self);
gboolean midori_tab_can_go_forward (MidoriTab* self);
void midori_tab_go_forward (MidoriTab* self);
void midori_tab_unmark_text_matches (MidoriTab* self);
gboolean midori_tab_find (MidoriTab* self, const gchar* text, gboolean case_sensitive, gboolean forward);
static void midori_tab_update_actions_data_free (gpointer _data);
void midori_tab_update_actions (MidoriTab* self, GtkActionGroup* actions, GAsyncReadyCallback _callback_, gpointer _user_data_);
void midori_tab_update_actions_finish (MidoriTab* self, GAsyncResult* _res_);
static gboolean midori_tab_update_actions_co (MidoriTabUpdateActionsData* _data_);
MidoriTab* midori_tab_new (void);
MidoriTab* midori_tab_construct (GType object_type);
MidoriTab* midori_tab_get_related (MidoriTab* self);
void midori_tab_set_related (MidoriTab* self, MidoriTab* value);
static void midori_tab_set_web_view (MidoriTab* self, WebKitWebView* value);
void midori_tab_set_uri (MidoriTab* self, const gchar* value);
gchar* midori_uri_format_for_display (const gchar* uri);
void midori_tab_set_special (MidoriTab* self, gboolean value);
gboolean midori_tab_get_minimized (MidoriTab* self);
void midori_tab_set_minimized (MidoriTab* self, gboolean value);
void midori_tab_set_mime_type (MidoriTab* self, const gchar* value);
MidoriSecurity midori_tab_get_security (MidoriTab* self);
void midori_tab_set_security (MidoriTab* self, MidoriSecurity value);
MidoriLoadStatus midori_tab_get_load_status (MidoriTab* self);
void midori_tab_set_load_status (MidoriTab* self, MidoriLoadStatus value);
MidoriLoadError midori_tab_get_load_error (MidoriTab* self);
void midori_tab_set_load_error (MidoriTab* self, MidoriLoadError value);
const gchar* midori_tab_get_statusbar_text (MidoriTab* self);
void midori_tab_set_statusbar_text (MidoriTab* self, const gchar* value);
GdkColor* midori_tab_get_fg_color (MidoriTab* self);
void midori_tab_set_fg_color (MidoriTab* self, GdkColor* value);
static GdkColor* _gdk_color_dup (GdkColor* self);
GdkColor* midori_tab_get_bg_color (MidoriTab* self);
void midori_tab_set_bg_color (MidoriTab* self, GdkColor* value);
gdouble midori_tab_get_progress (MidoriTab* self);
void midori_tab_set_progress (MidoriTab* self, gdouble value);
gboolean midori_tab_get_is_dialog (MidoriTab* self);
void midori_tab_set_is_dialog (MidoriTab* self, gboolean value);
void midori_tab_set_view_source (MidoriTab* self, gboolean value);
static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
GType midori_context_action_get_type (void) G_GNUC_CONST;
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * midori_tab_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void midori_tab_finalize (GObject* obj);
static void _vala_midori_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_midori_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType midori_new_view_get_type (void) {
	static volatile gsize midori_new_view_type_id__volatile = 0;
	if (g_once_init_enter (&midori_new_view_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_NEW_VIEW_TAB, "MIDORI_NEW_VIEW_TAB", "tab"}, {MIDORI_NEW_VIEW_BACKGROUND, "MIDORI_NEW_VIEW_BACKGROUND", "background"}, {MIDORI_NEW_VIEW_WINDOW, "MIDORI_NEW_VIEW_WINDOW", "window"}, {0, NULL, NULL}};
		GType midori_new_view_type_id;
		midori_new_view_type_id = g_enum_register_static ("MidoriNewView", values);
		g_once_init_leave (&midori_new_view_type_id__volatile, midori_new_view_type_id);
	}
	return midori_new_view_type_id__volatile;
}


GType midori_security_get_type (void) {
	static volatile gsize midori_security_type_id__volatile = 0;
	if (g_once_init_enter (&midori_security_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_SECURITY_NONE, "MIDORI_SECURITY_NONE", "none"}, {MIDORI_SECURITY_UNKNOWN, "MIDORI_SECURITY_UNKNOWN", "unknown"}, {MIDORI_SECURITY_TRUSTED, "MIDORI_SECURITY_TRUSTED", "trusted"}, {0, NULL, NULL}};
		GType midori_security_type_id;
		midori_security_type_id = g_enum_register_static ("MidoriSecurity", values);
		g_once_init_leave (&midori_security_type_id__volatile, midori_security_type_id);
	}
	return midori_security_type_id__volatile;
}


GType midori_load_status_get_type (void) {
	static volatile gsize midori_load_status_type_id__volatile = 0;
	if (g_once_init_enter (&midori_load_status_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_LOAD_FINISHED, "MIDORI_LOAD_FINISHED", "finished"}, {MIDORI_LOAD_COMMITTED, "MIDORI_LOAD_COMMITTED", "committed"}, {MIDORI_LOAD_PROVISIONAL, "MIDORI_LOAD_PROVISIONAL", "provisional"}, {0, NULL, NULL}};
		GType midori_load_status_type_id;
		midori_load_status_type_id = g_enum_register_static ("MidoriLoadStatus", values);
		g_once_init_leave (&midori_load_status_type_id__volatile, midori_load_status_type_id);
	}
	return midori_load_status_type_id__volatile;
}


GType midori_load_error_get_type (void) {
	static volatile gsize midori_load_error_type_id__volatile = 0;
	if (g_once_init_enter (&midori_load_error_type_id__volatile)) {
		static const GEnumValue values[] = {{MIDORI_LOAD_ERROR_NONE, "MIDORI_LOAD_ERROR_NONE", "none"}, {MIDORI_LOAD_ERROR_DELAYED, "MIDORI_LOAD_ERROR_DELAYED", "delayed"}, {MIDORI_LOAD_ERROR_SECURITY, "MIDORI_LOAD_ERROR_SECURITY", "security"}, {MIDORI_LOAD_ERROR_CRASH, "MIDORI_LOAD_ERROR_CRASH", "crash"}, {MIDORI_LOAD_ERROR_NETWORK, "MIDORI_LOAD_ERROR_NETWORK", "network"}, {0, NULL, NULL}};
		GType midori_load_error_type_id;
		midori_load_error_type_id = g_enum_register_static ("MidoriLoadError", values);
		g_once_init_leave (&midori_load_error_type_id__volatile, midori_load_error_type_id);
	}
	return midori_load_error_type_id__volatile;
}


gboolean midori_tab_is_blank (MidoriTab* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 127 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 128 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = midori_tab_get_uri (self);
#line 128 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = _tmp0_;
#line 128 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp2_ = midori_uri_is_blank (_tmp1_);
#line 128 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp2_;
#line 128 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 307 "midori-tab.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 148 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return self ? g_object_ref (self) : NULL;
#line 314 "midori-tab.c"
}


void midori_tab_inject_stylesheet (MidoriTab* self, const gchar* stylesheet) {
	WebKitDOMDocument* dom = NULL;
	WebKitWebView* _tmp0_ = NULL;
	WebKitDOMDocument* _tmp1_ = NULL;
	WebKitDOMDocument* _tmp2_ = NULL;
	WebKitDOMDocument* _tmp3_ = NULL;
	WebKitDOMHTMLElement* _tmp4_ = NULL;
	WebKitDOMHTMLElement* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 146 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 146 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (stylesheet != NULL);
#line 148 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 148 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = webkit_web_view_get_dom_document (_tmp0_);
#line 148 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 148 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	dom = _tmp2_;
#line 149 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp3_ = dom;
#line 149 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp4_ = webkit_dom_document_get_head (_tmp3_);
#line 149 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp5_ = _tmp4_;
#line 149 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (_tmp5_ != NULL);
#line 347 "midori-tab.c"
	{
		WebKitDOMElement* style = NULL;
		WebKitDOMDocument* _tmp6_ = NULL;
		WebKitDOMElement* _tmp7_ = NULL;
		WebKitDOMElement* _tmp8_ = NULL;
		WebKitDOMElement* _tmp9_ = NULL;
		WebKitDOMElement* _tmp10_ = NULL;
		WebKitDOMDocument* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		WebKitDOMText* _tmp13_ = NULL;
		WebKitDOMDocument* _tmp14_ = NULL;
		WebKitDOMHTMLElement* _tmp15_ = NULL;
		WebKitDOMHTMLElement* _tmp16_ = NULL;
		WebKitDOMElement* _tmp17_ = NULL;
#line 151 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp6_ = dom;
#line 151 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp7_ = webkit_dom_document_create_element (_tmp6_, "style", &_inner_error_);
#line 151 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp8_ = _g_object_ref0 (_tmp7_);
#line 151 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		style = _tmp8_;
#line 151 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 372 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 152 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp9_ = style;
#line 152 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		webkit_dom_element_set_attribute (_tmp9_, "type", "text/css", &_inner_error_);
#line 152 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_g_object_unref0 (style);
#line 383 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 153 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp10_ = style;
#line 153 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp11_ = dom;
#line 153 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp12_ = stylesheet;
#line 153 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp13_ = webkit_dom_document_create_text_node (_tmp11_, _tmp12_);
#line 153 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		webkit_dom_node_append_child ((WebKitDOMNode*) _tmp10_, (WebKitDOMNode*) _tmp13_, &_inner_error_);
#line 153 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 153 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_g_object_unref0 (style);
#line 400 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 154 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp14_ = dom;
#line 154 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp15_ = webkit_dom_document_get_head (_tmp14_);
#line 154 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp16_ = _tmp15_;
#line 154 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp17_ = style;
#line 154 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		webkit_dom_node_append_child ((WebKitDOMNode*) _tmp16_, (WebKitDOMNode*) _tmp17_, &_inner_error_);
#line 154 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 154 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_g_object_unref0 (style);
#line 417 "midori-tab.c"
			goto __catch37_g_error;
		}
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_g_object_unref0 (style);
#line 422 "midori-tab.c"
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_error_ = _inner_error_;
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_inner_error_ = NULL;
#line 157 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp18_ = _ ("Failed to inject stylesheet: %s");
#line 157 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp19_ = _error_;
#line 157 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp20_ = _tmp19_->message;
#line 157 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_critical (_tmp18_, _tmp20_);
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_g_error_free0 (_error_);
#line 445 "midori-tab.c"
	}
	__finally37:
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_g_object_unref0 (dom);
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_clear_error (&_inner_error_);
#line 150 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return;
#line 458 "midori-tab.c"
	}
#line 146 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (dom);
#line 462 "midori-tab.c"
}


gboolean midori_tab_can_view_source (MidoriTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* content_type = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* text_type = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
#line 182 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 183 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = midori_tab_get_view_source (self);
#line 183 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = _tmp0_;
#line 183 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp1_) {
#line 184 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = FALSE;
#line 184 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 490 "midori-tab.c"
	}
#line 185 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp2_ = self->priv->_mime_type;
#line 185 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp3_ = g_content_type_from_mime_type (_tmp2_);
#line 185 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	content_type = _tmp3_;
#line 190 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp4_ = g_content_type_from_mime_type ("text/plain");
#line 190 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	text_type = _tmp4_;
#line 192 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp5_ = content_type;
#line 192 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp6_ = text_type;
#line 192 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp7_ = g_content_type_is_a (_tmp5_, _tmp6_);
#line 192 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp7_;
#line 192 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (text_type);
#line 192 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (content_type);
#line 192 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 516 "midori-tab.c"
}


gchar* midori_tab_get_display_title (const gchar* title, const gchar* uri) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
#line 195 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = title;
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp1_ == NULL) {
#line 536 "midori-tab.c"
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp3_ = uri;
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp4_ = g_str_has_suffix (_tmp3_, ".diff");
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		if (_tmp4_) {
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp2_ = TRUE;
#line 548 "midori-tab.c"
		} else {
			const gchar* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp5_ = uri;
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp6_ = g_str_has_suffix (_tmp5_, ".patch");
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp2_ = _tmp6_;
#line 558 "midori-tab.c"
		}
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp0_ = _tmp2_;
#line 562 "midori-tab.c"
	} else {
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp0_ = FALSE;
#line 566 "midori-tab.c"
	}
#line 197 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp0_) {
#line 570 "midori-tab.c"
		const gchar* _tmp7_ = NULL;
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp7_ = uri;
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp8_ = g_file_new_for_uri (_tmp7_);
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp9_ = _tmp8_;
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp10_ = g_file_get_basename (_tmp9_);
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp11_ = _tmp10_;
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_g_object_unref0 (_tmp9_);
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = _tmp11_;
#line 198 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 592 "midori-tab.c"
	}
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp13_ = title;
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp13_ == NULL) {
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp12_ = TRUE;
#line 600 "midori-tab.c"
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_ = NULL;
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp15_ = title;
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		if (g_strcmp0 (_tmp15_, "OMG!") == 0) {
#line 608 "midori-tab.c"
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp16_ = uri;
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp17_ = g_str_has_prefix (_tmp16_, "file://");
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp14_ = _tmp17_;
#line 617 "midori-tab.c"
		} else {
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp14_ = FALSE;
#line 621 "midori-tab.c"
		}
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp12_ = _tmp14_;
#line 625 "midori-tab.c"
	}
#line 201 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp12_) {
#line 629 "midori-tab.c"
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 202 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp18_ = uri;
#line 202 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp19_ = midori_uri_strip_prefix_for_display (_tmp18_);
#line 202 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = _tmp19_;
#line 202 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 640 "midori-tab.c"
	}
#line 211 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp20_ = title;
#line 211 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp21_ = g_str_has_prefix (_tmp20_, "‪");
#line 211 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (!_tmp21_) {
#line 648 "midori-tab.c"
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
#line 212 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp22_ = title;
#line 212 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp23_ = g_strconcat ("‪", _tmp22_, NULL);
#line 212 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = _tmp23_;
#line 212 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 659 "midori-tab.c"
	}
#line 214 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp24_ = title;
#line 214 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp25_ = g_strdup (_tmp24_);
#line 214 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp25_;
#line 214 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 669 "midori-tab.c"
}


PangoEllipsizeMode midori_tab_get_display_ellipsize (const gchar* title, const gchar* uri) {
	PangoEllipsizeMode result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar** parts = NULL;
	const gchar* _tmp7_ = NULL;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gboolean _tmp10_ = FALSE;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
#line 217 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (title != NULL, 0);
#line 217 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (uri != NULL, 0);
#line 218 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = title;
#line 218 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = uri;
#line 218 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
#line 219 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = PANGO_ELLIPSIZE_START;
#line 219 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 704 "midori-tab.c"
	}
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp3_ = title;
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp4_ = g_str_has_suffix (_tmp3_, ".diff");
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp4_) {
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp2_ = TRUE;
#line 714 "midori-tab.c"
	} else {
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp5_ = title;
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp6_ = g_str_has_suffix (_tmp5_, ".patch");
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp2_ = _tmp6_;
#line 724 "midori-tab.c"
	}
#line 221 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp2_) {
#line 222 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = PANGO_ELLIPSIZE_START;
#line 222 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 732 "midori-tab.c"
	}
#line 224 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp7_ = title;
#line 224 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
#line 224 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	parts = _tmp9_;
#line 224 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	parts_length1 = _vala_array_length (_tmp8_);
#line 224 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_parts_size_ = parts_length1;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp11_ = parts;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp11__length1 = parts_length1;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp12_ = _tmp11_[0];
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp12_ != NULL) {
#line 752 "midori-tab.c"
		const gchar* _tmp13_ = NULL;
		gchar** _tmp14_ = NULL;
		gint _tmp14__length1 = 0;
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp13_ = uri;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp14_ = parts;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp14__length1 = parts_length1;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp15_ = parts;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp15__length1 = parts_length1;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp16_ = _tmp14_[_tmp15__length1 - 1];
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) (-1));
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp18_ = _tmp17_;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp19_ = g_str_has_suffix (_tmp13_, _tmp18_);
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp10_ = _tmp19_;
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_g_free0 (_tmp18_);
#line 784 "midori-tab.c"
	} else {
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp10_ = FALSE;
#line 788 "midori-tab.c"
	}
#line 225 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp10_) {
#line 226 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = PANGO_ELLIPSIZE_START;
#line 226 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 226 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 798 "midori-tab.c"
	}
#line 228 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = PANGO_ELLIPSIZE_END;
#line 228 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 228 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 806 "midori-tab.c"
}


gboolean midori_tab_can_save (MidoriTab* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	WebKitWebView* _tmp5_ = NULL;
	WebKitWebFrame* _tmp6_ = NULL;
	WebKitWebDataSource* _tmp7_ = NULL;
	GString* _tmp8_ = NULL;
#line 232 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 233 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = midori_tab_is_blank (self);
#line 233 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp1_) {
#line 233 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp0_ = TRUE;
#line 828 "midori-tab.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 233 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp2_ = self->priv->_special;
#line 233 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp0_ = _tmp2_;
#line 835 "midori-tab.c"
	}
#line 233 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp0_) {
#line 234 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = FALSE;
#line 234 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 843 "midori-tab.c"
	}
#line 235 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp3_ = midori_tab_get_view_source (self);
#line 235 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp4_ = _tmp3_;
#line 235 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp4_) {
#line 236 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = FALSE;
#line 236 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 855 "midori-tab.c"
	}
#line 238 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp5_ = self->priv->_web_view;
#line 238 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp6_ = webkit_web_view_get_main_frame (_tmp5_);
#line 238 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp7_ = webkit_web_frame_get_data_source (_tmp6_);
#line 238 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp8_ = webkit_web_data_source_get_data (_tmp7_);
#line 238 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp8_ == NULL) {
#line 239 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		result = FALSE;
#line 239 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		return result;
#line 871 "midori-tab.c"
	}
#line 241 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = TRUE;
#line 241 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 877 "midori-tab.c"
}


void midori_tab_stop_loading (MidoriTab* self) {
	WebKitWebView* _tmp0_ = NULL;
#line 244 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 245 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 245 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	webkit_web_view_stop_loading (_tmp0_);
#line 889 "midori-tab.c"
}


gboolean midori_tab_can_go_forward (MidoriTab* self) {
	gboolean result = FALSE;
	WebKitWebView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 248 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 249 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 249 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = webkit_web_view_can_go_forward (_tmp0_);
#line 249 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp1_;
#line 249 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 907 "midori-tab.c"
}


void midori_tab_go_forward (MidoriTab* self) {
	WebKitWebView* _tmp0_ = NULL;
#line 252 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 253 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 253 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	webkit_web_view_go_forward (_tmp0_);
#line 919 "midori-tab.c"
}


void midori_tab_unmark_text_matches (MidoriTab* self) {
	WebKitWebView* _tmp0_ = NULL;
#line 256 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 258 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 258 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	webkit_web_view_unmark_text_matches (_tmp0_);
#line 931 "midori-tab.c"
}


gboolean midori_tab_find (MidoriTab* self, const gchar* text, gboolean case_sensitive, gboolean forward) {
	gboolean result = FALSE;
	gboolean found = FALSE;
	WebKitWebView* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	WebKitWebView* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	WebKitWebView* _tmp8_ = NULL;
#line 262 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 262 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 274 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	found = FALSE;
#line 275 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 275 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = text;
#line 275 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp2_ = case_sensitive;
#line 275 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp3_ = forward;
#line 275 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp4_ = webkit_web_view_search_text (_tmp0_, _tmp1_, _tmp2_, _tmp3_, TRUE);
#line 275 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	found = _tmp4_;
#line 276 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp5_ = self->priv->_web_view;
#line 276 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp6_ = text;
#line 276 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp7_ = case_sensitive;
#line 276 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	webkit_web_view_mark_text_matches (_tmp5_, _tmp6_, _tmp7_, (guint) 0);
#line 277 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp8_ = self->priv->_web_view;
#line 277 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	webkit_web_view_set_highlight_text_matches (_tmp8_, TRUE);
#line 278 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = found;
#line 278 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 981 "midori-tab.c"
}


static void midori_tab_update_actions_data_free (gpointer _data) {
	MidoriTabUpdateActionsData* _data_;
	_data_ = _data;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (_data_->actions);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (_data_->self);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_slice_free (MidoriTabUpdateActionsData, _data_);
#line 994 "midori-tab.c"
}


void midori_tab_update_actions (MidoriTab* self, GtkActionGroup* actions, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MidoriTabUpdateActionsData* _data_;
	MidoriTab* _tmp0_ = NULL;
	GtkActionGroup* _tmp1_ = NULL;
	GtkActionGroup* _tmp2_ = NULL;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_ = g_slice_new0 (MidoriTabUpdateActionsData);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, midori_tab_update_actions);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, midori_tab_update_actions_data_free);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->self = _tmp0_;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = actions;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (_data_->actions);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->actions = _tmp2_;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	midori_tab_update_actions_co (_data_);
#line 1023 "midori-tab.c"
}


void midori_tab_update_actions_finish (MidoriTab* self, GAsyncResult* _res_) {
	MidoriTabUpdateActionsData* _data_;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1031 "midori-tab.c"
}


static gboolean midori_tab_update_actions_co (MidoriTabUpdateActionsData* _data_) {
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	switch (_data_->_state_) {
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case 0:
#line 1040 "midori-tab.c"
		goto _state_0;
		default:
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_assert_not_reached ();
#line 1045 "midori-tab.c"
	}
	_state_0:
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp0_ = NULL;
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp0_ = _data_->actions;
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp1_ = NULL;
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp1_ = gtk_action_group_get_action (_data_->_tmp0_, "Undo");
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp2_ = NULL;
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp2_ = _data_->self->priv->_web_view;
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp3_ = FALSE;
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp3_ = webkit_web_view_can_undo (_data_->_tmp2_);
#line 301 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp1_, _data_->_tmp3_);
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp4_ = NULL;
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp4_ = _data_->actions;
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp5_ = NULL;
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp5_ = gtk_action_group_get_action (_data_->_tmp4_, "Redo");
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp6_ = NULL;
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp6_ = _data_->self->priv->_web_view;
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp7_ = FALSE;
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp7_ = webkit_web_view_can_redo (_data_->_tmp6_);
#line 302 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp5_, _data_->_tmp7_);
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp8_ = NULL;
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp8_ = _data_->actions;
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp9_ = NULL;
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp9_ = gtk_action_group_get_action (_data_->_tmp8_, "Cut");
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp10_ = NULL;
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp10_ = _data_->self->priv->_web_view;
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp11_ = FALSE;
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp11_ = webkit_web_view_can_cut_clipboard (_data_->_tmp10_);
#line 303 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp9_, _data_->_tmp11_);
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp12_ = NULL;
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp12_ = _data_->actions;
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp13_ = NULL;
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp13_ = gtk_action_group_get_action (_data_->_tmp12_, "Copy");
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp14_ = NULL;
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp14_ = _data_->self->priv->_web_view;
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp15_ = FALSE;
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp15_ = webkit_web_view_can_copy_clipboard (_data_->_tmp14_);
#line 304 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp13_, _data_->_tmp15_);
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp16_ = NULL;
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp16_ = _data_->actions;
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp17_ = NULL;
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp17_ = gtk_action_group_get_action (_data_->_tmp16_, "Paste");
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp18_ = NULL;
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp18_ = _data_->self->priv->_web_view;
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp19_ = FALSE;
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp19_ = webkit_web_view_can_paste_clipboard (_data_->_tmp18_);
#line 305 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp17_, _data_->_tmp19_);
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp20_ = NULL;
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp20_ = _data_->actions;
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp21_ = NULL;
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp21_ = gtk_action_group_get_action (_data_->_tmp20_, "Delete");
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp22_ = NULL;
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp22_ = _data_->self->priv->_web_view;
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp23_ = FALSE;
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp23_ = webkit_web_view_can_cut_clipboard (_data_->_tmp22_);
#line 306 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp21_, _data_->_tmp23_);
#line 307 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp24_ = NULL;
#line 307 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp24_ = _data_->actions;
#line 307 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp25_ = NULL;
#line 307 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_data_->_tmp25_ = gtk_action_group_get_action (_data_->_tmp24_, "SelectAll");
#line 307 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	gtk_action_set_sensitive (_data_->_tmp25_, TRUE);
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_data_->_state_ == 0) {
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1170 "midori-tab.c"
	} else {
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1174 "midori-tab.c"
	}
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_unref (_data_->_async_result);
#line 287 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return FALSE;
#line 1180 "midori-tab.c"
}


MidoriTab* midori_tab_construct (GType object_type) {
	MidoriTab * self = NULL;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self = (MidoriTab*) g_object_new (object_type, NULL);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return self;
#line 1190 "midori-tab.c"
}


MidoriTab* midori_tab_new (void) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return midori_tab_construct (MIDORI_TYPE_TAB);
#line 1197 "midori-tab.c"
}


MidoriTab* midori_tab_get_related (MidoriTab* self) {
	MidoriTab* result;
	MidoriTab* _tmp0_ = NULL;
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_related;
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1212 "midori-tab.c"
}


void midori_tab_set_related (MidoriTab* self, MidoriTab* value) {
	MidoriTab* _tmp0_ = NULL;
	MidoriTab* _tmp1_ = NULL;
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (self->priv->_related);
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_related = _tmp1_;
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "related");
#line 1231 "midori-tab.c"
}


WebKitWebView* midori_tab_get_web_view (MidoriTab* self) {
	WebKitWebView* result;
	WebKitWebView* _tmp0_ = NULL;
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1246 "midori-tab.c"
}


static void midori_tab_set_web_view (MidoriTab* self, WebKitWebView* value) {
	WebKitWebView* _tmp0_ = NULL;
	WebKitWebView* _tmp1_ = NULL;
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (self->priv->_web_view);
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_web_view = _tmp1_;
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "web-view");
#line 1265 "midori-tab.c"
}


const gchar* midori_tab_get_uri (MidoriTab* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 50 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->current_uri;
#line 51 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 51 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1280 "midori-tab.c"
}


void midori_tab_set_uri (MidoriTab* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 53 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 54 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 54 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = midori_uri_format_for_display (_tmp0_);
#line 54 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->current_uri);
#line 54 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->current_uri = _tmp1_;
#line 53 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "uri");
#line 1299 "midori-tab.c"
}


gboolean midori_tab_get_special (MidoriTab* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_special;
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1314 "midori-tab.c"
}


void midori_tab_set_special (MidoriTab* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_special = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "special");
#line 1328 "midori-tab.c"
}


gboolean midori_tab_get_minimized (MidoriTab* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_minimized;
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1343 "midori-tab.c"
}


void midori_tab_set_minimized (MidoriTab* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_minimized = _tmp0_;
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "minimized");
#line 1357 "midori-tab.c"
}


const gchar* midori_tab_get_mime_type (MidoriTab* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_mime_type;
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1372 "midori-tab.c"
}


void midori_tab_set_mime_type (MidoriTab* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->_mime_type);
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_mime_type = _tmp1_;
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "mime-type");
#line 1391 "midori-tab.c"
}


MidoriSecurity midori_tab_get_security (MidoriTab* self) {
	MidoriSecurity result;
	MidoriSecurity _tmp0_ = 0;
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_security;
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1406 "midori-tab.c"
}


void midori_tab_set_security (MidoriTab* self, MidoriSecurity value) {
	MidoriSecurity _tmp0_ = 0;
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_security = _tmp0_;
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "security");
#line 1420 "midori-tab.c"
}


MidoriLoadStatus midori_tab_get_load_status (MidoriTab* self) {
	MidoriLoadStatus result;
	MidoriLoadStatus _tmp0_ = 0;
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_load_status;
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1435 "midori-tab.c"
}


void midori_tab_set_load_status (MidoriTab* self, MidoriLoadStatus value) {
	MidoriLoadStatus _tmp0_ = 0;
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_load_status = _tmp0_;
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "load-status");
#line 1449 "midori-tab.c"
}


MidoriLoadError midori_tab_get_load_error (MidoriTab* self) {
	MidoriLoadError result;
	MidoriLoadError _tmp0_ = 0;
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_load_error;
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1464 "midori-tab.c"
}


void midori_tab_set_load_error (MidoriTab* self, MidoriLoadError value) {
	MidoriLoadError _tmp0_ = 0;
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_load_error = _tmp0_;
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "load-error");
#line 1478 "midori-tab.c"
}


const gchar* midori_tab_get_statusbar_text (MidoriTab* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_statusbar_text;
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1493 "midori-tab.c"
}


void midori_tab_set_statusbar_text (MidoriTab* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->_statusbar_text);
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_statusbar_text = _tmp1_;
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "statusbar-text");
#line 1512 "midori-tab.c"
}


GdkColor* midori_tab_get_fg_color (MidoriTab* self) {
	GdkColor* result;
	GdkColor* _tmp0_ = NULL;
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_fg_color;
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1527 "midori-tab.c"
}


static GdkColor* _gdk_color_dup (GdkColor* self) {
	GdkColor* dup;
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	dup = g_new0 (GdkColor, 1);
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	memcpy (dup, self, sizeof (GdkColor));
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return dup;
#line 1539 "midori-tab.c"
}


static gpointer __gdk_color_dup0 (gpointer self) {
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return self ? _gdk_color_dup (self) : NULL;
#line 1546 "midori-tab.c"
}


void midori_tab_set_fg_color (MidoriTab* self, GdkColor* value) {
	GdkColor* _tmp0_ = NULL;
	GdkColor* _tmp1_ = NULL;
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = __gdk_color_dup0 (_tmp0_);
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->_fg_color);
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_fg_color = _tmp1_;
#line 1563 "midori-tab.c"
}


GdkColor* midori_tab_get_bg_color (MidoriTab* self) {
	GdkColor* result;
	GdkColor* _tmp0_ = NULL;
#line 74 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->bg_color_;
#line 75 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 75 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1578 "midori-tab.c"
}


void midori_tab_set_bg_color (MidoriTab* self, GdkColor* value) {
	GdkColor* _tmp0_ = NULL;
	GdkColor* _tmp1_ = NULL;
#line 76 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 77 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 77 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = __gdk_color_dup0 (_tmp0_);
#line 77 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->bg_color_);
#line 77 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->bg_color_ = _tmp1_;
#line 78 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_emit_by_name (self, "colors-changed");
#line 1597 "midori-tab.c"
}


gdouble midori_tab_get_progress (MidoriTab* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_ = FALSE;
#line 86 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 87 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = self->priv->_special;
#line 87 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp1_) {
#line 87 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp0_ = 0.0;
#line 1613 "midori-tab.c"
	} else {
		gdouble _tmp2_ = 0.0;
#line 87 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp2_ = self->priv->current_progress;
#line 87 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp0_ = _tmp2_;
#line 1620 "midori-tab.c"
	}
#line 87 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 87 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1626 "midori-tab.c"
}


void midori_tab_set_progress (MidoriTab* self, gdouble value) {
	MidoriLoadStatus _tmp0_ = 0;
#line 89 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 91 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_load_status;
#line 91 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (_tmp0_ == MIDORI_LOAD_FINISHED) {
#line 92 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		self->priv->current_progress = 0.0;
#line 1640 "midori-tab.c"
	} else {
		gdouble _tmp1_ = 0.0;
#line 94 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		_tmp1_ = value;
#line 94 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		if (_tmp1_ == 1.0) {
#line 95 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			self->priv->current_progress = 0.0;
#line 1649 "midori-tab.c"
		} else {
			gdouble _tmp2_ = 0.0;
			gdouble _tmp3_ = 0.0;
#line 98 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp2_ = value;
#line 98 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			_tmp3_ = CLAMP (_tmp2_, 0.1, 1.0);
#line 98 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
			self->priv->current_progress = _tmp3_;
#line 1659 "midori-tab.c"
		}
	}
#line 89 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "progress");
#line 1664 "midori-tab.c"
}


gboolean midori_tab_get_is_dialog (MidoriTab* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_is_dialog;
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp0_;
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1679 "midori-tab.c"
}


void midori_tab_set_is_dialog (MidoriTab* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = value;
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_is_dialog = _tmp0_;
#line 125 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "is-dialog");
#line 1693 "midori-tab.c"
}


gboolean midori_tab_get_view_source (MidoriTab* self) {
	gboolean result;
	WebKitWebView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 173 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 174 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 174 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = webkit_web_view_get_view_source_mode (_tmp0_);
#line 174 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	result = _tmp1_;
#line 174 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return result;
#line 1711 "midori-tab.c"
}


void midori_tab_set_view_source (MidoriTab* self, gboolean value) {
	WebKitWebView* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 176 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (self != NULL);
#line 177 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = self->priv->_web_view;
#line 177 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = value;
#line 177 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	webkit_web_view_set_view_source_mode (_tmp0_, _tmp1_);
#line 176 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_notify ((GObject *) self, "view-source");
#line 1728 "midori-tab.c"
}


static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (return_value != NULL);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 2);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1750 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = closure->data;
#line 1756 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	callback = (GMarshalFunc_BOOLEAN__STRING) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_value_set_boolean (return_value, v_return);
#line 1764 "midori-tab.c"
}


static void g_cclosure_user_marshal_VOID__STRING_INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT_STRING) (gpointer data1, const char* arg_1, gint arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 4);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1783 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = closure->data;
#line 1789 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	callback = (GMarshalFunc_VOID__STRING_INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), g_value_get_string (param_values + 3), data2);
#line 1795 "midori-tab.c"
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_STRING) (gpointer data1, gboolean arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 3);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1814 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = closure->data;
#line 1820 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	callback = (GMarshalFunc_VOID__BOOLEAN_STRING) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 1826 "midori-tab.c"
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_return_if_fail (n_param_values == 3);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = closure->data;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = param_values->data[0].v_pointer;
#line 1845 "midori-tab.c"
	} else {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data1 = param_values->data[0].v_pointer;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		data2 = closure->data;
#line 1851 "midori-tab.c"
	}
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 1857 "midori-tab.c"
}


static GObject * midori_tab_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MidoriTab * self;
	WebKitWebView* _tmp0_ = NULL;
	WebKitWebView* _tmp1_ = NULL;
	WebKitWebView* _tmp2_ = NULL;
#line 131 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	parent_class = G_OBJECT_CLASS (midori_tab_parent_class);
#line 131 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
#line 131 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MIDORI_TYPE_TAB, MidoriTab);
#line 140 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = (WebKitWebView*) webkit_web_view_new ();
#line 140 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_ref_sink (_tmp0_);
#line 140 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = _tmp0_;
#line 140 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	midori_tab_set_web_view (self, _tmp1_);
#line 140 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (_tmp1_);
#line 143 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp2_ = self->priv->_web_view;
#line 143 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	webkit_web_view_load_uri (_tmp2_, "");
#line 131 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	return obj;
#line 1890 "midori-tab.c"
}


static void midori_tab_class_init (MidoriTabClass * klass) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	midori_tab_parent_class = g_type_class_peek_parent (klass);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_type_class_add_private (klass, sizeof (MidoriTabPrivate));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_midori_tab_get_property;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_midori_tab_set_property;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->constructor = midori_tab_constructor;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	G_OBJECT_CLASS (klass)->finalize = midori_tab_finalize;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_RELATED, g_param_spec_object ("related", "related", "related", MIDORI_TYPE_TAB, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_WEB_VIEW, g_param_spec_object ("web-view", "web-view", "web-view", WEBKIT_TYPE_WEB_VIEW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_SPECIAL, g_param_spec_boolean ("special", "special", "special", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_MINIMIZED, g_param_spec_boolean ("minimized", "minimized", "minimized", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_MIME_TYPE, g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_SECURITY, g_param_spec_enum ("security", "security", "security", MIDORI_TYPE_SECURITY, MIDORI_SECURITY_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_LOAD_STATUS, g_param_spec_enum ("load-status", "load-status", "load-status", MIDORI_TYPE_LOAD_STATUS, MIDORI_LOAD_FINISHED, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_LOAD_ERROR, g_param_spec_enum ("load-error", "load-error", "load-error", MIDORI_TYPE_LOAD_ERROR, MIDORI_LOAD_ERROR_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_STATUSBAR_TEXT, g_param_spec_string ("statusbar-text", "statusbar-text", "statusbar-text", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_PROGRESS, g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_IS_DIALOG, g_param_spec_boolean ("is-dialog", "is-dialog", "is-dialog", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_TAB_VIEW_SOURCE, g_param_spec_boolean ("view-source", "view-source", "view-source", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("colors_changed", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("open_uri", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("navigation_requested", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("console_message", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("attach_inspector", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WEBKIT_TYPE_WEB_VIEW);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("detach_inspector", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WEBKIT_TYPE_WEB_VIEW);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("search_text", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_STRING, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_STRING);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	g_signal_new ("context_menu", MIDORI_TYPE_TAB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, WEBKIT_TYPE_HIT_TEST_RESULT, MIDORI_TYPE_CONTEXT_ACTION);
#line 1949 "midori-tab.c"
}


static void midori_tab_instance_init (MidoriTab * self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv = MIDORI_TAB_GET_PRIVATE (self);
#line 49 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp0_ = g_strdup ("about:blank");
#line 49 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->current_uri = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_special = FALSE;
#line 62 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_minimized = FALSE;
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_tmp1_ = g_strdup ("text/plain");
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_mime_type = _tmp1_;
#line 66 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_security = MIDORI_SECURITY_NONE;
#line 67 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_load_status = MIDORI_LOAD_FINISHED;
#line 68 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_load_error = MIDORI_LOAD_ERROR_NONE;
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_statusbar_text = NULL;
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->_fg_color = NULL;
#line 73 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->bg_color_ = NULL;
#line 85 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self->priv->current_progress = 0.0;
#line 1984 "midori-tab.c"
}


static void midori_tab_finalize (GObject* obj) {
	MidoriTab * self;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MIDORI_TYPE_TAB, MidoriTab);
#line 46 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (self->priv->_related);
#line 47 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_object_unref0 (self->priv->_web_view);
#line 49 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->current_uri);
#line 64 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->_mime_type);
#line 69 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->_statusbar_text);
#line 72 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->_fg_color);
#line 73 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	_g_free0 (self->priv->bg_color_);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	G_OBJECT_CLASS (midori_tab_parent_class)->finalize (obj);
#line 2008 "midori-tab.c"
}


GType midori_tab_get_type (void) {
	static volatile gsize midori_tab_type_id__volatile = 0;
	if (g_once_init_enter (&midori_tab_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MidoriTabClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) midori_tab_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MidoriTab), 0, (GInstanceInitFunc) midori_tab_instance_init, NULL };
		GType midori_tab_type_id;
		midori_tab_type_id = g_type_register_static (GTK_TYPE_VBOX, "MidoriTab", &g_define_type_info, 0);
		g_once_init_leave (&midori_tab_type_id__volatile, midori_tab_type_id);
	}
	return midori_tab_type_id__volatile;
}


static void _vala_midori_tab_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MidoriTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_TAB, MidoriTab);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	switch (property_id) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_RELATED:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_object (value, midori_tab_get_related (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_WEB_VIEW:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_object (value, midori_tab_get_web_view (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_URI:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_string (value, midori_tab_get_uri (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_SPECIAL:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_special (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_MINIMIZED:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_minimized (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_MIME_TYPE:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_string (value, midori_tab_get_mime_type (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_SECURITY:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_enum (value, midori_tab_get_security (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_STATUS:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_enum (value, midori_tab_get_load_status (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_ERROR:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_enum (value, midori_tab_get_load_error (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_STATUSBAR_TEXT:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_string (value, midori_tab_get_statusbar_text (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_PROGRESS:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_double (value, midori_tab_get_progress (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_IS_DIALOG:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_is_dialog (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_VIEW_SOURCE:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		g_value_set_boolean (value, midori_tab_get_view_source (self));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 2107 "midori-tab.c"
		default:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 2113 "midori-tab.c"
	}
}


static void _vala_midori_tab_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MidoriTab * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_TAB, MidoriTab);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
	switch (property_id) {
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_RELATED:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_related (self, g_value_get_object (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_WEB_VIEW:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_web_view (self, g_value_get_object (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_URI:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_uri (self, g_value_get_string (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_SPECIAL:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_special (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_MINIMIZED:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_minimized (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_MIME_TYPE:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_mime_type (self, g_value_get_string (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_SECURITY:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_security (self, g_value_get_enum (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_STATUS:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_load_status (self, g_value_get_enum (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_LOAD_ERROR:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_load_error (self, g_value_get_enum (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_STATUSBAR_TEXT:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_statusbar_text (self, g_value_get_string (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_PROGRESS:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_progress (self, g_value_get_double (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_IS_DIALOG:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_is_dialog (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		case MIDORI_TAB_VIEW_SOURCE:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		midori_tab_set_view_source (self, g_value_get_boolean (value));
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 2201 "midori-tab.c"
		default:
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 45 "/usr/src/ports/midori/midori-0.5.10-1.x86_64/src/midori/midori-tab.vala"
		break;
#line 2207 "midori-tab.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



