/*
 * Copyright (c) 1983 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *
 * 1-14-99 Karl R. Hakimian <hakimian@eecs.wsu.edu>
 * 
 * While the headers in this file claim only the purest decent from
 * their BSD roots, this program has had unspeakable things done to it
 * over the years. I have tried to clean things up and get them working
 * again.
 *
 * Put the port connect back to the client back where it belongs.
 * Replaced fork and coping data from stderr to error socket with a
 *  dup2 of the error socket onto stderr. This code was in the BSD code,
 *  but does not seem to be necessary and is broken under Linux
 * removed file descriptor from doit call. Not needed. f = 0 assumed
 *  throughout
 * Removed unused variables.
 *
 * 3-31-99 Karl R. Hakimian <hakimian@eecs.wsu.edu>
 *
 * Fixed problem where stderr socket can be left open if a daemon is
 * called from rexecd.
 *
 * KRH
 */

char copyright[] =
  "@(#) Copyright (c) 1983 The Regents of the University of California.\n"
  "All rights reserved.\n";

/*
 * From: @(#)rexecd.c	5.12 (Berkeley) 2/25/91
 */
char rcsid[] = 
  "$Id: rexecd.c,v 1.29 2000/07/23 04:16:22 dholland Exp $";
#include "../version.h"

#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <signal.h>
#include <netdb.h>
#include <pwd.h>
#include <errno.h>
#include <syslog.h>
#include <unistd.h>
#include <crypt.h>    /* apparently necessary in some glibcs */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <paths.h>
#include <grp.h>
#include <arpa/inet.h>
  
  
#ifdef USE_SHADOW
#include <shadow.h>
#endif

#ifdef USE_PAM
#include <security/pam_appl.h>
#endif

#define _PATH_FTPUSERS	      "/etc/ftpusers"

#ifdef TCP_WRAPPER
#include <syslog.h>
#include "log_tcp.h"
struct from_host from_host;
#endif

#ifdef __CYGWIN__
#include <windows.h>
#include <sys/cygwin.h>
#define is_winnt	(GetVersion() < 0x80000000)
#endif

/* Note: on cygwin, these are NOT imports from libwrap;
 * instead, they are simply local vars (we don't link
 * the r* daemons against libwrap -- that's the job of
 * the superserver
 */
int allow_severity = LOG_INFO;
int deny_severity = LOG_WARNING;


/*
 * remote execute server:
 *	username\0
 *	password\0
 *	command\0
 *	data
 */

static void fatal(const char *);
static void doit(struct sockaddr *fromp, socklen_t fromlen);
static void getstr(char *buf, int cnt, const char *err);
static const char *findhostname(struct sockaddr *fromp, socklen_t fromlen);
#ifdef __CYGWIN__
int unwrap_ipv4_ipv6(struct sockaddr *p, socklen_t plen);
#endif

static char *remote = NULL;

int
main(int argc, char **argv)
{
	struct sockaddr_storage from_storage;
	socklen_t fromlen;
	struct sockaddr * from = (struct sockaddr *)&from_storage;

	(void)argc;

	fromlen = sizeof(from_storage);
	remote = (char *)calloc (129, sizeof (char));

	if (getpeername(0, from, &fromlen) < 0) {
		fprintf(stderr, "rexecd: getpeername: %s\n", strerror(errno));
		return 1;
	}

	openlog(argv[0], LOG_PID, LOG_DAEMON);

#ifdef	TCP_WRAPPER
	/* Find out and report the remote host name. */
	/* I don't think this works. -- dholland */
	if (fromhost(&from_host) < 0 || !hosts_access(argv[0], &from_host))
		refuse(&from_host);
	  remote = hosts_info(&from_host);
#else
	if (argc > 1 && argv[1] && strcmp(argv[1], "-D")==0)
	{
		/* use IP in logs -- this is workaround */
		inet_ntop(from->sa_family,
		          ((from->sa_family == AF_INET6)
			   ? (void *)(&((struct sockaddr_in6 *)from)->sin6_addr)
			   : (void *)(&((struct sockaddr_in *)from)->sin_addr)),
			  remote, 128);

	}
	else
	{
		const char *tmp_remote = findhostname(from, fromlen);
		if (tmp_remote != NULL)
		{
		  /* Be advised that this may be utter nonsense. */
		  strncpy (remote, tmp_remote, 128);
		  free ((void *)(intptr_t)tmp_remote);
		}
		else
		{
			write(0, "\1Where are you?\n", 16);
			return 1;
		}
	}
#endif
	syslog(allow_severity, "connect from %.128s", remote);
	doit(from, fromlen);
	return 0;
}

char	username[20] = "USER=";
char	homedir[64] = "HOME=";
char	shell[64] = "SHELL=";
char	path[sizeof(_PATH_DEFPATH) + sizeof("PATH=")] = "PATH=";
char	*envinit[] =
	    {homedir, shell, path, username, NULL};
char	**myenviron;

#ifdef USE_PAM
static char *PAM_username;
static char *PAM_password;

static int
PAM_conv(int num_msg, const struct pam_message **msg, 
		struct pam_response **response, void *appdata_ptr)
{
	struct pam_response *pr;
	const struct pam_message *pm;
	int n;

	if ((*response = malloc(num_msg * sizeof(struct pam_response))) == NULL)
		return(PAM_CONV_ERR);
	memset(*response, 0, num_msg * sizeof(struct pam_response));

	for (pr = *response, pm = *msg, n = num_msg; n--; pr++, pm++) 
	{
		switch (pm->msg_style) {
		case PAM_PROMPT_ECHO_ON:
			/* XXX: why not pam_set_item(PAM_RUSER) ? */
			pr->resp_retcode = PAM_SUCCESS;
			pr->resp = PAM_username ? strdup(PAM_username) : NULL;
			/* PAM frees resp */
			break;
		case PAM_PROMPT_ECHO_OFF:
			pr->resp_retcode = PAM_SUCCESS;
			pr->resp = PAM_password ? strdup(PAM_password) : NULL;
			/* PAM frees resp */
			break;
		case PAM_TEXT_INFO:
		case PAM_ERROR_MSG:
			/* ignore it... */
			pr->resp_retcode = PAM_SUCCESS;
			pr->resp = NULL;
			break;
		default:
			/* Zero and free allocated memory and return an error. */
			for (pr = *response, n = num_msg; n--; pr++) 
			{
				if (pr->resp)
					free(pr->resp);
			}
			free(*response);
			*response = NULL;
			return(PAM_CONV_ERR);
		}
	}
	return PAM_SUCCESS;
}

static struct pam_conv PAM_conversation = {
    &PAM_conv,
    NULL
};
#endif /* USE_PAM */


static void
doit(struct sockaddr *fromp, socklen_t fromlen)
{
	char *cmdbuf;
	long cmdbuflen;
	char user[17], pass[17];
	struct passwd *pwd;
	int s = -1;
	u_short port;
	const char *theshell;
	const char *cp2;
	int ifd;
#ifdef USE_PAM
	pam_handle_t *pamh;
	int pam_error;
#else /* !USE_PAM */
	char *namep, *cp;
#ifdef RESTRICT_FTP
	char buf[BUFSIZ];
	FILE *fp;
#endif
#endif /* USE_PAM */

	cmdbuflen = sysconf (_SC_ARG_MAX);
	if (!(cmdbuflen > 0)) {
		syslog (LOG_ERR, "sysconf (_SC_ARG_MAX) failed");
		fatal ("sysconf (_SC_ARG_MAX) failed\n");
	}

	cmdbuf = malloc (++cmdbuflen);
	if (cmdbuf == NULL) {
		syslog (LOG_ERR, "Could not allocate space for cmdbuf");
		fatal ("Could not allocate space for cmdbuf\n");
	}

	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGTERM, SIG_DFL);
#ifdef DEBUG
	{ int t = open(_PATH_TTY, 2);
	  if (t >= 0) {
		ioctl(t, TIOCNOTTY, NULL);
		close(t);
	  }
	}
#endif

/* copy socket to stdout and stderr KRH */
	dup2(0, 1);
	dup2(0, 2);
	alarm(60);
	port = 0;
	for (;;) {
		char c;
		if (read(0, &c, 1) != 1)
			exit(1);
		if (c == 0)
			break;
		port = port * 10 + c - '0';
	}
	alarm(0);

/*
 We must connect back to the client here if a port was provided. KRH
*/
	if (port != 0) {
	        struct sockaddr_storage copy_from_storage;
		struct sockaddr * copy_fromp = (struct sockaddr *)&copy_from_storage;
		memset (&copy_from_storage, 0x00, sizeof (copy_from_storage));
		memcpy (copy_fromp, fromp, fromlen);
#ifdef __CYGWIN__
		unwrap_ipv4_ipv6 (copy_fromp, fromlen);
#endif
		s = socket(copy_fromp->sa_family, SOCK_STREAM, 0);
		if (s < 0)
			exit(1);

#if 0 /* this shouldn't be necessary */
		struct	sockaddr_in asin = { AF_INET };
		if (bind(s, (struct sockaddr *)&asin, sizeof (asin)) < 0)
			exit(1);
#endif
		alarm(60);
		if (copy_fromp->sa_family == AF_INET6)
		  ((struct sockaddr_in6 *)copy_fromp)->sin6_port = htons(port);
		else
		  ((struct sockaddr_in *)copy_fromp)->sin_port = htons(port);

		if (connect(s, copy_fromp, fromlen) < 0)
			exit(1);
		alarm(0);
	}

	getstr(user, sizeof(user), "username too long\n");
	getstr(pass, sizeof(pass), "password too long\n");
	getstr(cmdbuf, cmdbuflen, "command too long\n");
#ifdef USE_PAM
       #define PAM_BAIL if (pam_error != PAM_SUCCESS) { \
	       pam_end(pamh, pam_error); exit(1); \
       }
       PAM_username = user;
       PAM_password = pass;
       pam_error = pam_start("rexec", PAM_username, &PAM_conversation,&pamh);
       PAM_BAIL;
       pam_error = pam_set_item (pamh, PAM_RUSER, user);
       PAM_BAIL;
       pam_error = pam_set_item (pamh, PAM_RHOST, remote);	       
       PAM_BAIL;
       pam_error = pam_set_item (pamh, PAM_TTY, "rexec");   /* we don't have a tty yet! */
       PAM_BAIL;
       pam_error = pam_authenticate(pamh, 0);
       PAM_BAIL;
       pam_error = pam_acct_mgmt(pamh, 0);
       PAM_BAIL;
       pam_error = pam_setcred(pamh, PAM_ESTABLISH_CRED);
       PAM_BAIL;
       pam_error = pam_open_session(pamh, 0);
       PAM_BAIL;
       pam_close_session(pamh, 0);
       pam_end(pamh, PAM_SUCCESS);
       /* If this point is reached, the user has been authenticated. */
       setpwent();
       pwd = getpwnam(user);
       endpwent();
#else /* !USE_PAM */
       /* All of the following issues are dealt with in the PAM configuration
	  file, so put all authentication/priviledge checks before the
	  corresponding #endif below. */

	setpwent();
	pwd = getpwnam(user);
	if (pwd == NULL) {
		/* Log failed attempts. */
		syslog(LOG_ERR, "LOGIN FAILURE from %.128s, %s", remote, user);
		fatal("Login incorrect.\n");
	}
	endpwent();
#ifdef USE_SHADOW
	{
		struct spwd *sp = getspnam(pwd->pw_name);
		endspent();
		if (sp) {
			pwd->pw_passwd = sp->sp_pwdp;
		}
	}
#endif
	if (*pwd->pw_passwd != '\0') {
#ifdef __CYGWIN__
		if (is_winnt) {
			HANDLE hToken = cygwin_logon_user (pwd, pass);
			if (hToken == INVALID_HANDLE_VALUE) {
				syslog(LOG_ERR, "LOGIN FAILURE from %.128s, %s",
				       remote, user);
				fatal("Login incorrect.\n");
			}
			cygwin_set_impersonation_token (hToken);
		}
		else
		{
#endif
		namep = crypt(pass, pwd->pw_passwd);
		if (strcmp(namep, pwd->pw_passwd)) {
			/* Log failed attempts. */
			syslog(LOG_ERR, "LOGIN FAILURE from %.128s, %s",
			       remote, user);
			fatal("Login incorrect.\n");
		}
#ifdef __CYGWIN__
		}
#endif
	}

	/* Erase the cleartext password from memory. */
	memset(pass, 0, sizeof(pass));
	/* Clear out crypt()'s internal state, too. */
	crypt("flurgle", pwd->pw_passwd);

	/* Disallow access to root account. */
	if (pwd->pw_uid == 0) {
		syslog(LOG_ERR, "%s LOGIN REFUSED from %.128s", user, remote);
		fatal("Login incorrect.\n");
	}
#ifdef RESTRICT_FTP
	/* Disallow access to accounts in /etc/ftpusers. */
	fp = fopen(_PATH_FTPUSERS, "r");
	if (fp != NULL) {
	    while (fgets(buf, sizeof(buf), fp) != NULL) {
		if ((cp = strchr(buf, '\n')) != NULL)
			*cp = '\0';
		if (strcmp(buf, pwd->pw_name) == 0) {
			syslog(LOG_ERR, "%s LOGIN REFUSED from %.128s",
			       user, remote);
			fatal("Login incorrect.\n");
		}
	    }
	    fclose(fp);
	}
	else syslog(LOG_ERR, "cannot open /etc/ftpusers");
#endif
#endif /* !USE_PAM */

	/* Log successful attempts. */
	syslog(LOG_INFO, "login from %.128s as %s", remote, user);

	write(2, "\0", 1);
	if (port) {
		/* If we have a port, dup STDERR on that port KRH */
		close(2);
		dup2(s, 2);
		/*
		 * We no longer need s, close it so we don't leave it 
		 * behind for a daemon.
		 */
		close (s);
	}
	if (*pwd->pw_shell == 0) {
		/* Shouldn't we deny access? (Can be done by PAM KRH) */
		theshell = _PATH_BSHELL;
	}
	else theshell = pwd->pw_shell;
	/* shouldn't we check /etc/shells? (Can be done by PAM KRH) */

	if (setgid(pwd->pw_gid)) {
		perror("setgid");
		exit(1);
	}
	if (initgroups(pwd->pw_name, pwd->pw_gid)) {
		perror("initgroups");
		exit(1);
	}
	if (setuid(pwd->pw_uid)) {
		perror("setuid");
		exit(1);
	}

	if (chdir(pwd->pw_dir) < 0) {
		fatal("No remote directory.\n");
	}

	strcat(path, _PATH_DEFPATH);
	myenviron = envinit;
	strncat(homedir, pwd->pw_dir, sizeof(homedir)-6);
	strncat(shell, theshell, sizeof(shell)-7);
	strncat(username, pwd->pw_name, sizeof(username)-6);
	cp2 = strrchr(theshell, '/');
	if (cp2) cp2++;
	else cp2 = theshell;

	/*
	 * Close all fds, in case libc has left fun stuff like 
	 * /etc/shadow open.
	 */
	for (ifd = getdtablesize()-1; ifd > 2; ifd--) close(ifd);

	execle(theshell, cp2, "-c", cmdbuf, NULL, myenviron);
	perror(theshell);
	exit(1);
}

static void
fatal(const char *msg)
{
	char x = 1;
	write(2, &x, 1);
	write(2, msg, strlen(msg));
	exit(1);
}

static void
getstr(char *buf, int cnt, const char *err)
{
	char c;

	do {
		if (read(0, &c, 1) != 1)
			exit(1);
		if (--cnt < 0) {
			fatal(err);
		}
		*buf++ = c;
	} while (c != 0);
}

#ifdef __CYGWIN__
int unwrap_ipv4_ipv6(struct sockaddr *p, socklen_t plen)
{
  if (p->sa_family == AF_INET)
    return 1;
  else if (p->sa_family == AF_INET6)
    {
      if (IN6_IS_ADDR_V4MAPPED(&(((struct sockaddr_in6 *)p)->sin6_addr)))
        {
          struct sockaddr_storage tmp_storage;
          struct sockaddr_in * tmp_ptr = (struct sockaddr_in *)&tmp_storage;
          memset (&tmp_storage, 0x00, sizeof (tmp_storage));

          tmp_ptr->sin_family = AF_INET;
          tmp_ptr->sin_port = ((struct sockaddr_in6 *)p)->sin6_port;
          tmp_ptr->sin_addr.s_addr = ((const uint32_t *)&(((struct sockaddr_in6 *)p)->sin6_addr.s6_addr32))[3];
          memcpy (p, tmp_ptr, plen);
          return 2;
        }
    }
  return 0;
}
#endif /* __CYGWIN__ */

/* copied from rshd */
static const char *
findhostname(struct sockaddr *fromp, socklen_t fromlen)
{
	const char *hostname;
	char remote_address[INET6_ADDRSTRLEN];
	char remote_hostname[NI_MAXHOST];
	struct addrinfo hints;
	struct addrinfo *res0, *res;
	int err;
	struct sockaddr_storage copy_from_storage;
	struct sockaddr * copy_fromp = (struct sockaddr *)&copy_from_storage;
	memset (&copy_from_storage, 0x00, sizeof (copy_from_storage));
	memcpy (copy_fromp, fromp, fromlen);

#ifdef __CYGWIN__
	unwrap_ipv4_ipv6 (copy_fromp, fromlen);
#endif
	if (! inet_ntop(copy_fromp->sa_family,
		(( copy_fromp->sa_family == AF_INET6 )
		? (void *)( &((struct sockaddr_in6 *)copy_fromp)->sin6_addr )
		: (void *)( &((struct sockaddr_in *)copy_fromp)->sin_addr )),
		remote_address, sizeof(remote_address))) {
	    syslog(LOG_NOTICE|LOG_AUTH,
	    	"Failed to retrieve the socket remote address");
	    exit(1);
	}

	err = getnameinfo(copy_fromp, fromlen, remote_hostname, NI_MAXHOST,
		NULL, 0, 0);
	if (err && (err == EAI_AGAIN))
		err = getnameinfo (copy_fromp, fromlen, remote_hostname, NI_MAXHOST,
				   NULL, 0, NI_NUMERICHOST);
	if (err) {
		syslog(LOG_NOTICE|LOG_AUTH,
		       "Failed to retrieve the hostname information for %s",
		       remote_address);
		exit(1);
	}

	errno = ENOMEM; /* malloc (thus strdup) may not set it */
	hostname = strdup(remote_hostname);

	if (hostname==NULL) {
	    /* out of memory? */
	    syslog (LOG_CRIT, "strdup: %s\n", strerror(errno));
	    exit(1);
	}

	/*
	 * Attempt to confirm the DNS. 
	 */
	memset(&hints, 0, sizeof(hints));
	hints.ai_family = PF_UNSPEC;
	if (getaddrinfo(hostname, NULL, &hints, &res)) {
	    syslog(LOG_INFO, "Couldn't look up address for %s/%s",
		   hostname, remote_address);
	  {
	    free ((void *)(intptr_t)hostname);
	    return NULL;
	  }
	}

	res0 = res;
	while (res) {
	    struct sockaddr *sa;
	    char res_address[INET6_ADDRSTRLEN];
	    sa = res->ai_addr;

	    if (inet_ntop(sa->sa_family,
		(( sa->sa_family == AF_INET6 )
		? (void *)( &((struct sockaddr_in6 *)sa)->sin6_addr )
		: (void *)( &((struct sockaddr_in *)sa)->sin_addr )),
		res_address, sizeof(res_address))
		&& strcmp(remote_address, res_address) == 0) {
		    freeaddrinfo(res0);
		    return hostname;
	    }
	    res = res->ai_next;
	}
	freeaddrinfo(res0);

        /* Special case for INADDR_LOOPBACK, since getnameinfo
         * returns the canonical machine name when it ought to
         * return "localhost". Fix it.
         */
        {
            int is_localhost = 0;
            switch (copy_fromp->sa_family)
            {
            case AF_INET:
              {
                if (IN_LOOPBACK(ntohl(((struct sockaddr_in *)copy_fromp)->sin_addr.s_addr)))
                    is_localhost = 1;
                break;
              }

            case AF_INET6:
              {
                /* Don't need to worry about ::ffff:127.0.0.1 because
                 * we've already assured that copy_fromp has been
                 * transformed into an actual IPv4 addr in that case.
                 */
                struct sockaddr_in6 * fromp6 = (struct sockaddr_in6 *)copy_fromp;
                if (IN6_IS_ADDR_LOOPBACK(&fromp6->sin6_addr)) {
                    is_localhost = 1;
                }
                break;
              }

            default:
                break;
            }

            if (is_localhost) {
                free ((void *)(intptr_t)hostname);

                errno = ENOMEM; /* malloc (thus strdup) may not set it */
                hostname = strdup("localhost");

                if (hostname==NULL) {
                    /* out of memory? */
	            syslog (LOG_CRIT, "strdup: %s\n", strerror(errno));
	            exit(1);
                }

                return hostname;
            }
        }

	syslog(LOG_NOTICE, "Host addr %s not listed for host %s",
	       remote_address, hostname);
	free ((void *)(intptr_t)hostname);
	return NULL;
}

