/* i386-dos32.watcom.le.h
   created from i386-dos32.watcom.le.bin, 23329 (0x5b21) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_DOS32_WATCOM_LE_SIZE    23329
#define STUB_I386_DOS32_WATCOM_LE_ADLER32 0xa04cc126
#define STUB_I386_DOS32_WATCOM_LE_CRC32   0x7a9db6e4

unsigned char stub_i386_dos32_watcom_le[23329] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  36, 32,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,191, 97,108,105, 98,105, 87, 65, 84, 67, 79, 77,
/* 0x0040 */   6, 30,  7, 87,141,183,  0,  0,  0,  0,141,191,  0,  0,  0,  0,
/* 0x0050 */ 185,  0,  0,  0,  0,253,243,165,252,141,119,  4, 95,131,205,255,
/* 0x0060 */  87,233,252,255,255,255, 85, 80, 88, 33,161,216,208,213,  0,  0,
/* 0x0070 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0080 */   0,  0,  0,  0,  0, 45,235,  3,164,235,  3,138,  6, 70,136,  7,
/* 0x0090 */  71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,
/* 0x00a0 */  64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,
/* 0x00b0 */ 131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,
/* 0x00c0 */  17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,252, 17,
/* 0x00d0 */ 219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,  6, 70,
/* 0x00e0 */ 131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,238,252,
/* 0x00f0 */  17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0100 */ 201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x0110 */ 201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,  1,219,
/* 0x0120 */ 115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65, 65,131,
/* 0x0130 */ 193,  2,129,253,  0,243,255,255,131,209,  1, 86,141, 52, 47,243,
/* 0x0140 */ 164, 94,233,252,255,255,255,141, 20, 47,131,253,252,138,  4, 15,
/* 0x0150 */ 118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,
/* 0x0160 */ 139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,
/* 0x0170 */ 207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,  7,
/* 0x0180 */  71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,192,
/* 0x0190 */  64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,
/* 0x01a0 */ 131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,
/* 0x01b0 */  17,219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,
/* 0x01c0 */ 219,114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x01d0 */ 192,235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,
/* 0x01e0 */ 131,240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139,
/* 0x01f0 */  30,131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,
/* 0x0200 */ 252, 17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,
/* 0x0210 */ 252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0220 */ 115, 68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115,
/* 0x0230 */  68, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1, 86,
/* 0x0240 */ 141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,253,
/* 0x0250 */ 252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,
/* 0x0260 */ 252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,
/* 0x0270 */   4,119,241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,
/* 0x0280 */   6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0290 */ 114,  1, 49,192, 64,138,  7,114,255,184,  1,  0,  0,  0,  1,219,
/* 0x02a0 */ 117,  7,139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139,
/* 0x02b0 */  30,131,238,252, 17,219,114, 30,  1,219,115, 11,117, 30,139, 30,
/* 0x02c0 */ 131,238,252, 17,219,114, 30, 72,  1,219,117,  7,139, 30,131,238,
/* 0x02d0 */ 252, 17,219, 17,192,235,255,  1,219,117,  7,139, 30,131,238,252,
/* 0x02e0 */  17,219, 17,201,235,255, 49,201,131,232,  3,114, 17,193,224,  8,
/* 0x02f0 */ 138,  6, 70,131,240,255,116,255,209,248,137,197,235, 11,  1,219,
/* 0x0300 */ 117,  7,139, 30,131,238,252, 17,219,114,204, 65,  1,219,117,  7,
/* 0x0310 */ 139, 30,131,238,252, 17,219,114,190,  1,219,117,  7,139, 30,131,
/* 0x0320 */ 238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x0330 */ 219,115, 81,  1,219,115, 81,117,  9,139, 30,131,238,252, 17,219,
/* 0x0340 */ 115, 81, 65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  2,
/* 0x0350 */  86,141, 52, 47,243,164, 94,233,252,255,255,255,141, 20, 47,131,
/* 0x0360 */ 253,252,138,  4, 15,118,255,138,  2, 66,136,  7, 71, 73,117,247,
/* 0x0370 */ 233,252,255,255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,
/* 0x0380 */ 233,  4,119,241,  1,207,233,252,255,255,255,137,229,141,156, 36,
/* 0x0390 */   0,  0,  0,  0, 49,192, 80, 57,220,117,251, 70, 70, 83,104,  0,
/* 0x03a0 */   0,  0,  0, 87,131,195,  4, 83,104,  0,  0,  0,  0, 86,131,195,
/* 0x03b0 */   4, 83, 80,199,  3,  0,  0,  0,  0,137,229,139, 85,  0,172, 74,
/* 0x03c0 */ 136,193, 36,  7,192,233,  3,187,  0,253,255,255,211,227,141,164,
/* 0x03d0 */  92,144,241,255,255,131,228,224,106,  0,106,  0,137,227, 83,131,
/* 0x03e0 */ 195,  4,139, 77,  0,255, 49, 87, 83,131,195,  4,136, 67,  2,172,
/* 0x03f0 */  74,136,193, 36, 15,136,  3,192,233,  4,136, 75,  1, 82, 86, 83,
/* 0x0400 */  80, 85, 87,191,  0,  0,  0,  0, 86, 83,131,236,100,139, 84, 36,
/* 0x0410 */ 120,199, 68, 36, 92,  0,  0,  0,  0,141, 66,  4,137, 68, 36, 96,
/* 0x0420 */ 184,  1,  0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,
/* 0x0430 */ 137, 76, 36, 88, 15,182, 74,  1,211,224,139,140, 36,144,  0,  0,
/* 0x0440 */   0, 72,137, 68, 36, 84,139,132, 36,132,  0,  0,  0, 15,182, 50,
/* 0x0450 */ 199, 68, 36, 76,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,
/* 0x0460 */   3,  0,  0,199, 68, 36, 72,  1,  0,  0,  0,137,116, 36, 80,199,
/* 0x0470 */  68, 36, 68,  1,  0,  0,  0,199, 68, 36, 64,  1,  0,  0,  0,199,
/* 0x0480 */  68, 36, 60,  1,  0,  0,  0,199,  1,  0,  0,  0,  0, 15,182, 74,
/* 0x0490 */   1,  1,241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36, 92,115,
/* 0x04a0 */  14,139, 68, 36, 96,102,199,  0,  0,  4,131,192,  2,226,246,139,
/* 0x04b0 */ 108, 36,124,199, 68, 36, 48,  0,  0,  0,  0,199, 68, 36, 52,255,
/* 0x04c0 */ 255,255,255,186,  0,  0,  0,  0,137,235,  3,156, 36,128,  0,  0,
/* 0x04d0 */   0,137, 92, 36, 56, 59,108, 36, 56, 15,132,128,  8,  0,  0,193,
/* 0x04e0 */ 100, 36, 48,  8, 66, 15,182, 69,  0, 69,  9, 68, 36, 48,131,250,
/* 0x04f0 */   4,126,226,139,180, 36,140,  0,  0,  0, 57,116, 36, 92, 15,131,
/* 0x0500 */ 226,  1,  0,  0,139,132, 36,136,  0,  0,  0,137, 68, 36, 24,139,
/* 0x0510 */  84, 36, 92, 35, 84, 36, 88,139, 68, 36, 76,139, 76, 36, 96,193,
/* 0x0520 */ 224,  4,137, 84, 36, 44,  1,208,129,124, 36, 52,255,255,255,  0,
/* 0x0530 */ 141, 52, 65,119, 29, 59,108, 36, 56, 15,132, 32,  8,  0,  0,193,
/* 0x0540 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x0550 */  36, 48,139, 68, 36, 52,102,139, 22,193,232, 11, 15,183,202, 15,
/* 0x0560 */ 175,193, 57, 68, 36, 48, 15,131, 80,  2,  0,  0,137, 68, 36, 52,
/* 0x0570 */ 184,  0,  8,  0,  0, 41,200,138, 76, 36, 80,193,248,  5,187,  1,
/* 0x0580 */   0,  0,  0,141,  4,  2,102,137,  6,139, 68, 36, 92, 35, 68, 36,
/* 0x0590 */  84,139,116, 36, 96,211,224,137,249, 15,182,209,185,  8,  0,  0,
/* 0x05a0 */   0, 43, 76, 36, 80,211,250,  1,208,105,192,  0,  6,  0,  0,131,
/* 0x05b0 */ 124, 36, 76,  6,141,132, 48,108, 14,  0,  0,137, 68, 36, 20, 15,
/* 0x05c0 */ 142, 72,  1,  0,  0,139, 68, 36, 92, 43, 68, 36, 72,139,148, 36,
/* 0x05d0 */ 136,  0,  0,  0, 15,182,  4, 16,137, 68, 36, 40,235, 46,137, 68,
/* 0x05e0 */  36, 52,184,  0,  8,  0,  0, 41,216,137,251,193,248,  5,133,210,
/* 0x05f0 */ 141,  4,  1,102,137,134,  0,  2,  0,  0, 15,133,106,  1,  0,  0,
/* 0x0600 */ 129,251,255,  0,  0,  0, 15,143,143,  0,  0,  0,209,100, 36, 40,
/* 0x0610 */ 139, 84, 36, 40,141, 60, 27,139, 76, 36, 20,129,226,  0,  1,  0,
/* 0x0620 */   0,129,124, 36, 52,255,255,255,  0,141,  4, 81,141, 52, 56,119,
/* 0x0630 */  29, 59,108, 36, 56, 15,132, 36,  7,  0,  0,193,100, 36, 48,  8,
/* 0x0640 */ 193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68,
/* 0x0650 */  36, 52,102,139,142,  0,  2,  0,  0,193,232, 11, 15,183,217, 15,
/* 0x0660 */ 175,195, 57, 68, 36, 48, 15,130,114,255,255,255, 41, 68, 36, 52,
/* 0x0670 */  41, 68, 36, 48,137,200,102,193,232,  5,141, 95,  1,102, 41,193,
/* 0x0680 */ 133,210,102,137,142,  0,  2,  0,  0, 15,132,219,  0,  0,  0,129,
/* 0x0690 */ 251,255,  0,  0,  0, 15,142,113,255,255,255,139, 84, 36, 24,137,
/* 0x06a0 */ 223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36,
/* 0x06b0 */  24, 15,143,215,  0,  0,  0,199, 68, 36, 76,  0,  0,  0,  0,139,
/* 0x06c0 */ 132, 36,140,  0,  0,  0, 57, 68, 36, 92, 15,130, 63,254,255,255,
/* 0x06d0 */ 129,124, 36, 52,255,255,255,  0,119, 12, 59,108, 36, 56,184,  1,
/* 0x06e0 */   0,  0,  0,116, 32, 69, 43,108, 36,124,184,  0,  0,  0,  0,139,
/* 0x06f0 */ 148, 36,132,  0,  0,  0,139, 92, 36, 92,139,140, 36,144,  0,  0,
/* 0x0700 */   0,137, 42,137, 25,131,196,100,233, 46,  8,  0,  0,129,124, 36,
/* 0x0710 */  52,255,255,255,  0,141, 52, 27,139, 68, 36, 20,141, 28,  6,119,
/* 0x0720 */  29, 59,108, 36, 56, 15,132, 52,  6,  0,  0,193,100, 36, 48,  8,
/* 0x0730 */ 193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68,
/* 0x0740 */  36, 52,102,139, 11,193,232, 11, 15,183,209, 15,175,194, 57, 68,
/* 0x0750 */  36, 48,115, 79,137, 68, 36, 52,184,  0,  8,  0,  0, 41,208,193,
/* 0x0760 */ 248,  5,141,  4,  1,102,137,  3,137,243,129,251,255,  0,  0,  0,
/* 0x0770 */ 126,155,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,
/* 0x0780 */ 124, 36, 76,  3,137, 84, 36, 24, 15,142, 41,255,255,255,131,124,
/* 0x0790 */  36, 76,  9, 15,143,107,  6,  0,  0,131,108, 36, 76,  3,233, 28,
/* 0x07a0 */ 255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,
/* 0x07b0 */   5,102, 41,193,102,137, 11,141, 94,  1,235,174,139, 92, 36, 52,
/* 0x07c0 */  41, 68, 36, 48, 41,195,137,208,102,193,232,  5,139, 76, 36, 76,
/* 0x07d0 */ 102, 41,194,129,251,255,255,255,  0,102,137, 22,139,116, 36, 96,
/* 0x07e0 */ 141, 60, 78,119, 27, 59,108, 36, 56, 15,132,112,  5,  0,  0,193,
/* 0x07f0 */ 100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,
/* 0x0800 */ 102,139,151,128,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,
/* 0x0810 */ 175,193, 57, 68, 36, 48, 15,131,228,  2,  0,  0,137,198,184,  0,
/* 0x0820 */   8,  0,  0, 41,200,139, 92, 36, 96,193,248,  5,131,124, 36, 76,
/* 0x0830 */   6,141,  4,  2,139, 76, 36, 72,139, 84, 36, 68,102,137,135,128,
/* 0x0840 */   1,  0,  0,139, 68, 36, 64,137, 76, 36, 68,137, 68, 36, 60,184,
/* 0x0850 */   0,  0,  0,  0, 15,159,192,137, 84, 36, 64,141,  4, 64,129,195,
/* 0x0860 */ 100,  6,  0,  0,137, 68, 36, 76,129,254,255,255,255,  0,119, 27,
/* 0x0870 */  59,108, 36, 56, 15,132,229,  4,  0,  0,193,100, 36, 48,  8, 15,
/* 0x0880 */ 182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139, 19,137,240,
/* 0x0890 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,102,
/* 0x08a0 */   3,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100,
/* 0x08b0 */  36, 44,  4,193,248,  5,139, 76, 36, 44,141,  4,  2,199, 68, 36,
/* 0x08c0 */  32,  0,  0,  0,  0,102,137,  3,141, 92, 25,  4,137, 92, 36, 16,
/* 0x08d0 */ 199, 68, 36, 36,  3,  0,  0,  0,139,124, 36, 36,186,  1,  0,  0,
/* 0x08e0 */   0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x08f0 */   5, 79,141,  4,  2,137,242,102,137,  3,116, 97,129,124, 36, 52,
/* 0x0900 */ 255,255,255,  0,141, 52, 18,139, 68, 36, 16,141, 28,  6,119, 29,
/* 0x0910 */  59,108, 36, 56, 15,132, 69,  4,  0,  0,193,100, 36, 48,  8,193,
/* 0x0920 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x0930 */  52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x0940 */  48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,
/* 0x0950 */   5,102, 41,194, 79,102,137, 19,141, 86,  1,117,159,138, 76, 36,
/* 0x0960 */  36,184,  1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 32,131,124,
/* 0x0970 */  36, 76,  3,137, 84, 36, 12, 15,143,254,  3,  0,  0,131, 68, 36,
/* 0x0980 */  76,  7,131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139, 92,
/* 0x0990 */  36, 96,193,224,  7,191,  6,  0,  0,  0,141,132, 24, 96,  3,  0,
/* 0x09a0 */   0,137, 68, 36,  8,184,  1,  0,  0,  0,235, 25,137, 68, 36, 52,
/* 0x09b0 */ 184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,102,137,
/* 0x09c0 */   3,137,240,116, 97,129,124, 36, 52,255,255,255,  0,141, 52,  0,
/* 0x09d0 */ 139, 68, 36,  8,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,124,
/* 0x09e0 */   3,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x09f0 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11,
/* 0x0a00 */  15,183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52,
/* 0x0a10 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137,
/* 0x0a20 */  19,141, 70,  1,117,159,141, 80,192,131,250,  3,137, 84, 36,  4,
/* 0x0a30 */  15,142, 54,  3,  0,  0,137,211,137,208,131,227,  1,209,248,131,
/* 0x0a40 */ 203,  2,131,250, 13,141,120,255, 15,143, 66,  4,  0,  0,137,249,
/* 0x0a50 */ 139,116, 36, 96,211,227,  1,210,141,  4, 94,137, 92, 36,  4, 41,
/* 0x0a60 */ 208,  5, 94,  5,  0,  0,137,  4, 36,184,  1,  0,  0,  0,199, 68,
/* 0x0a70 */  36, 28,  1,  0,  0,  0,235, 33,137, 68, 36, 52,184,  0,  8,  0,
/* 0x0a80 */   0, 41,200,193,248,  5,141,  4,  2,102,137,  3,137,240,209,100,
/* 0x0a90 */  36, 28, 79, 15,132,211,  2,  0,  0,129,124, 36, 52,255,255,255,
/* 0x0aa0 */   0,141, 52,  0,139, 12, 36,141, 28, 14,119, 29, 59,108, 36, 56,
/* 0x0ab0 */  15,132,169,  2,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x0ac0 */  15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,
/* 0x0ad0 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,153, 41,
/* 0x0ae0 */  68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,
/* 0x0af0 */ 141, 70,  1,102,137, 19,139, 92, 36, 28,  9, 92, 36,  4,235,142,
/* 0x0b00 */  41,195, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,
/* 0x0b10 */ 251,255,255,255,  0,102,137,151,128,  1,  0,  0, 15,134,107,  1,
/* 0x0b20 */   0,  0,102,139,143,152,  1,  0,  0,137,218,193,234, 11, 15,183,
/* 0x0b30 */ 193, 15,175,208, 57, 84, 36, 48, 15,131,134,  1,  0,  0,190,  0,
/* 0x0b40 */   8,  0,  0,137,211, 41,198,137,240,193,248,  5,141,  4,  1,139,
/* 0x0b50 */  76, 36, 44,102,137,135,152,  1,  0,  0,139, 68, 36, 76,193,224,
/* 0x0b60 */   5,  3, 68, 36, 96,129,250,255,255,255,  0,141, 60, 72,119, 27,
/* 0x0b70 */  59,108, 36, 56, 15,132,229,  1,  0,  0,193,100, 36, 48,  8, 15,
/* 0x0b80 */ 182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,224,  1,
/* 0x0b90 */   0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x0ba0 */  48, 15,131,103,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x0bb0 */  41,200,193,248,  5,141,  4,  2,102,137,135,224,  1,  0,  0,139,
/* 0x0bc0 */  68, 36, 92,133,192, 15,132,148,  1,  0,  0,131,124, 36, 76,  6,
/* 0x0bd0 */ 184,  0,  0,  0,  0,139,156, 36,136,  0,  0,  0,139, 84, 36, 24,
/* 0x0be0 */  15,159,192,141, 68,  0,  9,137, 68, 36, 76,139, 68, 36, 92, 43,
/* 0x0bf0 */  68, 36, 72, 15,182, 60, 24,137,248,136,  2, 66,255, 68, 36, 92,
/* 0x0c00 */ 137, 84, 36, 24,233,182,250,255,255, 41,198, 41, 68, 36, 48,137,
/* 0x0c10 */ 208,102,193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137,
/* 0x0c20 */  19,119, 27, 59,108, 36, 56, 15,132, 50,  1,  0,  0,193,100, 36,
/* 0x0c30 */  48,  8, 15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139,
/* 0x0c40 */  83,  2,137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x0c50 */  48, 15,131,119,  1,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x0c60 */  41,200,193,100, 36, 44,  4,193,248,  5,139,116, 36, 44,141,  4,
/* 0x0c70 */   2,199, 68, 36, 32,  8,  0,  0,  0,102,137, 67,  2,141,156, 30,
/* 0x0c80 */   4,  1,  0,  0,137, 92, 36, 16,233, 67,252,255,255, 59,108, 36,
/* 0x0c90 */  56, 15,132,200,  0,  0,  0,193,100, 36, 48,  8,193,227,  8,102,
/* 0x0ca0 */ 139,143,152,  1,  0,  0, 15,182, 69,  0,137,218,  9, 68, 36, 48,
/* 0x0cb0 */ 193,234, 11, 15,183,193, 69, 15,175,208, 57, 84, 36, 48, 15,130,
/* 0x0cc0 */ 122,254,255,255,137,200, 41,211,102,193,232,  5, 41, 84, 36, 48,
/* 0x0cd0 */ 102, 41,193,129,251,255,255,255,  0,102,137,143,152,  1,  0,  0,
/* 0x0ce0 */ 119, 23, 59,108, 36, 56,116,119,193,100, 36, 48,  8, 15,182, 69,
/* 0x0cf0 */   0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,176,  1,  0,  0,
/* 0x0d00 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x0d10 */ 131, 22,  1,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x0d20 */   5,141,  4,  2,102,137,135,176,  1,  0,  0,139, 68, 36, 68,139,
/* 0x0d30 */  84, 36, 72,137, 68, 36, 72,137, 84, 36, 68,131,124, 36, 76,  6,
/* 0x0d40 */ 184,  0,  0,  0,  0,139, 92, 36, 96, 15,159,192,129,195,104, 10,
/* 0x0d50 */   0,  0,141, 68, 64,  8,137, 68, 36, 76,233,  9,251,255,255,131,
/* 0x0d60 */ 196,100,184,  1,  0,  0,  0,233,207,  1,  0,  0,139,116, 36,  4,
/* 0x0d70 */  70,137,116, 36, 72, 15,132, 85,249,255,255,139, 76, 36, 12,139,
/* 0x0d80 */  68, 36, 92,131,193,  2, 57, 68, 36, 72,119,211,137,194,139,132,
/* 0x0d90 */  36,136,  0,  0,  0, 43, 68, 36, 72,  3,148, 36,136,  0,  0,  0,
/* 0x0da0 */   3, 68, 36, 92, 15,182, 56, 64,137,251,136, 26, 66,255, 68, 36,
/* 0x0db0 */  92,255, 68, 36, 24, 73, 15,132,  3,249,255,255,139,180, 36,140,
/* 0x0dc0 */   0,  0,  0, 57,116, 36, 92,114,219,233,  2,249,255,255, 41,198,
/* 0x0dd0 */  41, 68, 36, 48,137,208,137,116, 36, 52,102,193,232,  5,199, 68,
/* 0x0de0 */  36, 32, 16,  0,  0,  0,102, 41,194,199, 68, 36, 36,  8,  0,  0,
/* 0x0df0 */   0,102,137, 83,  2,129,195,  4,  2,  0,  0,137, 92, 36, 16,233,
/* 0x0e00 */ 212,250,255,255,131,108, 36, 76,  6,233,177,248,255,255,137,222,
/* 0x0e10 */  41, 68, 36, 48, 41,198,137,208,102,193,232,  5,102, 41,194,102,
/* 0x0e20 */ 137,151,224,  1,  0,  0,233, 16,255,255,255, 41,195, 41, 68, 36,
/* 0x0e30 */  48,137,208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,
/* 0x0e40 */ 102,137,151,176,  1,  0,  0, 15,134,165,  0,  0,  0,102,139,151,
/* 0x0e50 */ 200,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x0e60 */  68, 36, 48, 15,131,169,  0,  0,  0,137,198,184,  0,  8,  0,  0,
/* 0x0e70 */  41,200,193,248,  5,141,  4,  2,102,137,135,200,  1,  0,  0,139,
/* 0x0e80 */  68, 36, 64,139, 92, 36, 68,137, 92, 36, 64,233,159,254,255,255,
/* 0x0e90 */ 141, 80,251,129,124, 36, 52,255,255,255,  0,119, 29, 59,108, 36,
/* 0x0ea0 */  56, 15,132,184,254,255,255,193,100, 36, 48,  8,193,100, 36, 52,
/* 0x0eb0 */   8, 15,182, 69,  0, 69,  9, 68, 36, 48,209,108, 36, 52,  1,219,
/* 0x0ec0 */ 139, 68, 36, 52, 57, 68, 36, 48,114,  7, 41, 68, 36, 48,131,203,
/* 0x0ed0 */   1, 74,117,191,139, 84, 36, 96,193,227,  4,191,  4,  0,  0,  0,
/* 0x0ee0 */ 137, 92, 36,  4,129,194, 68,  6,  0,  0,137, 20, 36,233,119,251,
/* 0x0ef0 */ 255,255, 59,108, 36, 56, 15,132, 99,254,255,255,193,100, 36, 48,
/* 0x0f00 */   8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,233, 59,255,
/* 0x0f10 */ 255,255,137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,
/* 0x0f20 */ 139, 76, 36, 64,102, 41,194,139, 68, 36, 60,102,137,151,200,  1,
/* 0x0f30 */   0,  0,137, 76, 36, 60,233, 72,255,255,255, 91, 94, 95, 93, 85,
/* 0x0f40 */  87,191,  0,  0,  0,  0, 86, 83,131,236,100,139, 84, 36,120,199,
/* 0x0f50 */  68, 36, 92,  0,  0,  0,  0,141, 66,  4,137, 68, 36, 96,184,  1,
/* 0x0f60 */   0,  0,  0, 15,182, 74,  2,137,195,211,227,137,217, 73,137, 76,
/* 0x0f70 */  36, 88, 15,182, 74,  1,211,224,139,140, 36,144,  0,  0,  0, 72,
/* 0x0f80 */ 137, 68, 36, 84,139,132, 36,132,  0,  0,  0, 15,182, 50,199, 68,
/* 0x0f90 */  36, 76,  0,  0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,
/* 0x0fa0 */   0,199, 68, 36, 72,  1,  0,  0,  0,137,116, 36, 80,199, 68, 36,
/* 0x0fb0 */  68,  1,  0,  0,  0,199, 68, 36, 64,  1,  0,  0,  0,199, 68, 36,
/* 0x0fc0 */  60,  1,  0,  0,  0,199,  1,  0,  0,  0,  0, 15,182, 74,  1,  1,
/* 0x0fd0 */ 241,211,224,141,136, 54,  7,  0,  0, 57, 76, 36, 92,115, 14,139,
/* 0x0fe0 */  68, 36, 96,102,199,  0,  0,  4,131,192,  2,226,246,139,108, 36,
/* 0x0ff0 */ 124,199, 68, 36, 48,  0,  0,  0,  0,199, 68, 36, 52,255,255,255,
/* 0x1000 */ 255,186,  0,  0,  0,  0,137,235,  3,156, 36,128,  0,  0,  0,137,
/* 0x1010 */  92, 36, 56, 59,108, 36, 56, 15,132,128,  8,  0,  0,193,100, 36,
/* 0x1020 */  48,  8, 66, 15,182, 69,  0, 69,  9, 68, 36, 48,131,250,  4,126,
/* 0x1030 */ 226,139,180, 36,140,  0,  0,  0, 57,116, 36, 92, 15,131,226,  1,
/* 0x1040 */   0,  0,139,132, 36,136,  0,  0,  0,137, 68, 36, 24,139, 84, 36,
/* 0x1050 */  92, 35, 84, 36, 88,139, 68, 36, 76,139, 76, 36, 96,193,224,  4,
/* 0x1060 */ 137, 84, 36, 44,  1,208,129,124, 36, 52,255,255,255,  0,141, 52,
/* 0x1070 */  65,119, 29, 59,108, 36, 56, 15,132, 32,  8,  0,  0,193,100, 36,
/* 0x1080 */  48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,
/* 0x1090 */ 139, 68, 36, 52,102,139, 22,193,232, 11, 15,183,202, 15,175,193,
/* 0x10a0 */  57, 68, 36, 48, 15,131, 80,  2,  0,  0,137, 68, 36, 52,184,  0,
/* 0x10b0 */   8,  0,  0, 41,200,138, 76, 36, 80,193,248,  5,187,  1,  0,  0,
/* 0x10c0 */   0,141,  4,  2,102,137,  6,139, 68, 36, 92, 35, 68, 36, 84,139,
/* 0x10d0 */ 116, 36, 96,211,224,137,249, 15,182,209,185,  8,  0,  0,  0, 43,
/* 0x10e0 */  76, 36, 80,211,250,  1,208,105,192,  0,  6,  0,  0,131,124, 36,
/* 0x10f0 */  76,  6,141,132, 48,108, 14,  0,  0,137, 68, 36, 20, 15,142, 72,
/* 0x1100 */   1,  0,  0,139, 68, 36, 92, 43, 68, 36, 72,139,148, 36,136,  0,
/* 0x1110 */   0,  0, 15,182,  4, 16,137, 68, 36, 40,235, 46,137, 68, 36, 52,
/* 0x1120 */ 184,  0,  8,  0,  0, 41,216,137,251,193,248,  5,133,210,141,  4,
/* 0x1130 */   1,102,137,134,  0,  2,  0,  0, 15,133,106,  1,  0,  0,129,251,
/* 0x1140 */ 255,  0,  0,  0, 15,143,143,  0,  0,  0,209,100, 36, 40,139, 84,
/* 0x1150 */  36, 40,141, 60, 27,139, 76, 36, 20,129,226,  0,  1,  0,  0,129,
/* 0x1160 */ 124, 36, 52,255,255,255,  0,141,  4, 81,141, 52, 56,119, 29, 59,
/* 0x1170 */ 108, 36, 56, 15,132, 36,  7,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x1180 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x1190 */ 102,139,142,  0,  2,  0,  0,193,232, 11, 15,183,217, 15,175,195,
/* 0x11a0 */  57, 68, 36, 48, 15,130,114,255,255,255, 41, 68, 36, 52, 41, 68,
/* 0x11b0 */  36, 48,137,200,102,193,232,  5,141, 95,  1,102, 41,193,133,210,
/* 0x11c0 */ 102,137,142,  0,  2,  0,  0, 15,132,219,  0,  0,  0,129,251,255,
/* 0x11d0 */   0,  0,  0, 15,142,113,255,255,255,139, 84, 36, 24,137,223,136,
/* 0x11e0 */  26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,
/* 0x11f0 */ 143,215,  0,  0,  0,199, 68, 36, 76,  0,  0,  0,  0,139,132, 36,
/* 0x1200 */ 140,  0,  0,  0, 57, 68, 36, 92, 15,130, 63,254,255,255,129,124,
/* 0x1210 */  36, 52,255,255,255,  0,119, 12, 59,108, 36, 56,184,  1,  0,  0,
/* 0x1220 */   0,116, 32, 69, 43,108, 36,124,184,  0,  0,  0,  0,139,148, 36,
/* 0x1230 */ 132,  0,  0,  0,139, 92, 36, 92,139,140, 36,144,  0,  0,  0,137,
/* 0x1240 */  42,137, 25,131,196,100,233, 46,  8,  0,  0,129,124, 36, 52,255,
/* 0x1250 */ 255,255,  0,141, 52, 27,139, 68, 36, 20,141, 28,  6,119, 29, 59,
/* 0x1260 */ 108, 36, 56, 15,132, 52,  6,  0,  0,193,100, 36, 48,  8,193,100,
/* 0x1270 */  36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,
/* 0x1280 */ 102,139, 11,193,232, 11, 15,183,209, 15,175,194, 57, 68, 36, 48,
/* 0x1290 */ 115, 79,137, 68, 36, 52,184,  0,  8,  0,  0, 41,208,193,248,  5,
/* 0x12a0 */ 141,  4,  1,102,137,  3,137,243,129,251,255,  0,  0,  0,126,155,
/* 0x12b0 */ 139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36, 92,131,124, 36,
/* 0x12c0 */  76,  3,137, 84, 36, 24, 15,142, 41,255,255,255,131,124, 36, 76,
/* 0x12d0 */   9, 15,143,107,  6,  0,  0,131,108, 36, 76,  3,233, 28,255,255,
/* 0x12e0 */ 255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,102,
/* 0x12f0 */  41,193,102,137, 11,141, 94,  1,235,174,139, 92, 36, 52, 41, 68,
/* 0x1300 */  36, 48, 41,195,137,208,102,193,232,  5,139, 76, 36, 76,102, 41,
/* 0x1310 */ 194,129,251,255,255,255,  0,102,137, 22,139,116, 36, 96,141, 60,
/* 0x1320 */  78,119, 27, 59,108, 36, 56, 15,132,112,  5,  0,  0,193,100, 36,
/* 0x1330 */  48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,
/* 0x1340 */ 151,128,  1,  0,  0,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x1350 */  57, 68, 36, 48, 15,131,228,  2,  0,  0,137,198,184,  0,  8,  0,
/* 0x1360 */   0, 41,200,139, 92, 36, 96,193,248,  5,131,124, 36, 76,  6,141,
/* 0x1370 */   4,  2,139, 76, 36, 72,139, 84, 36, 68,102,137,135,128,  1,  0,
/* 0x1380 */   0,139, 68, 36, 64,137, 76, 36, 68,137, 68, 36, 60,184,  0,  0,
/* 0x1390 */   0,  0, 15,159,192,137, 84, 36, 64,141,  4, 64,129,195,100,  6,
/* 0x13a0 */   0,  0,137, 68, 36, 76,129,254,255,255,255,  0,119, 27, 59,108,
/* 0x13b0 */  36, 56, 15,132,229,  4,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x13c0 */   0,193,230,  8,  9, 68, 36, 48, 69,102,139, 19,137,240,193,232,
/* 0x13d0 */  11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,102,  3,  0,
/* 0x13e0 */   0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,
/* 0x13f0 */   4,193,248,  5,139, 76, 36, 44,141,  4,  2,199, 68, 36, 32,  0,
/* 0x1400 */   0,  0,  0,102,137,  3,141, 92, 25,  4,137, 92, 36, 16,199, 68,
/* 0x1410 */  36, 36,  3,  0,  0,  0,139,124, 36, 36,186,  1,  0,  0,  0,235,
/* 0x1420 */  25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5, 79,
/* 0x1430 */ 141,  4,  2,137,242,102,137,  3,116, 97,129,124, 36, 52,255,255,
/* 0x1440 */ 255,  0,141, 52, 18,139, 68, 36, 16,141, 28,  6,119, 29, 59,108,
/* 0x1450 */  36, 56, 15,132, 69,  4,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x1460 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x1470 */ 139, 19,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,
/* 0x1480 */ 160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102,
/* 0x1490 */  41,194, 79,102,137, 19,141, 86,  1,117,159,138, 76, 36, 36,184,
/* 0x14a0 */   1,  0,  0,  0,211,224, 41,194,  3, 84, 36, 32,131,124, 36, 76,
/* 0x14b0 */   3,137, 84, 36, 12, 15,143,254,  3,  0,  0,131, 68, 36, 76,  7,
/* 0x14c0 */ 131,250,  3,137,208,126,  5,184,  3,  0,  0,  0,139, 92, 36, 96,
/* 0x14d0 */ 193,224,  7,191,  6,  0,  0,  0,141,132, 24, 96,  3,  0,  0,137,
/* 0x14e0 */  68, 36,  8,184,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,
/* 0x14f0 */   8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,102,137,  3,137,
/* 0x1500 */ 240,116, 97,129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 68,
/* 0x1510 */  36,  8,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,124,  3,  0,
/* 0x1520 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x1530 */   9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,
/* 0x1540 */ 202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68,
/* 0x1550 */  36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137, 19,141,
/* 0x1560 */  70,  1,117,159,141, 80,192,131,250,  3,137, 84, 36,  4, 15,142,
/* 0x1570 */  54,  3,  0,  0,137,211,137,208,131,227,  1,209,248,131,203,  2,
/* 0x1580 */ 131,250, 13,141,120,255, 15,143, 66,  4,  0,  0,137,249,139,116,
/* 0x1590 */  36, 96,211,227,  1,210,141,  4, 94,137, 92, 36,  4, 41,208,  5,
/* 0x15a0 */  94,  5,  0,  0,137,  4, 36,184,  1,  0,  0,  0,199, 68, 36, 28,
/* 0x15b0 */   1,  0,  0,  0,235, 33,137, 68, 36, 52,184,  0,  8,  0,  0, 41,
/* 0x15c0 */ 200,193,248,  5,141,  4,  2,102,137,  3,137,240,209,100, 36, 28,
/* 0x15d0 */  79, 15,132,211,  2,  0,  0,129,124, 36, 52,255,255,255,  0,141,
/* 0x15e0 */  52,  0,139, 12, 36,141, 28, 14,119, 29, 59,108, 36, 56, 15,132,
/* 0x15f0 */ 169,  2,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x1600 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232,
/* 0x1610 */  11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,153, 41, 68, 36,
/* 0x1620 */  52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,141, 70,
/* 0x1630 */   1,102,137, 19,139, 92, 36, 28,  9, 92, 36,  4,235,142, 41,195,
/* 0x1640 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194,129,251,255,
/* 0x1650 */ 255,255,  0,102,137,151,128,  1,  0,  0, 15,134,107,  1,  0,  0,
/* 0x1660 */ 102,139,143,152,  1,  0,  0,137,218,193,234, 11, 15,183,193, 15,
/* 0x1670 */ 175,208, 57, 84, 36, 48, 15,131,134,  1,  0,  0,190,  0,  8,  0,
/* 0x1680 */   0,137,211, 41,198,137,240,193,248,  5,141,  4,  1,139, 76, 36,
/* 0x1690 */  44,102,137,135,152,  1,  0,  0,139, 68, 36, 76,193,224,  5,  3,
/* 0x16a0 */  68, 36, 96,129,250,255,255,255,  0,141, 60, 72,119, 27, 59,108,
/* 0x16b0 */  36, 56, 15,132,229,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x16c0 */   0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,224,  1,  0,  0,
/* 0x16d0 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x16e0 */ 131,103,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x16f0 */ 193,248,  5,141,  4,  2,102,137,135,224,  1,  0,  0,139, 68, 36,
/* 0x1700 */  92,133,192, 15,132,148,  1,  0,  0,131,124, 36, 76,  6,184,  0,
/* 0x1710 */   0,  0,  0,139,156, 36,136,  0,  0,  0,139, 84, 36, 24, 15,159,
/* 0x1720 */ 192,141, 68,  0,  9,137, 68, 36, 76,139, 68, 36, 92, 43, 68, 36,
/* 0x1730 */  72, 15,182, 60, 24,137,248,136,  2, 66,255, 68, 36, 92,137, 84,
/* 0x1740 */  36, 24,233,182,250,255,255, 41,198, 41, 68, 36, 48,137,208,102,
/* 0x1750 */ 193,232,  5,102, 41,194,129,254,255,255,255,  0,102,137, 19,119,
/* 0x1760 */  27, 59,108, 36, 56, 15,132, 50,  1,  0,  0,193,100, 36, 48,  8,
/* 0x1770 */  15,182, 69,  0,193,230,  8,  9, 68, 36, 48, 69,102,139, 83,  2,
/* 0x1780 */ 137,240,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x1790 */ 131,119,  1,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x17a0 */ 193,100, 36, 44,  4,193,248,  5,139,116, 36, 44,141,  4,  2,199,
/* 0x17b0 */  68, 36, 32,  8,  0,  0,  0,102,137, 67,  2,141,156, 30,  4,  1,
/* 0x17c0 */   0,  0,137, 92, 36, 16,233, 67,252,255,255, 59,108, 36, 56, 15,
/* 0x17d0 */ 132,200,  0,  0,  0,193,100, 36, 48,  8,193,227,  8,102,139,143,
/* 0x17e0 */ 152,  1,  0,  0, 15,182, 69,  0,137,218,  9, 68, 36, 48,193,234,
/* 0x17f0 */  11, 15,183,193, 69, 15,175,208, 57, 84, 36, 48, 15,130,122,254,
/* 0x1800 */ 255,255,137,200, 41,211,102,193,232,  5, 41, 84, 36, 48,102, 41,
/* 0x1810 */ 193,129,251,255,255,255,  0,102,137,143,152,  1,  0,  0,119, 23,
/* 0x1820 */  59,108, 36, 56,116,119,193,100, 36, 48,  8, 15,182, 69,  0,193,
/* 0x1830 */ 227,  8,  9, 68, 36, 48, 69,102,139,151,176,  1,  0,  0,137,216,
/* 0x1840 */ 193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 22,
/* 0x1850 */   1,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x1860 */   4,  2,102,137,135,176,  1,  0,  0,139, 68, 36, 68,139, 84, 36,
/* 0x1870 */  72,137, 68, 36, 72,137, 84, 36, 68,131,124, 36, 76,  6,184,  0,
/* 0x1880 */   0,  0,  0,139, 92, 36, 96, 15,159,192,129,195,104, 10,  0,  0,
/* 0x1890 */ 141, 68, 64,  8,137, 68, 36, 76,233,  9,251,255,255,131,196,100,
/* 0x18a0 */ 184,  1,  0,  0,  0,233,207,  1,  0,  0,139,116, 36,  4, 70,137,
/* 0x18b0 */ 116, 36, 72, 15,132, 85,249,255,255,139, 76, 36, 12,139, 68, 36,
/* 0x18c0 */  92,131,193,  2, 57, 68, 36, 72,119,211,137,194,139,132, 36,136,
/* 0x18d0 */   0,  0,  0, 43, 68, 36, 72,  3,148, 36,136,  0,  0,  0,  3, 68,
/* 0x18e0 */  36, 92, 15,182, 56, 64,137,251,136, 26, 66,255, 68, 36, 92,255,
/* 0x18f0 */  68, 36, 24, 73, 15,132,  3,249,255,255,139,180, 36,140,  0,  0,
/* 0x1900 */   0, 57,116, 36, 92,114,219,233,  2,249,255,255, 41,198, 41, 68,
/* 0x1910 */  36, 48,137,208,137,116, 36, 52,102,193,232,  5,199, 68, 36, 32,
/* 0x1920 */  16,  0,  0,  0,102, 41,194,199, 68, 36, 36,  8,  0,  0,  0,102,
/* 0x1930 */ 137, 83,  2,129,195,  4,  2,  0,  0,137, 92, 36, 16,233,212,250,
/* 0x1940 */ 255,255,131,108, 36, 76,  6,233,177,248,255,255,137,222, 41, 68,
/* 0x1950 */  36, 48, 41,198,137,208,102,193,232,  5,102, 41,194,102,137,151,
/* 0x1960 */ 224,  1,  0,  0,233, 16,255,255,255, 41,195, 41, 68, 36, 48,137,
/* 0x1970 */ 208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,
/* 0x1980 */ 151,176,  1,  0,  0, 15,134,165,  0,  0,  0,102,139,151,200,  1,
/* 0x1990 */   0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x19a0 */  48, 15,131,169,  0,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,
/* 0x19b0 */ 193,248,  5,141,  4,  2,102,137,135,200,  1,  0,  0,139, 68, 36,
/* 0x19c0 */  64,139, 92, 36, 68,137, 92, 36, 64,233,159,254,255,255,141, 80,
/* 0x19d0 */ 251,129,124, 36, 52,255,255,255,  0,119, 29, 59,108, 36, 56, 15,
/* 0x19e0 */ 132,184,254,255,255,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,
/* 0x19f0 */ 182, 69,  0, 69,  9, 68, 36, 48,209,108, 36, 52,  1,219,139, 68,
/* 0x1a00 */  36, 52, 57, 68, 36, 48,114,  7, 41, 68, 36, 48,131,203,  1, 74,
/* 0x1a10 */ 117,191,139, 84, 36, 96,193,227,  4,191,  4,  0,  0,  0,137, 92,
/* 0x1a20 */  36,  4,129,194, 68,  6,  0,  0,137, 20, 36,233,119,251,255,255,
/* 0x1a30 */  59,108, 36, 56, 15,132, 99,254,255,255,193,100, 36, 48,  8, 15,
/* 0x1a40 */ 182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,233, 59,255,255,255,
/* 0x1a50 */ 137,222, 41, 68, 36, 48, 41,198,137,208,102,193,232,  5,139, 76,
/* 0x1a60 */  36, 64,102, 41,194,139, 68, 36, 60,102,137,151,200,  1,  0,  0,
/* 0x1a70 */ 137, 76, 36, 60,233, 72,255,255,255, 91, 94, 95, 93,  3,115,252,
/* 0x1a80 */   3,123,248, 49,192,141,140, 36,  0,255,255,255,137,236, 80, 57,
/* 0x1a90 */ 204,117,251,137,236, 49,201, 93, 86,141,181,  0,  0,  0,  0, 86,
/* 0x1aa0 */ 141,189,  0,  0,  0,  0,137,239,185,  0,  0,  0,  0,138,  7, 71,
/* 0x1ab0 */  44,232, 60,  1,119,247,128, 63,  0,117,  4,139,  7,138, 95,  4,
/* 0x1ac0 */ 102,193,232,  8,134,196,193,192, 16,134,196, 41,248,128,235,232,
/* 0x1ad0 */   1,232,137,  7,131,199,  5,136,216,226,  9,185,  0,  0,  0,  0,
/* 0x1ae0 */ 176,232,176,233,242,174,117,  6,128, 63,  0,117,255,139,  7,102,
/* 0x1af0 */ 193,232,  8,134,196,193,192, 16,134,196, 41,248,  1,232,171,235,
/* 0x1b00 */   4,185,  0,  0,  0,  0,235, 31,138,  7, 71, 60,128,114, 10, 60,
/* 0x1b10 */ 143,119,  6,128,127,254, 15,116,  5, 44,232, 60,  1,119,255,131,
/* 0x1b20 */ 249,  4,114,  4,139,  7, 44,  0,117,255,134,196,193,192, 16,134,
/* 0x1b30 */ 196, 41,248,  1,232,131,233,  4,171,131,233,  1,114,  4,138,  7,
/* 0x1b40 */  71,235, 13,131,233,  1,115,  6,141,125,252, 49,192,138,  6, 70,
/* 0x1b50 */   9,192,116,  1, 60,239,119, 17,  1,199,139,  7,134,196,193,192,
/* 0x1b60 */  16,134,196,  1,232,137,  7,235,226, 36, 15,193,224, 16,102,139,
/* 0x1b70 */   6,131,198,  2,  9,192,117, 12,139,  6,131,198,  4,235, 12,255,
/* 0x1b80 */ 214, 95, 89, 41,249,193,233,  2,243,171,  7,141,165,  0,  0,  0,
/* 0x1b90 */   0,233,252,255,255,255,102,105,108,101, 32,102,111,114,109, 97,
/* 0x1ba0 */ 116, 32,101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101,
/* 0x1bb0 */  99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101,
/* 0x1bc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32,
/* 0x1bd0 */  32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77,
/* 0x1be0 */  65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102,
/* 0x1bf0 */  32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32,
/* 0x1c00 */  48, 32, 87, 67, 76, 69, 77, 65, 73, 78, 32, 32, 32, 32, 32, 32,
/* 0x1c10 */  48, 50, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32,
/* 0x1c20 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1c30 */  32, 49, 32, 87, 67, 76, 69, 77, 65, 73, 78, 48, 50, 32, 32, 32,
/* 0x1c40 */  32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 53,100, 32, 32,
/* 0x1c50 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1c60 */  32, 50, 32, 87, 67, 76, 69, 77, 65, 73, 78, 48, 51, 32, 32, 32,
/* 0x1c70 */  32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 48, 32, 32,
/* 0x1c80 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1c90 */  32, 51, 32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32,
/* 0x1ca0 */  32, 48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 54, 32,
/* 0x1cb0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1cc0 */  32, 32, 52, 32, 87, 67, 76, 69, 67, 85, 84, 80, 32, 32, 32, 32,
/* 0x1cd0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 54, 32, 32,
/* 0x1ce0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1cf0 */  32, 53, 32, 78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32,
/* 0x1d00 */  32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 54, 32, 32,
/* 0x1d10 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1d20 */  32, 54, 32, 78, 50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32,
/* 0x1d30 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 57, 32, 32,
/* 0x1d40 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1d50 */  32, 55, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32,
/* 0x1d60 */  32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 98, 32, 32,
/* 0x1d70 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1d80 */  32, 56, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32,
/* 0x1d90 */  32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 49, 32, 32,
/* 0x1da0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1db0 */  32, 57, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32,
/* 0x1dc0 */  32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 99, 32, 32,
/* 0x1dd0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1de0 */  49, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32,
/* 0x1df0 */  32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 49, 32, 32,
/* 0x1e00 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1e10 */  49, 49, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32,
/* 0x1e20 */  32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 97, 32, 32,
/* 0x1e30 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1e40 */  49, 50, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32,
/* 0x1e50 */  32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 55, 32, 32,
/* 0x1e60 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1e70 */  49, 51, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32,
/* 0x1e80 */  32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 99, 52, 32, 32,
/* 0x1e90 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x1ea0 */  49, 52, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32,
/* 0x1eb0 */  32, 48, 51,101, 32, 32, 48, 32, 32, 48, 32, 32, 48,100, 51, 32,
/* 0x1ec0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x1ed0 */  32, 49, 53, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32,
/* 0x1ee0 */  32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 49,
/* 0x1ef0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1f00 */  10, 32, 49, 54, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 32, 32,
/* 0x1f10 */  32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49,
/* 0x1f20 */ 101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1f30 */  83, 10, 32, 49, 55, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32,
/* 0x1f40 */  32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x1f50 */  50,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1f60 */  84, 83, 10, 32, 49, 56, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32,
/* 0x1f70 */  32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1f80 */  49, 50,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1f90 */  78, 84, 83, 10, 32, 49, 57, 32, 78, 50, 66, 68, 69, 67, 53, 48,
/* 0x1fa0 */  32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x1fb0 */  48, 49, 51, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1fc0 */  69, 78, 84, 83, 10, 32, 50, 48, 32, 78, 50, 66, 83, 77, 65, 54,
/* 0x1fd0 */  48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32, 48, 32, 32, 48, 32,
/* 0x1fe0 */  32, 48, 49, 51, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ff0 */  84, 69, 78, 84, 83, 10, 32, 50, 49, 32, 78, 50, 66, 70, 65, 83,
/* 0x2000 */  54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32,
/* 0x2010 */  48, 32, 32, 48, 49, 52, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2020 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 50, 32, 78, 50, 66, 70,
/* 0x2030 */  65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48,
/* 0x2040 */  32, 32, 48, 32, 32, 48, 49, 54, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x2050 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 51, 32, 78, 50,
/* 0x2060 */  66, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48,
/* 0x2070 */  32, 32, 48, 32, 32, 48, 49, 55, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x2080 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 52, 32, 78, 50,
/* 0x2090 */  68, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x20a0 */  48, 32, 32, 48, 32, 32, 48, 49, 55, 54, 32, 32, 50, 42, 42, 48,
/* 0x20b0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 53, 32, 78,
/* 0x20c0 */  50, 68, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32,
/* 0x20d0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 55, 57, 32, 32, 50, 42, 42,
/* 0x20e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 54, 32,
/* 0x20f0 */  78, 50, 68, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54,
/* 0x2100 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 55, 98, 32, 32, 50, 42,
/* 0x2110 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 55,
/* 0x2120 */  32, 78, 50, 68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2130 */  98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 49, 32, 32, 50,
/* 0x2140 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x2150 */  56, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x2160 */  48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 99, 32, 32,
/* 0x2170 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2180 */  50, 57, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32,
/* 0x2190 */  32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 49, 32,
/* 0x21a0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x21b0 */  32, 51, 48, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x21c0 */  32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 97,
/* 0x21d0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x21e0 */  10, 32, 51, 49, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 32, 32,
/* 0x21f0 */  32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x2200 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2210 */  83, 10, 32, 51, 50, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 32,
/* 0x2220 */  32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2230 */  98, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2240 */  84, 83, 10, 32, 51, 51, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32,
/* 0x2250 */  32, 32, 32, 32, 32, 48, 53, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2260 */  48, 49, 99, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2270 */  69, 78, 84, 83, 10, 32, 51, 52, 32, 78, 50, 68, 83, 77, 65, 52,
/* 0x2280 */  48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32,
/* 0x2290 */  32, 48, 50, 49, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x22a0 */  84, 69, 78, 84, 83, 10, 32, 51, 53, 32, 78, 50, 68, 70, 65, 83,
/* 0x22b0 */  52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48,
/* 0x22c0 */  32, 32, 48, 50, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x22d0 */  78, 84, 69, 78, 84, 83, 10, 32, 51, 54, 32, 78, 50, 68, 83, 77,
/* 0x22e0 */  65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x22f0 */  48, 32, 32, 48, 50, 51, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2300 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 55, 32, 78, 50, 68, 70,
/* 0x2310 */  65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32,
/* 0x2320 */  32, 48, 32, 32, 48, 50, 51, 51, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2330 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 56, 32, 78, 50, 68,
/* 0x2340 */  68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48,
/* 0x2350 */  32, 32, 48, 32, 32, 48, 50, 51, 54, 32, 32, 50, 42, 42, 48, 32,
/* 0x2360 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 57, 32, 78, 50,
/* 0x2370 */  68, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48, 99, 32, 32,
/* 0x2380 */  48, 32, 32, 48, 32, 32, 48, 50, 51,102, 32, 32, 50, 42, 42, 48,
/* 0x2390 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 48, 32, 78,
/* 0x23a0 */  50, 68, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 57,
/* 0x23b0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 52, 98, 32, 32, 50, 42,
/* 0x23c0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 49,
/* 0x23d0 */  32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x23e0 */  49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 52, 32, 32,
/* 0x23f0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2400 */  52, 50, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32,
/* 0x2410 */  32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 97, 32, 32,
/* 0x2420 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2430 */  52, 51, 32, 78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32,
/* 0x2440 */  32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 97, 32,
/* 0x2450 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2460 */  32, 52, 52, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32,
/* 0x2470 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55,100,
/* 0x2480 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2490 */  10, 32, 52, 53, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 32, 32,
/* 0x24a0 */  32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55,
/* 0x24b0 */ 102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x24c0 */  83, 10, 32, 52, 54, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32,
/* 0x24d0 */  32, 32, 32, 32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x24e0 */  56, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x24f0 */  84, 83, 10, 32, 52, 55, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32,
/* 0x2500 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2510 */  50, 57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2520 */  78, 84, 83, 10, 32, 52, 56, 32, 78, 50, 69, 70, 65, 83, 50, 48,
/* 0x2530 */  32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2540 */  48, 50, 57, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2550 */  69, 78, 84, 83, 10, 32, 52, 57, 32, 78, 50, 69, 68, 69, 67, 50,
/* 0x2560 */  48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32,
/* 0x2570 */  32, 48, 50, 57,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2580 */  84, 69, 78, 84, 83, 10, 32, 53, 48, 32, 78, 50, 69, 83, 77, 65,
/* 0x2590 */  51, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48,
/* 0x25a0 */  32, 32, 48, 50, 97, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x25b0 */  78, 84, 69, 78, 84, 83, 10, 32, 53, 49, 32, 78, 50, 69, 70, 65,
/* 0x25c0 */  83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32,
/* 0x25d0 */  48, 32, 32, 48, 50, 98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x25e0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 50, 32, 78, 50, 69, 68,
/* 0x25f0 */  69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 53,102, 32, 32, 48,
/* 0x2600 */  32, 32, 48, 32, 32, 48, 50, 99, 55, 32, 32, 50, 42, 42, 48, 32,
/* 0x2610 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 51, 32, 78, 50,
/* 0x2620 */  69, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32,
/* 0x2630 */  48, 32, 32, 48, 32, 32, 48, 51, 50, 54, 32, 32, 50, 42, 42, 48,
/* 0x2640 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 52, 32, 78,
/* 0x2650 */  50, 69, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32,
/* 0x2660 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 51, 51, 32, 32, 50, 42, 42,
/* 0x2670 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 53, 32,
/* 0x2680 */  78, 50, 69, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x2690 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 50, 32, 32, 50, 42,
/* 0x26a0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 54,
/* 0x26b0 */  32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x26c0 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 52, 32, 32, 50,
/* 0x26d0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53,
/* 0x26e0 */  55, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32,
/* 0x26f0 */  48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 55, 32, 32,
/* 0x2700 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2710 */  53, 56, 32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32,
/* 0x2720 */  32, 48, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 53, 48, 32,
/* 0x2730 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2740 */  32, 53, 57, 32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32,
/* 0x2750 */  32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 53,
/* 0x2760 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2770 */  83, 10, 32, 54, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 32,
/* 0x2780 */  32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2790 */  51, 55, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x27a0 */  78, 84, 83, 10, 32, 54, 49, 32, 78, 50, 69, 68, 69, 67, 54, 48,
/* 0x27b0 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x27c0 */  51, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x27d0 */  78, 84, 83, 10, 32, 54, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x27e0 */  48, 48, 32, 32, 32, 32, 48, 50,101, 32, 32, 48, 32, 32, 48, 32,
/* 0x27f0 */  32, 48, 51, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2800 */  84, 69, 78, 84, 83, 10, 32, 54, 51, 32, 76, 90, 77, 65, 95, 69,
/* 0x2810 */  76, 70, 48, 48, 32, 32, 32, 32, 48, 52, 56, 32, 32, 48, 32, 32,
/* 0x2820 */  48, 32, 32, 48, 51, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2830 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 52, 32, 76, 90, 77, 65,
/* 0x2840 */  95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 98, 51,101, 32, 32,
/* 0x2850 */  48, 32, 32, 48, 32, 32, 48, 52, 48, 49, 32, 32, 50, 42, 42, 48,
/* 0x2860 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 53, 32, 76,
/* 0x2870 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 98, 51,
/* 0x2880 */ 101, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 51,102, 32, 32, 50,
/* 0x2890 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54,
/* 0x28a0 */  54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32,
/* 0x28b0 */  48, 49, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 55,100,
/* 0x28c0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x28d0 */  10, 32, 54, 55, 32, 87, 67, 76, 69, 77, 65, 73, 50, 32, 32, 32,
/* 0x28e0 */  32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x28f0 */  57, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2900 */  84, 83, 10, 32, 54, 56, 32, 87, 67, 67, 84, 84, 80, 79, 83, 32,
/* 0x2910 */  32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2920 */  49, 97, 97, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2930 */  69, 78, 84, 83, 10, 32, 54, 57, 32, 87, 67, 67, 84, 84, 78, 85,
/* 0x2940 */  76, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32,
/* 0x2950 */  32, 48, 49, 97, 97, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2960 */  78, 84, 69, 78, 84, 83, 10, 32, 55, 48, 32, 67, 65, 76, 76, 84,
/* 0x2970 */  82, 48, 48, 32, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32,
/* 0x2980 */  48, 32, 32, 48, 49, 97, 97, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2990 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 49, 32, 67, 84, 67,
/* 0x29a0 */  76, 69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48,
/* 0x29b0 */  32, 32, 48, 32, 32, 48, 49, 97, 98, 54, 32, 32, 50, 42, 42, 48,
/* 0x29c0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 50, 32, 67,
/* 0x29d0 */  65, 76, 76, 84, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x29e0 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 98, 98, 32, 32, 50, 42,
/* 0x29f0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 51,
/* 0x2a00 */  32, 67, 84, 66, 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48,
/* 0x2a10 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 48, 32, 32,
/* 0x2a20 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2a30 */  55, 52, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32,
/* 0x2a40 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 52,
/* 0x2a50 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2a60 */  10, 32, 55, 53, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32,
/* 0x2a70 */  32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x2a80 */  99, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2a90 */  84, 83, 10, 32, 55, 54, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32,
/* 0x2aa0 */  32, 32, 32, 32, 32, 48, 49, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2ab0 */  48, 49, 97, 99, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2ac0 */  84, 69, 78, 84, 83, 10, 32, 55, 55, 32, 67, 65, 76, 76, 84, 82,
/* 0x2ad0 */  49, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x2ae0 */  32, 32, 48, 49, 97,100, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2af0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 56, 32, 67, 65, 76, 76,
/* 0x2b00 */  84, 82, 69, 56, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x2b10 */  32, 48, 32, 32, 48, 49, 97,101, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x2b20 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 57, 32, 67, 65,
/* 0x2b30 */  76, 76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32,
/* 0x2b40 */  48, 32, 32, 48, 32, 32, 48, 49, 97,101, 50, 32, 32, 50, 42, 42,
/* 0x2b50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 48, 32,
/* 0x2b60 */  67, 65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x2b70 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,101, 52, 32, 32, 50,
/* 0x2b80 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2b90 */  49, 32, 67, 84, 67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32,
/* 0x2ba0 */  48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,101, 56, 32,
/* 0x2bb0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2bc0 */  32, 56, 50, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32,
/* 0x2bd0 */  32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,101,
/* 0x2be0 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2bf0 */  83, 10, 32, 56, 51, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32,
/* 0x2c00 */  32, 32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2c10 */  97,101,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2c20 */  78, 84, 83, 10, 32, 56, 52, 32, 67, 84, 66, 82, 79, 82, 49, 49,
/* 0x2c30 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2c40 */  48, 49, 97,102, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2c50 */  84, 69, 78, 84, 83, 10, 32, 56, 53, 32, 67, 84, 66, 83, 87, 65,
/* 0x2c60 */  49, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48,
/* 0x2c70 */  32, 32, 48, 49, 97,102, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2c80 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 54, 32, 67, 65, 76, 76,
/* 0x2c90 */  84, 82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32,
/* 0x2ca0 */  32, 48, 32, 32, 48, 49, 97,102, 97, 32, 32, 50, 42, 42, 48, 32,
/* 0x2cb0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 55, 32, 99,116,
/* 0x2cc0 */ 111,107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 97, 32, 32,
/* 0x2cd0 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 48, 49, 32, 32, 50, 42, 42,
/* 0x2ce0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 56, 32,
/* 0x2cf0 */  99,116,111,107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48,101,
/* 0x2d00 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 48, 98, 32, 32, 50,
/* 0x2d10 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2d20 */  57, 32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32,
/* 0x2d30 */  48, 50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 49, 57,
/* 0x2d40 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2d50 */  10, 32, 57, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32,
/* 0x2d60 */  32, 32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x2d70 */  51, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2d80 */  84, 83, 10, 32, 57, 49, 32, 99,116,111,107, 51, 50, 46, 52, 48,
/* 0x2d90 */  32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2da0 */  49, 98, 52, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2db0 */  69, 78, 84, 83, 10, 32, 57, 50, 32, 87, 67, 82, 69, 76, 79, 67,
/* 0x2dc0 */  49, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x2dd0 */  32, 48, 49, 98, 52, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2de0 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 51, 32, 82, 69, 76, 79, 67,
/* 0x2df0 */  51, 50, 48, 32, 32, 32, 32, 32, 32, 48, 50, 57, 32, 32, 48, 32,
/* 0x2e00 */  32, 48, 32, 32, 48, 49, 98, 52, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x2e10 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 52, 32, 82, 69,
/* 0x2e20 */  76, 51, 50, 66, 73, 71, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32,
/* 0x2e30 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 55, 52, 32, 32, 50, 42, 42,
/* 0x2e40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 53, 32,
/* 0x2e50 */  82, 69, 76, 79, 67, 51, 50, 74, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x2e60 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55,100, 32, 32, 50,
/* 0x2e70 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57,
/* 0x2e80 */  54, 32, 82, 69, 76, 51, 50, 69, 78, 68, 32, 32, 32, 32, 32, 32,
/* 0x2e90 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55,102, 32, 32,
/* 0x2ea0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2eb0 */  57, 55, 32, 87, 67, 82, 69, 76, 83, 69, 76, 32, 32, 32, 32, 32,
/* 0x2ec0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55,102,
/* 0x2ed0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2ee0 */  10, 32, 57, 56, 32, 87, 67, 76, 69, 77, 65, 73, 52, 32, 32, 32,
/* 0x2ef0 */  32, 32, 32, 48, 49, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2f00 */  98, 56, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2f10 */  78, 84, 83, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69,
/* 0x2f20 */  58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2f30 */ 100, 32, 32, 87, 67, 76, 69, 67, 85, 84, 80, 32, 48, 32, 87, 67,
/* 0x2f40 */  76, 69, 67, 85, 84, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f50 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 49, 48,
/* 0x2f60 */  32, 48, 32, 78, 50, 66, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48,
/* 0x2f70 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x2f80 */  70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49, 49,
/* 0x2f90 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x2fa0 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 66,
/* 0x2fb0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x2fc0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 32,
/* 0x2fd0 */  48, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2fe0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68,
/* 0x2ff0 */  69, 67, 51, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 51, 48, 10,
/* 0x3000 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3010 */  32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 66, 68,
/* 0x3020 */  69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3030 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 49, 32, 48,
/* 0x3040 */  32, 78, 50, 66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x3050 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69,
/* 0x3060 */  67, 54, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48,
/* 0x3070 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3080 */  78, 50, 68, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 68, 83, 77,
/* 0x3090 */  65, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x30a0 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 49, 32, 48, 32,
/* 0x30b0 */  78, 50, 68, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x30c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x30d0 */  49, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x30e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x30f0 */  50, 68, 68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67,
/* 0x3100 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3110 */  32,100, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 48, 32, 78,
/* 0x3120 */  50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3130 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 53,
/* 0x3140 */  48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 48, 48, 48,
/* 0x3150 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3160 */  68, 70, 65, 83, 54, 49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 54,
/* 0x3170 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3180 */ 100, 32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50,
/* 0x3190 */  68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x31a0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48,
/* 0x31b0 */  32, 48, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48,
/* 0x31c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x31d0 */  70, 65, 83, 49, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 49,
/* 0x31e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x31f0 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 69,
/* 0x3200 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3210 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32,
/* 0x3220 */  48, 32, 78, 50, 69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x3230 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68,
/* 0x3240 */  69, 67, 51, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10,
/* 0x3250 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3260 */  32, 78, 50, 69, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 69, 68,
/* 0x3270 */  69, 67, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3280 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 48,
/* 0x3290 */  32, 78, 50, 69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x32a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69,
/* 0x32b0 */  67, 54, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 48,
/* 0x32c0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x32d0 */  67, 65, 76, 76, 84, 82, 48, 48, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x32e0 */  82, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x32f0 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 48, 32, 48, 32,
/* 0x3300 */  67, 65, 76, 76, 84, 82, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3310 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x3320 */  49, 49, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 48, 48,
/* 0x3330 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x3340 */  65, 76, 76, 84, 82, 49, 51, 32, 48, 32, 67, 65, 76, 76, 84, 82,
/* 0x3350 */  49, 51, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3360 */  32,100, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32, 48, 32,
/* 0x3370 */  99,116,111,107, 51, 50, 46, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3380 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51,
/* 0x3390 */  50, 46, 49, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 49, 48,
/* 0x33a0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x33b0 */  32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 48, 32, 99,116,
/* 0x33c0 */ 111,107, 51, 50, 46, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33d0 */  32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x33e0 */  52, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48,
/* 0x33f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3400 */  82, 69, 76, 79, 67, 51, 50, 48, 32, 48, 32, 82, 69, 76, 79, 67,
/* 0x3410 */  51, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3420 */  32, 32,100, 32, 32, 82, 69, 76, 79, 67, 51, 50, 74, 32, 48, 32,
/* 0x3430 */  82, 69, 76, 79, 67, 51, 50, 74, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3440 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 87, 67, 76, 69, 77, 65,
/* 0x3450 */  73, 78, 32, 48, 32, 87, 67, 76, 69, 77, 65, 73, 78, 10, 48, 48,
/* 0x3460 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 87,
/* 0x3470 */  67, 76, 69, 77, 65, 73, 78, 48, 50, 32, 48, 32, 87, 67, 76, 69,
/* 0x3480 */  77, 65, 73, 78, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3490 */ 108, 32, 32, 32, 32,100, 32, 32, 87, 67, 76, 69, 77, 65, 73, 78,
/* 0x34a0 */  48, 51, 32, 48, 32, 87, 67, 76, 69, 77, 65, 73, 78, 48, 51, 10,
/* 0x34b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x34c0 */  32, 85, 80, 88, 49, 72, 69, 65, 68, 32, 48, 32, 85, 80, 88, 49,
/* 0x34d0 */  72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x34e0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 48, 32, 48,
/* 0x34f0 */  32, 78, 50, 66, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3500 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,
/* 0x3510 */  65, 50, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 50, 48, 10, 48,
/* 0x3520 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3530 */  78, 50, 66, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 66, 70, 65,
/* 0x3540 */  83, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3550 */  32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 51, 48, 32, 48, 32,
/* 0x3560 */  78, 50, 66, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3570 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83,
/* 0x3580 */  51, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 51, 48, 10, 48, 48,
/* 0x3590 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x35a0 */  50, 66, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65,
/* 0x35b0 */  52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x35c0 */  32,100, 32, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 48, 32, 78,
/* 0x35d0 */  50, 66, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x35e0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 53,
/* 0x35f0 */  48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 53, 48, 10, 48, 48, 48,
/* 0x3600 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3610 */  66, 70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 53,
/* 0x3620 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3630 */ 100, 32, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50,
/* 0x3640 */  66, 83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3650 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 54, 48,
/* 0x3660 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48,
/* 0x3670 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x3680 */  70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 49, 48,
/* 0x3690 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x36a0 */  32, 32, 78, 50, 68, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 68,
/* 0x36b0 */  83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x36c0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 50, 48, 32,
/* 0x36d0 */  48, 32, 78, 50, 68, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x36e0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83,
/* 0x36f0 */  77, 65, 51, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 51, 48, 10,
/* 0x3700 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3710 */  32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 68, 70,
/* 0x3720 */  65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3730 */  32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 48,
/* 0x3740 */  32, 78, 50, 68, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3750 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,
/* 0x3760 */  83, 52, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 52, 48, 10, 48,
/* 0x3770 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3780 */  78, 50, 68, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 68, 83, 77,
/* 0x3790 */  65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x37a0 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 53, 48, 32, 48, 32,
/* 0x37b0 */  78, 50, 68, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x37c0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x37d0 */  54, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 54, 48, 10, 48, 48,
/* 0x37e0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x37f0 */  50, 68, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83,
/* 0x3800 */  54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3810 */  32,100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 48, 32, 78,
/* 0x3820 */  50, 69, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3830 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 50,
/* 0x3840 */  48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 50, 48, 10, 48, 48, 48,
/* 0x3850 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3860 */  69, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 50,
/* 0x3870 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3880 */ 100, 32, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32, 48, 32, 78, 50,
/* 0x3890 */  69, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x38a0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 51, 48,
/* 0x38b0 */  32, 48, 32, 78, 50, 69, 70, 65, 83, 51, 48, 10, 48, 48, 48, 48,
/* 0x38c0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x38d0 */  83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 52, 48,
/* 0x38e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x38f0 */  32, 32, 78, 50, 69, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50, 69,
/* 0x3900 */  70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3910 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 53, 48, 32,
/* 0x3920 */  48, 32, 78, 50, 69, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x3930 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3940 */  65, 83, 53, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 53, 48, 10,
/* 0x3950 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3960 */  32, 78, 50, 69, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 69, 83,
/* 0x3970 */  77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3980 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 48,
/* 0x3990 */  32, 78, 50, 69, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x39a0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95,
/* 0x39b0 */  68, 69, 67, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x39c0 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x39d0 */  32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48,
/* 0x39e0 */  32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48,
/* 0x39f0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x3a00 */  65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68,
/* 0x3a10 */  69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3a20 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x3a30 */  32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x3a40 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3a50 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x3a60 */  95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3a70 */ 108, 32, 32, 32, 32,100, 32, 32, 87, 67, 76, 69, 77, 65, 73, 50,
/* 0x3a80 */  32, 48, 32, 87, 67, 76, 69, 77, 65, 73, 50, 10, 48, 48, 48, 48,
/* 0x3a90 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 87, 67, 67,
/* 0x3aa0 */  84, 84, 80, 79, 83, 32, 48, 32, 87, 67, 67, 84, 84, 80, 79, 83,
/* 0x3ab0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3ac0 */  32, 32, 87, 67, 67, 84, 84, 78, 85, 76, 32, 48, 32, 87, 67, 67,
/* 0x3ad0 */  84, 84, 78, 85, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3ae0 */  32, 32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32,
/* 0x3af0 */  48, 32, 67, 84, 67, 76, 69, 86, 69, 49, 10, 48, 48, 48, 48, 48,
/* 0x3b00 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76,
/* 0x3b10 */  84, 82, 48, 49, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10,
/* 0x3b20 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3b30 */  32, 67, 84, 66, 83, 72, 82, 48, 49, 32, 48, 32, 67, 84, 66, 83,
/* 0x3b40 */  72, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3b50 */  32, 32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 48,
/* 0x3b60 */  32, 67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x3b70 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87,
/* 0x3b80 */  65, 48, 49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 48, 49, 10, 48,
/* 0x3b90 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3ba0 */  67, 65, 76, 76, 84, 82, 48, 50, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x3bb0 */  82, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3bc0 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 48, 32,
/* 0x3bd0 */  67, 65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3be0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82,
/* 0x3bf0 */  69, 57, 32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48,
/* 0x3c00 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x3c10 */  84, 67, 76, 69, 86, 69, 50, 32, 48, 32, 67, 84, 67, 76, 69, 86,
/* 0x3c20 */  69, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3c30 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 48, 32, 67,
/* 0x3c40 */  65, 76, 76, 84, 82, 49, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c50 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 49,
/* 0x3c60 */  49, 32, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48,
/* 0x3c70 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x3c80 */  66, 82, 79, 82, 49, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 49,
/* 0x3c90 */  49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3ca0 */ 100, 32, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 48, 32, 67, 84,
/* 0x3cb0 */  66, 83, 87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3cc0 */ 108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 51,
/* 0x3cd0 */  48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10, 48, 48,
/* 0x3ce0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 87,
/* 0x3cf0 */  67, 82, 69, 76, 79, 67, 49, 32, 48, 32, 87, 67, 82, 69, 76, 79,
/* 0x3d00 */  67, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3d10 */  32,100, 32, 32, 82, 69, 76, 51, 50, 66, 73, 71, 32, 48, 32, 82,
/* 0x3d20 */  69, 76, 51, 50, 66, 73, 71, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d30 */  32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 51, 50, 69, 78,
/* 0x3d40 */  68, 32, 48, 32, 82, 69, 76, 51, 50, 69, 78, 68, 10, 48, 48, 48,
/* 0x3d50 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 87, 67,
/* 0x3d60 */  82, 69, 76, 83, 69, 76, 32, 48, 32, 87, 67, 82, 69, 76, 83, 69,
/* 0x3d70 */  76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3d80 */ 100, 32, 32, 87, 67, 76, 69, 77, 65, 73, 52, 32, 48, 32, 87, 67,
/* 0x3d90 */  76, 69, 77, 65, 73, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3da0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x3db0 */  99,111,112,121, 95,115,111,117,114, 99,101, 10, 48, 48, 48, 48,
/* 0x3dc0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x3dd0 */  68, 42, 32, 48, 32, 99,111,112,121, 95,100,101,115,116, 10, 48,
/* 0x3de0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3df0 */  42, 85, 78, 68, 42, 32, 48, 32,119,111,114,100,115, 95,116,111,
/* 0x3e00 */  95, 99,111,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3e10 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,
/* 0x3e20 */ 122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,117,115,116,
/* 0x3e30 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e40 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109, 97, 95,117,
/* 0x3e50 */  95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x3e60 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,
/* 0x3e70 */ 109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e80 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x3e90 */  48, 32,108,122,109, 97, 95,112,114,111,112,101,114,116,105,101,
/* 0x3ea0 */ 115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3eb0 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,115,116, 97,114,116,
/* 0x3ec0 */  95,111,102, 95,114,101,108,111, 99,115, 10, 48, 48, 48, 48, 48,
/* 0x3ed0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3ee0 */  42, 32, 48, 32,102,105,108,116,101,114, 95, 98,117,102,102,101,
/* 0x3ef0 */ 114, 95,115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x3f10 */  32,102,105,108,116,101,114, 95,108,101,110,103,116,104, 10, 48,
/* 0x3f20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f30 */  42, 85, 78, 68, 42, 32, 48, 32,102,105,108,116,101,114, 95, 99,
/* 0x3f40 */ 116,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x3f50 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,111,114,105,103,
/* 0x3f60 */ 105,110, 97,108, 95,115,116, 97, 99,107, 10, 48, 48, 48, 48, 48,
/* 0x3f70 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3f80 */  42, 32, 48, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,
/* 0x3f90 */ 114,121, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x3fa0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 87, 67, 76, 69,
/* 0x3fb0 */  77, 65, 73, 78, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x3fc0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3fd0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50,
/* 0x3fe0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ff0 */  32, 32, 32, 99,111,112,121, 95,115,111,117,114, 99,101, 10, 48,
/* 0x4000 */  48, 48, 48, 48, 48, 49, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x4010 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,112,121, 95,100,
/* 0x4020 */ 101,115,116, 10, 48, 48, 48, 48, 48, 48, 49,100, 32, 82, 95, 51,
/* 0x4030 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,119,
/* 0x4040 */ 111,114,100,115, 95,116,111, 95, 99,111,112,121, 10, 10, 82, 69,
/* 0x4050 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x4060 */  32, 70, 79, 82, 32, 91, 87, 67, 76, 69, 77, 65, 73, 78, 48, 51,
/* 0x4070 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4080 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4090 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x40a0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 87,
/* 0x40b0 */  67, 76, 69, 67, 85, 84, 80, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x40c0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x40d0 */  91, 78, 50, 66, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x40e0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x40f0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4100 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4110 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x4120 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4130 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,
/* 0x4140 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4150 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4160 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x4170 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4180 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x4190 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x41a0 */  82, 32, 91, 78, 50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70,
/* 0x41b0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x41c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x41d0 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x41e0 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65,
/* 0x41f0 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4200 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70,
/* 0x4210 */  65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4220 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4230 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51,
/* 0x4240 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x4250 */  32, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76,
/* 0x4260 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4270 */  70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10,
/* 0x4280 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4290 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x42a0 */  10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,
/* 0x42b0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x42c0 */  69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x42d0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x42e0 */  66, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x42f0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4300 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4310 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4320 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x4330 */  48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x4340 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50,
/* 0x4350 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4360 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69,
/* 0x4370 */  67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4380 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4390 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32,
/* 0x43a0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x43b0 */  32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x43c0 */  48, 50,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x43d0 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10,
/* 0x43e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x43f0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48,
/* 0x4400 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4420 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x4430 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4440 */  50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4450 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4460 */  91, 78, 50, 66, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4470 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4480 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4490 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x44a0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,
/* 0x44b0 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x44c0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x44d0 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x44e0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x44f0 */  66, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4500 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4510 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4520 */  48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4530 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x4540 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4550 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93,
/* 0x4560 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4570 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4580 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56,
/* 0x4590 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x45a0 */  66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32,
/* 0x45b0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x45c0 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x45d0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x45e0 */  79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x45f0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4600 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4620 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x4630 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4640 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x4650 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4660 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4670 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4680 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4690 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x46a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x46b0 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58,
/* 0x46c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x46d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x46e0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x46f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x4700 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4710 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4720 */  50, 68, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4730 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4740 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4750 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4760 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10,
/* 0x4770 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4780 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48,
/* 0x4790 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x47a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x47b0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x47c0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x47d0 */  50, 68, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x47e0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x47f0 */  91, 78, 50, 68, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4800 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4810 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4820 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4830 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x4840 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4850 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83,
/* 0x4860 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4870 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4880 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82,
/* 0x4890 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x48a0 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x48b0 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x48c0 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82,
/* 0x48d0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x48e0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93,
/* 0x48f0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4900 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4910 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x4920 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x4930 */  68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32,
/* 0x4940 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4950 */  32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x4960 */  48, 52, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4970 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10,
/* 0x4980 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4990 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48,
/* 0x49a0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x49b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x49c0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x49d0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x49e0 */  50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x49f0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4a00 */  91, 78, 50, 68, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4a10 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a20 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4a30 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4a40 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x4a50 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x4a60 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x4a70 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4a80 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x4a90 */  68, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4aa0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ab0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4ac0 */  48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x4ad0 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x4ae0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4af0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93,
/* 0x4b00 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4b10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4b20 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56,
/* 0x4b30 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x4b40 */  68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32,
/* 0x4b50 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4b60 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x4b70 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4b80 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x4b90 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4ba0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4bb0 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x4bc0 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x4bd0 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4be0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x4bf0 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4c00 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c10 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c20 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4c30 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x4c40 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x4c50 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58,
/* 0x4c60 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4c70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4c80 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x4c90 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x4ca0 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x4cb0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x4cc0 */  50, 69, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x4cd0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ce0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4cf0 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4d00 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10,
/* 0x4d10 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4d20 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48,
/* 0x4d30 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4d40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4d50 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x4d60 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4d70 */  50, 69, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4d80 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4d90 */  91, 78, 50, 69, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4da0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4db0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4dc0 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4dd0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x4de0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4df0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83,
/* 0x4e00 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4e10 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e20 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82,
/* 0x4e30 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e40 */  32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4e50 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4e60 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82,
/* 0x4e70 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x4e80 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93,
/* 0x4e90 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x4ea0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x4eb0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x4ec0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x4ed0 */  69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32,
/* 0x4ee0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ef0 */  32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x4f00 */  48, 51, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x4f10 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10,
/* 0x4f20 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4f30 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48,
/* 0x4f40 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4f50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4f60 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x4f70 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x4f80 */  50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4f90 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4fa0 */  91, 78, 50, 69, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4fb0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fc0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4fd0 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4fe0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x4ff0 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x5000 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x5010 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5020 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5030 */  69, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5040 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5050 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5060 */  48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5070 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x5080 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5090 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93,
/* 0x50a0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x50b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x50c0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56,
/* 0x50d0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x50e0 */  69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32,
/* 0x50f0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5100 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5110 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5120 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x5130 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5140 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5150 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5160 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x5170 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5180 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x5190 */  65, 95, 68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x51a0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51b0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x51c0 */  48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x51d0 */  32, 32, 32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107,
/* 0x51e0 */  95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52,
/* 0x51f0 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x5200 */  32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48,
/* 0x5210 */  48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x5220 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,
/* 0x5230 */ 108,101,110, 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51,
/* 0x5240 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x5250 */ 122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 10,
/* 0x5260 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5270 */  68, 83, 32, 70, 79, 82, 32, 91, 87, 67, 76, 69, 77, 65, 73, 50,
/* 0x5280 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5290 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x52a0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 51,
/* 0x52b0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,
/* 0x52c0 */ 116, 97,114,116, 95,111,102, 95,114,101,108,111, 99,115, 10, 10,
/* 0x52d0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x52e0 */  68, 83, 32, 70, 79, 82, 32, 91, 87, 67, 67, 84, 84, 80, 79, 83,
/* 0x52f0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5300 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5310 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x5320 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x5330 */ 105,108,116,101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,
/* 0x5340 */ 114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5350 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x5360 */  84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5370 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5380 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x5390 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x53a0 */  32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104,
/* 0x53b0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x53c0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86,
/* 0x53d0 */  69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x53e0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x53f0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,
/* 0x5400 */  95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5410 */  32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48,
/* 0x5420 */  48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x5430 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10,
/* 0x5440 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5450 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48,
/* 0x5460 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x5470 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x5480 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95,
/* 0x5490 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x54a0 */  67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x54b0 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x54c0 */  32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x54d0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x54e0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x54f0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x5500 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x5510 */ 108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5520 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5530 */  67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x5540 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5550 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x5560 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x5570 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51, 10,
/* 0x5580 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5590 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86, 69,
/* 0x55a0 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x55b0 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x55c0 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x55d0 */  51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x55e0 */ 102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48,
/* 0x55f0 */  48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5600 */  32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 10,
/* 0x5610 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5620 */  68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 51,
/* 0x5630 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5640 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5650 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51,
/* 0x5660 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,
/* 0x5670 */  65, 76, 76, 84, 82, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5680 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5690 */  91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x56a0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x56b0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x56c0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x56d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x56e0 */ 108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x56f0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5700 */  32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76,
/* 0x5710 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x5720 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 49, 48, 93, 58,
/* 0x5730 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5740 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5750 */  69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54,
/* 0x5760 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x5770 */ 107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5780 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5790 */  99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x57a0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x57b0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x57c0 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x57d0 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x57e0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54,
/* 0x57f0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x5800 */ 107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,
/* 0x5810 */  82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5820 */  32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,
/* 0x5830 */  48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5840 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x5850 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x5860 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x5870 */  50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5880 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5890 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x58a0 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x58b0 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48,
/* 0x58c0 */  48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x58d0 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x58e0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x58f0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x5900 */  50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5910 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5920 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x5930 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5940 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69,
/* 0x5950 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5960 */  32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67, 51, 50, 48, 93, 58,
/* 0x5970 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5980 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5990 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54,
/* 0x59a0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76,
/* 0x59b0 */  79, 67, 51, 50, 74, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x59c0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82,
/* 0x59d0 */  69, 76, 51, 50, 66, 73, 71, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x59e0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x59f0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5a00 */  48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5a10 */  32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 10,
/* 0x5a20 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5a30 */  68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67, 51, 50, 74,
/* 0x5a40 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5a50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5a60 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5a70 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 82,
/* 0x5a80 */  69, 76, 79, 67, 51, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5a90 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5aa0 */  91, 87, 67, 76, 69, 77, 65, 73, 52, 93, 58, 10, 79, 70, 70, 83,
/* 0x5ab0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ac0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5ad0 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32,
/* 0x5ae0 */  32, 32, 32, 32, 32, 32, 32, 32,111,114,105,103,105,110, 97,108,
/* 0x5af0 */  95,115,116, 97, 99,107, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32,
/* 0x5b00 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5b10 */  32, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,121,
/* 0x5b20 */  10
};
