/* codescanner.c generated by valac, the Vala compiler
 * generated from codescanner.vala, do not modify */

/* codescanner.vala
 *
 * Copyright (C) 2015       Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_HIGHLIGHTER_CODE_SCANNER_0_PROPERTY,
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUM_PROPERTIES
};
static GParamSpec* valadoc_highlighter_code_scanner_properties[VALADOC_HIGHLIGHTER_CODE_SCANNER_NUM_PROPERTIES];

#define VALADOC_HIGHLIGHTER_CODE_SCANNER_TYPE_NUMERIC_TYPE (valadoc_highlighter_code_scanner_numeric_type_get_type ())
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define __g_queue_free__valadoc_highlighter_code_token_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_queue_free__valadoc_highlighter_code_token_unref0_ (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHighlighterCodeScannerPrivate {
	ValaHashMap* keywords;
	gboolean enable_string_templates;
	gboolean enabel_verbatim_string;
	gboolean enable_preprocessor_define;
	gboolean enable_preprocessor_include;
	gboolean enable_keyword_escape;
	GQueue* token_queue;
	const gchar* content;
	const gchar* pos;
};

typedef enum  {
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER,
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL,
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE
} ValadocHighlighterCodeScannerNumericType;


static gpointer valadoc_highlighter_code_scanner_parent_class = NULL;
static ValadocHighlighterScannerIface * valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_parent_iface = NULL;

#define VALADOC_HIGHLIGHTER_CODE_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_HIGHLIGHTER_TYPE_CODE_SCANNER, ValadocHighlighterCodeScannerPrivate))
static GType valadoc_highlighter_code_scanner_numeric_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _valadoc_highlighter_code_token_unref0_ (gpointer var);
static inline void _g_queue_free__valadoc_highlighter_code_token_unref0_ (GQueue* self);
static ValadocHighlighterCodeToken* valadoc_highlighter_code_scanner_real_next (ValadocHighlighterScanner* base);
static gboolean valadoc_highlighter_code_scanner_queue_c_include (ValadocHighlighterCodeScanner* self);
static ValadocHighlighterCodeToken* valadoc_highlighter_code_scanner_dispatch (ValadocHighlighterCodeScanner* self, const gchar* start, const gchar* end);
static void valadoc_highlighter_code_scanner_queue_until (ValadocHighlighterCodeScanner* self, gchar end_char, ValadocHighlighterCodeTokenType token_type);
static void valadoc_highlighter_code_scanner_queue_string_literal (ValadocHighlighterCodeScanner* self, const gchar* end_chars);
static void valadoc_highlighter_code_scanner_queue_numeric_literal (ValadocHighlighterCodeScanner* self);
static void valadoc_highlighter_code_scanner_queue_multiline_comment (ValadocHighlighterCodeScanner* self);
static inline gboolean valadoc_highlighter_code_scanner_isidstartchar (ValadocHighlighterCodeScanner* self, gchar c);
static gboolean valadoc_highlighter_code_scanner_queue_keyword (ValadocHighlighterCodeScanner* self);
static gchar* _g_ascii_dup (gchar* self);
static void valadoc_highlighter_code_scanner_queue_token (ValadocHighlighterCodeScanner* self, const gchar* start, const gchar* end, ValadocHighlighterCodeTokenType token_type);
static gboolean _g_ascii_equal (const gchar * s1, const gchar * s2);
static inline gboolean valadoc_highlighter_code_scanner_isidchar (ValadocHighlighterCodeScanner* self, gchar c);
static gboolean valadoc_highlighter_code_scanner_has_printf_format_prefix (ValadocHighlighterCodeScanner* self, glong* skip);
static gboolean valadoc_highlighter_code_scanner_has_escape_prefix (ValadocHighlighterCodeScanner* self, glong* skip);
static gboolean valadoc_highlighter_code_scanner_has_template_literal_prefix (ValadocHighlighterCodeScanner* self, glong* skip);
static void valadoc_highlighter_code_scanner_finalize (GObject * obj);


static GType valadoc_highlighter_code_scanner_numeric_type_get_type (void) {
	static volatile gsize valadoc_highlighter_code_scanner_numeric_type_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_highlighter_code_scanner_numeric_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER, "VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER", "integer"}, {VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL, "VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL", "real"}, {VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE, "VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE", "none"}, {0, NULL, NULL}};
		GType valadoc_highlighter_code_scanner_numeric_type_type_id;
		valadoc_highlighter_code_scanner_numeric_type_type_id = g_enum_register_static ("ValadocHighlighterCodeScannerNumericType", values);
		g_once_init_leave (&valadoc_highlighter_code_scanner_numeric_type_type_id__volatile, valadoc_highlighter_code_scanner_numeric_type_type_id);
	}
	return valadoc_highlighter_code_scanner_numeric_type_type_id__volatile;
}


static void _valadoc_highlighter_code_token_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (valadoc_highlighter_code_token_unref (var), NULL));
}


static inline void _g_queue_free__valadoc_highlighter_code_token_unref0_ (GQueue* self) {
	g_queue_free_full (self, (GDestroyNotify) _valadoc_highlighter_code_token_unref0_);
}


static gpointer _vala_map_ref0 (gpointer self) {
	return self ? vala_map_ref (self) : NULL;
}


ValadocHighlighterCodeScanner* valadoc_highlighter_code_scanner_construct (GType object_type, const gchar* content, gboolean enable_string_templates, gboolean enabel_verbatim_string, gboolean enable_preprocessor_define, gboolean enable_preprocessor_include, gboolean enable_keyword_escape, ValaHashMap* keywords) {
	ValadocHighlighterCodeScanner * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	ValaHashMap* _tmp7_;
	ValaHashMap* _tmp8_;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (keywords != NULL, NULL);
	self = (ValadocHighlighterCodeScanner*) g_object_new (object_type, NULL);
	_tmp0_ = content;
	self->priv->content = _tmp0_;
	_tmp1_ = content;
	self->priv->pos = _tmp1_;
	_tmp2_ = enable_string_templates;
	self->priv->enable_string_templates = _tmp2_;
	_tmp3_ = enabel_verbatim_string;
	self->priv->enabel_verbatim_string = _tmp3_;
	_tmp4_ = enable_preprocessor_define;
	self->priv->enable_preprocessor_define = _tmp4_;
	_tmp5_ = enable_preprocessor_include;
	self->priv->enable_preprocessor_include = _tmp5_;
	_tmp6_ = enable_keyword_escape;
	self->priv->enable_keyword_escape = _tmp6_;
	_tmp7_ = keywords;
	_tmp8_ = _vala_map_ref0 (_tmp7_);
	_vala_map_unref0 (self->priv->keywords);
	self->priv->keywords = _tmp8_;
	return self;
}


ValadocHighlighterCodeScanner* valadoc_highlighter_code_scanner_new (const gchar* content, gboolean enable_string_templates, gboolean enabel_verbatim_string, gboolean enable_preprocessor_define, gboolean enable_preprocessor_include, gboolean enable_keyword_escape, ValaHashMap* keywords) {
	return valadoc_highlighter_code_scanner_construct (VALADOC_HIGHLIGHTER_TYPE_CODE_SCANNER, content, enable_string_templates, enabel_verbatim_string, enable_preprocessor_define, enable_preprocessor_include, enable_keyword_escape, keywords);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static ValadocHighlighterCodeToken* valadoc_highlighter_code_scanner_real_next (ValadocHighlighterScanner* base) {
	ValadocHighlighterCodeScanner * self;
	ValadocHighlighterCodeToken* result = NULL;
	GQueue* _tmp0_;
	gboolean _tmp1_;
	const gchar* start = NULL;
	GQueue* _tmp126_;
	ValadocHighlighterCodeToken* _tmp127_;
	const gchar* _tmp128_;
	const gchar* _tmp129_;
	ValadocHighlighterCodeToken* _tmp130_;
	self = (ValadocHighlighterCodeScanner*) base;
	_tmp0_ = self->priv->token_queue;
	_tmp1_ = g_queue_is_empty (_tmp0_);
	if (!_tmp1_) {
		GQueue* _tmp2_;
		gpointer _tmp3_;
		_tmp2_ = self->priv->token_queue;
		_tmp3_ = g_queue_pop_head (_tmp2_);
		result = (ValadocHighlighterCodeToken*) _tmp3_;
		return result;
	}
	{
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->pos;
		start = _tmp4_;
		_tmp5_ = TRUE;
		while (TRUE) {
			const gchar* _tmp8_;
			gchar _tmp9_;
			gboolean _tmp10_ = FALSE;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp61_;
			gchar _tmp62_;
			gboolean _tmp67_ = FALSE;
			const gchar* _tmp68_;
			gchar _tmp69_;
			gboolean _tmp90_ = FALSE;
			const gchar* _tmp91_;
			gchar _tmp92_;
			const gchar* _tmp99_;
			gboolean _tmp100_;
			const gchar* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp111_ = FALSE;
			gboolean _tmp112_ = FALSE;
			const gchar* _tmp113_;
			const gchar* _tmp114_;
			if (!_tmp5_) {
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = self->priv->pos;
				_tmp7_ = g_utf8_next_char (_tmp6_);
				self->priv->pos = _tmp7_;
			}
			_tmp5_ = FALSE;
			_tmp8_ = self->priv->pos;
			_tmp9_ = string_get (_tmp8_, (glong) 0);
			if (!(_tmp9_ != '\0')) {
				break;
			}
			_tmp11_ = self->priv->pos;
			_tmp12_ = self->priv->content;
			if (((gchar*) _tmp11_) == ((gchar*) _tmp12_)) {
				_tmp10_ = TRUE;
			} else {
				const gchar* _tmp13_;
				gchar _tmp14_;
				_tmp13_ = self->priv->pos;
				_tmp14_ = string_get (_tmp13_, (glong) 0);
				_tmp10_ = _tmp14_ == '\n';
			}
			if (_tmp10_) {
				const gchar* line_start = NULL;
				const gchar* _tmp15_;
				const gchar* _tmp26_;
				gchar _tmp27_;
				_tmp15_ = self->priv->pos;
				line_start = _tmp15_;
				while (TRUE) {
					gboolean _tmp16_ = FALSE;
					gboolean _tmp17_ = FALSE;
					const gchar* _tmp18_;
					gchar _tmp19_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp18_ = self->priv->pos;
					_tmp19_ = string_get (_tmp18_, (glong) 0);
					if (_tmp19_ == ' ') {
						_tmp17_ = TRUE;
					} else {
						const gchar* _tmp20_;
						gchar _tmp21_;
						_tmp20_ = self->priv->pos;
						_tmp21_ = string_get (_tmp20_, (glong) 0);
						_tmp17_ = _tmp21_ == '\t';
					}
					if (_tmp17_) {
						_tmp16_ = TRUE;
					} else {
						const gchar* _tmp22_;
						gchar _tmp23_;
						_tmp22_ = self->priv->pos;
						_tmp23_ = string_get (_tmp22_, (glong) 0);
						_tmp16_ = _tmp23_ == '\n';
					}
					if (!_tmp16_) {
						break;
					}
					_tmp24_ = self->priv->pos;
					_tmp25_ = string_offset (_tmp24_, (glong) 1);
					self->priv->pos = _tmp25_;
				}
				_tmp26_ = self->priv->pos;
				_tmp27_ = string_get (_tmp26_, (glong) 0);
				if (_tmp27_ == '\0') {
					break;
				} else {
					gboolean _tmp28_ = FALSE;
					gboolean _tmp29_;
					_tmp29_ = self->priv->enable_preprocessor_include;
					if (_tmp29_) {
						const gchar* _tmp30_;
						gboolean _tmp31_;
						_tmp30_ = self->priv->pos;
						_tmp31_ = g_str_has_prefix (_tmp30_, "#include");
						_tmp28_ = _tmp31_;
					} else {
						_tmp28_ = FALSE;
					}
					if (_tmp28_) {
						const gchar* end = NULL;
						const gchar* _tmp32_;
						gboolean _tmp33_;
						_tmp32_ = self->priv->pos;
						end = _tmp32_;
						_tmp33_ = valadoc_highlighter_code_scanner_queue_c_include (self);
						if (_tmp33_) {
							const gchar* _tmp34_;
							const gchar* _tmp35_;
							ValadocHighlighterCodeToken* _tmp36_;
							_tmp34_ = start;
							_tmp35_ = end;
							_tmp36_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp34_, _tmp35_);
							result = _tmp36_;
							return result;
						} else {
							const gchar* _tmp37_;
							_tmp37_ = line_start;
							self->priv->pos = _tmp37_;
							continue;
						}
					} else {
						gboolean _tmp38_ = FALSE;
						gboolean _tmp39_ = FALSE;
						gboolean _tmp40_ = FALSE;
						gboolean _tmp41_ = FALSE;
						const gchar* _tmp42_;
						gboolean _tmp43_;
						_tmp42_ = self->priv->pos;
						_tmp43_ = g_str_has_prefix (_tmp42_, "#if");
						if (_tmp43_) {
							_tmp41_ = TRUE;
						} else {
							const gchar* _tmp44_;
							gboolean _tmp45_;
							_tmp44_ = self->priv->pos;
							_tmp45_ = g_str_has_prefix (_tmp44_, "#else");
							_tmp41_ = _tmp45_;
						}
						if (_tmp41_) {
							_tmp40_ = TRUE;
						} else {
							const gchar* _tmp46_;
							gboolean _tmp47_;
							_tmp46_ = self->priv->pos;
							_tmp47_ = g_str_has_prefix (_tmp46_, "#elif");
							_tmp40_ = _tmp47_;
						}
						if (_tmp40_) {
							_tmp39_ = TRUE;
						} else {
							const gchar* _tmp48_;
							gboolean _tmp49_;
							_tmp48_ = self->priv->pos;
							_tmp49_ = g_str_has_prefix (_tmp48_, "#endif");
							_tmp39_ = _tmp49_;
						}
						if (_tmp39_) {
							_tmp38_ = TRUE;
						} else {
							gboolean _tmp50_ = FALSE;
							gboolean _tmp51_;
							_tmp51_ = self->priv->enable_preprocessor_define;
							if (_tmp51_) {
								gboolean _tmp52_ = FALSE;
								const gchar* _tmp53_;
								gboolean _tmp54_;
								_tmp53_ = self->priv->pos;
								_tmp54_ = g_str_has_prefix (_tmp53_, "#defined");
								if (_tmp54_) {
									_tmp52_ = TRUE;
								} else {
									const gchar* _tmp55_;
									gboolean _tmp56_;
									_tmp55_ = self->priv->pos;
									_tmp56_ = g_str_has_prefix (_tmp55_, "#ifdef");
									_tmp52_ = _tmp56_;
								}
								_tmp50_ = _tmp52_;
							} else {
								_tmp50_ = FALSE;
							}
							_tmp38_ = _tmp50_;
						}
						if (_tmp38_) {
							const gchar* end = NULL;
							const gchar* _tmp57_;
							const gchar* _tmp58_;
							const gchar* _tmp59_;
							ValadocHighlighterCodeToken* _tmp60_;
							_tmp57_ = self->priv->pos;
							end = _tmp57_;
							valadoc_highlighter_code_scanner_queue_until (self, '\n', VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PREPROCESSOR);
							_tmp58_ = start;
							_tmp59_ = end;
							_tmp60_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp58_, _tmp59_);
							result = _tmp60_;
							return result;
						}
					}
				}
			}
			_tmp61_ = self->priv->pos;
			_tmp62_ = string_get (_tmp61_, (glong) 0);
			if (_tmp62_ == '\'') {
				const gchar* end = NULL;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				const gchar* _tmp65_;
				ValadocHighlighterCodeToken* _tmp66_;
				_tmp63_ = self->priv->pos;
				end = _tmp63_;
				valadoc_highlighter_code_scanner_queue_string_literal (self, "\'");
				_tmp64_ = start;
				_tmp65_ = end;
				_tmp66_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp64_, _tmp65_);
				result = _tmp66_;
				return result;
			}
			_tmp68_ = self->priv->pos;
			_tmp69_ = string_get (_tmp68_, (glong) 0);
			if (_tmp69_ == '"') {
				_tmp67_ = TRUE;
			} else {
				gboolean _tmp70_ = FALSE;
				gboolean _tmp71_ = FALSE;
				gboolean _tmp72_;
				_tmp72_ = self->priv->enable_string_templates;
				if (_tmp72_) {
					const gchar* _tmp73_;
					gchar _tmp74_;
					_tmp73_ = self->priv->pos;
					_tmp74_ = string_get (_tmp73_, (glong) 0);
					_tmp71_ = _tmp74_ == '@';
				} else {
					_tmp71_ = FALSE;
				}
				if (_tmp71_) {
					const gchar* _tmp75_;
					gchar _tmp76_;
					_tmp75_ = self->priv->pos;
					_tmp76_ = string_get (_tmp75_, (glong) 1);
					_tmp70_ = _tmp76_ == '"';
				} else {
					_tmp70_ = FALSE;
				}
				_tmp67_ = _tmp70_;
			}
			if (_tmp67_) {
				const gchar* end = NULL;
				const gchar* _tmp77_;
				gboolean _tmp78_ = FALSE;
				gboolean _tmp79_;
				const gchar* _tmp87_;
				const gchar* _tmp88_;
				ValadocHighlighterCodeToken* _tmp89_;
				_tmp77_ = self->priv->pos;
				end = _tmp77_;
				_tmp79_ = self->priv->enabel_verbatim_string;
				if (_tmp79_) {
					gboolean _tmp80_ = FALSE;
					const gchar* _tmp81_;
					gboolean _tmp82_;
					_tmp81_ = self->priv->pos;
					_tmp82_ = g_str_has_prefix (_tmp81_, "\"\"\"");
					if (_tmp82_) {
						_tmp80_ = TRUE;
					} else {
						gboolean _tmp83_ = FALSE;
						gboolean _tmp84_;
						_tmp84_ = self->priv->enable_string_templates;
						if (_tmp84_) {
							const gchar* _tmp85_;
							gboolean _tmp86_;
							_tmp85_ = self->priv->pos;
							_tmp86_ = g_str_has_prefix (_tmp85_, "@\"\"\"");
							_tmp83_ = _tmp86_;
						} else {
							_tmp83_ = FALSE;
						}
						_tmp80_ = _tmp83_;
					}
					_tmp78_ = _tmp80_;
				} else {
					_tmp78_ = FALSE;
				}
				if (_tmp78_) {
					valadoc_highlighter_code_scanner_queue_string_literal (self, "\"\"\"");
				} else {
					valadoc_highlighter_code_scanner_queue_string_literal (self, "\"");
				}
				_tmp87_ = start;
				_tmp88_ = end;
				_tmp89_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp87_, _tmp88_);
				result = _tmp89_;
				return result;
			}
			_tmp91_ = self->priv->pos;
			_tmp92_ = string_get (_tmp91_, (glong) 0);
			if (_tmp92_ >= '0') {
				const gchar* _tmp93_;
				gchar _tmp94_;
				_tmp93_ = self->priv->pos;
				_tmp94_ = string_get (_tmp93_, (glong) 0);
				_tmp90_ = _tmp94_ <= '9';
			} else {
				_tmp90_ = FALSE;
			}
			if (_tmp90_) {
				const gchar* end = NULL;
				const gchar* _tmp95_;
				const gchar* _tmp96_;
				const gchar* _tmp97_;
				ValadocHighlighterCodeToken* _tmp98_;
				_tmp95_ = self->priv->pos;
				end = _tmp95_;
				valadoc_highlighter_code_scanner_queue_numeric_literal (self);
				_tmp96_ = start;
				_tmp97_ = end;
				_tmp98_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp96_, _tmp97_);
				result = _tmp98_;
				return result;
			}
			_tmp99_ = self->priv->pos;
			_tmp100_ = g_str_has_prefix (_tmp99_, "/*");
			if (_tmp100_) {
				const gchar* end = NULL;
				const gchar* _tmp101_;
				const gchar* _tmp102_;
				const gchar* _tmp103_;
				ValadocHighlighterCodeToken* _tmp104_;
				_tmp101_ = self->priv->pos;
				end = _tmp101_;
				valadoc_highlighter_code_scanner_queue_multiline_comment (self);
				_tmp102_ = start;
				_tmp103_ = end;
				_tmp104_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp102_, _tmp103_);
				result = _tmp104_;
				return result;
			}
			_tmp105_ = self->priv->pos;
			_tmp106_ = g_str_has_prefix (_tmp105_, "//");
			if (_tmp106_) {
				const gchar* end = NULL;
				const gchar* _tmp107_;
				const gchar* _tmp108_;
				const gchar* _tmp109_;
				ValadocHighlighterCodeToken* _tmp110_;
				_tmp107_ = self->priv->pos;
				end = _tmp107_;
				valadoc_highlighter_code_scanner_queue_until (self, '\n', VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_COMMENT);
				_tmp108_ = start;
				_tmp109_ = end;
				_tmp110_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp108_, _tmp109_);
				result = _tmp110_;
				return result;
			}
			_tmp113_ = self->priv->pos;
			_tmp114_ = self->priv->content;
			if (((gchar*) _tmp113_) == ((gchar*) _tmp114_)) {
				_tmp112_ = TRUE;
			} else {
				const gchar* _tmp115_;
				gchar _tmp116_;
				gboolean _tmp117_;
				_tmp115_ = self->priv->pos;
				_tmp116_ = string_get (_tmp115_, (glong) -1);
				_tmp117_ = valadoc_highlighter_code_scanner_isidstartchar (self, _tmp116_);
				_tmp112_ = !_tmp117_;
			}
			if (_tmp112_) {
				const gchar* _tmp118_;
				gchar _tmp119_;
				gboolean _tmp120_;
				_tmp118_ = self->priv->pos;
				_tmp119_ = string_get (_tmp118_, (glong) 0);
				_tmp120_ = valadoc_highlighter_code_scanner_isidstartchar (self, _tmp119_);
				_tmp111_ = _tmp120_;
			} else {
				_tmp111_ = FALSE;
			}
			if (_tmp111_) {
				const gchar* end = NULL;
				const gchar* _tmp121_;
				gboolean _tmp122_;
				_tmp121_ = self->priv->pos;
				end = _tmp121_;
				_tmp122_ = valadoc_highlighter_code_scanner_queue_keyword (self);
				if (_tmp122_) {
					const gchar* _tmp123_;
					const gchar* _tmp124_;
					ValadocHighlighterCodeToken* _tmp125_;
					_tmp123_ = start;
					_tmp124_ = end;
					_tmp125_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp123_, _tmp124_);
					result = _tmp125_;
					return result;
				} else {
					continue;
				}
			}
		}
	}
	_tmp126_ = self->priv->token_queue;
	_tmp127_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_EOF, "");
	g_queue_push_tail (_tmp126_, _tmp127_);
	_tmp128_ = start;
	_tmp129_ = self->priv->pos;
	_tmp130_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp128_, _tmp129_);
	result = _tmp130_;
	return result;
}


static gchar* _g_ascii_dup (gchar* self) {
	gchar* dup;
	dup = g_new0 (gchar, 1);
	memcpy (dup, self, sizeof (gchar));
	return dup;
}


static gpointer __g_ascii_dup0 (gpointer self) {
	return self ? _g_ascii_dup (self) : NULL;
}


static gboolean _g_ascii_equal (const gchar * s1, const gchar * s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static gboolean valadoc_highlighter_code_scanner_queue_c_include (ValadocHighlighterCodeScanner* self) {
	gboolean result = FALSE;
	const gchar* include_start = NULL;
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* end_char = NULL;
	const gchar* _tmp11_;
	gchar _tmp12_;
	gchar* _tmp19_;
	gboolean _tmp53_ = FALSE;
	const gchar* _tmp54_;
	gchar _tmp55_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	include_start = _tmp0_;
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->pos;
	_tmp3_ = string_offset (_tmp2_, (glong) 8);
	self->priv->pos = _tmp3_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		gchar _tmp6_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp5_ = self->priv->pos;
		_tmp6_ = string_get (_tmp5_, (glong) 0);
		if (_tmp6_ == ' ') {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			gchar _tmp8_;
			_tmp7_ = self->priv->pos;
			_tmp8_ = string_get (_tmp7_, (glong) 0);
			_tmp4_ = _tmp8_ == '\t';
		}
		if (!_tmp4_) {
			break;
		}
		_tmp9_ = self->priv->pos;
		_tmp10_ = string_offset (_tmp9_, (glong) 1);
		self->priv->pos = _tmp10_;
	}
	end_char = NULL;
	_tmp11_ = self->priv->pos;
	_tmp12_ = string_get (_tmp11_, (glong) 0);
	if (_tmp12_ == '"') {
		gchar _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = '"';
		_tmp14_ = __g_ascii_dup0 (&_tmp13_);
		_g_free0 (end_char);
		end_char = _tmp14_;
	} else {
		const gchar* _tmp15_;
		gchar _tmp16_;
		_tmp15_ = self->priv->pos;
		_tmp16_ = string_get (_tmp15_, (glong) 0);
		if (_tmp16_ == '<') {
			gchar _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = '>';
			_tmp18_ = __g_ascii_dup0 (&_tmp17_);
			_g_free0 (end_char);
			end_char = _tmp18_;
		}
	}
	_tmp19_ = end_char;
	if (_tmp19_ != NULL) {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* literal_start = NULL;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp36_;
		gchar _tmp37_;
		gchar* _tmp38_;
		_tmp20_ = start;
		_tmp21_ = self->priv->pos;
		valadoc_highlighter_code_scanner_queue_token (self, _tmp20_, _tmp21_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PREPROCESSOR);
		_tmp22_ = self->priv->pos;
		literal_start = _tmp22_;
		_tmp23_ = self->priv->pos;
		_tmp24_ = string_offset (_tmp23_, (glong) 1);
		self->priv->pos = _tmp24_;
		while (TRUE) {
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_ = FALSE;
			const gchar* _tmp27_;
			gchar _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			_tmp27_ = self->priv->pos;
			_tmp28_ = string_get (_tmp27_, (glong) 0);
			_tmp29_ = end_char;
			if (_g_ascii_equal (&_tmp28_, _tmp29_) != TRUE) {
				const gchar* _tmp30_;
				gchar _tmp31_;
				_tmp30_ = self->priv->pos;
				_tmp31_ = string_get (_tmp30_, (glong) 0);
				_tmp26_ = _tmp31_ != '\n';
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				const gchar* _tmp32_;
				gchar _tmp33_;
				_tmp32_ = self->priv->pos;
				_tmp33_ = string_get (_tmp32_, (glong) 0);
				_tmp25_ = _tmp33_ != '\0';
			} else {
				_tmp25_ = FALSE;
			}
			if (!_tmp25_) {
				break;
			}
			_tmp34_ = self->priv->pos;
			_tmp35_ = string_offset (_tmp34_, (glong) 1);
			self->priv->pos = _tmp35_;
		}
		_tmp36_ = self->priv->pos;
		_tmp37_ = string_get (_tmp36_, (glong) 0);
		_tmp38_ = end_char;
		if (_g_ascii_equal (&_tmp37_, _tmp38_) == TRUE) {
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			_tmp39_ = self->priv->pos;
			_tmp40_ = string_offset (_tmp39_, (glong) 1);
			self->priv->pos = _tmp40_;
			_tmp41_ = literal_start;
			_tmp42_ = self->priv->pos;
			valadoc_highlighter_code_scanner_queue_token (self, _tmp41_, _tmp42_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL);
			_tmp43_ = self->priv->pos;
			start = _tmp43_;
		} else {
			const gchar* _tmp44_;
			GQueue* _tmp45_;
			_tmp44_ = include_start;
			self->priv->pos = _tmp44_;
			_tmp45_ = self->priv->token_queue;
			g_queue_clear (_tmp45_);
			result = FALSE;
			_g_free0 (end_char);
			return result;
		}
	}
	while (TRUE) {
		gboolean _tmp46_ = FALSE;
		const gchar* _tmp47_;
		gchar _tmp48_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		_tmp47_ = self->priv->pos;
		_tmp48_ = string_get (_tmp47_, (glong) 0);
		if (_tmp48_ == ' ') {
			_tmp46_ = TRUE;
		} else {
			const gchar* _tmp49_;
			gchar _tmp50_;
			_tmp49_ = self->priv->pos;
			_tmp50_ = string_get (_tmp49_, (glong) 0);
			_tmp46_ = _tmp50_ == '\t';
		}
		if (!_tmp46_) {
			break;
		}
		_tmp51_ = self->priv->pos;
		_tmp52_ = string_offset (_tmp51_, (glong) 1);
		self->priv->pos = _tmp52_;
	}
	_tmp54_ = self->priv->pos;
	_tmp55_ = string_get (_tmp54_, (glong) 0);
	if (_tmp55_ == '\n') {
		_tmp53_ = TRUE;
	} else {
		const gchar* _tmp56_;
		gchar _tmp57_;
		_tmp56_ = self->priv->pos;
		_tmp57_ = string_get (_tmp56_, (glong) 0);
		_tmp53_ = _tmp57_ == '\0';
	}
	if (_tmp53_) {
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		_tmp58_ = start;
		_tmp59_ = self->priv->pos;
		valadoc_highlighter_code_scanner_queue_token (self, _tmp58_, _tmp59_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PREPROCESSOR);
		result = TRUE;
		_g_free0 (end_char);
		return result;
	} else {
		const gchar* _tmp60_;
		GQueue* _tmp61_;
		_tmp60_ = include_start;
		self->priv->pos = _tmp60_;
		_tmp61_ = self->priv->token_queue;
		g_queue_clear (_tmp61_);
		result = FALSE;
		_g_free0 (end_char);
		return result;
	}
	_g_free0 (end_char);
}


static glong string_pointer_to_offset (const gchar* self, const gchar* pos) {
	glong result = 0L;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pos != NULL, 0L);
	_tmp0_ = pos;
	result = (glong) (((gchar*) _tmp0_) - ((gchar*) self));
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gboolean valadoc_highlighter_code_scanner_queue_keyword (ValadocHighlighterCodeScanner* self) {
	gboolean result = FALSE;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar _tmp2_;
	glong length = 0L;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	glong _tmp12_;
	gchar* word = NULL;
	const gchar* _tmp13_;
	glong _tmp14_;
	gchar* _tmp15_;
	ValadocHighlighterCodeTokenType* token_type = NULL;
	ValaHashMap* _tmp16_;
	const gchar* _tmp17_;
	gpointer _tmp18_;
	ValadocHighlighterCodeTokenType* _tmp19_;
	GQueue* _tmp21_;
	ValadocHighlighterCodeTokenType* _tmp22_;
	const gchar* _tmp23_;
	ValadocHighlighterCodeToken* _tmp24_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '@') {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->pos;
		_tmp4_ = string_offset (_tmp3_, (glong) 1);
		self->priv->pos = _tmp4_;
	}
	while (TRUE) {
		const gchar* _tmp5_;
		gchar _tmp6_;
		gboolean _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp5_ = self->priv->pos;
		_tmp6_ = string_get (_tmp5_, (glong) 0);
		_tmp7_ = valadoc_highlighter_code_scanner_isidchar (self, _tmp6_);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = self->priv->pos;
		_tmp9_ = string_offset (_tmp8_, (glong) 1);
		self->priv->pos = _tmp9_;
	}
	_tmp10_ = start;
	_tmp11_ = self->priv->pos;
	_tmp12_ = string_pointer_to_offset (_tmp10_, _tmp11_);
	length = _tmp12_;
	_tmp13_ = start;
	_tmp14_ = length;
	_tmp15_ = string_substring (_tmp13_, (glong) 0, _tmp14_);
	word = _tmp15_;
	_tmp16_ = self->priv->keywords;
	_tmp17_ = word;
	_tmp18_ = vala_map_get ((ValaMap*) _tmp16_, _tmp17_);
	token_type = (ValadocHighlighterCodeTokenType*) _tmp18_;
	_tmp19_ = token_type;
	if (_tmp19_ == NULL) {
		const gchar* _tmp20_;
		_tmp20_ = start;
		self->priv->pos = _tmp20_;
		result = FALSE;
		_g_free0 (token_type);
		_g_free0 (word);
		return result;
	}
	_tmp21_ = self->priv->token_queue;
	_tmp22_ = token_type;
	_tmp23_ = word;
	_tmp24_ = valadoc_highlighter_code_token_new (*_tmp22_, _tmp23_);
	g_queue_push_tail (_tmp21_, _tmp24_);
	result = TRUE;
	_g_free0 (token_type);
	_g_free0 (word);
	return result;
}


static void valadoc_highlighter_code_scanner_queue_multiline_comment (ValadocHighlighterCodeScanner* self) {
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp13_;
	gchar _tmp14_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_offset (_tmp1_, (glong) 2);
	self->priv->pos = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		gchar _tmp6_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp5_ = self->priv->pos;
		_tmp6_ = string_get (_tmp5_, (glong) 0);
		if (_tmp6_ == '*') {
			const gchar* _tmp7_;
			gchar _tmp8_;
			_tmp7_ = self->priv->pos;
			_tmp8_ = string_get (_tmp7_, (glong) 1);
			_tmp4_ = _tmp8_ == '/';
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			const gchar* _tmp9_;
			gchar _tmp10_;
			_tmp9_ = self->priv->pos;
			_tmp10_ = string_get (_tmp9_, (glong) 0);
			_tmp3_ = _tmp10_ != '\0';
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp11_ = self->priv->pos;
		_tmp12_ = string_offset (_tmp11_, (glong) 1);
		self->priv->pos = _tmp12_;
	}
	_tmp13_ = self->priv->pos;
	_tmp14_ = string_get (_tmp13_, (glong) 0);
	if (_tmp14_ != '\0') {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp15_ = self->priv->pos;
		_tmp16_ = string_offset (_tmp15_, (glong) 2);
		self->priv->pos = _tmp16_;
	}
	_tmp17_ = start;
	_tmp18_ = self->priv->pos;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp17_, _tmp18_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_COMMENT);
}


static void valadoc_highlighter_code_scanner_queue_until (ValadocHighlighterCodeScanner* self, gchar end_char, ValadocHighlighterCodeTokenType token_type) {
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	gchar _tmp13_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ValadocHighlighterCodeTokenType _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_offset (_tmp1_, (glong) 1);
	self->priv->pos = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		gchar _tmp5_;
		gchar _tmp6_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp4_ = self->priv->pos;
		_tmp5_ = string_get (_tmp4_, (glong) 0);
		_tmp6_ = end_char;
		if (_tmp5_ != _tmp6_) {
			const gchar* _tmp7_;
			gchar _tmp8_;
			_tmp7_ = self->priv->pos;
			_tmp8_ = string_get (_tmp7_, (glong) 0);
			_tmp3_ = _tmp8_ != '\0';
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp9_ = self->priv->pos;
		_tmp10_ = string_offset (_tmp9_, (glong) 1);
		self->priv->pos = _tmp10_;
	}
	_tmp12_ = self->priv->pos;
	_tmp13_ = string_get (_tmp12_, (glong) 0);
	if (_tmp13_ != '\0') {
		const gchar* _tmp14_;
		gchar _tmp15_;
		_tmp14_ = self->priv->pos;
		_tmp15_ = string_get (_tmp14_, (glong) 0);
		_tmp11_ = _tmp15_ != '\n';
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = self->priv->pos;
		_tmp17_ = string_offset (_tmp16_, (glong) 1);
		self->priv->pos = _tmp17_;
	}
	_tmp18_ = start;
	_tmp19_ = self->priv->pos;
	_tmp20_ = token_type;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp18_, _tmp19_, _tmp20_);
}


static void valadoc_highlighter_code_scanner_queue_string_literal (ValadocHighlighterCodeScanner* self, const gchar* end_chars) {
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gboolean is_template = FALSE;
	const gchar* _tmp1_;
	gchar _tmp2_;
	const gchar* _tmp49_;
	gchar _tmp50_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (end_chars != NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	is_template = FALSE;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_get (_tmp1_, (glong) 0);
	if (_tmp2_ == '@') {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = self->priv->pos;
		_tmp4_ = end_chars;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = string_offset (_tmp3_, (glong) (_tmp6_ + 1));
		self->priv->pos = _tmp7_;
		is_template = TRUE;
	} else {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = self->priv->pos;
		_tmp9_ = end_chars;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_offset (_tmp8_, (glong) _tmp11_);
		self->priv->pos = _tmp12_;
	}
	while (TRUE) {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gboolean _tmp16_;
		glong skip = 0L;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		gchar _tmp23_;
		_tmp14_ = self->priv->pos;
		_tmp15_ = end_chars;
		_tmp16_ = g_str_has_prefix (_tmp14_, _tmp15_);
		if (!_tmp16_) {
			const gchar* _tmp17_;
			gchar _tmp18_;
			_tmp17_ = self->priv->pos;
			_tmp18_ = string_get (_tmp17_, (glong) 0);
			_tmp13_ = _tmp18_ != '\0';
		} else {
			_tmp13_ = FALSE;
		}
		if (!_tmp13_) {
			break;
		}
		skip = (glong) 0;
		_tmp22_ = self->priv->pos;
		_tmp23_ = string_get (_tmp22_, (glong) 0);
		if (_tmp23_ == '%') {
			glong _tmp24_ = 0L;
			gboolean _tmp25_;
			_tmp25_ = valadoc_highlighter_code_scanner_has_printf_format_prefix (self, &_tmp24_);
			skip = _tmp24_;
			_tmp21_ = _tmp25_;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			gboolean _tmp26_ = FALSE;
			const gchar* _tmp27_;
			gchar _tmp28_;
			_tmp27_ = self->priv->pos;
			_tmp28_ = string_get (_tmp27_, (glong) 0);
			if (_tmp28_ == '\\') {
				glong _tmp29_ = 0L;
				gboolean _tmp30_;
				_tmp30_ = valadoc_highlighter_code_scanner_has_escape_prefix (self, &_tmp29_);
				skip = _tmp29_;
				_tmp26_ = _tmp30_;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp20_ = _tmp26_;
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			gboolean _tmp31_ = FALSE;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp33_;
			_tmp33_ = is_template;
			if (_tmp33_) {
				const gchar* _tmp34_;
				gchar _tmp35_;
				_tmp34_ = self->priv->pos;
				_tmp35_ = string_get (_tmp34_, (glong) 0);
				_tmp32_ = _tmp35_ == '$';
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				glong _tmp36_ = 0L;
				gboolean _tmp37_;
				_tmp37_ = valadoc_highlighter_code_scanner_has_template_literal_prefix (self, &_tmp36_);
				skip = _tmp36_;
				_tmp31_ = _tmp37_;
			} else {
				_tmp31_ = FALSE;
			}
			_tmp19_ = _tmp31_;
		}
		if (_tmp19_) {
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			const gchar* sub_start = NULL;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			glong _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			_tmp38_ = start;
			_tmp39_ = self->priv->pos;
			valadoc_highlighter_code_scanner_queue_token (self, _tmp38_, _tmp39_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL);
			_tmp40_ = self->priv->pos;
			sub_start = _tmp40_;
			_tmp41_ = self->priv->pos;
			_tmp42_ = skip;
			_tmp43_ = string_offset (_tmp41_, _tmp42_);
			self->priv->pos = _tmp43_;
			_tmp44_ = sub_start;
			_tmp45_ = self->priv->pos;
			valadoc_highlighter_code_scanner_queue_token (self, _tmp44_, _tmp45_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_ESCAPE);
			_tmp46_ = self->priv->pos;
			start = _tmp46_;
		} else {
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_tmp47_ = self->priv->pos;
			_tmp48_ = string_offset (_tmp47_, (glong) 1);
			self->priv->pos = _tmp48_;
		}
	}
	_tmp49_ = self->priv->pos;
	_tmp50_ = string_get (_tmp49_, (glong) 0);
	if (_tmp50_ != '\0') {
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		const gchar* _tmp55_;
		_tmp51_ = self->priv->pos;
		_tmp52_ = end_chars;
		_tmp53_ = strlen (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = string_offset (_tmp51_, (glong) _tmp54_);
		self->priv->pos = _tmp55_;
	}
	_tmp56_ = start;
	_tmp57_ = self->priv->pos;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp56_, _tmp57_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL);
}


static gboolean valadoc_highlighter_code_scanner_has_template_literal_prefix (ValadocHighlighterCodeScanner* self, glong* skip) {
	glong _vala_skip = 0L;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp8_;
	gchar _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	_tmp1_ = string_get (_tmp0_, (glong) 1);
	_tmp2_ = valadoc_highlighter_code_scanner_isidchar (self, _tmp1_);
	if (_tmp2_) {
		_vala_skip = (glong) 1;
		while (TRUE) {
			const gchar* _tmp3_;
			glong _tmp4_;
			gchar _tmp5_;
			gboolean _tmp6_;
			glong _tmp7_;
			_tmp3_ = self->priv->pos;
			_tmp4_ = _vala_skip;
			_tmp5_ = string_get (_tmp3_, _tmp4_);
			_tmp6_ = valadoc_highlighter_code_scanner_isidchar (self, _tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _vala_skip;
			_vala_skip = _tmp7_ + 1;
		}
		result = TRUE;
		if (skip) {
			*skip = _vala_skip;
		}
		return result;
	}
	_tmp8_ = self->priv->pos;
	_tmp9_ = string_get (_tmp8_, (glong) 1);
	if (_tmp9_ == '(') {
		gint level = 0;
		level = 1;
		_vala_skip = (glong) 2;
		while (TRUE) {
			gint _tmp10_;
			const gchar* _tmp11_;
			glong _tmp12_;
			gchar _tmp13_;
			glong _tmp16_;
			_tmp10_ = level;
			if (!(_tmp10_ > 0)) {
				break;
			}
			_tmp11_ = self->priv->pos;
			_tmp12_ = _vala_skip;
			_tmp13_ = string_get (_tmp11_, _tmp12_);
			switch (_tmp13_) {
				case '(':
				{
					gint _tmp14_;
					_tmp14_ = level;
					level = _tmp14_ + 1;
					break;
				}
				case ')':
				{
					gint _tmp15_;
					_tmp15_ = level;
					level = _tmp15_ - 1;
					break;
				}
				case '\0':
				{
					_vala_skip = (glong) 0;
					result = FALSE;
					if (skip) {
						*skip = _vala_skip;
					}
					return result;
				}
				default:
				break;
			}
			_tmp16_ = _vala_skip;
			_vala_skip = _tmp16_ + 1;
		}
		result = TRUE;
		if (skip) {
			*skip = _vala_skip;
		}
		return result;
	}
	_vala_skip = (glong) 0;
	result = FALSE;
	if (skip) {
		*skip = _vala_skip;
	}
	return result;
}


static gboolean valadoc_highlighter_code_scanner_has_escape_prefix (ValadocHighlighterCodeScanner* self, glong* skip) {
	glong _vala_skip = 0L;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	_tmp1_ = string_get (_tmp0_, (glong) 1);
	switch (_tmp1_) {
		case 'a':
		case 'b':
		case 'f':
		case 'n':
		case 'r':
		case 't':
		case 'v':
		case '\\':
		case '\'':
		case '\"':
		case '?':
		{
			_vala_skip = (glong) 2;
			result = TRUE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
		case 'x':
		{
			const gchar* _tmp2_;
			gchar _tmp3_;
			gboolean _tmp4_;
			_tmp2_ = self->priv->pos;
			_tmp3_ = string_get (_tmp2_, (glong) 2);
			_tmp4_ = g_ascii_isxdigit (_tmp3_);
			if (_tmp4_) {
				glong _tmp12_;
				{
					gboolean _tmp5_ = FALSE;
					_vala_skip = (glong) 2;
					_tmp5_ = TRUE;
					while (TRUE) {
						const gchar* _tmp7_;
						glong _tmp8_;
						gchar _tmp9_;
						gboolean _tmp10_;
						glong _tmp11_;
						if (!_tmp5_) {
							glong _tmp6_;
							_tmp6_ = _vala_skip;
							_vala_skip = _tmp6_ + 1;
						}
						_tmp5_ = FALSE;
						_tmp7_ = self->priv->pos;
						_tmp8_ = _vala_skip;
						_tmp9_ = string_get (_tmp7_, _tmp8_);
						_tmp10_ = g_ascii_isxdigit (_tmp9_);
						if (!_tmp10_) {
							break;
						}
						_tmp11_ = _vala_skip;
						_vala_skip = _tmp11_ + 1;
					}
				}
				_tmp12_ = _vala_skip;
				_vala_skip = _tmp12_ + 1;
				result = TRUE;
				if (skip) {
					*skip = _vala_skip;
				}
				return result;
			}
			_vala_skip = (glong) 0;
			result = FALSE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
		default:
		{
			const gchar* _tmp13_;
			gchar _tmp14_;
			gboolean _tmp15_;
			_tmp13_ = self->priv->pos;
			_tmp14_ = string_get (_tmp13_, (glong) 1);
			_tmp15_ = g_ascii_isdigit (_tmp14_);
			if (_tmp15_) {
				const gchar* _tmp16_;
				gchar _tmp17_;
				gboolean _tmp18_;
				_vala_skip = (glong) 2;
				_tmp16_ = self->priv->pos;
				_tmp17_ = string_get (_tmp16_, (glong) 2);
				_tmp18_ = g_ascii_isdigit (_tmp17_);
				if (_tmp18_) {
					glong _tmp19_;
					const gchar* _tmp20_;
					gchar _tmp21_;
					gboolean _tmp22_;
					_tmp19_ = _vala_skip;
					_vala_skip = _tmp19_ + 1;
					_tmp20_ = self->priv->pos;
					_tmp21_ = string_get (_tmp20_, (glong) 3);
					_tmp22_ = g_ascii_isdigit (_tmp21_);
					if (_tmp22_) {
						glong _tmp23_;
						_tmp23_ = _vala_skip;
						_vala_skip = _tmp23_ + 1;
					}
				}
				result = TRUE;
				if (skip) {
					*skip = _vala_skip;
				}
				return result;
			}
			_vala_skip = (glong) 0;
			result = FALSE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
	}
	if (skip) {
		*skip = _vala_skip;
	}
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean valadoc_highlighter_code_scanner_has_printf_format_prefix (ValadocHighlighterCodeScanner* self, glong* skip) {
	glong _vala_skip = 0L;
	gboolean result = FALSE;
	const gchar* pos = NULL;
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar _tmp5_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	gchar _tmp20_;
	const gchar* _tmp31_;
	gchar _tmp32_;
	const gchar* _tmp47_;
	gchar _tmp48_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	glong _tmp53_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	pos = _tmp0_;
	_tmp1_ = pos;
	start = _tmp1_;
	_tmp2_ = pos;
	_tmp3_ = string_offset (_tmp2_, (glong) 1);
	pos = _tmp3_;
	_tmp4_ = pos;
	_tmp5_ = string_get (_tmp4_, (glong) 0);
	if (_tmp5_ == '%') {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = pos;
		_tmp7_ = string_offset (_tmp6_, (glong) 1);
		pos = _tmp7_;
		_vala_skip = (glong) 2;
		result = TRUE;
		if (skip) {
			*skip = _vala_skip;
		}
		return result;
	}
	while (TRUE) {
		const gchar* _tmp8_;
		gchar _tmp9_;
		gint _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = pos;
		_tmp9_ = string_get (_tmp8_, (glong) 0);
		_tmp10_ = string_index_of_char ("#0+- ", (gunichar) _tmp9_, 0);
		if (!(_tmp10_ > 0)) {
			break;
		}
		_tmp11_ = pos;
		_tmp12_ = string_offset (_tmp11_, (glong) 1);
		pos = _tmp12_;
	}
	while (TRUE) {
		const gchar* _tmp13_;
		gchar _tmp14_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp13_ = pos;
		_tmp14_ = string_get (_tmp13_, (glong) 0);
		_tmp15_ = g_ascii_isdigit (_tmp14_);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = pos;
		_tmp17_ = string_offset (_tmp16_, (glong) 1);
		pos = _tmp17_;
	}
	_tmp19_ = pos;
	_tmp20_ = string_get (_tmp19_, (glong) 0);
	if (_tmp20_ == '.') {
		const gchar* _tmp21_;
		gchar _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = pos;
		_tmp22_ = string_get (_tmp21_, (glong) 1);
		_tmp23_ = g_ascii_isdigit (_tmp22_);
		_tmp18_ = _tmp23_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = pos;
		_tmp25_ = string_offset (_tmp24_, (glong) 2);
		pos = _tmp25_;
		while (TRUE) {
			const gchar* _tmp26_;
			gchar _tmp27_;
			gboolean _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			_tmp26_ = pos;
			_tmp27_ = string_get (_tmp26_, (glong) 0);
			_tmp28_ = g_ascii_isdigit (_tmp27_);
			if (!_tmp28_) {
				break;
			}
			_tmp29_ = pos;
			_tmp30_ = string_offset (_tmp29_, (glong) 1);
			pos = _tmp30_;
		}
	}
	_tmp31_ = pos;
	_tmp32_ = string_get (_tmp31_, (glong) 0);
	switch (_tmp32_) {
		case 'h':
		{
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar _tmp36_;
			_tmp33_ = pos;
			_tmp34_ = string_offset (_tmp33_, (glong) 1);
			pos = _tmp34_;
			_tmp35_ = pos;
			_tmp36_ = string_get (_tmp35_, (glong) 0);
			if (_tmp36_ == 'h') {
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp37_ = pos;
				_tmp38_ = string_offset (_tmp37_, (glong) 1);
				pos = _tmp38_;
			}
			break;
		}
		case 'l':
		{
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gchar _tmp42_;
			_tmp39_ = pos;
			_tmp40_ = string_offset (_tmp39_, (glong) 1);
			pos = _tmp40_;
			_tmp41_ = pos;
			_tmp42_ = string_get (_tmp41_, (glong) 0);
			if (_tmp42_ == 'l') {
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				_tmp43_ = pos;
				_tmp44_ = string_offset (_tmp43_, (glong) 1);
				pos = _tmp44_;
			}
			break;
		}
		case 'j':
		case 'z':
		case 't':
		case 'L':
		{
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			_tmp45_ = pos;
			_tmp46_ = string_offset (_tmp45_, (glong) 1);
			pos = _tmp46_;
			break;
		}
		default:
		break;
	}
	_tmp47_ = pos;
	_tmp48_ = string_get (_tmp47_, (glong) 0);
	switch (_tmp48_) {
		case 'd':
		case 'i':
		case 'u':
		case 'o':
		case 'x':
		case 'X':
		case 'f':
		case 'F':
		case 'e':
		case 'E':
		case 'g':
		case 'G':
		case 'a':
		case 'A':
		case 'c':
		case 's':
		case 'p':
		case 'n':
		{
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp49_ = pos;
			_tmp50_ = string_offset (_tmp49_, (glong) 1);
			pos = _tmp50_;
			break;
		}
		default:
		{
			_vala_skip = (glong) 0;
			result = FALSE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
	}
	_tmp51_ = start;
	_tmp52_ = pos;
	_tmp53_ = string_pointer_to_offset (_tmp51_, _tmp52_);
	_vala_skip = _tmp53_;
	result = TRUE;
	if (skip) {
		*skip = _vala_skip;
	}
	return result;
}


static void valadoc_highlighter_code_scanner_queue_numeric_literal (ValadocHighlighterCodeScanner* self) {
	ValadocHighlighterCodeScannerNumericType numeric_type = 0;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar _tmp4_;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gchar _tmp24_;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_;
	gchar _tmp37_;
	const gchar* _tmp54_;
	gchar _tmp55_;
	const gchar* _tmp85_;
	gchar _tmp86_;
	gboolean _tmp87_;
	ValadocHighlighterCodeTokenType _tmp88_ = 0;
	ValadocHighlighterCodeScannerNumericType _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	g_return_if_fail (self != NULL);
	numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER;
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp3_ = self->priv->pos;
	_tmp4_ = string_get (_tmp3_, (glong) 0);
	if (_tmp4_ == '0') {
		const gchar* _tmp5_;
		gchar _tmp6_;
		_tmp5_ = self->priv->pos;
		_tmp6_ = string_get (_tmp5_, (glong) 1);
		_tmp2_ = _tmp6_ == 'x';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp7_;
		gchar _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->pos;
		_tmp8_ = string_get (_tmp7_, (glong) 2);
		_tmp9_ = g_ascii_isxdigit (_tmp8_);
		_tmp1_ = _tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->pos;
		_tmp11_ = string_offset (_tmp10_, (glong) 2);
		self->priv->pos = _tmp11_;
		while (TRUE) {
			const gchar* _tmp12_;
			gchar _tmp13_;
			gboolean _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp12_ = self->priv->pos;
			_tmp13_ = string_get (_tmp12_, (glong) 0);
			_tmp14_ = g_ascii_isxdigit (_tmp13_);
			if (!_tmp14_) {
				break;
			}
			_tmp15_ = self->priv->pos;
			_tmp16_ = string_offset (_tmp15_, (glong) 1);
			self->priv->pos = _tmp16_;
		}
	} else {
		while (TRUE) {
			const gchar* _tmp17_;
			gchar _tmp18_;
			gboolean _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp17_ = self->priv->pos;
			_tmp18_ = string_get (_tmp17_, (glong) 0);
			_tmp19_ = g_ascii_isdigit (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = self->priv->pos;
			_tmp21_ = string_offset (_tmp20_, (glong) 1);
			self->priv->pos = _tmp21_;
		}
	}
	_tmp23_ = self->priv->pos;
	_tmp24_ = string_get (_tmp23_, (glong) 0);
	if (_tmp24_ == '.') {
		const gchar* _tmp25_;
		gchar _tmp26_;
		gboolean _tmp27_;
		_tmp25_ = self->priv->pos;
		_tmp26_ = string_get (_tmp25_, (glong) 1);
		_tmp27_ = g_ascii_isdigit (_tmp26_);
		_tmp22_ = _tmp27_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL;
		_tmp28_ = self->priv->pos;
		_tmp29_ = string_offset (_tmp28_, (glong) 1);
		self->priv->pos = _tmp29_;
		while (TRUE) {
			const gchar* _tmp30_;
			gchar _tmp31_;
			gboolean _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			_tmp30_ = self->priv->pos;
			_tmp31_ = string_get (_tmp30_, (glong) 0);
			_tmp32_ = g_ascii_isdigit (_tmp31_);
			if (!_tmp32_) {
				break;
			}
			_tmp33_ = self->priv->pos;
			_tmp34_ = string_offset (_tmp33_, (glong) 1);
			self->priv->pos = _tmp34_;
		}
	}
	_tmp36_ = self->priv->pos;
	_tmp37_ = string_get (_tmp36_, (glong) 0);
	if (_tmp37_ == 'e') {
		_tmp35_ = TRUE;
	} else {
		const gchar* _tmp38_;
		gchar _tmp39_;
		_tmp38_ = self->priv->pos;
		_tmp39_ = string_get (_tmp38_, (glong) 0);
		_tmp35_ = _tmp39_ == 'E';
	}
	if (_tmp35_) {
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gboolean _tmp42_ = FALSE;
		const gchar* _tmp43_;
		gchar _tmp44_;
		numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL;
		_tmp40_ = self->priv->pos;
		_tmp41_ = string_offset (_tmp40_, (glong) 1);
		self->priv->pos = _tmp41_;
		_tmp43_ = self->priv->pos;
		_tmp44_ = string_get (_tmp43_, (glong) 0);
		if (_tmp44_ == '+') {
			_tmp42_ = TRUE;
		} else {
			const gchar* _tmp45_;
			gchar _tmp46_;
			_tmp45_ = self->priv->pos;
			_tmp46_ = string_get (_tmp45_, (glong) 0);
			_tmp42_ = _tmp46_ == '-';
		}
		if (_tmp42_) {
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_tmp47_ = self->priv->pos;
			_tmp48_ = string_offset (_tmp47_, (glong) 1);
			self->priv->pos = _tmp48_;
		}
		while (TRUE) {
			const gchar* _tmp49_;
			gchar _tmp50_;
			gboolean _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			_tmp49_ = self->priv->pos;
			_tmp50_ = string_get (_tmp49_, (glong) 0);
			_tmp51_ = g_ascii_isdigit (_tmp50_);
			if (!_tmp51_) {
				break;
			}
			_tmp52_ = self->priv->pos;
			_tmp53_ = string_offset (_tmp52_, (glong) 1);
			self->priv->pos = _tmp53_;
		}
	}
	_tmp54_ = self->priv->pos;
	_tmp55_ = string_get (_tmp54_, (glong) 0);
	switch (_tmp55_) {
		case 'l':
		case 'L':
		{
			ValadocHighlighterCodeScannerNumericType _tmp56_;
			_tmp56_ = numeric_type;
			if (_tmp56_ == VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER) {
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				gboolean _tmp59_ = FALSE;
				const gchar* _tmp60_;
				gchar _tmp61_;
				_tmp57_ = self->priv->pos;
				_tmp58_ = string_offset (_tmp57_, (glong) 1);
				self->priv->pos = _tmp58_;
				_tmp60_ = self->priv->pos;
				_tmp61_ = string_get (_tmp60_, (glong) 0);
				if (_tmp61_ == 'l') {
					_tmp59_ = TRUE;
				} else {
					const gchar* _tmp62_;
					gchar _tmp63_;
					_tmp62_ = self->priv->pos;
					_tmp63_ = string_get (_tmp62_, (glong) 0);
					_tmp59_ = _tmp63_ == 'L';
				}
				if (_tmp59_) {
					const gchar* _tmp64_;
					const gchar* _tmp65_;
					_tmp64_ = self->priv->pos;
					_tmp65_ = string_offset (_tmp64_, (glong) 1);
					self->priv->pos = _tmp65_;
				}
			}
			break;
		}
		case 'u':
		case 'U':
		{
			ValadocHighlighterCodeScannerNumericType _tmp66_;
			_tmp66_ = numeric_type;
			if (_tmp66_ == VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER) {
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				gboolean _tmp69_ = FALSE;
				const gchar* _tmp70_;
				gchar _tmp71_;
				_tmp67_ = self->priv->pos;
				_tmp68_ = string_offset (_tmp67_, (glong) 1);
				self->priv->pos = _tmp68_;
				_tmp70_ = self->priv->pos;
				_tmp71_ = string_get (_tmp70_, (glong) 0);
				if (_tmp71_ == 'l') {
					_tmp69_ = TRUE;
				} else {
					const gchar* _tmp72_;
					gchar _tmp73_;
					_tmp72_ = self->priv->pos;
					_tmp73_ = string_get (_tmp72_, (glong) 0);
					_tmp69_ = _tmp73_ == 'L';
				}
				if (_tmp69_) {
					const gchar* _tmp74_;
					const gchar* _tmp75_;
					gboolean _tmp76_ = FALSE;
					const gchar* _tmp77_;
					gchar _tmp78_;
					_tmp74_ = self->priv->pos;
					_tmp75_ = string_offset (_tmp74_, (glong) 1);
					self->priv->pos = _tmp75_;
					_tmp77_ = self->priv->pos;
					_tmp78_ = string_get (_tmp77_, (glong) 0);
					if (_tmp78_ == 'l') {
						_tmp76_ = TRUE;
					} else {
						const gchar* _tmp79_;
						gchar _tmp80_;
						_tmp79_ = self->priv->pos;
						_tmp80_ = string_get (_tmp79_, (glong) 0);
						_tmp76_ = _tmp80_ == 'L';
					}
					if (_tmp76_) {
						const gchar* _tmp81_;
						const gchar* _tmp82_;
						_tmp81_ = self->priv->pos;
						_tmp82_ = string_offset (_tmp81_, (glong) 1);
						self->priv->pos = _tmp82_;
					}
				}
			}
			break;
		}
		case 'f':
		case 'F':
		case 'd':
		case 'D':
		{
			const gchar* _tmp83_;
			const gchar* _tmp84_;
			numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL;
			_tmp83_ = self->priv->pos;
			_tmp84_ = string_offset (_tmp83_, (glong) 1);
			self->priv->pos = _tmp84_;
			break;
		}
		default:
		break;
	}
	_tmp85_ = self->priv->pos;
	_tmp86_ = string_get (_tmp85_, (glong) 0);
	_tmp87_ = g_ascii_isalnum (_tmp86_);
	if (_tmp87_) {
		numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE;
	}
	_tmp89_ = numeric_type;
	if (_tmp89_ != VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE) {
		_tmp88_ = VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL;
	} else {
		_tmp88_ = VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PLAIN;
	}
	_tmp90_ = start;
	_tmp91_ = self->priv->pos;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp90_, _tmp91_, _tmp88_);
}


static ValadocHighlighterCodeToken* valadoc_highlighter_code_scanner_dispatch (ValadocHighlighterCodeScanner* self, const gchar* start, const gchar* end) {
	ValadocHighlighterCodeToken* result = NULL;
	GQueue* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	glong length = 0L;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	glong _tmp8_;
	gchar* content = NULL;
	const gchar* _tmp9_;
	glong _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	ValadocHighlighterCodeToken* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (end != NULL, NULL);
	_tmp0_ = self->priv->token_queue;
	_tmp1_ = g_queue_is_empty (_tmp0_);
	_vala_assert (_tmp1_ == FALSE, "token_queue.is_empty () == false");
	_tmp2_ = start;
	_tmp3_ = end;
	if (((gchar*) _tmp2_) == ((gchar*) _tmp3_)) {
		GQueue* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = self->priv->token_queue;
		_tmp5_ = g_queue_pop_head (_tmp4_);
		result = (ValadocHighlighterCodeToken*) _tmp5_;
		return result;
	}
	_tmp6_ = start;
	_tmp7_ = end;
	_tmp8_ = string_pointer_to_offset (_tmp6_, _tmp7_);
	length = _tmp8_;
	_tmp9_ = start;
	_tmp10_ = length;
	_tmp11_ = string_substring (_tmp9_, (glong) 0, _tmp10_);
	content = _tmp11_;
	_tmp12_ = content;
	_tmp13_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PLAIN, _tmp12_);
	result = _tmp13_;
	_g_free0 (content);
	return result;
}


static void valadoc_highlighter_code_scanner_queue_token (ValadocHighlighterCodeScanner* self, const gchar* start, const gchar* end, ValadocHighlighterCodeTokenType token_type) {
	glong length = 0L;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	glong _tmp2_;
	gchar* content = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GQueue* _tmp5_;
	ValadocHighlighterCodeTokenType _tmp6_;
	ValadocHighlighterCodeToken* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	_tmp0_ = start;
	_tmp1_ = end;
	_tmp2_ = string_pointer_to_offset (_tmp0_, _tmp1_);
	length = _tmp2_;
	_tmp3_ = start;
	_tmp4_ = string_substring (_tmp3_, (glong) 0, length);
	content = _tmp4_;
	_tmp5_ = self->priv->token_queue;
	_tmp6_ = token_type;
	_tmp7_ = valadoc_highlighter_code_token_new (_tmp6_, content);
	g_queue_push_tail (_tmp5_, _tmp7_);
	_g_free0 (content);
}


static inline gboolean valadoc_highlighter_code_scanner_isidchar (ValadocHighlighterCodeScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = c;
	_tmp2_ = g_ascii_isalnum (_tmp1_);
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar _tmp3_;
		_tmp3_ = c;
		_tmp0_ = _tmp3_ == '_';
	}
	result = _tmp0_;
	return result;
}


static inline gboolean valadoc_highlighter_code_scanner_isidstartchar (ValadocHighlighterCodeScanner* self, gchar c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = c;
	_tmp3_ = g_ascii_isalnum (_tmp2_);
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		gchar _tmp4_;
		_tmp4_ = c;
		_tmp1_ = _tmp4_ == '_';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar _tmp6_;
		_tmp6_ = c;
		if (_tmp6_ == '@') {
			gboolean _tmp7_;
			_tmp7_ = self->priv->enable_keyword_escape;
			_tmp5_ = _tmp7_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}


static void valadoc_highlighter_code_scanner_class_init (ValadocHighlighterCodeScannerClass * klass) {
	valadoc_highlighter_code_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocHighlighterCodeScannerPrivate));
	G_OBJECT_CLASS (klass)->finalize = valadoc_highlighter_code_scanner_finalize;
}


static void valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_interface_init (ValadocHighlighterScannerIface * iface) {
	valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (ValadocHighlighterCodeToken* (*) (ValadocHighlighterScanner *)) valadoc_highlighter_code_scanner_real_next;
}


static void valadoc_highlighter_code_scanner_instance_init (ValadocHighlighterCodeScanner * self) {
	GQueue* _tmp0_;
	self->priv = VALADOC_HIGHLIGHTER_CODE_SCANNER_GET_PRIVATE (self);
	_tmp0_ = g_queue_new ();
	self->priv->token_queue = _tmp0_;
}


static void valadoc_highlighter_code_scanner_finalize (GObject * obj) {
	ValadocHighlighterCodeScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HIGHLIGHTER_TYPE_CODE_SCANNER, ValadocHighlighterCodeScanner);
	_vala_map_unref0 (self->priv->keywords);
	__g_queue_free__valadoc_highlighter_code_token_unref0_0 (self->priv->token_queue);
	G_OBJECT_CLASS (valadoc_highlighter_code_scanner_parent_class)->finalize (obj);
}


/**
 * A cheap scanner used to highlight C and Vala source code.
 */
GType valadoc_highlighter_code_scanner_get_type (void) {
	static volatile gsize valadoc_highlighter_code_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_highlighter_code_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocHighlighterCodeScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_highlighter_code_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHighlighterCodeScanner), 0, (GInstanceInitFunc) valadoc_highlighter_code_scanner_instance_init, NULL };
		static const GInterfaceInfo valadoc_highlighter_scanner_info = { (GInterfaceInitFunc) valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_highlighter_code_scanner_type_id;
		valadoc_highlighter_code_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocHighlighterCodeScanner", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_highlighter_code_scanner_type_id, VALADOC_HIGHLIGHTER_TYPE_SCANNER, &valadoc_highlighter_scanner_info);
		g_once_init_leave (&valadoc_highlighter_code_scanner_type_id__volatile, valadoc_highlighter_code_scanner_type_id);
	}
	return valadoc_highlighter_code_scanner_type_id__volatile;
}



