/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMCharacterData.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMCharacterDataPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMCharacterData* kit(WebCore::CharacterData* obj)
{
    return WEBKIT_DOM_CHARACTER_DATA(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::CharacterData* core(WebKitDOMCharacterData* request)
{
    return request ? static_cast<WebCore::CharacterData*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMCharacterData* wrapCharacterData(WebCore::CharacterData* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_CHARACTER_DATA(g_object_new(WEBKIT_TYPE_DOM_CHARACTER_DATA, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMCharacterData, webkit_dom_character_data, WEBKIT_TYPE_DOM_NODE)

enum {
    PROP_0,
    PROP_DATA,
    PROP_LENGTH,
};

static void webkit_dom_character_data_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMCharacterData* self = WEBKIT_DOM_CHARACTER_DATA(object);
    WebCore::CharacterData* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DATA: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setData(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_character_data_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMCharacterData* self = WEBKIT_DOM_CHARACTER_DATA(object);
    WebCore::CharacterData* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DATA: {
        g_value_take_string(value, convertToUTF8String(coreSelf->data()));
        break;
    }
    case PROP_LENGTH: {
        g_value_set_ulong(value, coreSelf->length());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_character_data_class_init(WebKitDOMCharacterDataClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_character_data_set_property;
    gobjectClass->get_property = webkit_dom_character_data_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_DATA,
                                    g_param_spec_string("data", /* name */
                                                           "character_data_data", /* short description */
                                                           "read-write  gchar* CharacterData.data", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LENGTH,
                                    g_param_spec_ulong("length", /* name */
                                                           "character_data_length", /* short description */
                                                           "read-only  gulong CharacterData.length", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXULONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_character_data_init(WebKitDOMCharacterData* request)
{
}

gchar*
webkit_dom_character_data_substring_data(WebKitDOMCharacterData* self, gulong offset, gulong length, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::CharacterData* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    gchar* result = convertToUTF8String(item->substringData(offset, length, ec));
    return result;
}

void
webkit_dom_character_data_append_data(WebKitDOMCharacterData* self, const gchar* data, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self));
    g_return_if_fail(data);
    g_return_if_fail(!error || !*error);
    WebCore::CharacterData* item = WebKit::core(self);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    WebCore::ExceptionCode ec = 0;
    item->appendData(convertedData, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_character_data_insert_data(WebKitDOMCharacterData* self, gulong offset, const gchar* data, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self));
    g_return_if_fail(data);
    g_return_if_fail(!error || !*error);
    WebCore::CharacterData* item = WebKit::core(self);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    WebCore::ExceptionCode ec = 0;
    item->insertData(offset, convertedData, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_character_data_delete_data(WebKitDOMCharacterData* self, gulong offset, gulong length, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self));
    g_return_if_fail(!error || !*error);
    WebCore::CharacterData* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->deleteData(offset, length, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_character_data_replace_data(WebKitDOMCharacterData* self, gulong offset, gulong length, const gchar* data, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self));
    g_return_if_fail(data);
    g_return_if_fail(!error || !*error);
    WebCore::CharacterData* item = WebKit::core(self);
    WTF::String convertedData = WTF::String::fromUTF8(data);
    WebCore::ExceptionCode ec = 0;
    item->replaceData(offset, length, convertedData, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

void
webkit_dom_character_data_remove(WebKitDOMCharacterData* self, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self));
    g_return_if_fail(!error || !*error);
    WebCore::CharacterData* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    item->remove(ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gchar*
webkit_dom_character_data_get_data(WebKitDOMCharacterData* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self), 0);
    WebCore::CharacterData* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->data());
    return result;
}

void
webkit_dom_character_data_set_data(WebKitDOMCharacterData* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::CharacterData* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setData(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

gulong
webkit_dom_character_data_get_length(WebKitDOMCharacterData* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_CHARACTER_DATA(self), 0);
    WebCore::CharacterData* item = WebKit::core(self);
    gulong result = item->length();
    return result;
}

