/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMDOMWindowCSS.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMDOMWindowCSSPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_DOM_WINDOW_CSS_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_DOM_WINDOW_CSS, WebKitDOMDOMWindowCSSPrivate)

typedef struct _WebKitDOMDOMWindowCSSPrivate {
#if ENABLE(CSS3_CONDITIONAL_RULES)
    RefPtr<WebCore::DOMWindowCSS> coreObject;
#endif // ENABLE(CSS3_CONDITIONAL_RULES)
} WebKitDOMDOMWindowCSSPrivate;

#if ENABLE(CSS3_CONDITIONAL_RULES)

namespace WebKit {

WebKitDOMDOMWindowCSS* kit(WebCore::DOMWindowCSS* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_DOM_WINDOW_CSS(ret);

    return wrapDOMWindowCSS(obj);
}

WebCore::DOMWindowCSS* core(WebKitDOMDOMWindowCSS* request)
{
    return request ? static_cast<WebCore::DOMWindowCSS*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMDOMWindowCSS* wrapDOMWindowCSS(WebCore::DOMWindowCSS* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_DOM_WINDOW_CSS(g_object_new(WEBKIT_TYPE_DOM_DOM_WINDOW_CSS, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(CSS3_CONDITIONAL_RULES)

G_DEFINE_TYPE(WebKitDOMDOMWindowCSS, webkit_dom_dom_window_css, WEBKIT_TYPE_DOM_OBJECT)

static void webkit_dom_dom_window_css_finalize(GObject* object)
{
    WebKitDOMDOMWindowCSSPrivate* priv = WEBKIT_DOM_DOM_WINDOW_CSS_GET_PRIVATE(object);
#if ENABLE(CSS3_CONDITIONAL_RULES)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(CSS3_CONDITIONAL_RULES)
    priv->~WebKitDOMDOMWindowCSSPrivate();
    G_OBJECT_CLASS(webkit_dom_dom_window_css_parent_class)->finalize(object);
}

static GObject* webkit_dom_dom_window_css_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_dom_window_css_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(CSS3_CONDITIONAL_RULES)
    WebKitDOMDOMWindowCSSPrivate* priv = WEBKIT_DOM_DOM_WINDOW_CSS_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::DOMWindowCSS*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(CSS3_CONDITIONAL_RULES)
    return object;
}

static void webkit_dom_dom_window_css_class_init(WebKitDOMDOMWindowCSSClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMDOMWindowCSSPrivate));
    gobjectClass->constructor = webkit_dom_dom_window_css_constructor;
    gobjectClass->finalize = webkit_dom_dom_window_css_finalize;
}

static void webkit_dom_dom_window_css_init(WebKitDOMDOMWindowCSS* request)
{
    WebKitDOMDOMWindowCSSPrivate* priv = WEBKIT_DOM_DOM_WINDOW_CSS_GET_PRIVATE(request);
    new (priv) WebKitDOMDOMWindowCSSPrivate();
}

gboolean
webkit_dom_dom_window_css_supports(WebKitDOMDOMWindowCSS* self, const gchar* property, const gchar* value)
{
#if ENABLE(CSS3_CONDITIONAL_RULES)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_DOM_WINDOW_CSS(self), FALSE);
    g_return_val_if_fail(property, FALSE);
    g_return_val_if_fail(value, FALSE);
    WebCore::DOMWindowCSS* item = WebKit::core(self);
    WTF::String convertedProperty = WTF::String::fromUTF8(property);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    gboolean result = item->supports(convertedProperty, convertedValue);
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Css3 Conditional Rules")
    return static_cast<gboolean>(0);
#endif /* ENABLE(CSS3_CONDITIONAL_RULES) */
}

