/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLLinkElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLLinkElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMStyleSheetPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLLinkElement* kit(WebCore::HTMLLinkElement* obj)
{
    return WEBKIT_DOM_HTML_LINK_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLLinkElement* core(WebKitDOMHTMLLinkElement* request)
{
    return request ? static_cast<WebCore::HTMLLinkElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLLinkElement* wrapHTMLLinkElement(WebCore::HTMLLinkElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_LINK_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_LINK_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLLinkElement, webkit_dom_html_link_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_DISABLED,
    PROP_CHARSET,
    PROP_HREF,
    PROP_HREFLANG,
    PROP_MEDIA,
    PROP_REL,
    PROP_REV,
    PROP_TARGET,
    PROP_TYPE,
    PROP_SHEET,
};

static void webkit_dom_html_link_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLLinkElement* self = WEBKIT_DOM_HTML_LINK_ELEMENT(object);
    WebCore::HTMLLinkElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        coreSelf->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, (g_value_get_boolean(value)));
        break;
    }
    case PROP_CHARSET: {
        coreSelf->setAttribute(WebCore::HTMLNames::charsetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HREF: {
        coreSelf->setAttribute(WebCore::HTMLNames::hrefAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HREFLANG: {
        coreSelf->setAttribute(WebCore::HTMLNames::hreflangAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_MEDIA: {
        coreSelf->setAttribute(WebCore::HTMLNames::mediaAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REL: {
        coreSelf->setAttribute(WebCore::HTMLNames::relAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_REV: {
        coreSelf->setAttribute(WebCore::HTMLNames::revAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TARGET: {
        coreSelf->setAttribute(WebCore::HTMLNames::targetAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_link_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLLinkElement* self = WEBKIT_DOM_HTML_LINK_ELEMENT(object);
    WebCore::HTMLLinkElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->fastHasAttribute(WebCore::HTMLNames::disabledAttr));
        break;
    }
    case PROP_CHARSET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::charsetAttr)));
        break;
    }
    case PROP_HREF: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getURLAttribute(WebCore::HTMLNames::hrefAttr)));
        break;
    }
    case PROP_HREFLANG: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::hreflangAttr)));
        break;
    }
    case PROP_MEDIA: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::mediaAttr)));
        break;
    }
    case PROP_REL: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::relAttr)));
        break;
    }
    case PROP_REV: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::revAttr)));
        break;
    }
    case PROP_TARGET: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::targetAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_SHEET: {
        RefPtr<WebCore::StyleSheet> ptr = coreSelf->sheet();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_link_element_class_init(WebKitDOMHTMLLinkElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_link_element_set_property;
    gobjectClass->get_property = webkit_dom_html_link_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_link_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLLinkElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_CHARSET,
                                    g_param_spec_string("charset", /* name */
                                                           "html_link_element_charset", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.charset", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HREF,
                                    g_param_spec_string("href", /* name */
                                                           "html_link_element_href", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.href", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HREFLANG,
                                    g_param_spec_string("hreflang", /* name */
                                                           "html_link_element_hreflang", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.hreflang", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MEDIA,
                                    g_param_spec_string("media", /* name */
                                                           "html_link_element_media", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.media", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REL,
                                    g_param_spec_string("rel", /* name */
                                                           "html_link_element_rel", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.rel", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_REV,
                                    g_param_spec_string("rev", /* name */
                                                           "html_link_element_rev", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.rev", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TARGET,
                                    g_param_spec_string("target", /* name */
                                                           "html_link_element_target", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.target", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_link_element_type", /* short description */
                                                           "read-write  gchar* HTMLLinkElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SHEET,
                                    g_param_spec_object("sheet", /* name */
                                                           "html_link_element_sheet", /* short description */
                                                           "read-only  WebKitDOMStyleSheet* HTMLLinkElement.sheet", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STYLE_SHEET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_link_element_init(WebKitDOMHTMLLinkElement* request)
{
}

gboolean
webkit_dom_html_link_element_get_disabled(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), FALSE);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gboolean result = item->fastHasAttribute(WebCore::HTMLNames::disabledAttr);
    return result;
}

void
webkit_dom_html_link_element_set_disabled(WebKitDOMHTMLLinkElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    item->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value);
}

gchar*
webkit_dom_html_link_element_get_charset(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::charsetAttr));
    return result;
}

void
webkit_dom_html_link_element_set_charset(WebKitDOMHTMLLinkElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::charsetAttr, convertedValue);
}

gchar*
webkit_dom_html_link_element_get_href(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getURLAttribute(WebCore::HTMLNames::hrefAttr));
    return result;
}

void
webkit_dom_html_link_element_set_href(WebKitDOMHTMLLinkElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::hrefAttr, convertedValue);
}

gchar*
webkit_dom_html_link_element_get_hreflang(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::hreflangAttr));
    return result;
}

void
webkit_dom_html_link_element_set_hreflang(WebKitDOMHTMLLinkElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::hreflangAttr, convertedValue);
}

gchar*
webkit_dom_html_link_element_get_media(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::mediaAttr));
    return result;
}

void
webkit_dom_html_link_element_set_media(WebKitDOMHTMLLinkElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::mediaAttr, convertedValue);
}

gchar*
webkit_dom_html_link_element_get_rel(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::relAttr));
    return result;
}

void
webkit_dom_html_link_element_set_rel(WebKitDOMHTMLLinkElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::relAttr, convertedValue);
}

gchar*
webkit_dom_html_link_element_get_rev(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::revAttr));
    return result;
}

void
webkit_dom_html_link_element_set_rev(WebKitDOMHTMLLinkElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::revAttr, convertedValue);
}

gchar*
webkit_dom_html_link_element_get_target(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::targetAttr));
    return result;
}

void
webkit_dom_html_link_element_set_target(WebKitDOMHTMLLinkElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::targetAttr, convertedValue);
}

WebKitDOMStyleSheet*
webkit_dom_html_link_element_get_sheet(WebKitDOMHTMLLinkElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_LINK_ELEMENT(self), 0);
    WebCore::HTMLLinkElement* item = WebKit::core(self);
    RefPtr<WebCore::StyleSheet> gobjectResult = WTF::getPtr(item->sheet());
    return WebKit::kit(gobjectResult.get());
}

