#include <stdio.h>
#include <string.h>
#include <ctype.h>

char *header[] = {
"do_panic:",
"	pushl	42",
"	jmp	_exit",
"",
"	.data",
"filename:",
"	.ascii	\"&\\0\"",
"dll:",
"	.long	0",
"do_lookup:",
"	cmpl	$0,dll",
"	jne	done_lookup",
"	pushl	$filename",
"	call	_dll_load",
"	popl	%edx",
"	or	%eax,%eax",
"	jnz	lookup_ok",
"	jmp	do_panic",
"lookup_ok:",
"	movl	%eax,dll",
"done_lookup:",
"	pushl	4(%esp)",
"	movl	dll,%eax",
"	pushl	%eax",
"	call	_dll_lookup",
"	popl	%edx",
"	popl	%edx",
"	or	%eax,%eax",
"	jnz	__dll_r",
"	jmp	do_panic",
"__dll_r:",
"	ret",
0
};

char *templ[] = {
"	.data",
"__dll_n_&:",
"	.ascii	\"&\\0\"",
"__dll_j_&:",
"	.long	__dll_l_&",
"	.text",
"__dll_l_&:",
"	pushl	$__dll_n_&",
"	call	do_lookup",
"	popl	%edx",
"	movl	%eax,__dll_j_&",
"	.globl	&",
"&:",
"	movl	__dll_j_&,%eax",
"	jmp	%eax",
0
};

void emit(FILE *f, char **list, char *fill)
{
  int i, j;
  for (i=0; list[i]; i++)
  {
    for (j=0; list[i][j]; j++)
      if (list[i][j] == '&')
        fputs(fill, f);
      else
        fputc(list[i][j], f);
    fputc('\n', f);
  }
}

main(int argc, char **argv)
{
  char buf[1000];
  if (argc < 3)
  {
    fprintf(stderr, "Usage: mkdlllib <file.o> <dllfile.s>\n");
    return 1;
  }
  FILE *ofile = fopen(argv[2], "w");
  emit(ofile, header, argv[1]);

  sprintf(buf, "nm %s", argv[1]);
  FILE *p = popen(buf, "r");
  while (fgets(buf, 1000, p))
  {
    buf[strlen(buf)-1] = 0;
    if (isxdigit(buf[0]) && buf[10] == 'g' && buf[12] == 'e')
      emit(ofile, templ, buf+28);
  }
  pclose(p);
  fclose(ofile);
  return 0;
}
