#! /bin/sh

# Building GDB-6.4 for DJGPP
#
VERSION=6.4
EXTRA_VER_INFO=

CURR=`pwd`
DVER=`echo $VERSION | sed 's:\.::2g'`
DVER0=`echo $VERSION | sed 's:\.::g'`
src=$CURR/gnu/gdb-$DVER
inst=$CURR/install.gdb


apply_patches() 
{
   AUTOCONF_LIST=
   AUTOMAKE_LIST=
   ACLOCAL_LIST=
   files=`( cd $1 && find . -type f | sed -e 's#^\./##')`
   for file in $files; do
      nm1=$file
      case $file in
         *.diff)
	     orig_name=`echo $file | sed -e 's#\.diff$##'`
             if [ -f $2/$orig_name ] ; then
                cat $1/$file | patch --verbose $2/$orig_name
                nm1=$orig_name 
             else
                echo "File $2/$orig_name is not found"
             fi
             ;; 
         *~*)  
             ;;
         *)   
	     dirname=`dirname $file`
	     mkdir -p $2/$dirname
             cp -v $1/$file $2/$file
             nm1=$file
             ;;  
      esac

      case $nm1 in
             Makefile.am)
                  AUTOMAKE_LIST="$nm1 $AUTOMAKE_LIST"
                  ;;

             acinclude.m4)
                  ACLOCAL_LIST="$nm1 $ACLOCAL_LIST"
                  ;;
      esac    
   done
}


unpack_sources () {
  archive=
  for arc_ext in tgz tar.gz tar.bz2 ; do
     if [ -f gdb-$VERSION.$arc_ext ] ; then
        archive=gdb-$VERSION.$arc_ext
     fi
  done

  if [ -z $archive ] ; then
     echo "Source archive of gdb-$VERSION is not found"
     exit 1
  fi

  ./djtar -x -p -o gdb-$VERSION/gdb/config/djgpp/fnchange.lst $archive >fnchange.tmp
  sed -e "s,@V@,gdb-$VERSION,g" < fnchange.tmp > fnchange.lst
  grep -q gdb fnchange.lst || exit 1
  ./djtar -x -n fnchange.lst $archive || exit
  apply_patches diffs/source gdb-$VERSION
  rm fnchange.tmp fnchange.lst
}

create_source_archive ()
{
  test -d gnu/gdb-$DVER && rm -rf gnu/gdb-$DVER
  test -d gnu || mkdir gnu
  mv -v gdb-$VERSION gnu/gdb-$DVER || exit 1
  cd gnu/gdb-$DVER || exit 1
  gdb/config/djgpp/djconfig.sh || exit 1
  cd $CURR || exit 1
  rm -rf manifest/gdb${DVER0}s.*
  mkdir manifest
  echo "gdb$DVER0.zip - gdb-$VERSION $EXTRA_VER_INFO (source archive for DJGPP)" >manifest/gdb${DVER0}s.ver
  echo "" >manifest/gdb${DVER0}s.mft
  ( find gnu/gdb-$DVER -type f ; find manifest -name gdb${DVER0}s'.*' ) |\
       sort >manifest/gdb${DVER0}s.mft
  ( cd dsi && ./mk-dsm.sh $VERSION && cp -v gdb${DVER0}s.mft ../manifest/ )
  cat manifest/gdb${DVER0}s.mft | zip -9@ gdb${DVER0}s.zip
}

setup_env () {
  export TEST_FINDS_EXE=Y
  export PATH_SEPARATOR=:
  top=`( cd $src && pwd ) | sed -e 's/^[a-zA-Z]:\//\//g' -e 's/^\/dev\/[a-zA-Z]\//\//g'`
  target=i586-pc-msdosdjgpp
  export AS=as
  export CC=gcc
  export ac_cv_func_mmap_dev_zero=no
  export lt_cv_sys_max_cmd_len=12000
  export ac_cv_prog_LN='cp -p'
  export ac_cv_prog_LN_S="cp -p"
  export ac_setrlimit=no
  CONFIG_SHELL=`/bin/sh -c 'echo $0'`
  case $CONFIG_SHELL in *.exe) ;; *) CONFIG_SHELL=$CONFIG_SHELL.exe ;; esac
  export CONFIG_SHELL
}

build_gdb () {
  result=false
  cd $src || exit 1
  make SHELL=$CONFIG_SHELL LN_S='cp -p' && result=true
  make -C bfdsymify || exit 1
  cd $CURR
  $result
}


install_temp () {
  cd $CURR
  rm -rf install.gdb
  cd $src || exit 1
  make SHELL=$CONFIG_SHELL LN_S='cp -p' prefix=$inst install || exit 1
  cd $inst || exit 1

  for d in bfd gdb libiberty mmalloc opcodes readline bfdsymify .; do
    for f in README COPYING TODO NEWS PROBLEMS CONTRIBUTE MAINTAINERS; do
      if [ -f $src/$d/$f ] ; then
         if ! [ -d gnu/gdb-$DVER/$d ] ; then
            mkdir -p gnu/gdb-$DVER/$d
         fi
         cp -v $src/$d/$f gnu/gdb-$DVER/$d/
      fi
    done
  done

  cp -v $src/gdb/config/djgpp/readme gnu/gdb-$DVER/README.DJGPP
  mkdir gnu/gdb-$DVER/bfdsymify
  cp -v $src/bfdsymify/bfdsymify.exe bin/
  cp -v $src/bfdsymify/readme gnu/gdb-$DVER/bfdsymify/
  rm info/dir
  for file in info/*.info; do
    echo $file
    cat $file | \
    awk 'substr($0,1,9)=="Indirect:" { active=1; } \
         substr($0,1,10)=="Tag Table:" { active=0; } \
         { if (active) gsub("info-","i"); \
           print $0 }' > $file.new
    mv -fv $file.new $file
    f0=`basename $file`
    for x in `find info -name $f0-'*'`; do 
      mv -v $x `echo $x | sed 's:\.info-:.i:'`
    done
  done

  echo "Converting man pages ..."

  for x in `find man -type f -and -name '*.[1-9]*'`; do
    case $x in 
      man/man*)
	    echo `basename $x`
	    x1=`echo $x | sed -e 's,^man/,,g'`
            c1=`echo $x1 | sed -e 's,man\([1-9]\)/,cat\1/,g'`
            ginstall -d man/`dirname $c1`
	    ( cd man && groff -man -Tascii $x1 >$c1 )
            ;;
    esac
  done

  for file in bin/*.exe; do
    strip $file
  done

  for file in lib/*.a; do
    strip -g $file
  done

  mkdir manifest
  echo "gdb${DVER0}a.zip - gdb-$VERSION $EXTRA_VER_INFO (extra binary archive for DJGPP)" >manifest/gdb${DVER0}a.ver
  echo "gdb${DVER0}b.zip - gdb-$VERSION $EXTRA_VER_INFO (binary archive for DJGPP)" >manifest/gdb${DVER0}b.ver
  echo "" >manifest/gdb${DVER0}a.mft
  echo "" >manifest/gdb${DVER0}b.mft

  cp -v $CURR/dsi/gdb*[adb].zip manifest/ 

  dgba=
  gdbb=
  skipped=
  files=`find . -type f | sed 's:^\./::' | sort`
  for x in $files; do
    case $x in
      man/man*/*) skipped="$skipped $x" ;;
      */bfd/* | */opcodes/* | */libiberty/* ) gdba="$gdba $x" ;;
      */readline/* | */mmalloc/*) gdba="$gdba $x" ;;
      */gdb.* | bin/bfdsymify.exe | */gdb/* | manifest/gdb*b.* ) gdbb="$gdbb $x" ;;
      info/annotate.* | info/gdbint.* | info/stabs.* ) gdbb="$gdbb $x" ;;
      info/configure.* | info/mmalloc.* | info/standards.* ) gdba="$gdba $x" ;;
      gnu/gdb*/*) gdbb="$gdbb $x" ;;
      *.h | *.a | *.la | */bfd* | manifest/gdb*a.* ) gdba="$gdba $x" ;;
      *) skipped="$skipped $x" ;;
    esac
  done 

  rm manifest/gdb${DVER0}a.mft
  rm manifest/gdb${DVER0}b.mft
  rm -f $CURR/skipped
  for x in $gdbb ; do
    echo $x >>manifest/gdb${DVER0}b.mft
  done
  for x in $gdba ; do
    echo $x >>manifest/gdb${DVER0}a.mft
  done
  for x in $skipped ; do
    echo $x >>$CURR/skipped
  done

  for x in a b ; do
    rm -f $CURR/gdb$DVER0$x.zip
    cat manifest/gdb$DVER0$x.mft | zip -9@ $CURR/gdb$DVER0$x.zip
  done
}



unpack_sources
create_source_archive
setup_env
build_gdb || exit 1
install_temp || exit 1
