#include <math.h>
#include <stdio.h>

static double argument[] = {
  -1.5707963267948966192313216916398L,  /* -90 degree.  */
  -1.3089969389957471826927680763665L,  /* -75 degree.  */
  -1.0471975511965977461542144610932L,  /* -60 degree.  */
  -0.7853981633974483096156608458199L,  /* -45 degree.  */
  -0.5235987755982988730771072305466L,  /* -30 degree.  */
  -0.2617993877991494365385536152733L,  /* -15 degree.  */
  +0.0000000000000000000000000000000L,  /* +0  degree.  */
  +0.2617993877991494365385536152733L,  /* +15 degree.  */
  +0.5235987755982988730771072305466L,  /* +30 degree.  */
  +0.7853981633974483096156608458199L,  /* +45 degree.  */
  +1.0471975511965977461542144610932L,  /* +60 degree.  */
  +1.3089969389957471826927680763665L,  /* +75 degree.  */
  +1.5707963267948966192313216916398L,  /* +90 degree.  */
  +2.0943951023931954923084289221863L,  /* +120 degree. */
  +2.6179938779914943653855361527329L,  /* +150 degree. */
  +3.1415926535897932384626433832795L,  /* +180 degree. */
  +3.1415926535897932384626433832795L,  /* +180 degree. */
  +3.9269908169872415480783042290994L,  /* +225 degree. */
  +4.7123889803846898576939650749193L,  /* +270 degree. */
  +5.4977871437821381673096259207391L,  /* +315 degree. */
  +6.283185307179586476925286766559L,   /* +360 degree. */
};

static double should_be[][2] = {
  /*   sine value        cosine value   */
  {-1.000000000000000, 0.000000000000000},
  {-0.965925826289068, 0.258819045102521},
  {-0.866025403784439, 0.500000000000000},
  {-0.707106781186547, 0.707106781186548},
  {-0.500000000000000, 0.866025403784439},
  {-0.258819045102521, 0.965925826289068},
  {0.000000000000000, 1.000000000000000},
  {0.258819045102521, 0.965925826289068},
  {0.500000000000000, 0.866025403784439},
  {0.707106781186547, 0.707106781186548},
  {0.866025403784439, 0.500000000000000},
  {0.965925826289068, 0.258819045102521},
  {1.000000000000000, 0.000000000000000},
  {0.866025403784439, -0.500000000000000},
  {0.500000000000000, -0.866025403784439},
  {0.000000000000000, -1.000000000000000},
  {0.000000000000000, -1.000000000000000},
  {-0.707106781186547, -0.707106781186548},
  {-1.000000000000000, -0.000000000000000},
  {-0.707106781186548, 0.707106781186547},
  {-0.000000000000000, 1.000000000000000}
};

static const size_t n_test_arguments = sizeof(argument) / sizeof(argument[0]);


int main(void)
{
  unsigned int i, error_counter;

  for (error_counter = i = 0; i < n_test_arguments; i++)
  {
    double sv, cv;
    sincos(argument[i], &sv, &cv);
    if (fabs(sv - should_be[i][0]) > 1.E-15 || fabs(cv - should_be[i][1]) > 1.E-15)
    {
      printf("sincos failed for %.15f\n"
             "returned values: sine value   = %.15f,  should be = %.15f\n"
             "                 cosine value = %.15f,  should be = %.15f\n",
             argument[i], sv, should_be[i][0], cv, should_be[i][1]);
      error_counter++;
    }
  }

  if (error_counter == 0)
    printf("sincos test passed.\n");

  return error_counter;
}
