/* $Id: terminal.c,v 1.1 2003/03/01 19:06:50 richdawe Exp $ */

/*
 * terminal.c - Terminal-handling functions for pakke
 * Copyright (C) 2003 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"

#include <stdio.h>
#include <termios.h>
#include <unistd.h>

#include "terminal.h"

int
terminal_getchar (void)
{
  const int fileno_stdin = fileno(stdin);

  if (isatty(fileno_stdin))
    tcflush(fileno_stdin, TCIFLUSH);

  return(getchar());
}
