/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _MENU_C_

#include "editor.h"

extern PREFERENCES pref;
extern WINDOW *win;
extern unsigned video_base;
extern union REGS regs;

typedef struct _MENU_tag {
	unsigned short		hotkey;
	char			item[30];
} MENU;

char scrnbuf[4000];

MENU file_menu[] =
{
	{ 2, 	" New             " },
	{ 2, 	" Open ...     F3 " },
	{ 2, 	" Save         F2 " },
	{ 3, 	" Save As ...     " },
	{ 12, 	" Save Config     " },
	{ 0, 	"" 		    },
	{ 2, 	" Print           " },
	{ 2, 	" DOS Shell       " },
	{ 2, 	" Exec. DOS Cmd.  " },
	{ 0, 	"" 	            },
	{ 3, 	" Exit      Alt-X " },
	{ -1, 	NULL 		    },
};

MENU edit_menu[] =
{
	{ 4, 	" Cut         Shift+Del " },
	{ 2, 	" Copy           Ctrl+K " },
	{ 2, 	" Paste       Shift+Ins " },
	{ 3, 	" Clear          Ctrl+N " },
	{ -1, 	NULL 		    	  },
};

MENU search_menu[] =
{
	{ 2, 	" Find ...       Ctrl+F " },
	{ 2, 	" Replace ...    Ctrl+A " },
	{ 3, 	" Repeat Find    Ctrl+L " },
	{ 12, 	" Repeat Replace Ctrl+J " },
	{ 0, 	"" 		          },
	{ 2, 	" Go to line number ... " },
	{ -1, 	NULL 		    	  },
};

MENU options_menu[] =
{
	{ 2, 	" Editor ...      " },
	{ 2, 	" Desktop ...     " },
	{ -1, 	NULL 		    },
};

MENU window_menu[] =
{
	{ 2, 	" Size/Move     Ctrl+F5 " },
	{ 2, 	" Full Screen        F5 " },
	{ 0, 	"" 			  },
	{ 2, 	" New Window    Ctrl+F6 " },
	{ 4, 	" Next Window        F6 " },
	{ 4, 	" Close Window   Alt+F3 " },
	{ 3, 	" Close All             " },
	{ -1, 	NULL 		          },
};

MENU help_menu[] =
{
	{ 2, 	" Help Contents    " },
	{ 2, 	" About ...        " },
	{ -1, 	NULL 		     },
};

void sngbox(int x1, int y1, int x2, int y2)
{
	int f, g;
	/* Border characters. */
	gotoxy(x1, y1); cprintf("");
	gotoxy(x2, y1); cprintf("");
	gotoxy(x1, y2); cprintf("");
	gotoxy(x2, y2); cprintf("");

	/* Horizontal lines. */
	for(f = x1 + 1; f <= x2 - 1; f++)
	{
		gotoxy(f, y1); cprintf("");
		gotoxy(f, y2); cprintf("");
	}

	/* Vertical lines. */
	for(f = y1 + 1; f <= y2 - 1; f++)
	{
		gotoxy(x1, f); cprintf("");
		gotoxy(x2, f); cprintf("");
	}

	/* Horizontal spaces. */
	for(f = y1 + 1; f <= y2 - 1; f++)
	{
		gotoxy(x1 + 1, f);
		for(g = x1 + 1; g <= x2 - 1; g++)
		cprintf(" ");
	}

	/* Draw shadow. */
	/* Horizontal lines. */
	gotoxy(x1 + 2, y2 + 1);
	textbackground(BLACK);		/* Don't bother about text color. */
	for(f = x1 + 2; f <= x2 + 2; f++)
	cprintf(" ");

	/* Vertical lines. */
	for(f = y1 + 1; f <= y2; f++)
	{
		gotoxy(x2 + 1, f);
		cprintf("  ");
	}
}

int pulldown(MENU *menu, int x, int y, int size)
{
	int f, g, nitems, choice = 1, quit = 0, key, dirty = 1;
	int curx = wherex(), cury = wherey();	/* Save cursor position. */
						/* Don't bother about window. */
	/* Save screen. */
	_setcursortype(0);
	movedata(_dos_ds,
                video_base,
		FP_SEG(scrnbuf),
		FP_OFF(scrnbuf),
		4000);

	/* Calculate number of items. */
	nitems = 0;
	while (menu[nitems].hotkey != 0xffff) nitems++;

	/* Draw menu. */
	textcolor(pref.pullmenucolor);
	textbackground(pref.pullmenubkcolor);
	sngbox(x, y, x + size, y + nitems + 1);

	while (!quit)
	{
		if (dirty) {
			textcolor(pref.pullmenucolor);
			textbackground(pref.pullmenubkcolor);
			for(f = 1; f <= nitems; f++)
			{
				textcolor(pref.pullmenucolor);
				gotoxy(x + 2, y + f);
				cprintf("%s", menu[f - 1].item);
				/* Highlight hotkey. */
				textcolor(RED +
					(pref.pullmenucolor & BLINK));
				if (menu[f - 1].hotkey) {
					gotoxy(x + menu[f - 1].hotkey + 1,
						y + f);
					cprintf("%c",
						menu[f - 1].
						item[menu[f - 1].
						hotkey - 1]);
				}

				/* See if it is a separator. */
				if (!strcmp(menu[f - 1].item, "")) {
					textcolor(pref.pullmenucolor);
					gotoxy(x, y + f);
					cprintf("");
					for(g = x; g <= x + size - 2; g++)
					cprintf("");
					cprintf("");
				}
			}

			/* Highlight choice. */
			gotoxy(x + 2, y + choice);
			textcolor(pref.menubarcolor);
			textbackground(pref.menubarbkcolor);
			cprintf("%s", menu[choice - 1].item);
			if (menu[choice - 1].hotkey) {
				textcolor(RED +
					(pref.pullmenucolor & BLINK));
				gotoxy(x + menu[choice - 1].hotkey + 1,
					y + choice);
				cprintf("%c",
					menu[choice - 1].
					item[menu[choice - 1].hotkey - 1]);
			}
			dirty = 0;
		}

		key = wait();
		if (!key) key = 256 + getch();

		if (key < 0) {
			mousestat();

			/* See if it is the menu bar. */
			if (mregs.x.dx == 8) {
				quit = 1;
				if (mregs.x.cx < 80) choice = 289; /* Alt-F. */
				else if (mregs.x.cx < 136) choice = 274;	/* Alt-E. */
				else if (mregs.x.cx < 208) choice = 287;	/* Alt-S. */
				else if (mregs.x.cx < 288) choice = 280;	/* Alt-O. */
				else if (mregs.x.cx < 368) choice = 273;	/* Alt-W. */
				else if (mregs.x.cx > 536) choice = 291;	/* Alt-H. */
				else quit = 0;
				continue;
			}

			if ((mregs.x.dx < y * 8) ||
				(mregs.x.dx > (y + nitems - 1) * 8)) {
				quit = 1;
				choice = -1;
				continue;
			}
			if ((mregs.x.cx < x * 8) ||
				(mregs.x.cx > (x + size - 2) * 8)) {
				quit = 1;
				choice = -1;
				continue;
			}

			/* Simulate enter key. */
			key = 13;
			choice = (mregs.x.dx / 8 - y + 1);
		}
		else if (key < 256) {
			for(f = 1; f <= nitems; f++)
			if ((menu[f - 1].hotkey) && (tolower(key) ==
				(tolower(menu[f - 1].item[
					menu[f - 1].hotkey - 1]))))
			{
				choice = f;
				quit = 1;
			}
		}
		switch (key) {
			/* ENTER key. */
			case 13:
				quit = 1;
				break;

			/* ESC key. */
			case 27:
				quit = 1;
				choice = -1;
				break;

			/* UP arrow. */
			case 328:
				dirty = 1;
				do {
					choice--;
					if (!choice) choice = nitems;
				} while (!strcmp(menu[choice - 1].item, ""));
				break;

			/* LEFT arrow. */
			case 331:
				quit = 1;
				choice = -2;
				break;		/* Pressed left. */

			/* RIGHT arrow. */
			case 333:
				quit = 1;
				choice = -3;
				break;		/* Pressed right. */

			/* DOWN arrow. */
			case 336:
				dirty = 1;
				do {
					choice++;
					if (choice > nitems) choice = 1;
				} while (!strcmp(menu[choice - 1].item, ""));
				break;

			/* Alt-F pressed. */
			case 289:
				quit = 1;
				choice = 289;
				break;

			/* Alt-E pressed. */
			case 274:
				quit = 1;
				choice = 274;
				break;

			/* Alt-S pressed. */
			case 287:
				quit = 1;
				choice = 287;
				break;

			/* Alt-O pressed. */
			case 280:
				quit = 1;
				choice = 280;
				break;

			/* Alt-W pressed. */
			case 273:
				quit = 1;
				choice = 273;
				break;

			/* Alt-H pressed. */
			case 291:
				quit = 1;
				choice = 291;
				break;

		}
	}

	/* Restore screen. */
	movedata(FP_SEG(scrnbuf), FP_OFF(scrnbuf), _dos_ds, video_base, 4000);
	gotoxy(curx, cury);
	if (win -> insert) _setcursortype(1);
	else _setcursortype(1);
	return (choice);
}

int filemenu()
{
	int choice;
	gotoxy(4, 2);
	textcolor(pref.menubarcolor);
	textbackground(pref.menubarbkcolor);
	cprintf(" File ");
	choice = pulldown(file_menu, 4, 3, 20);
	mainmenubar();
	return (choice);
}

int editmenu()
{
	int choice;
	gotoxy(11, 2);
	textcolor(pref.menubarcolor);
	textbackground(pref.menubarbkcolor);
	cprintf(" Edit ");
	choice = pulldown(edit_menu, 11, 3, 26);
	mainmenubar();
	return (choice);
}

int searchmenu()
{
	int choice;
	gotoxy(18, 2);
	textcolor(pref.menubarcolor);
	textbackground(pref.menubarbkcolor);
	cprintf(" Search ");
	choice = pulldown(search_menu, 18, 3, 26);
	mainmenubar();
	return (choice);
}

int optionsmenu()
{
	int choice;
	gotoxy(27, 2);
	textcolor(pref.menubarcolor);
	textbackground(pref.menubarbkcolor);
	cprintf(" Options ");
	choice = pulldown(options_menu, 27, 3, 20);
	mainmenubar();
	return (choice);
}

int windowmenu()
{
	int choice;
	gotoxy(38, 2);
	textcolor(pref.menubarcolor);
	textbackground(pref.menubarbkcolor);
	cprintf(" Window ");
	choice = pulldown(window_menu, 38, 3, 26);
	mainmenubar();
	return (choice);
}

int helpmenu()
{
	int choice;
	gotoxy(71, 2);
	textcolor(pref.menubarcolor);
	textbackground(pref.menubarbkcolor);
	cprintf(" Help ");
	choice = pulldown(help_menu, 56, 3, 20);
	mainmenubar();
	return (choice);
}