/*
 * BUSES.CPP - Contains BUSES unctions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _BUSES_CC_

#include "buses.h"

int errflag = 0;
FILE *fp;
char cmdline[20];

extern "C" int pentium();

// Write any string to the file and check for successfulness.
void writestring(const char *string)
{
 if (fprintf(fp, "%s", string) == EOF) {
    errflag = 2;
    checkerrors();
 }
}

int sysinfo()
{
 char output[256];
 char *buses = (char *)MK_FP(0xf000, 0xffd9);
 char primary_bus[20] = "ISA";
 int i;
 union REGS regs;
 struct SREGS segs;
 int pci = 0, mca = 0, usb = 0, isa = 0, agp = 0,
	vlb = 0, eisa = 0, pcmcia = 0;

 // Create output file.
 if ((fp = fopen("buses.txt", "w")) == NULL) {
    errflag = 1;
    checkerrors();
 }

 writestring("\nCPU BUSES :\n\n");

 // Check ROM table for Microchannel instead of ISA.
 regs.h.ah = 0xc0;
 int86x(0x15, &regs, &regs, &segs);
 if (!(regs.x.flags & 1)) {
    if ((peek(segs.es, regs.x.bx) >= 4) &&
       (peekb(segs.es, regs.x.bx + 5) & 2)) {
	// Primary bus is MCA.
	strcpy(primary_bus, "MCA");
	mca ++;
       }
    else {
	if (!strnicmp(buses, "EISA", 4)) eisa++;
	else isa++;
    }
 }

 // Get buses information in ROM BIOS.
 if ((!strnicmp(buses, "MCA", 3)) && (!mca)) mca++;
 if ((!strnicmp(buses, "ISA", 3)) && (!isa)) isa++;
 if (!strnicmp(buses, "EISA", 4)) eisa++;
 if (!strnicmp(buses, "VLB", 3)) vlb++;
 if (!strnicmp(buses, "PCMCIA", 6)) pcmcia++;
 if (!strnicmp(buses, "PCI", 3)) pci++;
 if (!strnicmp(buses, "USB", 3)) usb++;
 if (!strnicmp(buses, "AGP", 3)) agp++;

 // Write Primary bus type.
 sprintf(output, "\tMCA Bus Present instead of ISA         : %s\n",
		 (!strnicmp(primary_bus, "MCA", 3)) ? "Yes" : "No");
 writestring(output);

 // Write out detected buses.
 sprintf(output, "\tMCA Bus Present                        : %s\n",
		(mca) ? "Yes" : "No");
 writestring(output);

 sprintf(output, "\tISA Bus Present                        : %s\n",
		(isa) ? "Yes" : "No");
 writestring(output);

 sprintf(output, "\tEISA Bus Present                       : %s\n",
		(eisa) ? "Yes" : "No");
 writestring(output);

 if (vlb) {
	strcpy(output, "\tVESA-VL Bus Present                    : Yes\n");
	writestring(output);
 }

 if (pcmcia) {
	strcpy(output, "\tPCMCIA Bus Present                     : Yes\n");
	writestring(output);
 }

 if (pci) {
	strcpy(output, "\tPCI Bus Present                        : Yes\n");
	writestring(output);
 }

 if (usb) {
	strcpy(output, "\tUSB Bus Present                        : Yes\n");
	writestring(output);
 }

 if (agp) {
	strcpy(output, "\tAGP Bus Present                        : Yes\n");
	writestring(output);
 }

 // Check for PCI/AGP bus.
 regs.x.ax = 0xb101;
 int86(0x1a, &regs, &regs);
 asm {
	MOV	AX, 0B101H
	INT	1AH
	DB	66H, 81H, 0FAH	// CMP EDX, 20494350
	DD	20494350H
	JNZ	label1
 }
 if ((!(regs.x.flags & 1)) && (!regs.h.ah)) {
    // Write number of buses present.
    if ((!pci) && (!agp)) {
	strcpy(output, "\tPCI/AGP Bus Present                    : Yes\n");
	writestring(output);
    }
    sprintf(output, "\tNumber of PCI/AGP Buses                : %d\n",
		    regs.h.cl + 1);
    writestring(output);
    sprintf(output, "\tPCI/AGP Bus version                    : %X.%02X\n",
		    regs.h.bh, regs.h.bl);
    writestring(output);

    // Check for USB bus.
    for(i = 0;;i++)
    if (!check_usb(i)) break;
    if (i) {
       if (!usb) {
	strcpy(output, "\tUniversal Serial Bus Present           : Yes\n");
	writestring(output);
       }
       sprintf(output, "\tNumber of USB Buses present            : %d\n", i);
       writestring(output);
    }

    // Check PCMCIA.
label1:
    if ((!pcmcia) && (pentium())) {
	regs.h.ah = 0x80;
	int86(0x1a, &regs, &regs);
	if ((!regs.x.cflag) && (regs.x.cx == 0x5353)) {
		pcmcia = 1;
		strcpy(output, "\tPCMCIA Bus Present                     : Yes\n");
		writestring(output);
		sprintf(output, "\tNumber of PCMCIA adapters              : %d\n",
			regs.h.al);
		writestring(output);
		regs.h.ah = 0x83;
		segread(&segs);
		int86x(0x1a, &regs, &regs, &segs);
		sprintf(output, "\tPCMCIA Socket services version         : %X.%X\n",
			regs.x.ax, regs.x.bx);
		writestring(output);
		sprintf(output, "\tPCMCIA Inplementor description         : %s",
			(char *)MK_FP(segs.ds, regs.x.si));
	}
    }
 }

 fclose(fp);
 return 0;
}

void open_stderr()
{
	fclose(stdout);
	fclose(&_streams[2]);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if (fopen("nul", "wb") == NULL) exit(0x7f);
	if ((stderr = fopen("errors.$$$", "ab")) == NULL) exit(0x7f);
}

void get_cmdline()
{
 if ((fp = fopen("cmdline.$$$", "rb")) == NULL) exit (0x7f);

 if (fscanf(fp, "%s", cmdline) != 1) {
		fclose(fp);
		exit (0x7f);
 }

 fclose(fp);
 unlink("cmdline.$$$");

}

#pragma argsused

// The main function.
int main(int argc, char **argv)
{
 open_stderr();
 get_cmdline();

 if (!strcmp(cmdline, "sysinfo")) return (sysinfo());

 return 0;
}
