/*
 * EXTERNAL.H - Contains external functions.
 * Copyright (C) 1998, 1999 Prashant TR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING.TR for more details.
*/

// ID for this file.
#define _EXTERNAL_H_

// External variables.
#ifndef _PNP_CC_

extern int errflag;

#endif

#ifdef stderr

#undef stderr

#ifdef _PNP_CC_

FILE *stderr;

#else

extern FILE *stderr;

#endif

#endif

// PNP structure.
typedef struct _PNP_tag {
	char 		signature[4];
	unsigned char 	version;
	char		misc[8];
	unsigned short	(*pnp_entry_point)(...);
	unsigned short	protected_mode_entry_offset;
	char		misc_1[8];
	unsigned short	bios_selector;
	char 		misc_3[4];
	unsigned short	isa_read_port;
	char 		misc_4[8];
} PNP;

// Function definitions.
void newhandler();
void checkerrors();
int pinrun(const char *, const char *);
FILE *pinseek(const char *, const char *);