//----------------------------------------------------------------------------
//
// AATEXT 1.0 beta - Antialiased text fonts for Allegro
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
//
// Simple comparison between antialiased and non-antialiased text output
//
// Written by Doug Eleveld
//
//----------------------------------------------------------------------------
#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <stream.h>
#include "allegro.h"
#include "aatext.h"

// General RGB map speeds up almost all 256 color stuff
RGB_MAP rgb_table;

//----------------------------------------------------------------------------
int main (void)
   {
   cout << "Simple example of antialiased text output.\n";
   cout << "Press any key...\n";
   getch();

   // Setup Allegro and some internal stuff
	allegro_init();

   // Try and set the graphic mode
   set_color_depth(8);
   if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0)!=0)
      {
      // Warn that the mode did not work
      set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
      printf("Could not set graphics mode.\n");
      return 1;
      }

   // Load the font data in
   FONT* thefont = load_font("font.pcx");
   if(thefont == NULL)
      {
      set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
      cerr << "Could not load font data from font.pcx\n";
      return 1;
      }

   // Create the color maps and RGB table for the antialiased fonts
   PALETTE pal;
   generate_332_palette(pal);
   set_palette(pal);

   // Make sure that we have black as colour zero
   RGB black = {0,0,0};
   set_color(0,&black);

   create_rgb_table(&rgb_table,pal,NULL);
   rgb_map = &rgb_table;

   // Initialise the antialiased palette
   antialias_init(pal);

   // Draw background
   clear_to_color(screen,makecol(0,0,0));
   text_mode(0);

   textout(screen,thefont,"This text IS NOT antialiased...",10,10,makecol(255,255,255));
   aatextout(screen,thefont,"This text IS antialiased...", 10,40,makecol(255,255,255));

   aatextout(screen,thefont,"Press any key to exit.", 10,100,makecol(255,255,255));

   getch();

   // Close up shop and exit
   destroy_font(thefont);
   antialias_exit();
   allegro_exit();
   }
//----------------------------------------------------------------------------

