indexing
    description    : "Allegro con Eiffel: timer objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : timer
    date_started   : "30th January, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class TIMER


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


creation { ACE }
    make


------------------------------------------------------ Creation features
feature { ACE }

    make(timer_index : INTEGER) is
    -- Create a new timer with the specified index
    require
        ace_initialised      : info.ace_initialised
        timer_index_is_valid : timer_index >= 1 and timer_index <= 3
    local
        i : INTEGER
    do
        if not info.timer_initialised then
            c_inline_c("_i=install_timer();")
            init_success := i = 0
            info.set_timer_flag(init_success)
        else
            init_success := info.timer_initialised
        end  -- if

        index   := timer_index
        running := FALSE
    ensure
        timer_initialised : info.timer_initialised and init_success
        timer_not_running : not running
    end  -- feature make


------------------------------------------------------ Internal features
feature { NONE }

    -- What is the index of this timer?
    index : INTEGER


------------------------------------------------------ Timer features
feature { ANY }

    -- Is the timer currently running?
    running : BOOLEAN


    -- Success flag
    init_success : BOOLEAN


    start(milliseconds_per_tick : INTEGER) is
    -- Start the timer, at the specified rate
    require
        ace_initialised                : info.ace_initialised
        timer_initialised              : info.timer_initialised
        timer_not_running              : not running
        milliseconds_per_tick_is_valid : milliseconds_per_tick > 0
    local
        i : INTEGER
    do
        c_inline_c("_i=install_eiffel_timer(C->_index,a1);")

        running := i = 0
    ensure
        timer_running : running
    end  -- feature start


    stop is
    -- Stop the timer
    require
        ace_initialised   : info.ace_initialised
        timer_initialised : info.timer_initialised
        timer_running     : running
    do
        c_inline_c("remove_eiffel_timer(C->_index);")

        running := FALSE
    ensure
        timer_not_running : not running
    end  -- feature stop


    count : INTEGER is
    -- Return the current timer count
    require
        ace_initialised   : info.ace_initialised
        timer_initialised : info.timer_initialised
        timer_running     : running
    do
        c_inline_c("R=eiffel_counter[C->_index-1];")
    end  -- feature count


    delay(milliseconds : INTEGER) is
    -- Rest for the specified number of milliseconds
    require
        ace_initialised       : info.ace_initialised
        timer_initialised     : info.timer_initialised
        milliseconds_is_valid : milliseconds >= 0
    do
        c_inline_c("rest(a1);")
    end  -- feature delay


------------------------------------------------------ Class invariant
invariant

    index_is_valid : index >= 1 and index <= 3


end  -- class TIMER
