indexing
    description    : "Allegro con Eiffel: scancode objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : scancode
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class SCANCODE


creation { ANY }
    make


------------------------------------------------------ Creation features (ANY)
feature { ANY }

    -- The integer representation of a keyboard scancode
    code : INTEGER


    make(scancode : INTEGER) is
    -- Create a new scancode
    require
        scancode_is_valid : scancode >= 0 and scancode <= 127
    do
        code := scancode
    end  -- feature make


    is_action : BOOLEAN is
    -- Is this scancode an "action" key?
    do
        c_inline_c("R=eiffel_is_action(C->_code);")
    end  -- feature is_action


    is_modifier : BOOLEAN is
    -- Is this scancode a "modifier" key?
    do
        Result := not is_action
    end  -- feature is_modifier


    to_character : CHARACTER is
    -- Return the character representation of this scancode
    require
        is_action_key : is_action
    do
        c_inline_c("R=key_ascii_table[C->_code];")
    end  -- feature to_character


    to_shifted_character : CHARACTER is
    -- Return the shifted character representation of this scancode
    require
        is_action_key : is_action
    do
        c_inline_c("R=key_shift_table[C->_code];")
    end  -- feature to_shifted_character


------------------------------------------------------ Class invariant
invariant

    code_is_valid        : code >= 0 and code <= 127
    is_action_is_valid   : is_action   implies not is_modifier
    is_modifier_is_valid : is_modifier implies not is_action


end  -- class SCANCODE
