indexing
    description    : "Allegro con Eiffel: keyboard_test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : keyboard_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class KEYBOARD_TEST


inherit
    ACE  -- implementation inheritance
    end  -- inherit ACE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    -- Tester creation feature
    make is
    local
        key      : KEYPRESS
        scancode : SCANCODE
    do

--------------------------------------------------- ACE initialisation

        -- Initialise ACE
        if not init.success then
            crash_with_message("ACE initialisation error: ")
        end  -- if

--------------------------------------------------- Test keyboard routines

        -- Loop while no keys are pressed
        from
        until
            keyboard.input_waiting
        loop
            io.flush
            io.put_string("%NPress any key to terminate loop...")
        end  -- from

        -- Clear the keyboard buffer
        if keyboard.input_waiting then
            keyboard.clear
        end  -- if

        -- Do some input tests
        io.put_string("%NType something (ESC to exit): ")

        from
        until
            key.character.code = escape
        loop
            io.flush
            key      := keyboard.read
            scancode := key.scancode

            if key.character.is_letter_or_digit or
               key.character = ' '              then
                io.put_character(key.character)
            else
                if key.character = '%N' or
                   key.character = '%R' then
                    io.put_character('%N')
                end  -- if

                if scancode.code = info.scancode_escape then
                    io.put_string(" ESC")
                end  -- if

                if scancode.code = info.scancode_f1 then
                    io.put_string(" F1")
                end  -- if

                if scancode.code = info.scancode_tab then
                    io.put_string(" TAB")
                end  -- if
            end  -- if
        end  -- from
    end  -- feature make

------------------------------------------------------ Internal features
feature { NONE }

    -- The ascii code of ESC
    escape : INTEGER is 27


    -- The ascii code of ENTER
    enter : INTEGER is 13


    -- The ascii code of the spacebar
    space : INTEGER is 32


    -- The number of iterations of each test to perform
    num_iterations : INTEGER is 1024


    wait_for_key(message : STRING) is
    -- Display the message then wait for a key
    require
        message_is_valid : message /= Void
    do
        io.put_string(message)
        io.put_string("%NPress ENTER...")
        io.read_character
    end  -- feature wait_for_key


    crash_with_message(message : STRING) is
    -- Display the message then the allegro error message then crash
    require
        message_is_valid : message /= Void
    do
       io.put_character('%N')
       io.put_string(message)
       io.put_string(info.error_description)
       io.put_character('%N')
       crash
    end  -- feature crash_with_message


end  -- class KEYBOARD_TEST
