#ifndef DIALOG_

class dialog
{
   /*
    * The base class of all DIALOG- objects.
    * It has the same members, which are explained in the orginal DIALOG struct
    * of Allegro (see there).
    * The constructor needs a char* although not all derived classes need one.
    * I made this in order to get a better container template (see below).
    * The base class dialog will never be created, but all objects are derived from
    * it.
    * 
    * Also there are methods for handling the dialogs:
    * 
    * import()    
    *             reads the dialog of the specific mdk-file format
    * export()    
    *             saves the dialog in the specific mdk-file format
    * save()      
    *             saves the dialog in the C-style Allegro - Output file format
    * THIS(xm,ym) 
    *             checks if the point (xm,ym) is in the Dialog
    *
    * inside(xi,yi,wi,hi)
    *             checks if the area (xi,yi,wi,hi) is in the dialog
    *
    * copy(dialog& temp)
    *             copies the dialog temp into the current dialog
    * 
    * help() 
    *              only declared. Used in the derivats to call the specific
    *              help text (mostly the orginal Allegro text)
    * show_prop()
    *              showes the properties of the dialog, this means with this
    *              dialog you can display and modify all base members of a 
    *              dialog. Usually this envoked by a More-Button in MDK.
    *
    * char* input() 
    *              This function is not implemented on all dialog-derivats,
    *              but is thought for dialog-objects like the Listbox,
    *              where you can define and create the list items.
    * 
    * activate_func(BITMAP b=gui_area, int fgd=-1, int bg=0)
    *              Draws the dialog.
 *              MDK draws the dialog itself, this meant I had to copy 
 *              the drawing routine from the Allegro Source (GUI.C) into 
 *              there. THis might be a disadvantage, because if the 
 *              drawings are changed in a newer verion, I' ll have to 
 *              update it. But the advantage is that it's more flexible,
 *              and the whole program works more like a drawing program.
 *
 * 
 * */
 public :
   
   int x,y,w,h,fg,bg,d1,d2;
   String name;
   String key;
   String flags;
   String dp;
   int GuiNumber;
   int LCounter;
   char* ask_for_input;
   dialog(char* dummy);
   ~dialog();
   void export();
   void import();
   int save(int line_nr);
   int THIS(int xm,int ym);
   int inside(int xi,int yi,int wi,int hi);
   void copy (dialog& temp, int& xc, int& yc,int NoDeltaMove=0);
   void help();
   int show_prop(int sfg,int sbg);
   void write_defines(String DialogName,int DialogID);
   pos();
   char* input();
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   int key_convert();
   int flags_convert();
   int saveColor32(int line_nr,String DialogName);
   virtual void SaveInit();
   void ListCounter(int LC);
};

/*
 * 
 * The next classes explain themselves, the names are identical.
 * 
 * */

class gui_d_clear_proc: public dialog
{
 public:
   int c;
   gui_d_clear_proc(char* dummy);
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void help();
};

class gui_d_shadow_box_proc: public dialog
{
 public:
   gui_d_shadow_box_proc(char* dummy);
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void help();
   
};

class gui_d_box_proc: public dialog
{
 public:
   gui_d_box_proc(char* dummy);
   void help();
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
};





class gui_d_text_proc:public dialog
/*
 * This class is the base class of all text-dialog objects.
 * These are all dialog objects which contain a data in the dp 
 * field. 
 * The additional member char* s always contains text. For 
 * pure text objects s and dp is the same, but s was necessary 
 * for the textout-function.
 * */
{
 public:
   char s[256];
   int centre;
   int TextID;
 public:
   gui_d_text_proc( char* text);
   virtual void help();
   void rename(char* text);
   copy(gui_d_text_proc& from,int& xc, int& yc,int NoDeltaMove=0);
   void export();
   void import();
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void position();
   char* input();
   int save(int line_nr);
   void save_items(int line_nr,String DialogName);
   };




class gui_d_ctext_proc:public gui_d_text_proc
{
 public:
   gui_d_ctext_proc( char* text);
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void help();
};


class gui_d_textbox_proc:public gui_d_text_proc
{
 public:
   gui_d_textbox_proc(char* text);
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void help();
};





class gui_d_edit_proc:public gui_d_text_proc
{
 public:
   gui_d_edit_proc( char* pointer);
   void help();
   void export();
   void import();
   void default_string(char* zu);
   void save_string();
   void save(int line_nr);
   char* input();
   void rename(char* text);
     
};




class gui_d_button_proc:public gui_d_text_proc
{
 public:
   gui_d_button_proc( char* text);
   void help();
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void write_defines(String DialogName,int DialogID);
   void save(int line_nr);
};


class gui_d_radio_proc:public gui_d_text_proc
{
 public:
   gui_d_radio_proc( char* text);
   void help();
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   char* input();
   void write_defines(String DialogName,int DialogID);
   void save(int line_nr);
};






class gui_d_check_button_proc:public gui_d_text_proc
{
 public:
   gui_d_check_button_proc( char* text);
   void help();
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void write_defines(String DialogName,int DialogID);
};




class gui_d_listbox_proc:public gui_d_text_proc
/* 
 * The ListboxObject has addtionally a String* for holding the Strings in the
 * Listboxes
 * 
 * The draw style of Listboxes is (still) Allegro 2.1 ...
 * 
 * */
{
   
 public:
   int mxs;
   String* temps;
   int size;
   char* data(int index);
   gui_d_listbox_proc( char* text);
   ~gui_d_listbox_proc();
   void help();
   void save_items(int line_nr,String DialogName);
   void export();
   void import();
	void copy(gui_d_listbox_proc& from,int& xc, int& yc,int NoDeltaMove=0);
   char* input ();
   int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
   void write_defines(String DialogName,int DialogID);
   void save(int line_nr);
};




class gui_d_keyboard_proc: public gui_d_text_proc
     {
		String d1_ID;
		String d2_ID;
		int CTRL_key;
		int d1_key1;
		int d2_key1;
		int d1_key2;
		int d2_key2;
		int ASCII;
	public:
   	gui_d_keyboard_proc(char* text,String keyt);
      int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
		void help();
    	void save(int linenr);
		void export();
		String import();
		void copy(gui_d_keyboard_proc &from);
      char* input();
     };


class MainMenu:public dialog
/* 
 * Dialog Menu, necessary for menu handling.
 * Every menu will be started from the DIALOG, so the base MENU has 
 * to be called by a d_menu_proc (see Allegro-text)
 *
 * */
    {
     public:
     MainMenu(String pointer);
     int activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0);
	  };



#define DIALOG_
#endif
