//////////////////////////////////////////////////////////////////////////////
// In this file must be all the things the coder might need to use in his program
//
//
// Coded by Frodo The Ring Bearer    Copyright 1998, 1999
//////////////////////////////////////////////////////////////////////////////
#ifndef MDLIB_H
#define MDLIB_H

#include <allegro.h>

#ifdef __cplusplus
extern "C" {
#endif


#define LIBVERSION    0.45           // current version



// type of files the lib can handle
enum { TYPE_UNKNOWN, TYPE_MDLQ1, TYPE_MDLQ2, TYPE_MDLQ3, TYPE_MDLHL, TYPE_3DS, TYPE_ASC };

// possible modes of cameras
#define CAMERA_OFF			0  // not working
#define CAMERA_FIXED			1  // no movement and no rotation
#define CAMERA_ROTATES			2  // only rotation
#define CAMERA_MOVES			3  // only movement
#define CAMERA_FREE			4  // rotation and movement
#define CAMERA_CHASE			5  // chases a model
#define CAMERA_FOLLOW			6  // no movement but rotates to follow model
#define CAMERA_CYCLE			7  // no movement and no rotation but follows model
#define CAMERA_INMODEL			8  // camera is in model's eyes
#define CAMERA_ELASTIC_CHASE	        9  // rubber band chase camera

#define MAX_CAMERAS			20 // this should be enough!

#ifndef scalar_t
typedef float scalar_t;
#endif scalar_t
#ifndef u_char
typedef unsigned char u_char;
#endif u_char

typedef struct
{
    float x __attribute__ ((packed));
    float y __attribute__ ((packed));
    float z __attribute__ ((packed));
} vec3_t    __attribute__ ((packed));


//////////////////////////////////////////////////////////////////////////////
// Quake 1      TODO: __attribute__ packed to all of this!
//////////////////////////////////////////////////////////////////////////////
typedef struct
{
  long id;                     // 0x4F504449 = "IDPO" for IDPOLYGON
  long version;                // Version = 6
  vec3_t scale;                // Model scale factors.
  vec3_t origin;               // Model origin.
  scalar_t radius;             // Model bounding radius.
  vec3_t offsets;              // Eye position (useless?)
  long numskins ;              // the number of skin textures
  long skinwidth;              // Width of skin texture
                               //           must be multiple of 8
  long skinheight;             // Height of skin texture
                               //           must be multiple of 8
  long numverts;               // Number of vertices
  long numtris;                // Number of triangles surfaces
  long numframes;              // Number of frames
  long synctype;               // 0= synchron, 1= random
  long flags;                  // 0 (see Alias models)
  scalar_t size;               // average size of triangles
} q1mdlheader_t __attribute__ ((packed));
//The size of this header is 0x54 bytes (84).

typedef struct
{
	long group;         // value = 0
	unsigned char *skin;// [skinwidth*skinheight] the skin picture
} q1skin_t __attribute__ ((packed));

typedef struct
{
  long group;                  // value = 1
  long nb;                     // number of pictures in group
//  float time[nb];              // time values, for each picture
//  u_char skin[nb][skinwidth*skinheight]; // the pictures
} q1skingroup_t __attribute__ ((packed));

typedef struct
{
	long onseam;                 // 0 or 0x20
	long s;                      // position, horizontally
                                //  in range [0,skinwidth[
	long t;                      // position, vertically
                                //  in range [0,skinheight[
} q1stvert_t __attribute__ ((packed));

typedef struct
{
	long facesfront;             // boolean
	long vertices[3];            // Index of 3 triangle vertices
                                // in range [0,numverts[
} q1itriangle_t __attribute__ ((packed));

typedef struct
{
	u_char packedposition[3];    // X,Y,Z coordinate, packed on 0-255
	u_char lightnormalindex;     // index of the vertex normal
} q1trivertx_t __attribute__ ((packed));

typedef struct
{
    long type;                   // 0 for one simple frame and != 0 for multiframes
    q1trivertx_t min;              // minimum values of X,Y,Z
    q1trivertx_t max;              // maximum values of X,Y,Z
    char name[16];               // name of frame
    q1trivertx_t *frame;           // numverts, array of vertices

    V3D_f *pos;                  // vertice positions in allegro coord
    V3D_f *normvect;             // vectors normal to the triangles (numtris)
} q1simpleframe_t;


typedef struct
{
    q1mdlheader_t header;
    q1skin_t *oneskin;          // numskins == 1
    q1skingroup_t *multiskins;  // numskins != 1
    q1stvert_t *vertices;       // numverts
    q1itriangle_t *triangles;   // numtris
    q1simpleframe_t *frames;    // numframes

    // allegro stuff
    V3D_f *rpos;              // rotated and translated positions
    float *dist2;             // array of distance to triangle midpoints^2
    long *trigorder;          // array for the order of the triangles
    char *drawtrig;           // array to determine if a triangle is front or back
    BITMAP *tex;              // current texture
    float xscale;             // scaling factors for textures
    float yscale;
    long numvistris;          // number of visible triangles

} q1mdl_t;



//////////////////////////////////////////////////////////////////////////////
// Quake 2
//////////////////////////////////////////////////////////////////////////////
#define	MAX_TRIANGLES	4096
#define MAX_VERTS	2048
#define MAX_FRAMES	512
#define MAX_MD2SKINS	32
#define	MAX_SKINNAME	64

typedef struct
{
    short s    __attribute__ ((packed));
    short t    __attribute__ ((packed));
} q2dstvert_t  __attribute__ ((packed));

typedef struct
{
   double x __attribute__ ((packed));
   double y __attribute__ ((packed));
   double z __attribute__ ((packed));
} POINT_3D  __attribute__ ((packed));

typedef struct
{
//    POINT_3D *tris __attribute__ ((packed));
    V3D_f *tris __attribute__ ((packed));
} q2framelist_t __attribute__ ((packed));

typedef struct
{
    short index_xyz[3] __attribute__ ((packed));
    short index_st[3]  __attribute__ ((packed));
} q2dtriangle_t        __attribute__ ((packed));

typedef struct
{
    unsigned char v[3] __attribute__ ((packed)); // scaled byte to fit in frame mins/maxs
    unsigned char lightnormalindex __attribute__ ((packed));
} q2dtrivertx_t        __attribute__ ((packed));

typedef struct
{
    float scale[3]         __attribute__ ((packed));   // multiply byte verts by this
    float translate[3]     __attribute__ ((packed));   // then add this
    char name[16]          __attribute__ ((packed));   // frame name from grabbing
    q2dtrivertx_t verts[1] __attribute__ ((packed));   // variable sized
} q2daliasframe_t          __attribute__ ((packed));


// the glcmd format:
// a positive integer starts a tristrip command, followed by that many
// vertex structures.
// a negative integer starts a trifan command, followed by -x vertexes
// a zero indicates the end of the command list.
// a vertex consists of a floating point s, a floating point t,
// and an integer vertex index.

typedef struct
{
    int ident      __attribute__ ((packed));
    int version    __attribute__ ((packed));

    int skinwidth  __attribute__ ((packed));
    int skinheight __attribute__ ((packed));
    int framesize  __attribute__ ((packed)); // byte size of each frame

    int num_skins  __attribute__ ((packed));
    int num_xyz    __attribute__ ((packed));
    int num_st     __attribute__ ((packed)); // greater than num_xyz for seams
    int num_tris   __attribute__ ((packed));
    int num_glcmds __attribute__ ((packed)); // dwords in strip/fan command list
    int num_frames __attribute__ ((packed));

    int ofs_skins  __attribute__ ((packed)); // each skin is a MAX_SKINNAME string
    int ofs_st     __attribute__ ((packed)); // byte offset from start for stverts
    int ofs_tris   __attribute__ ((packed)); // offset for dtriangles
    int ofs_frames __attribute__ ((packed)); // offset for first frame
    int ofs_glcmds __attribute__ ((packed));
    int ofs_end    __attribute__ ((packed)); // end of file
} q2dmdl_t         __attribute__ ((packed));

// Q2 model struct
typedef struct
{
    q2dmdl_t header;

    char skins[MAX_MD2SKINS][MAX_SKINNAME];
    q2dstvert_t *texture_st;
    q2dtriangle_t *tri_index;
    q2framelist_t *framelist;
    long *commands;
    V3D_f *points;                  // vertice positions in allegro coord

    char model_pathname[255];
    char model_name[255];
    char skin_name[255];

    // allegro stuff
    V3D_f *rpos;              // rotated and translated positions
    float *dist2;             // array of distance to triangle midpoints^2
    long *trigorder;          // array for the order of the triangles
    char *drawtrig;           // array to determine if a triangle is front or back
    BITMAP *tex;              // current texture
    float xscale;             // scaling factors for textures
    float yscale;

} q2mdl_t;


//////////////////////////////////////////////////////////////////////////////
// Quake 3
//////////////////////////////////////////////////////////////////////////////
typedef struct {

} q3mdl_t;


typedef struct {

} hlmdl_t;

typedef struct {

} s3mdl_t;

//////////////////////////////////////////////////////////////////////////////
// ASC models
//////////////////////////////////////////////////////////////////////////////

typedef struct
{
    long vertices[3];         // Index of 3 triangle vertices

} asctrig_t;


typedef struct {
    char name[256];           // Name of the object
    long numverts;            // Number of vertices
    long numtris;             // Number of triangles surfaces
    V3D_f *pos;               // original positions
    V3D_f *rpos;              // rotated and translated positions
    asctrig_t *triangles;     // Array of triangles

    float *dist2;             // array of distance to triangle midpoints^2
    long *trigorder;          // array for the order of the triangles
    char *drawtrig;           // array to determine if a triangle is front or back

} ascmdl_t;


//////////////////////////////////////////////////////////////////////////////
// Generic 3D model
//////////////////////////////////////////////////////////////////////////////
// this must leave eventually
#define XTEX_CONV		512
#define YTEX_CONV		512
#define Z_CLIP			10



// type of files the lib can handle
#define IDQ1		0x4F504449	// IDPO
#define IDQ2		0x32504449	// IDP2
#define IDQ3		0x33504449	// IDP3
#define IDHL		0x54534449	// IDST or IDSQ ?
#define IDASC		0x656D614E	// "Named Object" first 4 chars
#define ID3DS           0x00004D4D	// .3DS start


typedef struct {
    unsigned char type;
    q1mdl_t *q1mdl;
    q2mdl_t *q2mdl;
    q3mdl_t *q3mdl;
    hlmdl_t *hlmdl;
    s3mdl_t *s3dmdl;
    ascmdl_t *ascmdl;

    long frameidx;
    long numframes;           // total number of frames
} mdl_t;


// a camera
typedef struct
{
    char mode;           // see CAMERA_?????
    float x;             // position of the camera
    float y;
    float z;
    float head;          // heading of the camera
    float pitch;         // pitch
    float roll;          // roll
    float headmax;       // can it look in all directions?
    float headmin;
    float rollmax;
    float rollmin;
    float pitchmax;
    float pitchmin;
    float zoom;          // 1 for normal, others for +/-

} camera_t;


//////////////////////////////////////////////////////////////////////////////
//                          PAK file stuff
//////////////////////////////////////////////////////////////////////////////
typedef struct
{
    unsigned char magic[4] __attribute__ ((packed)); // Name of the new WAD format "PACK"
    long diroffset         __attribute__ ((packed)); // Position of WAD directory from start of file
    long dirsize           __attribute__ ((packed)); // Number of entries * 0x40 (64 char)
} pakheader_t              __attribute__ ((packed));

typedef struct
{
    // Name of the file, Unix style, with extension, 50 chars, padded with '\0'.
    unsigned char filename[56] __attribute__ ((packed));
    long offset                __attribute__ ((packed)); // Position of the entry in PACK file
    long size                  __attribute__ ((packed)); // Size of the entry in PACK file
} pakentry_t                   __attribute__ ((packed));


//////////////////////////////////////////////////////////////////////////////
//                          Function definition
//                 These are the functions for the lib API
//////////////////////////////////////////////////////////////////////////////
mdl_t MDLLoad( char *filename );
void MDLDrawPoints( BITMAP *dbuf, mdl_t *model );
void MDLDrawWireframe( BITMAP *dbuf, mdl_t *model );
void MDLDrawFlat( BITMAP *dbuf, mdl_t *model );
void MDLDrawFlatShade( BITMAP *dbuf, mdl_t *model );
void MDLDrawTexture( BITMAP *dbuf, mdl_t *model );
void MDLDrawGouradTexture( BITMAP *dbuf, mdl_t *model );
void MDLUpdateView( camera_t cam, mdl_t *model );
void MDLUpdateCamera( camera_t *cam );
void MDLDebug( mdl_t *model );
void MDLUnload( mdl_t *model );
camera_t CameraFixed(float x, float y, float z, float head, float pitch, float roll);

pakentry_t *PAKLoadDir(char *filename, long *num_files);
long PAKExtractFile(char *pakfilename, pakentry_t entry);
void PAKLoader(void);
char *PAKListBox(int index, int *list_size);


// Extra functions that might be usefull
void Mysort(float *list, long v[], long left, long right);
void Swapsort(long v[], long i, long j);
void PAKShowWAL(char *filename, BITMAP *dbuf);


#ifdef __cplusplus
}
#endif

#endif MDLIB_H
