// Stuff to handle Quake .PAK files
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "mdlib.h"

/*
typedef struct
{
    unsigned char magic[4]= "PACK";  // Name of the new WAD format
    long diroffset;                  // Position of WAD directory from start of file
    long dirsize;                    // Number of entries * 0x40 (64 char)
} pakheader_t;

typedef struct
{
    unsigned char filename[56];      // Name of the file, Unix style, with extension,
                                     // 56 chars, padded with '\0'.
    long offset;                     // Position of the entry in PACK file
    long size;                       // Size of the entry in PACK file
} pakentry_t;
*/

pakentry_t *curr_list; // list of entrys in the current pak file
long curr_files = 0;   // number of entrys in the pak file


// Loads a PAK file "filename"
// Stores the number of files in num_files and returns the directory entrys
pakentry_t *PAKLoadDir(char *filename, long *num_files)
{
    pakentry_t *filelist;
    FILE *pak_file;
    pakheader_t header;
    long i;

    pak_file = fopen(filename, "rb");

    fread( &header, sizeof(pakheader_t), 1, pak_file );
    if( header.magic[0] != 'P' || header.magic[1] != 'A' ||
        header.magic[2] != 'C' || header.magic[3] != 'K')
    {
        printf("PAKLoadDir(): %s is not a valid PAK file\n", filename);
        exit(1);
    }


    filelist = (pakentry_t *)malloc( header.dirsize );
    *num_files = header.dirsize/sizeof(pakentry_t);

    // search the dir in the pak
    fseek( pak_file, header.diroffset, SEEK_SET);

    // read the directory
    fread( filelist, sizeof(pakentry_t), *num_files, pak_file );

    // close file
    fclose(pak_file);

    // stuff for the PAKListBox()
    curr_list = filelist;
    curr_files = *num_files;

    return filelist;
}

// extract a file to the current directory
// return NULL if error
// Make shure to create the directorys before you call this!
long PAKExtractFile(char *pakfilename, pakentry_t entry)
{
    FILE *fp;
    FILE *pak_file;
    unsigned char *buffer;


    fp = fopen( strlwr(get_filename(entry.filename)), "wb");
    pak_file = fopen( pakfilename, "rb");

    buffer = (unsigned char *)malloc( entry.size*sizeof(unsigned char) );

    if(fp == NULL) printf("PAKExtractFile(): Error creating %s\n", get_filename(entry.filename));
    if(pak_file == NULL) printf("PAKExtractFile(): Error opening %s\n", pakfilename);
    if(buffer == NULL) printf("PAKExtractFile(): Not enough memory to extract %s\n", entry.filename);

    if( fp == NULL || pak_file == NULL || buffer == NULL) return NULL;

    fseek( pak_file, entry.offset, SEEK_SET );
    fread( buffer, sizeof(unsigned char), entry.size, pak_file );
    fwrite( buffer, sizeof(unsigned char), entry.size, fp );

    free( buffer );

    fclose( fp );
    fclose( pak_file );

    return 1;
}

// call a gui to handle the pak stuff
void PAKLoader(void)
{
    pakentry_t *list;
    long numfiles;
    long i;
    char pakname[256];


//    strcpy(pakname, "kjdfhkdjfhk");

//    file_select("Select a .PAK file", pakname, "PAK");
//    list = PAKLoadDir(pathname, &numfiles);
    list = PAKLoadDir("f:/quake2/baseq2/pak3.pak", &numfiles);

    for(i=0; i<numfiles; i++)
    {
        printf("filename = %s\n", list[i].filename);
//        PAKExtractFile("f:/quake2/baseq2/pak3.pak", list[i]);
    }

//    exit(1);
}


/* callback function to specify the contents of the listbox */
char *PAKListBox(int index, int *list_size)
{

   if (index < 0) {
      *list_size = curr_files;
      return NULL;
   }
   else
      return curr_list[index].filename;
}

// show .WAL texture file
void PAKShowWAL(char *filename, BITMAP *dbuf)
{
   long i,j,k;
   long width, height;
   FILE *fp;
   unsigned char *buffer;

   fp = fopen( filename, "rb");

   buffer = (unsigned char *)malloc( file_size(filename)*sizeof(unsigned char) );

   fseek( fp, 0x20, SEEK_SET );
   fread( &width, sizeof(long), 1, fp );
   fread( &height, sizeof(long), 1, fp );
   fseek( fp, 0x64, SEEK_SET );
   fread( buffer, sizeof(unsigned char), file_size(filename)-0x64, fp );

   k = 0;
   for(i=0; i<height; i++)
      for(j=0; j<width; j++)
      {
         putpixel(dbuf, j, i, buffer[k]);
         k++;
      }

   free(buffer);
   fclose( fp );

}
