/* lazy mans linker */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "pic.h"

int main(void)
{
    BITMAP *test, *test2;
    PALETTE pal;
    long s1, s2;
    int x, y;
    int r, g, b, d, c;

    allegro_init();
    set_color_depth(24);
    set_gfx_mode(GFX_SAFE, 640, 480, 0, 0);

    /* load picture */
    test = load_bitmap("test.bmp", pal);

    /* save pic */
    jpg_quality = MED_QUALITY;
    s1 = clock();
    save_bitmap_pic("test.tom", test, NULL);
    s1 = clock() - s1;

    /* load pic */
    s2 = clock();
    test2 = load_bitmap_pic("test.tom", NULL);
    s2 = clock() - s2;

/*    for (x = 0; x < test2->w; x++)
        for (y = 0; y < test2->h; y++) {
            c = getpixel(test, x, y);
            d = getpixel(test2, x, y);
            r = getr(c) - getr(d);
            g = getg(c) - getg(d);
            b = getb(c) - getb(d);
            if (r < 0) r = 0;
            if (g < 0) g = 0;
            if (b < 0) b = 0;
            putpixel(test2, x, y, makecol(r,g,b));
        }
*/
    blit(test2, screen, 0, 0, 0, 0, test2->w, test2->h);
//    blit(test2, screen, 0, 0, 0, test->h + 10,  test2->w, test2->h);

    while (!kbhit());

    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);

    printf("Saving  time: %f\n", (double)s1 / (double)CLK_TCK);
    printf("Loading time: %f\n", (double)s2 / (double)CLK_TCK);

    return 0;
}

END_OF_MAIN();
