// This demo programm shows how to use AutoDialer application
// Put your actual numbers to the predefined CMD1,CMD2,CMD3
// and uncomment lines 32,33 if needed
/*
dialer.c - demo programm of DZComm and Palantir
Copyright 1998 Dim Zegebart, Moscow Russia.
E-mail zager@post.comstar.ru
http://www.geocities.com/siliconvalley/pines/7817
Tel. in Moscow (095)9560389
Fax. in Moscow (095)9563540
*/

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <palantir.h>

#define CMD1 "atdt92349696"
//#define CMD2 "atdt92306002"
//#define CMD3 "atdt99569022"

//--------------------- APP POLIANKA HANDLER -----------------------
int modem_hnd(a_message code,int p1,int p2)
{
  dz_app *app=cur_app;

  switch(code)
   { case APP_START :
      device_client_task_add(com2,app,READ);
      printf("\n");
      comm_port_dialstring_add(com2,app,CMD1);
//      comm_port_dialstring_add(com2,app,CMD2);
//      comm_port_dialstring_add(com2,app,CMD3);

      app_msg_put(adial_app,E_DIALER_START,0,(int)com2);
      break;
     case E_DIALER_FINISH :
      printf("\nFinished.\n");
//      app_msg_put(adialer_app,E_DIALER_START,0,(int)com2); //dial
      break;
     case E_DIALER_CONNECT :
      printf("%s : Connected %s\n",dstring_(p2)->call_command,(char*)p1);
      //you can do now communication on com2
      //we just dial next number if any.
      app_msg_put(adial_app,E_DIALER_CONTINUE,(int)app,(int)com2); //dial next number
      break;
     case H_COMM_IN :
      putch(p1);
      break;
     default :
      break;
   }
 return(1);
}

//----------------------------- CLOCK -------------------------
// just a clock
int prev_time;
int clock(void)
{ struct time now;
  int tmp;
  int x,y;

  real_time_clock(0,&now);
  if (prev_time==now.ti_sec) return(1);
  prev_time=now.ti_sec;
  lwp_disable;
  x=wherex();
  y=wherey();
  gotoxy(70,1);
  printf("%d:%d:%d   \n",now.ti_hour,now.ti_min,now.ti_sec);
  gotoxy(x,y);
  lwp_enable;
  return(1);
}


inline void dz_print_comm_err() {printf("%s",szDZCommErr);fflush(stdout);}

//---------------------- KEYBOARD HANDLER ----------------------

int keyboard_handler(a_message code,int p1,int p2)
{ int c=p1;

  switch(code)
   { case APP_START:
      break;
     case H_KEYBOARD :
       if (ctrl_(c,'Q'))
        { palantir_deinit();
          return(0);
        }
       comm_port_out(com2,ascii_(c));
       break;
     default:
      break;
   }
  return(1);
}

//------------------------- MAIN -----------------------

void main(void)
{ char s[255];
  dz_app *keyb_app;
#ifdef FORTIFY
Fortify_EnterScope();
#endif

  clrscr();

  if (palantir_init(DEV_KEYBOARD|DEV_COMMS)==FALSE) return;

  if (!autodialer_init())
   { printf("Error : autodialer_init\n");
     exit(0);
   }

  keyb_app=dz_app_new("KBD APP",16384,1,keyboard_handler);
  device_client_task_add(keyboard_device,keyb_app,READ);

//------------------ installing comm port 2
  if ((comm_port_init(_com2))==NULL)
   { dz_print_comm_err();
     exit(1);
   }
  comm_port_load_settings(com2,wd_cat(s,"ports.ini"));
  if (!comm_port_install_handler(com2))
   { dz_print_comm_err();
     exit(1);
   }
//handler for Polianka
  if (dz_app_new("DIALER",16384,1,modem_hnd)==NULL) exit(1);

//install clock
  idle_proc_add(clock);
//entering main loop

  lwp_wait_true(&exit_program);
#ifdef FORTIFY
Fortify_LeaveScope();
#endif
  return;
}

