/**[txh]********************************************************************

  Description:
  That's the first example for Palantir.
  The objetive is to collect keyboard events and show the ASCIIs on the
screen.

  Copyright (c) 1997 by Salvador Eduardo Tropea (SET)
  e-mail: salvador@inti.gov.ar or set-soft@usa.net

  Parts of this code:
  Copyright 1997 Dim Zegebart, Moscow Russia.
  e-mail zager@post.comstar.ru

  You can do anything with this code but:

1) You can't remove the copyright.
2) You can't blame me for any reason.

***************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <palantir.h>
#include <io.h>

#define LWPEnDisableUsed int tmp

/**[txh]********************************************************************

  Description:
  That's our Keyboard Handler application.
  It will receive messages from the keyboard.

***************************************************************************/

int keyboard_handler(a_message code,int p1,int p2)
{
 LWPEnDisableUsed;
 int c=p1;
 byte ch;

 // Uncomment this line to see what messages receive the application.
 // You'll see it gets APP_START(37), H_KEYBOARD(26) & APP_STOP(38).
 // Note: The values are for Palantir 0.3.
 //printf("Code : %d\n",code);

 // See if the message is from the keyboard
 if (code==H_KEYBOARD)
   {
    // If yes test if the key is CTRL+Q
    if (ctrl_(c,'Q'))
      { // In this case just stop all
       palantir_deinit();
       return 1;
      }

    ch=ascii_(c);
    // We must avoid problems with other tasks, so we can't write to the
    // screen at the same time that other task. For this reason we disable
    // the task switcher during it. This must be done for ALL the
    // no-reentrant things.
    lwp_disable;
    putch(ch);
    lwp_enable;
   }
 return 1;
}


int main(void)
{
 LWPEnDisableUsed;
 // That's the pointer to our keyboard application
 dz_app *keyb_app;

 clrscr();
 // Init Palantir using only the keyboard
 if (palantir_init(DEV_KEYBOARD)==FALSE)
   {
    printf("Error: Palantir initialization failed\n");
    return 1;
   }

 // Now create the new application with:
 // Name="KBD APP", Stack=4K, Priority=1 (1 time slice per turn) and this
 // application will process the messages through keyboard_handler
 keyb_app=dz_app_new("KBD APP",4096,1,keyboard_handler);
 // Now "connect" our keyboard application with the keyboard device
 device_client_task_add(keyboard_device,keyb_app,READ);

 lwp_disable;
 printf("Touch keyboard ...\nCtrl-Q to exit\n");
 lwp_enable;

 // Here the main process just waits until the exit_program variable becomes
 // true. This variable is true when we call palantir_deinit();
 // Note that this doesn't consume CPU so the "main" is sleeping all the time.
 lwp_wait_true(&exit_program);
 return 0;
}
