#include <allegro.h>
#include <salad.h>

int main(int argc, char *argv[])
{
//Contains the whole character pressed.
int character;
//Contains only the ascii part of the character.
uchar k, last=0;

//Install system.
allegro_init();
if(find_gfx_mode_size(53 * 8, 330))
   exitfail("Couldn't set graphics mode!");
salad_init();
install_keyboard();
textprintf(screen,font,0,0,255, "Press keys to test.");
textprintf(screen,font,0,10,255,"Press ESC to exit.");
set_color(0,  &brownlight);
set_color(255,&browndark);

//Loop till someone presses escape.
while(1){
	//Get a key from keyboard.
	character = readkey();
	if(character >> 8 == KEY_ESC)
		break;
	//Make it a char.
	k = character;
	clear(screen);
	textprintf(screen,font,0,0,255,  "Key: %c\n", k);
	textprintf(screen,font,0,10,255, "ascii: %d\n", (int)k);
	textprintf(screen,font,0,20,255, "chartoupper(): %c\n", chartoupper(k));
	textprintf(screen,font,0,30,255, "chartolower(): %c\n", chartolower(k));
	textprintf(screen,font,0,40,255, "charchangecase(): %c\n", charchangecase(k));
	textprintf(screen,font,0,50,255, "chartoupper_az(): %c\n", chartoupper_az(k));
	textprintf(screen,font,0,60,255, "chartolower_az(): %c\n", chartolower_az(k));
	textprintf(screen,font,0,70,255, "charchangecase_az(): %c\n", charchangecase_az(k));
	textprintf(screen,font,0,80,255, "charisalpha(): %d\n", charisalpha(k));
	textprintf(screen,font,0,90,255, "charisupper(): %d\n", charisupper(k));
	textprintf(screen,font,0,100,255,"charislower(): %d\n", charislower(k));
	textprintf(screen,font,0,110,255,"charisalpha_az(): %d\n", charisalpha_az(k));
	textprintf(screen,font,0,120,255,"charisupper_az(): %d\n", charisupper_az(k));
	textprintf(screen,font,0,130,255,"charislower_az(): %d\n", charislower_az(k));
	textprintf(screen,font,0,140,255,"charisdigit(): %d\n", charisdigit(k));
	textprintf(screen,font,0,150,255,"charisalnum(): %d\n", charisalnum(k));
	textprintf(screen,font,0,160,255,"charisuppernum(): %d\n", charisuppernum(k));
	textprintf(screen,font,0,170,255,"charislowernum(): %d\n", charislowernum(k));
	textprintf(screen,font,0,180,255,"charisalnum_az(): %d\n", charisalnum_az(k));
	textprintf(screen,font,0,190,255,"charisuppernum_az(): %d\n", charisuppernum_az(k));
	textprintf(screen,font,0,200,255,"charislowernum_az(): %d\n", charislowernum_az(k));
	textprintf(screen,font,0,210,255,"charisspace(): %d\n", charisspace(k));
	textprintf(screen,font,0,220,255,"charisempty(): %d\n", charisempty(k));
	textprintf(screen,font,0,230,255,"charissymbol(): %d\n", charissymbol(k));
	textprintf(screen,font,0,240,255,"charissymbol_az(): %d\n", charissymbol_az(k));
	textprintf(screen,font,0,250,255,"charisdigit_base() (base 2 = binary): %d\n", charisdigit_base(k,2));
	textprintf(screen,font,0,260,255,"charisdigit_base() (base 8 = octal): %d\n", charisdigit_base(k,8));
	textprintf(screen,font,0,270,255,"charisdigit_base() (base 10 = decimal): %d\n", charisdigit_base(k,10));
	textprintf(screen,font,0,280,255,"charisdigit_base() (base 16 = hex): %d\n", charisdigit_base(k,16));
	textprintf(screen,font,0,290,255,"charisdigit_base() (base 30 = crazy number system): %d\n", charisdigit_base(k,30));
	textprintf(screen,font,0,300,255,"char2digit(): %d", char2digit(k));
	textprintf(screen,font,0,310,255,"charicmp() (compare last with this): %d\n", charicmp(k,last));
	textprintf(screen,font,0,320,255,"charicmp_az() (compare last with this): %d\n", charicmp_az(k,last));
	//For the compare functions.
	last = k;
}

allegro_exit();
printf(
"Salad Example\n"
"Example of the character functions in Salad by Sven Sandberg.\n");

return 0;
}

