/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains different functions for changing filenames.

*/
#ifndef s_fname_h
#define s_fname_h

#include "s_defs.h"
//For TSTRLIST.
#include "s_string.h"
//For exists() in anotherfilename_*() macros.
#include <allegro.h>

#define _is_path_sep(ascii)         (((ascii)=='\\')||((ascii)=='/')||((ascii)==':'))
extern int is_path_sep(uchar ascii);
//ALLEGRO'S FUNCTION, CREDITS TO ALLEGRO!!!
	extern int getfilename_pos(uchar *path);
extern uchar *getfilename_d(uchar *path, uchar *de);
#define getfilename_new(path)       (getfilename_d(path,NULL))
#define getfilename_de(so,de)       (getfilename_d(so,de))
extern uchar *getextension_d(uchar *so, uchar *de);
extern uchar *getextension_s(uchar *filename, int allocmode);
#define getextension_new(path)         (getextension_d(path,NULL))
#define getextension_de(so,de)         (getextension_d(so,de))
#define getextension_realloc(filename) (getextension_d(filename,NULL))
#define getextension_change(filename)  (getextension_d(filename,1))
//Return only the path of a filename.
extern uchar *getpath_s(uchar *filename,int allocmode);
extern uchar *getpath_d(uchar *so,uchar *de);
#define getpath_new(filename)       (getpath_d(filename,NULL))
#define getpath_de(so,de)           (getpath_d(so,de))
#define getpath_realloc(filename)   (getpath_s(filename,NULL))
#define getpath_change(filename)    (getpath_s(filename,1))
//Return a string with the filename in the path changed to the filename you
//specify.
extern uchar *changefilename_d(uchar *so, uchar *de, uchar *filename);
extern uchar *changefilename_s(uchar *path, int allocmode, uchar *filename);
#define changefilename_new(path,filename)       (changefilename_d(path,NULL,filename))
#define changefilename_de(so,de,filename)       (changefilename_d(so,de,filename))
#define changefilename_realloc(path,filename)   (changefilename_s(path,NULL,filename))
#define changefilename_change(path,filename)    (changefilename_s(path,1,filename))
//Add a filename to the end of another.
extern uchar *addfilename_d(uchar *so,uchar *de,uchar *filename);
extern uchar *addfilename_s(uchar *path,int allocmode,uchar *filename);
#define addfilename_new(path,filename)          (addfilename_d(path,NULL,filename))
#define addfilename_de(so,de,filename)          (addfilename_d(so,de,filename))
#define addfilename_change(path,filename)       (addfilename_s(path,1,filename))
#define addfilename_realloc(path,filename)      (addfilename_s(path,NULL,filename))
//Add the extension to the filename.
extern uchar *addextension_d(uchar *so,uchar *de,uchar *extension);
extern uchar *addextension_s(uchar *filename,int allocmode,uchar *extension);
#define addextension_new(filename,extension)       (addextension_d(filename,NULL,extension))
#define addextension_de(so,de,extension)           (addextension_d(so,de,extension))
#define addextension_change(filename,extension)    (addextension_s(filename,1,extension))
#define addextension_realloc(filename,extension)   (addextension_s(filename,NULL,extension))
//Remove the extension from a filename.
extern uchar *removeextension_s(uchar *filename,int allocmode);
extern uchar *removeextension_d(uchar *so,uchar *de);
#define removeextension_new(filename,extension)       (removeextension_d(filename,NULL))
#define removeextension_de(so,de,extension)           (removeextension_d(so,de))
#define removeextension_change(filename,extension)    (removeextension_s(filename,1))
#define removeextension_realloc(filename,extension)   (removeextension_s(filename,NULL))
//Change the extension for a filename.
extern uchar *changeextension_d(uchar *so,uchar *de,uchar *extension);
extern uchar *changeextension_s(uchar *filename,int allocmode,uchar *extension);
#define changeextension_new(filename,extension)       (changeextension_d(filename,NULL,extension))
#define changeextension_de(so,de,extension)           (changeextension_d(so,de,extension))
#define changeextension_change(filename,extension)    (changeextension_s(filename,1,extension))
#define changeextension_realloc(filename,extension)   (changeextension_s(filename,NULL,extension))


//Expands the file name so that access() with the filename returns zero.
extern uchar *findfile_new(uchar *filenameandpaths, uchar *extension, ...);
//Adds all files in all subdirectories that matches the name to the
//stringlist.
int search_subdirs(uchar *name, TSTRLIST *sl);
//Adds all files in the directory that match the name to the stringlist.
int search_dir(uchar *name, TSTRLIST *sl);

//Return current directory, always with a backslash at the end of it.
extern uchar *getcd_d(uchar *buf);
#define getcd_new()     (getcd_d(NULL))
#define getcd_dest(buf) (getcd_d(buf))

/* Return the NAME property for a dat file that corresponds to filename.
	(Converts to uppercase and changes '.' to '_'.)
*/
extern uchar *filename2datname_d(uchar *so,uchar *de);
extern uchar *filename2datname_change(uchar* filename);
#define filename2datname_new(filename) (filename2datname_d(filename,NULL))
#define filename2datname_de(so,de)     (filename2datname_d(so,de))

/* Return the filename changed so that it contains a digit at the end. The
	new filename is always one that doesn't exist.
*/
extern uchar *anothername_d(uchar *so, uchar *de,
 int (*_check_exists)(uchar *filename));
extern uchar *anothername_s(uchar *filename, int allocmode,
 int (*_check_exists)(uchar *filename));
extern uchar *maybe_anothername_d(uchar *so, uchar *de,
 int (*_check_exists)(uchar *filename));
extern uchar *maybe_anothername_s(uchar *filename, int allocmode,
 int (*_check_exists)(uchar *filename));
#define anotherfilename_d(so,de)                      (anothername_d(so, de, any_exists))
#define anotherfilename_s(filename,allocmode)         (anothername_s(filename, allocmode, any_exists))
#define maybe_anotherfilename_d(so,de)                (maybe_anothername_d(so, de, any_exists))
#define maybe_anotherfilename_s(filename,allocmode)   (maybe_anothername_s(filename, allocmode, any_exists))

#define anotherfilename_new(filename)           (anotherfilename_d(filename, NULL))
#define anotherfilename_de(so,de)               (anotherfilename_d(so, de))
#define anotherfilename_change(filename)        (anotherfilename_s(filename, 1))
#define anotherfilename_realloc(filename)       (anotherfilename_s(filename, NULL))
#define maybe_anotherfilename_new(filename)     (maybe_anotherfilename_d(filename, NULL))
#define maybe_anotherfilename_de(so,de)         (maybe_anotherfilename_d(so, de))
#define maybe_anotherfilename_change(filename)  (maybe_anotherfilename_s(filename, 1))
#define maybe_anotherfilename_realloc(filename) (maybe_anotherfilename_s(filename, NULL))


//Returns TRUE if the drive exists. The format of the `drive' parameter is
//normal ascii, i.e. 'c' for c: etc.
extern int drive_exists(uchar drive);
//Returns TRUE if the path exists and really is a path and nothing else.
extern int path_exists(uchar *path);
extern int any_exists(uchar *path);

/* Creates the path if it doesn't exist. The path may include several
	non-existing directories, that all will be created. Returns the number of
	directories created (could be 0), or the negative value of
	[number of paths + 1] on error.
*/
extern int force_path(uchar *path);
extern int xforce_path(uchar *path);

#endif
