/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains string handling functions.

*/
#ifndef s_string_h
#define s_string_h

#include "s_defs.h"



/**********************************
****                           ****
**** Functions for stringlists ****
****                           ****
**********************************/
typedef struct{
	int num_strs;
	int num_malloced_strings;
	uchar **list;
}TSTRLIST;
extern int add_strlist_item(TSTRLIST *s, uchar *item);
extern void remove_strlist_item(TSTRLIST *s, int index);
extern void free_strlist_item(TSTRLIST *s, int index);
extern TSTRLIST *create_strlist(void);
extern void destroy_strlist(TSTRLIST *s);
extern void destroy_strlist_items(TSTRLIST *s);




/*********************************
****                          ****
**** Functions for substrings ****
****                          ****
**********************************
All my substring functions support all four of my mallocing variants.
They also do clipping, so if for example try to do something on a substr that,
according to the length you specified, should end outside the original string,
the function will stop it at the end anyway.
The substrs don't work in the way that they share memory at any time.
You should use the macros, not the external functions. This gives you a more
logical syntax and is not slower.*/

//Return part of a string.
/*not tested*/
extern uchar *getsubstr_s(uchar *text,int allocmode,ulong start,ulong length);
extern uchar *getsubstr_d(uchar *so,uchar *de,ulong start,ulong length);
#define getsubstr_new(so,start,length)       (getsubstr_d((so),NULL,(start),(length)))
#define getsubstr_de(so,de,start,length)     (getsubstr_d((so),(de),(start),(length)))
#define getsubstr_change(so,start,length)    (getsubstr_s((so),TRUE,(start),(length)))
#define getsubstr_realloc(so,start,length)   (getsubstr_s((so),FALSE,(start),(length)))
//Replace part of a string with another string.
/*not tested*/
extern uchar *replacesubstr_s(uchar *text,int allocmode,ulong start,ulong length,uchar *substr);
extern uchar *replacesubstr_d(uchar *so,uchar *de,ulong start,ulong length,uchar *substr);
#define replacesubstr_new(so,start,length,substr)        (replacesubstr_d((so),NULL,(start),(length),(substr)))
#define replacesubstr_de(so,de,start,length,substr)      (replacesubstr_d((so),(de),(start),(length),(substr)))
#define replacesubstr_change(so,start,length,substr)     (replacesubstr_s((so),TRUE,(start),(length),(substr)))
#define replacesubstr_realloc(so,start,length,substr)    (replacesubstr_s((so),FALSE,(start),(length),(substr)))
//Delete part of a string.
/*not tested*/
extern uchar *deletesubstr_s(uchar *text,int allocmode,ulong start,ulong length);
extern uchar *deletesubstr_d(uchar *so,uchar *de,ulong start,ulong length);
#define deletesubstr_new(so,start,length)       (deletesubstr_d((so),NULL,(start),(length)))
#define deletesubstr_de(so,de,start,length)     (deletesubstr_d((so),(de),(start),(length)))
#define deletesubstr_change(so,start,length)    (deletesubstr_s((so),TRUE,(start),(length)))
#define deletesubstr_realloc(so,start,length)   (deletesubstr_s((so),FALSE,(start),(length)))
//Insert a string into another.
/*not tested*/
extern uchar *insertsubstr_s(uchar *text,int allocmode,ulong position,uchar *substr);
extern uchar *insertsubstr_d(uchar *so,uchar *de,ulong position,uchar *substr);
#define insertsubstr_new(so,start,substr)       (insertsubstr_d((so),NULL,(start),(substr)))
#define insertsubstr_de(so,de,start,substr)     (insertsubstr_d((so),(de),(start),(substr)))
#define insertsubstr_change(so,start,substr)    (insertsubstr_s((so),TRUE,(start),(substr)))
#define insertsubstr_realloc(so,start,substr)   (insertsubstr_s((so),FALSE,(start),(substr)))



/********************************
****                         ****
**** Miscellaneous functions ****
****                         ****
********************************/
//Returns its parameter.
extern uchar *sc(uchar *text);

//Concatenates many strings.
extern uchar *mergestrs_realloc(uchar *text,...);
extern uchar *mergestrs_change(uchar *text,...);
extern uchar *mergestrs_de(uchar *de, uchar *text,...);
extern uchar *mergestrs_new(uchar *text,...);

//Fills a string with characters.
extern uchar *fillstr_d(uchar *de,uchar ascii,long length);
#define fillstr_new(ascii,length)   (fillstr_d(NULL,(ascii),(length)))
#define fillstr_de(de,ascii,length) (fillstr_d((de),(ascii),(length)))

/* strcpy exists, as well as memmove and memcpy, so it seems logical that
	strmove also should exist. The macro uses the source parameter twice, so
	it could be better to use the function in some cases.
*/
#define _strmove(dest,source) (memmove((dest),(source),strlen(source)))
extern uchar *strmove(uchar *dest,uchar *source);



#endif
