#include <stdio.h>
#include <string.h>
#include "stone.h"
#include "info.h"

int __help = 0;
int __force = 0;
int __stderr = 0;
int __verbose = 0;

FILE *outfile;

int main (int argc, char **argv)
{
  int c, count;
  
  outfile = stdout;
  count = 0;

  for (c = 1; c < argc; c ++)
    if (!strcasecmp ("--help", argv [c]) || !strcasecmp ("-help", argv [c]))
      __help = 1;
    else if (!strcasecmp ("--stderr", argv [c]) || !strcasecmp ("-stderr", argv [c]))
      outfile = stderr;
    else if (!strcasecmp ("--force", argv [c]) || !strcasecmp ("-force", argv [c]))
      __force = 1;
    else if (!strcasecmp ("--verbose", argv [c]) || !strcasecmp ("-verbose", argv [c]))
      __verbose = 1;
    else if (argv [c] [0] == '-')
    {
      out ("unknown argument '%s'\n", argv [c]);
      return 1;
    }
    else
      count ++;

  if (__help || count == 0)
  {
    out ("%s OPTION... FILE...\n", argv [0]);
    out ("  Print information on what Stonewheel made of your file.\n");
    out ("  --help     Print this help\n");
    out ("  --stderr   Print to standard error instead of standard out\n");
    out ("  --force    Force the useage of Stonewheel instead of any\n");
    out ("             special handlers\n");
    out ("  --verbose  Don't hold back on the useless information\n");
    out ("\n");
    return 1;
  }

  for (c = 1; c < argc; c ++)
    if (argv [c] [0] != '-')
    {
      out ("---------------------------------------------------------------------\n");
      if (__force)
      {
        if (!stone_info_stone (argv [c]))
        {
          out ("Error, exiting\n");
          return 1;
        }
      }
      else
      {
        if (!stone_info_omf (argv [c])
         && !stone_info_stone (argv [c]))
        {
          out ("Error, exiting\n");
          return 1;
        }
      }
    }

  out ("---------------------------------------------------------------------\n");
  return 0;
}

/* Print hexadecimal from file input to file output */
void print_hex_file_file (FILE *out, FILE *file, int length, int base, int textoff, int byteperline)
{
  int addrlength;
  int c, ch, d;

  addrlength = (length + base) < 10 ? 1
             : (length + base) < 100 ? 2
             : (length + base) < 1000 ? 3
             : (length + base) < 10000 ? 4
             : (length + base) < 100000 ? 5
             : (length + base) < 1000000 ? 6
             : (length + base) < 10000000 ? 7
             : (length + base) < 100000000 ? 8 : 9;

  for (c = 0; c < length; c ++)
  {
    if ((ch = fgetc (file)) == EOF)
      break;
    if (c % byteperline == 0)
      fprintf (out, "%*s%0*X  ", textoff, "", addrlength, c + base);
    fprintf (out, "%02X ", ch);
    if ((c + 1) % byteperline == 0)
    {
      fputs (" ", out);
      fseek (file, -byteperline, SEEK_CUR);
      for (d = 0; d < byteperline; d ++)
      {
        ch = fgetc (file);
        fputc (ch > 32 ? ch : ' ', out);
      }
      fputc ('\n', out);
    }
  }

  if (c % 16)
  {
    for (d = byteperline - 1; (c + 1) % byteperline; c ++, d --)
      fputs ("   ", out);
    fputs ("    ", out);
    fseek (file, -d, SEEK_CUR);
    for (; d > 0; d --)
    {
      ch = fgetc (file);
      fputc (ch > 32 ? ch : ' ', out);
    }
    fputc ('\n', out);
  }
}

int fgetw (FILE *file)
{
  return fgetc (file) | (fgetc (file) << 8);
}

